/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib.html;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.FlatteningPathIterator;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import org.jhotdraw.contrib.TextAreaFigure;
import org.jhotdraw.contrib.html.ContentProducer;
import org.jhotdraw.contrib.html.ContentProducerRegistry;
import org.jhotdraw.contrib.html.DisposableResourceHolder;
import org.jhotdraw.contrib.html.DisposableResourceManagerFactory;
import org.jhotdraw.contrib.html.GeometricFigure;
import org.jhotdraw.contrib.html.HTMLColorContentProducer;
import org.jhotdraw.contrib.html.HTMLContentProducer;
import org.jhotdraw.contrib.html.HTMLContentProducerContext;
import org.jhotdraw.contrib.html.TextHolderContentProducer;
import org.jhotdraw.figures.RectangleFigure;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureAttributeConstant;
import org.jhotdraw.framework.FigureChangeEvent;
import org.jhotdraw.framework.FigureChangeListener;
import org.jhotdraw.framework.HandleEnumeration;
import org.jhotdraw.util.Geom;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;

public class HTMLTextAreaFigure
extends TextAreaFigure
implements HTMLContentProducerContext,
FigureChangeListener {
    public static final char START_ENTITY_CHAR = '&';
    public static final char END_ENTITY_CHAR = ';';
    public static final char ESCAPE_CHAR = '\\';
    private transient DisposableResourceHolder fImageHolder;
    private transient JLabel fDisplayDelegate;
    private boolean fUseDirectDraw = false;
    private boolean fIsImageDirty = true;
    private boolean fRawHTML = false;
    private transient ContentProducer fIntrinsicContentProducer;
    private static ContentProducerRegistry fDefaultContentProducers = new ContentProducerRegistry();
    private transient ContentProducerRegistry fContentProducers = null;
    private Figure fFrameFigure = null;
    static /* synthetic */ Class class$org$jhotdraw$contrib$TextAreaFigure;
    static /* synthetic */ Class class$java$awt$Color;

    public HTMLTextAreaFigure() {
        this.initialize();
    }

    public Object clone() {
        Object object = super.clone();
        ((HTMLTextAreaFigure)object).initialize();
        return object;
    }

    public void basicDisplayBox(Point point, Point point2) {
        super.basicDisplayBox(point, point2);
        this.getFrameFigure().displayBox(this.displayBox());
    }

    public HandleEnumeration handles() {
        return this.getFrameFigure().handles();
    }

    public boolean containsPoint(int n, int n2) {
        return this.getFrameFigure().containsPoint(n, n2);
    }

    public void moveBy(int n, int n2) {
        super.moveBy(n, n2);
        this.getFrameFigure().moveBy(n, n2);
    }

    protected void initialize() {
        this.fImageHolder = DisposableResourceManagerFactory.createStandardHolder(null);
        this.setFrameFigure(new RectangleFigure());
        this.setIntrinsicContentProducer(new HTMLContentProducer());
        this.fContentProducers = new ContentProducerRegistry(fDefaultContentProducers);
        this.markSizeDirty();
        this.markImageDirty();
        this.markTextDirty();
        this.markFontDirty();
        this.setAttribute(FigureAttributeConstant.POPUP_MENU, (Object)this.createPopupMenu());
    }

    protected void markSizeDirty() {
        this.markImageDirty();
        super.markSizeDirty();
    }

    protected void markTextDirty() {
        this.markImageDirty();
        super.markTextDirty();
    }

    protected void markFontDirty() {
        this.markImageDirty();
        super.markFontDirty();
    }

    public void draw(Graphics graphics) {
        Color color = this.getFillColor();
        graphics.setColor(color);
        this.drawBackground(graphics);
        this.drawText(graphics, this.displayBox());
        Color color2 = this.getFrameColor();
        graphics.setColor(color2);
        this.drawFrame(graphics);
    }

    public void drawFrame(Graphics graphics) {
        ((Graphics2D)graphics).draw(this.getClippingShape());
    }

    public void drawBackground(Graphics graphics) {
        ((Graphics2D)graphics).fill(this.getClippingShape());
    }

    protected float drawText(Graphics graphics, Rectangle rectangle) {
        Rectangle rectangle2;
        Graphics2D graphics2D = null;
        Shape shape = null;
        if (graphics != null) {
            graphics2D = (Graphics2D)graphics;
            shape = graphics2D.getClip();
        }
        if ((rectangle2 = this.makeDrawingBox(rectangle)).isEmpty()) {
            return rectangle2.height;
        }
        if (graphics != null) {
            graphics2D.clip(this.getClippingShape());
        }
        if (this.usesDirectDraw()) {
            this.drawTextDirect(graphics2D, rectangle2);
        } else {
            this.fImageHolder.lock();
            if (this.isImageDirty()) {
                this.generateImage(rectangle2);
                this.setSizeDirty(false);
            }
            if (graphics2D != null) {
                graphics2D.drawImage((Image)this.getImage(), rectangle2.x, rectangle2.y, null);
            }
            this.fImageHolder.unlock();
        }
        if (graphics != null) {
            graphics2D.setClip(shape);
        }
        this.drawFrame(graphics);
        return rectangle.height;
    }

    protected void generateImage(Rectangle rectangle) {
        this.createImage(rectangle.width, rectangle.height);
        Graphics2D graphics2D = (Graphics2D)this.getImage().getGraphics();
        Rectangle rectangle2 = new Rectangle(rectangle);
        rectangle2.setLocation(0, 0);
        this.renderText(graphics2D, rectangle2);
        graphics2D.dispose();
    }

    protected void drawTextDirect(Graphics2D graphics2D, Rectangle rectangle) {
        Shape shape = null;
        Color color = null;
        RenderingHints renderingHints = null;
        if (graphics2D != null) {
            renderingHints = graphics2D.getRenderingHints();
            shape = graphics2D.getClip();
            color = graphics2D.getColor();
            graphics2D.clip(rectangle);
        }
        if (graphics2D != null) {
            graphics2D.setClip(shape);
            graphics2D.setColor(color);
            graphics2D.setRenderingHints(renderingHints);
        }
    }

    protected float renderText(Graphics2D graphics2D, Rectangle rectangle) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setBackground(this.getFillColor());
        graphics2D.setColor(this.getFillColor());
        graphics2D.clearRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        String string = this.isRawHTML() ? this.getText() : this.getHTMLText(this.getText(), this.getFont(), (String)this.getContentProducer(class$java$awt$Color == null ? (class$java$awt$Color = HTMLTextAreaFigure.class$("java.awt.Color")) : class$java$awt$Color).getContent(this, "TextColor", this.getTextColor()), (String)this.getContentProducer(class$java$awt$Color == null ? (class$java$awt$Color = HTMLTextAreaFigure.class$("java.awt.Color")) : class$java$awt$Color).getContent(this, "FillColor", this.getFillColor()), rectangle);
        string = this.substituteEntityKeywords(string);
        JLabel jLabel = this.getDisplayDelegate();
        jLabel.setText(string);
        jLabel.setBackground(this.getFillColor());
        jLabel.setLocation(0, 0);
        jLabel.setSize(rectangle.width, rectangle.height);
        jLabel.setHorizontalAlignment((Integer)this.getAttribute(FigureAttributeConstant.XALIGNMENT));
        jLabel.setVerticalAlignment((Integer)this.getAttribute(FigureAttributeConstant.YALIGNMENT));
        SwingUtilities.paintComponent(graphics2D, jLabel, this.getContainerPanel(jLabel, rectangle), rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        return rectangle.height;
    }

    protected Rectangle makeDrawingBox(Rectangle rectangle) {
        float f = ((Float)this.getAttribute(FigureAttributeConstant.LEFT_MARGIN)).floatValue();
        float f2 = ((Float)this.getAttribute(FigureAttributeConstant.RIGHT_MARGIN)).floatValue();
        float f3 = ((Float)this.getAttribute(FigureAttributeConstant.TOP_MARGIN)).floatValue();
        float f4 = ((Float)this.getAttribute(FigureAttributeConstant.BOTTOM_MARGIN)).floatValue();
        Rectangle rectangle2 = new Rectangle(rectangle);
        rectangle2.grow(-1, -1);
        rectangle2.x = (int)((float)rectangle2.x + f);
        rectangle2.width = (int)((float)rectangle2.width - (f + f2));
        rectangle2.y = (int)((float)rectangle2.y + f3);
        rectangle2.height = (int)((float)rectangle2.height - (f3 + f4));
        return rectangle2;
    }

    protected JLabel getDisplayDelegate() {
        if (this.fDisplayDelegate == null) {
            this.fDisplayDelegate = new JLabel();
            this.fDisplayDelegate.setBorder(null);
        }
        return this.fDisplayDelegate;
    }

    protected void createImage(int n, int n2) {
        this.fImageHolder.lock();
        if (!this.fImageHolder.isAvailable() || ((BufferedImage)this.fImageHolder.getResource()).getWidth() != n || ((BufferedImage)this.fImageHolder.getResource()).getHeight() != n2) {
            this.fImageHolder.setResource(new BufferedImage(n, n2, 1));
        }
    }

    protected JPanel getContainerPanel(Component component, Rectangle rectangle) {
        JPanel jPanel = new JPanel();
        return jPanel;
    }

    protected String getHTMLText(String string, Font font, String string2, String string3, Rectangle rectangle) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>");
        stringBuffer.append("<table border='0' width='" + rectangle.width + "' height='" + rectangle.height + "' cellpadding='0' cellspacing='0'" + "bgcolor='&FillColor;'>");
        stringBuffer.append("<tr><td width='100%'>");
        stringBuffer.append("<font face='&FontName;' color='&TextColor;' size='&FontSize;'>");
        if ((Integer)this.getAttribute(FigureAttributeConstant.XALIGNMENT) == 0) {
            stringBuffer.append("<center>");
        }
        if (font.isItalic()) {
            stringBuffer.append("<i>");
        }
        if (font.isBold()) {
            stringBuffer.append("<b>");
        }
        stringBuffer.append(string);
        if (font.isBold()) {
            stringBuffer.append("</b>");
        }
        if (font.isItalic()) {
            stringBuffer.append("</i>");
        }
        if ((Integer)this.getAttribute(FigureAttributeConstant.XALIGNMENT) == 0) {
            stringBuffer.append("</center>");
        }
        stringBuffer.append("</font>");
        stringBuffer.append("</td></tr></table>");
        stringBuffer.append("</html>");
        return stringBuffer.toString();
    }

    protected String substituteEntityKeywords(String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = n = 0;
        try {
            while ((n = string.indexOf(38, n)) != -1) {
                if (n != 0 && string.charAt(n - 1) == '\\') {
                    ++n;
                    continue;
                }
                int n3 = n + 1;
                if ((n3 = string.indexOf(59, n3)) != -1 && n3 != 0 && string.charAt(n3 - 1) == '\\') {
                    throw new InvalidAttributeMarker();
                }
                String string2 = string.substring(n + 1, n3);
                String string3 = this.getEntityHTMLRepresentation(string2);
                if (string3 != null) {
                    stringBuffer.append(string.substring(n2, n));
                    stringBuffer.append(this.substituteEntityKeywords(string3));
                    n2 = n = n3 + 1;
                    continue;
                }
                ++n;
            }
        }
        catch (InvalidAttributeMarker invalidAttributeMarker) {
            // empty catch block
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    protected String getEntityHTMLRepresentation(String string) {
        Object object = this.getIntrinsicContentProducer().getContent(this, string, null);
        if (object == null) {
            return null;
        }
        while (object != null && !(object instanceof String)) {
            if (object instanceof ContentProducer) {
                object = ((ContentProducer)object).getContent(this, string, object);
                continue;
            }
            ContentProducer contentProducer = this.getContentProducer(object.getClass());
            if (contentProducer != null) {
                object = contentProducer.getContent(this, string, object);
                continue;
            }
            object = object.toString();
        }
        return (String)object;
    }

    protected BufferedImage getImage() {
        if (this.fImageHolder.isAvailable()) {
            return (BufferedImage)this.fImageHolder.getResource();
        }
        return null;
    }

    protected void setImage(BufferedImage bufferedImage) {
        this.fImageHolder.setResource(bufferedImage);
    }

    protected JPopupMenu createPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.addPopupMenuItems(jPopupMenu);
        jPopupMenu.setLightWeightPopupEnabled(true);
        return jPopupMenu;
    }

    protected void addPopupMenuItems(JPopupMenu jPopupMenu) {
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(new AbstractAction("Direct drawing"){

            public void actionPerformed(ActionEvent actionEvent) {
                HTMLTextAreaFigure.this.setUseDirectDraw(true);
            }
        });
        buttonGroup.add(jRadioButtonMenuItem);
        if (this.usesDirectDraw()) {
            buttonGroup.setSelected(jRadioButtonMenuItem.getModel(), true);
        }
        jPopupMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem(new AbstractAction("Buffered drawing"){

            public void actionPerformed(ActionEvent actionEvent) {
                HTMLTextAreaFigure.this.setUseDirectDraw(false);
            }
        });
        buttonGroup.add(jRadioButtonMenuItem);
        if (this.usesBufferedDraw()) {
            buttonGroup.setSelected(jRadioButtonMenuItem.getModel(), true);
        }
        jPopupMenu.add(jRadioButtonMenuItem);
        jPopupMenu.addSeparator();
        buttonGroup = new ButtonGroup();
        jRadioButtonMenuItem = new JRadioButtonMenuItem(new AbstractAction("Normal HTML"){

            public void actionPerformed(ActionEvent actionEvent) {
                HTMLTextAreaFigure.this.setRawHTML(false);
            }
        });
        buttonGroup.add(jRadioButtonMenuItem);
        buttonGroup.setSelected(jRadioButtonMenuItem.getModel(), true);
        jPopupMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem(new AbstractAction("Raw HTML"){

            public void actionPerformed(ActionEvent actionEvent) {
                HTMLTextAreaFigure.this.setRawHTML(true);
            }
        });
        buttonGroup.add(jRadioButtonMenuItem);
        jPopupMenu.add(jRadioButtonMenuItem);
    }

    public boolean usesDirectDraw() {
        return this.fUseDirectDraw;
    }

    public void setUseDirectDraw(boolean bl) {
        this.fUseDirectDraw = bl;
        this.setAttribute(FigureAttributeConstant.POPUP_MENU, (Object)this.createPopupMenu());
        this.markSizeDirty();
    }

    public void setUseBufferedDraw(boolean bl) {
        this.setUseDirectDraw(!bl);
    }

    public boolean usesBufferedDraw() {
        return !this.usesDirectDraw();
    }

    protected void markImageDirty() {
        this.fImageHolder.dispose();
    }

    protected boolean isImageDirty() {
        return !this.fImageHolder.isAvailable();
    }

    public void read(StorableInput storableInput) throws IOException {
        super.read(storableInput);
        this.setFrameFigure((Figure)storableInput.readStorable());
        this.setUseDirectDraw(storableInput.readBoolean());
        this.setRawHTML(storableInput.readBoolean());
    }

    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        storableOutput.writeStorable(this.getFrameFigure());
        storableOutput.writeBoolean(this.usesDirectDraw());
        storableOutput.writeBoolean(this.isRawHTML());
    }

    public void setAttribute(FigureAttributeConstant figureAttributeConstant, Object object) {
        super.setAttribute(figureAttributeConstant, object);
        this.markImageDirty();
    }

    public boolean isRawHTML() {
        return this.fRawHTML;
    }

    public void setRawHTML(boolean bl) {
        this.fRawHTML = bl;
        this.setAttribute(FigureAttributeConstant.POPUP_MENU, (Object)this.createPopupMenu());
    }

    protected ContentProducer getIntrinsicContentProducer() {
        return this.fIntrinsicContentProducer;
    }

    public void setIntrinsicContentProducer(ContentProducer contentProducer) {
        this.fIntrinsicContentProducer = contentProducer;
    }

    public ContentProducer registerContentProducer(Class clazz, ContentProducer contentProducer) {
        return this.fContentProducers.registerContentProducer(clazz, contentProducer);
    }

    public void unregisterContentProducer(Class clazz, ContentProducer contentProducer) {
        this.fContentProducers.unregisterContentProducer(clazz, contentProducer);
    }

    protected ContentProducer getContentProducer(Class clazz) {
        return this.fContentProducers.getContentProducer(clazz);
    }

    public Polygon getPolygon() {
        Polygon polygon = new Polygon();
        AffineTransform affineTransform = AffineTransform.getScaleInstance(1.0, 1.0);
        FlatteningPathIterator flatteningPathIterator = new FlatteningPathIterator(this.getClippingShape().getPathIterator(affineTransform), 1.0);
        double[] dArray = new double[6];
        while (!flatteningPathIterator.isDone()) {
            flatteningPathIterator.currentSegment(dArray);
            polygon.addPoint((int)dArray[0], (int)dArray[1]);
            flatteningPathIterator.next();
        }
        return polygon;
    }

    protected Figure getFrameFigure() {
        return this.fFrameFigure;
    }

    public void setFrameFigure(Figure figure) {
        if (this.fFrameFigure != null) {
            this.fFrameFigure.removeFigureChangeListener(this);
        }
        this.fFrameFigure = figure;
        this.fFrameFigure.addFigureChangeListener(this);
    }

    protected Shape getClippingShape() {
        Figure figure = this.getFrameFigure();
        if (figure instanceof GeometricFigure) {
            return ((GeometricFigure)figure).getShape();
        }
        return figure.displayBox();
    }

    public void figureInvalidated(FigureChangeEvent figureChangeEvent) {
    }

    public void figureChanged(FigureChangeEvent figureChangeEvent) {
        this.willChange();
        super.basicDisplayBox(figureChangeEvent.getFigure().displayBox().getLocation(), Geom.corner(figureChangeEvent.getFigure().displayBox()));
        this.changed();
    }

    public void figureRemoved(FigureChangeEvent figureChangeEvent) {
    }

    public void figureRequestRemove(FigureChangeEvent figureChangeEvent) {
    }

    public void figureRequestUpdate(FigureChangeEvent figureChangeEvent) {
    }

    public Figure getRepresentingFigure() {
        return this;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        fDefaultContentProducers.registerContentProducer(class$org$jhotdraw$contrib$TextAreaFigure == null ? (class$org$jhotdraw$contrib$TextAreaFigure = HTMLTextAreaFigure.class$("org.jhotdraw.contrib.TextAreaFigure")) : class$org$jhotdraw$contrib$TextAreaFigure, new TextHolderContentProducer());
        fDefaultContentProducers.registerContentProducer(class$java$awt$Color == null ? (class$java$awt$Color = HTMLTextAreaFigure.class$("java.awt.Color")) : class$java$awt$Color, new HTMLColorContentProducer());
        HTMLTextAreaFigure.initDefaultAttribute("XAlignment", new Integer(2));
        HTMLTextAreaFigure.initDefaultAttribute("YAlignment", new Integer(1));
        HTMLTextAreaFigure.initDefaultAttribute("LeftMargin", new Float(5.0f));
        HTMLTextAreaFigure.initDefaultAttribute("RightMargin", new Float(5.0f));
        HTMLTextAreaFigure.initDefaultAttribute("TopMargin", new Float(5.0f));
        HTMLTextAreaFigure.initDefaultAttribute("BottomMargin", new Float(5.0f));
        HTMLTextAreaFigure.initDefaultAttribute("TabSize", new Float(8.0f));
    }

    private class InvalidAttributeMarker
    extends Exception {
        private InvalidAttributeMarker() {
        }
    }
}

