/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.matrix;

import org.la4j.decomposition.MatrixDecompositor;
import org.la4j.factory.Factory;
import org.la4j.inversion.MatrixInvertor;
import org.la4j.matrix.Matrices;
import org.la4j.matrix.Matrix;
import org.la4j.matrix.functor.AdvancedMatrixPredicate;
import org.la4j.matrix.functor.MatrixAccumulator;
import org.la4j.matrix.functor.MatrixFunction;
import org.la4j.matrix.functor.MatrixPredicate;
import org.la4j.matrix.functor.MatrixProcedure;
import org.la4j.vector.Vector;

public abstract class AbstractMatrix
implements Matrix {
    protected int rows;
    protected int columns;
    protected Factory factory;

    protected AbstractMatrix(Factory factory) {
        this(factory, 0, 0);
    }

    protected AbstractMatrix(Factory factory, int rows, int columns) {
        this.ensureDimensionsAreNotNegative(rows, columns);
        this.factory = factory;
        this.rows = rows;
        this.columns = columns;
    }

    @Override
    public void assign(double value) {
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                this.set(i, j, value);
            }
        }
    }

    @Override
    public int rows() {
        return this.rows;
    }

    @Override
    public int columns() {
        return this.columns;
    }

    @Override
    public Vector getRow(int i) {
        return this.getRow(i, this.factory);
    }

    @Override
    public Vector getRow(int i, Factory factory) {
        this.ensureFactoryIsNotNull(factory);
        Vector result = factory.createVector(this.columns);
        for (int j = 0; j < this.columns; ++j) {
            result.set(j, this.get(i, j));
        }
        return result;
    }

    @Override
    public Vector getColumn(int j) {
        return this.getColumn(j, this.factory);
    }

    @Override
    public Vector getColumn(int j, Factory factory) {
        this.ensureFactoryIsNotNull(factory);
        Vector result = factory.createVector(this.rows);
        for (int i = 0; i < this.rows; ++i) {
            result.set(i, this.get(i, j));
        }
        return result;
    }

    @Override
    public void setRow(int i, Vector row) {
        if (row == null) {
            throw new IllegalArgumentException("Row can't be null.");
        }
        if (this.columns != row.length()) {
            throw new IllegalArgumentException("Wrong row length: " + row.length());
        }
        for (int j = 0; j < row.length(); ++j) {
            this.set(i, j, row.get(j));
        }
    }

    @Override
    public void setColumn(int j, Vector column) {
        if (column == null) {
            throw new IllegalArgumentException("Column can't be null.");
        }
        if (this.rows != column.length()) {
            throw new IllegalArgumentException("Wrong column length: " + column.length());
        }
        for (int i = 0; i < column.length(); ++i) {
            this.set(i, j, column.get(i));
        }
    }

    @Override
    public void swapRows(int i, int j) {
        if (i != j) {
            Vector ii = this.getRow(i);
            Vector jj = this.getRow(j);
            this.setRow(i, jj);
            this.setRow(j, ii);
        }
    }

    @Override
    public void swapColumns(int i, int j) {
        if (i != j) {
            Vector ii = this.getColumn(i);
            Vector jj = this.getColumn(j);
            this.setColumn(i, jj);
            this.setColumn(j, ii);
        }
    }

    @Override
    public Matrix transpose() {
        return this.transpose(this.factory);
    }

    @Override
    public Matrix transpose(Factory factory) {
        this.ensureFactoryIsNotNull(factory);
        Matrix result = factory.createMatrix(this.columns, this.rows);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                result.set(j, i, this.get(i, j));
            }
        }
        return result;
    }

    @Override
    public double determinant() {
        if (this.rows != this.columns) {
            throw new IllegalStateException("Can't compute determinant for non-square matrix.");
        }
        if (this.rows == 0) {
            return 0.0;
        }
        if (this.rows == 1) {
            return this.get(0, 0);
        }
        if (this.rows == 2) {
            return this.get(0, 0) * this.get(1, 1) - this.get(0, 1) * this.get(1, 0);
        }
        if (this.rows == 3) {
            return this.get(0, 0) * this.get(1, 1) * this.get(2, 2) + this.get(0, 1) * this.get(1, 2) * this.get(2, 0) + this.get(0, 2) * this.get(1, 0) * this.get(2, 1) - this.get(0, 2) * this.get(1, 1) * this.get(2, 0) - this.get(0, 1) * this.get(1, 0) * this.get(2, 2) - this.get(0, 0) * this.get(1, 2) * this.get(2, 1);
        }
        return this.triangularize().product();
    }

    @Override
    public int rank() {
        int result;
        if (this.columns == 0 || this.rows == 0) {
            return 0;
        }
        Matrix copy = this.copy();
        int min = this.columns > this.rows ? this.rows : this.columns;
        for (int k = 0; k < min; ++k) {
            int j;
            if (Math.abs(copy.get(k, k)) <= Matrices.EPS) {
                int x = 0;
                int y = 0;
                boolean nz = false;
                for (int i = k; i < this.rows && !nz; ++i) {
                    for (int j2 = k; j2 < this.columns && !nz; ++j2) {
                        if (!(Math.abs(copy.get(i, j2)) > Matrices.EPS)) continue;
                        y = i;
                        x = j2;
                        nz = true;
                    }
                }
                if (!nz) break;
                if (k != y) {
                    copy.swapRows(k, y);
                }
                if (k != x) {
                    copy.swapColumns(k, x);
                }
            }
            for (j = k; j < this.columns; ++j) {
                copy.update(k, j, Matrices.asDivFunction(copy.get(k, k)));
            }
            for (int i = k + 1; i < this.rows; ++i) {
                for (int j3 = k; j3 < this.columns; ++j3) {
                    copy.update(i, j3, Matrices.asMinusFunction(copy.get(k, j3) * copy.get(i, k)));
                }
            }
            for (j = k + 1; j < this.columns; ++j) {
                for (int i = k; i < this.rows; ++i) {
                    copy.update(i, j, Matrices.asMinusFunction(copy.get(i, k) * copy.get(k, j)));
                }
            }
        }
        for (result = 0; result < min && Math.abs(copy.get(result, result)) > Matrices.EPS; ++result) {
        }
        return result;
    }

    @Override
    public Matrix multiply(double value) {
        return this.multiply(value, this.factory);
    }

    @Override
    public Matrix multiply(double value, Factory factory) {
        this.ensureFactoryIsNotNull(factory);
        Matrix result = this.blank(factory);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                result.set(i, j, this.get(i, j) * value);
            }
        }
        return result;
    }

    @Override
    public Vector multiply(Vector vector) {
        return this.multiply(vector, this.factory);
    }

    @Override
    public Vector multiply(Vector vector, Factory factory) {
        this.ensureFactoryIsNotNull(factory);
        if (vector == null) {
            throw new IllegalArgumentException("Vector can't be null.");
        }
        if (this.columns != vector.length()) {
            throw new IllegalArgumentException("Wrong vector length: " + vector.length());
        }
        Vector result = factory.createVector(this.rows);
        for (int i = 0; i < this.rows; ++i) {
            double summand = 0.0;
            for (int j = 0; j < this.columns; ++j) {
                summand += this.get(i, j) * vector.get(j);
            }
            result.set(i, summand);
        }
        return result;
    }

    @Override
    public Matrix multiply(Matrix matrix) {
        return this.multiply(matrix, this.factory);
    }

    @Override
    public Matrix multiply(Matrix matrix, Factory factory) {
        this.ensureFactoryIsNotNull(factory);
        if (matrix == null) {
            throw new IllegalArgumentException("Matrix can't be null.");
        }
        if (this.columns != matrix.rows()) {
            throw new IllegalArgumentException("Wrong matrix dimensions: " + matrix.rows() + "x" + matrix.columns());
        }
        Matrix result = factory.createMatrix(this.rows, matrix.columns());
        for (int j = 0; j < matrix.columns(); ++j) {
            Vector column = matrix.getColumn(j);
            for (int i = 0; i < this.rows; ++i) {
                double summand = 0.0;
                for (int k = 0; k < this.columns; ++k) {
                    summand += this.get(i, k) * column.get(k);
                }
                result.set(i, j, summand);
            }
        }
        return result;
    }

    @Override
    public Matrix subtract(double value) {
        return this.subtract(value, this.factory);
    }

    @Override
    public Matrix subtract(double value, Factory factory) {
        return this.add(-value, factory);
    }

    @Override
    public Matrix subtract(Matrix matrix) {
        return this.subtract(matrix, this.factory);
    }

    @Override
    public Matrix subtract(Matrix matrix, Factory factory) {
        return this.add(matrix.multiply(-1.0), factory);
    }

    @Override
    public Matrix add(double value) {
        return this.add(value, this.factory);
    }

    @Override
    public Matrix add(double value, Factory factory) {
        this.ensureFactoryIsNotNull(factory);
        Matrix result = this.blank(factory);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                result.set(i, j, this.get(i, j) + value);
            }
        }
        return result;
    }

    @Override
    public Matrix add(Matrix matrix) {
        return this.add(matrix, this.factory);
    }

    @Override
    public Matrix add(Matrix matrix, Factory factory) {
        this.ensureFactoryIsNotNull(factory);
        if (matrix == null) {
            throw new IllegalArgumentException("Matrix can't be null.");
        }
        if (this.rows != matrix.rows() || this.columns != matrix.columns()) {
            throw new IllegalArgumentException("Wrong matrix dimensions: " + matrix.rows() + "x" + matrix.columns());
        }
        Matrix result = this.blank(factory);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                result.set(i, j, this.get(i, j) + matrix.get(i, j));
            }
        }
        return result;
    }

    @Override
    public Matrix divide(double value) {
        return this.divide(value, this.factory);
    }

    @Override
    public Matrix divide(double value, Factory factory) {
        return this.multiply(1.0 / value, factory);
    }

    @Override
    public Matrix kronecker(Matrix matrix) {
        return this.kronecker(matrix, this.factory);
    }

    @Override
    public Matrix kronecker(Matrix matrix, Factory factory) {
        this.ensureFactoryIsNotNull(factory);
        if (matrix == null) {
            throw new IllegalArgumentException("Matrix can't be null.");
        }
        int n = this.rows() * matrix.rows();
        int m = this.columns() * matrix.columns();
        Matrix result = factory.createMatrix(n, m);
        int p = matrix.rows();
        int q = matrix.columns();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                result.set(i, j, this.get(i / p, j / q) * matrix.get(i % p, j % q));
            }
        }
        return result;
    }

    @Override
    public double trace() {
        double result = 0.0;
        for (int i = 0; i < this.rows; ++i) {
            result += this.get(i, i);
        }
        return result;
    }

    @Override
    public double product() {
        double result = 1.0;
        for (int i = 0; i < this.rows; ++i) {
            result *= this.get(i, i);
        }
        return result;
    }

    @Override
    public Matrix triangularize() {
        return this.triangularize(this.factory);
    }

    @Override
    public Matrix triangularize(Factory factory) {
        this.ensureFactoryIsNotNull(factory);
        if (this.is(Matrices.UPPER_TRIANGULAR_MATRIX) || this.is(Matrices.LOWER_TRIANGULAR_MARTIX)) {
            return this.copy(factory);
        }
        Matrix result = factory.createMatrix(this.rows, this.columns);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = i + 1; j < this.rows; ++j) {
                double c = this.get(j, i) / this.get(i, i);
                for (int k = i; k < this.columns; ++k) {
                    if (k == i) {
                        result.set(j, k, 0.0);
                        continue;
                    }
                    result.set(j, k, this.get(j, k) - this.get(i, k) * c);
                }
            }
        }
        return result;
    }

    @Override
    public Matrix[] decompose(MatrixDecompositor decompositor) {
        return this.decompose(decompositor, this.factory);
    }

    @Override
    public Matrix[] decompose(MatrixDecompositor decompositor, Factory factory) {
        return decompositor.decompose(this, factory);
    }

    @Override
    public Matrix inverse(MatrixInvertor invertor) {
        return this.inverse(invertor, this.factory);
    }

    @Override
    public Matrix inverse(MatrixInvertor invertor, Factory factory) {
        return invertor.inverse(this, factory);
    }

    @Override
    public Matrix blank() {
        return this.blank(this.factory);
    }

    @Override
    public Matrix blank(Factory factory) {
        this.ensureFactoryIsNotNull(factory);
        return factory.createMatrix(this.rows, this.columns);
    }

    @Override
    public Matrix copy() {
        return this.copy(this.factory);
    }

    @Override
    public Matrix copy(Factory factory) {
        this.ensureFactoryIsNotNull(factory);
        return factory.createMatrix(this);
    }

    @Override
    public Matrix resize(int rows, int columns) {
        return this.resize(rows, columns, this.factory);
    }

    @Override
    public Matrix resizeRows(int rows) {
        return this.resize(rows, this.columns, this.factory);
    }

    @Override
    public Matrix resizeRows(int rows, Factory factory) {
        return this.resize(rows, this.columns, factory);
    }

    @Override
    public Matrix resizeColumns(int columns) {
        return this.resize(this.rows, columns, this.factory);
    }

    @Override
    public Matrix resizeColumns(int columns, Factory factory) {
        return this.resize(this.rows, columns, factory);
    }

    @Override
    public Matrix resize(int rows, int columns, Factory factory) {
        this.ensureFactoryIsNotNull(factory);
        Matrix result = factory.createMatrix(rows, columns);
        for (int i = 0; i < Math.min(rows, this.rows); ++i) {
            for (int j = 0; j < Math.min(columns, this.columns); ++j) {
                result.set(i, j, this.get(i, j));
            }
        }
        return result;
    }

    @Override
    public Matrix slice(int fromRow, int fromColumn, int untilRow, int untilColumn) {
        return this.slice(fromRow, fromColumn, untilRow, untilColumn, this.factory);
    }

    @Override
    public Matrix slice(int fromRow, int fromColumn, int untilRow, int untilColumn, Factory factory) {
        this.ensureFactoryIsNotNull(factory);
        Matrix result = factory.createMatrix(untilRow - fromRow, untilColumn - fromColumn);
        for (int i = fromRow; i < untilRow; ++i) {
            for (int j = fromColumn; j < untilColumn; ++j) {
                result.set(i - fromRow, j - fromColumn, this.get(i, j));
            }
        }
        return result;
    }

    @Override
    public Matrix sliceTopLeft(int untilRow, int untilColumn) {
        return this.slice(0, 0, untilRow, untilColumn, this.factory);
    }

    @Override
    public Matrix sliceTopLeft(int untilRow, int untilColumn, Factory factory) {
        return this.slice(0, 0, untilRow, untilColumn, factory);
    }

    @Override
    public Matrix sliceBottomRight(int fromRow, int fromColumn) {
        return this.slice(fromRow, fromColumn, this.rows, this.columns, this.factory);
    }

    @Override
    public Matrix sliceBottomRight(int fromRow, int fromColumn, Factory fac) {
        return this.slice(fromRow, fromColumn, this.rows, this.columns, this.factory);
    }

    @Override
    public Factory factory() {
        return this.factory;
    }

    @Override
    public void each(MatrixProcedure procedure) {
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                procedure.apply(i, j, this.get(i, j));
            }
        }
    }

    @Override
    public Matrix transform(MatrixFunction function) {
        return this.transform(function, this.factory);
    }

    @Override
    public Matrix transform(MatrixFunction function, Factory factory) {
        Matrix result = this.blank(factory);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                result.set(i, j, function.evaluate(i, j, this.get(i, j)));
            }
        }
        return result;
    }

    @Override
    public Matrix transform(int i, int j, MatrixFunction function) {
        return this.transform(i, j, function, this.factory);
    }

    @Override
    public Matrix transform(int i, int j, MatrixFunction function, Factory factory) {
        Matrix result = this.copy(factory);
        result.set(i, j, function.evaluate(i, j, result.get(i, j)));
        return result;
    }

    @Override
    public void update(MatrixFunction function) {
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                this.set(i, j, function.evaluate(i, j, this.get(i, j)));
            }
        }
    }

    @Override
    public void update(int i, int j, MatrixFunction function) {
        this.set(i, j, function.evaluate(i, j, this.get(i, j)));
    }

    @Override
    public double fold(MatrixAccumulator accumulator) {
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                accumulator.update(i, j, this.get(i, j));
            }
        }
        return accumulator.accumulate();
    }

    @Override
    public double foldRow(int i, MatrixAccumulator accumulator) {
        for (int j = 0; j < this.columns; ++j) {
            accumulator.update(i, j, this.get(i, j));
        }
        return accumulator.accumulate();
    }

    @Override
    public double foldColumn(int j, MatrixAccumulator accumulator) {
        for (int i = 0; i < this.rows; ++i) {
            accumulator.update(i, j, this.get(i, j));
        }
        return accumulator.accumulate();
    }

    @Override
    public boolean is(MatrixPredicate predicate) {
        boolean result = predicate instanceof AdvancedMatrixPredicate ? ((AdvancedMatrixPredicate)predicate).test(this.rows, this.columns) : this.rows > 0 && this.columns > 0;
        for (int i = 0; result && i < this.rows; ++i) {
            for (int j = 0; result && j < this.columns; ++j) {
                result = result && predicate.test(i, j, this.get(i, j));
            }
        }
        return result;
    }

    @Override
    public Matrix unsafe() {
        return this;
    }

    public int hashCode() {
        int result = 17;
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                long value = (long)this.get(i, j);
                result = 37 * result + (int)(value ^ value >>> 32);
            }
        }
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Matrix)) {
            return false;
        }
        Matrix matrix = (Matrix)object;
        if (this.rows != matrix.rows() || this.columns != matrix.columns()) {
            return false;
        }
        boolean result = true;
        for (int i = 0; result && i < this.rows; ++i) {
            for (int j = 0; result && j < this.columns; ++j) {
                double a = this.get(i, j);
                double b = matrix.get(i, j);
                double diff = Math.abs(a - b);
                result = result && a == b ? true : (diff < Matrices.EPS ? true : diff / Math.max(Math.abs(a), Math.abs(b)) < Matrices.EPS);
            }
        }
        return result;
    }

    public String toString() {
        int precision = 3;
        int[] formats = new int[this.columns];
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                double value = this.get(i, j);
                int size = String.valueOf((long)value).length() + 3 + (value < 0.0 && value > -1.0 ? 1 : 0) + 2;
                formats[j] = size > formats[j] ? size : formats[j];
            }
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                sb.append(String.format("%" + Integer.toString(formats[j]) + "." + 3 + "f", this.get(i, j)));
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    protected void ensureFactoryIsNotNull(Factory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Factory can't be null.");
        }
    }

    protected void ensureDimensionsAreNotNegative(int rows, int columns) {
        if (rows < 0 || columns < 0) {
            throw new IllegalArgumentException("Wrong matrix dimensions: " + rows + "x" + columns);
        }
    }
}

