/*
 * Decompiled with CFR 0.152.
 */
package bsearch.evaluation;

import bsearch.app.BehaviorSearchException;
import bsearch.app.SearchProtocol;
import bsearch.evaluation.FitnessFunction;
import bsearch.evaluation.ResultsArchive;
import bsearch.nlogolink.ModelRunResult;
import bsearch.representations.Chromosome;
import bsearch.representations.DummyChromosome;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.nlogo.api.MersenneTwisterFast;

public strictfp class DerivativeFitnessFunction
implements FitnessFunction {
    private final SearchProtocol protocol;
    private final String paramName;
    private final double deltaDistance;
    private final MersenneTwisterFast rng;
    private List<Chromosome> SPECIAL_MUTATE_pointsqueue = new LinkedList<Chromosome>();
    private List<Chromosome> SPECIAL_MUTATE_neighborsqueue = new LinkedList<Chromosome>();

    public DerivativeFitnessFunction(SearchProtocol protocol, MersenneTwisterFast rng) throws BehaviorSearchException {
        this.protocol = protocol;
        this.paramName = protocol.fitnessDerivativeParameter;
        this.deltaDistance = protocol.fitnessDerivativeDelta;
        this.rng = rng;
        if (this.deltaDistance == 0.0) {
            throw new BehaviorSearchException("When taking the 'derivative' of the fitness function with respect to parameter X, the delta value (change in X) cannot be 0!");
        }
    }

    private Chromosome getPointDeltaNearby(Chromosome point) throws BehaviorSearchException {
        if (this.paramName.equals("@MUTATE@")) {
            double mutRate = this.deltaDistance;
            int failedMutationCounter = 0;
            int MAX_MUTATION_ATTEMPTS = 1000000;
            Chromosome neighbor = point.mutate(mutRate, this.rng);
            while (neighbor.equals(point) && failedMutationCounter < 1000000) {
                neighbor = point.mutate(mutRate, this.rng);
            }
            if (failedMutationCounter == 1000000) {
                throw new BehaviorSearchException("An extremely large number of mutation attempts all resulted in no mutation - perhaps your mutation-rate is too low?");
            }
            this.SPECIAL_MUTATE_pointsqueue.add(point);
            this.SPECIAL_MUTATE_neighborsqueue.add(neighbor);
            return neighbor;
        }
        LinkedHashMap<String, Object> newParamSettings = new LinkedHashMap<String, Object>(point.getParamSettings());
        Object curVal = newParamSettings.get(this.paramName);
        if (!(curVal instanceof Number)) {
            throw new BehaviorSearchException("Derivative-based fitness measurements currently only work with numerical parameters!");
        }
        double val = ((Number)curVal).doubleValue();
        double newVal = val - this.deltaDistance;
        newParamSettings.put(this.paramName, newVal);
        return new DummyChromosome(point.getSearchSpace(), newParamSettings);
    }

    @Override
    public HashMap<Chromosome, Integer> getRunsNeeded(Chromosome point, int repetitionsRequested, ResultsArchive archive) throws BehaviorSearchException {
        LinkedHashMap<Chromosome, Integer> map = new LinkedHashMap<Chromosome, Integer>(1);
        map.put(point, StrictMath.max(0, repetitionsRequested - archive.getResultsCount(point)));
        Chromosome deltaComparePoint = this.getPointDeltaNearby(point);
        map.put(deltaComparePoint, StrictMath.max(0, repetitionsRequested - archive.getResultsCount(deltaComparePoint)));
        return map;
    }

    @Override
    public int getMaximumRunsThatCouldBeNeeded(int repetitionsRequested) {
        return 2 * repetitionsRequested;
    }

    @Override
    public double evaluate(Chromosome point, ResultsArchive archive) throws BehaviorSearchException {
        Chromosome neighbor;
        List<ModelRunResult> resultsSoFar = archive.getResults(point);
        LinkedList<Double> condensedResults = new LinkedList<Double>();
        for (ModelRunResult result : resultsSoFar) {
            LinkedList<Double> singleRunHistory = result.getPrimaryTimeSeries();
            double dResult = this.protocol.fitnessCollecting.collectFrom(singleRunHistory);
            condensedResults.add(dResult);
        }
        double pointVal = this.protocol.fitnessCombineReplications.combine(condensedResults);
        if (this.paramName.equals("@MUTATE@")) {
            int index = this.SPECIAL_MUTATE_pointsqueue.indexOf(point);
            neighbor = this.SPECIAL_MUTATE_neighborsqueue.get(index);
            this.SPECIAL_MUTATE_pointsqueue.remove(index);
            this.SPECIAL_MUTATE_neighborsqueue.remove(index);
        } else {
            neighbor = this.getPointDeltaNearby(point);
        }
        resultsSoFar = archive.getResults(neighbor);
        condensedResults = new LinkedList();
        for (ModelRunResult result : resultsSoFar) {
            LinkedList<Double> singleRunHistory = result.getPrimaryTimeSeries();
            double dResult = this.protocol.fitnessCollecting.collectFrom(singleRunHistory);
            condensedResults.add(dResult);
        }
        double deltaComparePointVal = this.protocol.fitnessCombineReplications.combine(condensedResults);
        double denominator = this.deltaDistance;
        if (this.paramName.equals("@MUTATE@")) {
            denominator = 1.0;
        }
        if (this.protocol.fitnessDerivativeUseAbs) {
            return StrictMath.abs((pointVal - deltaComparePointVal) / denominator);
        }
        return (pointVal - deltaComparePointVal) / denominator;
    }

    @Override
    public double compare(double v1, double v2) {
        if (this.protocol.fitnessMinimized) {
            return v2 - v1;
        }
        return v1 - v2;
    }

    @Override
    public boolean strictlyBetterThan(double v1, double v2) {
        return this.compare(v1, v2) > 0.0;
    }

    @Override
    public double getWorstConceivableFitnessValue() {
        return this.protocol.fitnessMinimized ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
    }

    @Override
    public double getBestConceivableFitnessValue() {
        return this.protocol.fitnessMinimized ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean reachedStopGoalFitness(double fitness) {
        return false;
    }
}

