/*
 * Decompiled with CFR 0.152.
 */
package org.onemind.commons.java.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.PrintStream;
import java.util.logging.LogManager;
import org.onemind.commons.java.util.FileUtils;

public final class LogUtils {
    private LogUtils() {
    }

    public static void initLoggingFromClassPath() {
        String classPath = (String)System.getProperties().get("java.class.path");
        String[] paths = null;
        paths = classPath.indexOf(";") != -1 ? classPath.split(";") : classPath.split(":");
        for (int i = 0; i < paths.length; ++i) {
            String config;
            if (paths[i].endsWith(".jar") || !new File(config = FileUtils.concatFilePath(paths[i], "logging.properties")).exists()) continue;
            System.out.println("Use logging configuration " + config);
            try {
                LogManager.getLogManager().readConfiguration(new FileInputStream(config));
                continue;
            }
            catch (Exception e) {
                System.out.println("- init logging problem: " + e.getMessage());
            }
        }
    }

    public static String getTrace(Throwable e) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(buffer);
        e.printStackTrace(ps);
        ps.flush();
        return new String(buffer.toByteArray());
    }
}

