/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.experiment;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import weka.core.SerializedObject;
import weka.core.Utils;
import weka.experiment.Experiment;
import weka.experiment.RemoteExperiment;
import weka.experiment.RemoteExperimentEvent;
import weka.experiment.RemoteExperimentListener;
import weka.gui.LogPanel;
import weka.gui.experiment.Experimenter;
import weka.gui.experiment.ResultsPanel;

public class RunPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1691868018596872051L;
    protected static final String NOT_RUNNING = "Not running";
    protected JButton m_StartBut = new JButton("Start");
    protected JButton m_StopBut = new JButton("Stop");
    protected LogPanel m_Log = new LogPanel();
    protected Experiment m_Exp;
    protected Thread m_RunThread = null;
    protected ResultsPanel m_ResultsPanel = null;

    public void setResultsPanel(ResultsPanel rp) {
        this.m_ResultsPanel = rp;
    }

    public RunPanel() {
        this.m_StartBut.addActionListener(this);
        this.m_StopBut.addActionListener(this);
        this.m_StartBut.setEnabled(false);
        this.m_StopBut.setEnabled(false);
        this.m_StartBut.setMnemonic('S');
        this.m_StopBut.setMnemonic('t');
        this.m_Log.statusMessage(NOT_RUNNING);
        JPanel controls = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        controls.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        controls.setLayout(gb);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 5.0;
        constraints.fill = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.insets = new Insets(0, 2, 0, 2);
        controls.add((Component)this.m_StartBut, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 5.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        controls.add((Component)this.m_StopBut, constraints);
        this.setLayout(new BorderLayout());
        this.add((Component)controls, "North");
        this.add((Component)this.m_Log, "Center");
    }

    public RunPanel(Experiment exp) {
        this();
        this.setExperiment(exp);
    }

    public void setExperiment(Experiment exp) {
        this.m_Exp = exp;
        this.m_StartBut.setEnabled(this.m_RunThread == null);
        this.m_StopBut.setEnabled(this.m_RunThread != null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_StartBut) {
            if (this.m_RunThread == null) {
                boolean proceed = true;
                if (Experimenter.m_Memory.memoryIsLow()) {
                    proceed = Experimenter.m_Memory.showMemoryIsLow();
                }
                if (proceed) {
                    try {
                        this.m_RunThread = new ExperimentRunner(this.m_Exp);
                        this.m_RunThread.setPriority(1);
                        this.m_RunThread.start();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        this.logMessage("Problem creating experiment copy to run: " + ex.getMessage());
                    }
                }
            }
        } else if (e.getSource() == this.m_StopBut) {
            this.m_StopBut.setEnabled(false);
            this.logMessage("User aborting experiment. ");
            if (this.m_Exp instanceof RemoteExperiment) {
                this.logMessage("Waiting for remote tasks to complete...");
            }
            ((ExperimentRunner)this.m_RunThread).abortExperiment();
            this.m_RunThread.stop();
            this.m_RunThread = null;
        }
    }

    protected void logMessage(String message) {
        this.m_Log.logMessage(message);
    }

    protected void statusMessage(String message) {
        this.m_Log.statusMessage(message);
    }

    public static void main(String[] args) {
        try {
            boolean readExp = Utils.getFlag('l', args);
            String expFile = Utils.getOption('f', args);
            if (readExp && expFile.length() == 0) {
                throw new Exception("A filename must be given with the -f option");
            }
            Experiment exp = null;
            if (readExp) {
                FileInputStream fi = new FileInputStream(expFile);
                ObjectInputStream oi = new ObjectInputStream(new BufferedInputStream(fi));
                Object to = oi.readObject();
                exp = to instanceof RemoteExperiment ? (RemoteExperiment)to : (Experiment)to;
                oi.close();
            } else {
                exp = new Experiment();
            }
            System.err.println("Initial Experiment:\n" + exp.toString());
            final JFrame jf = new JFrame("Run Weka Experiment");
            jf.getContentPane().setLayout(new BorderLayout());
            final RunPanel sp = new RunPanel(exp);
            jf.getContentPane().add((Component)sp, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.err.println("\nExperiment Configuration\n" + sp.m_Exp.toString());
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    class ExperimentRunner
    extends Thread
    implements Serializable {
        private static final long serialVersionUID = -5591889874714150118L;
        Experiment m_ExpCopy;

        public ExperimentRunner(Experiment exp) throws Exception {
            if (exp == null) {
                System.err.println("Null experiment!!!");
            } else {
                System.err.println("Running experiment: " + exp.toString());
            }
            System.err.println("Writing experiment copy");
            SerializedObject so = new SerializedObject(exp);
            System.err.println("Reading experiment copy");
            this.m_ExpCopy = (Experiment)so.getObject();
            System.err.println("Made experiment copy");
        }

        public void abortExperiment() {
            if (this.m_ExpCopy instanceof RemoteExperiment) {
                ((RemoteExperiment)this.m_ExpCopy).abortExperiment();
                RunPanel.this.m_StopBut.setEnabled(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RunPanel.this.m_StartBut.setEnabled(false);
            RunPanel.this.m_StopBut.setEnabled(true);
            if (RunPanel.this.m_ResultsPanel != null) {
                RunPanel.this.m_ResultsPanel.setExperiment(null);
            }
            try {
                if (this.m_ExpCopy instanceof RemoteExperiment) {
                    System.err.println("Adding a listener");
                    ((RemoteExperiment)this.m_ExpCopy).addRemoteExperimentListener(new RemoteExperimentListener(){

                        @Override
                        public void remoteExperimentStatus(RemoteExperimentEvent e) {
                            if (e.m_statusMessage) {
                                RunPanel.this.statusMessage(e.m_messageString);
                            }
                            if (e.m_logMessage) {
                                RunPanel.this.logMessage(e.m_messageString);
                            }
                            if (e.m_experimentFinished) {
                                RunPanel.this.m_RunThread = null;
                                RunPanel.this.m_StartBut.setEnabled(true);
                                RunPanel.this.m_StopBut.setEnabled(false);
                                RunPanel.this.statusMessage(RunPanel.NOT_RUNNING);
                            }
                        }
                    });
                }
                RunPanel.this.logMessage("Started");
                RunPanel.this.statusMessage("Initializing...");
                this.m_ExpCopy.initialize();
                int errors = 0;
                if (!(this.m_ExpCopy instanceof RemoteExperiment)) {
                    RunPanel.this.statusMessage("Iterating...");
                    while (RunPanel.this.m_RunThread != null && this.m_ExpCopy.hasMoreIterations()) {
                        try {
                            String current = "Iteration:";
                            if (this.m_ExpCopy.getUsePropertyIterator()) {
                                int cnum = this.m_ExpCopy.getCurrentPropertyNumber();
                                String ctype = this.m_ExpCopy.getPropertyArray().getClass().getComponentType().getName();
                                int lastDot = ctype.lastIndexOf(46);
                                if (lastDot != -1) {
                                    ctype = ctype.substring(lastDot + 1);
                                }
                                String cname = " " + ctype + "=" + (cnum + 1) + ":" + this.m_ExpCopy.getPropertyArrayValue(cnum).getClass().getName();
                                current = current + cname;
                            }
                            String dname = ((File)this.m_ExpCopy.getDatasets().elementAt(this.m_ExpCopy.getCurrentDatasetNumber())).getName();
                            current = current + " Dataset=" + dname + " Run=" + this.m_ExpCopy.getCurrentRunNumber();
                            RunPanel.this.statusMessage(current);
                            this.m_ExpCopy.nextIteration();
                        }
                        catch (Exception ex) {
                            ++errors;
                            RunPanel.this.logMessage(ex.getMessage());
                            ex.printStackTrace();
                            boolean continueAfterError = false;
                            if (continueAfterError) {
                                this.m_ExpCopy.advanceCounters();
                                continue;
                            }
                            RunPanel.this.m_RunThread = null;
                        }
                    }
                    RunPanel.this.statusMessage("Postprocessing...");
                    this.m_ExpCopy.postProcess();
                    if (RunPanel.this.m_RunThread == null) {
                        RunPanel.this.logMessage("Interrupted");
                    } else {
                        RunPanel.this.logMessage("Finished");
                    }
                    if (errors == 1) {
                        RunPanel.this.logMessage("There was " + errors + " error");
                    } else {
                        RunPanel.this.logMessage("There were " + errors + " errors");
                    }
                    RunPanel.this.statusMessage(RunPanel.NOT_RUNNING);
                } else {
                    RunPanel.this.statusMessage("Remote experiment running...");
                    ((RemoteExperiment)this.m_ExpCopy).runExperiment();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println(ex.getMessage());
                RunPanel.this.statusMessage(ex.getMessage());
            }
            finally {
                if (RunPanel.this.m_ResultsPanel != null) {
                    RunPanel.this.m_ResultsPanel.setExperiment(this.m_ExpCopy);
                }
                if (!(this.m_ExpCopy instanceof RemoteExperiment)) {
                    RunPanel.this.m_RunThread = null;
                    RunPanel.this.m_StartBut.setEnabled(true);
                    RunPanel.this.m_StopBut.setEnabled(false);
                    System.err.println("Done...");
                }
            }
        }
    }
}

