/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 *    ExecutionResult.java
 *    Copyright (C) 2015 University of Waikato, Hamilton, New Zealand
 *
 */

package weka.knowledgeflow;

import java.io.Serializable;

/**
 * Stores the result generated by a StepTask.
 *
 * @param <T> the type of the result stored
 *
 * @author Mark Hall (mhall{[at]}pentaho{[dot]}com)
 * @version $Revision: $
 */
public class ExecutionResult<T> implements Serializable {

  /**
   * For serialization
   */
  private static final long serialVersionUID = -4495164361311877942L;

  /** Holds any error that might have been generated */
  protected Exception m_error;

  /** Holds the result payload */
  protected T m_executionResult;

  /**
   * Set an exception, in the case that an error occurred during the
   * processing done by a StepTask
   *
   * @param error
   */
  public void setError(Exception error) {
    m_error = error;
  }

  /**
   * Get the Exception generated during processing of a StepTask, or null
   * if the task completed successfully.
   *
   * @return the Exception generated, or null if the task completed successfully
   */
  public Exception getError() {
    return m_error;
  }

  /**
   * Set the result generated by the StepTask
   *
   * @param result the result generated by the StepTask
   */
  public void setResult(T result) {
    m_executionResult = result;
  }

  /**
   * Get the result generated by the StepTask
   *
   * @return the result generated by the StepTask
   */
  public T getResult() {
    return m_executionResult;
  }
}
