package databox

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// AddressType enumerates the values for address type.
type AddressType string

const (
	// Commercial ...
	Commercial AddressType = "Commercial"
	// None ...
	None AddressType = "None"
	// Residential ...
	Residential AddressType = "Residential"
)

// PossibleAddressTypeValues returns an array of possible values for the AddressType const type.
func PossibleAddressTypeValues() []AddressType {
	return []AddressType{Commercial, None, Residential}
}

// AddressValidationStatus enumerates the values for address validation status.
type AddressValidationStatus string

const (
	// Ambiguous ...
	Ambiguous AddressValidationStatus = "Ambiguous"
	// Invalid ...
	Invalid AddressValidationStatus = "Invalid"
	// Valid ...
	Valid AddressValidationStatus = "Valid"
)

// PossibleAddressValidationStatusValues returns an array of possible values for the AddressValidationStatus const type.
func PossibleAddressValidationStatusValues() []AddressValidationStatus {
	return []AddressValidationStatus{Ambiguous, Invalid, Valid}
}

// CopyLogDetailsType enumerates the values for copy log details type.
type CopyLogDetailsType string

const (
	// CopyLogDetailsTypeCopyLogDetails ...
	CopyLogDetailsTypeCopyLogDetails CopyLogDetailsType = "CopyLogDetails"
	// CopyLogDetailsTypeDisk ...
	CopyLogDetailsTypeDisk CopyLogDetailsType = "Disk"
	// CopyLogDetailsTypePod ...
	CopyLogDetailsTypePod CopyLogDetailsType = "Pod"
)

// PossibleCopyLogDetailsTypeValues returns an array of possible values for the CopyLogDetailsType const type.
func PossibleCopyLogDetailsTypeValues() []CopyLogDetailsType {
	return []CopyLogDetailsType{CopyLogDetailsTypeCopyLogDetails, CopyLogDetailsTypeDisk, CopyLogDetailsTypePod}
}

// CopyStatus enumerates the values for copy status.
type CopyStatus string

const (
	// Completed ...
	Completed CopyStatus = "Completed"
	// CompletedWithErrors ...
	CompletedWithErrors CopyStatus = "CompletedWithErrors"
	// Failed ...
	Failed CopyStatus = "Failed"
	// InProgress ...
	InProgress CopyStatus = "InProgress"
	// NotStarted ...
	NotStarted CopyStatus = "NotStarted"
)

// PossibleCopyStatusValues returns an array of possible values for the CopyStatus const type.
func PossibleCopyStatusValues() []CopyStatus {
	return []CopyStatus{Completed, CompletedWithErrors, Failed, InProgress, NotStarted}
}

// DeviceIssueType enumerates the values for device issue type.
type DeviceIssueType string

const (
	// DeviceHealthCheckShowFailures ...
	DeviceHealthCheckShowFailures DeviceIssueType = "DeviceHealthCheckShowFailures"
	// DeviceNotBootingUp ...
	DeviceNotBootingUp DeviceIssueType = "DeviceNotBootingUp"
	// DeviceTampering ...
	DeviceTampering DeviceIssueType = "DeviceTampering"
	// Misc ...
	Misc DeviceIssueType = "Misc"
	// NICsAreNotWorking ...
	NICsAreNotWorking DeviceIssueType = "NICsAreNotWorking"
)

// PossibleDeviceIssueTypeValues returns an array of possible values for the DeviceIssueType const type.
func PossibleDeviceIssueTypeValues() []DeviceIssueType {
	return []DeviceIssueType{DeviceHealthCheckShowFailures, DeviceNotBootingUp, DeviceTampering, Misc, NICsAreNotWorking}
}

// DeviceType enumerates the values for device type.
type DeviceType string

const (
	// Cabinet ...
	Cabinet DeviceType = "Cabinet"
	// Disk ...
	Disk DeviceType = "Disk"
	// Pod ...
	Pod DeviceType = "Pod"
)

// PossibleDeviceTypeValues returns an array of possible values for the DeviceType const type.
func PossibleDeviceTypeValues() []DeviceType {
	return []DeviceType{Cabinet, Disk, Pod}
}

// IssueType enumerates the values for issue type.
type IssueType string

const (
	// CredentialNotWorking ...
	CredentialNotWorking IssueType = "CredentialNotWorking"
	// DeviceFailure ...
	DeviceFailure IssueType = "DeviceFailure"
	// DeviceMismatch ...
	DeviceMismatch IssueType = "DeviceMismatch"
	// ValidationStringMismatch ...
	ValidationStringMismatch IssueType = "ValidationStringMismatch"
)

// PossibleIssueTypeValues returns an array of possible values for the IssueType const type.
func PossibleIssueTypeValues() []IssueType {
	return []IssueType{CredentialNotWorking, DeviceFailure, DeviceMismatch, ValidationStringMismatch}
}

// JobDetailsType enumerates the values for job details type.
type JobDetailsType string

const (
	// JobDetailsTypeDisk ...
	JobDetailsTypeDisk JobDetailsType = "Disk"
	// JobDetailsTypeJobDetails ...
	JobDetailsTypeJobDetails JobDetailsType = "JobDetails"
	// JobDetailsTypePod ...
	JobDetailsTypePod JobDetailsType = "Pod"
)

// PossibleJobDetailsTypeValues returns an array of possible values for the JobDetailsType const type.
func PossibleJobDetailsTypeValues() []JobDetailsType {
	return []JobDetailsType{JobDetailsTypeDisk, JobDetailsTypeJobDetails, JobDetailsTypePod}
}

// JobSecretsType enumerates the values for job secrets type.
type JobSecretsType string

const (
	// JobSecretsTypeCabinet ...
	JobSecretsTypeCabinet JobSecretsType = "Cabinet"
	// JobSecretsTypeDisk ...
	JobSecretsTypeDisk JobSecretsType = "Disk"
	// JobSecretsTypeJobSecrets ...
	JobSecretsTypeJobSecrets JobSecretsType = "JobSecrets"
	// JobSecretsTypePod ...
	JobSecretsTypePod JobSecretsType = "Pod"
)

// PossibleJobSecretsTypeValues returns an array of possible values for the JobSecretsType const type.
func PossibleJobSecretsTypeValues() []JobSecretsType {
	return []JobSecretsType{JobSecretsTypeCabinet, JobSecretsTypeDisk, JobSecretsTypeJobSecrets, JobSecretsTypePod}
}

// NotificationStageName enumerates the values for notification stage name.
type NotificationStageName string

const (
	// AtAzureDC ...
	AtAzureDC NotificationStageName = "AtAzureDC"
	// DataCopy ...
	DataCopy NotificationStageName = "DataCopy"
	// Delivered ...
	Delivered NotificationStageName = "Delivered"
	// DevicePrepared ...
	DevicePrepared NotificationStageName = "DevicePrepared"
	// Dispatched ...
	Dispatched NotificationStageName = "Dispatched"
	// PickedUp ...
	PickedUp NotificationStageName = "PickedUp"
)

// PossibleNotificationStageNameValues returns an array of possible values for the NotificationStageName const type.
func PossibleNotificationStageNameValues() []NotificationStageName {
	return []NotificationStageName{AtAzureDC, DataCopy, Delivered, DevicePrepared, Dispatched, PickedUp}
}

// StageName enumerates the values for stage name.
type StageName string

const (
	// StageNameAborted ...
	StageNameAborted StageName = "Aborted"
	// StageNameAtAzureDC ...
	StageNameAtAzureDC StageName = "AtAzureDC"
	// StageNameCancelled ...
	StageNameCancelled StageName = "Cancelled"
	// StageNameCompleted ...
	StageNameCompleted StageName = "Completed"
	// StageNameCompletedWithErrors ...
	StageNameCompletedWithErrors StageName = "CompletedWithErrors"
	// StageNameDataCopy ...
	StageNameDataCopy StageName = "DataCopy"
	// StageNameDelivered ...
	StageNameDelivered StageName = "Delivered"
	// StageNameDeviceOrdered ...
	StageNameDeviceOrdered StageName = "DeviceOrdered"
	// StageNameDevicePrepared ...
	StageNameDevicePrepared StageName = "DevicePrepared"
	// StageNameDispatched ...
	StageNameDispatched StageName = "Dispatched"
	// StageNameFailedIssueDetectedAtAzureDC ...
	StageNameFailedIssueDetectedAtAzureDC StageName = "Failed_IssueDetectedAtAzureDC"
	// StageNameFailedIssueReportedAtCustomer ...
	StageNameFailedIssueReportedAtCustomer StageName = "Failed_IssueReportedAtCustomer"
	// StageNamePickedUp ...
	StageNamePickedUp StageName = "PickedUp"
)

// PossibleStageNameValues returns an array of possible values for the StageName const type.
func PossibleStageNameValues() []StageName {
	return []StageName{StageNameAborted, StageNameAtAzureDC, StageNameCancelled, StageNameCompleted, StageNameCompletedWithErrors, StageNameDataCopy, StageNameDelivered, StageNameDeviceOrdered, StageNameDevicePrepared, StageNameDispatched, StageNameFailedIssueDetectedAtAzureDC, StageNameFailedIssueReportedAtCustomer, StageNamePickedUp}
}

// StageStatus enumerates the values for stage status.
type StageStatus string

const (
	// StageStatusCancelled ...
	StageStatusCancelled StageStatus = "Cancelled"
	// StageStatusCancelling ...
	StageStatusCancelling StageStatus = "Cancelling"
	// StageStatusFailed ...
	StageStatusFailed StageStatus = "Failed"
	// StageStatusInProgress ...
	StageStatusInProgress StageStatus = "InProgress"
	// StageStatusNone ...
	StageStatusNone StageStatus = "None"
	// StageStatusSucceeded ...
	StageStatusSucceeded StageStatus = "Succeeded"
	// StageStatusSucceededWithErrors ...
	StageStatusSucceededWithErrors StageStatus = "SucceededWithErrors"
)

// PossibleStageStatusValues returns an array of possible values for the StageStatus const type.
func PossibleStageStatusValues() []StageStatus {
	return []StageStatus{StageStatusCancelled, StageStatusCancelling, StageStatusFailed, StageStatusInProgress, StageStatusNone, StageStatusSucceeded, StageStatusSucceededWithErrors}
}

// AccountCopyLogDetails copy log details for an storage account
type AccountCopyLogDetails struct {
	// AccountName - Destination account name.
	AccountName *string `json:"accountName,omitempty"`
	// CopyLogLink - Link for copy logs.
	CopyLogLink *string `json:"copyLogLink,omitempty"`
	// CopyLogDetailsType - Possible values include: 'CopyLogDetailsTypeCopyLogDetails', 'CopyLogDetailsTypePod', 'CopyLogDetailsTypeDisk'
	CopyLogDetailsType CopyLogDetailsType `json:"copyLogDetailsType,omitempty"`
}

// MarshalJSON is the custom marshaler for AccountCopyLogDetails.
func (acld AccountCopyLogDetails) MarshalJSON() ([]byte, error) {
	acld.CopyLogDetailsType = CopyLogDetailsTypePod
	objectMap := make(map[string]interface{})
	if acld.AccountName != nil {
		objectMap["accountName"] = acld.AccountName
	}
	if acld.CopyLogLink != nil {
		objectMap["copyLogLink"] = acld.CopyLogLink
	}
	if acld.CopyLogDetailsType != "" {
		objectMap["copyLogDetailsType"] = acld.CopyLogDetailsType
	}
	return json.Marshal(objectMap)
}

// AsAccountCopyLogDetails is the BasicCopyLogDetails implementation for AccountCopyLogDetails.
func (acld AccountCopyLogDetails) AsAccountCopyLogDetails() (*AccountCopyLogDetails, bool) {
	return &acld, true
}

// AsDiskCopyLogDetails is the BasicCopyLogDetails implementation for AccountCopyLogDetails.
func (acld AccountCopyLogDetails) AsDiskCopyLogDetails() (*DiskCopyLogDetails, bool) {
	return nil, false
}

// AsCopyLogDetails is the BasicCopyLogDetails implementation for AccountCopyLogDetails.
func (acld AccountCopyLogDetails) AsCopyLogDetails() (*CopyLogDetails, bool) {
	return nil, false
}

// AsBasicCopyLogDetails is the BasicCopyLogDetails implementation for AccountCopyLogDetails.
func (acld AccountCopyLogDetails) AsBasicCopyLogDetails() (BasicCopyLogDetails, bool) {
	return &acld, true
}

// AccountCredentialDetails credential details of the account.
type AccountCredentialDetails struct {
	// AccountName - Name of the account.
	AccountName *string `json:"accountName,omitempty"`
	// ShareCredentialDetails - Per share level unencrypted access credentials.
	ShareCredentialDetails *[]ShareCredentialDetails `json:"shareCredentialDetails,omitempty"`
}

// AddressValidationOutput output of the address validation api.
type AddressValidationOutput struct {
	autorest.Response `json:"-"`
	// AddressValidationProperties - The address validation properties.
	*AddressValidationProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AddressValidationOutput.
func (avo AddressValidationOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if avo.AddressValidationProperties != nil {
		objectMap["properties"] = avo.AddressValidationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AddressValidationOutput struct.
func (avo *AddressValidationOutput) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var addressValidationProperties AddressValidationProperties
				err = json.Unmarshal(*v, &addressValidationProperties)
				if err != nil {
					return err
				}
				avo.AddressValidationProperties = &addressValidationProperties
			}
		}
	}

	return nil
}

// AddressValidationProperties the address validation output.
type AddressValidationProperties struct {
	// ValidationStatus - The address validation status. Possible values include: 'Valid', 'Invalid', 'Ambiguous'
	ValidationStatus AddressValidationStatus `json:"validationStatus,omitempty"`
	// AlternateAddresses - List of alternate addresses.
	AlternateAddresses *[]ShippingAddress `json:"alternateAddresses,omitempty"`
}

// ArmBaseObject base class for all objects under resource.
type ArmBaseObject struct {
	// Name - Name of the object.
	Name *string `json:"name,omitempty"`
	// ID - Id of the object.
	ID *string `json:"id,omitempty"`
	// Type - Type of the object.
	Type *string `json:"type,omitempty"`
}

// AvailableSkuRequest the filters for showing the available skus.
type AvailableSkuRequest struct {
	// TransferType - Type of the transfer.
	TransferType *string `json:"transferType,omitempty"`
	// Country - ISO country code. Country for hardware shipment. For codes check: https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2#Officially_assigned_code_elements
	Country *string `json:"country,omitempty"`
	// Location - Location for data transfer. For locations check: https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01
	Location *string `json:"location,omitempty"`
}

// AvailableSkusResult the available skus operation response.
type AvailableSkusResult struct {
	autorest.Response `json:"-"`
	// Value - List of available skus.
	Value *[]SkuInformation `json:"value,omitempty"`
	// NextLink - Link for the next set of skus.
	NextLink *string `json:"nextLink,omitempty"`
}

// AvailableSkusResultIterator provides access to a complete listing of SkuInformation values.
type AvailableSkusResultIterator struct {
	i    int
	page AvailableSkusResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AvailableSkusResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AvailableSkusResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AvailableSkusResultIterator) Response() AvailableSkusResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AvailableSkusResultIterator) Value() SkuInformation {
	if !iter.page.NotDone() {
		return SkuInformation{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (asr AvailableSkusResult) IsEmpty() bool {
	return asr.Value == nil || len(*asr.Value) == 0
}

// availableSkusResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (asr AvailableSkusResult) availableSkusResultPreparer() (*http.Request, error) {
	if asr.NextLink == nil || len(to.String(asr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(asr.NextLink)))
}

// AvailableSkusResultPage contains a page of SkuInformation values.
type AvailableSkusResultPage struct {
	fn  func(AvailableSkusResult) (AvailableSkusResult, error)
	asr AvailableSkusResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AvailableSkusResultPage) Next() error {
	next, err := page.fn(page.asr)
	if err != nil {
		return err
	}
	page.asr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AvailableSkusResultPage) NotDone() bool {
	return !page.asr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AvailableSkusResultPage) Response() AvailableSkusResult {
	return page.asr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AvailableSkusResultPage) Values() []SkuInformation {
	if page.asr.IsEmpty() {
		return nil
	}
	return *page.asr.Value
}

// CabinetJobSecrets the secrets related to a cabinet job.
type CabinetJobSecrets struct {
	// CabinetPodSecrets - Contains the list of secret objects for a cabinet job.
	CabinetPodSecrets *[]CabinetPodSecret `json:"cabinetPodSecrets,omitempty"`
	// JobSecretsType - Possible values include: 'JobSecretsTypeJobSecrets', 'JobSecretsTypeCabinet', 'JobSecretsTypeDisk', 'JobSecretsTypePod'
	JobSecretsType JobSecretsType `json:"jobSecretsType,omitempty"`
}

// MarshalJSON is the custom marshaler for CabinetJobSecrets.
func (cjs CabinetJobSecrets) MarshalJSON() ([]byte, error) {
	cjs.JobSecretsType = JobSecretsTypeCabinet
	objectMap := make(map[string]interface{})
	if cjs.CabinetPodSecrets != nil {
		objectMap["cabinetPodSecrets"] = cjs.CabinetPodSecrets
	}
	if cjs.JobSecretsType != "" {
		objectMap["jobSecretsType"] = cjs.JobSecretsType
	}
	return json.Marshal(objectMap)
}

// AsCabinetJobSecrets is the BasicJobSecrets implementation for CabinetJobSecrets.
func (cjs CabinetJobSecrets) AsCabinetJobSecrets() (*CabinetJobSecrets, bool) {
	return &cjs, true
}

// AsDiskJobSecrets is the BasicJobSecrets implementation for CabinetJobSecrets.
func (cjs CabinetJobSecrets) AsDiskJobSecrets() (*DiskJobSecrets, bool) {
	return nil, false
}

// AsPodJobSecrets is the BasicJobSecrets implementation for CabinetJobSecrets.
func (cjs CabinetJobSecrets) AsPodJobSecrets() (*PodJobSecrets, bool) {
	return nil, false
}

// AsJobSecrets is the BasicJobSecrets implementation for CabinetJobSecrets.
func (cjs CabinetJobSecrets) AsJobSecrets() (*JobSecrets, bool) {
	return nil, false
}

// AsBasicJobSecrets is the BasicJobSecrets implementation for CabinetJobSecrets.
func (cjs CabinetJobSecrets) AsBasicJobSecrets() (BasicJobSecrets, bool) {
	return &cjs, true
}

// CabinetPodSecret the secrets related to a cabinet pod.
type CabinetPodSecret struct {
	// DeviceSerialNumber - Serial number of the assigned device.
	DeviceSerialNumber *string `json:"deviceSerialNumber,omitempty"`
	// DevicePassword - Password for out of the box experience on device.
	DevicePassword *string `json:"devicePassword,omitempty"`
	// AccountCredentialDetails - Per account level access credentials.
	AccountCredentialDetails *[]AccountCredentialDetails `json:"accountCredentialDetails,omitempty"`
}

// CancellationReason reason for cancellation.
type CancellationReason struct {
	// Reason - Reason for cancellation.
	Reason *string `json:"reason,omitempty"`
}

// ContactDetails contact Details.
type ContactDetails struct {
	// ContactName - Contact name of the person.
	ContactName *string `json:"contactName,omitempty"`
	// Phone - Phone number of the contact person.
	Phone *string `json:"phone,omitempty"`
	// PhoneExtension - Phone extension number of the contact person.
	PhoneExtension *string `json:"phoneExtension,omitempty"`
	// Mobile - Mobile number of the contact person.
	Mobile *string `json:"mobile,omitempty"`
	// EmailList - List of Email-ids to be notified about job progress.
	EmailList *[]string `json:"emailList,omitempty"`
	// NotificationPreference - Notification preference for a job stage.
	NotificationPreference *[]NotificationPreference `json:"notificationPreference,omitempty"`
}

// BasicCopyLogDetails details for log generated during copy.
type BasicCopyLogDetails interface {
	AsAccountCopyLogDetails() (*AccountCopyLogDetails, bool)
	AsDiskCopyLogDetails() (*DiskCopyLogDetails, bool)
	AsCopyLogDetails() (*CopyLogDetails, bool)
}

// CopyLogDetails details for log generated during copy.
type CopyLogDetails struct {
	// CopyLogDetailsType - Possible values include: 'CopyLogDetailsTypeCopyLogDetails', 'CopyLogDetailsTypePod', 'CopyLogDetailsTypeDisk'
	CopyLogDetailsType CopyLogDetailsType `json:"copyLogDetailsType,omitempty"`
}

func unmarshalBasicCopyLogDetails(body []byte) (BasicCopyLogDetails, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["copyLogDetailsType"] {
	case string(CopyLogDetailsTypePod):
		var acld AccountCopyLogDetails
		err := json.Unmarshal(body, &acld)
		return acld, err
	case string(CopyLogDetailsTypeDisk):
		var dcld DiskCopyLogDetails
		err := json.Unmarshal(body, &dcld)
		return dcld, err
	default:
		var cld CopyLogDetails
		err := json.Unmarshal(body, &cld)
		return cld, err
	}
}
func unmarshalBasicCopyLogDetailsArray(body []byte) ([]BasicCopyLogDetails, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	cldArray := make([]BasicCopyLogDetails, len(rawMessages))

	for index, rawMessage := range rawMessages {
		cld, err := unmarshalBasicCopyLogDetails(*rawMessage)
		if err != nil {
			return nil, err
		}
		cldArray[index] = cld
	}
	return cldArray, nil
}

// MarshalJSON is the custom marshaler for CopyLogDetails.
func (cld CopyLogDetails) MarshalJSON() ([]byte, error) {
	cld.CopyLogDetailsType = CopyLogDetailsTypeCopyLogDetails
	objectMap := make(map[string]interface{})
	if cld.CopyLogDetailsType != "" {
		objectMap["copyLogDetailsType"] = cld.CopyLogDetailsType
	}
	return json.Marshal(objectMap)
}

// AsAccountCopyLogDetails is the BasicCopyLogDetails implementation for CopyLogDetails.
func (cld CopyLogDetails) AsAccountCopyLogDetails() (*AccountCopyLogDetails, bool) {
	return nil, false
}

// AsDiskCopyLogDetails is the BasicCopyLogDetails implementation for CopyLogDetails.
func (cld CopyLogDetails) AsDiskCopyLogDetails() (*DiskCopyLogDetails, bool) {
	return nil, false
}

// AsCopyLogDetails is the BasicCopyLogDetails implementation for CopyLogDetails.
func (cld CopyLogDetails) AsCopyLogDetails() (*CopyLogDetails, bool) {
	return &cld, true
}

// AsBasicCopyLogDetails is the BasicCopyLogDetails implementation for CopyLogDetails.
func (cld CopyLogDetails) AsBasicCopyLogDetails() (BasicCopyLogDetails, bool) {
	return &cld, true
}

// CopyProgress copy progress.
type CopyProgress struct {
	// StorageAccountName - Name of the storage account where the data needs to be uploaded.
	StorageAccountName *string `json:"storageAccountName,omitempty"`
	// BytesSentToCloud - Amount of data uploaded by the job as of now.
	BytesSentToCloud *int64 `json:"bytesSentToCloud,omitempty"`
	// TotalBytesToProcess - Total amount of data to be processed by the job.
	TotalBytesToProcess *int64 `json:"totalBytesToProcess,omitempty"`
}

// DestinationAccountDetails details for the destination account.
type DestinationAccountDetails struct {
	// AccountID - Destination storage account id.
	AccountID *string `json:"accountId,omitempty"`
}

// DestinationToServiceLocationMap map of destination location to service location
type DestinationToServiceLocationMap struct {
	// DestinationLocation - Location of the destination.
	DestinationLocation *string `json:"destinationLocation,omitempty"`
	// ServiceLocation - Location of the service.
	ServiceLocation *string `json:"serviceLocation,omitempty"`
}

// DiskCopyLogDetails copy Log Details for a disk
type DiskCopyLogDetails struct {
	// DiskSerialNumber - Disk Serial Number.
	DiskSerialNumber *string `json:"diskSerialNumber,omitempty"`
	// ErrorLogLink - Link for copy error logs.
	ErrorLogLink *string `json:"errorLogLink,omitempty"`
	// VerboseLogLink - Link for copy verbose logs.
	VerboseLogLink *string `json:"verboseLogLink,omitempty"`
	// CopyLogDetailsType - Possible values include: 'CopyLogDetailsTypeCopyLogDetails', 'CopyLogDetailsTypePod', 'CopyLogDetailsTypeDisk'
	CopyLogDetailsType CopyLogDetailsType `json:"copyLogDetailsType,omitempty"`
}

// MarshalJSON is the custom marshaler for DiskCopyLogDetails.
func (dcld DiskCopyLogDetails) MarshalJSON() ([]byte, error) {
	dcld.CopyLogDetailsType = CopyLogDetailsTypeDisk
	objectMap := make(map[string]interface{})
	if dcld.DiskSerialNumber != nil {
		objectMap["diskSerialNumber"] = dcld.DiskSerialNumber
	}
	if dcld.ErrorLogLink != nil {
		objectMap["errorLogLink"] = dcld.ErrorLogLink
	}
	if dcld.VerboseLogLink != nil {
		objectMap["verboseLogLink"] = dcld.VerboseLogLink
	}
	if dcld.CopyLogDetailsType != "" {
		objectMap["copyLogDetailsType"] = dcld.CopyLogDetailsType
	}
	return json.Marshal(objectMap)
}

// AsAccountCopyLogDetails is the BasicCopyLogDetails implementation for DiskCopyLogDetails.
func (dcld DiskCopyLogDetails) AsAccountCopyLogDetails() (*AccountCopyLogDetails, bool) {
	return nil, false
}

// AsDiskCopyLogDetails is the BasicCopyLogDetails implementation for DiskCopyLogDetails.
func (dcld DiskCopyLogDetails) AsDiskCopyLogDetails() (*DiskCopyLogDetails, bool) {
	return &dcld, true
}

// AsCopyLogDetails is the BasicCopyLogDetails implementation for DiskCopyLogDetails.
func (dcld DiskCopyLogDetails) AsCopyLogDetails() (*CopyLogDetails, bool) {
	return nil, false
}

// AsBasicCopyLogDetails is the BasicCopyLogDetails implementation for DiskCopyLogDetails.
func (dcld DiskCopyLogDetails) AsBasicCopyLogDetails() (BasicCopyLogDetails, bool) {
	return &dcld, true
}

// DiskCopyProgress disk Copy Progress
type DiskCopyProgress struct {
	// SerialNumber - The serial number of the disk
	SerialNumber *string `json:"serialNumber,omitempty"`
	// PercentComplete - Indicates the percentage completed for the copy of the disk.
	PercentComplete *int32 `json:"percentComplete,omitempty"`
	// Status - The Status of the copy. Possible values include: 'NotStarted', 'InProgress', 'Completed', 'CompletedWithErrors', 'Failed'
	Status CopyStatus `json:"status,omitempty"`
}

// DiskJobDetails disk Job Details.
type DiskJobDetails struct {
	// PreferredDisks - User preference on what size disks are needed for the job. The map is from the disk size in TB to the count. Eg. {2,5} means 5 disks of 2 TB size. Key is string but will be checked against an int.
	PreferredDisks map[string]*int32 `json:"preferredDisks"`
	// CopyProgress - Copy progress per disk.
	CopyProgress *[]DiskCopyProgress `json:"copyProgress,omitempty"`
	// DisksAndSizeDetails - Contains the map of disk serial number to the disk size being used for the job. Is returned only after the disks are shipped to the customer.
	DisksAndSizeDetails map[string]*int32 `json:"disksAndSizeDetails"`
	// ExpectedDataSizeInTeraBytes - The expected size of the data, which needs to be transfered in this job, in tera bytes.
	ExpectedDataSizeInTeraBytes *int32 `json:"expectedDataSizeInTeraBytes,omitempty"`
	// JobStages - List of stages that run in the job.
	JobStages *[]JobStages `json:"jobStages,omitempty"`
	// ContactDetails - Contact details for notification and shipping.
	ContactDetails *ContactDetails `json:"contactDetails,omitempty"`
	// ShippingAddress - Shipping address of the customer.
	ShippingAddress *ShippingAddress `json:"shippingAddress,omitempty"`
	// ErrorDetails - Error details for failure. This is optional.
	ErrorDetails *[]JobErrorDetails `json:"errorDetails,omitempty"`
	// JobDetailsType - Possible values include: 'JobDetailsTypeJobDetails', 'JobDetailsTypeDisk', 'JobDetailsTypePod'
	JobDetailsType JobDetailsType `json:"jobDetailsType,omitempty"`
}

// MarshalJSON is the custom marshaler for DiskJobDetails.
func (djd DiskJobDetails) MarshalJSON() ([]byte, error) {
	djd.JobDetailsType = JobDetailsTypeDisk
	objectMap := make(map[string]interface{})
	if djd.PreferredDisks != nil {
		objectMap["preferredDisks"] = djd.PreferredDisks
	}
	if djd.CopyProgress != nil {
		objectMap["copyProgress"] = djd.CopyProgress
	}
	if djd.DisksAndSizeDetails != nil {
		objectMap["disksAndSizeDetails"] = djd.DisksAndSizeDetails
	}
	if djd.ExpectedDataSizeInTeraBytes != nil {
		objectMap["expectedDataSizeInTeraBytes"] = djd.ExpectedDataSizeInTeraBytes
	}
	if djd.JobStages != nil {
		objectMap["jobStages"] = djd.JobStages
	}
	if djd.ContactDetails != nil {
		objectMap["contactDetails"] = djd.ContactDetails
	}
	if djd.ShippingAddress != nil {
		objectMap["shippingAddress"] = djd.ShippingAddress
	}
	if djd.ErrorDetails != nil {
		objectMap["errorDetails"] = djd.ErrorDetails
	}
	if djd.JobDetailsType != "" {
		objectMap["jobDetailsType"] = djd.JobDetailsType
	}
	return json.Marshal(objectMap)
}

// AsDiskJobDetails is the BasicJobDetails implementation for DiskJobDetails.
func (djd DiskJobDetails) AsDiskJobDetails() (*DiskJobDetails, bool) {
	return &djd, true
}

// AsPodJobDetails is the BasicJobDetails implementation for DiskJobDetails.
func (djd DiskJobDetails) AsPodJobDetails() (*PodJobDetails, bool) {
	return nil, false
}

// AsJobDetails is the BasicJobDetails implementation for DiskJobDetails.
func (djd DiskJobDetails) AsJobDetails() (*JobDetails, bool) {
	return nil, false
}

// AsBasicJobDetails is the BasicJobDetails implementation for DiskJobDetails.
func (djd DiskJobDetails) AsBasicJobDetails() (BasicJobDetails, bool) {
	return &djd, true
}

// DiskJobSecrets the secrets related to disk job.
type DiskJobSecrets struct {
	// DiskSecrets - Contains the list of secrets object for that device.
	DiskSecrets *[]DiskSecret `json:"diskSecrets,omitempty"`
	// JobSecretsType - Possible values include: 'JobSecretsTypeJobSecrets', 'JobSecretsTypeCabinet', 'JobSecretsTypeDisk', 'JobSecretsTypePod'
	JobSecretsType JobSecretsType `json:"jobSecretsType,omitempty"`
}

// MarshalJSON is the custom marshaler for DiskJobSecrets.
func (djs DiskJobSecrets) MarshalJSON() ([]byte, error) {
	djs.JobSecretsType = JobSecretsTypeDisk
	objectMap := make(map[string]interface{})
	if djs.DiskSecrets != nil {
		objectMap["diskSecrets"] = djs.DiskSecrets
	}
	if djs.JobSecretsType != "" {
		objectMap["jobSecretsType"] = djs.JobSecretsType
	}
	return json.Marshal(objectMap)
}

// AsCabinetJobSecrets is the BasicJobSecrets implementation for DiskJobSecrets.
func (djs DiskJobSecrets) AsCabinetJobSecrets() (*CabinetJobSecrets, bool) {
	return nil, false
}

// AsDiskJobSecrets is the BasicJobSecrets implementation for DiskJobSecrets.
func (djs DiskJobSecrets) AsDiskJobSecrets() (*DiskJobSecrets, bool) {
	return &djs, true
}

// AsPodJobSecrets is the BasicJobSecrets implementation for DiskJobSecrets.
func (djs DiskJobSecrets) AsPodJobSecrets() (*PodJobSecrets, bool) {
	return nil, false
}

// AsJobSecrets is the BasicJobSecrets implementation for DiskJobSecrets.
func (djs DiskJobSecrets) AsJobSecrets() (*JobSecrets, bool) {
	return nil, false
}

// AsBasicJobSecrets is the BasicJobSecrets implementation for DiskJobSecrets.
func (djs DiskJobSecrets) AsBasicJobSecrets() (BasicJobSecrets, bool) {
	return &djs, true
}

// DiskSecret contains all the secrets of a Disk.
type DiskSecret struct {
	// DiskSerialNumber - Serial number of the assigned disk.
	DiskSerialNumber *string `json:"diskSerialNumber,omitempty"`
	// BitLockerKey - Bit Locker key of the disk which can be used to unlock the disk to copy data.
	BitLockerKey *string `json:"bitLockerKey,omitempty"`
}

// Error top level error for the job.
type Error struct {
	// Code - Error code that can be used to programmatically identify the error.
	Code *string `json:"code,omitempty"`
	// Message - Describes the error in detail and provides debugging information.
	Message *string `json:"message,omitempty"`
}

// GetCopyLogsURIOutput output for the GetCopyLogsUri.
type GetCopyLogsURIOutput struct {
	autorest.Response `json:"-"`
	// LogType - Type/Level of the log.
	LogType *string `json:"logType,omitempty"`
	// CopyLogDetails - List of copy log details.
	CopyLogDetails *[]BasicCopyLogDetails `json:"copyLogDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for GetCopyLogsURIOutput struct.
func (gcluo *GetCopyLogsURIOutput) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "logType":
			if v != nil {
				var logType string
				err = json.Unmarshal(*v, &logType)
				if err != nil {
					return err
				}
				gcluo.LogType = &logType
			}
		case "copyLogDetails":
			if v != nil {
				copyLogDetails, err := unmarshalBasicCopyLogDetailsArray(*v)
				if err != nil {
					return err
				}
				gcluo.CopyLogDetails = &copyLogDetails
			}
		}
	}

	return nil
}

// BasicJobDetails job details.
type BasicJobDetails interface {
	AsDiskJobDetails() (*DiskJobDetails, bool)
	AsPodJobDetails() (*PodJobDetails, bool)
	AsJobDetails() (*JobDetails, bool)
}

// JobDetails job details.
type JobDetails struct {
	// ExpectedDataSizeInTeraBytes - The expected size of the data, which needs to be transfered in this job, in tera bytes.
	ExpectedDataSizeInTeraBytes *int32 `json:"expectedDataSizeInTeraBytes,omitempty"`
	// JobStages - List of stages that run in the job.
	JobStages *[]JobStages `json:"jobStages,omitempty"`
	// ContactDetails - Contact details for notification and shipping.
	ContactDetails *ContactDetails `json:"contactDetails,omitempty"`
	// ShippingAddress - Shipping address of the customer.
	ShippingAddress *ShippingAddress `json:"shippingAddress,omitempty"`
	// ErrorDetails - Error details for failure. This is optional.
	ErrorDetails *[]JobErrorDetails `json:"errorDetails,omitempty"`
	// JobDetailsType - Possible values include: 'JobDetailsTypeJobDetails', 'JobDetailsTypeDisk', 'JobDetailsTypePod'
	JobDetailsType JobDetailsType `json:"jobDetailsType,omitempty"`
}

func unmarshalBasicJobDetails(body []byte) (BasicJobDetails, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["jobDetailsType"] {
	case string(JobDetailsTypeDisk):
		var djd DiskJobDetails
		err := json.Unmarshal(body, &djd)
		return djd, err
	case string(JobDetailsTypePod):
		var pjd PodJobDetails
		err := json.Unmarshal(body, &pjd)
		return pjd, err
	default:
		var jd JobDetails
		err := json.Unmarshal(body, &jd)
		return jd, err
	}
}
func unmarshalBasicJobDetailsArray(body []byte) ([]BasicJobDetails, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	jdArray := make([]BasicJobDetails, len(rawMessages))

	for index, rawMessage := range rawMessages {
		jd, err := unmarshalBasicJobDetails(*rawMessage)
		if err != nil {
			return nil, err
		}
		jdArray[index] = jd
	}
	return jdArray, nil
}

// MarshalJSON is the custom marshaler for JobDetails.
func (jd JobDetails) MarshalJSON() ([]byte, error) {
	jd.JobDetailsType = JobDetailsTypeJobDetails
	objectMap := make(map[string]interface{})
	if jd.ExpectedDataSizeInTeraBytes != nil {
		objectMap["expectedDataSizeInTeraBytes"] = jd.ExpectedDataSizeInTeraBytes
	}
	if jd.JobStages != nil {
		objectMap["jobStages"] = jd.JobStages
	}
	if jd.ContactDetails != nil {
		objectMap["contactDetails"] = jd.ContactDetails
	}
	if jd.ShippingAddress != nil {
		objectMap["shippingAddress"] = jd.ShippingAddress
	}
	if jd.ErrorDetails != nil {
		objectMap["errorDetails"] = jd.ErrorDetails
	}
	if jd.JobDetailsType != "" {
		objectMap["jobDetailsType"] = jd.JobDetailsType
	}
	return json.Marshal(objectMap)
}

// AsDiskJobDetails is the BasicJobDetails implementation for JobDetails.
func (jd JobDetails) AsDiskJobDetails() (*DiskJobDetails, bool) {
	return nil, false
}

// AsPodJobDetails is the BasicJobDetails implementation for JobDetails.
func (jd JobDetails) AsPodJobDetails() (*PodJobDetails, bool) {
	return nil, false
}

// AsJobDetails is the BasicJobDetails implementation for JobDetails.
func (jd JobDetails) AsJobDetails() (*JobDetails, bool) {
	return &jd, true
}

// AsBasicJobDetails is the BasicJobDetails implementation for JobDetails.
func (jd JobDetails) AsBasicJobDetails() (BasicJobDetails, bool) {
	return &jd, true
}

// JobErrorDetails job Error Details for providing the information and recommended action.
type JobErrorDetails struct {
	// ErrorMessage - Message for the error.
	ErrorMessage *string `json:"errorMessage,omitempty"`
	// ErrorCode - Code for the error.
	ErrorCode *int32 `json:"errorCode,omitempty"`
	// RecommendedAction - Recommended action for the error.
	RecommendedAction *string `json:"recommendedAction,omitempty"`
	// ExceptionMessage - Contains the non localized exception message
	ExceptionMessage *string `json:"exceptionMessage,omitempty"`
}

// JobProperties job Properties
type JobProperties struct {
	// DeviceType - Type of the device to be used for the job. Possible values include: 'Pod', 'Disk', 'Cabinet'
	DeviceType DeviceType `json:"deviceType,omitempty"`
	// IsCancellable - Describes whether the job is cancellable or not.
	IsCancellable *bool `json:"isCancellable,omitempty"`
	// IsShippingAddressEditable - Describes whether the shipping address is editable or not.
	IsShippingAddressEditable *bool `json:"isShippingAddressEditable,omitempty"`
	// Status - Name of the stage which is in progress. Possible values include: 'StageNameDeviceOrdered', 'StageNameDevicePrepared', 'StageNameDispatched', 'StageNameDelivered', 'StageNamePickedUp', 'StageNameAtAzureDC', 'StageNameDataCopy', 'StageNameCompleted', 'StageNameCompletedWithErrors', 'StageNameCancelled', 'StageNameFailedIssueReportedAtCustomer', 'StageNameFailedIssueDetectedAtAzureDC', 'StageNameAborted'
	Status StageName `json:"status,omitempty"`
	// StartTime - Time at which the job was started in UTC ISO 8601 format.
	StartTime *date.Time `json:"startTime,omitempty"`
	// Error - Top level error for the job.
	Error *Error `json:"error,omitempty"`
	// DeliveryPackage - Delivery package shipping details.
	DeliveryPackage *PackageShippingDetails `json:"deliveryPackage,omitempty"`
	// ReturnPackage - Return package shipping details.
	ReturnPackage *PackageShippingDetails `json:"returnPackage,omitempty"`
	// DestinationAccountDetails - Destination account details.
	DestinationAccountDetails *[]DestinationAccountDetails `json:"destinationAccountDetails,omitempty"`
	// Details - Details of a job run. This field will only be sent for expand details filter.
	Details BasicJobDetails `json:"details,omitempty"`
	// CancellationReason - Reason for cancellation.
	CancellationReason *string `json:"cancellationReason,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for JobProperties struct.
func (jp *JobProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "deviceType":
			if v != nil {
				var deviceType DeviceType
				err = json.Unmarshal(*v, &deviceType)
				if err != nil {
					return err
				}
				jp.DeviceType = deviceType
			}
		case "isCancellable":
			if v != nil {
				var isCancellable bool
				err = json.Unmarshal(*v, &isCancellable)
				if err != nil {
					return err
				}
				jp.IsCancellable = &isCancellable
			}
		case "isShippingAddressEditable":
			if v != nil {
				var isShippingAddressEditable bool
				err = json.Unmarshal(*v, &isShippingAddressEditable)
				if err != nil {
					return err
				}
				jp.IsShippingAddressEditable = &isShippingAddressEditable
			}
		case "status":
			if v != nil {
				var status StageName
				err = json.Unmarshal(*v, &status)
				if err != nil {
					return err
				}
				jp.Status = status
			}
		case "startTime":
			if v != nil {
				var startTime date.Time
				err = json.Unmarshal(*v, &startTime)
				if err != nil {
					return err
				}
				jp.StartTime = &startTime
			}
		case "error":
			if v != nil {
				var errorVar Error
				err = json.Unmarshal(*v, &errorVar)
				if err != nil {
					return err
				}
				jp.Error = &errorVar
			}
		case "deliveryPackage":
			if v != nil {
				var deliveryPackage PackageShippingDetails
				err = json.Unmarshal(*v, &deliveryPackage)
				if err != nil {
					return err
				}
				jp.DeliveryPackage = &deliveryPackage
			}
		case "returnPackage":
			if v != nil {
				var returnPackage PackageShippingDetails
				err = json.Unmarshal(*v, &returnPackage)
				if err != nil {
					return err
				}
				jp.ReturnPackage = &returnPackage
			}
		case "destinationAccountDetails":
			if v != nil {
				var destinationAccountDetails []DestinationAccountDetails
				err = json.Unmarshal(*v, &destinationAccountDetails)
				if err != nil {
					return err
				}
				jp.DestinationAccountDetails = &destinationAccountDetails
			}
		case "details":
			if v != nil {
				details, err := unmarshalBasicJobDetails(*v)
				if err != nil {
					return err
				}
				jp.Details = details
			}
		case "cancellationReason":
			if v != nil {
				var cancellationReason string
				err = json.Unmarshal(*v, &cancellationReason)
				if err != nil {
					return err
				}
				jp.CancellationReason = &cancellationReason
			}
		}
	}

	return nil
}

// JobResource job Resource.
type JobResource struct {
	autorest.Response `json:"-"`
	// JobProperties - Properties of a job.
	*JobProperties `json:"properties,omitempty"`
	// Name - Name of the object.
	Name *string `json:"name,omitempty"`
	// ID - Id of the object.
	ID *string `json:"id,omitempty"`
	// Type - Type of the object.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource. This will be one of the supported and registered Azure Regions (e.g. West US, East US, Southeast Asia, etc.). The region of a resource cannot be changed once it is created, but if an identical region is specified on update the request will succeed.
	Location *string `json:"location,omitempty"`
	// Tags - The list of key value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups).
	Tags map[string]*string `json:"tags"`
	// Sku - The sku type.
	Sku *Sku `json:"sku,omitempty"`
}

// MarshalJSON is the custom marshaler for JobResource.
func (jr JobResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jr.JobProperties != nil {
		objectMap["properties"] = jr.JobProperties
	}
	if jr.Name != nil {
		objectMap["name"] = jr.Name
	}
	if jr.ID != nil {
		objectMap["id"] = jr.ID
	}
	if jr.Type != nil {
		objectMap["type"] = jr.Type
	}
	if jr.Location != nil {
		objectMap["location"] = jr.Location
	}
	if jr.Tags != nil {
		objectMap["tags"] = jr.Tags
	}
	if jr.Sku != nil {
		objectMap["sku"] = jr.Sku
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for JobResource struct.
func (jr *JobResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var jobProperties JobProperties
				err = json.Unmarshal(*v, &jobProperties)
				if err != nil {
					return err
				}
				jr.JobProperties = &jobProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				jr.Name = &name
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				jr.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				jr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				jr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				jr.Tags = tags
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				jr.Sku = &sku
			}
		}
	}

	return nil
}

// JobResourceList job Resource Collection
type JobResourceList struct {
	autorest.Response `json:"-"`
	// Value - List of job resources.
	Value *[]JobResource `json:"value,omitempty"`
	// NextLink - Link for the next set of job resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// JobResourceListIterator provides access to a complete listing of JobResource values.
type JobResourceListIterator struct {
	i    int
	page JobResourceListPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobResourceListIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobResourceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobResourceListIterator) Response() JobResourceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobResourceListIterator) Value() JobResource {
	if !iter.page.NotDone() {
		return JobResource{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (jrl JobResourceList) IsEmpty() bool {
	return jrl.Value == nil || len(*jrl.Value) == 0
}

// jobResourceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jrl JobResourceList) jobResourceListPreparer() (*http.Request, error) {
	if jrl.NextLink == nil || len(to.String(jrl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jrl.NextLink)))
}

// JobResourceListPage contains a page of JobResource values.
type JobResourceListPage struct {
	fn  func(JobResourceList) (JobResourceList, error)
	jrl JobResourceList
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobResourceListPage) Next() error {
	next, err := page.fn(page.jrl)
	if err != nil {
		return err
	}
	page.jrl = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobResourceListPage) NotDone() bool {
	return !page.jrl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobResourceListPage) Response() JobResourceList {
	return page.jrl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobResourceListPage) Values() []JobResource {
	if page.jrl.IsEmpty() {
		return nil
	}
	return *page.jrl.Value
}

// JobResourceUpdateParameter the JobResourceUpdateParameter.
type JobResourceUpdateParameter struct {
	// UpdateJobProperties - Properties of a job to be updated.
	*UpdateJobProperties `json:"properties,omitempty"`
	// Tags - The list of key value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups).
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for JobResourceUpdateParameter.
func (jrup JobResourceUpdateParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jrup.UpdateJobProperties != nil {
		objectMap["properties"] = jrup.UpdateJobProperties
	}
	if jrup.Tags != nil {
		objectMap["tags"] = jrup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for JobResourceUpdateParameter struct.
func (jrup *JobResourceUpdateParameter) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var updateJobProperties UpdateJobProperties
				err = json.Unmarshal(*v, &updateJobProperties)
				if err != nil {
					return err
				}
				jrup.UpdateJobProperties = &updateJobProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				jrup.Tags = tags
			}
		}
	}

	return nil
}

// JobsCreateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type JobsCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *JobsCreateFuture) Result(client JobsClient) (jr JobResource, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databox.JobsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("databox.JobsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if jr.Response.Response, err = future.GetResult(sender); err == nil && jr.Response.Response.StatusCode != http.StatusNoContent {
		jr, err = client.CreateResponder(jr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "databox.JobsCreateFuture", "Result", jr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// BasicJobSecrets the base class for the secrets
type BasicJobSecrets interface {
	AsCabinetJobSecrets() (*CabinetJobSecrets, bool)
	AsDiskJobSecrets() (*DiskJobSecrets, bool)
	AsPodJobSecrets() (*PodJobSecrets, bool)
	AsJobSecrets() (*JobSecrets, bool)
}

// JobSecrets the base class for the secrets
type JobSecrets struct {
	// JobSecretsType - Possible values include: 'JobSecretsTypeJobSecrets', 'JobSecretsTypeCabinet', 'JobSecretsTypeDisk', 'JobSecretsTypePod'
	JobSecretsType JobSecretsType `json:"jobSecretsType,omitempty"`
}

func unmarshalBasicJobSecrets(body []byte) (BasicJobSecrets, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["jobSecretsType"] {
	case string(JobSecretsTypeCabinet):
		var cjs CabinetJobSecrets
		err := json.Unmarshal(body, &cjs)
		return cjs, err
	case string(JobSecretsTypeDisk):
		var djs DiskJobSecrets
		err := json.Unmarshal(body, &djs)
		return djs, err
	case string(JobSecretsTypePod):
		var pjs PodJobSecrets
		err := json.Unmarshal(body, &pjs)
		return pjs, err
	default:
		var js JobSecrets
		err := json.Unmarshal(body, &js)
		return js, err
	}
}
func unmarshalBasicJobSecretsArray(body []byte) ([]BasicJobSecrets, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	jsArray := make([]BasicJobSecrets, len(rawMessages))

	for index, rawMessage := range rawMessages {
		js, err := unmarshalBasicJobSecrets(*rawMessage)
		if err != nil {
			return nil, err
		}
		jsArray[index] = js
	}
	return jsArray, nil
}

// MarshalJSON is the custom marshaler for JobSecrets.
func (js JobSecrets) MarshalJSON() ([]byte, error) {
	js.JobSecretsType = JobSecretsTypeJobSecrets
	objectMap := make(map[string]interface{})
	if js.JobSecretsType != "" {
		objectMap["jobSecretsType"] = js.JobSecretsType
	}
	return json.Marshal(objectMap)
}

// AsCabinetJobSecrets is the BasicJobSecrets implementation for JobSecrets.
func (js JobSecrets) AsCabinetJobSecrets() (*CabinetJobSecrets, bool) {
	return nil, false
}

// AsDiskJobSecrets is the BasicJobSecrets implementation for JobSecrets.
func (js JobSecrets) AsDiskJobSecrets() (*DiskJobSecrets, bool) {
	return nil, false
}

// AsPodJobSecrets is the BasicJobSecrets implementation for JobSecrets.
func (js JobSecrets) AsPodJobSecrets() (*PodJobSecrets, bool) {
	return nil, false
}

// AsJobSecrets is the BasicJobSecrets implementation for JobSecrets.
func (js JobSecrets) AsJobSecrets() (*JobSecrets, bool) {
	return &js, true
}

// AsBasicJobSecrets is the BasicJobSecrets implementation for JobSecrets.
func (js JobSecrets) AsBasicJobSecrets() (BasicJobSecrets, bool) {
	return &js, true
}

// JobStages job stages.
type JobStages struct {
	// StageName - Name of the job stage. Possible values include: 'StageNameDeviceOrdered', 'StageNameDevicePrepared', 'StageNameDispatched', 'StageNameDelivered', 'StageNamePickedUp', 'StageNameAtAzureDC', 'StageNameDataCopy', 'StageNameCompleted', 'StageNameCompletedWithErrors', 'StageNameCancelled', 'StageNameFailedIssueReportedAtCustomer', 'StageNameFailedIssueDetectedAtAzureDC', 'StageNameAborted'
	StageName StageName `json:"stageName,omitempty"`
	// DisplayName - Display name of the job stage.
	DisplayName *string `json:"displayName,omitempty"`
	// StageStatus - Status of the job stage. Possible values include: 'StageStatusNone', 'StageStatusInProgress', 'StageStatusSucceeded', 'StageStatusFailed', 'StageStatusCancelled', 'StageStatusCancelling', 'StageStatusSucceededWithErrors'
	StageStatus StageStatus `json:"stageStatus,omitempty"`
	// StageTime - Time for the job stage in UTC ISO 8601 format.
	StageTime *date.Time `json:"stageTime,omitempty"`
	// JobStageDetails - Job Stage Details
	JobStageDetails interface{} `json:"jobStageDetails,omitempty"`
	// ErrorDetails - Error details for the stage.
	ErrorDetails *[]JobErrorDetails `json:"errorDetails,omitempty"`
}

// JobsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type JobsUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *JobsUpdateFuture) Result(client JobsClient) (jr JobResource, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databox.JobsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("databox.JobsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if jr.Response.Response, err = future.GetResult(sender); err == nil && jr.Response.Response.StatusCode != http.StatusNoContent {
		jr, err = client.UpdateResponder(jr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "databox.JobsUpdateFuture", "Result", jr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// NotificationPreference notification preference for a job stage.
type NotificationPreference struct {
	// StageName - Name of the stage. Possible values include: 'DevicePrepared', 'Dispatched', 'Delivered', 'PickedUp', 'AtAzureDC', 'DataCopy'
	StageName NotificationStageName `json:"stageName,omitempty"`
	// SendNotification - Notification is required or not.
	SendNotification *bool `json:"sendNotification,omitempty"`
}

// Operation operation entity.
type Operation struct {
	// Name - Name of the operation. Format: {resourceProviderNamespace}/{resourceType}/{read|write|delete|action}
	Name *string `json:"name,omitempty"`
	// Display - Operation display values.
	Display *OperationDisplay `json:"display,omitempty"`
	// Properties - Operation properties.
	Properties interface{} `json:"properties,omitempty"`
	// Origin - Origin of the operation. Can be : user|system|user,system
	Origin *string `json:"origin,omitempty"`
}

// OperationDisplay operation display
type OperationDisplay struct {
	// Provider - Provider name.
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource name.
	Resource *string `json:"resource,omitempty"`
	// Operation - Localized name of the operation for display purpose.
	Operation *string `json:"operation,omitempty"`
	// Description - Localized description of the operation for display purpose.
	Description *string `json:"description,omitempty"`
}

// OperationList operation Collection.
type OperationList struct {
	autorest.Response `json:"-"`
	// Value - List of operations.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - Link for the next set of operations.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListIterator provides access to a complete listing of Operation values.
type OperationListIterator struct {
	i    int
	page OperationListPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListIterator) Response() OperationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (ol OperationList) IsEmpty() bool {
	return ol.Value == nil || len(*ol.Value) == 0
}

// operationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ol OperationList) operationListPreparer() (*http.Request, error) {
	if ol.NextLink == nil || len(to.String(ol.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ol.NextLink)))
}

// OperationListPage contains a page of Operation values.
type OperationListPage struct {
	fn func(OperationList) (OperationList, error)
	ol OperationList
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListPage) Next() error {
	next, err := page.fn(page.ol)
	if err != nil {
		return err
	}
	page.ol = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListPage) NotDone() bool {
	return !page.ol.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListPage) Response() OperationList {
	return page.ol
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListPage) Values() []Operation {
	if page.ol.IsEmpty() {
		return nil
	}
	return *page.ol.Value
}

// PackageShippingDetails shipping details.
type PackageShippingDetails struct {
	// CarrierName - Name of the carrier.
	CarrierName *string `json:"carrierName,omitempty"`
	// TrackingID - Tracking Id of shipment.
	TrackingID *string `json:"trackingId,omitempty"`
	// TrackingURL - Url where shipment can be tracked.
	TrackingURL *string `json:"trackingUrl,omitempty"`
}

// PodJobDetails pod Job Details
type PodJobDetails struct {
	// CopyProgress - Copy progress per account.
	CopyProgress *[]CopyProgress `json:"copyProgress,omitempty"`
	// ExpectedDataSizeInTeraBytes - The expected size of the data, which needs to be transfered in this job, in tera bytes.
	ExpectedDataSizeInTeraBytes *int32 `json:"expectedDataSizeInTeraBytes,omitempty"`
	// JobStages - List of stages that run in the job.
	JobStages *[]JobStages `json:"jobStages,omitempty"`
	// ContactDetails - Contact details for notification and shipping.
	ContactDetails *ContactDetails `json:"contactDetails,omitempty"`
	// ShippingAddress - Shipping address of the customer.
	ShippingAddress *ShippingAddress `json:"shippingAddress,omitempty"`
	// ErrorDetails - Error details for failure. This is optional.
	ErrorDetails *[]JobErrorDetails `json:"errorDetails,omitempty"`
	// JobDetailsType - Possible values include: 'JobDetailsTypeJobDetails', 'JobDetailsTypeDisk', 'JobDetailsTypePod'
	JobDetailsType JobDetailsType `json:"jobDetailsType,omitempty"`
}

// MarshalJSON is the custom marshaler for PodJobDetails.
func (pjd PodJobDetails) MarshalJSON() ([]byte, error) {
	pjd.JobDetailsType = JobDetailsTypePod
	objectMap := make(map[string]interface{})
	if pjd.CopyProgress != nil {
		objectMap["copyProgress"] = pjd.CopyProgress
	}
	if pjd.ExpectedDataSizeInTeraBytes != nil {
		objectMap["expectedDataSizeInTeraBytes"] = pjd.ExpectedDataSizeInTeraBytes
	}
	if pjd.JobStages != nil {
		objectMap["jobStages"] = pjd.JobStages
	}
	if pjd.ContactDetails != nil {
		objectMap["contactDetails"] = pjd.ContactDetails
	}
	if pjd.ShippingAddress != nil {
		objectMap["shippingAddress"] = pjd.ShippingAddress
	}
	if pjd.ErrorDetails != nil {
		objectMap["errorDetails"] = pjd.ErrorDetails
	}
	if pjd.JobDetailsType != "" {
		objectMap["jobDetailsType"] = pjd.JobDetailsType
	}
	return json.Marshal(objectMap)
}

// AsDiskJobDetails is the BasicJobDetails implementation for PodJobDetails.
func (pjd PodJobDetails) AsDiskJobDetails() (*DiskJobDetails, bool) {
	return nil, false
}

// AsPodJobDetails is the BasicJobDetails implementation for PodJobDetails.
func (pjd PodJobDetails) AsPodJobDetails() (*PodJobDetails, bool) {
	return &pjd, true
}

// AsJobDetails is the BasicJobDetails implementation for PodJobDetails.
func (pjd PodJobDetails) AsJobDetails() (*JobDetails, bool) {
	return nil, false
}

// AsBasicJobDetails is the BasicJobDetails implementation for PodJobDetails.
func (pjd PodJobDetails) AsBasicJobDetails() (BasicJobDetails, bool) {
	return &pjd, true
}

// PodJobSecrets the secrets related to a pod job.
type PodJobSecrets struct {
	// PodSecrets - Contains the list of secret objects for a job.
	PodSecrets *[]PodSecret `json:"podSecrets,omitempty"`
	// JobSecretsType - Possible values include: 'JobSecretsTypeJobSecrets', 'JobSecretsTypeCabinet', 'JobSecretsTypeDisk', 'JobSecretsTypePod'
	JobSecretsType JobSecretsType `json:"jobSecretsType,omitempty"`
}

// MarshalJSON is the custom marshaler for PodJobSecrets.
func (pjs PodJobSecrets) MarshalJSON() ([]byte, error) {
	pjs.JobSecretsType = JobSecretsTypePod
	objectMap := make(map[string]interface{})
	if pjs.PodSecrets != nil {
		objectMap["podSecrets"] = pjs.PodSecrets
	}
	if pjs.JobSecretsType != "" {
		objectMap["jobSecretsType"] = pjs.JobSecretsType
	}
	return json.Marshal(objectMap)
}

// AsCabinetJobSecrets is the BasicJobSecrets implementation for PodJobSecrets.
func (pjs PodJobSecrets) AsCabinetJobSecrets() (*CabinetJobSecrets, bool) {
	return nil, false
}

// AsDiskJobSecrets is the BasicJobSecrets implementation for PodJobSecrets.
func (pjs PodJobSecrets) AsDiskJobSecrets() (*DiskJobSecrets, bool) {
	return nil, false
}

// AsPodJobSecrets is the BasicJobSecrets implementation for PodJobSecrets.
func (pjs PodJobSecrets) AsPodJobSecrets() (*PodJobSecrets, bool) {
	return &pjs, true
}

// AsJobSecrets is the BasicJobSecrets implementation for PodJobSecrets.
func (pjs PodJobSecrets) AsJobSecrets() (*JobSecrets, bool) {
	return nil, false
}

// AsBasicJobSecrets is the BasicJobSecrets implementation for PodJobSecrets.
func (pjs PodJobSecrets) AsBasicJobSecrets() (BasicJobSecrets, bool) {
	return &pjs, true
}

// PodSecret the secrets related to a Pod.
type PodSecret struct {
	// DeviceSerialNumber - Serial number of the assigned device.
	DeviceSerialNumber *string `json:"deviceSerialNumber,omitempty"`
	// DevicePassword - Password for out of the box experience on device.
	DevicePassword *string `json:"devicePassword,omitempty"`
	// AccountCredentialDetails - Per account level access credentials.
	AccountCredentialDetails *[]AccountCredentialDetails `json:"accountCredentialDetails,omitempty"`
}

// ReportIssueDetails details of the reported issue.
type ReportIssueDetails struct {
	// IssueType - Issue Type. Possible values include: 'DeviceMismatch', 'ValidationStringMismatch', 'CredentialNotWorking', 'DeviceFailure'
	IssueType IssueType `json:"issueType,omitempty"`
	// DeviceIssueType - Device Issue Type. Only used for Device failure issue. Possible values include: 'DeviceTampering', 'DeviceNotBootingUp', 'DeviceHealthCheckShowFailures', 'NICsAreNotWorking', 'Misc'
	DeviceIssueType DeviceIssueType `json:"deviceIssueType,omitempty"`
}

// Resource model of the Resource.
type Resource struct {
	// Location - The location of the resource. This will be one of the supported and registered Azure Regions (e.g. West US, East US, Southeast Asia, etc.). The region of a resource cannot be changed once it is created, but if an identical region is specified on update the request will succeed.
	Location *string `json:"location,omitempty"`
	// Tags - The list of key value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups).
	Tags map[string]*string `json:"tags"`
	// Sku - The sku type.
	Sku *Sku `json:"sku,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	if r.Sku != nil {
		objectMap["sku"] = r.Sku
	}
	return json.Marshal(objectMap)
}

// ShareCredentialDetails credential details of the shares in account.
type ShareCredentialDetails struct {
	// ShareName - Name of the share.
	ShareName *string `json:"shareName,omitempty"`
	// UserName - User name for the share.
	UserName *string `json:"userName,omitempty"`
	// Password - Password for the share.
	Password *string `json:"password,omitempty"`
}

// ShipmentPickUpRequest shipment pick up request details.
type ShipmentPickUpRequest struct {
	// StartTime - Minimum date after which the pick up should commence, this must be in local time of pick up area.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Maximum date before which the pick up should commence, this must be in local time of pick up area.
	EndTime *date.Time `json:"endTime,omitempty"`
	// ShipmentLocation - Shipment Location in the pickup place. Eg.front desk
	ShipmentLocation *string `json:"shipmentLocation,omitempty"`
}

// ShipmentPickUpResponse shipment pick up response.
type ShipmentPickUpResponse struct {
	autorest.Response `json:"-"`
	// ConfirmationNumber - Confirmation number for the pick up request.
	ConfirmationNumber *string `json:"confirmationNumber,omitempty"`
	// ReadyByTime - Time by which shipment should be ready for pick up, this is in local time of pick up area.
	ReadyByTime *date.Time `json:"readyByTime,omitempty"`
}

// ShippingAddress shipping address where customer wishes to receive the device.
type ShippingAddress struct {
	// StreetAddress1 - Street Address line 1.
	StreetAddress1 *string `json:"streetAddress1,omitempty"`
	// StreetAddress2 - Street Address line 2.
	StreetAddress2 *string `json:"streetAddress2,omitempty"`
	// StreetAddress3 - Street Address line 3.
	StreetAddress3 *string `json:"streetAddress3,omitempty"`
	// City - Name of the City.
	City *string `json:"city,omitempty"`
	// StateOrProvince - Name of the State or Province.
	StateOrProvince *string `json:"stateOrProvince,omitempty"`
	// Country - Name of the Country.
	Country *string `json:"country,omitempty"`
	// PostalCode - Postal code.
	PostalCode *string `json:"postalCode,omitempty"`
	// ZipExtendedCode - Extended Zip Code.
	ZipExtendedCode *string `json:"zipExtendedCode,omitempty"`
	// CompanyName - Name of the company.
	CompanyName *string `json:"companyName,omitempty"`
	// AddressType - Type of address. Possible values include: 'None', 'Residential', 'Commercial'
	AddressType AddressType `json:"addressType,omitempty"`
}

// ShippingLabelDetails details for the shipping label.
type ShippingLabelDetails struct {
	autorest.Response `json:"-"`
	// ShippingLabelSasURI - Sas uri for accessing the shipping label.
	ShippingLabelSasURI *string `json:"shippingLabelSasUri,omitempty"`
}

// Sku the Sku.
type Sku struct {
	// Name - The sku name.
	Name *string `json:"name,omitempty"`
	// DisplayName - The display name of the sku.
	DisplayName *string `json:"displayName,omitempty"`
	// Family - The sku family.
	Family *string `json:"family,omitempty"`
}

// SkuCapacity capacity of the sku.
type SkuCapacity struct {
	// Usable - Usable capacity in TB.
	Usable *string `json:"usable,omitempty"`
	// Maximum - Maximum capacity in TB.
	Maximum *string `json:"maximum,omitempty"`
}

// SkuCost describes metadata for retrieving price info.
type SkuCost struct {
	// MeterID - Meter id of the Sku.
	MeterID *string `json:"meterId,omitempty"`
	// MeterType - The type of the meter.
	MeterType *string `json:"meterType,omitempty"`
}

// SkuInformation information of the sku.
type SkuInformation struct {
	// Sku - The Sku.
	Sku *Sku `json:"sku,omitempty"`
	// Enabled - The sku is enabled or not.
	Enabled *bool `json:"enabled,omitempty"`
	// SkuProperties - Properties of the sku.
	*SkuProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for SkuInformation.
func (si SkuInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if si.Sku != nil {
		objectMap["sku"] = si.Sku
	}
	if si.Enabled != nil {
		objectMap["enabled"] = si.Enabled
	}
	if si.SkuProperties != nil {
		objectMap["properties"] = si.SkuProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SkuInformation struct.
func (si *SkuInformation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				si.Sku = &sku
			}
		case "enabled":
			if v != nil {
				var enabled bool
				err = json.Unmarshal(*v, &enabled)
				if err != nil {
					return err
				}
				si.Enabled = &enabled
			}
		case "properties":
			if v != nil {
				var skuProperties SkuProperties
				err = json.Unmarshal(*v, &skuProperties)
				if err != nil {
					return err
				}
				si.SkuProperties = &skuProperties
			}
		}
	}

	return nil
}

// SkuProperties properties of the sku.
type SkuProperties struct {
	// DestinationToServiceLocationMap - The map of destination location to service location.
	DestinationToServiceLocationMap *[]DestinationToServiceLocationMap `json:"destinationToServiceLocationMap,omitempty"`
	// Capacity - Capacity of the Sku.
	Capacity *SkuCapacity `json:"capacity,omitempty"`
	// Costs - Cost of the Sku.
	Costs *[]SkuCost `json:"costs,omitempty"`
	// APIVersions - Api versions that support this Sku.
	APIVersions *[]string `json:"apiVersions,omitempty"`
	// DisabledReason - Reason why the Sku is disabled.
	DisabledReason *string `json:"disabledReason,omitempty"`
}

// UnencryptedSecrets unencrypted secrets for accessing device.
type UnencryptedSecrets struct {
	autorest.Response `json:"-"`
	// JobName - Name of the job.
	JobName *string `json:"jobName,omitempty"`
	// DeviceType - The Device Type used in the job. Possible values include: 'Pod', 'Disk', 'Cabinet'
	DeviceType DeviceType `json:"deviceType,omitempty"`
	// JobSecrets - Secrets related to this job.
	JobSecrets BasicJobSecrets `json:"jobSecrets,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for UnencryptedSecrets struct.
func (us *UnencryptedSecrets) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "jobName":
			if v != nil {
				var jobName string
				err = json.Unmarshal(*v, &jobName)
				if err != nil {
					return err
				}
				us.JobName = &jobName
			}
		case "deviceType":
			if v != nil {
				var deviceType DeviceType
				err = json.Unmarshal(*v, &deviceType)
				if err != nil {
					return err
				}
				us.DeviceType = deviceType
			}
		case "jobSecrets":
			if v != nil {
				jobSecrets, err := unmarshalBasicJobSecrets(*v)
				if err != nil {
					return err
				}
				us.JobSecrets = jobSecrets
			}
		}
	}

	return nil
}

// UpdateJobDetails job details for update.
type UpdateJobDetails struct {
	// ContactDetails - Contact details for notification and shipping.
	ContactDetails *ContactDetails `json:"contactDetails,omitempty"`
	// ShippingAddress - Shipping address of the customer.
	ShippingAddress *ShippingAddress `json:"shippingAddress,omitempty"`
}

// UpdateJobProperties job Properties for update
type UpdateJobProperties struct {
	// Details - Details of a job to be updated.
	Details *UpdateJobDetails `json:"details,omitempty"`
}

// ValidateAddress the requirements to validate customer address where the device needs to be shipped.
type ValidateAddress struct {
	// ShippingAddress - Shipping address of the customer.
	ShippingAddress *ShippingAddress `json:"shippingAddress,omitempty"`
	// DeviceType - Device type to be used for the job. Possible values include: 'Pod', 'Disk', 'Cabinet'
	DeviceType DeviceType `json:"deviceType,omitempty"`
}
