package insights

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"net/http"
)

// FavoritesClient is the composite Swagger for Application Insights Management Client
type FavoritesClient struct {
	BaseClient
}

// NewFavoritesClient creates an instance of the FavoritesClient client.
func NewFavoritesClient(subscriptionID string) FavoritesClient {
	return NewFavoritesClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewFavoritesClientWithBaseURI creates an instance of the FavoritesClient client.
func NewFavoritesClientWithBaseURI(baseURI string, subscriptionID string) FavoritesClient {
	return FavoritesClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// List gets a list of favorites defined within an Application Insights component.
// Parameters:
// resourceGroupName - the name of the resource group.
// resourceName - the name of the Application Insights component resource.
// favoriteType - the type of favorite. Value can be either shared or user.
// sourceType - source type of favorite to return. When left out, the source type defaults to 'other' (not
// present in this enum).
// canFetchContent - flag indicating whether or not to return the full content for each applicable favorite. If
// false, only return summary content for favorites.
// tags - tags that must be present on each favorite returned.
func (client FavoritesClient) List(ctx context.Context, resourceGroupName string, resourceName string, favoriteType FavoriteType, sourceType FavoriteSourceType, canFetchContent *bool, tags []string) (result ListApplicationInsightsComponentFavorite, err error) {
	req, err := client.ListPreparer(ctx, resourceGroupName, resourceName, favoriteType, sourceType, canFetchContent, tags)
	if err != nil {
		err = autorest.NewErrorWithError(err, "insights.FavoritesClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "insights.FavoritesClient", "List", resp, "Failure sending request")
		return
	}

	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "insights.FavoritesClient", "List", resp, "Failure responding to request")
	}

	return
}

// ListPreparer prepares the List request.
func (client FavoritesClient) ListPreparer(ctx context.Context, resourceGroupName string, resourceName string, favoriteType FavoriteType, sourceType FavoriteSourceType, canFetchContent *bool, tags []string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"resourceName":      autorest.Encode("path", resourceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-05-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(string(favoriteType)) > 0 {
		queryParameters["favoriteType"] = autorest.Encode("query", favoriteType)
	} else {
		queryParameters["favoriteType"] = autorest.Encode("query", "shared")
	}
	if len(string(sourceType)) > 0 {
		queryParameters["sourceType"] = autorest.Encode("query", sourceType)
	}
	if canFetchContent != nil {
		queryParameters["canFetchContent"] = autorest.Encode("query", *canFetchContent)
	}
	if tags != nil && len(tags) > 0 {
		queryParameters["tags"] = autorest.Encode("query", tags, ",")
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/favorites", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client FavoritesClient) ListSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client FavoritesClient) ListResponder(resp *http.Response) (result ListApplicationInsightsComponentFavorite, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
