/* 
    TowBowlTactics: Strategy game for X11

    Copyright (C) 2001 Pascal Bourut (toweld@rocketmail.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "dir_func.h"

team_list_t *get_team_list(const char* dirname){

	team_list_t *team_list = (team_list_t*) malloc(sizeof(team_list_t));
	team_list->nb = 0;
	char full_path[256];
	team_summary_t* sum;
	char* elm;
	DIR *dirp = opendir(dirname);
	dirent *dp;
	while ((dp = readdir(dirp)) != NULL){
		elm = strstr(dp->d_name,".xml");
		if( elm != NULL && strlen(elm) == strlen(".xml") ){
			DEBUG ( printf("Fichier xml : %s ", dp->d_name); );
			
			sprintf(full_path,"%s/%s",dirname, dp->d_name);
			sum = xml_load_team_summary(full_path);
			if(sum){
				DEBUG ( printf(" => accepted.\n",dp->d_name); );	
				team_list->teams[team_list->nb] = sum;
				team_list->nb++;
			}
			DEBUG ( else printf(" => refused.\n",dp->d_name); );
		}
	}
	closedir(dirp);
	return (team_list->nb>0)?(team_list):(NULL);
}


