/*******************************************************************************
 * Copyright (c) Contributors to the Eclipse Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-License-Identifier: Apache-2.0 
 *******************************************************************************/

package org.osgi.service.zigbee;

import java.math.BigInteger;

/**
 * This interface represents events generated by a ZigBee Device node.
 * 
 * @author $Id: 8e8eb5867bb1b3eb462f221539d37d25c1a23d41 $
 */
public interface ZigBeeEvent {

	/**
	 * Returns the ZigBee device node IEEE Address.
	 * 
	 * @return the ZigBee device node IEEE Address.
	 */
	public BigInteger getIEEEAddress();

	/**
	 * Returns the endpoint identifier.
	 * 
	 * @return the endpoint identifier.
	 */
	public short getEndpointId();

	/**
	 * Returns the cluster id associated to this ZigBeeEvent.
	 * 
	 * @return the cluster id.
	 */
	public int getClusterId();

	/**
	 * Returns the attribute identifier (that is, the attribute's ID).
	 * 
	 * @return the attribute identifier (that is, the attribute's ID).
	 */
	public int getAttributeId();

	/**
	 * Returns an object containing the new value of the related ZigBee
	 * attribute.
	 * 
	 * @return an object containing the new value for the ZigBee attribute that
	 *         has changed.
	 */
	public Object getValue();

}
