/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.fileEditors;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorComposite;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorWithProvider;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.FileEditorOpenOptions;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImplKt;
import com.intellij.openapi.progress.Cancellation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ide.diagnostic.startUpPerformanceReporter.FUSProjectHotStartUpMeasurer;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.util.containers.CollectionFactory;
import com.jetbrains.ide.model.uiautomation.BeControl;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.framework.IRdCall;
import com.jetbrains.rd.framework.impl.RpcTimeouts;
import com.jetbrains.rd.ide.editor.UtilKt;
import com.jetbrains.rd.ide.model.FileEditorCompositeModel;
import com.jetbrains.rd.ide.model.FileEditorIdAndModel;
import com.jetbrains.rd.ide.model.FileEditorManagerEventModel;
import com.jetbrains.rd.ide.model.FileEditorModel;
import com.jetbrains.rd.ide.model.FileEditorsModel;
import com.jetbrains.rd.ide.model.FileEditorsModel_GeneratedKt;
import com.jetbrains.rd.ide.model.OpenModeModel;
import com.jetbrains.rd.ide.model.OpenWithFocusRequest;
import com.jetbrains.rd.ide.model.OriginKind;
import com.jetbrains.rd.ide.model.RdFileEditorCompositeId;
import com.jetbrains.rd.ide.model.RdFileEditorId;
import com.jetbrains.rd.ide.model.RdFileId;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.ide.model.TopBottomComponentUpdate;
import com.jetbrains.rd.ide.model.TopBottomComponentUpdateType;
import com.jetbrains.rd.platform.util.ReenterabilityKt;
import com.jetbrains.rd.platform.util.UserDataHolderKt;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.protocol.SolutionExtListener;
import com.jetbrains.rd.ui.bedsl.extensions.LocalChangeKt;
import com.jetbrains.rd.ui.bedsl.extensions.UpdateFlag;
import com.jetbrains.rd.ui.bindable.UtilsKt;
import com.jetbrains.rd.ui.bindable.ViewRegistryKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.IViewableList;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rdclient.document.FrontendDocumentHost;
import com.jetbrains.rdclient.editors.FrontendTextControlHost;
import com.jetbrains.rdclient.fileEditors.FrontendFileEditorHost;
import com.jetbrains.rdclient.fileEditors.FrontendFileEditorManager;
import com.jetbrains.rdclient.fileEditors.FrontendFileEditorModelHandler;
import com.jetbrains.rdclient.fileEditors.FrontendTextFileEditor;
import com.jetbrains.rdclient.services.IdeBackend;
import com.jetbrains.rdclient.util.idea.ExtensionsKt;
import com.jetbrains.rdclient.vfs.FrontendVirtualFileManager;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference2;
import kotlin.jvm.internal.MutablePropertyReference2Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 E2\u00020\u0001:\u0004EFGHB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002JR\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020#2\u0006\u0010(\u001a\u00020#H\u0002J(\u0010)\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020\bH\u0002J(\u0010,\u001a\u00020-2\u0006\u0010 \u001a\u00020!2\u0006\u0010.\u001a\u00020\u001c2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0002J(\u00103\u001a\u00020\u00162\u0006\u0010.\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020\b2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000202H\u0002J8\u00107\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020\b2\u0006\u00104\u001a\u0002052\u0006\u00108\u001a\u00020\u00122\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020#H\u0002J(\u0010<\u001a\u00020\u00162\u0006\u0010+\u001a\u00020\b2\u0006\u00104\u001a\u0002052\u0006\u00108\u001a\u00020\u00122\u0006\u0010;\u001a\u00020#H\u0002J\u0010\u0010?\u001a\u00020\u00162\u0006\u0010@\u001a\u00020AH\u0002J\u0018\u0010B\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010C\u001a\u00020DR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R3\u0010\u0006\u001a'\u0012\u000e\u0012\f0\b\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\b\n\u0012\u000e\u0012\f0\u000b\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\b\n0\u0007\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020>X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lcom/jetbrains/rdclient/fileEditors/FrontendFileEditorHost;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "<init>", "(Lcom/intellij/openapi/client/ClientProjectSession;)V", "compositeToId", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/openapi/fileEditor/impl/EditorComposite;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "Lcom/jetbrains/rd/ide/model/RdFileEditorCompositeId;", "fileEditorsModel", "Lcom/jetbrains/rd/ide/model/FileEditorsModel;", "getFileEditorsModel", "()Lcom/jetbrains/rd/ide/model/FileEditorsModel;", "topComponentsStorage", "", "", "Lcom/jetbrains/rdclient/fileEditors/FrontendFileEditorHost$ComponentInfo;", "bottomComponentsStorage", "closeFileWithCopies", "", "fileId", "Lcom/jetbrains/rd/ide/model/RdFileId;", "openComposite", "Lcom/intellij/openapi/fileEditor/FileEditorComposite;", "compositeModelLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "compositeId", "compositeModel", "Lcom/jetbrains/rd/ide/model/FileEditorCompositeModel;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "requestFocus", "", "selectAsCurrent", "openMode", "Lcom/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$OpenMode;", "isSingletonEditorInWindow", "isPinned", "bindComposite", "lifetime", "composite", "createEditorWithProvider", "Lcom/intellij/openapi/fileEditor/ex/FileEditorWithProvider;", "editorLifetime", "editorId", "Lcom/jetbrains/rd/ide/model/RdFileEditorId;", "editorModel", "Lcom/jetbrains/rd/ide/model/FileEditorModel;", "bindFileEditor", "editor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "model", "addComponent", "componentId", "beControl", "Lcom/jetbrains/ide/model/uiautomation/BeControl;", "isTop", "removeComponent", "selectionChange", "Lcom/jetbrains/rd/ui/bedsl/extensions/UpdateFlag;", "sendSelection", "eventModel", "Lcom/jetbrains/rd/ide/model/FileEditorManagerEventModel;", "requestCompositeFromBackendSync", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "MyProtocolListener", "MyFileEditorManagerListener", "ComponentInfo", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendFileEditorHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendFileEditorHost.kt\ncom/jetbrains/rdclient/fileEditors/FrontendFileEditorHost\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,339:1\n69#2,4:340\n69#2,4:344\n69#2,4:348\n69#2,4:355\n69#2,4:360\n69#2,4:364\n15#2:370\n1557#3:352\n1628#3,2:353\n1630#3:359\n13402#4,2:368\n*S KotlinDebug\n*F\n+ 1 FrontendFileEditorHost.kt\ncom/jetbrains/rdclient/fileEditors/FrontendFileEditorHost\n*L\n148#1:340,4\n178#1:344,4\n182#1:348,4\n184#1:355,4\n188#1:360,4\n198#1:364,4\n65#1:370\n183#1:352\n183#1:353,2\n183#1:359\n296#1:368,2\n*E\n"})
public final class FrontendFileEditorHost
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientProjectSession session;
    @NotNull
    private final ConcurrentMap<EditorComposite, RdFileEditorCompositeId> compositeToId;
    @NotNull
    private final Map<String, ComponentInfo> topComponentsStorage;
    @NotNull
    private final Map<String, ComponentInfo> bottomComponentsStorage;
    @NotNull
    private final UpdateFlag selectionChange;
    @NotNull
    private static final ReadWriteProperty<? super UserDataHolder, RdFileEditorId> fileEditorId$delegate = UserDataHolderKt.userData((String)"frontendModelId");
    @NotNull
    private static final Logger LOG;

    public FrontendFileEditorHost(@NotNull ClientProjectSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentWeakIdentityMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentWeakIdentityMap(...)");
        this.compositeToId = concurrentMap;
        this.topComponentsStorage = new LinkedHashMap();
        this.bottomComponentsStorage = new LinkedHashMap();
        this.selectionChange = new UpdateFlag();
    }

    private final FileEditorsModel getFileEditorsModel() {
        return FileEditorsModel_GeneratedKt.getFileEditorsModel((Solution)FrontendSessionsUtilKt.getProtocolModel(this.session));
    }

    private final void closeFileWithCopies(RdFileId fileId) {
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("[service] closeFileWithCopies: fileId=" + fileId);
        }
        VirtualFile virtualFile = FrontendVirtualFileManager.Companion.getInstance().getVirtualFile(fileId);
        if (virtualFile == null) {
            return;
        }
        VirtualFile file = virtualFile;
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.session.getProject());
        Intrinsics.checkNotNull((Object)fileEditorManager, (String)"null cannot be cast to non-null type com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl");
        FileEditorManagerImpl manager = (FileEditorManagerImpl)fileEditorManager;
        manager.closeFile(file, true, true);
    }

    /*
     * WARNING - void declaration
     */
    private final FileEditorComposite openComposite(Lifetime compositeModelLifetime, RdFileEditorCompositeId compositeId, FileEditorCompositeModel compositeModel, VirtualFile file, boolean requestFocus, boolean selectAsCurrent, FileEditorManagerImpl.OpenMode openMode, boolean isSingletonEditorInWindow, boolean isPinned) {
        void $this$mapTo$iv$iv;
        Object object;
        Object v0;
        FrontendFileEditorManager fileEditorManager;
        block8: {
            Project project = this.session.getProject();
            fileEditorManager = FrontendFileEditorManager.Companion.getInstance(project);
            List fileComposites = fileEditorManager.getAllComposites(file);
            Iterable iterable = fileComposites;
            for (Object t : iterable) {
                EditorComposite it = (EditorComposite)t;
                boolean bl = false;
                RdFileEditorCompositeId rdFileEditorCompositeId = (RdFileEditorCompositeId)this.compositeToId.get(it);
                if (!Intrinsics.areEqual((Object)rdFileEditorCompositeId, (Object)compositeId)) continue;
                v0 = t;
                break block8;
            }
            v0 = null;
        }
        EditorComposite existingComposite = v0;
        if (existingComposite != null) {
            EditorWindow editorWindow;
            block9: {
                EditorWindow[] editorWindowArray = fileEditorManager.getWindows();
                int it = editorWindowArray.length;
                for (int i = 0; i < it; ++i) {
                    EditorWindow bl;
                    EditorWindow it2 = bl = editorWindowArray[i];
                    boolean bl2 = false;
                    if (!SequencesKt.contains((Sequence)it2.composites(), (Object)existingComposite)) continue;
                    editorWindow = bl;
                    break block9;
                }
                editorWindow = null;
            }
            EditorWindow existingWindow = editorWindow;
            Logger $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("[file] openComposite: opening existing editor. file.name=" + file.getName() + ", compositeId=" + UtilKt.toDebugString((RdFileEditorCompositeId)compositeId));
            }
            return fileEditorManager.openFile(file, existingWindow, new FileEditorOpenOptions(false, false, false, requestFocus, false, 0, false, null, false, false, 1015, null));
        }
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            object = $this$trace$iv;
            boolean bl = false;
            object.trace("[file] openComposite: collect `editorsWithProviders` for " + compositeModel.getEditors().size() + " editors. file.name=" + file.getName() + ", compositeId=" + UtilKt.toDebugString((RdFileEditorCompositeId)compositeId));
        }
        Iterable $this$map$iv = compositeModel.getEditors();
        boolean $i$f$map = false;
        Iterable bl = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FileEditorIdAndModel fileEditorIdAndModel = (FileEditorIdAndModel)item$iv$iv;
            object = destination$iv$iv;
            boolean bl3 = false;
            Logger $this$trace$iv2 = LOG;
            boolean $i$f$trace2 = false;
            if ($this$trace$iv2.isTraceEnabled()) {
                Logger logger = $this$trace$iv2;
                boolean bl4 = false;
                logger.trace("[file] openComposite$map: call createEditorWithProvider(id=" + UtilKt.toDebugString((RdFileEditorId)it.getId()) + "))");
            }
            object.add(this.createEditorWithProvider(file, compositeModelLifetime, it.getId(), it.getModel()));
        }
        List editorsWithProviders = (List)destination$iv$iv;
        Logger $this$trace$iv3 = LOG;
        boolean $i$f$trace3 = false;
        if ($this$trace$iv3.isTraceEnabled()) {
            object = $this$trace$iv3;
            boolean bl5 = false;
            object.trace("[file] openComposite: call openFileFromBackend for collected `editorsWithProviders`");
        }
        return fileEditorManager.openFileFromBackend$intellij_rd_client(file, editorsWithProviders, requestFocus, selectAsCurrent, openMode, isSingletonEditorInWindow, isPinned, (Function1<? super EditorComposite, Unit>)((Function1)arg_0 -> FrontendFileEditorHost.openComposite$lambda$9(this, compositeModelLifetime, compositeId, compositeModel, arg_0)));
    }

    private final void bindComposite(Lifetime lifetime, RdFileEditorCompositeId compositeId, FileEditorCompositeModel compositeModel, EditorComposite composite) {
        this.compositeToId.put(composite, compositeId);
        lifetime.onTermination(() -> FrontendFileEditorHost.bindComposite$lambda$12(this, composite));
        Disposer.register((Disposable)((Disposable)composite), () -> FrontendFileEditorHost.bindComposite$lambda$13(this, compositeId));
        for (Pair pair : CollectionsKt.zip((Iterable)composite.getAllEditors(), (Iterable)compositeModel.getEditors())) {
            FileEditor editor = (FileEditor)pair.component1();
            FileEditorIdAndModel editorModel = (FileEditorIdAndModel)pair.component2();
            this.bindFileEditor(lifetime, composite, editor, editorModel.getModel());
        }
        compositeModel.getDynamicallyAddedEditors().getChange().advise(lifetime, arg_0 -> FrontendFileEditorHost.bindComposite$lambda$14(this, composite, lifetime, arg_0));
        composite.getComponent().addPropertyChangeListener(arg_0 -> FrontendFileEditorHost.bindComposite$lambda$15(compositeModel, arg_0));
        UtilsKt.showingProperty((Component)composite.getComponent()).advise(lifetime, arg_0 -> FrontendFileEditorHost.bindComposite$lambda$16(compositeModel, arg_0));
    }

    private final FileEditorWithProvider createEditorWithProvider(VirtualFile file, Lifetime editorLifetime, RdFileEditorId editorId, FileEditorModel editorModel) {
        Object object = FrontendFileEditorModelHandler.Companion.getEP().findFirstSafe(arg_0 -> FrontendFileEditorHost.createEditorWithProvider$lambda$18(arg_0 -> FrontendFileEditorHost.createEditorWithProvider$lambda$17(this, file, editorModel, arg_0), arg_0));
        Intrinsics.checkNotNull((Object)object);
        FrontendFileEditorModelHandler handler = (FrontendFileEditorModelHandler)object;
        FileEditorWithProvider editorWithProvider = handler.createEditorWithProvider(this.session.getProject(), editorLifetime, file, editorModel);
        FrontendFileEditorHost.Companion.setFileEditorId(editorWithProvider.getFileEditor(), editorId);
        editorLifetime.onTermination(() -> FrontendFileEditorHost.createEditorWithProvider$lambda$19(editorWithProvider));
        return editorWithProvider;
    }

    private final void bindFileEditor(Lifetime editorLifetime, EditorComposite composite, FileEditor editor, FileEditorModel model) {
        FileEditorModel fileEditorModel;
        FileEditorModel $this$bindFileEditor_u24lambda_u2425 = fileEditorModel = model;
        boolean bl = false;
        $this$bindFileEditor_u24lambda_u2425.getName().getChange().advise(editorLifetime, arg_0 -> FrontendFileEditorHost.bindFileEditor$lambda$25$lambda$20(composite, editor, arg_0));
        Function1 processUpdate2 = arg_0 -> FrontendFileEditorHost.bindFileEditor$lambda$25$lambda$22(this, composite, editor, editorLifetime, arg_0);
        $this$bindFileEditor_u24lambda_u2425.getTopBottomComponentsUpdates().view(editorLifetime, (arg_0, arg_1) -> FrontendFileEditorHost.bindFileEditor$lambda$25$lambda$24(processUpdate2, arg_0, arg_1));
    }

    private final void addComponent(Lifetime lifetime, EditorComposite composite, FileEditor editor, String componentId, BeControl beControl, boolean isTop) {
        LifetimeDefinition componentLifetime = lifetime.createNested();
        JComponent panel = ViewRegistryKt.getView((BeControl)beControl, (Lifetime)((Lifetime)componentLifetime));
        Map<String, ComponentInfo> storage = isTop ? this.topComponentsStorage : this.bottomComponentsStorage;
        storage.put(componentId, new ComponentInfo(panel, componentLifetime));
        EditorComposite $this$addComponent_u24lambda_u2426 = composite;
        boolean bl = false;
        if (isTop) {
            $this$addComponent_u24lambda_u2426.addTopComponent(editor, panel);
        } else {
            $this$addComponent_u24lambda_u2426.addBottomComponent(editor, panel);
        }
    }

    private final void removeComponent(EditorComposite composite, FileEditor editor, String componentId, boolean isTop) {
        Map<String, ComponentInfo> storage = isTop ? this.topComponentsStorage : this.bottomComponentsStorage;
        ComponentInfo componentInfo = storage.remove(componentId);
        if (componentInfo == null) {
            return;
        }
        ComponentInfo componentInfo2 = componentInfo;
        JComponent panel = componentInfo2.component1();
        LifetimeDefinition lifetime = componentInfo2.component2();
        EditorComposite $this$removeComponent_u24lambda_u2427 = composite;
        boolean bl = false;
        if (isTop) {
            $this$removeComponent_u24lambda_u2427.removeTopComponent(editor, panel);
        } else {
            $this$removeComponent_u24lambda_u2427.removeBottomComponent(editor, panel);
        }
        LifetimeDefinition.terminate$default((LifetimeDefinition)lifetime, (boolean)false, (int)1, null);
    }

    private final void sendSelection(FileEditorManagerEventModel eventModel) {
        LocalChangeKt.ignoreOnReentrancy((UpdateFlag)this.selectionChange, () -> FrontendFileEditorHost.sendSelection$lambda$28(this, eventModel));
    }

    @Nullable
    public final RdFileEditorCompositeId requestCompositeFromBackendSync(@NotNull RdFileId fileId, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        IProtocol protocol = IdeBackend.Companion.getInstance(project).getProtocol();
        return (RdFileEditorCompositeId)ExtensionsKt.callSynchronously$default((IRdCall)this.getFileEditorsModel().getRequestComposite(), fileId, protocol, null, RpcTimeouts.Companion.getDefault(), null, 20, null);
    }

    private static final Unit openComposite$lambda$9(FrontendFileEditorHost this$0, Lifetime $compositeModelLifetime, RdFileEditorCompositeId $compositeId, FileEditorCompositeModel $compositeModel, EditorComposite it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("[file] openComposite$openFileFromBackend: call bindComposite(...)");
        }
        this$0.bindComposite($compositeModelLifetime, $compositeId, $compositeModel, it);
        return Unit.INSTANCE;
    }

    private static final void bindComposite$lambda$12$lambda$11$lambda$10(FrontendFileEditorHost this$0, EditorComposite $composite) {
        FrontendFileEditorManager.Companion.getInstance(this$0.session.getProject()).closeFile$intellij_rd_client($composite);
    }

    private static final Unit bindComposite$lambda$12$lambda$11(FrontendFileEditorHost this$0, EditorComposite $composite) {
        Cancellation.executeInNonCancelableSection(() -> FrontendFileEditorHost.bindComposite$lambda$12$lambda$11$lambda$10(this$0, $composite));
        return Unit.INSTANCE;
    }

    private static final Unit bindComposite$lambda$12(FrontendFileEditorHost this$0, EditorComposite $composite) {
        this$0.compositeToId.remove($composite);
        if (!Disposer.isDisposed((Disposable)((Disposable)$composite))) {
            FrontendTextControlHost textControlHost = FrontendTextControlHost.Companion.getInstance(this$0.session.getAppSession());
            ReenterabilityKt.noReenter((Object)textControlHost.getEditorIsReleasingLock(), () -> FrontendFileEditorHost.bindComposite$lambda$12$lambda$11(this$0, $composite));
        }
        return Unit.INSTANCE;
    }

    private static final void bindComposite$lambda$13(FrontendFileEditorHost this$0, RdFileEditorCompositeId $compositeId) {
        this$0.getFileEditorsModel().getComposites().remove((Object)$compositeId);
    }

    private static final Unit bindComposite$lambda$14(FrontendFileEditorHost this$0, EditorComposite $composite, Lifetime $lifetime, IViewableList.Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!(event instanceof IViewableList.Event.Add)) {
            return Unit.INSTANCE;
        }
        RdFileEditorId editorId = ((FileEditorIdAndModel)((IViewableList.Event.Add)event).getNewValue()).getId();
        FileEditorModel editorModel = ((FileEditorIdAndModel)((IViewableList.Event.Add)event).getNewValue()).getModel();
        FileEditorWithProvider editorWithProvider = this$0.createEditorWithProvider($composite.getFile(), $lifetime, editorId, editorModel);
        FileEditor editor = editorWithProvider.getFileEditor();
        FileEditorProvider provider2 = editorWithProvider.getProvider();
        $composite.addEditor(editor, provider2);
        this$0.bindFileEditor($lifetime, $composite, editor, editorModel);
        return Unit.INSTANCE;
    }

    private static final void bindComposite$lambda$15(FileEditorCompositeModel $compositeModel, PropertyChangeEvent it) {
        if (Intrinsics.areEqual((Object)it.getPropertyName(), (Object)JBTabsImpl.PINNED.toString())) {
            Object object;
            $compositeModel.getPinned().set((Object)Intrinsics.areEqual((Object)((object = it.getNewValue()) instanceof Boolean ? (Boolean)object : null), (Object)true));
        }
    }

    private static final Unit bindComposite$lambda$16(FileEditorCompositeModel $compositeModel, boolean it) {
        $compositeModel.getVisible().set((Object)it);
        return Unit.INSTANCE;
    }

    private static final boolean createEditorWithProvider$lambda$17(FrontendFileEditorHost this$0, VirtualFile $file, FileEditorModel $editorModel, FrontendFileEditorModelHandler it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.accept(this$0.session.getProject(), $file, $editorModel);
    }

    private static final boolean createEditorWithProvider$lambda$18(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit createEditorWithProvider$lambda$19(FileEditorWithProvider $editorWithProvider) {
        FrontendFileEditorHost.Companion.setFileEditorId($editorWithProvider.getFileEditor(), null);
        return Unit.INSTANCE;
    }

    private static final Unit bindFileEditor$lambda$25$lambda$20(EditorComposite $composite, FileEditor $editor, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $composite.setDisplayName($editor, it);
        return Unit.INSTANCE;
    }

    private static final Object bindFileEditor$lambda$25$lambda$22(FrontendFileEditorHost this$0, EditorComposite $composite, FileEditor $editor, Lifetime $editorLifetime, TopBottomComponentUpdate update2) {
        Intrinsics.checkNotNullParameter((Object)update2, (String)"update");
        return switch (WhenMappings.$EnumSwitchMapping$0[update2.getUpdateType().ordinal()]) {
            case 1 -> {
                BeControl v0 = update2.getBeControl();
                if (v0 != null) {
                    BeControl var5_5;
                    BeControl beControl = var5_5 = v0;
                    boolean $i$a$-also-FrontendFileEditorHost$bindFileEditor$1$processUpdate$1$1 = false;
                    this$0.addComponent($editorLifetime, $composite, $editor, update2.getComponentId(), beControl, update2.isTop());
                    yield var5_5;
                }
                yield null;
            }
            case 2 -> {
                this$0.removeComponent($composite, $editor, update2.getComponentId(), update2.isTop());
                yield Unit.INSTANCE;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final Unit bindFileEditor$lambda$25$lambda$24(Function1 $processUpdate, Lifetime lifetime, TopBottomComponentUpdate[] updates) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)updates, (String)"updates");
        TopBottomComponentUpdate[] $this$forEach$iv = updates;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            TopBottomComponentUpdate element$iv;
            TopBottomComponentUpdate it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            $processUpdate.invoke((Object)it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit sendSelection$lambda$28(FrontendFileEditorHost this$0, FileEditorManagerEventModel $eventModel) {
        this$0.getFileEditorsModel().getSelectionChanged().fire((Object)$eventModel);
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FrontendFileEditorHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u000b*\u00020\u00132\u0006\u0010\n\u001a\u00020\tH\u0002R3\u0010\n\u001a\u0004\u0018\u00010\t*\u00020\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\t8F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rdclient/fileEditors/FrontendFileEditorHost$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rdclient/fileEditors/FrontendFileEditorHost;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "<set-?>", "Lcom/jetbrains/rd/ide/model/RdFileEditorId;", "fileEditorId", "Lcom/intellij/openapi/fileEditor/FileEditor;", "getFileEditorId", "(Lcom/intellij/openapi/fileEditor/FileEditor;)Lcom/jetbrains/rd/ide/model/RdFileEditorId;", "setFileEditorId", "(Lcom/intellij/openapi/fileEditor/FileEditor;Lcom/jetbrains/rd/ide/model/RdFileEditorId;)V", "fileEditorId$delegate", "Lkotlin/properties/ReadWriteProperty;", "getEditor", "Lcom/intellij/openapi/fileEditor/impl/EditorComposite;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.client"})
    @SourceDebugExtension(value={"SMAP\nFrontendFileEditorHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendFileEditorHost.kt\ncom/jetbrains/rdclient/fileEditors/FrontendFileEditorHost$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,339:1\n31#2,2:340\n1#3:342\n*S KotlinDebug\n*F\n+ 1 FrontendFileEditorHost.kt\ncom/jetbrains/rdclient/fileEditors/FrontendFileEditorHost$Companion\n*L\n56#1:340,2\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        @NotNull
        public final FrontendFileEditorHost getInstance(@NotNull ClientProjectSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            ComponentManager $this$service$iv = (ComponentManager)session;
            boolean $i$f$service = false;
            Class<FrontendFileEditorHost> serviceClass$iv = FrontendFileEditorHost.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (FrontendFileEditorHost)((Object)object);
        }

        @Nullable
        public final RdFileEditorId getFileEditorId(@NotNull FileEditor $this$fileEditorId) {
            Intrinsics.checkNotNullParameter((Object)$this$fileEditorId, (String)"<this>");
            return (RdFileEditorId)fileEditorId$delegate.getValue((Object)$this$fileEditorId, $$delegatedProperties[0]);
        }

        private final void setFileEditorId(FileEditor $this$fileEditorId, RdFileEditorId rdFileEditorId) {
            fileEditorId$delegate.setValue((Object)$this$fileEditorId, $$delegatedProperties[0], (Object)rdFileEditorId);
        }

        private final FileEditor getEditor(EditorComposite $this$getEditor, RdFileEditorId fileEditorId) {
            Object v0;
            block1: {
                Iterable iterable = $this$getEditor.getAllEditors();
                for (Object t : iterable) {
                    FileEditor it = (FileEditor)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)Companion.getFileEditorId(it), (Object)fileEditorId)) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty2((MutablePropertyReference2)((MutablePropertyReference2)new MutablePropertyReference2Impl(Companion.class, "fileEditorId", "getFileEditorId(Lcom/intellij/openapi/fileEditor/FileEditor;)Lcom/jetbrains/rd/ide/model/RdFileEditorId;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rdclient/fileEditors/FrontendFileEditorHost$ComponentInfo;", "", "component", "Ljavax/swing/JComponent;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "<init>", "(Ljavax/swing/JComponent;Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;)V", "getComponent", "()Ljavax/swing/JComponent;", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.rd.client"})
    private static final class ComponentInfo {
        @NotNull
        private final JComponent component;
        @NotNull
        private final LifetimeDefinition lifetime;

        public ComponentInfo(@NotNull JComponent component, @NotNull LifetimeDefinition lifetime) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            this.component = component;
            this.lifetime = lifetime;
        }

        @NotNull
        public final JComponent getComponent() {
            return this.component;
        }

        @NotNull
        public final LifetimeDefinition getLifetime() {
            return this.lifetime;
        }

        @NotNull
        public final JComponent component1() {
            return this.component;
        }

        @NotNull
        public final LifetimeDefinition component2() {
            return this.lifetime;
        }

        @NotNull
        public final ComponentInfo copy(@NotNull JComponent component, @NotNull LifetimeDefinition lifetime) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            return new ComponentInfo(component, lifetime);
        }

        public static /* synthetic */ ComponentInfo copy$default(ComponentInfo componentInfo, JComponent jComponent, LifetimeDefinition lifetimeDefinition, int n, Object object) {
            if ((n & 1) != 0) {
                jComponent = componentInfo.component;
            }
            if ((n & 2) != 0) {
                lifetimeDefinition = componentInfo.lifetime;
            }
            return componentInfo.copy(jComponent, lifetimeDefinition);
        }

        @NotNull
        public String toString() {
            return "ComponentInfo(component=" + this.component + ", lifetime=" + this.lifetime + ")";
        }

        public int hashCode() {
            int result2 = this.component.hashCode();
            result2 = result2 * 31 + this.lifetime.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ComponentInfo)) {
                return false;
            }
            ComponentInfo componentInfo = (ComponentInfo)other;
            if (!Intrinsics.areEqual((Object)this.component, (Object)componentInfo.component)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.lifetime, (Object)componentInfo.lifetime);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdclient/fileEditors/FrontendFileEditorHost$MyFileEditorManagerListener;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "<init>", "()V", "selectionChanged", "", "event", "Lcom/intellij/openapi/fileEditor/FileEditorManagerEvent;", "intellij.rd.client"})
    public static final class MyFileEditorManagerListener
    implements FileEditorManagerListener {
        public void selectionChanged(@NotNull FileEditorManagerEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            FileEditor fileEditor = event.getOldEditor();
            RdFileEditorId oldEditorId = fileEditor != null ? Companion.getFileEditorId(fileEditor) : null;
            FileEditor fileEditor2 = event.getNewEditor();
            RdFileEditorId newEditorId = fileEditor2 != null ? Companion.getFileEditorId(fileEditor2) : null;
            FileEditorManagerEventModel eventModel = new FileEditorManagerEventModel(OriginKind.Frontend, oldEditorId, newEditorId);
            Project project = event.getManager().getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Companion.getInstance(FrontendSessionsUtilKt.getFrontendProjectSession(project)).sendSelection(eventModel);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\f\u0010\f\u001a\u00020\r*\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rdclient/fileEditors/FrontendFileEditorHost$MyProtocolListener;", "Lcom/jetbrains/rd/protocol/SolutionExtListener;", "Lcom/jetbrains/rd/ide/model/FileEditorsModel;", "<init>", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "model", "fromModel", "Lcom/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$OpenMode;", "Lcom/jetbrains/rd/ide/model/OpenModeModel;", "intellij.rd.client"})
    @SourceDebugExtension(value={"SMAP\nFrontendFileEditorHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendFileEditorHost.kt\ncom/jetbrains/rdclient/fileEditors/FrontendFileEditorHost$MyProtocolListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,339:1\n69#2,4:340\n69#2,4:344\n69#2,4:348\n69#2,4:365\n808#3,11:352\n295#3,2:363\n*S KotlinDebug\n*F\n+ 1 FrontendFileEditorHost.kt\ncom/jetbrains/rdclient/fileEditors/FrontendFileEditorHost$MyProtocolListener\n*L\n77#1:340,4\n81#1:344,4\n125#1:348,4\n83#1:365,4\n102#1:352,11\n103#1:363,2\n*E\n"})
    public static final class MyProtocolListener
    implements SolutionExtListener<FileEditorsModel> {
        public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientProjectSession session, @NotNull FileEditorsModel model) {
            Logger logger;
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Logger $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("[service] MyProtocolListener$extensionCreated: before launchOnEdtAndStartImmediatelyIfEdt");
            }
            FrontendDocumentHost.Companion.getInstance(session.getAppSession()).ensureProtocolSubscriptionsReady();
            Ref.ObjectRef firstEditorOpened = new Ref.ObjectRef();
            firstEditorOpened.element = new AtomicBoolean(false);
            CoroutineContext.Element fusContext = FUSProjectHotStartUpMeasurer.INSTANCE.getContextElementToPass();
            Logger $this$trace$iv2 = LOG;
            boolean $i$f$trace2 = false;
            if ($this$trace$iv2.isTraceEnabled()) {
                logger = $this$trace$iv2;
                boolean bl = false;
                logger.trace("[service] MyProtocolListener$extensionCreated$launchOnEdtAndStartImmediatelyIfEdt: subscribe on `fileEditorsModel.composites` model");
            }
            model.getComposites().view(lifetime, (arg_0, arg_1) -> MyProtocolListener.extensionCreated$lambda$6(session, this, firstEditorOpened, lifetime, fusContext, arg_0, arg_1));
            SourceExKt.adviseUntil((ISource)((ISource)model.getEditorsRestored()), (Lifetime)lifetime, arg_0 -> MyProtocolListener.extensionCreated$lambda$7(lifetime, fusContext, arg_0));
            $this$trace$iv2 = LOG;
            $i$f$trace2 = false;
            if ($this$trace$iv2.isTraceEnabled()) {
                logger = $this$trace$iv2;
                boolean bl = false;
                logger.trace("[service] MyProtocolListener$extensionCreated$launchOnEdtAndStartImmediatelyIfEdt: subscribe on `fileEditorsModel.closeFileWithCopies` model");
            }
            model.getCloseFileWithCopies().advise(lifetime, arg_0 -> MyProtocolListener.extensionCreated$lambda$9(session, arg_0));
        }

        private final FileEditorManagerImpl.OpenMode fromModel(OpenModeModel $this$fromModel) {
            return switch (WhenMappings.$EnumSwitchMapping$0[$this$fromModel.ordinal()]) {
                case 1 -> FileEditorManagerImpl.OpenMode.NEW_WINDOW;
                case 2 -> FileEditorManagerImpl.OpenMode.RIGHT_SPLIT;
                case 3 -> FileEditorManagerImpl.OpenMode.DEFAULT;
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        /*
         * WARNING - void declaration
         */
        private static final void extensionCreated$lambda$6$lambda$5$lambda$4(RdFileEditorCompositeId $compositeId, ClientProjectSession $session, Lifetime $compositeLifetime, FileEditorCompositeModel $compositeModel, OpenWithFocusRequest $it, MyProtocolListener this$0, Ref.ObjectRef $firstEditorOpened, Lifetime $lifetime, CoroutineContext.Element $fusContext) {
            VirtualFile virtualFile = FrontendVirtualFileManager.Companion.getInstance().getVirtualFile($compositeId.getFileId());
            Intrinsics.checkNotNull((Object)virtualFile);
            VirtualFile file = virtualFile;
            OpenModeModel openModeModel = $it.getOpenMode();
            FileEditorComposite composite = Companion.getInstance($session).openComposite($compositeLifetime, $compositeId, $compositeModel, file, $it.getRequestFocus(), $it.getSelectAsCurrent(), openModeModel != null ? this$0.fromModel(openModeModel) : null, $it.isSingletonEditorInWindow(), $it.isPinned());
            if (((AtomicBoolean)$firstEditorOpened.element).compareAndSet(false, true)) {
                Object v2;
                block4: {
                    void $this$firstOrNull$iv;
                    void $this$filterIsInstanceTo$iv$iv;
                    Iterable $this$filterIsInstance$iv;
                    Iterable iterable = composite.getAllEditors();
                    boolean $i$f$filterIsInstance = false;
                    Iterator iterator2 = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof FrontendTextFileEditor)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filterIsInstance$iv = (List)destination$iv$iv;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        FrontendTextFileEditor editor = (FrontendTextFileEditor)((Object)element$iv);
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)editor.getFile(), (Object)file)) continue;
                        v2 = element$iv;
                        break block4;
                    }
                    v2 = null;
                }
                FrontendTextFileEditor frontendTextFileEditor = v2;
                if (frontendTextFileEditor == null) {
                    return;
                }
                FrontendTextFileEditor textEditor = frontendTextFileEditor;
                BuildersKt.launch$default((CoroutineScope)$lifetime.getCoroutineScope(), (CoroutineContext)((CoroutineContext)$fusContext), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(textEditor, null){
                    int label;
                    final /* synthetic */ FrontendTextFileEditor $textEditor;
                    {
                        this.$textEditor = $textEditor;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                TextEditorImplKt.performWhenLoaded((TextEditorImpl)((TextEditorImpl)this.$textEditor), () -> extensionCreated.3.2.1.1.invokeSuspend$lambda$0(this.$textEditor));
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }

                    private static final Unit invokeSuspend$lambda$0(FrontendTextFileEditor $textEditor) {
                        Project project = $textEditor.getEditor().getProject();
                        if (project == null) {
                            return Unit.INSTANCE;
                        }
                        Project project2 = project;
                        FUSProjectHotStartUpMeasurer.INSTANCE.firstOpenedEditor($textEditor.getFile(), project2);
                        return Unit.INSTANCE;
                    }
                }), (int)2, null);
            }
        }

        private static final Unit extensionCreated$lambda$6$lambda$5(RdFileEditorCompositeId $compositeId, ClientProjectSession $session, Lifetime $compositeLifetime, FileEditorCompositeModel $compositeModel, MyProtocolListener this$0, Ref.ObjectRef $firstEditorOpened, Lifetime $lifetime, CoroutineContext.Element $fusContext, OpenWithFocusRequest it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            WriteIntentReadAction.run(() -> MyProtocolListener.extensionCreated$lambda$6$lambda$5$lambda$4($compositeId, $session, $compositeLifetime, $compositeModel, it, this$0, $firstEditorOpened, $lifetime, $fusContext));
            return Unit.INSTANCE;
        }

        private static final Unit extensionCreated$lambda$6(ClientProjectSession $session, MyProtocolListener this$0, Ref.ObjectRef $firstEditorOpened, Lifetime $lifetime, CoroutineContext.Element $fusContext, Lifetime compositeLifetime, Map.Entry entry) {
            Intrinsics.checkNotNullParameter((Object)compositeLifetime, (String)"compositeLifetime");
            Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
            RdFileEditorCompositeId compositeId = (RdFileEditorCompositeId)entry.getKey();
            FileEditorCompositeModel compositeModel = (FileEditorCompositeModel)entry.getValue();
            Logger $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("[service] MyProtocolListener$extensionCreated$launchOnEdtAndStartImmediatelyIfEdt: subscribe on `compositeModel.openWithFocus` signal");
            }
            compositeModel.getOpenWithFocus().advise(compositeLifetime, arg_0 -> MyProtocolListener.extensionCreated$lambda$6$lambda$5(compositeId, $session, compositeLifetime, compositeModel, this$0, $firstEditorOpened, $lifetime, $fusContext, arg_0));
            return Unit.INSTANCE;
        }

        private static final boolean extensionCreated$lambda$7(Lifetime $lifetime, CoroutineContext.Element $fusContext, boolean it) {
            if (it) {
                BuildersKt.launch$default((CoroutineScope)$lifetime.getCoroutineScope(), (CoroutineContext)((CoroutineContext)$fusContext), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
                    int label;

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                FUSProjectHotStartUpMeasurer.INSTANCE.reportNoMoreEditorsOnStartup(System.nanoTime());
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
            }
            return it;
        }

        private static final Unit extensionCreated$lambda$9(ClientProjectSession $session, RdFileId fileId) {
            Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
            Companion.getInstance($session).closeFileWithCopies(fileId);
            return Unit.INSTANCE;
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[OpenModeModel.values().length];
                try {
                    nArray[OpenModeModel.NEW_WINDOW.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OpenModeModel.RIGHT_SPLIT.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OpenModeModel.DEFAULT.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TopBottomComponentUpdateType.values().length];
            try {
                nArray[TopBottomComponentUpdateType.ADD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TopBottomComponentUpdateType.REMOVE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

