/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webSymbols.documentation.impl;

import com.intellij.model.Pointer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.backend.documentation.DocumentationResult;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.scale.ScaleType;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.webSymbols.WebSymbol;
import com.intellij.webSymbols.WebSymbolApiStatus;
import com.intellij.webSymbols.WebSymbolOrigin;
import com.intellij.webSymbols.WebSymbolsBundle;
import com.intellij.webSymbols.documentation.WebSymbolDocumentation;
import com.intellij.webSymbols.documentation.WebSymbolDocumentationTarget;
import com.intellij.webSymbols.impl.WebSymbolsImplUtilsKt;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\rH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/intellij/webSymbols/documentation/impl/WebSymbolDocumentationTargetImpl;", "Lcom/intellij/webSymbols/documentation/WebSymbolDocumentationTarget;", "symbol", "Lcom/intellij/webSymbols/WebSymbol;", "location", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/webSymbols/WebSymbol;Lcom/intellij/psi/PsiElement;)V", "getSymbol", "()Lcom/intellij/webSymbols/WebSymbol;", "getLocation", "()Lcom/intellij/psi/PsiElement;", "createPointer", "Lcom/intellij/model/Pointer;", "Lcom/intellij/platform/backend/documentation/DocumentationTarget;", "Companion", "intellij.platform.webSymbols"})
@SourceDebugExtension(value={"SMAP\nWebSymbolDocumentationTargetImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebSymbolDocumentationTargetImpl.kt\ncom/intellij/webSymbols/documentation/impl/WebSymbolDocumentationTargetImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,194:1\n1#2:195\n*E\n"})
public final class WebSymbolDocumentationTargetImpl
implements WebSymbolDocumentationTarget {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WebSymbol symbol;
    @Nullable
    private final PsiElement location;
    @NotNull
    private static final Regex imgSrcRegex = new Regex("<img [^>]*src\\s*=\\s*['\"]([^'\"]+)['\"]");

    public WebSymbolDocumentationTargetImpl(@NotNull WebSymbol symbol, @Nullable PsiElement location) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        this.symbol = symbol;
        this.location = location;
    }

    @Override
    @NotNull
    public WebSymbol getSymbol() {
        return this.symbol;
    }

    @Override
    @Nullable
    public PsiElement getLocation() {
        return this.location;
    }

    @NotNull
    public Pointer<? extends DocumentationTarget> createPointer() {
        Pointer<? extends WebSymbol> pointer = this.getSymbol().createPointer();
        PsiElement psiElement = this.getLocation();
        SmartPsiElementPointer locationPtr = psiElement != null ? SmartPointersKt.createSmartPointer((PsiElement)psiElement) : null;
        return () -> WebSymbolDocumentationTargetImpl.createPointer$lambda$1(pointer, locationPtr);
    }

    private static final DocumentationTarget createPointer$lambda$1(Pointer $pointer, SmartPsiElementPointer $locationPtr) {
        WebSymbolDocumentationTargetImpl webSymbolDocumentationTargetImpl;
        WebSymbol webSymbol = (WebSymbol)$pointer.dereference();
        if (webSymbol != null) {
            WebSymbol it = webSymbol;
            boolean bl = false;
            SmartPsiElementPointer smartPsiElementPointer = $locationPtr;
            webSymbolDocumentationTargetImpl = new WebSymbolDocumentationTargetImpl(it, (PsiElement)(smartPsiElementPointer != null ? smartPsiElementPointer.dereference() : null));
        } else {
            webSymbolDocumentationTargetImpl = null;
        }
        return webSymbolDocumentationTargetImpl;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ0\u0010\n\u001a\u00060\u000bj\u0002`\f*\u00060\u000bj\u0002`\f2\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eH\u0002J\u001c\u0010\u0011\u001a\u00060\u000bj\u0002`\f*\u00060\u000bj\u0002`\f2\u0006\u0010\b\u001a\u00020\tH\u0002J\u001c\u0010\u0012\u001a\u00060\u000bj\u0002`\f*\u00060\u000bj\u0002`\f2\u0006\u0010\b\u001a\u00020\tH\u0002J\u001c\u0010\u0013\u001a\u00060\u000bj\u0002`\f*\u00060\u000bj\u0002`\f2\u0006\u0010\b\u001a\u00020\tH\u0002J\u001c\u0010\u0014\u001a\u00060\u000bj\u0002`\f*\u00060\u000bj\u0002`\f2\u0006\u0010\b\u001a\u00020\tH\u0002J\u001c\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u00162\u0006\u0010\b\u001a\u00020\tH\u0002J0\u0010\u0017\u001a\u00060\u000bj\u0002`\f*\u00060\u000bj\u0002`\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eH\u0002J(\u0010\u001c\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eH\u0002R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/webSymbols/documentation/impl/WebSymbolDocumentationTargetImpl$Companion;", "", "<init>", "()V", "buildDocumentation", "Lcom/intellij/platform/backend/documentation/DocumentationResult;", "origin", "Lcom/intellij/webSymbols/WebSymbolOrigin;", "doc", "Lcom/intellij/webSymbols/documentation/WebSymbolDocumentation;", "appendDefinition", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "url2ImageMap", "", "", "Ljava/awt/Image;", "appendDescription", "appendSections", "appendFootnote", "appendHeader", "buildSections", "", "appendIcon", "icon", "Ljavax/swing/Icon;", "imgSrcRegex", "Lkotlin/text/Regex;", "loadLocalImages", "intellij.platform.webSymbols"})
    @SourceDebugExtension(value={"SMAP\nWebSymbolDocumentationTargetImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebSymbolDocumentationTargetImpl.kt\ncom/intellij/webSymbols/documentation/impl/WebSymbolDocumentationTargetImpl$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,194:1\n1#2:195\n1863#3,2:196\n607#4:198\n*S KotlinDebug\n*F\n+ 1 WebSymbolDocumentationTargetImpl.kt\ncom/intellij/webSymbols/documentation/impl/WebSymbolDocumentationTargetImpl$Companion\n*L\n80#1:196,2\n176#1:198\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DocumentationResult buildDocumentation(@NotNull WebSymbolOrigin origin, @NotNull WebSymbolDocumentation doc) {
            Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
            Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
            Map url2ImageMap = new LinkedHashMap();
            String string = this.appendFootnote(this.appendSections(this.appendDescription(this.appendDefinition(this.appendHeader(new StringBuilder(), doc), doc, url2ImageMap), doc), doc), doc).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String contents = this.loadLocalImages(string, origin, url2ImageMap);
            return (DocumentationResult)DocumentationResult.Companion.documentation(contents).images(url2ImageMap).externalUrl(doc.getDocUrl()).definitionDetails(doc.getDefinitionDetails());
        }

        private final StringBuilder appendDefinition(StringBuilder $this$appendDefinition, WebSymbolDocumentation doc, Map<String, Image> url2ImageMap) {
            StringBuilder stringBuilder;
            StringBuilder it = stringBuilder = $this$appendDefinition.append("<div class='definition'><pre>");
            boolean bl = false;
            Icon icon = doc.getIcon();
            if (icon != null) {
                Icon it2 = icon;
                boolean bl2 = false;
                Companion.appendIcon($this$appendDefinition, it2, url2ImageMap).append("&nbsp;&nbsp;");
            }
            StringBuilder stringBuilder2 = stringBuilder.append(doc.getDefinition()).append("</pre></div>").append('\n');
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
            return stringBuilder2;
        }

        private final StringBuilder appendDescription(StringBuilder $this$appendDescription, WebSymbolDocumentation doc) {
            CharSequence charSequence;
            block3: {
                block2: {
                    charSequence = doc.getDescription();
                    if (charSequence == null) break block2;
                    String it = charSequence;
                    boolean bl = false;
                    StringBuilder stringBuilder = $this$appendDescription.append("<div class='content'>").append('\n').append(it).append('\n').append("</div>");
                    charSequence = stringBuilder;
                    if (stringBuilder != null) break block3;
                }
                charSequence = $this$appendDescription;
            }
            return charSequence;
        }

        private final StringBuilder appendSections(StringBuilder $this$appendSections, WebSymbolDocumentation doc) {
            Map<String, String> sections = this.buildSections(doc);
            boolean bl = false;
            if (!sections.isEmpty()) {
                $this$appendSections.append("<table class='sections'>").append('\n');
                Iterable $this$forEach$iv = sections.entrySet();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Map.Entry entry = (Map.Entry)element$iv;
                    boolean bl2 = false;
                    String name = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    $this$appendSections.append("<tr><td valign='top' class='section'><p>").append(StringUtil.capitalize((String)name));
                    if (!StringsKt.isBlank((CharSequence)value)) {
                        if (!StringsKt.endsWith$default((String)name, (String)":", (boolean)false, (int)2, null)) {
                            $this$appendSections.append(':');
                        }
                        $this$appendSections.append("</td><td valign='top'>").append(value);
                    }
                    $this$appendSections.append("</td>").append('\n');
                }
                $this$appendSections.append("</table>").append('\n');
            }
            return $this$appendSections;
        }

        private final StringBuilder appendFootnote(StringBuilder $this$appendFootnote, WebSymbolDocumentation doc) {
            CharSequence charSequence;
            block3: {
                block2: {
                    charSequence = doc.getFootnote();
                    if (charSequence == null) break block2;
                    String it = charSequence;
                    boolean bl = false;
                    StringBuilder stringBuilder = $this$appendFootnote.append("<div class='content'>").append(it).append("</div>").append('\n');
                    charSequence = stringBuilder;
                    if (stringBuilder != null) break block3;
                }
                charSequence = $this$appendFootnote;
            }
            return charSequence;
        }

        private final StringBuilder appendHeader(StringBuilder $this$appendHeader, WebSymbolDocumentation doc) {
            CharSequence charSequence;
            block3: {
                block2: {
                    charSequence = doc.getHeader();
                    if (charSequence == null) break block2;
                    String it = charSequence;
                    boolean bl = false;
                    StringBuilder stringBuilder = $this$appendHeader.append("<div class='top'>").append(it).append("</div>\n");
                    charSequence = stringBuilder;
                    if (stringBuilder != null) break block3;
                }
                charSequence = $this$appendHeader;
            }
            return charSequence;
        }

        private final Map<String, String> buildSections(WebSymbolDocumentation doc) {
            LinkedHashMap<String, String> linkedHashMap;
            block18: {
                String it;
                LinkedHashMap<String, String> sections = linkedHashMap = new LinkedHashMap<String, String>(doc.getDescriptionSections());
                boolean bl = false;
                if (doc.isRequired()) {
                    ((Map)sections).put(WebSymbolsBundle.message("mdn.documentation.section.isRequired", new Object[0]), "");
                }
                WebSymbolApiStatus webSymbolApiStatus = doc.getApiStatus();
                if (webSymbolApiStatus != null) {
                    WebSymbolApiStatus status = webSymbolApiStatus;
                    boolean bl2 = false;
                    WebSymbolApiStatus webSymbolApiStatus2 = status;
                    if (webSymbolApiStatus2 instanceof WebSymbolApiStatus.Deprecated) {
                        Map map = sections;
                        String string = WebSymbolsBundle.message("mdn.documentation.section.status.Deprecated", new Object[0]);
                        String string2 = ((WebSymbolApiStatus.Deprecated)status).getMessage();
                        if (string2 == null) {
                            string2 = "";
                        }
                        String string3 = string2;
                        map.put(string, string3);
                        String string4 = ((WebSymbolApiStatus.Deprecated)status).getSince();
                        if (string4 != null) {
                            String it2 = string4;
                            boolean bl3 = false;
                            ((Map)sections).put(WebSymbolsBundle.message("mdn.documentation.section.status.DeprecatedSince", new Object[0]), it2);
                        }
                    } else if (webSymbolApiStatus2 instanceof WebSymbolApiStatus.Obsolete) {
                        Map map = sections;
                        String string = WebSymbolsBundle.message("mdn.documentation.section.status.Obsolete", new Object[0]);
                        String string5 = ((WebSymbolApiStatus.Obsolete)status).getMessage();
                        if (string5 == null) {
                            string5 = "";
                        }
                        String it2 = string5;
                        map.put(string, it2);
                        String string6 = ((WebSymbolApiStatus.Obsolete)status).getSince();
                        if (string6 != null) {
                            it2 = string6;
                            boolean bl4 = false;
                            ((Map)sections).put(WebSymbolsBundle.message("mdn.documentation.section.status.ObsoleteSince", new Object[0]), it2);
                        }
                    } else if (webSymbolApiStatus2 instanceof WebSymbolApiStatus.Experimental) {
                        Map map = sections;
                        String string = WebSymbolsBundle.message("mdn.documentation.section.status.Experimental", new Object[0]);
                        String string7 = ((WebSymbolApiStatus.Experimental)status).getMessage();
                        if (string7 == null) {
                            string7 = "";
                        }
                        String it3 = string7;
                        map.put(string, it3);
                        String string8 = ((WebSymbolApiStatus.Experimental)status).getSince();
                        if (string8 != null) {
                            it3 = string8;
                            boolean bl5 = false;
                            ((Map)sections).put(WebSymbolsBundle.message("mdn.documentation.section.status.Since", new Object[0]), it3);
                        }
                    } else if (webSymbolApiStatus2 instanceof WebSymbolApiStatus.Stable) {
                        String string = ((WebSymbolApiStatus.Stable)status).getSince();
                        if (string != null) {
                            String it4 = string;
                            boolean bl6 = false;
                            ((Map)sections).put(WebSymbolsBundle.message("mdn.documentation.section.status.Since", new Object[0]), it4);
                        }
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                String string = doc.getDefaultValue();
                if (string != null) {
                    it = string;
                    boolean bl7 = false;
                    ((Map)sections).put(WebSymbolsBundle.message("mdn.documentation.section.defaultValue", new Object[0]), "<p><code>" + it + "</code>");
                }
                String string9 = doc.getLibrary();
                if (string9 == null) break block18;
                it = string9;
                boolean bl8 = false;
                ((Map)sections).put(WebSymbolsBundle.message("mdn.documentation.section.library", new Object[0]), "<p>" + it);
            }
            return linkedHashMap;
        }

        private final StringBuilder appendIcon(StringBuilder $this$appendIcon, Icon icon, Map<String, Image> url2ImageMap) {
            BufferedImage bufferedImage;
            BufferedImage bufferedImage2 = new BufferedImage(1, 1, 2);
            Graphics2D g = bufferedImage2.createGraphics();
            g.setFont(UIUtil.getToolTipFont());
            int height = (int)(g.getFontMetrics().getStringBounds("a", g).getHeight() / ScaleContext.Companion.create().getScale(ScaleType.USR_SCALE));
            g.dispose();
            try {
                bufferedImage = IconUtil.toBufferedImage$default((Icon)WebSymbolsImplUtilsKt.scaleToHeight(icon, height), (boolean)false, (int)2, null);
            }
            catch (Exception e) {
                return $this$appendIcon;
            }
            BufferedImage image = bufferedImage;
            String url = "https://img" + url2ImageMap.size();
            url2ImageMap.put(url, image);
            double screenHeight = (double)height * ScaleContext.Companion.create().getScale(ScaleType.SYS_SCALE);
            $this$appendIcon.append("<img src='" + url + "' height=\"" + screenHeight + "\" width=\"" + screenHeight * (double)icon.getIconWidth() / (double)icon.getIconHeight() + "\" border=0 />");
            return $this$appendIcon;
        }

        /*
         * WARNING - void declaration
         */
        private final String loadLocalImages(String $this$loadLocalImages, WebSymbolOrigin origin, Map<String, Image> url2ImageMap) {
            void $this$sortedBy$iv;
            Sequence sequence = SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)Regex.findAll$default((Regex)imgSrcRegex, (CharSequence)$this$loadLocalImages, (int)0, (int)2, null), Companion::loadLocalImages$lambda$15), Companion::loadLocalImages$lambda$16), arg_0 -> Companion.loadLocalImages$lambda$19(origin, url2ImageMap, arg_0));
            boolean $i$f$sortedBy = false;
            List replaces = SequencesKt.toList((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Pair it = (Pair)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(((IntRange)it.getFirst()).getFirst());
                    it = (Pair)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(((IntRange)it.getFirst()).getFirst()));
                }
            }));
            if (replaces.isEmpty()) {
                return $this$loadLocalImages;
            }
            StringBuilder result2 = new StringBuilder();
            int lastIndex = 0;
            for (Pair replace : replaces) {
                Intrinsics.checkNotNullExpressionValue((Object)result2.append($this$loadLocalImages, lastIndex, ((IntRange)replace.getFirst()).getFirst()), (String)"append(...)");
                result2.append((String)replace.getSecond());
                lastIndex = ((IntRange)replace.getFirst()).getLast() + 1;
            }
            if (lastIndex < $this$loadLocalImages.length()) {
                Intrinsics.checkNotNullExpressionValue((Object)result2.append($this$loadLocalImages, lastIndex, $this$loadLocalImages.length()), (String)"append(...)");
            }
            String string = result2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private static final MatchGroup loadLocalImages$lambda$15(MatchResult it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getGroups().get(1);
        }

        private static final boolean loadLocalImages$lambda$16(MatchGroup it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return !StringsKt.contains$default((CharSequence)it.getValue(), (char)':', (boolean)false, (int)2, null);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static final Pair loadLocalImages$lambda$19(WebSymbolOrigin $origin, Map $url2ImageMap, MatchGroup group) {
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            Icon icon = $origin.loadIcon(group.getValue());
            if (icon == null) return null;
            Object it = icon;
            boolean bl = false;
            BufferedImage bufferedImage = IconUtil.toBufferedImage((Icon)it, (boolean)true);
            if (bufferedImage == null) return null;
            it = bufferedImage;
            boolean bl2 = false;
            String url = "https://img" + $url2ImageMap.size();
            $url2ImageMap.put(url, it);
            Pair pair = new Pair((Object)group.getRange(), (Object)url);
            return pair;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

