/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.scientific.action;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.images.ImagesBundle;
import org.intellij.images.scientific.ScientificUtils;
import org.intellij.images.scientific.action.SaveImageActionKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/intellij/images/scientific/action/SaveImageAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "Companion", "intellij.platform.images"})
@SourceDebugExtension(value={"SMAP\nSaveImageAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SaveImageAction.kt\norg/intellij/images/scientific/action/SaveImageAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,54:1\n1#2:55\n*E\n"})
public final class SaveImageAction
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String IMAGE_FORMAT = "png";
    @NotNull
    private static final String IMAGE_DEFAULT_NAME = "myimg";

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile virtualFile;
        FileSaverDialog chooser;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        VirtualFile virtualFile2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (virtualFile2 == null || project == null) {
            SaveImageActionKt.access$getLogger$p().error("Missing project or image file.");
            return;
        }
        FileSaverDescriptor descriptor = new FileSaverDescriptor(ImagesBundle.message("dialog.title.save.image", new Object[0]), "", IMAGE_FORMAT);
        FileSaverDialog fileSaverDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor, project);
        Intrinsics.checkNotNullExpressionValue((Object)fileSaverDialog, (String)"createSaveFileDialog(...)");
        FileSaverDialog fileSaverDialog2 = chooser = fileSaverDialog;
        String string = project.getBasePath();
        if (string != null) {
            void it;
            String string2 = string;
            FileSaverDialog fileSaverDialog3 = fileSaverDialog2;
            boolean bl = false;
            virtualFile = VirtualFileManager.getInstance().findFileByUrl((String)it);
            fileSaverDialog2 = fileSaverDialog3;
        } else {
            virtualFile = null;
        }
        VirtualFileWrapper wrapper = fileSaverDialog2.save(virtualFile, IMAGE_DEFAULT_NAME);
        if (wrapper == null) {
            return;
        }
        try {
            Files.write(wrapper.getFile().toPath(), virtualFile2.contentsToByteArray(), new OpenOption[0]);
        }
        catch (IOException e2) {
            SaveImageActionKt.access$getLogger$p().warn("Failed to save image", (Throwable)e2);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        VirtualFile imageFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        VirtualFile virtualFile = imageFile;
        e.getPresentation().setEnabledAndVisible((virtualFile != null ? (Unit)virtualFile.getUserData(ScientificUtils.INSTANCE.getSCIENTIFIC_MODE_KEY()) : null) != null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/intellij/images/scientific/action/SaveImageAction$Companion;", "", "<init>", "()V", "IMAGE_FORMAT", "", "IMAGE_DEFAULT_NAME", "intellij.platform.images"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

