/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.impl.diagnostic;

import com.intellij.ml.inline.completion.impl.AnalyzedMLCompletionProposal;
import com.intellij.ml.inline.completion.impl.MLCompletionProposal;
import com.intellij.ml.inline.completion.impl.RawMLCompletionProposal;
import com.intellij.ml.inline.completion.impl.diagnostic.AddCachedProposals;
import com.intellij.ml.inline.completion.impl.diagnostic.Analyzed;
import com.intellij.ml.inline.completion.impl.diagnostic.AnalyzedFilteringCompleted;
import com.intellij.ml.inline.completion.impl.diagnostic.ClientSelected;
import com.intellij.ml.inline.completion.impl.diagnostic.CloudFilterModel;
import com.intellij.ml.inline.completion.impl.diagnostic.CompletionInvoked;
import com.intellij.ml.inline.completion.impl.diagnostic.ContextMessage;
import com.intellij.ml.inline.completion.impl.diagnostic.FilterModelMessage;
import com.intellij.ml.inline.completion.impl.diagnostic.FilteredAnalyzed;
import com.intellij.ml.inline.completion.impl.diagnostic.FilteredRaw;
import com.intellij.ml.inline.completion.impl.diagnostic.Grouped;
import com.intellij.ml.inline.completion.impl.diagnostic.IncompatibleUxMode;
import com.intellij.ml.inline.completion.impl.diagnostic.MLCompletionEvent;
import com.intellij.ml.inline.completion.impl.diagnostic.Mapper;
import com.intellij.ml.inline.completion.impl.diagnostic.Mappings;
import com.intellij.ml.inline.completion.impl.diagnostic.ModelInferred;
import com.intellij.ml.inline.completion.impl.diagnostic.MultilineApplicability;
import com.intellij.ml.inline.completion.impl.diagnostic.NextEditComputed;
import com.intellij.ml.inline.completion.impl.diagnostic.NextEditConsideredChange;
import com.intellij.ml.inline.completion.impl.diagnostic.NextEditModelResponse;
import com.intellij.ml.inline.completion.impl.diagnostic.NextEditPromptComposed;
import com.intellij.ml.inline.completion.impl.diagnostic.NextEditSessionMessage;
import com.intellij.ml.inline.completion.impl.diagnostic.NextEditSessionMessagePayload;
import com.intellij.ml.inline.completion.impl.diagnostic.NextEditTargetFile;
import com.intellij.ml.inline.completion.impl.diagnostic.PipelineStartsWith;
import com.intellij.ml.inline.completion.impl.diagnostic.ProposalForFilterModel;
import com.intellij.ml.inline.completion.impl.diagnostic.RawFilteringCompleted;
import com.intellij.ml.inline.completion.impl.diagnostic.ResultProposals;
import com.intellij.ml.inline.completion.impl.diagnostic.SessionMessage;
import com.intellij.ml.inline.completion.impl.diagnostic.SessionMessagePayload;
import com.intellij.ml.inline.completion.impl.diagnostic.SilentCompletion;
import com.intellij.ml.inline.completion.impl.diagnostic.SkipReason;
import com.intellij.ml.inline.completion.impl.diagnostic.TextMessage;
import com.intellij.ml.inline.completion.impl.postprocessing.filter.ProposalFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002H\u0000\u001a\u000e\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0003H\u0002\u001a.\u0010\u0004\u001a\u0004\u0018\u00010\u0005\"\b\b\u0000\u0010\u0006*\u00020\u00072\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u0002H\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tH\u0002\u001a\f\u0010\f\u001a\u00020\u0005*\u00020\rH\u0002\u001a\f\u0010\f\u001a\u00020\u0005*\u00020\u000eH\u0002\u001a\u000e\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"toTextMessage", "Lcom/intellij/ml/inline/completion/impl/diagnostic/TextMessage;", "Lcom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionEvent;", "Lcom/intellij/ml/inline/completion/impl/diagnostic/SessionMessagePayload;", "filterDescription", "", "T", "Lcom/intellij/ml/inline/completion/impl/MLCompletionProposal;", "items", "", "", "Lcom/intellij/ml/inline/completion/impl/postprocessing/filter/ProposalFilter;", "describe", "Lcom/intellij/ml/inline/completion/impl/RawMLCompletionProposal;", "Lcom/intellij/ml/inline/completion/impl/AnalyzedMLCompletionProposal;", "Lcom/intellij/ml/inline/completion/impl/diagnostic/NextEditSessionMessagePayload;", "intellij.fullLine.core.completion"})
@SourceDebugExtension(value={"SMAP\ntextLog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 textLog.kt\ncom/intellij/ml/inline/completion/impl/diagnostic/TextLogKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,111:1\n774#2:112\n865#2,2:113\n1557#2:115\n1628#2,3:116\n774#2:119\n865#2,2:120\n1#3:122\n503#4,7:123\n*S KotlinDebug\n*F\n+ 1 textLog.kt\ncom/intellij/ml/inline/completion/impl/diagnostic/TextLogKt\n*L\n37#1:112\n37#1:113,2\n41#1:115\n41#1:116,3\n53#1:119\n53#1:120,2\n82#1:123,7\n*E\n"})
public final class TextLogKt {
    @Nullable
    public static final TextMessage toTextMessage(@NotNull MLCompletionEvent $this$toTextMessage) {
        Intrinsics.checkNotNullParameter((Object)$this$toTextMessage, (String)"<this>");
        if ($this$toTextMessage instanceof TextMessage) {
            return (TextMessage)$this$toTextMessage;
        }
        if ($this$toTextMessage instanceof SessionMessage) {
            return TextLogKt.toTextMessage(((SessionMessage)$this$toTextMessage).getPayload());
        }
        if ($this$toTextMessage instanceof NextEditSessionMessage) {
            return TextLogKt.toTextMessage(((NextEditSessionMessage)$this$toTextMessage).getPayload());
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static final TextMessage toTextMessage(SessionMessagePayload $this$toTextMessage) {
        Object object;
        SessionMessagePayload sessionMessagePayload = $this$toTextMessage;
        if (sessionMessagePayload instanceof CompletionInvoked) {
            object = "Completion invoked";
        } else if (sessionMessagePayload instanceof ModelInferred) {
            object = "Model inferred with generation_id " + ((ModelInferred)$this$toTextMessage).getGenerationId() + " in " + Duration.getInWholeMilliseconds-impl((long)((ModelInferred)$this$toTextMessage).getDuration-UwyO8pc()) + "ms";
        } else if (sessionMessagePayload instanceof CloudFilterModel) {
            object = "Cloud filter model responded with " + ((CloudFilterModel)$this$toTextMessage).getResponseType() + " and prob=" + ((CloudFilterModel)$this$toTextMessage).getProbability();
        } else if (sessionMessagePayload instanceof ClientSelected) {
            object = "Client selected " + ((ClientSelected)$this$toTextMessage).getName();
        } else if (sessionMessagePayload instanceof AddCachedProposals) {
            object = null;
        } else if (sessionMessagePayload instanceof Analyzed) {
            object = "Analyzing for all " + ((Analyzed)$this$toTextMessage).getProposals().size() + " suggestions took " + ((Analyzed)$this$toTextMessage).getDuration() + "ms";
        } else if (sessionMessagePayload instanceof ContextMessage) {
            object = "Context assembled in " + Duration.getInWholeMilliseconds-impl((long)((ContextMessage)$this$toTextMessage).getTimeToAssemble-UwyO8pc()) + "ms";
        } else if (sessionMessagePayload instanceof FilterModelMessage) {
            object = "Filter model for " + ((FilterModelMessage)$this$toTextMessage).getProposal().getSuggestion() + " executed with " + ((FilterModelMessage)$this$toTextMessage).getResponse() + ". Should pass=" + ((FilterModelMessage)$this$toTextMessage).getPass() + ", took " + Duration.getInWholeMilliseconds-impl((long)((FilterModelMessage)$this$toTextMessage).getDuration-UwyO8pc()) + "ms";
        } else if (sessionMessagePayload instanceof FilteredAnalyzed) {
            object = TextLogKt.filterDescription(((FilteredAnalyzed)$this$toTextMessage).getItems());
        } else if (sessionMessagePayload instanceof FilteredRaw) {
            object = TextLogKt.filterDescription(((FilteredRaw)$this$toTextMessage).getItems());
        } else if (sessionMessagePayload instanceof AnalyzedFilteringCompleted) {
            object = "Analyzed filtering took " + Duration.getInWholeMilliseconds-impl((long)((AnalyzedFilteringCompleted)$this$toTextMessage).getDuration-UwyO8pc()) + "ms";
        } else if (sessionMessagePayload instanceof RawFilteringCompleted) {
            object = "Raw filtering took " + Duration.getInWholeMilliseconds-impl((long)((RawFilteringCompleted)$this$toTextMessage).getDuration-UwyO8pc()) + "ms";
        } else if (sessionMessagePayload instanceof Grouped) {
            Map.Entry it;
            void $this$filterTo$iv$iv;
            StringBuilder stringBuilder;
            StringBuilder $this$toTextMessage_u24lambda_u242 = stringBuilder = new StringBuilder();
            boolean bl = false;
            Iterable $this$filter$iv = ((Grouped)$this$toTextMessage).getGroups().entrySet();
            boolean $i$f$filter2 = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Map.Entry)element$iv$iv;
                boolean bl2 = false;
                if (!(((List)it.getValue()).size() != 1)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List merges = (List)destination$iv$iv;
            if (!((Collection)merges).isEmpty()) {
                $this$toTextMessage_u24lambda_u242.append("Some elements were grouped").append('\n');
                for (Map.Entry $i$f$filter2 : merges) {
                    void $this$mapTo$iv$iv;
                    String $this$map$iv;
                    RawMLCompletionProposal to = (RawMLCompletionProposal)$i$f$filter2.getKey();
                    List from = (List)$i$f$filter2.getValue();
                    StringBuilder $i$f$filterTo2 = $this$toTextMessage_u24lambda_u242;
                    Iterable iterable2 = from;
                    String string = to.getSuggestion();
                    boolean $i$f$map = false;
                    it = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv), (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it2;
                        RawMLCompletionProposal rawMLCompletionProposal = (RawMLCompletionProposal)item$iv$iv;
                        Collection collection = destination$iv$iv2;
                        boolean bl3 = false;
                        collection.add(it2.getSuggestion());
                    }
                    $this$map$iv = "\t" + string + " <- " + (List)destination$iv$iv2;
                    $i$f$filterTo2.append($this$map$iv).append('\n');
                }
            }
            object = stringBuilder.toString();
        } else if (sessionMessagePayload instanceof Mapper) {
            String name = ((Mapper)$this$toTextMessage).getMapperDiagnostics().getName();
            String bl = "%.3f";
            Object[] $this$filter$iv = new Object[]{((Mapper)$this$toTextMessage).getMapperDiagnostics().getTotalTimeMs()};
            String string = String.format(bl, Arrays.copyOf($this$filter$iv, $this$filter$iv.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            String totalTimeMs = string;
            int transformedNumber = ((Mapper)$this$toTextMessage).getMapperDiagnostics().getMappings().size();
            int totalInvocations = ((Mapper)$this$toTextMessage).getMapperDiagnostics().getInvocations();
            object = "Mapper '" + name + "' took " + totalTimeMs + "ms and transformed " + transformedNumber + " out of " + totalInvocations + " variants";
        } else if (sessionMessagePayload instanceof Mappings) {
            Pair $this$filterTo$iv$iv2;
            StringBuilder stringBuilder;
            StringBuilder $this$toTextMessage_u24lambda_u245 = stringBuilder = new StringBuilder();
            boolean bl = false;
            Iterable $this$filter$iv = CollectionsKt.zip((Iterable)((Mappings)$this$toTextMessage).getBefore(), (Iterable)((Mappings)$this$toTextMessage).getAfter());
            boolean $i$f$filter = false;
            Iterable to = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                Pair it = (Pair)element$iv$iv;
                boolean bl4 = false;
                if (!(!Intrinsics.areEqual((Object)((MLCompletionProposal)it.getFirst()).getSuggestion(), (Object)((MLCompletionProposal)it.getSecond()).getSuggestion()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List changes = (List)destination$iv$iv;
            if (!((Collection)changes).isEmpty()) {
                $this$filterTo$iv$iv2 = ((Iterable)changes).iterator();
                if (!$this$filterTo$iv$iv2.hasNext()) {
                    throw new NoSuchElementException();
                }
                Pair it22 = (Pair)$this$filterTo$iv$iv2.next();
                boolean bl5 = false;
                int it22 = ((MLCompletionProposal)it22.getFirst()).getSuggestion().length();
                while ($this$filterTo$iv$iv2.hasNext()) {
                    Pair it32 = (Pair)$this$filterTo$iv$iv2.next();
                    $i$a$-maxOf-TextLogKt$toTextMessage$text$2$longest$1 = false;
                    int it32 = ((MLCompletionProposal)it32.getFirst()).getSuggestion().length();
                    if (it22 >= it32) continue;
                    it22 = it32;
                }
                int longest = it22;
                $this$toTextMessage_u24lambda_u245.append("Some elements were transformed due to Mapping").append('\n');
                for (Pair $this$filterTo$iv$iv2 : changes) {
                    MLCompletionProposal b = (MLCompletionProposal)$this$filterTo$iv$iv2.component1();
                    MLCompletionProposal a = (MLCompletionProposal)$this$filterTo$iv$iv2.component2();
                    $this$toTextMessage_u24lambda_u245.append("\t" + StringsKt.padEnd$default((String)b.getSuggestion(), (int)longest, (char)'\u0000', (int)2, null) + " -> " + a.getSuggestion()).append('\n');
                }
            }
            object = stringBuilder.toString();
        } else if (sessionMessagePayload instanceof PipelineStartsWith) {
            StringBuilder stringBuilder;
            StringBuilder $this$toTextMessage_u24lambda_u247 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$toTextMessage_u24lambda_u247.append("Got " + ((PipelineStartsWith)$this$toTextMessage).getProposals().size() + " raw ML proposals").append('\n');
            Iterator longest = ((Iterable)((PipelineStartsWith)$this$toTextMessage).getProposals()).iterator();
            if (!longest.hasNext()) {
                throw new NoSuchElementException();
            }
            RawMLCompletionProposal it = (RawMLCompletionProposal)longest.next();
            boolean bl6 = false;
            int n = it.getSuggestion().length();
            while (longest.hasNext()) {
                RawMLCompletionProposal it3 = (RawMLCompletionProposal)longest.next();
                $i$a$-maxOf-TextLogKt$toTextMessage$text$3$longest$1 = false;
                int n2 = it3.getSuggestion().length();
                if (n >= n2) continue;
                n = n2;
            }
            int longest2 = n;
            for (RawMLCompletionProposal proposal : ((PipelineStartsWith)$this$toTextMessage).getProposals()) {
                $this$toTextMessage_u24lambda_u247.append("\t" + StringsKt.padEnd$default((String)proposal.getSuggestion(), (int)longest2, (char)'\u0000', (int)2, null) + " [" + TextLogKt.describe(proposal) + "]").append('\n');
            }
            object = stringBuilder.toString();
        } else if (sessionMessagePayload instanceof ResultProposals) {
            object = "Result proposals:\n" + CollectionsKt.joinToString$default((Iterable)((ResultProposals)$this$toTextMessage).getProposals(), (CharSequence)"\n", null, null, (int)0, null, TextLogKt::toTextMessage$lambda$8, (int)30, null);
        } else if (sessionMessagePayload instanceof SilentCompletion) {
            object = "Silent completion";
        } else if (sessionMessagePayload instanceof SkipReason) {
            object = "Skip due to " + ((SkipReason)$this$toTextMessage).getReason();
        } else if (sessionMessagePayload instanceof ProposalForFilterModel) {
            object = null;
        } else if (sessionMessagePayload instanceof IncompatibleUxMode) {
            object = "Cannot show a completion because of incompatible UX mode";
        } else if (sessionMessagePayload instanceof MultilineApplicability) {
            object = "Multi-line can be requested: " + ((MultilineApplicability)$this$toTextMessage).getResult();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        if (object == null) {
            return null;
        }
        String text2 = object;
        return new TextMessage(text2, System.currentTimeMillis());
    }

    private static final <T extends MLCompletionProposal> String filterDescription(Map<T, ? extends List<? extends ProposalFilter>> items) {
        Map<T, List<ProposalFilter>> $this$filterValues$iv = items;
        boolean $i$f$filterValues = false;
        LinkedHashMap<T, List<? extends ProposalFilter>> result$iv = new LinkedHashMap<T, List<? extends ProposalFilter>>();
        for (Map.Entry<T, List<ProposalFilter>> entry$iv : $this$filterValues$iv.entrySet()) {
            List<? extends ProposalFilter> it = entry$iv.getValue();
            boolean bl = false;
            boolean bl2 = !((Collection)it).isEmpty();
            if (!bl2) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map filteredWithReasons = result$iv;
        if (filteredWithReasons.isEmpty()) {
            return null;
        }
        return CollectionsKt.joinToString$default((Iterable)filteredWithReasons.entrySet(), (CharSequence)"\n", (CharSequence)"Some elements were filtered:\n", null, (int)0, null, TextLogKt::filterDescription$lambda$10, (int)28, null);
    }

    private static final String describe(RawMLCompletionProposal $this$describe) {
        StringBuilder stringBuilder;
        StringBuilder $this$describe_u24lambda_u2411 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$describe_u24lambda_u2411.append("score: " + $this$describe.getScore());
        return stringBuilder.toString();
    }

    private static final String describe(AnalyzedMLCompletionProposal $this$describe) {
        return "correctness: " + $this$describe.getCorrectnessState() + ", suffix: " + $this$describe.getSuffix().getPresentation();
    }

    private static final TextMessage toTextMessage(NextEditSessionMessagePayload $this$toTextMessage) {
        String string;
        NextEditSessionMessagePayload nextEditSessionMessagePayload = $this$toTextMessage;
        if (nextEditSessionMessagePayload instanceof NextEditConsideredChange) {
            string = "Considered changed " + ((NextEditConsideredChange)$this$toTextMessage).getPath() + " with text \n" + ((NextEditConsideredChange)$this$toTextMessage).getText();
        } else if (nextEditSessionMessagePayload instanceof NextEditModelResponse) {
            string = "Model responded with \n" + ((NextEditModelResponse)$this$toTextMessage).getGeneration();
        } else if (nextEditSessionMessagePayload instanceof NextEditPromptComposed) {
            string = "Prompt composed: \n " + ((NextEditPromptComposed)$this$toTextMessage).getPayload();
        } else if (nextEditSessionMessagePayload instanceof NextEditTargetFile) {
            string = "Target set to " + ((NextEditTargetFile)$this$toTextMessage).getAfter();
        } else if (nextEditSessionMessagePayload instanceof NextEditComputed) {
            string = "Computed " + ((NextEditComputed)$this$toTextMessage).getDiffs() + " diffs";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String text2 = string;
        return new TextMessage(text2, System.currentTimeMillis());
    }

    private static final CharSequence toTextMessage$lambda$8(AnalyzedMLCompletionProposal it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getSuggestion();
    }

    private static final CharSequence filterDescription$lambda$10(Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        MLCompletionProposal proposal = (MLCompletionProposal)entry.getKey();
        List reasons = (List)entry.getValue();
        return proposal.getSuggestion() + " <- " + CollectionsKt.first((List)reasons);
    }
}

