/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.imports;

import com.intellij.ide.DataManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.imports.ImportCandidateHolder;
import com.jetbrains.python.codeInsight.imports.ImportChooser;
import java.awt.Component;
import java.awt.Font;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class PyImportChooser
implements ImportChooser {
    @Override
    public Promise<ImportCandidateHolder> selectImport(List<? extends ImportCandidateHolder> sources, boolean useQualifiedImport) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return Promises.resolvedPromise((Object)sources.get(0));
        }
        AsyncPromise result2 = new AsyncPromise();
        DataManager.getInstance().getDataContextFromFocus().doWhenDone(dataContext -> {
            IPopupChooserBuilder popup = JBPopupFactory.getInstance().createPopupChooserBuilder(sources).setItemChosenCallback(item -> result2.setResult(item));
            this.processPopup((IPopupChooserBuilder<? extends ImportCandidateHolder>)popup, useQualifiedImport);
            popup.createPopup().showInBestPositionFor(dataContext);
        });
        return result2;
    }

    protected void processPopup(IPopupChooserBuilder<? extends ImportCandidateHolder> popup, boolean useQualifiedImport) {
        popup.setRenderer((ListCellRenderer)new CellRenderer()).setTitle(useQualifiedImport ? PyPsiBundle.message("ACT.qualify.with.module", new Object[0]) : PyPsiBundle.message("ACT.from.some.module.import", new Object[0])).setNamerForFiltering(o -> o.getPresentableText());
    }

    private static class CellRenderer
    extends SimpleColoredComponent
    implements ListCellRenderer<ImportCandidateHolder> {
        private final Font FONT;

        CellRenderer() {
            EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
            this.FONT = scheme.getFont(EditorFontType.PLAIN);
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends ImportCandidateHolder> list, ImportCandidateHolder value, int index, boolean isSelected, boolean cellHasFocus) {
            this.clear();
            PsiNamedElement importable = value.getImportable();
            if (importable != null) {
                Icon icon = (Icon)ReadAction.compute(() -> CellRenderer.lambda$getListCellRendererComponent$0((PsiElement)importable));
                this.setIcon(icon);
            }
            String item_name = value.getPresentableText();
            this.append(item_name, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            this.setFont(this.FONT);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }

        private static /* synthetic */ Icon lambda$getListCellRendererComponent$0(PsiElement importable) throws RuntimeException {
            return importable.getIcon(0);
        }
    }
}

