/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.terminal.TerminalTitle;
import com.intellij.terminal.frontend.ReworkedTerminalView;
import com.intellij.terminal.session.TerminalSession;
import com.intellij.terminal.ui.TerminalWidget;
import com.intellij.terminal.ui.TtyConnectorAccessor;
import com.jediterm.core.util.TermSize;
import com.jediterm.terminal.TtyConnector;
import java.awt.Component;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.JBTerminalSystemSettingsProvider;
import org.jetbrains.plugins.terminal.block.TerminalContentView;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\fH\u0016J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00140\u000bH\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020%H\u0016J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\"H\u0016J\u0010\u0010*\u001a\u00020\"2\u0006\u0010\u0017\u001a\u00020\u0019H\u0016J\u0018\u0010+\u001a\u00020\"2\u0006\u0010,\u001a\u00020-2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0015\u0010.\u001a\u00020\"2\u000b\u0010/\u001a\u00070\u0019\u00a2\u0006\u0002\b0H\u0016J\u0010\u00101\u001a\u00020\"2\u0006\u00102\u001a\u00020(H\u0016J\u0018\u00103\u001a\u00020\"2\u0006\u00104\u001a\u00020%2\u0006\u00105\u001a\u00020\u0007H\u0016J\b\u00106\u001a\u00020\"H\u0016J\u0018\u0010;\u001a\u00020\"2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\"\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0018X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\u0004\u0018\u00010\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u00107\u001a\u000208X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:\u00a8\u0006?"}, d2={"Lcom/intellij/terminal/frontend/ReworkedTerminalWidget;", "Lcom/intellij/terminal/ui/TerminalWidget;", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lorg/jetbrains/plugins/terminal/JBTerminalSystemSettingsProvider;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/terminal/JBTerminalSystemSettingsProvider;Lcom/intellij/openapi/Disposable;)V", "sessionFuture", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/terminal/session/TerminalSession;", "view", "Lorg/jetbrains/plugins/terminal/block/TerminalContentView;", "terminalTitle", "Lcom/intellij/terminal/TerminalTitle;", "getTerminalTitle", "()Lcom/intellij/terminal/TerminalTitle;", "termSize", "Lcom/jediterm/core/util/TermSize;", "getTermSize", "()Lcom/jediterm/core/util/TermSize;", "shellCommand", "", "", "getShellCommand", "()Ljava/util/List;", "setShellCommand", "(Ljava/util/List;)V", "session", "getSession", "()Lcom/intellij/terminal/session/TerminalSession;", "connectToSession", "", "getTerminalSizeInitializedFuture", "getComponent", "Ljavax/swing/JComponent;", "getPreferredFocusableComponent", "hasFocus", "", "requestFocus", "sendCommandToExecute", "addTerminationCallback", "onTerminated", "Ljava/lang/Runnable;", "writePlainMessage", "message", "Lorg/jetbrains/annotations/Nls;", "setCursorVisible", "visible", "addNotification", "notificationComponent", "disposable", "dispose", "ttyConnectorAccessor", "Lcom/intellij/terminal/ui/TtyConnectorAccessor;", "getTtyConnectorAccessor", "()Lcom/intellij/terminal/ui/TtyConnectorAccessor;", "connectToTty", "ttyConnector", "Lcom/jediterm/terminal/TtyConnector;", "initialTermSize", "intellij.terminal.frontend"})
public final class ReworkedTerminalWidget
implements TerminalWidget {
    @NotNull
    private final Project project;
    @NotNull
    private final CompletableFuture<TerminalSession> sessionFuture;
    @NotNull
    private final TerminalContentView view;
    @NotNull
    private final TerminalTitle terminalTitle;
    @Nullable
    private List<String> shellCommand;
    @NotNull
    private final TtyConnectorAccessor ttyConnectorAccessor;

    public ReworkedTerminalWidget(@NotNull Project project, @NotNull JBTerminalSystemSettingsProvider settings, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.project = project;
        this.sessionFuture = new CompletableFuture();
        this.view = new ReworkedTerminalView(this.project, settings, this.sessionFuture);
        this.terminalTitle = new TerminalTitle();
        Disposer.register((Disposable)parentDisposable, (Disposable)((Disposable)this));
        Disposer.register((Disposable)((Disposable)this), (Disposable)this.view);
        Disposer.register((Disposable)((Disposable)this), () -> ReworkedTerminalWidget._init_$lambda$0(this));
        this.ttyConnectorAccessor = new TtyConnectorAccessor();
    }

    @NotNull
    public TerminalTitle getTerminalTitle() {
        return this.terminalTitle;
    }

    @Nullable
    public TermSize getTermSize() {
        return this.view.getTerminalSize();
    }

    @Nullable
    public List<String> getShellCommand() {
        return this.shellCommand;
    }

    public void setShellCommand(@Nullable List<String> list) {
        this.shellCommand = list;
    }

    @Nullable
    public TerminalSession getSession() {
        return this.sessionFuture.getNow(null);
    }

    public void connectToSession(@NotNull TerminalSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.sessionFuture.complete(session2);
    }

    @NotNull
    public CompletableFuture<TermSize> getTerminalSizeInitializedFuture() {
        CompletionStage completionStage = this.view.getTerminalSizeInitializedFuture().thenApply(arg_0 -> ReworkedTerminalWidget.getTerminalSizeInitializedFuture$lambda$1(new Function1(this){
            final /* synthetic */ ReworkedTerminalWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final TermSize invoke(Object it) {
                return this.this$0.getTermSize();
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    @NotNull
    public JComponent getComponent() {
        return this.view.getComponent();
    }

    @NotNull
    public JComponent getPreferredFocusableComponent() {
        return this.view.getPreferredFocusableComponent();
    }

    public boolean hasFocus() {
        return this.view.isFocused();
    }

    public void requestFocus() {
        IdeFocusManager.getInstance((Project)this.project).requestFocus((Component)this.getPreferredFocusableComponent(), true);
    }

    public void sendCommandToExecute(@NotNull String shellCommand) {
        Intrinsics.checkNotNullParameter((Object)shellCommand, (String)"shellCommand");
        this.view.sendCommandToExecute(shellCommand);
    }

    public void addTerminationCallback(@NotNull Runnable onTerminated, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)onTerminated, (String)"onTerminated");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.view.addTerminationCallback(onTerminated, parentDisposable);
    }

    public void writePlainMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
    }

    public void setCursorVisible(boolean visible) {
    }

    public void addNotification(@NotNull JComponent notificationComponent, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)notificationComponent, (String)"notificationComponent");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
    }

    public void dispose() {
    }

    @NotNull
    public TtyConnectorAccessor getTtyConnectorAccessor() {
        return this.ttyConnectorAccessor;
    }

    public void connectToTty(@NotNull TtyConnector ttyConnector, @NotNull TermSize initialTermSize) {
        Intrinsics.checkNotNullParameter((Object)ttyConnector, (String)"ttyConnector");
        Intrinsics.checkNotNullParameter((Object)initialTermSize, (String)"initialTermSize");
        throw new IllegalStateException("connectToTty is not supported by ReworkedTerminalWidget, use connectToSession instead".toString());
    }

    private static final void _init_$lambda$0(ReworkedTerminalWidget this$0) {
        this$0.sessionFuture.complete(null);
    }

    private static final TermSize getTerminalSizeInitializedFuture$lambda$1(Function1 $tmp0, Object p0) {
        return (TermSize)$tmp0.invoke(p0);
    }
}

