/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.core;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.settingsSync.core.FileState;
import com.intellij.settingsSync.core.FileStateKt;
import com.intellij.settingsSync.core.SettingsProvider;
import com.intellij.settingsSync.core.SettingsSnapshot;
import com.intellij.settingsSync.core.SettingsSyncIdeMediatorImpl;
import com.intellij.settingsSync.core.plugins.SettingsSyncPluginsState;
import com.intellij.util.io.Compressor;
import com.intellij.util.io.Decompressor;
import java.io.Closeable;
import java.io.File;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u00010B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J-\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0018H\u0000\u00a2\u0006\u0002\b\u001aJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u0004\u0018\u00010\u000f2\u0006\u0010#\u001a\u00020\rJ3\u0010$\u001a \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0&0%2\u0006\u0010'\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b(J\u0010\u0010)\u001a\u00020!2\u0006\u0010*\u001a\u00020\rH\u0002J\u0010\u0010+\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020-2\u0006\u0010/\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/intellij/settingsSync/core/SettingsSnapshotZipSerializer;", "", "<init>", "()V", "METAINFO", "", "INFO", "PLUGINS", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "json", "Lkotlinx/serialization/json/Json;", "serializeToZip", "Ljava/nio/file/Path;", "snapshot", "Lcom/intellij/settingsSync/core/SettingsSnapshot;", "serializeToStream", "", "stream", "Ljava/io/OutputStream;", "serialize", "zipCompressor", "Lcom/intellij/util/io/Compressor$Zip;", "serializeSettingsProviders", "", "settingsFromProviders", "serializeSettingsProviders$intellij_settingsSync_core", "getContentForFileState", "", "fileState", "Lcom/intellij/settingsSync/core/FileState;", "serializePlugins", "plugins", "Lcom/intellij/settingsSync/core/plugins/SettingsSyncPluginsState;", "extractFromZip", "zipFile", "deserializeSettingsProviders", "Lkotlin/Pair;", "", "containingFolder", "deserializeSettingsProviders$intellij_settingsSync_core", "deserializePlugins", "metaInfoFolder", "serializeMetaInfo", "snapshotMetaInfo", "Lcom/intellij/settingsSync/core/SettingsSnapshot$MetaInfo;", "parseMetaInfo", "path", "MetaInfo", "intellij.settingsSync.core"})
@SourceDebugExtension(value={"SMAP\nSettingsSnapshotZipSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsSnapshotZipSerializer.kt\ncom/intellij/settingsSync/core/SettingsSnapshotZipSerializer\n+ 2 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,195:1\n113#2:196\n147#3:197\n15#4:198\n*S KotlinDebug\n*F\n+ 1 SettingsSnapshotZipSerializer.kt\ncom/intellij/settingsSync/core/SettingsSnapshotZipSerializer\n*L\n90#1:196\n138#1:197\n28#1:198\n*E\n"})
public final class SettingsSnapshotZipSerializer {
    @NotNull
    public static final SettingsSnapshotZipSerializer INSTANCE = new SettingsSnapshotZipSerializer();
    @NotNull
    private static final String METAINFO = ".metainfo";
    @NotNull
    private static final String INFO = "info.json";
    @NotNull
    public static final String PLUGINS = "plugins.json";
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Json json;

    private SettingsSnapshotZipSerializer() {
    }

    @NotNull
    public final Path serializeToZip(@NotNull SettingsSnapshot snapshot) {
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        File file = FileUtil.createTempFile((String)"settings.sync.snapshot.zip", null);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(...)");
        File file2 = file;
        this.serialize(snapshot, new Compressor.Zip(file2));
        Path path = file2.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        return path;
    }

    public final void serializeToStream(@NotNull SettingsSnapshot snapshot, @NotNull OutputStream stream) {
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        this.serialize(snapshot, new Compressor.Zip(stream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void serialize(SettingsSnapshot snapshot, Compressor.Zip zipCompressor) {
        Closeable closeable = (Closeable)zipCompressor;
        Throwable throwable = null;
        try {
            Compressor.Zip zip = (Compressor.Zip)closeable;
            boolean bl = false;
            zip.addFile(".metainfo/info.json", INSTANCE.serializeMetaInfo(snapshot.getMetaInfo()));
            if (snapshot.getPlugins() != null) {
                byte[] byArray = INSTANCE.serializePlugins(snapshot.getPlugins()).getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                zip.addFile(".metainfo/plugins.json", byArray);
            }
            for (FileState fileState : snapshot.getFileStates()) {
                zip.addFile(fileState.getFile(), INSTANCE.getContentForFileState(fileState));
            }
            for (Map.Entry entry : INSTANCE.serializeSettingsProviders$intellij_settingsSync_core(snapshot.getSettingsFromProviders()).entrySet()) {
                String relativePath = (String)entry.getKey();
                String content = (String)entry.getValue();
                String string = ".metainfo/" + relativePath;
                byte[] byArray = content.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                zip.addFile(string, byArray);
            }
            for (FileState fileState : snapshot.getAdditionalFiles()) {
                zip.addFile(".metainfo/" + fileState.getFile(), INSTANCE.getContentForFileState(fileState));
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public final Map<String, String> serializeSettingsProviders$intellij_settingsSync_core(@NotNull Map<String, ? extends Object> settingsFromProviders) {
        Intrinsics.checkNotNullParameter(settingsFromProviders, (String)"settingsFromProviders");
        Map pathsAndContents = new LinkedHashMap();
        for (Map.Entry<String, ? extends Object> entry : settingsFromProviders.entrySet()) {
            Object state;
            String id = entry.getKey();
            SettingsProvider<Object> provider = SettingsSyncIdeMediatorImpl.Companion.findProviderById$intellij_settingsSync_core(id, state = entry.getValue());
            if (provider == null) continue;
            try {
                String string = provider.serialize(state);
                pathsAndContents.put(id + "/" + provider.getFileName(), string);
            }
            catch (Exception e) {
                LOG.error("Could not serialize provider '" + id + "' with " + state, (Throwable)e);
            }
        }
        return pathsAndContents;
    }

    private final byte[] getContentForFileState(FileState fileState) {
        byte[] byArray;
        if (fileState instanceof FileState.Modified) {
            byArray = ((FileState.Modified)fileState).getContent();
        } else {
            String string = "DELETED";
            byte[] byArray2 = string.getBytes(Charsets.UTF_8);
            byArray = byArray2;
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        }
        return byArray;
    }

    private final String serializePlugins(SettingsSyncPluginsState plugins) {
        StringFormat $this$encodeToString$iv = (StringFormat)json;
        boolean $i$f$encodeToString = false;
        $this$encodeToString$iv.getSerializersModule();
        return $this$encodeToString$iv.encodeToString((SerializationStrategy)SettingsSyncPluginsState.Companion.serializer(), (Object)plugins);
    }

    @Nullable
    public final SettingsSnapshot extractFromZip(@NotNull Path zipFile) {
        Intrinsics.checkNotNullParameter((Object)zipFile, (String)"zipFile");
        try {
            Path tempDir = FileUtil.createTempDirectory((String)"settings.sync.updates", null).toPath();
            new Decompressor.Zip(zipFile).extract(tempDir);
            Intrinsics.checkNotNull((Object)tempDir);
            Path path = tempDir.resolve(METAINFO);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            Path metaInfoFolder = path;
            SettingsSnapshot.MetaInfo metaInfo = this.parseMetaInfo(metaInfoFolder);
            Set fileStates = Files.walk(tempDir, new FileVisitOption[0]).filter(arg_0 -> SettingsSnapshotZipSerializer.extractFromZip$lambda$3(arg_0 -> SettingsSnapshotZipSerializer.extractFromZip$lambda$2(metaInfoFolder, arg_0), arg_0)).map(arg_0 -> SettingsSnapshotZipSerializer.extractFromZip$lambda$5(arg_0 -> SettingsSnapshotZipSerializer.extractFromZip$lambda$4(tempDir, arg_0), arg_0)).collect(Collectors.toSet());
            Pair<Map<String, Object>, Set<Path>> pair = this.deserializeSettingsProviders$intellij_settingsSync_core(metaInfoFolder);
            Map settingsFromProviders = (Map)pair.component1();
            Set filesFromProviders = (Set)pair.component2();
            Set additionalFiles = Files.walk(metaInfoFolder, new FileVisitOption[0]).filter(arg_0 -> SettingsSnapshotZipSerializer.extractFromZip$lambda$7(arg_0 -> SettingsSnapshotZipSerializer.extractFromZip$lambda$6(filesFromProviders, arg_0), arg_0)).map(arg_0 -> SettingsSnapshotZipSerializer.extractFromZip$lambda$9(arg_0 -> SettingsSnapshotZipSerializer.extractFromZip$lambda$8(metaInfoFolder, arg_0), arg_0)).collect(Collectors.toSet());
            SettingsSyncPluginsState plugins = this.deserializePlugins(metaInfoFolder);
            Intrinsics.checkNotNull(fileStates);
            Intrinsics.checkNotNull(additionalFiles);
            return new SettingsSnapshot(metaInfo, fileStates, plugins, settingsFromProviders, additionalFiles);
        }
        catch (Exception ex) {
            LOG.warn("Cannot extract settings snapshot from zipFile", (Throwable)ex);
            return null;
        }
    }

    @NotNull
    public final Pair<Map<String, Object>, Set<Path>> deserializeSettingsProviders$intellij_settingsSync_core(@NotNull Path containingFolder) {
        Intrinsics.checkNotNullParameter((Object)containingFolder, (String)"containingFolder");
        Map settingsFromProviders = new LinkedHashMap();
        Set filesFromProviders = new LinkedHashSet();
        SettingsProvider.Companion.getSETTINGS_PROVIDER_EP().forEachExtensionSafe(arg_0 -> SettingsSnapshotZipSerializer.deserializeSettingsProviders$lambda$10(containingFolder, settingsFromProviders, filesFromProviders, arg_0));
        return TuplesKt.to((Object)settingsFromProviders, (Object)filesFromProviders);
    }

    /*
     * WARNING - void declaration
     */
    private final SettingsSyncPluginsState deserializePlugins(Path metaInfoFolder) {
        Path path = metaInfoFolder.resolve(PLUGINS);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path pluginsFile = path;
        try {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(pluginsFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                void this_$iv;
                Json json = SettingsSnapshotZipSerializer.json;
                String string$iv = PathsKt.readText$default((Path)pluginsFile, null, (int)1, null);
                boolean $i$f$decodeFromString = false;
                this_$iv.getSerializersModule();
                return (SettingsSyncPluginsState)this_$iv.decodeFromString((DeserializationStrategy)SettingsSyncPluginsState.Companion.serializer(), string$iv);
            }
        }
        catch (Throwable e) {
            LOG.error("Failed to read " + pluginsFile, e);
        }
        return new SettingsSyncPluginsState(MapsKt.emptyMap());
    }

    private final byte[] serializeMetaInfo(SettingsSnapshot.MetaInfo snapshotMetaInfo) {
        MetaInfo metaInfo;
        String formattedDate = DateTimeFormatter.ISO_INSTANT.format(snapshotMetaInfo.getDateCreated());
        MetaInfo $this$serializeMetaInfo_u24lambda_u2411 = metaInfo = new MetaInfo();
        boolean bl = false;
        $this$serializeMetaInfo_u24lambda_u2411.setDate(formattedDate);
        SettingsSnapshot.AppInfo appInfo = snapshotMetaInfo.getAppInfo();
        $this$serializeMetaInfo_u24lambda_u2411.setApplicationId(String.valueOf(appInfo != null ? appInfo.getApplicationId() : null));
        Object object = snapshotMetaInfo.getAppInfo();
        if (object == null || (object = ((SettingsSnapshot.AppInfo)object).getBuildNumber()) == null || (object = object.asString()) == null) {
            object = "";
        }
        $this$serializeMetaInfo_u24lambda_u2411.setBuildNumber((String)object);
        SettingsSnapshot.AppInfo appInfo2 = snapshotMetaInfo.getAppInfo();
        $this$serializeMetaInfo_u24lambda_u2411.setUserName(String.valueOf(appInfo2 != null ? appInfo2.getUserName() : null));
        SettingsSnapshot.AppInfo appInfo3 = snapshotMetaInfo.getAppInfo();
        $this$serializeMetaInfo_u24lambda_u2411.setHostName(String.valueOf(appInfo3 != null ? appInfo3.getHostName() : null));
        SettingsSnapshot.AppInfo appInfo4 = snapshotMetaInfo.getAppInfo();
        $this$serializeMetaInfo_u24lambda_u2411.setConfigFolder(String.valueOf(appInfo4 != null ? appInfo4.getConfigFolder() : null));
        $this$serializeMetaInfo_u24lambda_u2411.setDeleted(snapshotMetaInfo.isDeleted());
        MetaInfo metaInfo2 = metaInfo;
        byte[] byArray = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsBytes((Object)metaInfo2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"writeValueAsBytes(...)");
        return byArray;
    }

    private final SettingsSnapshot.MetaInfo parseMetaInfo(Path path) {
        try {
            Path path2 = path.resolve(INFO);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
            Path infoFile = path2;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(infoFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                MetaInfo metaInfo = (MetaInfo)new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readValue(PathsKt.readText$default((Path)infoFile, null, (int)1, null), MetaInfo.class);
                Instant date = DateTimeFormatter.ISO_INSTANT.parse((CharSequence)metaInfo.getDate(), Instant::from);
                UUID uUID = UUID.fromString(metaInfo.getApplicationId());
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(...)");
                SettingsSnapshot.AppInfo appInfo = new SettingsSnapshot.AppInfo(uUID, BuildNumber.fromString((String)metaInfo.getBuildNumber()), metaInfo.getUserName(), metaInfo.getHostName(), metaInfo.getConfigFolder());
                Intrinsics.checkNotNull((Object)date);
                return new SettingsSnapshot.MetaInfo(date, appInfo, metaInfo.isDeleted());
            }
            LOG.warn("Timestamp file doesn't exist");
        }
        catch (Throwable e) {
            LOG.error("Couldn't read .metainfo from settings.sync.snapshot.zip", e);
        }
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        return new SettingsSnapshot.MetaInfo(instant, null, false, 4, null);
    }

    private static final Unit json$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setPrettyPrint(true);
        return Unit.INSTANCE;
    }

    private static final boolean extractFromZip$lambda$2(Path $metaInfoFolder, Path it) {
        Intrinsics.checkNotNull((Object)it);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.isRegularFile(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && !it.startsWith($metaInfoFolder);
    }

    private static final boolean extractFromZip$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final FileState extractFromZip$lambda$4(Path $tempDir, Path it) {
        Intrinsics.checkNotNull((Object)it);
        Intrinsics.checkNotNull((Object)$tempDir);
        return FileStateKt.getFileStateFromFileWithDeletedMarker(it, $tempDir);
    }

    private static final FileState extractFromZip$lambda$5(Function1 $tmp0, Object p0) {
        return (FileState)$tmp0.invoke(p0);
    }

    private static final boolean extractFromZip$lambda$6(Set $filesFromProviders, Path it) {
        Intrinsics.checkNotNull((Object)it);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.isRegularFile(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && !Intrinsics.areEqual((Object)PathsKt.getName((Path)it), (Object)INFO) && !Intrinsics.areEqual((Object)PathsKt.getName((Path)it), (Object)PLUGINS) && !$filesFromProviders.contains(it);
    }

    private static final boolean extractFromZip$lambda$7(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final FileState extractFromZip$lambda$8(Path $metaInfoFolder, Path it) {
        Intrinsics.checkNotNull((Object)it);
        return FileStateKt.getFileStateFromFileWithDeletedMarker(it, $metaInfoFolder);
    }

    private static final FileState extractFromZip$lambda$9(Function1 $tmp0, Object p0) {
        return (FileState)$tmp0.invoke(p0);
    }

    private static final void deserializeSettingsProviders$lambda$10(Path $containingFolder, Map $settingsFromProviders, Set $filesFromProviders, SettingsProvider it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Path file = $containingFolder.resolve(it.getId()).resolve(it.getFileName());
        Intrinsics.checkNotNull((Object)file);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            Object state = it.deserialize(PathsKt.readText$default((Path)file, null, (int)1, null));
            $settingsFromProviders.put(it.getId(), state);
            $filesFromProviders.add(file);
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SettingsSnapshotZipSerializer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        json = JsonKt.Json$default(null, SettingsSnapshotZipSerializer::json$lambda$0, (int)1, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR\u001a\u0010\u0010\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\tR\u001a\u0010\u0013\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0007\"\u0004\b\u0015\u0010\tR\u001a\u0010\u0016\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0007\"\u0004\b\u0018\u0010\tR\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lcom/intellij/settingsSync/core/SettingsSnapshotZipSerializer$MetaInfo;", "", "<init>", "()V", "date", "", "getDate", "()Ljava/lang/String;", "setDate", "(Ljava/lang/String;)V", "applicationId", "getApplicationId", "setApplicationId", "buildNumber", "getBuildNumber", "setBuildNumber", "userName", "getUserName", "setUserName", "hostName", "getHostName", "setHostName", "configFolder", "getConfigFolder", "setConfigFolder", "isDeleted", "", "()Z", "setDeleted", "(Z)V", "intellij.settingsSync.core"})
    private static final class MetaInfo {
        public String date;
        public String applicationId;
        @NotNull
        private String buildNumber = "";
        @NotNull
        private String userName = "";
        @NotNull
        private String hostName = "";
        @NotNull
        private String configFolder = "";
        private boolean isDeleted;

        @NotNull
        public final String getDate() {
            String string = this.date;
            if (string != null) {
                return string;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"date");
            return null;
        }

        public final void setDate(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.date = string;
        }

        @NotNull
        public final String getApplicationId() {
            String string = this.applicationId;
            if (string != null) {
                return string;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"applicationId");
            return null;
        }

        public final void setApplicationId(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.applicationId = string;
        }

        @NotNull
        public final String getBuildNumber() {
            return this.buildNumber;
        }

        public final void setBuildNumber(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.buildNumber = string;
        }

        @NotNull
        public final String getUserName() {
            return this.userName;
        }

        public final void setUserName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.userName = string;
        }

        @NotNull
        public final String getHostName() {
            return this.hostName;
        }

        public final void setHostName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.hostName = string;
        }

        @NotNull
        public final String getConfigFolder() {
            return this.configFolder;
        }

        public final void setConfigFolder(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.configFolder = string;
        }

        public final boolean isDeleted() {
            return this.isDeleted;
        }

        public final void setDeleted(boolean bl) {
            this.isDeleted = bl;
        }
    }
}

