/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.TabGroupId;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.history.FileHistoryUi;
import com.intellij.vcs.log.history.FileHistoryUiFactory;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u00002\u00020\u0001:\u0001\u001dB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J*\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0007J2\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001c\u001a\u00020\u0010H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryTabsManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "tabGroupId", "Lcom/intellij/ui/content/TabGroupId;", "historyTabs", "", "Lcom/intellij/vcs/log/history/FileHistoryTabsManager$FileHistoryTab;", "isLogDisposing", "", "openFileHistoryTab", "Lcom/intellij/vcs/log/history/FileHistoryUi;", "logManager", "Lcom/intellij/vcs/log/impl/VcsLogManager;", "path", "Lcom/intellij/openapi/vcs/FilePath;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "hash", "Lcom/intellij/vcs/log/Hash;", "doOpenFileHistoryTab", "focus", "FileHistoryTab", "intellij.platform.vcs.log.impl"})
public final class FileHistoryTabsManager {
    @NotNull
    private final Project project;
    @NotNull
    private final TabGroupId tabGroupId;
    @NotNull
    private final List<FileHistoryTab> historyTabs;
    private boolean isLogDisposing;

    public FileHistoryTabsManager(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        Supplier supplier = VcsBundle.messagePointer((String)"file.history.tab.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)supplier, (String)"messagePointer(...)");
        this.tabGroupId = new TabGroupId("History", supplier, false);
        this.historyTabs = new ArrayList();
        this.project.getMessageBus().connect(coroutineScope).subscribe(VcsProjectLog.VCS_PROJECT_LOG_CHANGED, (Object)new VcsProjectLog.ProjectLogListener(){

            @Override
            public void logCreated(VcsLogManager manager) {
                Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
                isLogDisposing = false;
                ToolWindowManager.Companion.getInstance(this.getProject()).invokeLater(() -> 1.logCreated$lambda$3(manager, this));
            }

            @Override
            public void logDisposed(VcsLogManager manager) {
                Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
                isLogDisposing = true;
            }

            private static final boolean logCreated$lambda$3$lambda$0(VcsLogManager $manager, FileHistoryTab it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return !$manager.getDataManager().getLogProviders().keySet().contains(it.getRoot());
            }

            private static final boolean logCreated$lambda$3$lambda$1(Function1 $tmp0, Object p0) {
                return (Boolean)$tmp0.invoke(p0);
            }

            private static final void logCreated$lambda$3(VcsLogManager $manager, FileHistoryTabsManager this$0) {
                if ($manager.isDisposed()) {
                    return;
                }
                this$0.historyTabs.removeIf(arg_0 -> 1.logCreated$lambda$3$lambda$1(arg_0 -> 1.logCreated$lambda$3$lambda$0($manager, arg_0), arg_0));
                Iterable $this$forEach$iv = this$0.historyTabs;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    FileHistoryTab fileHistoryTab = (FileHistoryTab)element$iv;
                    boolean bl = false;
                    FilePath path = fileHistoryTab.component1();
                    VirtualFile root = fileHistoryTab.component2();
                    Hash hash = fileHistoryTab.component3();
                    this$0.doOpenFileHistoryTab($manager, path, root, hash, false);
                }
            }
        });
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @RequiresEdt
    @NotNull
    public final FileHistoryUi openFileHistoryTab(@NotNull VcsLogManager logManager2, @NotNull FilePath path, @NotNull VirtualFile root, @Nullable Hash hash) {
        Intrinsics.checkNotNullParameter((Object)logManager2, (String)"logManager");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.historyTabs.add(new FileHistoryTab(path, root, hash));
        return this.doOpenFileHistoryTab(logManager2, path, root, hash, true);
    }

    private final FileHistoryUi doOpenFileHistoryTab(VcsLogManager logManager2, FilePath path, VirtualFile root, Hash hash, boolean focus) {
        Hash hash2 = hash;
        Object suffix = hash2 != null ? " (" + hash2.toShortString() + ")" : "";
        FileHistoryUi fileHistoryUi = VcsLogContentUtil.openLogTab(this.project, logManager2, this.tabGroupId, arg_0 -> FileHistoryTabsManager.doOpenFileHistoryTab$lambda$0(path, (String)suffix, arg_0), new FileHistoryUiFactory(path, root, hash), focus);
        Disposer.register((Disposable)fileHistoryUi, () -> FileHistoryTabsManager.doOpenFileHistoryTab$lambda$1(this, path, root, hash));
        Intrinsics.checkNotNull((Object)fileHistoryUi);
        return fileHistoryUi;
    }

    private static final String doOpenFileHistoryTab$lambda$0(FilePath $path, String $suffix, FileHistoryUi it) {
        return $path.getName() + $suffix;
    }

    private static final void doOpenFileHistoryTab$lambda$1(FileHistoryTabsManager this$0, FilePath $path, VirtualFile $root, Hash $hash) {
        if (!this$0.isLogDisposing) {
            this$0.historyTabs.remove(new FileHistoryTab($path, $root, $hash));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryTabsManager$FileHistoryTab;", "", "path", "Lcom/intellij/openapi/vcs/FilePath;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "hash", "Lcom/intellij/vcs/log/Hash;", "<init>", "(Lcom/intellij/openapi/vcs/FilePath;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/vcs/log/Hash;)V", "getPath", "()Lcom/intellij/openapi/vcs/FilePath;", "getRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getHash", "()Lcom/intellij/vcs/log/Hash;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.vcs.log.impl"})
    private static final class FileHistoryTab {
        @NotNull
        private final FilePath path;
        @NotNull
        private final VirtualFile root;
        @Nullable
        private final Hash hash;

        public FileHistoryTab(@NotNull FilePath path, @NotNull VirtualFile root, @Nullable Hash hash) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            this.path = path;
            this.root = root;
            this.hash = hash;
        }

        @NotNull
        public final FilePath getPath() {
            return this.path;
        }

        @NotNull
        public final VirtualFile getRoot() {
            return this.root;
        }

        @Nullable
        public final Hash getHash() {
            return this.hash;
        }

        @NotNull
        public final FilePath component1() {
            return this.path;
        }

        @NotNull
        public final VirtualFile component2() {
            return this.root;
        }

        @Nullable
        public final Hash component3() {
            return this.hash;
        }

        @NotNull
        public final FileHistoryTab copy(@NotNull FilePath path, @NotNull VirtualFile root, @Nullable Hash hash) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            return new FileHistoryTab(path, root, hash);
        }

        public static /* synthetic */ FileHistoryTab copy$default(FileHistoryTab fileHistoryTab, FilePath filePath, VirtualFile virtualFile, Hash hash, int n, Object object) {
            if ((n & 1) != 0) {
                filePath = fileHistoryTab.path;
            }
            if ((n & 2) != 0) {
                virtualFile = fileHistoryTab.root;
            }
            if ((n & 4) != 0) {
                hash = fileHistoryTab.hash;
            }
            return fileHistoryTab.copy(filePath, virtualFile, hash);
        }

        @NotNull
        public String toString() {
            return "FileHistoryTab(path=" + this.path + ", root=" + this.root + ", hash=" + this.hash + ")";
        }

        public int hashCode() {
            int result = this.path.hashCode();
            result = result * 31 + this.root.hashCode();
            result = result * 31 + (this.hash == null ? 0 : this.hash.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FileHistoryTab)) {
                return false;
            }
            FileHistoryTab fileHistoryTab = (FileHistoryTab)other;
            if (!Intrinsics.areEqual((Object)this.path, (Object)fileHistoryTab.path)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.root, (Object)fileHistoryTab.root)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.hash, (Object)fileHistoryTab.hash);
        }
    }
}

