/*
 * Copyright 2019-2021 Hans-Kristian Arntzen for Valve Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#pragma once

#include "thread_local_allocator.hpp"
#include "dxil_converter.hpp"
#include "ir.hpp"

#ifdef HAVE_LLVMBC
#include "cast.hpp"
#include "instruction.hpp"
#include "module.hpp"
#include "value.hpp"
#else
#include <llvm/IR/Instructions.h>
#endif

#include <vector>

namespace dxil_spv
{
enum class RawWidth { B16 = 0, B32, B64, Count };
enum class RawVecSize { V1 = 0, V2, V3, V4, Count };
}
