/*
  Copyright (C) 2004-2005 Tommi Tervonen, Petteri Klemola, Pasi Orovuo

  This file is part of Kajaani Kombat.

  Kajaani Kombat is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  Kajaani Kombat is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with Kajaani Kombat; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __GFX_FUNCTIONS_H
#define __GFX_FUNCTIONS_H

#include "SDL.h"
#include "coord.h"
#include "SDL_ttf.h"
#include "SDL_image.h"
#include <cstdlib>
#include <string>
#include "globals.h"

inline int center_xcoord(SDL_Surface *s) {return (SCR_WIDTH/2) - (s->w/2);}
extern SDL_Surface *img_load (const char *fname);
extern TTF_Font *font_load (const char *fname, int size);
extern SDL_Surface *copy_surface (SDL_Surface *surf);
extern SDL_Surface *deep_copy_surface (SDL_Surface *surf);
extern SDL_Rect draw_text (SDL_Surface *dest, TTF_Font *font, const char *text, const coord &c);
extern SDL_Rect draw_text (SDL_Surface *dest, TTF_Font *font, const char *text, const coord &c, SDL_Color &col);
extern SDL_Rect draw_text_baseline (SDL_Surface *dst, TTF_Font *font, const char *text, const coord &c);
extern SDL_Rect draw_text_baseline (SDL_Surface *dst, TTF_Font *font, const char *text, const coord &c, SDL_Color &col);
extern SDL_Rect draw_text_centered (SDL_Surface *dst, TTF_Font *font, const char *text, const coord &c, SDL_Color &col);
extern SDL_Rect draw_text_centered (SDL_Surface *dst, TTF_Font *font, const char *text, const coord &c);
extern SDL_Rect draw_text_baseline_centered (SDL_Surface *dst, TTF_Font *font, const char *text, const coord &c, SDL_Color &col);

extern void draw_hline (SDL_Surface *dst, const coord &spos, const coord &dpos, Uint32 col);
extern void draw_vline (SDL_Surface *dst, const coord &spos, const coord &dpos, Uint32 col);
extern void draw_rectangle (SDL_Surface *dst, const coord &spos, const coord &dpos, Uint32 col);

extern void pix_compext (Uint32 pix, int &r, int &g, int &b, int &a);

inline Uint32 pix_pack (int r, int g, int b, int a)
{ return (a << 24) | (r << 16) | (g << 8) | b; }



#endif
