/*
  Copyright (C) 2004-2005 Tommi Tervonen, Petteri Klemola, Pasi Orovuo

  This file is part of Kajaani Kombat.

  Kajaani Kombat is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  Kajaani Kombat is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with Kajaani Kombat; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "mosaic.h"

mosaic::mosaic(SDL_Surface *_surf, SDL_Surface *_dest,Uint32 stime, bool _reverse)
{
  start_time=stime;
  o_time=stime;
  reverse=_reverse;
  if(reverse)
    blocksize=41;
  else
    blocksize=1;
  surf=_surf;
  dest=_dest;


  
  orginal= SDL_CreateRGBSurface (SDL_SWSURFACE, surf->w, surf->h, surf->format->BitsPerPixel,
			surf->format->Rmask, surf->format->Gmask,
			surf->format->Bmask, surf->format->Amask);
  SDL_BlitSurface (surf, NULL, orginal, NULL);
  
  finished=false;
}

mosaic::~mosaic()
{
  SDL_FreeSurface(orginal);
}

void mosaic::draw_mosaic()
{
  //int aa=blocksize;
  //only for 4 bytes per pixel surfaces
  if(surf->format->BytesPerPixel!=4)
    return;

  if(blocksize>=surf->h || blocksize>=surf->w)
    return;

  SDL_Rect ruutu;
  double nelio=sqrt(2.0);

  if(surf->h%blocksize==0 && surf->w%blocksize==0)
    {

  for(int y=0; y<=(surf->h-blocksize);y=y+blocksize)
    {
      for(int x=0; x<=(surf->w-blocksize);x=x+blocksize)
	{

	  ruutu.x=x;
	  ruutu.y=y;
	  ruutu.h=blocksize;
	  ruutu.w=blocksize;
	  
	  double temp = (blocksize * nelio)/2;
	  int xx= x+(int)temp;
	  int yy= y+(int)temp;
	  
	  Uint8 *p = (Uint8 *)surf->pixels + yy * surf->pitch + xx * 4;
	  
	  Uint32 tpikseli =*(Uint32 *)p;
	  
	  SDL_FillRect(dest, &ruutu, tpikseli);
	}
     
      if(start_time+16<SDL_GetTicks())
	{
	  //printf("nyt tippu tll blocksize on %i\n",blocksize);
	  return;

	}
      	  

    }

  }
  else
    return;
}

void mosaic::update(Uint32 ctime)
{
  if(finished)
    return;

  if(!(o_time+400>ctime))
    {
      finished=true;
      //printf("nyt tippu blocksize on %i\n",blocksize);
      return;
    }


  if(reverse)
    {
      
      if((start_time+20)<ctime)
	{
	  start_time=ctime;
	  
	  for(int x=8;x>-1;x--)
	    {
	      if(blocksize>bsizes[x])
		{
		  blocksize=bsizes[x];
		  //surf=SDL_CreateRGBSurface (SDL_SWSURFACE, orginal->w, orginal->h, orginal->format->BitsPerPixel,
		  //orginal->format->Rmask, orginal->format->Gmask,
		  //			   orginal->format->Bmask, orginal->format->Amask);
		  
		  if(blocksize!=bsizes[8])
		    SDL_BlitSurface (orginal, NULL, surf, NULL);
		  
		  
		  
		  draw_mosaic();
		  break;
		}
	    }
	  
	  
	  


	  if(blocksize==bsizes[0])
	    {
	      finished=true;
	    }
	  
	}
    }
  else
    {
      if((start_time+1)<ctime)
	{
	  start_time=ctime;
	  
	  for(int x=0;x<9;x++)
	    {
	      if(blocksize<bsizes[x])
		{
		  blocksize=bsizes[x];
		  draw_mosaic();
		  break;
		}
	    }
	}
	  if(blocksize==bsizes[8])
	    {
	      finished=true;
	    }

    }
}
    
bool mosaic::is_finished()
{
  return finished;
}
