/* 
* Copyright (C) 2001-2024 Jacek Sieka, arnetheduck on gmail point com
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef DCPP_USERINFOBASE_H
#define DCPP_USERINFOBASE_H

#include <airdcpp/forward.h>


namespace dcpp
{

class UserInfoBase {
public:
	UserInfoBase() { }
	
	void getList();
	void browseList();
	void getBrowseList();
	void matchQueue();
	void pm();

	void grant();
	void grantTimeless();
	void grantHour();
	void grantDay();
	void grantWeek();
	void ungrant();
	void handleFav();
	void removeAll();
	void connectFav();
	bool hasReservedSlot();
	
	virtual const UserPtr& getUser() const = 0;
	virtual const string& getHubUrl() const = 0;
};

} // namespace dcpp

#endif