/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.urldata.http.element;

import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.EqualsUtil;
import org.jivesoftware.smack.util.HashCode;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.urldata.http.element.NameValuePairElement;

public class CookieElement
extends NameValuePairElement {
    public static final String ELEMENT = "cookie";
    public static final String PREFIX = "http";
    public static final String ATTR_DOMAIN = "domain";
    public static final String ATTR_MAX_AGE = "max-age";
    public static final String ATTR_PATH = "path";
    public static final String ATTR_COMMENT = "comment";
    public static final String ATTR_VERSION = "version";
    public static final String ATTR_SECURE = "secure";
    private final String domain;
    private final Integer maxAge;
    private final String path;
    private final String comment;
    private final String version;
    private final Boolean secure;

    public CookieElement(String name, String value) {
        this(name, value, null, null, null, null, null, null);
    }

    public CookieElement(String name, String value, String domain, Integer maxAge, String path, String comment, String version, Boolean secure) {
        super(name, value);
        this.domain = domain;
        this.maxAge = maxAge;
        this.path = path;
        this.comment = comment;
        this.version = version;
        this.secure = secure;
    }

    public String getPath() {
        return this.path;
    }

    public int getMaxAge() {
        return this.maxAge == null ? 0 : this.maxAge;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getComment() {
        return this.comment;
    }

    public String getVersion() {
        return this.version == null ? "1.0" : this.version;
    }

    public boolean isSecure() {
        return this.secure != null && this.secure != false;
    }

    @Override
    public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
        XmlStringBuilder sb = this.addCommonXml(new XmlStringBuilder(this)).optAttribute(ATTR_DOMAIN, this.domain).optAttribute(ATTR_MAX_AGE, this.maxAge).optAttribute(ATTR_PATH, this.path).optAttribute(ATTR_COMMENT, this.comment).optAttribute(ATTR_VERSION, this.version);
        if (this.secure != null) {
            sb.attribute(ATTR_SECURE, this.secure);
        }
        return sb.closeEmptyElement();
    }

    @Override
    public String getElementName() {
        return "http:cookie";
    }

    public int hashCode() {
        return HashCode.builder().append(this.getElementName()).append(this.getName()).append(this.getValue()).append(this.getDomain()).append(this.getMaxAge()).append(this.getPath()).append(this.getComment()).append(this.getVersion()).append(this.isSecure()).build();
    }

    public boolean equals(Object obj) {
        return EqualsUtil.equals(this, obj, (equalsBuilder, other) -> equalsBuilder.append(this.getElementName(), other.getElementName()).append(this.getName(), other.getName()).append(this.getValue(), other.getValue()).append(this.getDomain(), other.getDomain()).append(this.getMaxAge(), other.getMaxAge()).append(this.getPath(), other.getPath()).append(this.getComment(), other.getComment()).append(this.getVersion(), other.getVersion()).append(this.isSecure(), other.isSecure()));
    }
}

