/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.packet;

import java.io.IOException;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jxmpp.JxmppContext;

public class RoomTransfer
implements ExtensionElement {
    public static final String ELEMENT_NAME = "transfer";
    public static final String NAMESPACE = "http://jabber.org/protocol/workgroup";
    public static final QName QNAME = new QName("http://jabber.org/protocol/workgroup", "transfer");
    private Type type;
    private String invitee;
    private String inviter;
    private String sessionID;
    private String room;
    private String reason;

    public RoomTransfer(Type type, String invitee, String sessionID, String reason) {
        this.type = type;
        this.invitee = invitee;
        this.sessionID = sessionID;
        this.reason = reason;
    }

    private RoomTransfer() {
    }

    @Override
    public String getElementName() {
        return ELEMENT_NAME;
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    public String getInviter() {
        return this.inviter;
    }

    public String getRoom() {
        return this.room;
    }

    public String getReason() {
        return this.reason;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    @Override
    public XmlStringBuilder toXML(XmlEnvironment enclosingNamespace) {
        IQ.IQChildElementXmlStringBuilder xml = this.getIQChildElementBuilder(new IQ.IQChildElementXmlStringBuilder(this, enclosingNamespace));
        xml.closeElement(this);
        return xml;
    }

    public IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder buf) {
        buf.append(" type=\"").append(this.type.name()).append("\">");
        buf.append("<session xmlns=\"http://jivesoftware.com/protocol/workgroup\" id=\"").append(this.sessionID).append("\"></session>");
        if (this.invitee != null) {
            buf.append("<invitee>").append(this.invitee).append("</invitee>");
        }
        if (this.inviter != null) {
            buf.append("<inviter>").append(this.inviter).append("</inviter>");
        }
        if (this.reason != null) {
            buf.append("<reason>").append(this.reason).append("</reason>");
        }
        return buf;
    }

    public static enum Type {
        user,
        queue,
        workgroup;

    }

    public static class Provider
    extends ExtensionElementProvider<RoomTransfer> {
        @Override
        public RoomTransfer parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment, JxmppContext jxmppContext) throws XmlPullParserException, IOException {
            RoomTransfer invitation = new RoomTransfer();
            invitation.type = Type.valueOf(parser.getAttributeValue("", "type"));
            while (true) {
                parser.next();
                if (parser.getEventType() == XmlPullParser.Event.START_ELEMENT) {
                    String elementName = parser.getName();
                    if ("session".equals(elementName)) {
                        invitation.sessionID = parser.getAttributeValue("", "id");
                        continue;
                    }
                    if ("invitee".equals(elementName)) {
                        invitation.invitee = parser.nextText();
                        continue;
                    }
                    if ("inviter".equals(elementName)) {
                        invitation.inviter = parser.nextText();
                        continue;
                    }
                    if ("reason".equals(elementName)) {
                        invitation.reason = parser.nextText();
                        continue;
                    }
                    if (!"room".equals(elementName)) continue;
                    invitation.room = parser.nextText();
                    continue;
                }
                if (parser.getEventType() == XmlPullParser.Event.END_ELEMENT && parser.getDepth() == initialDepth) break;
            }
            return invitation;
        }
    }

    public static class RoomTransferIQ
    extends IQ {
        private final RoomTransfer roomTransfer;

        public RoomTransferIQ(RoomTransfer roomTransfer) {
            super(RoomTransfer.ELEMENT_NAME, RoomTransfer.NAMESPACE);
            this.roomTransfer = roomTransfer;
        }

        @Override
        protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder xml) {
            return this.roomTransfer.getIQChildElementBuilder(xml);
        }
    }
}

