
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define LINESIZE 100
#define MAXFH 100
#define MAXNT 2048

static int ptr[256];
static unsigned long token[MAXNT];
char buf[LINESIZE];
int nt;
static char comment[256][LINESIZE];
static char filehead[MAXFH][LINESIZE];

void addtoken(unsigned long t)
{
	if (nt >= MAXNT) 
	{ 
		fprintf(stderr, "Too many Unicode entries. Recompile "
				"map2uni with a bigger MAXNT\n"); 
		exit(1); 
	}

        if (t < 0x20 || (t >= 0x7F && t < 0xA0))
        {
		fprintf(stderr, "Token 0x%lx (control code) ignored!\n", t);
		return;	
	}
	token[nt++] = t;
}

void setup_map(int nc, char *p)
{
	char *tmp;
	unsigned long uni;

	ptr[nc] = nt;
	if ((tmp = strstr(p, "0x")))
	{
		sscanf(tmp, "0x%lx", &uni);
		addtoken(uni);
		p = tmp + 1;
	}
	addtoken(0xFFFF);
}

int main(int argc, char **argv)
{
	nt = 0;
	int from;
	char *p, *c;
	FILE *fp = fopen(argv[2], "r");
	int fh = 0;

	/* Characters not named will default to entry 0, no mapping */
	addtoken(0xFFFF);
	while (fgets(buf, LINESIZE, fp))
	{
		if (buf[0] == '#' && fh >= 0 && fh < MAXFH)
		{
			strcpy(filehead[fh], buf + 1);
			p = strchr(filehead[fh], '\n');
			if (p) *p = 0;
			++fh;
		}
		if (buf[0] != '0') continue;
		fh = -1;
		
		sscanf(buf, "0x%x", &from);
	
		c = strchr(buf, '#');
		if (c) 
		{
			*c = 0;
			c++;
			p = strchr(c, '\n');
			if (p) *p = 0;
			strcpy(comment[from], c);
		}
		setup_map(from++, buf + 4);	
	}
	fclose(fp);
	p = strchr(argv[1], '.');
	if (p) *p = 0;
	p = strchr(argv[1], '-');
	if (p) *p = '_';

	printf("/* This file was autogenerated from the file \n"
	       " * %s from UNICODE.ORG */\n\n", argv[2]);
	for (from = 0; from < MAXFH; from++)
	{
		if (filehead[from][0])
			printf("/* %s */\n", filehead[from]);
	}
	printf("#include <stdio.h>\n#include \"psflib.h\"\n\n");
	printf("static psf_dword values[] = {\n");
	for (from = 0; from < nt; from++)
	{
		printf("0x%04lx, ", token[from]); 
		if ((from & 7) == 7) printf("\n");
	}
	printf("};\n\n");

	printf("struct psf_mapping m_%s = { ", argv[1]);
	p = strchr(argv[1], '_');
	if (p) *p = '-';
	printf("\"%s\", {\n", argv[1]);

	for (from = 0; from < 256; from++)
	{
		printf("&values[%d], /* %d %s */\n", ptr[from], from, comment[from]); 
	}
	printf("}};\n");

	return 0;
}
