/*
 * Decompiled with CFR 0.152.
 */
package jwbroek.cuelib;

import java.io.File;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jwbroek.cuelib.CueSheet;
import jwbroek.cuelib.FileData;
import jwbroek.cuelib.Index;
import jwbroek.cuelib.Position;
import jwbroek.cuelib.TrackData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CueSheetToXmlSerializer {
    private DocumentBuilder docBuilder;
    private String namespace = "http://jwbroek/cuelib/2008/cuesheet/1";
    private static final Logger logger = Logger.getLogger(CueSheetToXmlSerializer.class.getCanonicalName());

    public CueSheetToXmlSerializer() throws ParserConfigurationException {
        logger.entering(CueSheetToXmlSerializer.class.getCanonicalName(), "CueSheetToXmlSerializer()");
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        this.docBuilder = documentBuilderFactory.newDocumentBuilder();
        logger.exiting(CueSheetToXmlSerializer.class.getCanonicalName(), "CueSheetToXmlSerializer()");
    }

    public void serializeCueSheet(CueSheet cueSheet, Writer writer) throws TransformerException {
        logger.entering(CueSheetToXmlSerializer.class.getCanonicalName(), "serializeCueSheet(CueSheet,Writer)", new Object[]{cueSheet, writer});
        this.serializeCueSheet(cueSheet, new StreamResult(writer));
        logger.exiting(CueSheetToXmlSerializer.class.getCanonicalName(), "serializeCueSheet(CueSheet,Writer)");
    }

    public void serializeCueSheet(CueSheet cueSheet, OutputStream outputStream) throws TransformerException {
        logger.entering(CueSheetToXmlSerializer.class.getCanonicalName(), "serializeCueSheet(CueSheet,OutputStream)", new Object[]{cueSheet, outputStream});
        this.serializeCueSheet(cueSheet, new StreamResult(outputStream));
        logger.exiting(CueSheetToXmlSerializer.class.getCanonicalName(), "serializeCueSheet(CueSheet,OutputStream)");
    }

    public void serializeCueSheet(CueSheet cueSheet, File file) throws TransformerException {
        logger.entering(CueSheetToXmlSerializer.class.getCanonicalName(), "serializeCueSheet(CueSheet,File)", new Object[]{cueSheet, file});
        this.serializeCueSheet(cueSheet, new StreamResult(file));
        logger.exiting(CueSheetToXmlSerializer.class.getCanonicalName(), "serializeCueSheet(CueSheet,File)");
    }

    public void serializeCueSheet(CueSheet cueSheet, Result result) throws TransformerException {
        logger.entering(CueSheetToXmlSerializer.class.getCanonicalName(), "serializeCueSheet(CueSheet,Result)", new Object[]{cueSheet, result});
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource dOMSource = new DOMSource(this.serializeCueSheet(cueSheet));
        transformer.transform(dOMSource, result);
        logger.exiting(CueSheetToXmlSerializer.class.getCanonicalName(), "serializeCueSheet(CueSheet,Result)");
    }

    public Document serializeCueSheet(CueSheet cueSheet) {
        logger.entering(CueSheetToXmlSerializer.class.getCanonicalName(), "serializeCueSheet(CueSheet)", cueSheet);
        Document document = this.docBuilder.newDocument();
        Element element = document.createElementNS(this.namespace, "cuesheet");
        document.appendChild(element);
        this.addAttribute(element, "genre", cueSheet.getGenre());
        this.addAttribute(element, "date", cueSheet.getYear());
        this.addAttribute(element, "discid", cueSheet.getDiscid());
        this.addAttribute(element, "comment", cueSheet.getComment());
        this.addAttribute(element, "catalog", cueSheet.getCatalog());
        this.addAttribute(element, "performer", cueSheet.getPerformer());
        this.addAttribute(element, "title", cueSheet.getTitle());
        this.addAttribute(element, "songwriter", cueSheet.getSongwriter());
        this.addAttribute(element, "cdtextfile", cueSheet.getCdTextFile());
        for (FileData fileData : cueSheet.getFileData()) {
            this.serializeFileData(element, fileData);
        }
        logger.exiting(CueSheetToXmlSerializer.class.getCanonicalName(), "serializeCueSheet(CueSheet)", document);
        return document;
    }

    private void serializeFileData(Element element, FileData fileData) {
        logger.entering(CueSheetToXmlSerializer.class.getCanonicalName(), "serializeFileData(Element,FileData)", new Object[]{element, fileData});
        Document document = element.getOwnerDocument();
        Element element2 = document.createElementNS(this.namespace, "file");
        element.appendChild(element2);
        this.addAttribute(element2, "file", fileData.getFile());
        this.addAttribute(element2, "type", fileData.getFileType());
        for (TrackData trackData : fileData.getTrackData()) {
            this.serializeTrackData(element2, trackData);
        }
        logger.exiting(CueSheetToXmlSerializer.class.getCanonicalName(), "serializeFileData(Element,FileData)");
    }

    private void serializeTrackData(Element element, TrackData trackData) {
        logger.entering(CueSheetToXmlSerializer.class.getCanonicalName(), "serializeTrackData(Element,TrackData)", new Object[]{element, trackData});
        Document document = element.getOwnerDocument();
        Element element2 = document.createElementNS(this.namespace, "track");
        element.appendChild(element2);
        this.addAttribute(element2, "number", trackData.getNumber());
        this.addAttribute(element2, "type", trackData.getDataType());
        this.addAttribute(element2, "isrc", trackData.getIsrcCode());
        this.addAttribute(element2, "performer", trackData.getPerformer());
        this.addAttribute(element2, "title", trackData.getTitle());
        this.addAttribute(element2, "songwriter", trackData.getSongwriter());
        this.addElement(element2, "pregap", trackData.getPregap());
        this.addElement(element2, "postgap", trackData.getPostgap());
        if (trackData.getFlags().size() > 0) {
            this.serializeFlags(element2, trackData.getFlags());
        }
        for (Index index : trackData.getIndices()) {
            this.serializeIndex(element2, index);
        }
        logger.exiting(CueSheetToXmlSerializer.class.getCanonicalName(), "serializeTrackData(Element,TrackData)");
    }

    private void serializeFlags(Element element, Set<String> set) {
        logger.entering(CueSheetToXmlSerializer.class.getCanonicalName(), "serializeFlags(Element,Set<String>)", new Object[]{element, set});
        Document document = element.getOwnerDocument();
        Element element2 = document.createElementNS(this.namespace, "flags");
        element.appendChild(element2);
        for (String string : set) {
            this.addElement(element2, "flag", string);
        }
        logger.exiting(CueSheetToXmlSerializer.class.getCanonicalName(), "serializeFlags(Element,Set<String>)");
    }

    private void serializeIndex(Element element, Index index) {
        logger.entering(CueSheetToXmlSerializer.class.getCanonicalName(), "serializeIndex(Element,Index)", new Object[]{element, index});
        Element element2 = this.addElement(element, "index", index.getPosition(), true);
        this.addAttribute(element2, "number", index.getNumber());
        logger.exiting(CueSheetToXmlSerializer.class.getCanonicalName(), "serializeIndex(Element,Index)");
    }

    private Element addElement(Element element, String string, Position position) {
        logger.entering(CueSheetToXmlSerializer.class.getCanonicalName(), "addElement(Element,String,Position)", new Object[]{element, string, position});
        Element element2 = this.addElement(element, string, position, false);
        logger.exiting(CueSheetToXmlSerializer.class.getCanonicalName(), "addElement(Element,String,Position)", element2);
        return element2;
    }

    private Element addElement(Element element, String string, Position position, boolean bl) {
        logger.entering(CueSheetToXmlSerializer.class.getCanonicalName(), "addElement(Element,String,Position,boolean)", new Object[]{element, string, position, bl});
        Element element2 = null;
        if (position != null || bl) {
            element2 = element.getOwnerDocument().createElementNS(this.namespace, string);
            element.appendChild(element2);
            if (position != null) {
                element2.setAttribute("minutes", "" + position.getMinutes());
                element2.setAttribute("seconds", "" + position.getSeconds());
                element2.setAttribute("frames", "" + position.getFrames());
            }
        }
        logger.exiting(CueSheetToXmlSerializer.class.getCanonicalName(), "addElement(Element,String,Position,boolean)", element2);
        return element2;
    }

    private Element addElement(Element element, String string, String string2) {
        logger.entering(CueSheetToXmlSerializer.class.getCanonicalName(), "addElement(Element,String,String)", new Object[]{element, string, string2});
        Element element2 = null;
        if (string2 != null) {
            element2 = element.getOwnerDocument().createElementNS(this.namespace, string);
            element2.appendChild(element.getOwnerDocument().createTextNode(string2));
            element.appendChild(element2);
        }
        logger.exiting(CueSheetToXmlSerializer.class.getCanonicalName(), "addElement(Element,String,String)", element2);
        return element2;
    }

    private Element addElement(Element element, String string, int n) {
        logger.entering(CueSheetToXmlSerializer.class.getCanonicalName(), "addElement(Element,String,int)", new Object[]{element, string, n});
        Element element2 = null;
        if (n > -1) {
            element2 = element.getOwnerDocument().createElementNS(this.namespace, string);
            element2.appendChild(element.getOwnerDocument().createTextNode("" + n));
            element.appendChild(element2);
        }
        logger.exiting(CueSheetToXmlSerializer.class.getCanonicalName(), "addElement(Element,String,int)", element2);
        return element2;
    }

    private void addAttribute(Element element, String string, String string2) {
        logger.entering(CueSheetToXmlSerializer.class.getCanonicalName(), "addAttribute(Element,String,String)", new Object[]{element, string, string2});
        if (string2 != null) {
            element.setAttribute(string, string2);
        }
        logger.exiting(CueSheetToXmlSerializer.class.getCanonicalName(), "addAttribute(Element,String,String)");
    }

    private void addAttribute(Element element, String string, int n) {
        logger.entering(CueSheetToXmlSerializer.class.getCanonicalName(), "addAttribute(Element,String,int)", new Object[]{element, string, n});
        if (n > -1) {
            element.setAttribute(string, "" + n);
        }
        logger.exiting(CueSheetToXmlSerializer.class.getCanonicalName(), "addAttribute(Element,String,int)");
    }
}

