/*
 * Decompiled with CFR 0.152.
 */
package net.pms.io;

import java.io.IOException;
import java.io.InputStream;
import net.pms.io.BufferedOutputFile;

class WaitBufferedInputStream
extends InputStream {
    private BufferedOutputFile outputStream;
    private long readCount;
    private boolean firstRead;

    public void setReadCount(long readCount) {
        this.readCount = readCount;
    }

    public long getReadCount() {
        return this.readCount;
    }

    WaitBufferedInputStream(BufferedOutputFile outputStream) {
        this.outputStream = outputStream;
        this.firstRead = true;
    }

    @Override
    public int read() throws IOException {
        int r = this.outputStream.read(this.firstRead, this.getReadCount());
        if (r != -1) {
            this.setReadCount(this.getReadCount() + 1L);
        }
        this.firstRead = false;
        return r;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int returned = this.outputStream.read(this.firstRead, this.getReadCount(), b, off, len);
        if (returned != -1) {
            this.setReadCount(this.getReadCount() + (long)returned);
        }
        this.firstRead = false;
        return returned;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int available() throws IOException {
        return (int)this.outputStream.getWriteCount();
    }

    @Override
    public void close() throws IOException {
        this.outputStream.removeInputStream(this);
        this.outputStream.detachInputStream();
    }
}

