/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.StringTokenizer;
import net.pms.PMS;
import net.pms.configuration.RendererConfiguration;
import net.pms.external.StartStopListenerDelegate;
import net.pms.network.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestHandler
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(RequestHandler.class);
    public static final int SOCKET_BUF_SIZE = 32768;
    private Socket socket;
    private OutputStream output;
    private BufferedReader br;
    private static final String[] KNOWN_HEADERS = new String[]{"Accept", "Accept-Language", "Accept-Encoding", "Callback", "Connection", "Content-Length", "Content-Type", "Date", "Host", "Nt", "Sid", "Timeout", "User-Agent"};

    public RequestHandler(Socket socket) throws IOException {
        this.socket = socket;
        this.output = socket.getOutputStream();
        this.br = new BufferedReader(new InputStreamReader(socket.getInputStream()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Request request = null;
        StartStopListenerDelegate startStopListenerDelegate = new StartStopListenerDelegate(this.socket.getInetAddress().getHostAddress());
        try {
            int receivedContentLength = -1;
            String headerLine = this.br.readLine();
            String userAgentString = null;
            StringBuilder unknownHeaders = new StringBuilder();
            String separator = "";
            RendererConfiguration renderer = null;
            InetSocketAddress remoteAddress = (InetSocketAddress)this.socket.getRemoteSocketAddress();
            InetAddress ia = remoteAddress.getAddress();
            if (this.filterIp(ia)) {
                throw new IOException("Access denied for address " + ia + " based on IP filter");
            }
            logger.trace("Opened request handler on socket " + this.socket);
            PMS.get().getRegistry().disableGoToSleep();
            while (headerLine != null && headerLine.length() > 0) {
                logger.trace("Received on socket: " + headerLine);
                if (request != null && request.getMediaRenderer() == null && (renderer = RendererConfiguration.getRendererConfigurationBySocketAddress(ia)) != null) {
                    PMS.get().setRendererFound(renderer);
                    request.setMediaRenderer(renderer);
                    logger.trace("Matched media renderer \"" + renderer.getRendererName() + "\" based on address " + ia);
                }
                if (renderer == null && headerLine != null && headerLine.toUpperCase().startsWith("USER-AGENT") && request != null && (renderer = RendererConfiguration.getRendererConfigurationByUA(userAgentString = headerLine.substring(headerLine.indexOf(":") + 1).trim())) != null) {
                    PMS.get().setRendererFound(renderer);
                    request.setMediaRenderer(renderer);
                    renderer.associateIP(ia);
                    logger.trace("Matched media renderer \"" + renderer.getRendererName() + "\" based on header \"" + headerLine + "\"");
                }
                if (renderer == null && headerLine != null && request != null && (renderer = RendererConfiguration.getRendererConfigurationByUAAHH(headerLine)) != null) {
                    PMS.get().setRendererFound(renderer);
                    request.setMediaRenderer(renderer);
                    renderer.associateIP(ia);
                    logger.trace("Matched media renderer \"" + renderer.getRendererName() + "\" based on header \"" + headerLine + "\"");
                }
                try {
                    StringTokenizer s = new StringTokenizer(headerLine);
                    String temp = s.nextToken();
                    if (temp.equals("SUBSCRIBE") || temp.equals("GET") || temp.equals("POST") || temp.equals("HEAD")) {
                        request = new Request(temp, s.nextToken().substring(1));
                        if (s.hasMoreTokens() && s.nextToken().equals("HTTP/1.0")) {
                            request.setHttp10(true);
                        }
                    } else if (request != null && temp.toUpperCase().equals("CALLBACK:")) {
                        request.setSoapaction(s.nextToken());
                    } else if (request != null && temp.toUpperCase().equals("SOAPACTION:")) {
                        request.setSoapaction(s.nextToken());
                    } else if (headerLine.toUpperCase().contains("CONTENT-LENGTH:")) {
                        receivedContentLength = Integer.parseInt(headerLine.substring(headerLine.toUpperCase().indexOf("CONTENT-LENGTH: ") + 16));
                    } else if (headerLine.toUpperCase().indexOf("RANGE: BYTES=") > -1) {
                        String nums = headerLine.substring(headerLine.toUpperCase().indexOf("RANGE: BYTES=") + 13).trim();
                        StringTokenizer st = new StringTokenizer(nums, "-");
                        if (!nums.startsWith("-")) {
                            request.setLowRange(Long.parseLong(st.nextToken()));
                        }
                        if (!nums.startsWith("-") && !nums.endsWith("-")) {
                            request.setHighRange(Long.parseLong(st.nextToken()));
                        } else {
                            request.setHighRange(-1L);
                        }
                    } else if (headerLine.toLowerCase().indexOf("transfermode.dlna.org:") > -1) {
                        request.setTransferMode(headerLine.substring(headerLine.toLowerCase().indexOf("transfermode.dlna.org:") + 22).trim());
                    } else if (headerLine.toLowerCase().indexOf("getcontentfeatures.dlna.org:") > -1) {
                        request.setContentFeatures(headerLine.substring(headerLine.toLowerCase().indexOf("getcontentfeatures.dlna.org:") + 28).trim());
                    } else if (headerLine.toUpperCase().indexOf("TIMESEEKRANGE.DLNA.ORG: NPT=") > -1) {
                        String timeseek = headerLine.substring(headerLine.toUpperCase().indexOf("TIMESEEKRANGE.DLNA.ORG: NPT=") + 28);
                        if (timeseek.endsWith("-")) {
                            timeseek = timeseek.substring(0, timeseek.length() - 1);
                        } else if (timeseek.indexOf("-") > -1) {
                            timeseek = timeseek.substring(0, timeseek.indexOf("-"));
                        }
                        request.setTimeseek(Double.parseDouble(timeseek));
                    } else if (headerLine.toUpperCase().indexOf("TIMESEEKRANGE.DLNA.ORG : NPT=") > -1) {
                        String timeseek = headerLine.substring(headerLine.toUpperCase().indexOf("TIMESEEKRANGE.DLNA.ORG : NPT=") + 29);
                        if (timeseek.endsWith("-")) {
                            timeseek = timeseek.substring(0, timeseek.length() - 1);
                        } else if (timeseek.indexOf("-") > -1) {
                            timeseek = timeseek.substring(0, timeseek.indexOf("-"));
                        }
                        request.setTimeseek(Double.parseDouble(timeseek));
                    } else {
                        boolean isKnown = false;
                        for (String knownHeaderString : KNOWN_HEADERS) {
                            if (!headerLine.toLowerCase().startsWith(knownHeaderString.toLowerCase())) continue;
                            isKnown = true;
                            break;
                        }
                        if (!isKnown) {
                            unknownHeaders.append(separator).append(headerLine);
                            separator = ", ";
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("Error in parsing HTTP headers", e);
                }
                headerLine = this.br.readLine();
            }
            if (request != null) {
                if (request.getMediaRenderer() == null) {
                    request.setMediaRenderer(RendererConfiguration.getDefaultConf());
                    logger.trace("Using default media renderer: " + request.getMediaRenderer().getRendererName());
                    if (userAgentString != null && !userAgentString.equals("FDSSDP")) {
                        logger.info("Media renderer was not recognized. Possible identifying HTTP headers: User-Agent: " + userAgentString + ("".equals(unknownHeaders.toString()) ? "" : ", " + unknownHeaders.toString()));
                        PMS.get().setRendererFound(request.getMediaRenderer());
                    }
                } else {
                    if (userAgentString != null) {
                        logger.debug("HTTP User-Agent: " + userAgentString);
                    }
                    logger.trace("Recognized media renderer: " + request.getMediaRenderer().getRendererName());
                }
            }
            if (receivedContentLength > 0) {
                char[] buf = new char[receivedContentLength];
                this.br.read(buf);
                if (request != null) {
                    request.setTextContent(new String(buf));
                }
            }
            if (request != null) {
                logger.trace("HTTP: " + request.getArgument() + " / " + request.getLowRange() + "-" + request.getHighRange());
            }
            if (request != null) {
                request.answer(this.output, startStopListenerDelegate);
            }
            if (request != null && request.getInputStream() != null) {
                request.getInputStream().close();
            }
        }
        catch (IOException e) {
            logger.trace("Unexpected IO error: " + e.getClass().getName() + ": " + e.getMessage());
            if (request != null && request.getInputStream() != null) {
                try {
                    logger.trace("Closing input stream: " + request.getInputStream());
                    request.getInputStream().close();
                }
                catch (IOException e1) {
                    logger.error("Error closing input stream", e1);
                }
            }
        }
        finally {
            try {
                PMS.get().getRegistry().reenableGoToSleep();
                this.output.close();
                this.br.close();
                this.socket.close();
            }
            catch (IOException e) {
                logger.error("Error closing connection: ", e);
            }
            startStopListenerDelegate.stop();
            logger.trace("Close connection");
        }
    }

    private boolean filterIp(InetAddress inetAddress) {
        return !PMS.getConfiguration().getIpFiltering().allowed(inetAddress);
    }
}

