#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 3725
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 228
#define ALIAS_COUNT 1
#define TOKEN_COUNT 94
#define EXTERNAL_TOKEN_COUNT 36
#define FIELD_COUNT 34
#define MAX_ALIAS_SEQUENCE_LENGTH 11
#define PRODUCTION_ID_COUNT 103

enum ts_symbol_identifiers {
  sym_name = 1,
  anon_sym_SEMI = 2,
  anon_sym_return = 3,
  anon_sym_local = 4,
  anon_sym_function = 5,
  anon_sym_COLON = 6,
  anon_sym_for = 7,
  anon_sym_in = 8,
  anon_sym_do = 9,
  anon_sym_end = 10,
  anon_sym_EQ = 11,
  anon_sym_COMMA = 12,
  anon_sym_if = 13,
  anon_sym_then = 14,
  anon_sym_elseif = 15,
  anon_sym_else = 16,
  anon_sym_repeat = 17,
  anon_sym_until = 18,
  anon_sym_while = 19,
  anon_sym_break = 20,
  sym_continue_stmt = 21,
  anon_sym_export = 22,
  aux_sym_type_stmt_token1 = 23,
  anon_sym_type = 24,
  anon_sym_LT = 25,
  anon_sym_GT = 26,
  anon_sym_PLUS_EQ = 27,
  anon_sym_DASH_EQ = 28,
  anon_sym_STAR_EQ = 29,
  anon_sym_SLASH_SLASH_EQ = 30,
  anon_sym_SLASH_EQ = 31,
  anon_sym_PERCENT_EQ = 32,
  anon_sym_CARET_EQ = 33,
  anon_sym_DOT_DOT_EQ = 34,
  anon_sym_or = 35,
  anon_sym_and = 36,
  anon_sym_EQ_EQ = 37,
  anon_sym_TILDE_EQ = 38,
  anon_sym_LT_EQ = 39,
  anon_sym_GT_EQ = 40,
  anon_sym_PLUS = 41,
  anon_sym_DASH = 42,
  anon_sym_STAR = 43,
  anon_sym_SLASH_SLASH = 44,
  anon_sym_SLASH = 45,
  anon_sym_PERCENT = 46,
  anon_sym_DOT_DOT = 47,
  anon_sym_CARET = 48,
  anon_sym_COLON_COLON = 49,
  anon_sym_not = 50,
  anon_sym_POUND = 51,
  anon_sym_LBRACE = 52,
  anon_sym_RBRACE = 53,
  anon_sym_LBRACK = 54,
  anon_sym_RBRACK = 55,
  anon_sym_LPAREN = 56,
  anon_sym_RPAREN = 57,
  anon_sym_DOT = 58,
  anon_sym_AMP = 59,
  anon_sym_PIPE = 60,
  anon_sym_DOT_DOT_DOT = 61,
  anon_sym_typeof = 62,
  anon_sym_DASH_GT = 63,
  anon_sym_QMARK = 64,
  sym_number = 65,
  anon_sym_LBRACE2 = 66,
  aux_sym_unicode_escape_token1 = 67,
  anon_sym_RBRACE2 = 68,
  aux_sym_dec_byte_escape_token1 = 69,
  aux_sym_hex_byte_escape_token1 = 70,
  anon_sym_true = 71,
  anon_sym_false = 72,
  anon_sym_nil = 73,
  anon_sym_read = 74,
  anon_sym_write = 75,
  anon_sym_AT = 76,
  aux_sym_attribute_token1 = 77,
  anon_sym_AT_LBRACK = 78,
  sym__comment_start = 79,
  sym__comment_content = 80,
  sym__comment_end = 81,
  sym__string_start = 82,
  sym__string_content = 83,
  sym__string_end = 84,
  sym_interp_start = 85,
  sym_interp_content = 86,
  sym_interp_brace_open = 87,
  sym_interp_brace_close = 88,
  sym_interp_end = 89,
  sym_simple_escape = 90,
  sym__unicode_escape_sequence = 91,
  sym__dec_byte_escape_sequence = 92,
  sym__hex_byte_escape_sequence = 93,
  sym_chunk = 94,
  sym_block = 95,
  sym__block = 96,
  sym_ret_stmt = 97,
  sym_statement = 98,
  sym_local_fn_stmt = 99,
  sym_fn_stmt = 100,
  sym__tbl_fn_member = 101,
  aux_sym__attrlist = 102,
  sym_for_in_stmt = 103,
  sym_for_range_stmt = 104,
  sym_if_stmt = 105,
  sym_elseif_clause = 106,
  sym_else_clause = 107,
  sym_repeat_stmt = 108,
  sym_while_stmt = 109,
  sym_do_stmt = 110,
  sym_break_stmt = 111,
  sym_local_var_stmt = 112,
  sym_var_stmt = 113,
  sym_assign_stmt = 114,
  sym__varlist = 115,
  sym_type_stmt = 116,
  sym_type_fn_stmt = 117,
  sym__type_assign = 118,
  sym_genericdef = 119,
  sym__type_stmt_genlist = 120,
  sym_genpackdef = 121,
  sym__type_stmt_packlist = 122,
  sym__assign = 123,
  sym_exp = 124,
  sym__explist = 125,
  sym_binexp = 126,
  sym_cast = 127,
  sym_unexp = 128,
  sym_ifexp = 129,
  sym__ifexp_elseif = 130,
  sym_table = 131,
  sym__fieldlist = 132,
  sym_field = 133,
  sym_prefixexp = 134,
  sym__prefixexp = 135,
  sym_exp_wrap = 136,
  sym_call_stmt = 137,
  sym__tbl_method = 138,
  sym__method_name = 139,
  sym_arglist = 140,
  sym_binding = 141,
  sym_bindinglist = 142,
  sym_var = 143,
  sym__tbl_seq = 144,
  sym_key = 145,
  sym__key_named = 146,
  sym_anon_fn = 147,
  sym__fn_body = 148,
  sym_paramlist = 149,
  sym_param = 150,
  sym__param_vararg = 151,
  sym_type = 152,
  sym__outertype = 153,
  sym_singleton = 154,
  sym_namedtype = 155,
  sym_typelist = 156,
  sym__typelist_vrd = 157,
  sym_wraptype = 158,
  sym_typeparam = 159,
  sym__typeparamlist = 160,
  sym_typepack = 161,
  sym__typepack_wrap = 162,
  sym__typepack_vrd = 163,
  sym__typepack_gen = 164,
  sym_variadic = 165,
  sym_dyntype = 166,
  sym_fntype = 167,
  sym__fntype_gen = 168,
  sym_paramtypelist = 169,
  sym__fntype_param = 170,
  sym__fntype_paramlist = 171,
  sym__fntype_paramlist_vrd = 172,
  sym_tbtype = 173,
  sym__tbtype_content = 174,
  sym__array_type = 175,
  sym__tbtype_kv = 176,
  sym_kvtypelist = 177,
  sym_indexertype = 178,
  sym_proptype = 179,
  sym_bintype = 180,
  sym_untype = 181,
  sym_generic = 182,
  sym__genlist = 183,
  sym_genpack = 184,
  sym__genpack_list = 185,
  sym_vararg = 186,
  sym_string = 187,
  sym_string_interp = 188,
  sym_interp_exp = 189,
  sym__escape_sequence = 190,
  sym_unicode_escape = 191,
  sym_dec_byte_escape = 192,
  sym_hex_byte_escape = 193,
  sym_boolean = 194,
  sym_nil = 195,
  sym_readwrite = 196,
  sym_attribute = 197,
  sym__parattrlist = 198,
  sym_parattr = 199,
  sym_parattr_param = 200,
  sym_literal = 201,
  sym__litlist = 202,
  sym_littable = 203,
  sym__litfieldlist = 204,
  sym_litfield = 205,
  sym_comment = 206,
  aux_sym__block_repeat1 = 207,
  aux_sym_if_stmt_repeat1 = 208,
  aux_sym__varlist_repeat1 = 209,
  aux_sym__type_stmt_genlist_repeat1 = 210,
  aux_sym__type_stmt_packlist_repeat1 = 211,
  aux_sym__explist_repeat1 = 212,
  aux_sym_ifexp_repeat1 = 213,
  aux_sym__fieldlist_repeat1 = 214,
  aux_sym_bindinglist_repeat1 = 215,
  aux_sym_paramlist_repeat1 = 216,
  aux_sym_typelist_repeat1 = 217,
  aux_sym__typeparamlist_repeat1 = 218,
  aux_sym__fntype_paramlist_repeat1 = 219,
  aux_sym_kvtypelist_repeat1 = 220,
  aux_sym__genlist_repeat1 = 221,
  aux_sym__genpack_list_repeat1 = 222,
  aux_sym_string_repeat1 = 223,
  aux_sym_string_interp_repeat1 = 224,
  aux_sym__parattrlist_repeat1 = 225,
  aux_sym__litlist_repeat1 = 226,
  aux_sym__litfieldlist_repeat1 = 227,
  alias_sym_explist = 228,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_name] = "name",
  [anon_sym_SEMI] = ";",
  [anon_sym_return] = "return",
  [anon_sym_local] = "local",
  [anon_sym_function] = "function",
  [anon_sym_COLON] = ":",
  [anon_sym_for] = "for",
  [anon_sym_in] = "in",
  [anon_sym_do] = "do",
  [anon_sym_end] = "end",
  [anon_sym_EQ] = "=",
  [anon_sym_COMMA] = ",",
  [anon_sym_if] = "if",
  [anon_sym_then] = "then",
  [anon_sym_elseif] = "elseif",
  [anon_sym_else] = "else",
  [anon_sym_repeat] = "repeat",
  [anon_sym_until] = "until",
  [anon_sym_while] = "while",
  [anon_sym_break] = "break",
  [sym_continue_stmt] = "continue_stmt",
  [anon_sym_export] = "export",
  [aux_sym_type_stmt_token1] = "type_stmt_token1",
  [anon_sym_type] = "type",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_SLASH_EQ] = "//=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_DOT_DOT_EQ] = "..=",
  [anon_sym_or] = "or",
  [anon_sym_and] = "and",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_TILDE_EQ] = "~=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH_SLASH] = "//",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_DOT_DOT] = "..",
  [anon_sym_CARET] = "^",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_not] = "not",
  [anon_sym_POUND] = "#",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_DOT] = ".",
  [anon_sym_AMP] = "&",
  [anon_sym_PIPE] = "|",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_typeof] = "typeof",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_QMARK] = "\?",
  [sym_number] = "number",
  [anon_sym_LBRACE2] = "{",
  [aux_sym_unicode_escape_token1] = "codepoint",
  [anon_sym_RBRACE2] = "}",
  [aux_sym_dec_byte_escape_token1] = "dec_byte_escape_token1",
  [aux_sym_hex_byte_escape_token1] = "hex_byte_escape_token1",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [anon_sym_nil] = "nil",
  [anon_sym_read] = "read",
  [anon_sym_write] = "write",
  [anon_sym_AT] = "@",
  [aux_sym_attribute_token1] = "attribute_token1",
  [anon_sym_AT_LBRACK] = "@[",
  [sym__comment_start] = "_comment_start",
  [sym__comment_content] = "_comment_content",
  [sym__comment_end] = "_comment_end",
  [sym__string_start] = "_string_start",
  [sym__string_content] = "_string_content",
  [sym__string_end] = "_string_end",
  [sym_interp_start] = "interp_start",
  [sym_interp_content] = "interp_content",
  [sym_interp_brace_open] = "interp_brace_open",
  [sym_interp_brace_close] = "interp_brace_close",
  [sym_interp_end] = "interp_end",
  [sym_simple_escape] = "simple_escape",
  [sym__unicode_escape_sequence] = "_unicode_escape_sequence",
  [sym__dec_byte_escape_sequence] = "_dec_byte_escape_sequence",
  [sym__hex_byte_escape_sequence] = "_hex_byte_escape_sequence",
  [sym_chunk] = "chunk",
  [sym_block] = "block",
  [sym__block] = "_block",
  [sym_ret_stmt] = "ret_stmt",
  [sym_statement] = "statement",
  [sym_local_fn_stmt] = "local_fn_stmt",
  [sym_fn_stmt] = "fn_stmt",
  [sym__tbl_fn_member] = "_tbl_fn_member",
  [aux_sym__attrlist] = "_attrlist",
  [sym_for_in_stmt] = "for_in_stmt",
  [sym_for_range_stmt] = "for_range_stmt",
  [sym_if_stmt] = "if_stmt",
  [sym_elseif_clause] = "elseif_clause",
  [sym_else_clause] = "else_clause",
  [sym_repeat_stmt] = "repeat_stmt",
  [sym_while_stmt] = "while_stmt",
  [sym_do_stmt] = "do_stmt",
  [sym_break_stmt] = "break_stmt",
  [sym_local_var_stmt] = "local_var_stmt",
  [sym_var_stmt] = "var_stmt",
  [sym_assign_stmt] = "assign_stmt",
  [sym__varlist] = "varlist",
  [sym_type_stmt] = "type_stmt",
  [sym_type_fn_stmt] = "type_fn_stmt",
  [sym__type_assign] = "_type_assign",
  [sym_genericdef] = "genericdef",
  [sym__type_stmt_genlist] = "_type_stmt_genlist",
  [sym_genpackdef] = "genpackdef",
  [sym__type_stmt_packlist] = "_type_stmt_packlist",
  [sym__assign] = "_assign",
  [sym_exp] = "exp",
  [sym__explist] = "_explist",
  [sym_binexp] = "binexp",
  [sym_cast] = "cast",
  [sym_unexp] = "unexp",
  [sym_ifexp] = "ifexp",
  [sym__ifexp_elseif] = "_ifexp_elseif",
  [sym_table] = "table",
  [sym__fieldlist] = "_fieldlist",
  [sym_field] = "field",
  [sym_prefixexp] = "prefixexp",
  [sym__prefixexp] = "_prefixexp",
  [sym_exp_wrap] = "exp_wrap",
  [sym_call_stmt] = "call_stmt",
  [sym__tbl_method] = "_tbl_method",
  [sym__method_name] = "_method_name",
  [sym_arglist] = "arglist",
  [sym_binding] = "binding",
  [sym_bindinglist] = "bindinglist",
  [sym_var] = "var",
  [sym__tbl_seq] = "_tbl_seq",
  [sym_key] = "key",
  [sym__key_named] = "_key_named",
  [sym_anon_fn] = "anon_fn",
  [sym__fn_body] = "_fn_body",
  [sym_paramlist] = "paramlist",
  [sym_param] = "param",
  [sym__param_vararg] = "param",
  [sym_type] = "type",
  [sym__outertype] = "_outertype",
  [sym_singleton] = "singleton",
  [sym_namedtype] = "namedtype",
  [sym_typelist] = "typelist",
  [sym__typelist_vrd] = "_typelist_vrd",
  [sym_wraptype] = "wraptype",
  [sym_typeparam] = "typeparam",
  [sym__typeparamlist] = "_typeparamlist",
  [sym_typepack] = "typepack",
  [sym__typepack_wrap] = "_typepack_wrap",
  [sym__typepack_vrd] = "_typepack_vrd",
  [sym__typepack_gen] = "_typepack_gen",
  [sym_variadic] = "variadic",
  [sym_dyntype] = "dyntype",
  [sym_fntype] = "fntype",
  [sym__fntype_gen] = "_fntype_gen",
  [sym_paramtypelist] = "paramtypelist",
  [sym__fntype_param] = "_fntype_param",
  [sym__fntype_paramlist] = "_fntype_paramlist",
  [sym__fntype_paramlist_vrd] = "_fntype_paramlist_vrd",
  [sym_tbtype] = "tbtype",
  [sym__tbtype_content] = "_tbtype_content",
  [sym__array_type] = "_array_type",
  [sym__tbtype_kv] = "_tbtype_kv",
  [sym_kvtypelist] = "kvtypelist",
  [sym_indexertype] = "indexertype",
  [sym_proptype] = "proptype",
  [sym_bintype] = "bintype",
  [sym_untype] = "untype",
  [sym_generic] = "generic",
  [sym__genlist] = "_genlist",
  [sym_genpack] = "genpack",
  [sym__genpack_list] = "_genpack_list",
  [sym_vararg] = "vararg",
  [sym_string] = "string",
  [sym_string_interp] = "string_interp",
  [sym_interp_exp] = "interp_exp",
  [sym__escape_sequence] = "_escape_sequence",
  [sym_unicode_escape] = "unicode_escape",
  [sym_dec_byte_escape] = "dec_byte_escape",
  [sym_hex_byte_escape] = "hex_byte_escape",
  [sym_boolean] = "boolean",
  [sym_nil] = "nil",
  [sym_readwrite] = "readwrite",
  [sym_attribute] = "attribute",
  [sym__parattrlist] = "_parattrlist",
  [sym_parattr] = "parattr",
  [sym_parattr_param] = "parattr_param",
  [sym_literal] = "literal",
  [sym__litlist] = "_litlist",
  [sym_littable] = "littable",
  [sym__litfieldlist] = "_litfieldlist",
  [sym_litfield] = "litfield",
  [sym_comment] = "comment",
  [aux_sym__block_repeat1] = "_block_repeat1",
  [aux_sym_if_stmt_repeat1] = "if_stmt_repeat1",
  [aux_sym__varlist_repeat1] = "_varlist_repeat1",
  [aux_sym__type_stmt_genlist_repeat1] = "_type_stmt_genlist_repeat1",
  [aux_sym__type_stmt_packlist_repeat1] = "_type_stmt_packlist_repeat1",
  [aux_sym__explist_repeat1] = "_explist_repeat1",
  [aux_sym_ifexp_repeat1] = "ifexp_repeat1",
  [aux_sym__fieldlist_repeat1] = "_fieldlist_repeat1",
  [aux_sym_bindinglist_repeat1] = "bindinglist_repeat1",
  [aux_sym_paramlist_repeat1] = "paramlist_repeat1",
  [aux_sym_typelist_repeat1] = "typelist_repeat1",
  [aux_sym__typeparamlist_repeat1] = "_typeparamlist_repeat1",
  [aux_sym__fntype_paramlist_repeat1] = "_fntype_paramlist_repeat1",
  [aux_sym_kvtypelist_repeat1] = "kvtypelist_repeat1",
  [aux_sym__genlist_repeat1] = "_genlist_repeat1",
  [aux_sym__genpack_list_repeat1] = "_genpack_list_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_string_interp_repeat1] = "string_interp_repeat1",
  [aux_sym__parattrlist_repeat1] = "_parattrlist_repeat1",
  [aux_sym__litlist_repeat1] = "_litlist_repeat1",
  [aux_sym__litfieldlist_repeat1] = "_litfieldlist_repeat1",
  [alias_sym_explist] = "explist",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_name] = sym_name,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_local] = anon_sym_local,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_end] = anon_sym_end,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_then] = anon_sym_then,
  [anon_sym_elseif] = anon_sym_elseif,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_repeat] = anon_sym_repeat,
  [anon_sym_until] = anon_sym_until,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_break] = anon_sym_break,
  [sym_continue_stmt] = sym_continue_stmt,
  [anon_sym_export] = anon_sym_export,
  [aux_sym_type_stmt_token1] = aux_sym_type_stmt_token1,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_SLASH_EQ] = anon_sym_SLASH_SLASH_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_DOT_DOT_EQ] = anon_sym_DOT_DOT_EQ,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_TILDE_EQ] = anon_sym_TILDE_EQ,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH_SLASH] = anon_sym_SLASH_SLASH,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_not] = anon_sym_not,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_typeof] = anon_sym_typeof,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [sym_number] = sym_number,
  [anon_sym_LBRACE2] = anon_sym_LBRACE,
  [aux_sym_unicode_escape_token1] = aux_sym_unicode_escape_token1,
  [anon_sym_RBRACE2] = anon_sym_RBRACE,
  [aux_sym_dec_byte_escape_token1] = aux_sym_dec_byte_escape_token1,
  [aux_sym_hex_byte_escape_token1] = aux_sym_hex_byte_escape_token1,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [anon_sym_nil] = anon_sym_nil,
  [anon_sym_read] = anon_sym_read,
  [anon_sym_write] = anon_sym_write,
  [anon_sym_AT] = anon_sym_AT,
  [aux_sym_attribute_token1] = aux_sym_attribute_token1,
  [anon_sym_AT_LBRACK] = anon_sym_AT_LBRACK,
  [sym__comment_start] = sym__comment_start,
  [sym__comment_content] = sym__comment_content,
  [sym__comment_end] = sym__comment_end,
  [sym__string_start] = sym__string_start,
  [sym__string_content] = sym__string_content,
  [sym__string_end] = sym__string_end,
  [sym_interp_start] = sym_interp_start,
  [sym_interp_content] = sym_interp_content,
  [sym_interp_brace_open] = sym_interp_brace_open,
  [sym_interp_brace_close] = sym_interp_brace_close,
  [sym_interp_end] = sym_interp_end,
  [sym_simple_escape] = sym_simple_escape,
  [sym__unicode_escape_sequence] = sym__unicode_escape_sequence,
  [sym__dec_byte_escape_sequence] = sym__dec_byte_escape_sequence,
  [sym__hex_byte_escape_sequence] = sym__hex_byte_escape_sequence,
  [sym_chunk] = sym_chunk,
  [sym_block] = sym_block,
  [sym__block] = sym__block,
  [sym_ret_stmt] = sym_ret_stmt,
  [sym_statement] = sym_statement,
  [sym_local_fn_stmt] = sym_local_fn_stmt,
  [sym_fn_stmt] = sym_fn_stmt,
  [sym__tbl_fn_member] = sym__tbl_fn_member,
  [aux_sym__attrlist] = aux_sym__attrlist,
  [sym_for_in_stmt] = sym_for_in_stmt,
  [sym_for_range_stmt] = sym_for_range_stmt,
  [sym_if_stmt] = sym_if_stmt,
  [sym_elseif_clause] = sym_elseif_clause,
  [sym_else_clause] = sym_else_clause,
  [sym_repeat_stmt] = sym_repeat_stmt,
  [sym_while_stmt] = sym_while_stmt,
  [sym_do_stmt] = sym_do_stmt,
  [sym_break_stmt] = sym_break_stmt,
  [sym_local_var_stmt] = sym_local_var_stmt,
  [sym_var_stmt] = sym_var_stmt,
  [sym_assign_stmt] = sym_assign_stmt,
  [sym__varlist] = sym__varlist,
  [sym_type_stmt] = sym_type_stmt,
  [sym_type_fn_stmt] = sym_type_fn_stmt,
  [sym__type_assign] = sym__type_assign,
  [sym_genericdef] = sym_genericdef,
  [sym__type_stmt_genlist] = sym__type_stmt_genlist,
  [sym_genpackdef] = sym_genpackdef,
  [sym__type_stmt_packlist] = sym__type_stmt_packlist,
  [sym__assign] = sym__assign,
  [sym_exp] = sym_exp,
  [sym__explist] = sym__explist,
  [sym_binexp] = sym_binexp,
  [sym_cast] = sym_cast,
  [sym_unexp] = sym_unexp,
  [sym_ifexp] = sym_ifexp,
  [sym__ifexp_elseif] = sym__ifexp_elseif,
  [sym_table] = sym_table,
  [sym__fieldlist] = sym__fieldlist,
  [sym_field] = sym_field,
  [sym_prefixexp] = sym_prefixexp,
  [sym__prefixexp] = sym__prefixexp,
  [sym_exp_wrap] = sym_exp_wrap,
  [sym_call_stmt] = sym_call_stmt,
  [sym__tbl_method] = sym__tbl_method,
  [sym__method_name] = sym__method_name,
  [sym_arglist] = sym_arglist,
  [sym_binding] = sym_binding,
  [sym_bindinglist] = sym_bindinglist,
  [sym_var] = sym_var,
  [sym__tbl_seq] = sym__tbl_seq,
  [sym_key] = sym_key,
  [sym__key_named] = sym__key_named,
  [sym_anon_fn] = sym_anon_fn,
  [sym__fn_body] = sym__fn_body,
  [sym_paramlist] = sym_paramlist,
  [sym_param] = sym_param,
  [sym__param_vararg] = sym_param,
  [sym_type] = sym_type,
  [sym__outertype] = sym__outertype,
  [sym_singleton] = sym_singleton,
  [sym_namedtype] = sym_namedtype,
  [sym_typelist] = sym_typelist,
  [sym__typelist_vrd] = sym__typelist_vrd,
  [sym_wraptype] = sym_wraptype,
  [sym_typeparam] = sym_typeparam,
  [sym__typeparamlist] = sym__typeparamlist,
  [sym_typepack] = sym_typepack,
  [sym__typepack_wrap] = sym__typepack_wrap,
  [sym__typepack_vrd] = sym__typepack_vrd,
  [sym__typepack_gen] = sym__typepack_gen,
  [sym_variadic] = sym_variadic,
  [sym_dyntype] = sym_dyntype,
  [sym_fntype] = sym_fntype,
  [sym__fntype_gen] = sym__fntype_gen,
  [sym_paramtypelist] = sym_paramtypelist,
  [sym__fntype_param] = sym__fntype_param,
  [sym__fntype_paramlist] = sym__fntype_paramlist,
  [sym__fntype_paramlist_vrd] = sym__fntype_paramlist_vrd,
  [sym_tbtype] = sym_tbtype,
  [sym__tbtype_content] = sym__tbtype_content,
  [sym__array_type] = sym__array_type,
  [sym__tbtype_kv] = sym__tbtype_kv,
  [sym_kvtypelist] = sym_kvtypelist,
  [sym_indexertype] = sym_indexertype,
  [sym_proptype] = sym_proptype,
  [sym_bintype] = sym_bintype,
  [sym_untype] = sym_untype,
  [sym_generic] = sym_generic,
  [sym__genlist] = sym__genlist,
  [sym_genpack] = sym_genpack,
  [sym__genpack_list] = sym__genpack_list,
  [sym_vararg] = sym_vararg,
  [sym_string] = sym_string,
  [sym_string_interp] = sym_string_interp,
  [sym_interp_exp] = sym_interp_exp,
  [sym__escape_sequence] = sym__escape_sequence,
  [sym_unicode_escape] = sym_unicode_escape,
  [sym_dec_byte_escape] = sym_dec_byte_escape,
  [sym_hex_byte_escape] = sym_hex_byte_escape,
  [sym_boolean] = sym_boolean,
  [sym_nil] = sym_nil,
  [sym_readwrite] = sym_readwrite,
  [sym_attribute] = sym_attribute,
  [sym__parattrlist] = sym__parattrlist,
  [sym_parattr] = sym_parattr,
  [sym_parattr_param] = sym_parattr_param,
  [sym_literal] = sym_literal,
  [sym__litlist] = sym__litlist,
  [sym_littable] = sym_littable,
  [sym__litfieldlist] = sym__litfieldlist,
  [sym_litfield] = sym_litfield,
  [sym_comment] = sym_comment,
  [aux_sym__block_repeat1] = aux_sym__block_repeat1,
  [aux_sym_if_stmt_repeat1] = aux_sym_if_stmt_repeat1,
  [aux_sym__varlist_repeat1] = aux_sym__varlist_repeat1,
  [aux_sym__type_stmt_genlist_repeat1] = aux_sym__type_stmt_genlist_repeat1,
  [aux_sym__type_stmt_packlist_repeat1] = aux_sym__type_stmt_packlist_repeat1,
  [aux_sym__explist_repeat1] = aux_sym__explist_repeat1,
  [aux_sym_ifexp_repeat1] = aux_sym_ifexp_repeat1,
  [aux_sym__fieldlist_repeat1] = aux_sym__fieldlist_repeat1,
  [aux_sym_bindinglist_repeat1] = aux_sym_bindinglist_repeat1,
  [aux_sym_paramlist_repeat1] = aux_sym_paramlist_repeat1,
  [aux_sym_typelist_repeat1] = aux_sym_typelist_repeat1,
  [aux_sym__typeparamlist_repeat1] = aux_sym__typeparamlist_repeat1,
  [aux_sym__fntype_paramlist_repeat1] = aux_sym__fntype_paramlist_repeat1,
  [aux_sym_kvtypelist_repeat1] = aux_sym_kvtypelist_repeat1,
  [aux_sym__genlist_repeat1] = aux_sym__genlist_repeat1,
  [aux_sym__genpack_list_repeat1] = aux_sym__genpack_list_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_string_interp_repeat1] = aux_sym_string_interp_repeat1,
  [aux_sym__parattrlist_repeat1] = aux_sym__parattrlist_repeat1,
  [aux_sym__litlist_repeat1] = aux_sym__litlist_repeat1,
  [aux_sym__litfieldlist_repeat1] = aux_sym__litfieldlist_repeat1,
  [alias_sym_explist] = alias_sym_explist,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_name] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_local] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_end] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_then] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_elseif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_repeat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_until] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [sym_continue_stmt] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_export] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_stmt_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_typeof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACE2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_unicode_escape_token1] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_dec_byte_escape_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_hex_byte_escape_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nil] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_read] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_write] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_attribute_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_AT_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [sym__comment_start] = {
    .visible = false,
    .named = true,
  },
  [sym__comment_content] = {
    .visible = false,
    .named = true,
  },
  [sym__comment_end] = {
    .visible = false,
    .named = true,
  },
  [sym__string_start] = {
    .visible = false,
    .named = true,
  },
  [sym__string_content] = {
    .visible = false,
    .named = true,
  },
  [sym__string_end] = {
    .visible = false,
    .named = true,
  },
  [sym_interp_start] = {
    .visible = true,
    .named = true,
  },
  [sym_interp_content] = {
    .visible = true,
    .named = true,
  },
  [sym_interp_brace_open] = {
    .visible = true,
    .named = true,
  },
  [sym_interp_brace_close] = {
    .visible = true,
    .named = true,
  },
  [sym_interp_end] = {
    .visible = true,
    .named = true,
  },
  [sym_simple_escape] = {
    .visible = true,
    .named = true,
  },
  [sym__unicode_escape_sequence] = {
    .visible = false,
    .named = true,
  },
  [sym__dec_byte_escape_sequence] = {
    .visible = false,
    .named = true,
  },
  [sym__hex_byte_escape_sequence] = {
    .visible = false,
    .named = true,
  },
  [sym_chunk] = {
    .visible = true,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym__block] = {
    .visible = false,
    .named = true,
  },
  [sym_ret_stmt] = {
    .visible = true,
    .named = true,
  },
  [sym_statement] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_local_fn_stmt] = {
    .visible = true,
    .named = true,
  },
  [sym_fn_stmt] = {
    .visible = true,
    .named = true,
  },
  [sym__tbl_fn_member] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__attrlist] = {
    .visible = false,
    .named = false,
  },
  [sym_for_in_stmt] = {
    .visible = true,
    .named = true,
  },
  [sym_for_range_stmt] = {
    .visible = true,
    .named = true,
  },
  [sym_if_stmt] = {
    .visible = true,
    .named = true,
  },
  [sym_elseif_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_repeat_stmt] = {
    .visible = true,
    .named = true,
  },
  [sym_while_stmt] = {
    .visible = true,
    .named = true,
  },
  [sym_do_stmt] = {
    .visible = true,
    .named = true,
  },
  [sym_break_stmt] = {
    .visible = true,
    .named = true,
  },
  [sym_local_var_stmt] = {
    .visible = true,
    .named = true,
  },
  [sym_var_stmt] = {
    .visible = true,
    .named = true,
  },
  [sym_assign_stmt] = {
    .visible = true,
    .named = true,
  },
  [sym__varlist] = {
    .visible = true,
    .named = true,
  },
  [sym_type_stmt] = {
    .visible = true,
    .named = true,
  },
  [sym_type_fn_stmt] = {
    .visible = true,
    .named = true,
  },
  [sym__type_assign] = {
    .visible = false,
    .named = true,
  },
  [sym_genericdef] = {
    .visible = true,
    .named = true,
  },
  [sym__type_stmt_genlist] = {
    .visible = false,
    .named = true,
  },
  [sym_genpackdef] = {
    .visible = true,
    .named = true,
  },
  [sym__type_stmt_packlist] = {
    .visible = false,
    .named = true,
  },
  [sym__assign] = {
    .visible = false,
    .named = true,
  },
  [sym_exp] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__explist] = {
    .visible = false,
    .named = true,
  },
  [sym_binexp] = {
    .visible = true,
    .named = true,
  },
  [sym_cast] = {
    .visible = true,
    .named = true,
  },
  [sym_unexp] = {
    .visible = true,
    .named = true,
  },
  [sym_ifexp] = {
    .visible = true,
    .named = true,
  },
  [sym__ifexp_elseif] = {
    .visible = false,
    .named = true,
  },
  [sym_table] = {
    .visible = true,
    .named = true,
  },
  [sym__fieldlist] = {
    .visible = false,
    .named = true,
  },
  [sym_field] = {
    .visible = true,
    .named = true,
  },
  [sym_prefixexp] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__prefixexp] = {
    .visible = false,
    .named = true,
  },
  [sym_exp_wrap] = {
    .visible = true,
    .named = true,
  },
  [sym_call_stmt] = {
    .visible = true,
    .named = true,
  },
  [sym__tbl_method] = {
    .visible = false,
    .named = true,
  },
  [sym__method_name] = {
    .visible = false,
    .named = true,
  },
  [sym_arglist] = {
    .visible = true,
    .named = true,
  },
  [sym_binding] = {
    .visible = true,
    .named = true,
  },
  [sym_bindinglist] = {
    .visible = true,
    .named = true,
  },
  [sym_var] = {
    .visible = true,
    .named = true,
  },
  [sym__tbl_seq] = {
    .visible = false,
    .named = true,
  },
  [sym_key] = {
    .visible = true,
    .named = true,
  },
  [sym__key_named] = {
    .visible = false,
    .named = true,
  },
  [sym_anon_fn] = {
    .visible = true,
    .named = true,
  },
  [sym__fn_body] = {
    .visible = false,
    .named = true,
  },
  [sym_paramlist] = {
    .visible = true,
    .named = true,
  },
  [sym_param] = {
    .visible = true,
    .named = true,
  },
  [sym__param_vararg] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__outertype] = {
    .visible = false,
    .named = true,
  },
  [sym_singleton] = {
    .visible = true,
    .named = true,
  },
  [sym_namedtype] = {
    .visible = true,
    .named = true,
  },
  [sym_typelist] = {
    .visible = true,
    .named = true,
  },
  [sym__typelist_vrd] = {
    .visible = false,
    .named = true,
  },
  [sym_wraptype] = {
    .visible = true,
    .named = true,
  },
  [sym_typeparam] = {
    .visible = true,
    .named = true,
  },
  [sym__typeparamlist] = {
    .visible = false,
    .named = true,
  },
  [sym_typepack] = {
    .visible = true,
    .named = true,
  },
  [sym__typepack_wrap] = {
    .visible = false,
    .named = true,
  },
  [sym__typepack_vrd] = {
    .visible = false,
    .named = true,
  },
  [sym__typepack_gen] = {
    .visible = false,
    .named = true,
  },
  [sym_variadic] = {
    .visible = true,
    .named = true,
  },
  [sym_dyntype] = {
    .visible = true,
    .named = true,
  },
  [sym_fntype] = {
    .visible = true,
    .named = true,
  },
  [sym__fntype_gen] = {
    .visible = false,
    .named = true,
  },
  [sym_paramtypelist] = {
    .visible = true,
    .named = true,
  },
  [sym__fntype_param] = {
    .visible = false,
    .named = true,
  },
  [sym__fntype_paramlist] = {
    .visible = false,
    .named = true,
  },
  [sym__fntype_paramlist_vrd] = {
    .visible = false,
    .named = true,
  },
  [sym_tbtype] = {
    .visible = true,
    .named = true,
  },
  [sym__tbtype_content] = {
    .visible = false,
    .named = true,
  },
  [sym__array_type] = {
    .visible = false,
    .named = true,
  },
  [sym__tbtype_kv] = {
    .visible = false,
    .named = true,
  },
  [sym_kvtypelist] = {
    .visible = true,
    .named = true,
  },
  [sym_indexertype] = {
    .visible = true,
    .named = true,
  },
  [sym_proptype] = {
    .visible = true,
    .named = true,
  },
  [sym_bintype] = {
    .visible = true,
    .named = true,
  },
  [sym_untype] = {
    .visible = true,
    .named = true,
  },
  [sym_generic] = {
    .visible = true,
    .named = true,
  },
  [sym__genlist] = {
    .visible = false,
    .named = true,
  },
  [sym_genpack] = {
    .visible = true,
    .named = true,
  },
  [sym__genpack_list] = {
    .visible = false,
    .named = true,
  },
  [sym_vararg] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_string_interp] = {
    .visible = true,
    .named = true,
  },
  [sym_interp_exp] = {
    .visible = true,
    .named = true,
  },
  [sym__escape_sequence] = {
    .visible = false,
    .named = true,
  },
  [sym_unicode_escape] = {
    .visible = true,
    .named = true,
  },
  [sym_dec_byte_escape] = {
    .visible = true,
    .named = true,
  },
  [sym_hex_byte_escape] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean] = {
    .visible = true,
    .named = true,
  },
  [sym_nil] = {
    .visible = true,
    .named = true,
  },
  [sym_readwrite] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym__parattrlist] = {
    .visible = false,
    .named = true,
  },
  [sym_parattr] = {
    .visible = true,
    .named = true,
  },
  [sym_parattr_param] = {
    .visible = true,
    .named = true,
  },
  [sym_literal] = {
    .visible = true,
    .named = true,
  },
  [sym__litlist] = {
    .visible = false,
    .named = true,
  },
  [sym_littable] = {
    .visible = true,
    .named = true,
  },
  [sym__litfieldlist] = {
    .visible = false,
    .named = true,
  },
  [sym_litfield] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_stmt_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__varlist_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__type_stmt_genlist_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__type_stmt_packlist_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__explist_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_ifexp_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__fieldlist_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_bindinglist_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_paramlist_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_typelist_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__typeparamlist_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__fntype_paramlist_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_kvtypelist_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__genlist_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__genpack_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_interp_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__parattrlist_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__litlist_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__litfieldlist_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_explist] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_alternative = 1,
  field_array_type_specifier = 2,
  field_assign_symbol = 3,
  field_attribute_name = 4,
  field_body = 5,
  field_condition = 6,
  field_consequence = 7,
  field_field_indexer = 8,
  field_field_name = 9,
  field_function_name = 10,
  field_generic_type_name = 11,
  field_generic_typepack_name = 12,
  field_indexer_type_specifier = 13,
  field_invoked = 14,
  field_left = 15,
  field_method_name = 16,
  field_method_table = 17,
  field_module_namespace = 18,
  field_operand = 19,
  field_operator = 20,
  field_parameter_name = 21,
  field_return_type = 22,
  field_right = 23,
  field_start = 24,
  field_step = 25,
  field_stop = 26,
  field_table_name = 27,
  field_type_name = 28,
  field_type_specifier = 29,
  field_type_value = 30,
  field_typepack_value = 31,
  field_value = 32,
  field_value_type_specifier = 33,
  field_variable_name = 34,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_array_type_specifier] = "array_type_specifier",
  [field_assign_symbol] = "assign_symbol",
  [field_attribute_name] = "attribute_name",
  [field_body] = "body",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_field_indexer] = "field_indexer",
  [field_field_name] = "field_name",
  [field_function_name] = "function_name",
  [field_generic_type_name] = "generic_type_name",
  [field_generic_typepack_name] = "generic_typepack_name",
  [field_indexer_type_specifier] = "indexer_type_specifier",
  [field_invoked] = "invoked",
  [field_left] = "left",
  [field_method_name] = "method_name",
  [field_method_table] = "method_table",
  [field_module_namespace] = "module_namespace",
  [field_operand] = "operand",
  [field_operator] = "operator",
  [field_parameter_name] = "parameter_name",
  [field_return_type] = "return_type",
  [field_right] = "right",
  [field_start] = "start",
  [field_step] = "step",
  [field_stop] = "stop",
  [field_table_name] = "table_name",
  [field_type_name] = "type_name",
  [field_type_specifier] = "type_specifier",
  [field_type_value] = "type_value",
  [field_typepack_value] = "typepack_value",
  [field_value] = "value",
  [field_value_type_specifier] = "value_type_specifier",
  [field_variable_name] = "variable_name",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [4] = {.index = 2, .length = 1},
  [5] = {.index = 3, .length = 1},
  [6] = {.index = 4, .length = 1},
  [7] = {.index = 5, .length = 2},
  [8] = {.index = 7, .length = 1},
  [9] = {.index = 8, .length = 2},
  [10] = {.index = 10, .length = 3},
  [11] = {.index = 13, .length = 2},
  [12] = {.index = 15, .length = 1},
  [13] = {.index = 3, .length = 1},
  [14] = {.index = 16, .length = 4},
  [15] = {.index = 20, .length = 1},
  [16] = {.index = 21, .length = 1},
  [17] = {.index = 22, .length = 4},
  [18] = {.index = 26, .length = 1},
  [19] = {.index = 27, .length = 1},
  [20] = {.index = 28, .length = 1},
  [21] = {.index = 29, .length = 1},
  [22] = {.index = 30, .length = 3},
  [23] = {.index = 33, .length = 1},
  [24] = {.index = 34, .length = 2},
  [25] = {.index = 36, .length = 3},
  [26] = {.index = 39, .length = 1},
  [27] = {.index = 40, .length = 4},
  [28] = {.index = 44, .length = 4},
  [29] = {.index = 48, .length = 3},
  [30] = {.index = 51, .length = 1},
  [31] = {.index = 52, .length = 5},
  [32] = {.index = 57, .length = 2},
  [33] = {.index = 59, .length = 1},
  [34] = {.index = 60, .length = 1},
  [35] = {.index = 61, .length = 2},
  [36] = {.index = 63, .length = 1},
  [37] = {.index = 64, .length = 1},
  [38] = {.index = 65, .length = 3},
  [39] = {.index = 68, .length = 2},
  [40] = {.index = 70, .length = 2},
  [41] = {.index = 72, .length = 1},
  [42] = {.index = 73, .length = 1},
  [43] = {.index = 74, .length = 2},
  [44] = {.index = 76, .length = 1},
  [45] = {.index = 77, .length = 2},
  [46] = {.index = 79, .length = 2},
  [47] = {.index = 81, .length = 2},
  [48] = {.index = 83, .length = 2},
  [49] = {.index = 85, .length = 2},
  [50] = {.index = 87, .length = 4},
  [51] = {.index = 91, .length = 4},
  [52] = {.index = 95, .length = 4},
  [53] = {.index = 99, .length = 1},
  [54] = {.index = 100, .length = 5},
  [55] = {.index = 105, .length = 1},
  [56] = {.index = 106, .length = 3},
  [57] = {.index = 109, .length = 2},
  [58] = {.index = 111, .length = 2},
  [59] = {.index = 113, .length = 2},
  [60] = {.index = 115, .length = 2},
  [61] = {.index = 117, .length = 1},
  [62] = {.index = 118, .length = 2},
  [63] = {.index = 120, .length = 2},
  [64] = {.index = 122, .length = 1},
  [66] = {.index = 123, .length = 3},
  [67] = {.index = 126, .length = 3},
  [68] = {.index = 129, .length = 3},
  [69] = {.index = 132, .length = 2},
  [70] = {.index = 134, .length = 1},
  [71] = {.index = 135, .length = 1},
  [72] = {.index = 136, .length = 2},
  [73] = {.index = 138, .length = 3},
  [74] = {.index = 141, .length = 3},
  [75] = {.index = 144, .length = 1},
  [76] = {.index = 145, .length = 1},
  [77] = {.index = 146, .length = 4},
  [78] = {.index = 150, .length = 4},
  [79] = {.index = 154, .length = 4},
  [80] = {.index = 158, .length = 2},
  [81] = {.index = 160, .length = 3},
  [82] = {.index = 163, .length = 2},
  [83] = {.index = 165, .length = 2},
  [84] = {.index = 167, .length = 1},
  [85] = {.index = 168, .length = 2},
  [86] = {.index = 170, .length = 4},
  [87] = {.index = 145, .length = 1},
  [88] = {.index = 174, .length = 3},
  [89] = {.index = 177, .length = 2},
  [90] = {.index = 179, .length = 4},
  [91] = {.index = 183, .length = 3},
  [92] = {.index = 186, .length = 2},
  [93] = {.index = 188, .length = 1},
  [94] = {.index = 189, .length = 1},
  [95] = {.index = 190, .length = 3},
  [96] = {.index = 193, .length = 3},
  [97] = {.index = 196, .length = 2},
  [98] = {.index = 198, .length = 2},
  [99] = {.index = 200, .length = 1},
  [100] = {.index = 201, .length = 4},
  [101] = {.index = 205, .length = 3},
  [102] = {.index = 208, .length = 2},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_variable_name, 0},
  [1] =
    {field_table_name, 0, .inherited = true},
  [2] =
    {field_table_name, 0},
  [3] =
    {field_field_name, 0, .inherited = true},
  [4] =
    {field_attribute_name, 1},
  [5] =
    {field_method_name, 1, .inherited = true},
    {field_method_table, 0},
  [7] =
    {field_invoked, 0},
  [8] =
    {field_method_name, 0, .inherited = true},
    {field_method_table, 0, .inherited = true},
  [10] =
    {field_body, 1, .inherited = true},
    {field_operator, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
  [13] =
    {field_operand, 1},
    {field_operator, 0},
  [15] =
    {field_value, 0},
  [16] =
    {field_body, 2, .inherited = true},
    {field_function_name, 1},
    {field_operator, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
  [20] =
    {field_body, 1},
  [21] =
    {field_condition, 2},
  [22] =
    {field_assign_symbol, 2, .inherited = true},
    {field_left, 2, .inherited = true},
    {field_operator, 2, .inherited = true},
    {field_right, 2, .inherited = true},
  [26] =
    {field_field_name, 1},
  [27] =
    {field_attribute_name, 0},
  [28] =
    {field_assign_symbol, 1},
  [29] =
    {field_method_name, 1},
  [30] =
    {field_assign_symbol, 1},
    {field_left, 0},
    {field_right, 2},
  [33] =
    {field_parameter_name, 0},
  [34] =
    {field_operator, 0, .inherited = true},
    {field_type_specifier, 0, .inherited = true},
  [36] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [39] =
    {field_type_name, 0},
  [40] =
    {field_left, 0},
    {field_operator, 1},
    {field_operator, 2, .inherited = true},
    {field_right, 2},
  [44] =
    {field_body, 3, .inherited = true},
    {field_function_name, 2},
    {field_operator, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
  [48] =
    {field_operator, 2, .inherited = true},
    {field_type_specifier, 2},
    {field_variable_name, 0},
  [51] =
    {field_assign_symbol, 2},
  [52] =
    {field_body, 3, .inherited = true},
    {field_method_name, 2, .inherited = true},
    {field_operator, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_table_name, 1},
  [57] =
    {field_field_name, 0, .inherited = true},
    {field_method_name, 1, .inherited = true},
  [59] =
    {field_condition, 1},
  [60] =
    {field_alternative, 0},
  [61] =
    {field_body, 1},
    {field_condition, 3},
  [63] =
    {field_field_indexer, 1},
  [64] =
    {field_generic_typepack_name, 0},
  [65] =
    {field_assign_symbol, 1},
    {field_field_name, 0},
    {field_value, 2},
  [68] =
    {field_array_type_specifier, 0},
    {field_operator, 0, .inherited = true},
  [70] =
    {field_array_type_specifier, 0, .inherited = true},
    {field_operator, 0, .inherited = true},
  [72] =
    {field_operator, 0, .inherited = true},
  [73] =
    {field_operator, 0},
  [74] =
    {field_operand, 0},
    {field_operator, 1},
  [76] =
    {field_return_type, 1},
  [77] =
    {field_condition, 1},
    {field_consequence, 3},
  [79] =
    {field_alternative, 3},
    {field_condition, 1},
  [81] =
    {field_alternative, 3, .inherited = true},
    {field_condition, 1},
  [83] =
    {field_alternative, 0, .inherited = true},
    {field_alternative, 1, .inherited = true},
  [85] =
    {field_body, 3},
    {field_condition, 1},
  [87] =
    {field_assign_symbol, 4, .inherited = true},
    {field_left, 4, .inherited = true},
    {field_operator, 4, .inherited = true},
    {field_right, 4, .inherited = true},
  [91] =
    {field_body, 4, .inherited = true},
    {field_function_name, 3},
    {field_operator, 4, .inherited = true},
    {field_return_type, 4, .inherited = true},
  [95] =
    {field_assign_symbol, 1},
    {field_left, 0},
    {field_operator, 2, .inherited = true},
    {field_right, 2},
  [99] =
    {field_generic_type_name, 0},
  [100] =
    {field_body, 4, .inherited = true},
    {field_method_name, 3, .inherited = true},
    {field_operator, 4, .inherited = true},
    {field_return_type, 4, .inherited = true},
    {field_table_name, 2},
  [105] =
    {field_body, 2},
  [106] =
    {field_operator, 2, .inherited = true},
    {field_parameter_name, 0},
    {field_type_specifier, 2},
  [109] =
    {field_operator, 2, .inherited = true},
    {field_type_specifier, 2, .inherited = true},
  [111] =
    {field_operator, 2, .inherited = true},
    {field_type_specifier, 2},
  [113] =
    {field_array_type_specifier, 1, .inherited = true},
    {field_operator, 1, .inherited = true},
  [115] =
    {field_array_type_specifier, 1},
    {field_operator, 1, .inherited = true},
  [117] =
    {field_operator, 1, .inherited = true},
  [118] =
    {field_operator, 0, .inherited = true},
    {field_operator, 1, .inherited = true},
  [120] =
    {field_module_namespace, 0},
    {field_type_name, 2},
  [122] =
    {field_return_type, 2},
  [123] =
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 3},
  [126] =
    {field_alternative, 4, .inherited = true},
    {field_condition, 1},
    {field_consequence, 3},
  [129] =
    {field_alternative, 3, .inherited = true},
    {field_alternative, 4},
    {field_condition, 1},
  [132] =
    {field_operator, 3, .inherited = true},
    {field_return_type, 3},
  [134] =
    {field_return_type, 3},
  [135] =
    {field_body, 3},
  [136] =
    {field_operator, 3, .inherited = true},
    {field_type_specifier, 3, .inherited = true},
  [138] =
    {field_assign_symbol, 3},
    {field_field_indexer, 1},
    {field_value, 4},
  [141] =
    {field_field_name, 0},
    {field_operator, 2, .inherited = true},
    {field_type_specifier, 2},
  [144] =
    {field_operator, 2, .inherited = true},
  [145] =
    {field_body, 5},
  [146] =
    {field_alternative, 4, .inherited = true},
    {field_alternative, 5},
    {field_condition, 1},
    {field_consequence, 3},
  [150] =
    {field_body, 6, .inherited = true},
    {field_function_name, 5},
    {field_operator, 6, .inherited = true},
    {field_return_type, 6, .inherited = true},
  [154] =
    {field_assign_symbol, 1},
    {field_generic_type_name, 0},
    {field_operator, 2, .inherited = true},
    {field_type_value, 2},
  [158] =
    {field_assign_symbol, 1},
    {field_typepack_value, 2},
  [160] =
    {field_body, 4},
    {field_operator, 3, .inherited = true},
    {field_return_type, 3},
  [163] =
    {field_body, 4},
    {field_return_type, 3},
  [165] =
    {field_operator, 4, .inherited = true},
    {field_return_type, 4},
  [167] =
    {field_return_type, 4},
  [168] =
    {field_start, 3},
    {field_stop, 5},
  [170] =
    {field_assign_symbol, 4},
    {field_left, 0},
    {field_operator, 5, .inherited = true},
    {field_right, 5},
  [174] =
    {field_body, 5},
    {field_operator, 4, .inherited = true},
    {field_return_type, 4},
  [177] =
    {field_body, 5},
    {field_return_type, 4},
  [179] =
    {field_indexer_type_specifier, 1},
    {field_operator, 1, .inherited = true},
    {field_operator, 4, .inherited = true},
    {field_value_type_specifier, 4},
  [183] =
    {field_body, 7},
    {field_start, 3},
    {field_stop, 5},
  [186] =
    {field_operator, 6, .inherited = true},
    {field_return_type, 6},
  [188] =
    {field_return_type, 6},
  [189] =
    {field_body, 6},
  [190] =
    {field_start, 3},
    {field_step, 7},
    {field_stop, 5},
  [193] =
    {field_body, 7},
    {field_operator, 6, .inherited = true},
    {field_return_type, 6},
  [196] =
    {field_body, 7},
    {field_return_type, 6},
  [198] =
    {field_operator, 7, .inherited = true},
    {field_return_type, 7},
  [200] =
    {field_return_type, 7},
  [201] =
    {field_body, 9},
    {field_start, 3},
    {field_step, 7},
    {field_stop, 5},
  [205] =
    {field_body, 8},
    {field_operator, 7, .inherited = true},
    {field_return_type, 7},
  [208] =
    {field_body, 8},
    {field_return_type, 7},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [3] = {
    [1] = alias_sym_explist,
  },
  [13] = {
    [0] = sym_key,
  },
  [20] = {
    [2] = alias_sym_explist,
  },
  [30] = {
    [3] = alias_sym_explist,
  },
  [32] = {
    [0] = sym_key,
  },
  [65] = {
    [3] = alias_sym_explist,
  },
  [76] = {
    [3] = alias_sym_explist,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym__explist, 2,
    sym__explist,
    alias_sym_explist,
  sym__key_named, 2,
    sym__key_named,
    sym_key,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 2,
  [4] = 2,
  [5] = 2,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 7,
  [10] = 10,
  [11] = 11,
  [12] = 8,
  [13] = 8,
  [14] = 7,
  [15] = 10,
  [16] = 11,
  [17] = 10,
  [18] = 8,
  [19] = 7,
  [20] = 10,
  [21] = 11,
  [22] = 8,
  [23] = 7,
  [24] = 10,
  [25] = 11,
  [26] = 8,
  [27] = 7,
  [28] = 10,
  [29] = 11,
  [30] = 8,
  [31] = 7,
  [32] = 10,
  [33] = 11,
  [34] = 8,
  [35] = 7,
  [36] = 10,
  [37] = 11,
  [38] = 8,
  [39] = 7,
  [40] = 10,
  [41] = 11,
  [42] = 8,
  [43] = 7,
  [44] = 10,
  [45] = 11,
  [46] = 8,
  [47] = 7,
  [48] = 10,
  [49] = 11,
  [50] = 8,
  [51] = 7,
  [52] = 10,
  [53] = 11,
  [54] = 8,
  [55] = 7,
  [56] = 10,
  [57] = 11,
  [58] = 8,
  [59] = 7,
  [60] = 10,
  [61] = 11,
  [62] = 8,
  [63] = 7,
  [64] = 10,
  [65] = 11,
  [66] = 8,
  [67] = 7,
  [68] = 10,
  [69] = 11,
  [70] = 11,
  [71] = 71,
  [72] = 72,
  [73] = 73,
  [74] = 74,
  [75] = 75,
  [76] = 73,
  [77] = 77,
  [78] = 78,
  [79] = 71,
  [80] = 80,
  [81] = 81,
  [82] = 82,
  [83] = 77,
  [84] = 84,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 73,
  [90] = 78,
  [91] = 75,
  [92] = 75,
  [93] = 71,
  [94] = 77,
  [95] = 78,
  [96] = 80,
  [97] = 80,
  [98] = 81,
  [99] = 82,
  [100] = 81,
  [101] = 84,
  [102] = 85,
  [103] = 86,
  [104] = 87,
  [105] = 88,
  [106] = 73,
  [107] = 82,
  [108] = 75,
  [109] = 84,
  [110] = 71,
  [111] = 77,
  [112] = 78,
  [113] = 85,
  [114] = 80,
  [115] = 81,
  [116] = 82,
  [117] = 86,
  [118] = 84,
  [119] = 85,
  [120] = 86,
  [121] = 87,
  [122] = 88,
  [123] = 87,
  [124] = 88,
  [125] = 77,
  [126] = 78,
  [127] = 80,
  [128] = 81,
  [129] = 84,
  [130] = 85,
  [131] = 87,
  [132] = 88,
  [133] = 77,
  [134] = 78,
  [135] = 80,
  [136] = 81,
  [137] = 137,
  [138] = 84,
  [139] = 85,
  [140] = 87,
  [141] = 88,
  [142] = 77,
  [143] = 78,
  [144] = 80,
  [145] = 81,
  [146] = 84,
  [147] = 85,
  [148] = 87,
  [149] = 88,
  [150] = 77,
  [151] = 78,
  [152] = 80,
  [153] = 72,
  [154] = 84,
  [155] = 85,
  [156] = 87,
  [157] = 88,
  [158] = 77,
  [159] = 78,
  [160] = 80,
  [161] = 81,
  [162] = 84,
  [163] = 85,
  [164] = 87,
  [165] = 88,
  [166] = 77,
  [167] = 78,
  [168] = 80,
  [169] = 81,
  [170] = 84,
  [171] = 85,
  [172] = 87,
  [173] = 88,
  [174] = 77,
  [175] = 78,
  [176] = 80,
  [177] = 81,
  [178] = 84,
  [179] = 85,
  [180] = 87,
  [181] = 88,
  [182] = 77,
  [183] = 78,
  [184] = 80,
  [185] = 81,
  [186] = 84,
  [187] = 85,
  [188] = 87,
  [189] = 88,
  [190] = 77,
  [191] = 78,
  [192] = 80,
  [193] = 81,
  [194] = 84,
  [195] = 85,
  [196] = 87,
  [197] = 88,
  [198] = 77,
  [199] = 78,
  [200] = 80,
  [201] = 81,
  [202] = 84,
  [203] = 85,
  [204] = 87,
  [205] = 88,
  [206] = 72,
  [207] = 77,
  [208] = 78,
  [209] = 80,
  [210] = 81,
  [211] = 84,
  [212] = 85,
  [213] = 87,
  [214] = 88,
  [215] = 77,
  [216] = 78,
  [217] = 80,
  [218] = 81,
  [219] = 84,
  [220] = 85,
  [221] = 87,
  [222] = 88,
  [223] = 72,
  [224] = 81,
  [225] = 225,
  [226] = 226,
  [227] = 227,
  [228] = 228,
  [229] = 137,
  [230] = 137,
  [231] = 137,
  [232] = 227,
  [233] = 233,
  [234] = 234,
  [235] = 235,
  [236] = 226,
  [237] = 237,
  [238] = 238,
  [239] = 239,
  [240] = 240,
  [241] = 241,
  [242] = 242,
  [243] = 226,
  [244] = 226,
  [245] = 245,
  [246] = 225,
  [247] = 228,
  [248] = 227,
  [249] = 225,
  [250] = 228,
  [251] = 227,
  [252] = 252,
  [253] = 253,
  [254] = 254,
  [255] = 255,
  [256] = 256,
  [257] = 257,
  [258] = 228,
  [259] = 225,
  [260] = 260,
  [261] = 261,
  [262] = 262,
  [263] = 252,
  [264] = 254,
  [265] = 253,
  [266] = 255,
  [267] = 254,
  [268] = 255,
  [269] = 256,
  [270] = 256,
  [271] = 237,
  [272] = 238,
  [273] = 239,
  [274] = 257,
  [275] = 240,
  [276] = 241,
  [277] = 241,
  [278] = 242,
  [279] = 245,
  [280] = 245,
  [281] = 242,
  [282] = 282,
  [283] = 283,
  [284] = 245,
  [285] = 257,
  [286] = 235,
  [287] = 237,
  [288] = 238,
  [289] = 260,
  [290] = 235,
  [291] = 233,
  [292] = 253,
  [293] = 293,
  [294] = 294,
  [295] = 295,
  [296] = 239,
  [297] = 254,
  [298] = 298,
  [299] = 299,
  [300] = 240,
  [301] = 234,
  [302] = 302,
  [303] = 241,
  [304] = 304,
  [305] = 305,
  [306] = 257,
  [307] = 307,
  [308] = 255,
  [309] = 242,
  [310] = 310,
  [311] = 311,
  [312] = 256,
  [313] = 313,
  [314] = 314,
  [315] = 315,
  [316] = 316,
  [317] = 317,
  [318] = 318,
  [319] = 319,
  [320] = 252,
  [321] = 321,
  [322] = 322,
  [323] = 323,
  [324] = 324,
  [325] = 325,
  [326] = 326,
  [327] = 237,
  [328] = 238,
  [329] = 234,
  [330] = 235,
  [331] = 239,
  [332] = 260,
  [333] = 233,
  [334] = 240,
  [335] = 260,
  [336] = 233,
  [337] = 234,
  [338] = 235,
  [339] = 252,
  [340] = 253,
  [341] = 234,
  [342] = 342,
  [343] = 343,
  [344] = 262,
  [345] = 262,
  [346] = 261,
  [347] = 262,
  [348] = 261,
  [349] = 261,
  [350] = 313,
  [351] = 317,
  [352] = 305,
  [353] = 315,
  [354] = 318,
  [355] = 319,
  [356] = 283,
  [357] = 321,
  [358] = 322,
  [359] = 307,
  [360] = 310,
  [361] = 323,
  [362] = 324,
  [363] = 325,
  [364] = 311,
  [365] = 313,
  [366] = 326,
  [367] = 314,
  [368] = 368,
  [369] = 293,
  [370] = 294,
  [371] = 315,
  [372] = 295,
  [373] = 316,
  [374] = 298,
  [375] = 299,
  [376] = 342,
  [377] = 302,
  [378] = 234,
  [379] = 304,
  [380] = 305,
  [381] = 235,
  [382] = 317,
  [383] = 307,
  [384] = 282,
  [385] = 310,
  [386] = 311,
  [387] = 313,
  [388] = 314,
  [389] = 316,
  [390] = 318,
  [391] = 317,
  [392] = 318,
  [393] = 393,
  [394] = 319,
  [395] = 321,
  [396] = 322,
  [397] = 319,
  [398] = 316,
  [399] = 324,
  [400] = 325,
  [401] = 326,
  [402] = 282,
  [403] = 321,
  [404] = 322,
  [405] = 283,
  [406] = 406,
  [407] = 323,
  [408] = 315,
  [409] = 324,
  [410] = 325,
  [411] = 293,
  [412] = 294,
  [413] = 326,
  [414] = 293,
  [415] = 295,
  [416] = 282,
  [417] = 294,
  [418] = 295,
  [419] = 283,
  [420] = 298,
  [421] = 299,
  [422] = 234,
  [423] = 235,
  [424] = 298,
  [425] = 342,
  [426] = 302,
  [427] = 304,
  [428] = 305,
  [429] = 299,
  [430] = 342,
  [431] = 302,
  [432] = 307,
  [433] = 433,
  [434] = 310,
  [435] = 311,
  [436] = 304,
  [437] = 235,
  [438] = 314,
  [439] = 234,
  [440] = 323,
  [441] = 441,
  [442] = 442,
  [443] = 443,
  [444] = 441,
  [445] = 445,
  [446] = 446,
  [447] = 441,
  [448] = 441,
  [449] = 441,
  [450] = 441,
  [451] = 441,
  [452] = 343,
  [453] = 441,
  [454] = 454,
  [455] = 455,
  [456] = 456,
  [457] = 457,
  [458] = 458,
  [459] = 459,
  [460] = 460,
  [461] = 461,
  [462] = 462,
  [463] = 463,
  [464] = 441,
  [465] = 465,
  [466] = 466,
  [467] = 467,
  [468] = 468,
  [469] = 469,
  [470] = 470,
  [471] = 471,
  [472] = 472,
  [473] = 473,
  [474] = 474,
  [475] = 475,
  [476] = 476,
  [477] = 441,
  [478] = 478,
  [479] = 479,
  [480] = 441,
  [481] = 441,
  [482] = 343,
  [483] = 343,
  [484] = 441,
  [485] = 441,
  [486] = 486,
  [487] = 441,
  [488] = 260,
  [489] = 233,
  [490] = 490,
  [491] = 491,
  [492] = 492,
  [493] = 493,
  [494] = 494,
  [495] = 441,
  [496] = 496,
  [497] = 497,
  [498] = 498,
  [499] = 499,
  [500] = 500,
  [501] = 501,
  [502] = 502,
  [503] = 441,
  [504] = 441,
  [505] = 441,
  [506] = 441,
  [507] = 441,
  [508] = 441,
  [509] = 441,
  [510] = 441,
  [511] = 441,
  [512] = 441,
  [513] = 441,
  [514] = 441,
  [515] = 441,
  [516] = 516,
  [517] = 517,
  [518] = 516,
  [519] = 516,
  [520] = 393,
  [521] = 368,
  [522] = 368,
  [523] = 523,
  [524] = 524,
  [525] = 525,
  [526] = 517,
  [527] = 516,
  [528] = 517,
  [529] = 516,
  [530] = 517,
  [531] = 516,
  [532] = 517,
  [533] = 516,
  [534] = 517,
  [535] = 516,
  [536] = 516,
  [537] = 516,
  [538] = 517,
  [539] = 516,
  [540] = 393,
  [541] = 368,
  [542] = 517,
  [543] = 517,
  [544] = 516,
  [545] = 517,
  [546] = 516,
  [547] = 517,
  [548] = 516,
  [549] = 517,
  [550] = 517,
  [551] = 516,
  [552] = 516,
  [553] = 393,
  [554] = 517,
  [555] = 516,
  [556] = 517,
  [557] = 517,
  [558] = 516,
  [559] = 517,
  [560] = 517,
  [561] = 561,
  [562] = 501,
  [563] = 502,
  [564] = 469,
  [565] = 442,
  [566] = 470,
  [567] = 471,
  [568] = 472,
  [569] = 473,
  [570] = 474,
  [571] = 475,
  [572] = 476,
  [573] = 478,
  [574] = 561,
  [575] = 479,
  [576] = 445,
  [577] = 497,
  [578] = 561,
  [579] = 498,
  [580] = 493,
  [581] = 462,
  [582] = 463,
  [583] = 465,
  [584] = 561,
  [585] = 494,
  [586] = 496,
  [587] = 497,
  [588] = 260,
  [589] = 498,
  [590] = 561,
  [591] = 443,
  [592] = 561,
  [593] = 499,
  [594] = 446,
  [595] = 497,
  [596] = 498,
  [597] = 499,
  [598] = 500,
  [599] = 501,
  [600] = 260,
  [601] = 502,
  [602] = 233,
  [603] = 455,
  [604] = 456,
  [605] = 500,
  [606] = 561,
  [607] = 442,
  [608] = 233,
  [609] = 443,
  [610] = 446,
  [611] = 501,
  [612] = 466,
  [613] = 561,
  [614] = 445,
  [615] = 486,
  [616] = 502,
  [617] = 499,
  [618] = 457,
  [619] = 458,
  [620] = 459,
  [621] = 500,
  [622] = 459,
  [623] = 561,
  [624] = 624,
  [625] = 490,
  [626] = 486,
  [627] = 491,
  [628] = 460,
  [629] = 461,
  [630] = 462,
  [631] = 463,
  [632] = 465,
  [633] = 466,
  [634] = 467,
  [635] = 468,
  [636] = 469,
  [637] = 454,
  [638] = 561,
  [639] = 492,
  [640] = 478,
  [641] = 476,
  [642] = 467,
  [643] = 471,
  [644] = 472,
  [645] = 473,
  [646] = 474,
  [647] = 475,
  [648] = 476,
  [649] = 478,
  [650] = 479,
  [651] = 455,
  [652] = 493,
  [653] = 456,
  [654] = 561,
  [655] = 446,
  [656] = 445,
  [657] = 494,
  [658] = 490,
  [659] = 496,
  [660] = 490,
  [661] = 457,
  [662] = 458,
  [663] = 459,
  [664] = 442,
  [665] = 460,
  [666] = 491,
  [667] = 561,
  [668] = 460,
  [669] = 491,
  [670] = 561,
  [671] = 461,
  [672] = 492,
  [673] = 486,
  [674] = 454,
  [675] = 462,
  [676] = 493,
  [677] = 561,
  [678] = 463,
  [679] = 465,
  [680] = 443,
  [681] = 494,
  [682] = 466,
  [683] = 496,
  [684] = 492,
  [685] = 467,
  [686] = 561,
  [687] = 468,
  [688] = 458,
  [689] = 468,
  [690] = 561,
  [691] = 260,
  [692] = 469,
  [693] = 470,
  [694] = 471,
  [695] = 461,
  [696] = 561,
  [697] = 472,
  [698] = 479,
  [699] = 473,
  [700] = 233,
  [701] = 474,
  [702] = 475,
  [703] = 454,
  [704] = 455,
  [705] = 456,
  [706] = 457,
  [707] = 470,
  [708] = 708,
  [709] = 523,
  [710] = 524,
  [711] = 525,
  [712] = 712,
  [713] = 713,
  [714] = 714,
  [715] = 713,
  [716] = 714,
  [717] = 523,
  [718] = 524,
  [719] = 525,
  [720] = 523,
  [721] = 524,
  [722] = 713,
  [723] = 714,
  [724] = 708,
  [725] = 525,
  [726] = 726,
  [727] = 727,
  [728] = 713,
  [729] = 729,
  [730] = 714,
  [731] = 708,
  [732] = 726,
  [733] = 729,
  [734] = 708,
  [735] = 726,
  [736] = 729,
  [737] = 726,
  [738] = 729,
  [739] = 708,
  [740] = 726,
  [741] = 729,
  [742] = 708,
  [743] = 726,
  [744] = 729,
  [745] = 708,
  [746] = 726,
  [747] = 729,
  [748] = 712,
  [749] = 726,
  [750] = 729,
  [751] = 708,
  [752] = 726,
  [753] = 729,
  [754] = 708,
  [755] = 726,
  [756] = 729,
  [757] = 708,
  [758] = 726,
  [759] = 729,
  [760] = 708,
  [761] = 726,
  [762] = 729,
  [763] = 708,
  [764] = 726,
  [765] = 729,
  [766] = 708,
  [767] = 726,
  [768] = 729,
  [769] = 708,
  [770] = 726,
  [771] = 729,
  [772] = 708,
  [773] = 726,
  [774] = 729,
  [775] = 708,
  [776] = 726,
  [777] = 729,
  [778] = 708,
  [779] = 726,
  [780] = 729,
  [781] = 712,
  [782] = 712,
  [783] = 708,
  [784] = 784,
  [785] = 785,
  [786] = 786,
  [787] = 787,
  [788] = 788,
  [789] = 789,
  [790] = 790,
  [791] = 789,
  [792] = 788,
  [793] = 793,
  [794] = 794,
  [795] = 795,
  [796] = 796,
  [797] = 797,
  [798] = 798,
  [799] = 799,
  [800] = 800,
  [801] = 784,
  [802] = 802,
  [803] = 786,
  [804] = 787,
  [805] = 788,
  [806] = 790,
  [807] = 807,
  [808] = 808,
  [809] = 789,
  [810] = 790,
  [811] = 794,
  [812] = 797,
  [813] = 799,
  [814] = 795,
  [815] = 796,
  [816] = 798,
  [817] = 800,
  [818] = 802,
  [819] = 787,
  [820] = 797,
  [821] = 799,
  [822] = 789,
  [823] = 790,
  [824] = 794,
  [825] = 795,
  [826] = 796,
  [827] = 798,
  [828] = 800,
  [829] = 802,
  [830] = 787,
  [831] = 797,
  [832] = 799,
  [833] = 833,
  [834] = 834,
  [835] = 789,
  [836] = 794,
  [837] = 797,
  [838] = 799,
  [839] = 795,
  [840] = 796,
  [841] = 790,
  [842] = 798,
  [843] = 800,
  [844] = 802,
  [845] = 787,
  [846] = 784,
  [847] = 797,
  [848] = 799,
  [849] = 849,
  [850] = 789,
  [851] = 790,
  [852] = 852,
  [853] = 789,
  [854] = 799,
  [855] = 794,
  [856] = 795,
  [857] = 796,
  [858] = 798,
  [859] = 800,
  [860] = 802,
  [861] = 787,
  [862] = 799,
  [863] = 863,
  [864] = 864,
  [865] = 789,
  [866] = 790,
  [867] = 786,
  [868] = 868,
  [869] = 799,
  [870] = 870,
  [871] = 789,
  [872] = 872,
  [873] = 794,
  [874] = 795,
  [875] = 796,
  [876] = 798,
  [877] = 800,
  [878] = 802,
  [879] = 787,
  [880] = 789,
  [881] = 790,
  [882] = 882,
  [883] = 883,
  [884] = 797,
  [885] = 790,
  [886] = 886,
  [887] = 790,
  [888] = 794,
  [889] = 889,
  [890] = 794,
  [891] = 795,
  [892] = 796,
  [893] = 798,
  [894] = 800,
  [895] = 802,
  [896] = 787,
  [897] = 795,
  [898] = 898,
  [899] = 796,
  [900] = 798,
  [901] = 800,
  [902] = 802,
  [903] = 787,
  [904] = 789,
  [905] = 790,
  [906] = 797,
  [907] = 794,
  [908] = 833,
  [909] = 849,
  [910] = 807,
  [911] = 852,
  [912] = 794,
  [913] = 795,
  [914] = 795,
  [915] = 833,
  [916] = 849,
  [917] = 807,
  [918] = 796,
  [919] = 852,
  [920] = 798,
  [921] = 800,
  [922] = 796,
  [923] = 833,
  [924] = 849,
  [925] = 807,
  [926] = 798,
  [927] = 852,
  [928] = 802,
  [929] = 833,
  [930] = 849,
  [931] = 807,
  [932] = 852,
  [933] = 787,
  [934] = 785,
  [935] = 833,
  [936] = 849,
  [937] = 807,
  [938] = 852,
  [939] = 833,
  [940] = 849,
  [941] = 807,
  [942] = 799,
  [943] = 852,
  [944] = 800,
  [945] = 833,
  [946] = 849,
  [947] = 807,
  [948] = 852,
  [949] = 799,
  [950] = 786,
  [951] = 833,
  [952] = 849,
  [953] = 807,
  [954] = 852,
  [955] = 833,
  [956] = 849,
  [957] = 807,
  [958] = 788,
  [959] = 852,
  [960] = 789,
  [961] = 790,
  [962] = 833,
  [963] = 849,
  [964] = 807,
  [965] = 852,
  [966] = 833,
  [967] = 849,
  [968] = 807,
  [969] = 852,
  [970] = 794,
  [971] = 795,
  [972] = 833,
  [973] = 849,
  [974] = 852,
  [975] = 794,
  [976] = 795,
  [977] = 796,
  [978] = 852,
  [979] = 798,
  [980] = 800,
  [981] = 852,
  [982] = 802,
  [983] = 787,
  [984] = 796,
  [985] = 852,
  [986] = 798,
  [987] = 800,
  [988] = 797,
  [989] = 852,
  [990] = 852,
  [991] = 802,
  [992] = 799,
  [993] = 864,
  [994] = 793,
  [995] = 787,
  [996] = 863,
  [997] = 889,
  [998] = 864,
  [999] = 793,
  [1000] = 784,
  [1001] = 863,
  [1002] = 889,
  [1003] = 864,
  [1004] = 793,
  [1005] = 863,
  [1006] = 889,
  [1007] = 868,
  [1008] = 868,
  [1009] = 868,
  [1010] = 868,
  [1011] = 868,
  [1012] = 868,
  [1013] = 868,
  [1014] = 868,
  [1015] = 868,
  [1016] = 868,
  [1017] = 868,
  [1018] = 785,
  [1019] = 785,
  [1020] = 802,
  [1021] = 1021,
  [1022] = 1021,
  [1023] = 1023,
  [1024] = 1021,
  [1025] = 1025,
  [1026] = 1026,
  [1027] = 1023,
  [1028] = 1021,
  [1029] = 1025,
  [1030] = 1026,
  [1031] = 1023,
  [1032] = 1021,
  [1033] = 1025,
  [1034] = 1025,
  [1035] = 1026,
  [1036] = 1023,
  [1037] = 1021,
  [1038] = 1025,
  [1039] = 1026,
  [1040] = 1023,
  [1041] = 1021,
  [1042] = 1025,
  [1043] = 1026,
  [1044] = 1023,
  [1045] = 1021,
  [1046] = 1025,
  [1047] = 1026,
  [1048] = 1023,
  [1049] = 1021,
  [1050] = 1025,
  [1051] = 1026,
  [1052] = 1023,
  [1053] = 1053,
  [1054] = 1054,
  [1055] = 1026,
  [1056] = 1023,
  [1057] = 1021,
  [1058] = 1025,
  [1059] = 1026,
  [1060] = 1023,
  [1061] = 1021,
  [1062] = 1025,
  [1063] = 1026,
  [1064] = 1023,
  [1065] = 1021,
  [1066] = 1025,
  [1067] = 1026,
  [1068] = 1023,
  [1069] = 1021,
  [1070] = 1025,
  [1071] = 1026,
  [1072] = 1023,
  [1073] = 1021,
  [1074] = 1025,
  [1075] = 1026,
  [1076] = 1023,
  [1077] = 1021,
  [1078] = 1025,
  [1079] = 1026,
  [1080] = 1026,
  [1081] = 1023,
  [1082] = 1021,
  [1083] = 1025,
  [1084] = 1026,
  [1085] = 1023,
  [1086] = 1025,
  [1087] = 1087,
  [1088] = 227,
  [1089] = 225,
  [1090] = 228,
  [1091] = 1091,
  [1092] = 1092,
  [1093] = 1091,
  [1094] = 1091,
  [1095] = 1091,
  [1096] = 1092,
  [1097] = 1091,
  [1098] = 225,
  [1099] = 1092,
  [1100] = 228,
  [1101] = 227,
  [1102] = 1092,
  [1103] = 1091,
  [1104] = 1092,
  [1105] = 1092,
  [1106] = 1091,
  [1107] = 1092,
  [1108] = 1092,
  [1109] = 1091,
  [1110] = 1091,
  [1111] = 1092,
  [1112] = 1092,
  [1113] = 1091,
  [1114] = 1091,
  [1115] = 1092,
  [1116] = 1092,
  [1117] = 1092,
  [1118] = 1091,
  [1119] = 1092,
  [1120] = 1091,
  [1121] = 1092,
  [1122] = 1092,
  [1123] = 1092,
  [1124] = 1091,
  [1125] = 1091,
  [1126] = 1092,
  [1127] = 1091,
  [1128] = 1091,
  [1129] = 1091,
  [1130] = 1130,
  [1131] = 241,
  [1132] = 237,
  [1133] = 245,
  [1134] = 234,
  [1135] = 260,
  [1136] = 235,
  [1137] = 238,
  [1138] = 1138,
  [1139] = 233,
  [1140] = 256,
  [1141] = 252,
  [1142] = 1142,
  [1143] = 253,
  [1144] = 239,
  [1145] = 254,
  [1146] = 255,
  [1147] = 240,
  [1148] = 1148,
  [1149] = 242,
  [1150] = 233,
  [1151] = 241,
  [1152] = 227,
  [1153] = 234,
  [1154] = 242,
  [1155] = 257,
  [1156] = 237,
  [1157] = 245,
  [1158] = 257,
  [1159] = 260,
  [1160] = 235,
  [1161] = 225,
  [1162] = 228,
  [1163] = 227,
  [1164] = 253,
  [1165] = 252,
  [1166] = 255,
  [1167] = 239,
  [1168] = 240,
  [1169] = 225,
  [1170] = 228,
  [1171] = 256,
  [1172] = 254,
  [1173] = 238,
  [1174] = 257,
  [1175] = 262,
  [1176] = 261,
  [1177] = 225,
  [1178] = 228,
  [1179] = 1179,
  [1180] = 225,
  [1181] = 228,
  [1182] = 227,
  [1183] = 261,
  [1184] = 315,
  [1185] = 1185,
  [1186] = 227,
  [1187] = 228,
  [1188] = 245,
  [1189] = 307,
  [1190] = 254,
  [1191] = 310,
  [1192] = 239,
  [1193] = 260,
  [1194] = 1194,
  [1195] = 298,
  [1196] = 1196,
  [1197] = 317,
  [1198] = 1198,
  [1199] = 262,
  [1200] = 1194,
  [1201] = 1201,
  [1202] = 1194,
  [1203] = 252,
  [1204] = 323,
  [1205] = 1194,
  [1206] = 1196,
  [1207] = 262,
  [1208] = 1208,
  [1209] = 1196,
  [1210] = 295,
  [1211] = 311,
  [1212] = 245,
  [1213] = 1208,
  [1214] = 240,
  [1215] = 1196,
  [1216] = 324,
  [1217] = 241,
  [1218] = 302,
  [1219] = 255,
  [1220] = 1208,
  [1221] = 253,
  [1222] = 1194,
  [1223] = 293,
  [1224] = 315,
  [1225] = 299,
  [1226] = 256,
  [1227] = 294,
  [1228] = 233,
  [1229] = 1229,
  [1230] = 261,
  [1231] = 242,
  [1232] = 225,
  [1233] = 225,
  [1234] = 1234,
  [1235] = 227,
  [1236] = 235,
  [1237] = 1237,
  [1238] = 257,
  [1239] = 228,
  [1240] = 242,
  [1241] = 241,
  [1242] = 234,
  [1243] = 235,
  [1244] = 1244,
  [1245] = 252,
  [1246] = 1194,
  [1247] = 282,
  [1248] = 253,
  [1249] = 304,
  [1250] = 254,
  [1251] = 260,
  [1252] = 1194,
  [1253] = 237,
  [1254] = 238,
  [1255] = 257,
  [1256] = 325,
  [1257] = 237,
  [1258] = 305,
  [1259] = 326,
  [1260] = 1194,
  [1261] = 1237,
  [1262] = 1194,
  [1263] = 233,
  [1264] = 257,
  [1265] = 1208,
  [1266] = 1208,
  [1267] = 234,
  [1268] = 342,
  [1269] = 314,
  [1270] = 1270,
  [1271] = 1237,
  [1272] = 1194,
  [1273] = 234,
  [1274] = 255,
  [1275] = 1275,
  [1276] = 1194,
  [1277] = 313,
  [1278] = 238,
  [1279] = 239,
  [1280] = 1280,
  [1281] = 316,
  [1282] = 240,
  [1283] = 317,
  [1284] = 318,
  [1285] = 319,
  [1286] = 321,
  [1287] = 256,
  [1288] = 283,
  [1289] = 322,
  [1290] = 1194,
  [1291] = 1237,
  [1292] = 235,
  [1293] = 227,
  [1294] = 343,
  [1295] = 261,
  [1296] = 257,
  [1297] = 261,
  [1298] = 257,
  [1299] = 237,
  [1300] = 238,
  [1301] = 239,
  [1302] = 240,
  [1303] = 241,
  [1304] = 242,
  [1305] = 1179,
  [1306] = 234,
  [1307] = 260,
  [1308] = 245,
  [1309] = 235,
  [1310] = 233,
  [1311] = 1179,
  [1312] = 252,
  [1313] = 253,
  [1314] = 254,
  [1315] = 255,
  [1316] = 256,
  [1317] = 261,
  [1318] = 282,
  [1319] = 283,
  [1320] = 252,
  [1321] = 253,
  [1322] = 254,
  [1323] = 255,
  [1324] = 256,
  [1325] = 293,
  [1326] = 294,
  [1327] = 295,
  [1328] = 298,
  [1329] = 299,
  [1330] = 342,
  [1331] = 302,
  [1332] = 304,
  [1333] = 305,
  [1334] = 307,
  [1335] = 310,
  [1336] = 311,
  [1337] = 313,
  [1338] = 314,
  [1339] = 316,
  [1340] = 317,
  [1341] = 318,
  [1342] = 321,
  [1343] = 322,
  [1344] = 323,
  [1345] = 324,
  [1346] = 325,
  [1347] = 326,
  [1348] = 293,
  [1349] = 294,
  [1350] = 295,
  [1351] = 298,
  [1352] = 299,
  [1353] = 342,
  [1354] = 302,
  [1355] = 304,
  [1356] = 305,
  [1357] = 307,
  [1358] = 310,
  [1359] = 311,
  [1360] = 313,
  [1361] = 314,
  [1362] = 316,
  [1363] = 318,
  [1364] = 319,
  [1365] = 321,
  [1366] = 322,
  [1367] = 323,
  [1368] = 324,
  [1369] = 325,
  [1370] = 326,
  [1371] = 282,
  [1372] = 283,
  [1373] = 260,
  [1374] = 233,
  [1375] = 1179,
  [1376] = 260,
  [1377] = 233,
  [1378] = 234,
  [1379] = 235,
  [1380] = 234,
  [1381] = 235,
  [1382] = 234,
  [1383] = 235,
  [1384] = 234,
  [1385] = 235,
  [1386] = 237,
  [1387] = 238,
  [1388] = 239,
  [1389] = 240,
  [1390] = 241,
  [1391] = 242,
  [1392] = 245,
  [1393] = 252,
  [1394] = 253,
  [1395] = 254,
  [1396] = 255,
  [1397] = 256,
  [1398] = 319,
  [1399] = 238,
  [1400] = 260,
  [1401] = 233,
  [1402] = 234,
  [1403] = 235,
  [1404] = 317,
  [1405] = 262,
  [1406] = 257,
  [1407] = 255,
  [1408] = 233,
  [1409] = 256,
  [1410] = 261,
  [1411] = 242,
  [1412] = 237,
  [1413] = 317,
  [1414] = 262,
  [1415] = 245,
  [1416] = 238,
  [1417] = 237,
  [1418] = 241,
  [1419] = 235,
  [1420] = 240,
  [1421] = 241,
  [1422] = 242,
  [1423] = 315,
  [1424] = 239,
  [1425] = 262,
  [1426] = 252,
  [1427] = 253,
  [1428] = 317,
  [1429] = 254,
  [1430] = 262,
  [1431] = 343,
  [1432] = 245,
  [1433] = 255,
  [1434] = 240,
  [1435] = 256,
  [1436] = 315,
  [1437] = 234,
  [1438] = 257,
  [1439] = 262,
  [1440] = 252,
  [1441] = 253,
  [1442] = 260,
  [1443] = 261,
  [1444] = 254,
  [1445] = 239,
  [1446] = 325,
  [1447] = 458,
  [1448] = 293,
  [1449] = 294,
  [1450] = 295,
  [1451] = 298,
  [1452] = 299,
  [1453] = 342,
  [1454] = 302,
  [1455] = 304,
  [1456] = 305,
  [1457] = 307,
  [1458] = 310,
  [1459] = 311,
  [1460] = 313,
  [1461] = 314,
  [1462] = 316,
  [1463] = 318,
  [1464] = 319,
  [1465] = 321,
  [1466] = 322,
  [1467] = 459,
  [1468] = 323,
  [1469] = 324,
  [1470] = 325,
  [1471] = 326,
  [1472] = 442,
  [1473] = 1473,
  [1474] = 313,
  [1475] = 314,
  [1476] = 316,
  [1477] = 317,
  [1478] = 318,
  [1479] = 319,
  [1480] = 321,
  [1481] = 234,
  [1482] = 260,
  [1483] = 322,
  [1484] = 235,
  [1485] = 233,
  [1486] = 490,
  [1487] = 491,
  [1488] = 492,
  [1489] = 260,
  [1490] = 460,
  [1491] = 461,
  [1492] = 462,
  [1493] = 463,
  [1494] = 465,
  [1495] = 443,
  [1496] = 1496,
  [1497] = 323,
  [1498] = 466,
  [1499] = 324,
  [1500] = 467,
  [1501] = 468,
  [1502] = 469,
  [1503] = 470,
  [1504] = 471,
  [1505] = 472,
  [1506] = 257,
  [1507] = 473,
  [1508] = 474,
  [1509] = 475,
  [1510] = 476,
  [1511] = 478,
  [1512] = 479,
  [1513] = 282,
  [1514] = 283,
  [1515] = 1515,
  [1516] = 326,
  [1517] = 293,
  [1518] = 294,
  [1519] = 295,
  [1520] = 234,
  [1521] = 235,
  [1522] = 261,
  [1523] = 262,
  [1524] = 282,
  [1525] = 283,
  [1526] = 299,
  [1527] = 1527,
  [1528] = 282,
  [1529] = 283,
  [1530] = 368,
  [1531] = 255,
  [1532] = 233,
  [1533] = 1527,
  [1534] = 235,
  [1535] = 293,
  [1536] = 294,
  [1537] = 304,
  [1538] = 295,
  [1539] = 298,
  [1540] = 1473,
  [1541] = 1496,
  [1542] = 299,
  [1543] = 293,
  [1544] = 294,
  [1545] = 295,
  [1546] = 342,
  [1547] = 298,
  [1548] = 305,
  [1549] = 307,
  [1550] = 299,
  [1551] = 342,
  [1552] = 302,
  [1553] = 310,
  [1554] = 311,
  [1555] = 304,
  [1556] = 445,
  [1557] = 313,
  [1558] = 316,
  [1559] = 1473,
  [1560] = 318,
  [1561] = 319,
  [1562] = 321,
  [1563] = 322,
  [1564] = 1496,
  [1565] = 305,
  [1566] = 302,
  [1567] = 307,
  [1568] = 310,
  [1569] = 311,
  [1570] = 313,
  [1571] = 314,
  [1572] = 316,
  [1573] = 304,
  [1574] = 318,
  [1575] = 319,
  [1576] = 321,
  [1577] = 322,
  [1578] = 1473,
  [1579] = 323,
  [1580] = 324,
  [1581] = 260,
  [1582] = 326,
  [1583] = 455,
  [1584] = 234,
  [1585] = 456,
  [1586] = 252,
  [1587] = 253,
  [1588] = 323,
  [1589] = 324,
  [1590] = 325,
  [1591] = 326,
  [1592] = 1496,
  [1593] = 235,
  [1594] = 486,
  [1595] = 254,
  [1596] = 305,
  [1597] = 293,
  [1598] = 234,
  [1599] = 294,
  [1600] = 235,
  [1601] = 295,
  [1602] = 298,
  [1603] = 299,
  [1604] = 342,
  [1605] = 302,
  [1606] = 234,
  [1607] = 235,
  [1608] = 315,
  [1609] = 304,
  [1610] = 1473,
  [1611] = 1496,
  [1612] = 305,
  [1613] = 307,
  [1614] = 307,
  [1615] = 252,
  [1616] = 253,
  [1617] = 310,
  [1618] = 254,
  [1619] = 311,
  [1620] = 493,
  [1621] = 1527,
  [1622] = 313,
  [1623] = 1515,
  [1624] = 255,
  [1625] = 1473,
  [1626] = 1496,
  [1627] = 1515,
  [1628] = 1527,
  [1629] = 314,
  [1630] = 256,
  [1631] = 298,
  [1632] = 1515,
  [1633] = 1473,
  [1634] = 1496,
  [1635] = 342,
  [1636] = 302,
  [1637] = 1473,
  [1638] = 1496,
  [1639] = 1527,
  [1640] = 314,
  [1641] = 1515,
  [1642] = 1473,
  [1643] = 1496,
  [1644] = 1527,
  [1645] = 1515,
  [1646] = 1473,
  [1647] = 1496,
  [1648] = 1527,
  [1649] = 233,
  [1650] = 1515,
  [1651] = 1473,
  [1652] = 1496,
  [1653] = 494,
  [1654] = 496,
  [1655] = 1527,
  [1656] = 282,
  [1657] = 283,
  [1658] = 497,
  [1659] = 316,
  [1660] = 1660,
  [1661] = 1515,
  [1662] = 317,
  [1663] = 318,
  [1664] = 1473,
  [1665] = 1496,
  [1666] = 319,
  [1667] = 321,
  [1668] = 322,
  [1669] = 310,
  [1670] = 323,
  [1671] = 1527,
  [1672] = 498,
  [1673] = 234,
  [1674] = 260,
  [1675] = 499,
  [1676] = 500,
  [1677] = 501,
  [1678] = 1515,
  [1679] = 1515,
  [1680] = 1473,
  [1681] = 1496,
  [1682] = 1527,
  [1683] = 324,
  [1684] = 325,
  [1685] = 326,
  [1686] = 235,
  [1687] = 233,
  [1688] = 1515,
  [1689] = 502,
  [1690] = 1473,
  [1691] = 1496,
  [1692] = 1527,
  [1693] = 1515,
  [1694] = 1473,
  [1695] = 1496,
  [1696] = 1527,
  [1697] = 1473,
  [1698] = 1496,
  [1699] = 257,
  [1700] = 1515,
  [1701] = 1527,
  [1702] = 1515,
  [1703] = 1527,
  [1704] = 1515,
  [1705] = 1527,
  [1706] = 1515,
  [1707] = 1527,
  [1708] = 282,
  [1709] = 283,
  [1710] = 1515,
  [1711] = 1711,
  [1712] = 252,
  [1713] = 253,
  [1714] = 254,
  [1715] = 1527,
  [1716] = 1515,
  [1717] = 1527,
  [1718] = 1718,
  [1719] = 315,
  [1720] = 255,
  [1721] = 261,
  [1722] = 1722,
  [1723] = 256,
  [1724] = 1473,
  [1725] = 1496,
  [1726] = 262,
  [1727] = 457,
  [1728] = 234,
  [1729] = 256,
  [1730] = 235,
  [1731] = 454,
  [1732] = 1473,
  [1733] = 1496,
  [1734] = 311,
  [1735] = 325,
  [1736] = 234,
  [1737] = 294,
  [1738] = 499,
  [1739] = 500,
  [1740] = 501,
  [1741] = 261,
  [1742] = 262,
  [1743] = 502,
  [1744] = 315,
  [1745] = 282,
  [1746] = 283,
  [1747] = 1747,
  [1748] = 260,
  [1749] = 233,
  [1750] = 234,
  [1751] = 235,
  [1752] = 1752,
  [1753] = 282,
  [1754] = 283,
  [1755] = 454,
  [1756] = 234,
  [1757] = 455,
  [1758] = 456,
  [1759] = 442,
  [1760] = 235,
  [1761] = 457,
  [1762] = 458,
  [1763] = 459,
  [1764] = 460,
  [1765] = 461,
  [1766] = 462,
  [1767] = 463,
  [1768] = 465,
  [1769] = 466,
  [1770] = 467,
  [1771] = 468,
  [1772] = 469,
  [1773] = 470,
  [1774] = 471,
  [1775] = 472,
  [1776] = 473,
  [1777] = 368,
  [1778] = 474,
  [1779] = 475,
  [1780] = 476,
  [1781] = 478,
  [1782] = 479,
  [1783] = 486,
  [1784] = 490,
  [1785] = 443,
  [1786] = 293,
  [1787] = 343,
  [1788] = 294,
  [1789] = 295,
  [1790] = 298,
  [1791] = 299,
  [1792] = 342,
  [1793] = 315,
  [1794] = 304,
  [1795] = 305,
  [1796] = 307,
  [1797] = 310,
  [1798] = 311,
  [1799] = 313,
  [1800] = 314,
  [1801] = 316,
  [1802] = 317,
  [1803] = 318,
  [1804] = 319,
  [1805] = 321,
  [1806] = 322,
  [1807] = 491,
  [1808] = 323,
  [1809] = 324,
  [1810] = 325,
  [1811] = 261,
  [1812] = 326,
  [1813] = 262,
  [1814] = 492,
  [1815] = 343,
  [1816] = 445,
  [1817] = 493,
  [1818] = 494,
  [1819] = 293,
  [1820] = 295,
  [1821] = 1821,
  [1822] = 1822,
  [1823] = 299,
  [1824] = 304,
  [1825] = 496,
  [1826] = 305,
  [1827] = 307,
  [1828] = 310,
  [1829] = 311,
  [1830] = 313,
  [1831] = 316,
  [1832] = 317,
  [1833] = 318,
  [1834] = 319,
  [1835] = 321,
  [1836] = 322,
  [1837] = 497,
  [1838] = 323,
  [1839] = 324,
  [1840] = 325,
  [1841] = 326,
  [1842] = 446,
  [1843] = 298,
  [1844] = 342,
  [1845] = 302,
  [1846] = 498,
  [1847] = 314,
  [1848] = 302,
  [1849] = 293,
  [1850] = 307,
  [1851] = 1711,
  [1852] = 310,
  [1853] = 368,
  [1854] = 343,
  [1855] = 1855,
  [1856] = 1855,
  [1857] = 293,
  [1858] = 294,
  [1859] = 295,
  [1860] = 1722,
  [1861] = 1660,
  [1862] = 1855,
  [1863] = 299,
  [1864] = 304,
  [1865] = 305,
  [1866] = 1711,
  [1867] = 307,
  [1868] = 310,
  [1869] = 311,
  [1870] = 1855,
  [1871] = 313,
  [1872] = 316,
  [1873] = 317,
  [1874] = 318,
  [1875] = 319,
  [1876] = 321,
  [1877] = 322,
  [1878] = 1660,
  [1879] = 323,
  [1880] = 324,
  [1881] = 325,
  [1882] = 326,
  [1883] = 234,
  [1884] = 235,
  [1885] = 343,
  [1886] = 1855,
  [1887] = 1722,
  [1888] = 235,
  [1889] = 446,
  [1890] = 323,
  [1891] = 1855,
  [1892] = 324,
  [1893] = 305,
  [1894] = 298,
  [1895] = 1718,
  [1896] = 342,
  [1897] = 302,
  [1898] = 325,
  [1899] = 1718,
  [1900] = 1711,
  [1901] = 326,
  [1902] = 1902,
  [1903] = 282,
  [1904] = 1855,
  [1905] = 314,
  [1906] = 283,
  [1907] = 1722,
  [1908] = 368,
  [1909] = 311,
  [1910] = 1660,
  [1911] = 1855,
  [1912] = 313,
  [1913] = 314,
  [1914] = 316,
  [1915] = 234,
  [1916] = 317,
  [1917] = 304,
  [1918] = 294,
  [1919] = 318,
  [1920] = 295,
  [1921] = 1855,
  [1922] = 319,
  [1923] = 1855,
  [1924] = 321,
  [1925] = 1718,
  [1926] = 298,
  [1927] = 299,
  [1928] = 1855,
  [1929] = 342,
  [1930] = 282,
  [1931] = 283,
  [1932] = 322,
  [1933] = 302,
  [1934] = 1855,
  [1935] = 501,
  [1936] = 1747,
  [1937] = 1937,
  [1938] = 1938,
  [1939] = 1939,
  [1940] = 457,
  [1941] = 1941,
  [1942] = 458,
  [1943] = 459,
  [1944] = 493,
  [1945] = 494,
  [1946] = 460,
  [1947] = 461,
  [1948] = 496,
  [1949] = 497,
  [1950] = 498,
  [1951] = 499,
  [1952] = 500,
  [1953] = 343,
  [1954] = 462,
  [1955] = 1821,
  [1956] = 502,
  [1957] = 1822,
  [1958] = 465,
  [1959] = 1752,
  [1960] = 1960,
  [1961] = 1821,
  [1962] = 1822,
  [1963] = 1963,
  [1964] = 463,
  [1965] = 1965,
  [1966] = 1966,
  [1967] = 465,
  [1968] = 466,
  [1969] = 1969,
  [1970] = 1970,
  [1971] = 467,
  [1972] = 468,
  [1973] = 469,
  [1974] = 466,
  [1975] = 470,
  [1976] = 1976,
  [1977] = 1977,
  [1978] = 1978,
  [1979] = 1979,
  [1980] = 1980,
  [1981] = 1981,
  [1982] = 1982,
  [1983] = 471,
  [1984] = 1984,
  [1985] = 1985,
  [1986] = 260,
  [1987] = 467,
  [1988] = 458,
  [1989] = 472,
  [1990] = 468,
  [1991] = 1991,
  [1992] = 1992,
  [1993] = 1993,
  [1994] = 473,
  [1995] = 1995,
  [1996] = 442,
  [1997] = 1997,
  [1998] = 1998,
  [1999] = 474,
  [2000] = 2000,
  [2001] = 443,
  [2002] = 475,
  [2003] = 2003,
  [2004] = 2004,
  [2005] = 2005,
  [2006] = 476,
  [2007] = 2007,
  [2008] = 2008,
  [2009] = 445,
  [2010] = 486,
  [2011] = 479,
  [2012] = 469,
  [2013] = 368,
  [2014] = 456,
  [2015] = 2015,
  [2016] = 1821,
  [2017] = 1822,
  [2018] = 470,
  [2019] = 479,
  [2020] = 2020,
  [2021] = 457,
  [2022] = 490,
  [2023] = 491,
  [2024] = 492,
  [2025] = 455,
  [2026] = 2026,
  [2027] = 471,
  [2028] = 493,
  [2029] = 494,
  [2030] = 496,
  [2031] = 497,
  [2032] = 498,
  [2033] = 499,
  [2034] = 500,
  [2035] = 501,
  [2036] = 460,
  [2037] = 472,
  [2038] = 502,
  [2039] = 1747,
  [2040] = 473,
  [2041] = 2041,
  [2042] = 461,
  [2043] = 462,
  [2044] = 474,
  [2045] = 454,
  [2046] = 475,
  [2047] = 445,
  [2048] = 486,
  [2049] = 1752,
  [2050] = 463,
  [2051] = 455,
  [2052] = 456,
  [2053] = 446,
  [2054] = 2054,
  [2055] = 476,
  [2056] = 454,
  [2057] = 457,
  [2058] = 458,
  [2059] = 459,
  [2060] = 442,
  [2061] = 460,
  [2062] = 461,
  [2063] = 462,
  [2064] = 463,
  [2065] = 465,
  [2066] = 443,
  [2067] = 466,
  [2068] = 467,
  [2069] = 468,
  [2070] = 469,
  [2071] = 470,
  [2072] = 471,
  [2073] = 472,
  [2074] = 473,
  [2075] = 474,
  [2076] = 475,
  [2077] = 476,
  [2078] = 478,
  [2079] = 479,
  [2080] = 478,
  [2081] = 260,
  [2082] = 454,
  [2083] = 1747,
  [2084] = 233,
  [2085] = 2085,
  [2086] = 1752,
  [2087] = 2087,
  [2088] = 233,
  [2089] = 455,
  [2090] = 490,
  [2091] = 491,
  [2092] = 492,
  [2093] = 456,
  [2094] = 459,
  [2095] = 343,
  [2096] = 446,
  [2097] = 478,
  [2098] = 455,
  [2099] = 460,
  [2100] = 461,
  [2101] = 462,
  [2102] = 463,
  [2103] = 465,
  [2104] = 476,
  [2105] = 501,
  [2106] = 2106,
  [2107] = 462,
  [2108] = 445,
  [2109] = 2106,
  [2110] = 478,
  [2111] = 479,
  [2112] = 466,
  [2113] = 467,
  [2114] = 468,
  [2115] = 469,
  [2116] = 502,
  [2117] = 490,
  [2118] = 2106,
  [2119] = 501,
  [2120] = 475,
  [2121] = 455,
  [2122] = 469,
  [2123] = 470,
  [2124] = 456,
  [2125] = 471,
  [2126] = 457,
  [2127] = 260,
  [2128] = 472,
  [2129] = 502,
  [2130] = 2106,
  [2131] = 490,
  [2132] = 486,
  [2133] = 491,
  [2134] = 473,
  [2135] = 474,
  [2136] = 475,
  [2137] = 476,
  [2138] = 492,
  [2139] = 2139,
  [2140] = 260,
  [2141] = 463,
  [2142] = 478,
  [2143] = 494,
  [2144] = 479,
  [2145] = 499,
  [2146] = 498,
  [2147] = 498,
  [2148] = 470,
  [2149] = 454,
  [2150] = 454,
  [2151] = 233,
  [2152] = 1902,
  [2153] = 471,
  [2154] = 465,
  [2155] = 466,
  [2156] = 442,
  [2157] = 472,
  [2158] = 496,
  [2159] = 461,
  [2160] = 442,
  [2161] = 491,
  [2162] = 492,
  [2163] = 443,
  [2164] = 497,
  [2165] = 467,
  [2166] = 445,
  [2167] = 468,
  [2168] = 493,
  [2169] = 458,
  [2170] = 457,
  [2171] = 499,
  [2172] = 458,
  [2173] = 494,
  [2174] = 500,
  [2175] = 459,
  [2176] = 496,
  [2177] = 2177,
  [2178] = 460,
  [2179] = 446,
  [2180] = 1902,
  [2181] = 473,
  [2182] = 443,
  [2183] = 1902,
  [2184] = 497,
  [2185] = 459,
  [2186] = 474,
  [2187] = 493,
  [2188] = 486,
  [2189] = 233,
  [2190] = 500,
  [2191] = 456,
  [2192] = 496,
  [2193] = 462,
  [2194] = 463,
  [2195] = 465,
  [2196] = 443,
  [2197] = 2003,
  [2198] = 2004,
  [2199] = 466,
  [2200] = 467,
  [2201] = 468,
  [2202] = 469,
  [2203] = 2005,
  [2204] = 470,
  [2205] = 471,
  [2206] = 472,
  [2207] = 2007,
  [2208] = 473,
  [2209] = 474,
  [2210] = 475,
  [2211] = 476,
  [2212] = 2008,
  [2213] = 478,
  [2214] = 479,
  [2215] = 2020,
  [2216] = 2026,
  [2217] = 2041,
  [2218] = 1979,
  [2219] = 2003,
  [2220] = 2220,
  [2221] = 2004,
  [2222] = 2222,
  [2223] = 227,
  [2224] = 1980,
  [2225] = 1981,
  [2226] = 2054,
  [2227] = 2005,
  [2228] = 443,
  [2229] = 2229,
  [2230] = 1982,
  [2231] = 2231,
  [2232] = 2007,
  [2233] = 2233,
  [2234] = 2026,
  [2235] = 1937,
  [2236] = 1938,
  [2237] = 1939,
  [2238] = 1941,
  [2239] = 502,
  [2240] = 2229,
  [2241] = 2233,
  [2242] = 2231,
  [2243] = 454,
  [2244] = 1960,
  [2245] = 2233,
  [2246] = 493,
  [2247] = 2008,
  [2248] = 1963,
  [2249] = 1965,
  [2250] = 1966,
  [2251] = 1969,
  [2252] = 1970,
  [2253] = 454,
  [2254] = 2020,
  [2255] = 2026,
  [2256] = 2229,
  [2257] = 1976,
  [2258] = 1977,
  [2259] = 2231,
  [2260] = 1978,
  [2261] = 1979,
  [2262] = 1980,
  [2263] = 1981,
  [2264] = 2041,
  [2265] = 1982,
  [2266] = 1984,
  [2267] = 1985,
  [2268] = 455,
  [2269] = 2233,
  [2270] = 456,
  [2271] = 2271,
  [2272] = 1991,
  [2273] = 1992,
  [2274] = 1993,
  [2275] = 1995,
  [2276] = 457,
  [2277] = 2229,
  [2278] = 458,
  [2279] = 459,
  [2280] = 2231,
  [2281] = 445,
  [2282] = 486,
  [2283] = 2041,
  [2284] = 1997,
  [2285] = 2233,
  [2286] = 1998,
  [2287] = 2000,
  [2288] = 460,
  [2289] = 461,
  [2290] = 462,
  [2291] = 463,
  [2292] = 465,
  [2293] = 2003,
  [2294] = 2004,
  [2295] = 466,
  [2296] = 467,
  [2297] = 468,
  [2298] = 469,
  [2299] = 2229,
  [2300] = 2231,
  [2301] = 2005,
  [2302] = 470,
  [2303] = 471,
  [2304] = 472,
  [2305] = 2007,
  [2306] = 473,
  [2307] = 2233,
  [2308] = 474,
  [2309] = 475,
  [2310] = 476,
  [2311] = 2008,
  [2312] = 478,
  [2313] = 479,
  [2314] = 1991,
  [2315] = 2054,
  [2316] = 2229,
  [2317] = 2231,
  [2318] = 1992,
  [2319] = 260,
  [2320] = 1937,
  [2321] = 2233,
  [2322] = 1993,
  [2323] = 233,
  [2324] = 1938,
  [2325] = 1995,
  [2326] = 490,
  [2327] = 491,
  [2328] = 2229,
  [2329] = 492,
  [2330] = 2231,
  [2331] = 260,
  [2332] = 2020,
  [2333] = 2233,
  [2334] = 1939,
  [2335] = 2231,
  [2336] = 494,
  [2337] = 2229,
  [2338] = 2231,
  [2339] = 1937,
  [2340] = 1938,
  [2341] = 2233,
  [2342] = 2229,
  [2343] = 2231,
  [2344] = 1939,
  [2345] = 1941,
  [2346] = 2233,
  [2347] = 493,
  [2348] = 233,
  [2349] = 455,
  [2350] = 494,
  [2351] = 496,
  [2352] = 497,
  [2353] = 498,
  [2354] = 499,
  [2355] = 500,
  [2356] = 501,
  [2357] = 2229,
  [2358] = 456,
  [2359] = 2231,
  [2360] = 442,
  [2361] = 502,
  [2362] = 497,
  [2363] = 2233,
  [2364] = 1960,
  [2365] = 498,
  [2366] = 499,
  [2367] = 1963,
  [2368] = 1965,
  [2369] = 2229,
  [2370] = 1966,
  [2371] = 2231,
  [2372] = 461,
  [2373] = 458,
  [2374] = 454,
  [2375] = 459,
  [2376] = 2233,
  [2377] = 460,
  [2378] = 461,
  [2379] = 455,
  [2380] = 456,
  [2381] = 2229,
  [2382] = 2231,
  [2383] = 462,
  [2384] = 463,
  [2385] = 465,
  [2386] = 466,
  [2387] = 467,
  [2388] = 2233,
  [2389] = 1969,
  [2390] = 468,
  [2391] = 469,
  [2392] = 457,
  [2393] = 458,
  [2394] = 459,
  [2395] = 470,
  [2396] = 471,
  [2397] = 472,
  [2398] = 473,
  [2399] = 474,
  [2400] = 460,
  [2401] = 461,
  [2402] = 462,
  [2403] = 463,
  [2404] = 465,
  [2405] = 475,
  [2406] = 466,
  [2407] = 2233,
  [2408] = 467,
  [2409] = 468,
  [2410] = 469,
  [2411] = 476,
  [2412] = 470,
  [2413] = 471,
  [2414] = 472,
  [2415] = 473,
  [2416] = 474,
  [2417] = 475,
  [2418] = 476,
  [2419] = 478,
  [2420] = 479,
  [2421] = 460,
  [2422] = 2422,
  [2423] = 478,
  [2424] = 479,
  [2425] = 2233,
  [2426] = 1960,
  [2427] = 1984,
  [2428] = 1985,
  [2429] = 1963,
  [2430] = 2233,
  [2431] = 1965,
  [2432] = 2432,
  [2433] = 1966,
  [2434] = 1970,
  [2435] = 2233,
  [2436] = 1941,
  [2437] = 2233,
  [2438] = 454,
  [2439] = 2054,
  [2440] = 500,
  [2441] = 2441,
  [2442] = 2442,
  [2443] = 2443,
  [2444] = 1969,
  [2445] = 2220,
  [2446] = 2441,
  [2447] = 2442,
  [2448] = 501,
  [2449] = 1976,
  [2450] = 2220,
  [2451] = 2441,
  [2452] = 2442,
  [2453] = 2453,
  [2454] = 1976,
  [2455] = 1977,
  [2456] = 1978,
  [2457] = 1979,
  [2458] = 1980,
  [2459] = 2220,
  [2460] = 1981,
  [2461] = 1982,
  [2462] = 1977,
  [2463] = 1984,
  [2464] = 1985,
  [2465] = 455,
  [2466] = 456,
  [2467] = 1997,
  [2468] = 1998,
  [2469] = 2000,
  [2470] = 1991,
  [2471] = 1992,
  [2472] = 1993,
  [2473] = 1995,
  [2474] = 457,
  [2475] = 1978,
  [2476] = 1970,
  [2477] = 458,
  [2478] = 2441,
  [2479] = 225,
  [2480] = 459,
  [2481] = 454,
  [2482] = 442,
  [2483] = 455,
  [2484] = 456,
  [2485] = 457,
  [2486] = 458,
  [2487] = 459,
  [2488] = 2442,
  [2489] = 460,
  [2490] = 461,
  [2491] = 462,
  [2492] = 463,
  [2493] = 465,
  [2494] = 466,
  [2495] = 467,
  [2496] = 468,
  [2497] = 469,
  [2498] = 470,
  [2499] = 471,
  [2500] = 472,
  [2501] = 473,
  [2502] = 474,
  [2503] = 2453,
  [2504] = 475,
  [2505] = 476,
  [2506] = 478,
  [2507] = 479,
  [2508] = 2453,
  [2509] = 445,
  [2510] = 486,
  [2511] = 2453,
  [2512] = 2453,
  [2513] = 2453,
  [2514] = 2453,
  [2515] = 2453,
  [2516] = 2453,
  [2517] = 2453,
  [2518] = 2453,
  [2519] = 2453,
  [2520] = 1997,
  [2521] = 2432,
  [2522] = 2432,
  [2523] = 2432,
  [2524] = 2229,
  [2525] = 1998,
  [2526] = 490,
  [2527] = 491,
  [2528] = 492,
  [2529] = 2000,
  [2530] = 457,
  [2531] = 2139,
  [2532] = 2139,
  [2533] = 2139,
  [2534] = 2534,
  [2535] = 237,
  [2536] = 242,
  [2537] = 2534,
  [2538] = 245,
  [2539] = 2534,
  [2540] = 240,
  [2541] = 238,
  [2542] = 239,
  [2543] = 2534,
  [2544] = 2544,
  [2545] = 2545,
  [2546] = 2546,
  [2547] = 2547,
  [2548] = 2548,
  [2549] = 2549,
  [2550] = 2550,
  [2551] = 2548,
  [2552] = 2550,
  [2553] = 2548,
  [2554] = 2548,
  [2555] = 2550,
  [2556] = 2550,
  [2557] = 2550,
  [2558] = 2550,
  [2559] = 2559,
  [2560] = 2548,
  [2561] = 2548,
  [2562] = 2548,
  [2563] = 2550,
  [2564] = 2564,
  [2565] = 2548,
  [2566] = 2550,
  [2567] = 2550,
  [2568] = 2548,
  [2569] = 2548,
  [2570] = 2550,
  [2571] = 2550,
  [2572] = 2548,
  [2573] = 2548,
  [2574] = 2550,
  [2575] = 257,
  [2576] = 2576,
  [2577] = 2577,
  [2578] = 2577,
  [2579] = 2579,
  [2580] = 2577,
  [2581] = 2579,
  [2582] = 2579,
  [2583] = 2577,
  [2584] = 2577,
  [2585] = 2579,
  [2586] = 2579,
  [2587] = 2577,
  [2588] = 2579,
  [2589] = 2577,
  [2590] = 2590,
  [2591] = 2579,
  [2592] = 2577,
  [2593] = 2579,
  [2594] = 2577,
  [2595] = 2579,
  [2596] = 2577,
  [2597] = 2579,
  [2598] = 2577,
  [2599] = 2579,
  [2600] = 2577,
  [2601] = 2579,
  [2602] = 2577,
  [2603] = 2579,
  [2604] = 2577,
  [2605] = 2579,
  [2606] = 2577,
  [2607] = 2579,
  [2608] = 2577,
  [2609] = 2579,
  [2610] = 2577,
  [2611] = 2579,
  [2612] = 2577,
  [2613] = 2579,
  [2614] = 2577,
  [2615] = 2579,
  [2616] = 2577,
  [2617] = 2579,
  [2618] = 2577,
  [2619] = 2579,
  [2620] = 2577,
  [2621] = 2579,
  [2622] = 2577,
  [2623] = 2579,
  [2624] = 2577,
  [2625] = 2579,
  [2626] = 2577,
  [2627] = 2579,
  [2628] = 2577,
  [2629] = 2579,
  [2630] = 2577,
  [2631] = 2579,
  [2632] = 2579,
  [2633] = 2579,
  [2634] = 2579,
  [2635] = 2577,
  [2636] = 2577,
  [2637] = 2577,
  [2638] = 2579,
  [2639] = 2579,
  [2640] = 2577,
  [2641] = 2577,
  [2642] = 2642,
  [2643] = 2579,
  [2644] = 2579,
  [2645] = 261,
  [2646] = 2577,
  [2647] = 2577,
  [2648] = 2577,
  [2649] = 2649,
  [2650] = 2579,
  [2651] = 2651,
  [2652] = 298,
  [2653] = 2653,
  [2654] = 262,
  [2655] = 317,
  [2656] = 322,
  [2657] = 325,
  [2658] = 234,
  [2659] = 2659,
  [2660] = 302,
  [2661] = 311,
  [2662] = 235,
  [2663] = 257,
  [2664] = 293,
  [2665] = 294,
  [2666] = 295,
  [2667] = 2667,
  [2668] = 299,
  [2669] = 304,
  [2670] = 305,
  [2671] = 307,
  [2672] = 310,
  [2673] = 2673,
  [2674] = 313,
  [2675] = 316,
  [2676] = 318,
  [2677] = 319,
  [2678] = 321,
  [2679] = 2679,
  [2680] = 323,
  [2681] = 324,
  [2682] = 326,
  [2683] = 314,
  [2684] = 2684,
  [2685] = 342,
  [2686] = 282,
  [2687] = 283,
  [2688] = 2688,
  [2689] = 2689,
  [2690] = 261,
  [2691] = 228,
  [2692] = 2692,
  [2693] = 2693,
  [2694] = 2694,
  [2695] = 2693,
  [2696] = 2696,
  [2697] = 2696,
  [2698] = 2698,
  [2699] = 2699,
  [2700] = 2696,
  [2701] = 2693,
  [2702] = 2702,
  [2703] = 2693,
  [2704] = 2696,
  [2705] = 2696,
  [2706] = 2694,
  [2707] = 2694,
  [2708] = 2693,
  [2709] = 2693,
  [2710] = 2696,
  [2711] = 2711,
  [2712] = 2702,
  [2713] = 2696,
  [2714] = 2696,
  [2715] = 2696,
  [2716] = 2693,
  [2717] = 2693,
  [2718] = 2693,
  [2719] = 2693,
  [2720] = 2696,
  [2721] = 2721,
  [2722] = 2696,
  [2723] = 2693,
  [2724] = 2696,
  [2725] = 2696,
  [2726] = 2693,
  [2727] = 2696,
  [2728] = 2728,
  [2729] = 2693,
  [2730] = 2702,
  [2731] = 2693,
  [2732] = 2732,
  [2733] = 2693,
  [2734] = 2696,
  [2735] = 317,
  [2736] = 262,
  [2737] = 2702,
  [2738] = 2692,
  [2739] = 2694,
  [2740] = 2692,
  [2741] = 2693,
  [2742] = 2692,
  [2743] = 2696,
  [2744] = 2744,
  [2745] = 2745,
  [2746] = 2746,
  [2747] = 2747,
  [2748] = 2747,
  [2749] = 2749,
  [2750] = 313,
  [2751] = 2749,
  [2752] = 2752,
  [2753] = 304,
  [2754] = 241,
  [2755] = 234,
  [2756] = 316,
  [2757] = 1752,
  [2758] = 2749,
  [2759] = 2744,
  [2760] = 2760,
  [2761] = 2761,
  [2762] = 260,
  [2763] = 255,
  [2764] = 305,
  [2765] = 2760,
  [2766] = 2752,
  [2767] = 2760,
  [2768] = 2747,
  [2769] = 235,
  [2770] = 2749,
  [2771] = 323,
  [2772] = 2747,
  [2773] = 2747,
  [2774] = 2749,
  [2775] = 2747,
  [2776] = 2747,
  [2777] = 324,
  [2778] = 2749,
  [2779] = 2749,
  [2780] = 2747,
  [2781] = 2781,
  [2782] = 2747,
  [2783] = 2749,
  [2784] = 2781,
  [2785] = 2747,
  [2786] = 2749,
  [2787] = 2787,
  [2788] = 2749,
  [2789] = 2698,
  [2790] = 325,
  [2791] = 282,
  [2792] = 283,
  [2793] = 2747,
  [2794] = 2749,
  [2795] = 318,
  [2796] = 2747,
  [2797] = 2749,
  [2798] = 307,
  [2799] = 319,
  [2800] = 293,
  [2801] = 2752,
  [2802] = 321,
  [2803] = 322,
  [2804] = 2760,
  [2805] = 234,
  [2806] = 2747,
  [2807] = 294,
  [2808] = 298,
  [2809] = 295,
  [2810] = 2781,
  [2811] = 342,
  [2812] = 2812,
  [2813] = 2699,
  [2814] = 302,
  [2815] = 2781,
  [2816] = 2787,
  [2817] = 2752,
  [2818] = 2747,
  [2819] = 2749,
  [2820] = 2787,
  [2821] = 252,
  [2822] = 253,
  [2823] = 233,
  [2824] = 2747,
  [2825] = 2787,
  [2826] = 2749,
  [2827] = 2827,
  [2828] = 235,
  [2829] = 2711,
  [2830] = 256,
  [2831] = 326,
  [2832] = 254,
  [2833] = 2749,
  [2834] = 2747,
  [2835] = 2749,
  [2836] = 310,
  [2837] = 2837,
  [2838] = 311,
  [2839] = 314,
  [2840] = 2749,
  [2841] = 2841,
  [2842] = 1747,
  [2843] = 299,
  [2844] = 2747,
  [2845] = 2845,
  [2846] = 1747,
  [2847] = 2847,
  [2848] = 2848,
  [2849] = 2849,
  [2850] = 2845,
  [2851] = 2851,
  [2852] = 1752,
  [2853] = 2845,
  [2854] = 2845,
  [2855] = 2845,
  [2856] = 2845,
  [2857] = 2845,
  [2858] = 2845,
  [2859] = 2845,
  [2860] = 2845,
  [2861] = 2845,
  [2862] = 2845,
  [2863] = 2845,
  [2864] = 2845,
  [2865] = 2845,
  [2866] = 2845,
  [2867] = 2867,
  [2868] = 2868,
  [2869] = 1747,
  [2870] = 2867,
  [2871] = 2867,
  [2872] = 2867,
  [2873] = 2873,
  [2874] = 245,
  [2875] = 1752,
  [2876] = 2876,
  [2877] = 2867,
  [2878] = 2867,
  [2879] = 2879,
  [2880] = 2880,
  [2881] = 2867,
  [2882] = 2882,
  [2883] = 2883,
  [2884] = 2884,
  [2885] = 2885,
  [2886] = 2867,
  [2887] = 1752,
  [2888] = 2867,
  [2889] = 2889,
  [2890] = 2868,
  [2891] = 2891,
  [2892] = 1711,
  [2893] = 2893,
  [2894] = 2867,
  [2895] = 1747,
  [2896] = 2896,
  [2897] = 2867,
  [2898] = 2898,
  [2899] = 2899,
  [2900] = 2867,
  [2901] = 2901,
  [2902] = 2902,
  [2903] = 2903,
  [2904] = 2868,
  [2905] = 2868,
  [2906] = 2893,
  [2907] = 2893,
  [2908] = 2893,
  [2909] = 2909,
  [2910] = 1722,
  [2911] = 2911,
  [2912] = 2912,
  [2913] = 2913,
  [2914] = 2914,
  [2915] = 2915,
  [2916] = 1821,
  [2917] = 2917,
  [2918] = 2912,
  [2919] = 2911,
  [2920] = 2912,
  [2921] = 2921,
  [2922] = 2911,
  [2923] = 2911,
  [2924] = 2924,
  [2925] = 2925,
  [2926] = 2912,
  [2927] = 2927,
  [2928] = 2928,
  [2929] = 2929,
  [2930] = 2912,
  [2931] = 2911,
  [2932] = 2911,
  [2933] = 2933,
  [2934] = 2934,
  [2935] = 2928,
  [2936] = 2936,
  [2937] = 2937,
  [2938] = 2938,
  [2939] = 2939,
  [2940] = 2937,
  [2941] = 2937,
  [2942] = 2911,
  [2943] = 2911,
  [2944] = 2939,
  [2945] = 2945,
  [2946] = 2912,
  [2947] = 2947,
  [2948] = 2948,
  [2949] = 2949,
  [2950] = 2950,
  [2951] = 2951,
  [2952] = 2952,
  [2953] = 2953,
  [2954] = 2954,
  [2955] = 2955,
  [2956] = 1747,
  [2957] = 2957,
  [2958] = 2958,
  [2959] = 2911,
  [2960] = 2912,
  [2961] = 2913,
  [2962] = 2962,
  [2963] = 2963,
  [2964] = 2939,
  [2965] = 2965,
  [2966] = 2948,
  [2967] = 2949,
  [2968] = 2968,
  [2969] = 2969,
  [2970] = 1752,
  [2971] = 2971,
  [2972] = 2950,
  [2973] = 2973,
  [2974] = 2974,
  [2975] = 2912,
  [2976] = 2976,
  [2977] = 2977,
  [2978] = 2913,
  [2979] = 2951,
  [2980] = 2911,
  [2981] = 2912,
  [2982] = 2911,
  [2983] = 2948,
  [2984] = 2911,
  [2985] = 2985,
  [2986] = 2986,
  [2987] = 2987,
  [2988] = 2988,
  [2989] = 2911,
  [2990] = 2911,
  [2991] = 2991,
  [2992] = 2992,
  [2993] = 2993,
  [2994] = 2949,
  [2995] = 2995,
  [2996] = 2996,
  [2997] = 2997,
  [2998] = 2998,
  [2999] = 2999,
  [3000] = 2950,
  [3001] = 2951,
  [3002] = 3002,
  [3003] = 2912,
  [3004] = 3004,
  [3005] = 3005,
  [3006] = 3006,
  [3007] = 3007,
  [3008] = 3008,
  [3009] = 2911,
  [3010] = 2928,
  [3011] = 2912,
  [3012] = 1718,
  [3013] = 3013,
  [3014] = 3014,
  [3015] = 3015,
  [3016] = 3016,
  [3017] = 2911,
  [3018] = 2937,
  [3019] = 3019,
  [3020] = 2939,
  [3021] = 3021,
  [3022] = 2913,
  [3023] = 3023,
  [3024] = 3024,
  [3025] = 2911,
  [3026] = 2928,
  [3027] = 2912,
  [3028] = 3028,
  [3029] = 3029,
  [3030] = 2948,
  [3031] = 2949,
  [3032] = 2950,
  [3033] = 3033,
  [3034] = 2951,
  [3035] = 2987,
  [3036] = 2987,
  [3037] = 2987,
  [3038] = 2911,
  [3039] = 3039,
  [3040] = 3040,
  [3041] = 3041,
  [3042] = 3042,
  [3043] = 3043,
  [3044] = 3042,
  [3045] = 3045,
  [3046] = 3046,
  [3047] = 3042,
  [3048] = 3046,
  [3049] = 3049,
  [3050] = 3050,
  [3051] = 3042,
  [3052] = 3046,
  [3053] = 3042,
  [3054] = 3046,
  [3055] = 2901,
  [3056] = 3056,
  [3057] = 3057,
  [3058] = 3058,
  [3059] = 3059,
  [3060] = 3060,
  [3061] = 3061,
  [3062] = 3062,
  [3063] = 3063,
  [3064] = 2901,
  [3065] = 2576,
  [3066] = 3042,
  [3067] = 3042,
  [3068] = 3046,
  [3069] = 3046,
  [3070] = 3042,
  [3071] = 3071,
  [3072] = 3042,
  [3073] = 3045,
  [3074] = 1822,
  [3075] = 3045,
  [3076] = 3076,
  [3077] = 3077,
  [3078] = 3042,
  [3079] = 3046,
  [3080] = 3042,
  [3081] = 3046,
  [3082] = 3046,
  [3083] = 3046,
  [3084] = 3046,
  [3085] = 3045,
  [3086] = 3042,
  [3087] = 3087,
  [3088] = 3046,
  [3089] = 3089,
  [3090] = 3042,
  [3091] = 3091,
  [3092] = 3092,
  [3093] = 3061,
  [3094] = 3094,
  [3095] = 3095,
  [3096] = 3096,
  [3097] = 3097,
  [3098] = 2901,
  [3099] = 3099,
  [3100] = 3046,
  [3101] = 3042,
  [3102] = 3042,
  [3103] = 3061,
  [3104] = 3104,
  [3105] = 3105,
  [3106] = 3106,
  [3107] = 3107,
  [3108] = 3046,
  [3109] = 3042,
  [3110] = 3110,
  [3111] = 3042,
  [3112] = 3042,
  [3113] = 3113,
  [3114] = 3114,
  [3115] = 3046,
  [3116] = 3046,
  [3117] = 3117,
  [3118] = 3118,
  [3119] = 3046,
  [3120] = 3045,
  [3121] = 3121,
  [3122] = 3046,
  [3123] = 445,
  [3124] = 3061,
  [3125] = 3125,
  [3126] = 3126,
  [3127] = 3127,
  [3128] = 3128,
  [3129] = 3125,
  [3130] = 3125,
  [3131] = 3131,
  [3132] = 3132,
  [3133] = 3133,
  [3134] = 3134,
  [3135] = 3135,
  [3136] = 3128,
  [3137] = 3137,
  [3138] = 3138,
  [3139] = 3139,
  [3140] = 3140,
  [3141] = 3141,
  [3142] = 3142,
  [3143] = 3143,
  [3144] = 3144,
  [3145] = 3145,
  [3146] = 3146,
  [3147] = 3147,
  [3148] = 3148,
  [3149] = 3131,
  [3150] = 3133,
  [3151] = 3151,
  [3152] = 3152,
  [3153] = 3135,
  [3154] = 3154,
  [3155] = 3155,
  [3156] = 3156,
  [3157] = 3138,
  [3158] = 3158,
  [3159] = 3128,
  [3160] = 3126,
  [3161] = 3127,
  [3162] = 3125,
  [3163] = 3138,
  [3164] = 3140,
  [3165] = 3133,
  [3166] = 3138,
  [3167] = 3139,
  [3168] = 3139,
  [3169] = 3147,
  [3170] = 3147,
  [3171] = 3148,
  [3172] = 3140,
  [3173] = 2958,
  [3174] = 3174,
  [3175] = 3152,
  [3176] = 3142,
  [3177] = 3177,
  [3178] = 3148,
  [3179] = 3156,
  [3180] = 3145,
  [3181] = 3135,
  [3182] = 3128,
  [3183] = 3142,
  [3184] = 3184,
  [3185] = 3151,
  [3186] = 3140,
  [3187] = 3147,
  [3188] = 3142,
  [3189] = 3148,
  [3190] = 3147,
  [3191] = 3145,
  [3192] = 3147,
  [3193] = 3146,
  [3194] = 3194,
  [3195] = 3131,
  [3196] = 3196,
  [3197] = 3151,
  [3198] = 3152,
  [3199] = 3199,
  [3200] = 3154,
  [3201] = 3155,
  [3202] = 3202,
  [3203] = 3131,
  [3204] = 3158,
  [3205] = 3152,
  [3206] = 3126,
  [3207] = 3127,
  [3208] = 3125,
  [3209] = 3145,
  [3210] = 3210,
  [3211] = 3133,
  [3212] = 3138,
  [3213] = 3139,
  [3214] = 3214,
  [3215] = 3151,
  [3216] = 3147,
  [3217] = 3148,
  [3218] = 3218,
  [3219] = 3219,
  [3220] = 3152,
  [3221] = 3128,
  [3222] = 3154,
  [3223] = 3155,
  [3224] = 3135,
  [3225] = 3225,
  [3226] = 3226,
  [3227] = 3135,
  [3228] = 3128,
  [3229] = 3128,
  [3230] = 3230,
  [3231] = 3142,
  [3232] = 3232,
  [3233] = 3233,
  [3234] = 3145,
  [3235] = 3158,
  [3236] = 3236,
  [3237] = 3151,
  [3238] = 3152,
  [3239] = 3125,
  [3240] = 3126,
  [3241] = 3134,
  [3242] = 3127,
  [3243] = 3135,
  [3244] = 3125,
  [3245] = 3245,
  [3246] = 3142,
  [3247] = 3140,
  [3248] = 3145,
  [3249] = 3249,
  [3250] = 3155,
  [3251] = 3151,
  [3252] = 3152,
  [3253] = 3125,
  [3254] = 3133,
  [3255] = 3138,
  [3256] = 3139,
  [3257] = 3135,
  [3258] = 3258,
  [3259] = 3259,
  [3260] = 3147,
  [3261] = 3135,
  [3262] = 3148,
  [3263] = 3131,
  [3264] = 3264,
  [3265] = 3135,
  [3266] = 3146,
  [3267] = 3142,
  [3268] = 3133,
  [3269] = 3135,
  [3270] = 3134,
  [3271] = 3019,
  [3272] = 3148,
  [3273] = 3135,
  [3274] = 3151,
  [3275] = 3145,
  [3276] = 3152,
  [3277] = 3135,
  [3278] = 3225,
  [3279] = 3245,
  [3280] = 3280,
  [3281] = 3135,
  [3282] = 3225,
  [3283] = 3141,
  [3284] = 3284,
  [3285] = 3135,
  [3286] = 3146,
  [3287] = 3154,
  [3288] = 3288,
  [3289] = 3135,
  [3290] = 3154,
  [3291] = 3155,
  [3292] = 3135,
  [3293] = 3135,
  [3294] = 3148,
  [3295] = 3131,
  [3296] = 3128,
  [3297] = 3135,
  [3298] = 3135,
  [3299] = 3143,
  [3300] = 3155,
  [3301] = 3140,
  [3302] = 3151,
  [3303] = 3152,
  [3304] = 3142,
  [3305] = 3128,
  [3306] = 3154,
  [3307] = 3145,
  [3308] = 3158,
  [3309] = 3155,
  [3310] = 3310,
  [3311] = 3126,
  [3312] = 3312,
  [3313] = 3133,
  [3314] = 3314,
  [3315] = 3131,
  [3316] = 3316,
  [3317] = 3127,
  [3318] = 3318,
  [3319] = 3125,
  [3320] = 3320,
  [3321] = 3321,
  [3322] = 3151,
  [3323] = 3323,
  [3324] = 3324,
  [3325] = 3158,
  [3326] = 3326,
  [3327] = 3327,
  [3328] = 3328,
  [3329] = 3329,
  [3330] = 3152,
  [3331] = 3210,
  [3332] = 3332,
  [3333] = 3333,
  [3334] = 3131,
  [3335] = 3196,
  [3336] = 3141,
  [3337] = 3126,
  [3338] = 3338,
  [3339] = 3339,
  [3340] = 3340,
  [3341] = 3154,
  [3342] = 3155,
  [3343] = 3127,
  [3344] = 3125,
  [3345] = 3310,
  [3346] = 3346,
  [3347] = 3312,
  [3348] = 3321,
  [3349] = 3314,
  [3350] = 3350,
  [3351] = 3316,
  [3352] = 3158,
  [3353] = 3318,
  [3354] = 3133,
  [3355] = 3126,
  [3356] = 3321,
  [3357] = 3127,
  [3358] = 3323,
  [3359] = 3324,
  [3360] = 3133,
  [3361] = 3326,
  [3362] = 3328,
  [3363] = 3138,
  [3364] = 3364,
  [3365] = 3210,
  [3366] = 3139,
  [3367] = 3226,
  [3368] = 3139,
  [3369] = 3196,
  [3370] = 2965,
  [3371] = 3139,
  [3372] = 3133,
  [3373] = 3339,
  [3374] = 3340,
  [3375] = 3138,
  [3376] = 3128,
  [3377] = 3139,
  [3378] = 3138,
  [3379] = 3310,
  [3380] = 3146,
  [3381] = 3312,
  [3382] = 3147,
  [3383] = 3314,
  [3384] = 3147,
  [3385] = 3316,
  [3386] = 3148,
  [3387] = 3318,
  [3388] = 2991,
  [3389] = 3143,
  [3390] = 3321,
  [3391] = 3245,
  [3392] = 3323,
  [3393] = 3324,
  [3394] = 3148,
  [3395] = 3326,
  [3396] = 3328,
  [3397] = 3310,
  [3398] = 3154,
  [3399] = 3210,
  [3400] = 3139,
  [3401] = 3140,
  [3402] = 3328,
  [3403] = 3196,
  [3404] = 3126,
  [3405] = 3135,
  [3406] = 3151,
  [3407] = 3339,
  [3408] = 3340,
  [3409] = 3156,
  [3410] = 3147,
  [3411] = 3148,
  [3412] = 3146,
  [3413] = 3413,
  [3414] = 3128,
  [3415] = 2991,
  [3416] = 3328,
  [3417] = 3417,
  [3418] = 3146,
  [3419] = 3140,
  [3420] = 2965,
  [3421] = 2958,
  [3422] = 3135,
  [3423] = 3340,
  [3424] = 3146,
  [3425] = 3128,
  [3426] = 3314,
  [3427] = 3142,
  [3428] = 3013,
  [3429] = 3135,
  [3430] = 3328,
  [3431] = 3236,
  [3432] = 3128,
  [3433] = 3140,
  [3434] = 3140,
  [3435] = 3435,
  [3436] = 3156,
  [3437] = 3323,
  [3438] = 3340,
  [3439] = 3350,
  [3440] = 3142,
  [3441] = 3127,
  [3442] = 3140,
  [3443] = 3145,
  [3444] = 3145,
  [3445] = 3328,
  [3446] = 3142,
  [3447] = 3142,
  [3448] = 3138,
  [3449] = 3142,
  [3450] = 3145,
  [3451] = 3324,
  [3452] = 3158,
  [3453] = 3340,
  [3454] = 3350,
  [3455] = 3131,
  [3456] = 3139,
  [3457] = 3131,
  [3458] = 3131,
  [3459] = 3151,
  [3460] = 3148,
  [3461] = 3461,
  [3462] = 3145,
  [3463] = 3463,
  [3464] = 3151,
  [3465] = 3152,
  [3466] = 3152,
  [3467] = 3126,
  [3468] = 3340,
  [3469] = 3154,
  [3470] = 3155,
  [3471] = 3471,
  [3472] = 3154,
  [3473] = 3146,
  [3474] = 3155,
  [3475] = 3328,
  [3476] = 3476,
  [3477] = 3158,
  [3478] = 3326,
  [3479] = 3126,
  [3480] = 3145,
  [3481] = 3127,
  [3482] = 3158,
  [3483] = 3340,
  [3484] = 3125,
  [3485] = 3417,
  [3486] = 3126,
  [3487] = 3127,
  [3488] = 3125,
  [3489] = 3489,
  [3490] = 3328,
  [3491] = 3131,
  [3492] = 3492,
  [3493] = 3493,
  [3494] = 3133,
  [3495] = 3138,
  [3496] = 3139,
  [3497] = 3135,
  [3498] = 3340,
  [3499] = 3499,
  [3500] = 3019,
  [3501] = 3158,
  [3502] = 3133,
  [3503] = 3140,
  [3504] = 3138,
  [3505] = 3328,
  [3506] = 3139,
  [3507] = 3013,
  [3508] = 3226,
  [3509] = 3145,
  [3510] = 3318,
  [3511] = 3147,
  [3512] = 3236,
  [3513] = 3340,
  [3514] = 3148,
  [3515] = 3312,
  [3516] = 3516,
  [3517] = 3151,
  [3518] = 3147,
  [3519] = 3148,
  [3520] = 3328,
  [3521] = 3521,
  [3522] = 3522,
  [3523] = 3146,
  [3524] = 3126,
  [3525] = 3350,
  [3526] = 3152,
  [3527] = 2958,
  [3528] = 3340,
  [3529] = 3127,
  [3530] = 2965,
  [3531] = 3146,
  [3532] = 3127,
  [3533] = 3154,
  [3534] = 3534,
  [3535] = 3328,
  [3536] = 3155,
  [3537] = 3537,
  [3538] = 3236,
  [3539] = 3146,
  [3540] = 3540,
  [3541] = 3541,
  [3542] = 3340,
  [3543] = 3135,
  [3544] = 3135,
  [3545] = 3158,
  [3546] = 3546,
  [3547] = 3328,
  [3548] = 3128,
  [3549] = 3146,
  [3550] = 3131,
  [3551] = 3151,
  [3552] = 3140,
  [3553] = 3135,
  [3554] = 3340,
  [3555] = 3339,
  [3556] = 3142,
  [3557] = 3126,
  [3558] = 3135,
  [3559] = 3328,
  [3560] = 3145,
  [3561] = 3128,
  [3562] = 3127,
  [3563] = 3316,
  [3564] = 3564,
  [3565] = 3131,
  [3566] = 3340,
  [3567] = 3125,
  [3568] = 3152,
  [3569] = 3151,
  [3570] = 3152,
  [3571] = 3328,
  [3572] = 3140,
  [3573] = 3327,
  [3574] = 3154,
  [3575] = 3155,
  [3576] = 3151,
  [3577] = 3476,
  [3578] = 3340,
  [3579] = 3158,
  [3580] = 3152,
  [3581] = 3581,
  [3582] = 3126,
  [3583] = 3127,
  [3584] = 3125,
  [3585] = 3225,
  [3586] = 3245,
  [3587] = 3133,
  [3588] = 3138,
  [3589] = 3139,
  [3590] = 3135,
  [3591] = 3128,
  [3592] = 3147,
  [3593] = 3593,
  [3594] = 3230,
  [3595] = 3288,
  [3596] = 3148,
  [3597] = 3142,
  [3598] = 3534,
  [3599] = 3492,
  [3600] = 3125,
  [3601] = 3132,
  [3602] = 3154,
  [3603] = 3145,
  [3604] = 3593,
  [3605] = 3133,
  [3606] = 3593,
  [3607] = 3230,
  [3608] = 3138,
  [3609] = 3139,
  [3610] = 3534,
  [3611] = 3492,
  [3612] = 3154,
  [3613] = 3132,
  [3614] = 3131,
  [3615] = 3155,
  [3616] = 3616,
  [3617] = 3134,
  [3618] = 3593,
  [3619] = 3230,
  [3620] = 3155,
  [3621] = 3151,
  [3622] = 3534,
  [3623] = 3492,
  [3624] = 3624,
  [3625] = 3132,
  [3626] = 3152,
  [3627] = 3627,
  [3628] = 3534,
  [3629] = 3492,
  [3630] = 3146,
  [3631] = 3534,
  [3632] = 3492,
  [3633] = 3154,
  [3634] = 3534,
  [3635] = 3492,
  [3636] = 3143,
  [3637] = 3534,
  [3638] = 3492,
  [3639] = 3155,
  [3640] = 3534,
  [3641] = 3492,
  [3642] = 3135,
  [3643] = 3534,
  [3644] = 3492,
  [3645] = 3147,
  [3646] = 3534,
  [3647] = 3492,
  [3648] = 3128,
  [3649] = 3534,
  [3650] = 3492,
  [3651] = 3534,
  [3652] = 3492,
  [3653] = 3534,
  [3654] = 3492,
  [3655] = 3534,
  [3656] = 3492,
  [3657] = 3534,
  [3658] = 3492,
  [3659] = 3534,
  [3660] = 3534,
  [3661] = 3541,
  [3662] = 3493,
  [3663] = 3219,
  [3664] = 3489,
  [3665] = 3148,
  [3666] = 3158,
  [3667] = 3541,
  [3668] = 3668,
  [3669] = 3219,
  [3670] = 3489,
  [3671] = 3140,
  [3672] = 3125,
  [3673] = 3541,
  [3674] = 3142,
  [3675] = 3219,
  [3676] = 3489,
  [3677] = 3126,
  [3678] = 3142,
  [3679] = 3679,
  [3680] = 3489,
  [3681] = 3340,
  [3682] = 3489,
  [3683] = 3683,
  [3684] = 3489,
  [3685] = 3127,
  [3686] = 3489,
  [3687] = 3125,
  [3688] = 3489,
  [3689] = 3145,
  [3690] = 3489,
  [3691] = 3226,
  [3692] = 3489,
  [3693] = 2991,
  [3694] = 3489,
  [3695] = 3489,
  [3696] = 3489,
  [3697] = 3489,
  [3698] = 3489,
  [3699] = 3133,
  [3700] = 3140,
  [3701] = 3131,
  [3702] = 3138,
  [3703] = 3013,
  [3704] = 3139,
  [3705] = 3158,
  [3706] = 3151,
  [3707] = 3707,
  [3708] = 3152,
  [3709] = 3142,
  [3710] = 3154,
  [3711] = 3155,
  [3712] = 3141,
  [3713] = 3158,
  [3714] = 3147,
  [3715] = 3126,
  [3716] = 3127,
  [3717] = 3125,
  [3718] = 3145,
  [3719] = 3158,
  [3720] = 3133,
  [3721] = 3138,
  [3722] = 3328,
  [3723] = 3723,
  [3724] = 3724,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(24);
      ADVANCE_MAP(
        '#', 67,
        '%', 60,
        '&', 78,
        '(', 72,
        ')', 73,
        '*', 54,
        '+', 49,
        ',', 30,
        '-', 51,
        '.', 74,
        '/', 57,
        '0', 91,
        ':', 27,
        ';', 25,
        '<', 33,
        '=', 29,
        '>', 35,
        '?', 82,
        '@', 189,
        '[', 70,
        ']', 71,
        '^', 65,
        '{', 89,
        '|', 79,
        '}', 183,
        '~', 12,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(19);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(92);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(181);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 1:
      ADVANCE_MAP(
        '%', 7,
        '&', 78,
        '(', 72,
        ')', 73,
        '*', 8,
        '+', 9,
        ',', 30,
        '-', 10,
        '.', 77,
        '/', 6,
        ':', 26,
        ';', 25,
        '<', 32,
        '=', 28,
        '>', 34,
        '?', 82,
        '[', 70,
        ']', 71,
        '^', 11,
        '{', 68,
        '|', 79,
        '}', 69,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(1);
      END_STATE();
    case 2:
      ADVANCE_MAP(
        '%', 7,
        '&', 78,
        '(', 72,
        ')', 73,
        '*', 8,
        '+', 9,
        ',', 30,
        '-', 10,
        '.', 77,
        '/', 6,
        ':', 26,
        ';', 25,
        '<', 32,
        '=', 28,
        '>', 34,
        '?', 82,
        '[', 70,
        ']', 71,
        '^', 11,
        '{', 68,
        '|', 79,
        '}', 69,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(152);
      END_STATE();
    case 3:
      if (lookahead == '.') ADVANCE(80);
      END_STATE();
    case 4:
      if (lookahead == '.') ADVANCE(80);
      if (lookahead == '=') ADVANCE(43);
      END_STATE();
    case 5:
      if (lookahead == '.') ADVANCE(3);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(85);
      END_STATE();
    case 6:
      if (lookahead == '/') ADVANCE(13);
      if (lookahead == '=') ADVANCE(40);
      END_STATE();
    case 7:
      if (lookahead == '=') ADVANCE(41);
      END_STATE();
    case 8:
      if (lookahead == '=') ADVANCE(38);
      END_STATE();
    case 9:
      if (lookahead == '=') ADVANCE(36);
      END_STATE();
    case 10:
      if (lookahead == '=') ADVANCE(37);
      END_STATE();
    case 11:
      if (lookahead == '=') ADVANCE(42);
      END_STATE();
    case 12:
      if (lookahead == '=') ADVANCE(45);
      END_STATE();
    case 13:
      if (lookahead == '=') ADVANCE(39);
      END_STATE();
    case 14:
      if (lookahead == '_') ADVANCE(15);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(15);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(87);
      END_STATE();
    case 15:
      if (lookahead == '_') ADVANCE(15);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(87);
      END_STATE();
    case 16:
      if (lookahead == '{') ADVANCE(89);
      if (lookahead == '}') ADVANCE(183);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(31);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(190);
      END_STATE();
    case 17:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(187);
      END_STATE();
    case 18:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(17);
      END_STATE();
    case 19:
      if (eof) ADVANCE(24);
      ADVANCE_MAP(
        '#', 67,
        '%', 60,
        '&', 78,
        '(', 72,
        ')', 73,
        '*', 54,
        '+', 49,
        ',', 30,
        '-', 51,
        '.', 74,
        '/', 57,
        '0', 83,
        ':', 27,
        ';', 25,
        '<', 33,
        '=', 29,
        '>', 35,
        '?', 82,
        '@', 189,
        '[', 70,
        ']', 71,
        '^', 65,
        '{', 68,
        '|', 79,
        '}', 69,
        '~', 12,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(19);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(84);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 20:
      if (eof) ADVANCE(24);
      ADVANCE_MAP(
        '#', 67,
        '&', 78,
        '(', 72,
        ')', 73,
        ',', 30,
        '-', 52,
        '.', 5,
        '0', 83,
        ';', 25,
        '<', 32,
        '=', 28,
        '>', 34,
        '?', 82,
        '[', 70,
        ']', 71,
        '{', 68,
        '|', 79,
        '}', 69,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(20);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(84);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 21:
      if (eof) ADVANCE(24);
      ADVANCE_MAP(
        '%', 59,
        '&', 78,
        '(', 72,
        ')', 73,
        '*', 53,
        '+', 48,
        ',', 30,
        '-', 52,
        '.', 75,
        '/', 58,
        ':', 27,
        ';', 25,
        '<', 33,
        '=', 29,
        '>', 35,
        '?', 82,
        '@', 189,
        '[', 70,
        ']', 71,
        '^', 64,
        '{', 68,
        '|', 79,
        '}', 69,
        '~', 12,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(22);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(186);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 22:
      if (eof) ADVANCE(24);
      ADVANCE_MAP(
        '%', 59,
        '&', 78,
        '(', 72,
        ')', 73,
        '*', 53,
        '+', 48,
        ',', 30,
        '-', 52,
        '.', 75,
        '/', 58,
        ':', 27,
        ';', 25,
        '<', 33,
        '=', 29,
        '>', 35,
        '?', 82,
        '@', 189,
        '[', 70,
        ']', 71,
        '^', 64,
        '{', 68,
        '|', 79,
        '}', 69,
        '~', 12,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(22);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 23:
      if (eof) ADVANCE(24);
      ADVANCE_MAP(
        '%', 59,
        '&', 78,
        '(', 72,
        ')', 73,
        '*', 53,
        '+', 48,
        ',', 30,
        '-', 50,
        '.', 76,
        '/', 58,
        ':', 27,
        ';', 25,
        '<', 33,
        '=', 29,
        '>', 35,
        '?', 82,
        '@', 189,
        ']', 71,
        '^', 64,
        '{', 68,
        '|', 79,
        '}', 69,
        '~', 12,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(23);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(66);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(44);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(aux_sym_type_stmt_token1);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(46);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(47);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH_EQ);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_EQ);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_TILDE_EQ);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '=') ADVANCE(36);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(37);
      if (lookahead == '>') ADVANCE(81);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '>') ADVANCE(81);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '=') ADVANCE(38);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      if (lookahead == '=') ADVANCE(39);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == '=') ADVANCE(40);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '/') ADVANCE(55);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(41);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      if (lookahead == '.') ADVANCE(80);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      if (lookahead == '.') ADVANCE(80);
      if (lookahead == '=') ADVANCE(43);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(42);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(63);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(85);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(61);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(62);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(4);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(sym_number);
      ADVANCE_MAP(
        '.', 85,
        '_', 83,
        'B', 86,
        'b', 86,
        'E', 14,
        'e', 14,
        'X', 88,
        'x', 88,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(84);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(85);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(14);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(84);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(14);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(85);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '0' ||
          lookahead == '1' ||
          lookahead == '_') ADVANCE(86);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(sym_number);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(87);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(sym_number);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(88);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_LBRACE2);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      ADVANCE_MAP(
        '.', 85,
        '_', 83,
        'B', 121,
        'b', 121,
        'E', 122,
        'e', 122,
        'X', 88,
        'x', 88,
        'A', 180,
        'C', 180,
        'D', 180,
        'F', 180,
        'a', 180,
        'c', 180,
        'd', 180,
        'f', 180,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(106);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '.') ADVANCE(85);
      if (lookahead == '_') ADVANCE(84);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(122);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(180);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(106);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '.') ADVANCE(85);
      if (lookahead == '_') ADVANCE(84);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(123);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(90);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(107);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '.') ADVANCE(85);
      if (lookahead == '_') ADVANCE(84);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(124);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(153);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(93);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '.') ADVANCE(85);
      if (lookahead == '_') ADVANCE(84);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(125);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(158);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(96);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '.') ADVANCE(85);
      if (lookahead == '_') ADVANCE(84);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(126);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(156);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(94);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '.') ADVANCE(85);
      if (lookahead == '_') ADVANCE(84);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(127);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(160);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(95);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '.') ADVANCE(85);
      if (lookahead == '_') ADVANCE(84);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(128);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(162);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(97);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '.') ADVANCE(85);
      if (lookahead == '_') ADVANCE(84);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(129);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(164);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(98);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '.') ADVANCE(85);
      if (lookahead == '_') ADVANCE(84);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(130);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(166);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(99);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '.') ADVANCE(85);
      if (lookahead == '_') ADVANCE(84);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(131);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(168);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(100);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '.') ADVANCE(85);
      if (lookahead == '_') ADVANCE(84);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(132);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(170);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(101);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '.') ADVANCE(85);
      if (lookahead == '_') ADVANCE(84);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(133);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(172);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(102);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '.') ADVANCE(85);
      if (lookahead == '_') ADVANCE(84);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(134);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(174);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(103);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '.') ADVANCE(85);
      if (lookahead == '_') ADVANCE(84);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(135);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(176);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(104);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '.') ADVANCE(85);
      if (lookahead == '_') ADVANCE(84);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(136);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(178);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(105);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '.') ADVANCE(85);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(14);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(84);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '_') ADVANCE(86);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(150);
      if (('2' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(90);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '_') ADVANCE(86);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(108);
      if (('2' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(153);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '_') ADVANCE(86);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(109);
      if (('2' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(156);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '_') ADVANCE(86);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(110);
      if (('2' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(158);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '_') ADVANCE(86);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(111);
      if (('2' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(160);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '_') ADVANCE(86);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(112);
      if (('2' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(162);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '_') ADVANCE(86);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(113);
      if (('2' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(164);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '_') ADVANCE(86);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(114);
      if (('2' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(166);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '_') ADVANCE(86);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(115);
      if (('2' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(168);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '_') ADVANCE(86);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(116);
      if (('2' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(170);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '_') ADVANCE(86);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(117);
      if (('2' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(172);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '_') ADVANCE(86);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(118);
      if (('2' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(174);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '_') ADVANCE(86);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(119);
      if (('2' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(176);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '_') ADVANCE(86);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(120);
      if (('2' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(178);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '_') ADVANCE(15);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(15);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(149);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(178);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '_') ADVANCE(15);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(15);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(87);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '_') ADVANCE(15);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(15);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(151);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(90);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '_') ADVANCE(15);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(15);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(139);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(156);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '_') ADVANCE(15);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(15);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(137);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(153);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '_') ADVANCE(15);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(15);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(138);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(158);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '_') ADVANCE(15);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(15);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(140);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(160);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '_') ADVANCE(15);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(15);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(141);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(162);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '_') ADVANCE(15);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(15);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(142);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(164);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '_') ADVANCE(15);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(15);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(143);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(166);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '_') ADVANCE(15);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(15);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(144);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(168);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '_') ADVANCE(15);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(15);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(145);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(170);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '_') ADVANCE(15);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(15);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(146);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(172);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '_') ADVANCE(15);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(15);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(147);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(174);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '_') ADVANCE(15);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(15);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(148);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(176);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '_') ADVANCE(87);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(151);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(90);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '_') ADVANCE(87);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(139);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(156);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '_') ADVANCE(87);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(137);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(153);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '_') ADVANCE(87);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(138);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(158);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '_') ADVANCE(87);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(140);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(160);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '_') ADVANCE(87);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(141);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(162);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '_') ADVANCE(87);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(142);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(164);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '_') ADVANCE(87);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(143);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(166);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '_') ADVANCE(87);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(144);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(168);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '_') ADVANCE(87);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(145);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(170);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '_') ADVANCE(87);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(146);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(172);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '_') ADVANCE(87);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(147);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(174);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '_') ADVANCE(87);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(148);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(176);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (lookahead == '0' ||
          lookahead == '1' ||
          lookahead == '_') ADVANCE(86);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(87);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(180);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(90);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(182);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(154);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(153);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(155);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(156);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(157);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(158);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(159);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(160);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(161);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(162);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(163);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(164);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(165);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(166);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(167);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(168);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(169);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(170);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(171);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(172);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(173);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(174);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(175);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(176);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(177);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(178);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(179);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(aux_sym_unicode_escape_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_RBRACE2);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(aux_sym_dec_byte_escape_token1);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(aux_sym_dec_byte_escape_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(184);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(aux_sym_dec_byte_escape_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(185);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(aux_sym_hex_byte_escape_token1);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(sym_name);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == '[') ADVANCE(191);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(aux_sym_attribute_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(190);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_AT_LBRACK);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      ADVANCE_MAP(
        'a', 1,
        'b', 2,
        'c', 3,
        'd', 4,
        'e', 5,
        'f', 6,
        'i', 7,
        'l', 8,
        'n', 9,
        'o', 10,
        'r', 11,
        't', 12,
        'u', 13,
        'w', 14,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0);
      END_STATE();
    case 1:
      if (lookahead == 'n') ADVANCE(15);
      END_STATE();
    case 2:
      if (lookahead == 'r') ADVANCE(16);
      END_STATE();
    case 3:
      if (lookahead == 'o') ADVANCE(17);
      END_STATE();
    case 4:
      if (lookahead == 'o') ADVANCE(18);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(19);
      if (lookahead == 'n') ADVANCE(20);
      if (lookahead == 'x') ADVANCE(21);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(22);
      if (lookahead == 'o') ADVANCE(23);
      if (lookahead == 'u') ADVANCE(24);
      END_STATE();
    case 7:
      if (lookahead == 'f') ADVANCE(25);
      if (lookahead == 'n') ADVANCE(26);
      END_STATE();
    case 8:
      if (lookahead == 'o') ADVANCE(27);
      END_STATE();
    case 9:
      if (lookahead == 'i') ADVANCE(28);
      if (lookahead == 'o') ADVANCE(29);
      END_STATE();
    case 10:
      if (lookahead == 'r') ADVANCE(30);
      END_STATE();
    case 11:
      if (lookahead == 'e') ADVANCE(31);
      END_STATE();
    case 12:
      if (lookahead == 'h') ADVANCE(32);
      if (lookahead == 'r') ADVANCE(33);
      if (lookahead == 'y') ADVANCE(34);
      END_STATE();
    case 13:
      if (lookahead == 'n') ADVANCE(35);
      END_STATE();
    case 14:
      if (lookahead == 'h') ADVANCE(36);
      if (lookahead == 'r') ADVANCE(37);
      END_STATE();
    case 15:
      if (lookahead == 'd') ADVANCE(38);
      END_STATE();
    case 16:
      if (lookahead == 'e') ADVANCE(39);
      END_STATE();
    case 17:
      if (lookahead == 'n') ADVANCE(40);
      END_STATE();
    case 18:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 19:
      if (lookahead == 's') ADVANCE(41);
      END_STATE();
    case 20:
      if (lookahead == 'd') ADVANCE(42);
      END_STATE();
    case 21:
      if (lookahead == 'p') ADVANCE(43);
      END_STATE();
    case 22:
      if (lookahead == 'l') ADVANCE(44);
      END_STATE();
    case 23:
      if (lookahead == 'r') ADVANCE(45);
      END_STATE();
    case 24:
      if (lookahead == 'n') ADVANCE(46);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 27:
      if (lookahead == 'c') ADVANCE(47);
      END_STATE();
    case 28:
      if (lookahead == 'l') ADVANCE(48);
      END_STATE();
    case 29:
      if (lookahead == 't') ADVANCE(49);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_or);
      END_STATE();
    case 31:
      if (lookahead == 'a') ADVANCE(50);
      if (lookahead == 'p') ADVANCE(51);
      if (lookahead == 't') ADVANCE(52);
      END_STATE();
    case 32:
      if (lookahead == 'e') ADVANCE(53);
      END_STATE();
    case 33:
      if (lookahead == 'u') ADVANCE(54);
      END_STATE();
    case 34:
      if (lookahead == 'p') ADVANCE(55);
      END_STATE();
    case 35:
      if (lookahead == 't') ADVANCE(56);
      END_STATE();
    case 36:
      if (lookahead == 'i') ADVANCE(57);
      END_STATE();
    case 37:
      if (lookahead == 'i') ADVANCE(58);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 39:
      if (lookahead == 'a') ADVANCE(59);
      END_STATE();
    case 40:
      if (lookahead == 't') ADVANCE(60);
      END_STATE();
    case 41:
      if (lookahead == 'e') ADVANCE(61);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_end);
      END_STATE();
    case 43:
      if (lookahead == 'o') ADVANCE(62);
      END_STATE();
    case 44:
      if (lookahead == 's') ADVANCE(63);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 46:
      if (lookahead == 'c') ADVANCE(64);
      END_STATE();
    case 47:
      if (lookahead == 'a') ADVANCE(65);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_nil);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_not);
      END_STATE();
    case 50:
      if (lookahead == 'd') ADVANCE(66);
      END_STATE();
    case 51:
      if (lookahead == 'e') ADVANCE(67);
      END_STATE();
    case 52:
      if (lookahead == 'u') ADVANCE(68);
      END_STATE();
    case 53:
      if (lookahead == 'n') ADVANCE(69);
      END_STATE();
    case 54:
      if (lookahead == 'e') ADVANCE(70);
      END_STATE();
    case 55:
      if (lookahead == 'e') ADVANCE(71);
      END_STATE();
    case 56:
      if (lookahead == 'i') ADVANCE(72);
      END_STATE();
    case 57:
      if (lookahead == 'l') ADVANCE(73);
      END_STATE();
    case 58:
      if (lookahead == 't') ADVANCE(74);
      END_STATE();
    case 59:
      if (lookahead == 'k') ADVANCE(75);
      END_STATE();
    case 60:
      if (lookahead == 'i') ADVANCE(76);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_else);
      if (lookahead == 'i') ADVANCE(77);
      END_STATE();
    case 62:
      if (lookahead == 'r') ADVANCE(78);
      END_STATE();
    case 63:
      if (lookahead == 'e') ADVANCE(79);
      END_STATE();
    case 64:
      if (lookahead == 't') ADVANCE(80);
      END_STATE();
    case 65:
      if (lookahead == 'l') ADVANCE(81);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_read);
      END_STATE();
    case 67:
      if (lookahead == 'a') ADVANCE(82);
      END_STATE();
    case 68:
      if (lookahead == 'r') ADVANCE(83);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_then);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_type);
      if (lookahead == 'o') ADVANCE(84);
      END_STATE();
    case 72:
      if (lookahead == 'l') ADVANCE(85);
      END_STATE();
    case 73:
      if (lookahead == 'e') ADVANCE(86);
      END_STATE();
    case 74:
      if (lookahead == 'e') ADVANCE(87);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 76:
      if (lookahead == 'n') ADVANCE(88);
      END_STATE();
    case 77:
      if (lookahead == 'f') ADVANCE(89);
      END_STATE();
    case 78:
      if (lookahead == 't') ADVANCE(90);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 80:
      if (lookahead == 'i') ADVANCE(91);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_local);
      END_STATE();
    case 82:
      if (lookahead == 't') ADVANCE(92);
      END_STATE();
    case 83:
      if (lookahead == 'n') ADVANCE(93);
      END_STATE();
    case 84:
      if (lookahead == 'f') ADVANCE(94);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_until);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_write);
      END_STATE();
    case 88:
      if (lookahead == 'u') ADVANCE(95);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_elseif);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_export);
      END_STATE();
    case 91:
      if (lookahead == 'o') ADVANCE(96);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_repeat);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_typeof);
      END_STATE();
    case 95:
      if (lookahead == 'e') ADVANCE(97);
      END_STATE();
    case 96:
      if (lookahead == 'n') ADVANCE(98);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(sym_continue_stmt);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 21, .external_lex_state = 2},
  [2] = {.lex_state = 21, .external_lex_state = 3},
  [3] = {.lex_state = 21, .external_lex_state = 3},
  [4] = {.lex_state = 21, .external_lex_state = 3},
  [5] = {.lex_state = 21, .external_lex_state = 3},
  [6] = {.lex_state = 21, .external_lex_state = 3},
  [7] = {.lex_state = 21, .external_lex_state = 4},
  [8] = {.lex_state = 21, .external_lex_state = 4},
  [9] = {.lex_state = 21, .external_lex_state = 4},
  [10] = {.lex_state = 21, .external_lex_state = 4},
  [11] = {.lex_state = 21, .external_lex_state = 4},
  [12] = {.lex_state = 21, .external_lex_state = 4},
  [13] = {.lex_state = 21, .external_lex_state = 4},
  [14] = {.lex_state = 21, .external_lex_state = 4},
  [15] = {.lex_state = 21, .external_lex_state = 4},
  [16] = {.lex_state = 21, .external_lex_state = 4},
  [17] = {.lex_state = 21, .external_lex_state = 4},
  [18] = {.lex_state = 21, .external_lex_state = 4},
  [19] = {.lex_state = 21, .external_lex_state = 4},
  [20] = {.lex_state = 21, .external_lex_state = 4},
  [21] = {.lex_state = 21, .external_lex_state = 4},
  [22] = {.lex_state = 21, .external_lex_state = 4},
  [23] = {.lex_state = 21, .external_lex_state = 4},
  [24] = {.lex_state = 21, .external_lex_state = 4},
  [25] = {.lex_state = 21, .external_lex_state = 4},
  [26] = {.lex_state = 21, .external_lex_state = 4},
  [27] = {.lex_state = 21, .external_lex_state = 4},
  [28] = {.lex_state = 21, .external_lex_state = 4},
  [29] = {.lex_state = 21, .external_lex_state = 4},
  [30] = {.lex_state = 21, .external_lex_state = 4},
  [31] = {.lex_state = 21, .external_lex_state = 4},
  [32] = {.lex_state = 21, .external_lex_state = 4},
  [33] = {.lex_state = 21, .external_lex_state = 4},
  [34] = {.lex_state = 21, .external_lex_state = 4},
  [35] = {.lex_state = 21, .external_lex_state = 4},
  [36] = {.lex_state = 21, .external_lex_state = 4},
  [37] = {.lex_state = 21, .external_lex_state = 4},
  [38] = {.lex_state = 21, .external_lex_state = 4},
  [39] = {.lex_state = 21, .external_lex_state = 4},
  [40] = {.lex_state = 21, .external_lex_state = 4},
  [41] = {.lex_state = 21, .external_lex_state = 4},
  [42] = {.lex_state = 21, .external_lex_state = 4},
  [43] = {.lex_state = 21, .external_lex_state = 4},
  [44] = {.lex_state = 21, .external_lex_state = 4},
  [45] = {.lex_state = 21, .external_lex_state = 4},
  [46] = {.lex_state = 21, .external_lex_state = 4},
  [47] = {.lex_state = 21, .external_lex_state = 4},
  [48] = {.lex_state = 21, .external_lex_state = 4},
  [49] = {.lex_state = 21, .external_lex_state = 4},
  [50] = {.lex_state = 21, .external_lex_state = 4},
  [51] = {.lex_state = 21, .external_lex_state = 4},
  [52] = {.lex_state = 21, .external_lex_state = 4},
  [53] = {.lex_state = 21, .external_lex_state = 4},
  [54] = {.lex_state = 21, .external_lex_state = 4},
  [55] = {.lex_state = 21, .external_lex_state = 4},
  [56] = {.lex_state = 21, .external_lex_state = 4},
  [57] = {.lex_state = 21, .external_lex_state = 4},
  [58] = {.lex_state = 21, .external_lex_state = 4},
  [59] = {.lex_state = 21, .external_lex_state = 4},
  [60] = {.lex_state = 21, .external_lex_state = 4},
  [61] = {.lex_state = 21, .external_lex_state = 4},
  [62] = {.lex_state = 21, .external_lex_state = 4},
  [63] = {.lex_state = 21, .external_lex_state = 4},
  [64] = {.lex_state = 21, .external_lex_state = 4},
  [65] = {.lex_state = 21, .external_lex_state = 4},
  [66] = {.lex_state = 21, .external_lex_state = 4},
  [67] = {.lex_state = 21, .external_lex_state = 4},
  [68] = {.lex_state = 21, .external_lex_state = 4},
  [69] = {.lex_state = 21, .external_lex_state = 4},
  [70] = {.lex_state = 21, .external_lex_state = 4},
  [71] = {.lex_state = 21, .external_lex_state = 4},
  [72] = {.lex_state = 21, .external_lex_state = 5},
  [73] = {.lex_state = 21, .external_lex_state = 4},
  [74] = {.lex_state = 21, .external_lex_state = 4},
  [75] = {.lex_state = 21, .external_lex_state = 4},
  [76] = {.lex_state = 21, .external_lex_state = 4},
  [77] = {.lex_state = 21, .external_lex_state = 4},
  [78] = {.lex_state = 21, .external_lex_state = 4},
  [79] = {.lex_state = 21, .external_lex_state = 4},
  [80] = {.lex_state = 21, .external_lex_state = 4},
  [81] = {.lex_state = 21, .external_lex_state = 4},
  [82] = {.lex_state = 21, .external_lex_state = 4},
  [83] = {.lex_state = 21, .external_lex_state = 4},
  [84] = {.lex_state = 21, .external_lex_state = 4},
  [85] = {.lex_state = 21, .external_lex_state = 4},
  [86] = {.lex_state = 21, .external_lex_state = 4},
  [87] = {.lex_state = 21, .external_lex_state = 4},
  [88] = {.lex_state = 21, .external_lex_state = 4},
  [89] = {.lex_state = 21, .external_lex_state = 4},
  [90] = {.lex_state = 21, .external_lex_state = 4},
  [91] = {.lex_state = 21, .external_lex_state = 4},
  [92] = {.lex_state = 21, .external_lex_state = 4},
  [93] = {.lex_state = 21, .external_lex_state = 4},
  [94] = {.lex_state = 21, .external_lex_state = 4},
  [95] = {.lex_state = 21, .external_lex_state = 4},
  [96] = {.lex_state = 21, .external_lex_state = 4},
  [97] = {.lex_state = 21, .external_lex_state = 4},
  [98] = {.lex_state = 21, .external_lex_state = 4},
  [99] = {.lex_state = 21, .external_lex_state = 4},
  [100] = {.lex_state = 21, .external_lex_state = 4},
  [101] = {.lex_state = 21, .external_lex_state = 4},
  [102] = {.lex_state = 21, .external_lex_state = 4},
  [103] = {.lex_state = 21, .external_lex_state = 4},
  [104] = {.lex_state = 21, .external_lex_state = 4},
  [105] = {.lex_state = 21, .external_lex_state = 4},
  [106] = {.lex_state = 21, .external_lex_state = 4},
  [107] = {.lex_state = 21, .external_lex_state = 4},
  [108] = {.lex_state = 21, .external_lex_state = 4},
  [109] = {.lex_state = 21, .external_lex_state = 4},
  [110] = {.lex_state = 21, .external_lex_state = 4},
  [111] = {.lex_state = 21, .external_lex_state = 4},
  [112] = {.lex_state = 21, .external_lex_state = 4},
  [113] = {.lex_state = 21, .external_lex_state = 4},
  [114] = {.lex_state = 21, .external_lex_state = 4},
  [115] = {.lex_state = 21, .external_lex_state = 4},
  [116] = {.lex_state = 21, .external_lex_state = 4},
  [117] = {.lex_state = 21, .external_lex_state = 4},
  [118] = {.lex_state = 21, .external_lex_state = 4},
  [119] = {.lex_state = 21, .external_lex_state = 4},
  [120] = {.lex_state = 21, .external_lex_state = 4},
  [121] = {.lex_state = 21, .external_lex_state = 4},
  [122] = {.lex_state = 21, .external_lex_state = 4},
  [123] = {.lex_state = 21, .external_lex_state = 4},
  [124] = {.lex_state = 21, .external_lex_state = 4},
  [125] = {.lex_state = 21, .external_lex_state = 4},
  [126] = {.lex_state = 21, .external_lex_state = 4},
  [127] = {.lex_state = 21, .external_lex_state = 4},
  [128] = {.lex_state = 21, .external_lex_state = 4},
  [129] = {.lex_state = 21, .external_lex_state = 4},
  [130] = {.lex_state = 21, .external_lex_state = 4},
  [131] = {.lex_state = 21, .external_lex_state = 4},
  [132] = {.lex_state = 21, .external_lex_state = 4},
  [133] = {.lex_state = 21, .external_lex_state = 4},
  [134] = {.lex_state = 21, .external_lex_state = 4},
  [135] = {.lex_state = 21, .external_lex_state = 4},
  [136] = {.lex_state = 21, .external_lex_state = 4},
  [137] = {.lex_state = 21, .external_lex_state = 3},
  [138] = {.lex_state = 21, .external_lex_state = 4},
  [139] = {.lex_state = 21, .external_lex_state = 4},
  [140] = {.lex_state = 21, .external_lex_state = 4},
  [141] = {.lex_state = 21, .external_lex_state = 4},
  [142] = {.lex_state = 21, .external_lex_state = 4},
  [143] = {.lex_state = 21, .external_lex_state = 4},
  [144] = {.lex_state = 21, .external_lex_state = 4},
  [145] = {.lex_state = 21, .external_lex_state = 4},
  [146] = {.lex_state = 21, .external_lex_state = 4},
  [147] = {.lex_state = 21, .external_lex_state = 4},
  [148] = {.lex_state = 21, .external_lex_state = 4},
  [149] = {.lex_state = 21, .external_lex_state = 4},
  [150] = {.lex_state = 21, .external_lex_state = 4},
  [151] = {.lex_state = 21, .external_lex_state = 4},
  [152] = {.lex_state = 21, .external_lex_state = 4},
  [153] = {.lex_state = 21, .external_lex_state = 5},
  [154] = {.lex_state = 21, .external_lex_state = 4},
  [155] = {.lex_state = 21, .external_lex_state = 4},
  [156] = {.lex_state = 21, .external_lex_state = 4},
  [157] = {.lex_state = 21, .external_lex_state = 4},
  [158] = {.lex_state = 21, .external_lex_state = 4},
  [159] = {.lex_state = 21, .external_lex_state = 4},
  [160] = {.lex_state = 21, .external_lex_state = 4},
  [161] = {.lex_state = 21, .external_lex_state = 4},
  [162] = {.lex_state = 21, .external_lex_state = 4},
  [163] = {.lex_state = 21, .external_lex_state = 4},
  [164] = {.lex_state = 21, .external_lex_state = 4},
  [165] = {.lex_state = 21, .external_lex_state = 4},
  [166] = {.lex_state = 21, .external_lex_state = 4},
  [167] = {.lex_state = 21, .external_lex_state = 4},
  [168] = {.lex_state = 21, .external_lex_state = 4},
  [169] = {.lex_state = 21, .external_lex_state = 4},
  [170] = {.lex_state = 21, .external_lex_state = 4},
  [171] = {.lex_state = 21, .external_lex_state = 4},
  [172] = {.lex_state = 21, .external_lex_state = 4},
  [173] = {.lex_state = 21, .external_lex_state = 4},
  [174] = {.lex_state = 21, .external_lex_state = 4},
  [175] = {.lex_state = 21, .external_lex_state = 4},
  [176] = {.lex_state = 21, .external_lex_state = 4},
  [177] = {.lex_state = 21, .external_lex_state = 4},
  [178] = {.lex_state = 21, .external_lex_state = 4},
  [179] = {.lex_state = 21, .external_lex_state = 4},
  [180] = {.lex_state = 21, .external_lex_state = 4},
  [181] = {.lex_state = 21, .external_lex_state = 4},
  [182] = {.lex_state = 21, .external_lex_state = 4},
  [183] = {.lex_state = 21, .external_lex_state = 4},
  [184] = {.lex_state = 21, .external_lex_state = 4},
  [185] = {.lex_state = 21, .external_lex_state = 4},
  [186] = {.lex_state = 21, .external_lex_state = 4},
  [187] = {.lex_state = 21, .external_lex_state = 4},
  [188] = {.lex_state = 21, .external_lex_state = 4},
  [189] = {.lex_state = 21, .external_lex_state = 4},
  [190] = {.lex_state = 21, .external_lex_state = 4},
  [191] = {.lex_state = 21, .external_lex_state = 4},
  [192] = {.lex_state = 21, .external_lex_state = 4},
  [193] = {.lex_state = 21, .external_lex_state = 4},
  [194] = {.lex_state = 21, .external_lex_state = 4},
  [195] = {.lex_state = 21, .external_lex_state = 4},
  [196] = {.lex_state = 21, .external_lex_state = 4},
  [197] = {.lex_state = 21, .external_lex_state = 4},
  [198] = {.lex_state = 21, .external_lex_state = 4},
  [199] = {.lex_state = 21, .external_lex_state = 4},
  [200] = {.lex_state = 21, .external_lex_state = 4},
  [201] = {.lex_state = 21, .external_lex_state = 4},
  [202] = {.lex_state = 21, .external_lex_state = 4},
  [203] = {.lex_state = 21, .external_lex_state = 4},
  [204] = {.lex_state = 21, .external_lex_state = 4},
  [205] = {.lex_state = 21, .external_lex_state = 4},
  [206] = {.lex_state = 21, .external_lex_state = 5},
  [207] = {.lex_state = 21, .external_lex_state = 4},
  [208] = {.lex_state = 21, .external_lex_state = 4},
  [209] = {.lex_state = 21, .external_lex_state = 4},
  [210] = {.lex_state = 21, .external_lex_state = 4},
  [211] = {.lex_state = 21, .external_lex_state = 4},
  [212] = {.lex_state = 21, .external_lex_state = 4},
  [213] = {.lex_state = 21, .external_lex_state = 4},
  [214] = {.lex_state = 21, .external_lex_state = 4},
  [215] = {.lex_state = 21, .external_lex_state = 4},
  [216] = {.lex_state = 21, .external_lex_state = 4},
  [217] = {.lex_state = 21, .external_lex_state = 4},
  [218] = {.lex_state = 21, .external_lex_state = 4},
  [219] = {.lex_state = 21, .external_lex_state = 4},
  [220] = {.lex_state = 21, .external_lex_state = 4},
  [221] = {.lex_state = 21, .external_lex_state = 4},
  [222] = {.lex_state = 21, .external_lex_state = 4},
  [223] = {.lex_state = 21, .external_lex_state = 5},
  [224] = {.lex_state = 21, .external_lex_state = 4},
  [225] = {.lex_state = 21, .external_lex_state = 6},
  [226] = {.lex_state = 21, .external_lex_state = 3},
  [227] = {.lex_state = 21, .external_lex_state = 6},
  [228] = {.lex_state = 21, .external_lex_state = 6},
  [229] = {.lex_state = 21, .external_lex_state = 5},
  [230] = {.lex_state = 21, .external_lex_state = 2},
  [231] = {.lex_state = 21, .external_lex_state = 4},
  [232] = {.lex_state = 21, .external_lex_state = 7},
  [233] = {.lex_state = 21, .external_lex_state = 6},
  [234] = {.lex_state = 21, .external_lex_state = 6},
  [235] = {.lex_state = 21, .external_lex_state = 6},
  [236] = {.lex_state = 21, .external_lex_state = 2},
  [237] = {.lex_state = 21, .external_lex_state = 6},
  [238] = {.lex_state = 21, .external_lex_state = 6},
  [239] = {.lex_state = 21, .external_lex_state = 6},
  [240] = {.lex_state = 21, .external_lex_state = 6},
  [241] = {.lex_state = 21, .external_lex_state = 6},
  [242] = {.lex_state = 21, .external_lex_state = 6},
  [243] = {.lex_state = 21, .external_lex_state = 4},
  [244] = {.lex_state = 21, .external_lex_state = 5},
  [245] = {.lex_state = 21, .external_lex_state = 6},
  [246] = {.lex_state = 21, .external_lex_state = 8},
  [247] = {.lex_state = 21, .external_lex_state = 8},
  [248] = {.lex_state = 21, .external_lex_state = 8},
  [249] = {.lex_state = 21, .external_lex_state = 9},
  [250] = {.lex_state = 21, .external_lex_state = 9},
  [251] = {.lex_state = 21, .external_lex_state = 9},
  [252] = {.lex_state = 21, .external_lex_state = 6},
  [253] = {.lex_state = 21, .external_lex_state = 6},
  [254] = {.lex_state = 21, .external_lex_state = 6},
  [255] = {.lex_state = 21, .external_lex_state = 6},
  [256] = {.lex_state = 21, .external_lex_state = 6},
  [257] = {.lex_state = 23, .external_lex_state = 10},
  [258] = {.lex_state = 21, .external_lex_state = 7},
  [259] = {.lex_state = 21, .external_lex_state = 7},
  [260] = {.lex_state = 21, .external_lex_state = 6},
  [261] = {.lex_state = 21, .external_lex_state = 10},
  [262] = {.lex_state = 21, .external_lex_state = 10},
  [263] = {.lex_state = 21, .external_lex_state = 8},
  [264] = {.lex_state = 21, .external_lex_state = 7},
  [265] = {.lex_state = 21, .external_lex_state = 9},
  [266] = {.lex_state = 21, .external_lex_state = 7},
  [267] = {.lex_state = 21, .external_lex_state = 9},
  [268] = {.lex_state = 21, .external_lex_state = 9},
  [269] = {.lex_state = 21, .external_lex_state = 7},
  [270] = {.lex_state = 21, .external_lex_state = 9},
  [271] = {.lex_state = 21, .external_lex_state = 8},
  [272] = {.lex_state = 21, .external_lex_state = 8},
  [273] = {.lex_state = 21, .external_lex_state = 8},
  [274] = {.lex_state = 23, .external_lex_state = 11},
  [275] = {.lex_state = 21, .external_lex_state = 8},
  [276] = {.lex_state = 21, .external_lex_state = 8},
  [277] = {.lex_state = 21, .external_lex_state = 7},
  [278] = {.lex_state = 21, .external_lex_state = 8},
  [279] = {.lex_state = 21, .external_lex_state = 8},
  [280] = {.lex_state = 21, .external_lex_state = 9},
  [281] = {.lex_state = 21, .external_lex_state = 7},
  [282] = {.lex_state = 21, .external_lex_state = 10},
  [283] = {.lex_state = 21, .external_lex_state = 10},
  [284] = {.lex_state = 21, .external_lex_state = 7},
  [285] = {.lex_state = 23, .external_lex_state = 12},
  [286] = {.lex_state = 21, .external_lex_state = 10},
  [287] = {.lex_state = 21, .external_lex_state = 9},
  [288] = {.lex_state = 21, .external_lex_state = 9},
  [289] = {.lex_state = 21, .external_lex_state = 8},
  [290] = {.lex_state = 21, .external_lex_state = 7},
  [291] = {.lex_state = 21, .external_lex_state = 8},
  [292] = {.lex_state = 21, .external_lex_state = 8},
  [293] = {.lex_state = 21, .external_lex_state = 10},
  [294] = {.lex_state = 21, .external_lex_state = 10},
  [295] = {.lex_state = 21, .external_lex_state = 10},
  [296] = {.lex_state = 21, .external_lex_state = 9},
  [297] = {.lex_state = 21, .external_lex_state = 8},
  [298] = {.lex_state = 21, .external_lex_state = 10},
  [299] = {.lex_state = 21, .external_lex_state = 10},
  [300] = {.lex_state = 21, .external_lex_state = 9},
  [301] = {.lex_state = 21, .external_lex_state = 10},
  [302] = {.lex_state = 21, .external_lex_state = 10},
  [303] = {.lex_state = 21, .external_lex_state = 9},
  [304] = {.lex_state = 21, .external_lex_state = 10},
  [305] = {.lex_state = 21, .external_lex_state = 10},
  [306] = {.lex_state = 23, .external_lex_state = 13},
  [307] = {.lex_state = 21, .external_lex_state = 10},
  [308] = {.lex_state = 21, .external_lex_state = 8},
  [309] = {.lex_state = 21, .external_lex_state = 9},
  [310] = {.lex_state = 21, .external_lex_state = 10},
  [311] = {.lex_state = 21, .external_lex_state = 10},
  [312] = {.lex_state = 21, .external_lex_state = 8},
  [313] = {.lex_state = 21, .external_lex_state = 10},
  [314] = {.lex_state = 21, .external_lex_state = 10},
  [315] = {.lex_state = 21, .external_lex_state = 6},
  [316] = {.lex_state = 21, .external_lex_state = 10},
  [317] = {.lex_state = 21, .external_lex_state = 10},
  [318] = {.lex_state = 21, .external_lex_state = 10},
  [319] = {.lex_state = 21, .external_lex_state = 10},
  [320] = {.lex_state = 21, .external_lex_state = 9},
  [321] = {.lex_state = 21, .external_lex_state = 10},
  [322] = {.lex_state = 21, .external_lex_state = 10},
  [323] = {.lex_state = 21, .external_lex_state = 10},
  [324] = {.lex_state = 21, .external_lex_state = 10},
  [325] = {.lex_state = 21, .external_lex_state = 10},
  [326] = {.lex_state = 21, .external_lex_state = 10},
  [327] = {.lex_state = 21, .external_lex_state = 7},
  [328] = {.lex_state = 21, .external_lex_state = 7},
  [329] = {.lex_state = 21, .external_lex_state = 8},
  [330] = {.lex_state = 21, .external_lex_state = 8},
  [331] = {.lex_state = 21, .external_lex_state = 7},
  [332] = {.lex_state = 21, .external_lex_state = 9},
  [333] = {.lex_state = 21, .external_lex_state = 9},
  [334] = {.lex_state = 21, .external_lex_state = 7},
  [335] = {.lex_state = 21, .external_lex_state = 7},
  [336] = {.lex_state = 21, .external_lex_state = 7},
  [337] = {.lex_state = 21, .external_lex_state = 9},
  [338] = {.lex_state = 21, .external_lex_state = 9},
  [339] = {.lex_state = 21, .external_lex_state = 7},
  [340] = {.lex_state = 21, .external_lex_state = 7},
  [341] = {.lex_state = 21, .external_lex_state = 7},
  [342] = {.lex_state = 21, .external_lex_state = 10},
  [343] = {.lex_state = 21, .external_lex_state = 10},
  [344] = {.lex_state = 21, .external_lex_state = 13},
  [345] = {.lex_state = 21, .external_lex_state = 11},
  [346] = {.lex_state = 21, .external_lex_state = 12},
  [347] = {.lex_state = 21, .external_lex_state = 12},
  [348] = {.lex_state = 21, .external_lex_state = 13},
  [349] = {.lex_state = 21, .external_lex_state = 11},
  [350] = {.lex_state = 21, .external_lex_state = 11},
  [351] = {.lex_state = 21, .external_lex_state = 11},
  [352] = {.lex_state = 21, .external_lex_state = 12},
  [353] = {.lex_state = 21, .external_lex_state = 9},
  [354] = {.lex_state = 21, .external_lex_state = 11},
  [355] = {.lex_state = 21, .external_lex_state = 11},
  [356] = {.lex_state = 21, .external_lex_state = 11},
  [357] = {.lex_state = 21, .external_lex_state = 11},
  [358] = {.lex_state = 21, .external_lex_state = 11},
  [359] = {.lex_state = 21, .external_lex_state = 12},
  [360] = {.lex_state = 21, .external_lex_state = 12},
  [361] = {.lex_state = 21, .external_lex_state = 11},
  [362] = {.lex_state = 21, .external_lex_state = 11},
  [363] = {.lex_state = 21, .external_lex_state = 11},
  [364] = {.lex_state = 21, .external_lex_state = 12},
  [365] = {.lex_state = 21, .external_lex_state = 12},
  [366] = {.lex_state = 21, .external_lex_state = 11},
  [367] = {.lex_state = 21, .external_lex_state = 12},
  [368] = {.lex_state = 21, .external_lex_state = 10},
  [369] = {.lex_state = 21, .external_lex_state = 13},
  [370] = {.lex_state = 21, .external_lex_state = 13},
  [371] = {.lex_state = 21, .external_lex_state = 7},
  [372] = {.lex_state = 21, .external_lex_state = 13},
  [373] = {.lex_state = 21, .external_lex_state = 12},
  [374] = {.lex_state = 21, .external_lex_state = 13},
  [375] = {.lex_state = 21, .external_lex_state = 13},
  [376] = {.lex_state = 21, .external_lex_state = 13},
  [377] = {.lex_state = 21, .external_lex_state = 13},
  [378] = {.lex_state = 21, .external_lex_state = 13},
  [379] = {.lex_state = 21, .external_lex_state = 13},
  [380] = {.lex_state = 21, .external_lex_state = 13},
  [381] = {.lex_state = 21, .external_lex_state = 13},
  [382] = {.lex_state = 21, .external_lex_state = 12},
  [383] = {.lex_state = 21, .external_lex_state = 13},
  [384] = {.lex_state = 21, .external_lex_state = 11},
  [385] = {.lex_state = 21, .external_lex_state = 13},
  [386] = {.lex_state = 21, .external_lex_state = 13},
  [387] = {.lex_state = 21, .external_lex_state = 13},
  [388] = {.lex_state = 21, .external_lex_state = 13},
  [389] = {.lex_state = 21, .external_lex_state = 13},
  [390] = {.lex_state = 21, .external_lex_state = 12},
  [391] = {.lex_state = 21, .external_lex_state = 13},
  [392] = {.lex_state = 21, .external_lex_state = 13},
  [393] = {.lex_state = 20, .external_lex_state = 14},
  [394] = {.lex_state = 21, .external_lex_state = 13},
  [395] = {.lex_state = 21, .external_lex_state = 13},
  [396] = {.lex_state = 21, .external_lex_state = 13},
  [397] = {.lex_state = 21, .external_lex_state = 12},
  [398] = {.lex_state = 21, .external_lex_state = 11},
  [399] = {.lex_state = 21, .external_lex_state = 13},
  [400] = {.lex_state = 21, .external_lex_state = 13},
  [401] = {.lex_state = 21, .external_lex_state = 13},
  [402] = {.lex_state = 21, .external_lex_state = 12},
  [403] = {.lex_state = 21, .external_lex_state = 12},
  [404] = {.lex_state = 21, .external_lex_state = 12},
  [405] = {.lex_state = 21, .external_lex_state = 12},
  [406] = {.lex_state = 20, .external_lex_state = 15},
  [407] = {.lex_state = 21, .external_lex_state = 12},
  [408] = {.lex_state = 21, .external_lex_state = 8},
  [409] = {.lex_state = 21, .external_lex_state = 12},
  [410] = {.lex_state = 21, .external_lex_state = 12},
  [411] = {.lex_state = 21, .external_lex_state = 11},
  [412] = {.lex_state = 21, .external_lex_state = 11},
  [413] = {.lex_state = 21, .external_lex_state = 12},
  [414] = {.lex_state = 21, .external_lex_state = 12},
  [415] = {.lex_state = 21, .external_lex_state = 11},
  [416] = {.lex_state = 21, .external_lex_state = 13},
  [417] = {.lex_state = 21, .external_lex_state = 12},
  [418] = {.lex_state = 21, .external_lex_state = 12},
  [419] = {.lex_state = 21, .external_lex_state = 13},
  [420] = {.lex_state = 21, .external_lex_state = 11},
  [421] = {.lex_state = 21, .external_lex_state = 11},
  [422] = {.lex_state = 21, .external_lex_state = 11},
  [423] = {.lex_state = 21, .external_lex_state = 11},
  [424] = {.lex_state = 21, .external_lex_state = 12},
  [425] = {.lex_state = 21, .external_lex_state = 11},
  [426] = {.lex_state = 21, .external_lex_state = 11},
  [427] = {.lex_state = 21, .external_lex_state = 11},
  [428] = {.lex_state = 21, .external_lex_state = 11},
  [429] = {.lex_state = 21, .external_lex_state = 12},
  [430] = {.lex_state = 21, .external_lex_state = 12},
  [431] = {.lex_state = 21, .external_lex_state = 12},
  [432] = {.lex_state = 21, .external_lex_state = 11},
  [433] = {.lex_state = 20, .external_lex_state = 15},
  [434] = {.lex_state = 21, .external_lex_state = 11},
  [435] = {.lex_state = 21, .external_lex_state = 11},
  [436] = {.lex_state = 21, .external_lex_state = 12},
  [437] = {.lex_state = 21, .external_lex_state = 12},
  [438] = {.lex_state = 21, .external_lex_state = 11},
  [439] = {.lex_state = 21, .external_lex_state = 12},
  [440] = {.lex_state = 21, .external_lex_state = 13},
  [441] = {.lex_state = 20, .external_lex_state = 15},
  [442] = {.lex_state = 21, .external_lex_state = 10},
  [443] = {.lex_state = 21, .external_lex_state = 10},
  [444] = {.lex_state = 20, .external_lex_state = 15},
  [445] = {.lex_state = 21, .external_lex_state = 10},
  [446] = {.lex_state = 21, .external_lex_state = 10},
  [447] = {.lex_state = 20, .external_lex_state = 15},
  [448] = {.lex_state = 20, .external_lex_state = 15},
  [449] = {.lex_state = 20, .external_lex_state = 15},
  [450] = {.lex_state = 20, .external_lex_state = 15},
  [451] = {.lex_state = 20, .external_lex_state = 15},
  [452] = {.lex_state = 21, .external_lex_state = 13},
  [453] = {.lex_state = 20, .external_lex_state = 15},
  [454] = {.lex_state = 21, .external_lex_state = 10},
  [455] = {.lex_state = 21, .external_lex_state = 10},
  [456] = {.lex_state = 21, .external_lex_state = 10},
  [457] = {.lex_state = 21, .external_lex_state = 10},
  [458] = {.lex_state = 21, .external_lex_state = 10},
  [459] = {.lex_state = 21, .external_lex_state = 10},
  [460] = {.lex_state = 21, .external_lex_state = 10},
  [461] = {.lex_state = 21, .external_lex_state = 10},
  [462] = {.lex_state = 21, .external_lex_state = 10},
  [463] = {.lex_state = 21, .external_lex_state = 10},
  [464] = {.lex_state = 20, .external_lex_state = 15},
  [465] = {.lex_state = 21, .external_lex_state = 10},
  [466] = {.lex_state = 21, .external_lex_state = 10},
  [467] = {.lex_state = 21, .external_lex_state = 10},
  [468] = {.lex_state = 21, .external_lex_state = 10},
  [469] = {.lex_state = 21, .external_lex_state = 10},
  [470] = {.lex_state = 21, .external_lex_state = 10},
  [471] = {.lex_state = 21, .external_lex_state = 10},
  [472] = {.lex_state = 21, .external_lex_state = 10},
  [473] = {.lex_state = 21, .external_lex_state = 10},
  [474] = {.lex_state = 21, .external_lex_state = 10},
  [475] = {.lex_state = 21, .external_lex_state = 10},
  [476] = {.lex_state = 21, .external_lex_state = 10},
  [477] = {.lex_state = 20, .external_lex_state = 15},
  [478] = {.lex_state = 21, .external_lex_state = 10},
  [479] = {.lex_state = 21, .external_lex_state = 10},
  [480] = {.lex_state = 20, .external_lex_state = 15},
  [481] = {.lex_state = 20, .external_lex_state = 15},
  [482] = {.lex_state = 21, .external_lex_state = 12},
  [483] = {.lex_state = 21, .external_lex_state = 11},
  [484] = {.lex_state = 20, .external_lex_state = 15},
  [485] = {.lex_state = 20, .external_lex_state = 15},
  [486] = {.lex_state = 21, .external_lex_state = 10},
  [487] = {.lex_state = 20, .external_lex_state = 15},
  [488] = {.lex_state = 21, .external_lex_state = 10},
  [489] = {.lex_state = 21, .external_lex_state = 10},
  [490] = {.lex_state = 21, .external_lex_state = 10},
  [491] = {.lex_state = 21, .external_lex_state = 10},
  [492] = {.lex_state = 21, .external_lex_state = 10},
  [493] = {.lex_state = 21, .external_lex_state = 10},
  [494] = {.lex_state = 21, .external_lex_state = 10},
  [495] = {.lex_state = 20, .external_lex_state = 15},
  [496] = {.lex_state = 21, .external_lex_state = 10},
  [497] = {.lex_state = 21, .external_lex_state = 10},
  [498] = {.lex_state = 21, .external_lex_state = 10},
  [499] = {.lex_state = 21, .external_lex_state = 10},
  [500] = {.lex_state = 21, .external_lex_state = 10},
  [501] = {.lex_state = 21, .external_lex_state = 10},
  [502] = {.lex_state = 21, .external_lex_state = 10},
  [503] = {.lex_state = 20, .external_lex_state = 15},
  [504] = {.lex_state = 20, .external_lex_state = 15},
  [505] = {.lex_state = 20, .external_lex_state = 15},
  [506] = {.lex_state = 20, .external_lex_state = 15},
  [507] = {.lex_state = 20, .external_lex_state = 15},
  [508] = {.lex_state = 20, .external_lex_state = 15},
  [509] = {.lex_state = 20, .external_lex_state = 15},
  [510] = {.lex_state = 20, .external_lex_state = 15},
  [511] = {.lex_state = 20, .external_lex_state = 15},
  [512] = {.lex_state = 20, .external_lex_state = 15},
  [513] = {.lex_state = 20, .external_lex_state = 15},
  [514] = {.lex_state = 20, .external_lex_state = 15},
  [515] = {.lex_state = 20, .external_lex_state = 15},
  [516] = {.lex_state = 23, .external_lex_state = 16},
  [517] = {.lex_state = 21, .external_lex_state = 16},
  [518] = {.lex_state = 23, .external_lex_state = 16},
  [519] = {.lex_state = 23, .external_lex_state = 16},
  [520] = {.lex_state = 20, .external_lex_state = 17},
  [521] = {.lex_state = 21, .external_lex_state = 11},
  [522] = {.lex_state = 21, .external_lex_state = 12},
  [523] = {.lex_state = 21, .external_lex_state = 10},
  [524] = {.lex_state = 21, .external_lex_state = 10},
  [525] = {.lex_state = 21, .external_lex_state = 10},
  [526] = {.lex_state = 21, .external_lex_state = 16},
  [527] = {.lex_state = 23, .external_lex_state = 16},
  [528] = {.lex_state = 21, .external_lex_state = 16},
  [529] = {.lex_state = 23, .external_lex_state = 16},
  [530] = {.lex_state = 21, .external_lex_state = 16},
  [531] = {.lex_state = 23, .external_lex_state = 16},
  [532] = {.lex_state = 21, .external_lex_state = 16},
  [533] = {.lex_state = 23, .external_lex_state = 16},
  [534] = {.lex_state = 21, .external_lex_state = 16},
  [535] = {.lex_state = 23, .external_lex_state = 16},
  [536] = {.lex_state = 23, .external_lex_state = 16},
  [537] = {.lex_state = 23, .external_lex_state = 16},
  [538] = {.lex_state = 21, .external_lex_state = 16},
  [539] = {.lex_state = 23, .external_lex_state = 16},
  [540] = {.lex_state = 20, .external_lex_state = 18},
  [541] = {.lex_state = 21, .external_lex_state = 13},
  [542] = {.lex_state = 21, .external_lex_state = 16},
  [543] = {.lex_state = 21, .external_lex_state = 16},
  [544] = {.lex_state = 23, .external_lex_state = 16},
  [545] = {.lex_state = 21, .external_lex_state = 16},
  [546] = {.lex_state = 23, .external_lex_state = 16},
  [547] = {.lex_state = 21, .external_lex_state = 16},
  [548] = {.lex_state = 23, .external_lex_state = 16},
  [549] = {.lex_state = 21, .external_lex_state = 16},
  [550] = {.lex_state = 21, .external_lex_state = 16},
  [551] = {.lex_state = 23, .external_lex_state = 16},
  [552] = {.lex_state = 23, .external_lex_state = 16},
  [553] = {.lex_state = 20, .external_lex_state = 15},
  [554] = {.lex_state = 21, .external_lex_state = 16},
  [555] = {.lex_state = 23, .external_lex_state = 16},
  [556] = {.lex_state = 21, .external_lex_state = 16},
  [557] = {.lex_state = 21, .external_lex_state = 16},
  [558] = {.lex_state = 23, .external_lex_state = 16},
  [559] = {.lex_state = 21, .external_lex_state = 16},
  [560] = {.lex_state = 21, .external_lex_state = 16},
  [561] = {.lex_state = 20, .external_lex_state = 15},
  [562] = {.lex_state = 21, .external_lex_state = 12},
  [563] = {.lex_state = 21, .external_lex_state = 12},
  [564] = {.lex_state = 21, .external_lex_state = 11},
  [565] = {.lex_state = 21, .external_lex_state = 12},
  [566] = {.lex_state = 21, .external_lex_state = 11},
  [567] = {.lex_state = 21, .external_lex_state = 11},
  [568] = {.lex_state = 21, .external_lex_state = 11},
  [569] = {.lex_state = 21, .external_lex_state = 11},
  [570] = {.lex_state = 21, .external_lex_state = 11},
  [571] = {.lex_state = 21, .external_lex_state = 11},
  [572] = {.lex_state = 21, .external_lex_state = 11},
  [573] = {.lex_state = 21, .external_lex_state = 11},
  [574] = {.lex_state = 20, .external_lex_state = 15},
  [575] = {.lex_state = 21, .external_lex_state = 11},
  [576] = {.lex_state = 21, .external_lex_state = 11},
  [577] = {.lex_state = 21, .external_lex_state = 12},
  [578] = {.lex_state = 20, .external_lex_state = 15},
  [579] = {.lex_state = 21, .external_lex_state = 12},
  [580] = {.lex_state = 21, .external_lex_state = 11},
  [581] = {.lex_state = 21, .external_lex_state = 11},
  [582] = {.lex_state = 21, .external_lex_state = 11},
  [583] = {.lex_state = 21, .external_lex_state = 11},
  [584] = {.lex_state = 20, .external_lex_state = 15},
  [585] = {.lex_state = 21, .external_lex_state = 11},
  [586] = {.lex_state = 21, .external_lex_state = 11},
  [587] = {.lex_state = 21, .external_lex_state = 11},
  [588] = {.lex_state = 21, .external_lex_state = 12},
  [589] = {.lex_state = 21, .external_lex_state = 11},
  [590] = {.lex_state = 20, .external_lex_state = 15},
  [591] = {.lex_state = 21, .external_lex_state = 12},
  [592] = {.lex_state = 20, .external_lex_state = 15},
  [593] = {.lex_state = 21, .external_lex_state = 11},
  [594] = {.lex_state = 21, .external_lex_state = 12},
  [595] = {.lex_state = 21, .external_lex_state = 13},
  [596] = {.lex_state = 21, .external_lex_state = 13},
  [597] = {.lex_state = 21, .external_lex_state = 13},
  [598] = {.lex_state = 21, .external_lex_state = 13},
  [599] = {.lex_state = 21, .external_lex_state = 13},
  [600] = {.lex_state = 21, .external_lex_state = 11},
  [601] = {.lex_state = 21, .external_lex_state = 13},
  [602] = {.lex_state = 21, .external_lex_state = 11},
  [603] = {.lex_state = 21, .external_lex_state = 13},
  [604] = {.lex_state = 21, .external_lex_state = 13},
  [605] = {.lex_state = 21, .external_lex_state = 11},
  [606] = {.lex_state = 20, .external_lex_state = 15},
  [607] = {.lex_state = 21, .external_lex_state = 13},
  [608] = {.lex_state = 21, .external_lex_state = 12},
  [609] = {.lex_state = 21, .external_lex_state = 13},
  [610] = {.lex_state = 21, .external_lex_state = 11},
  [611] = {.lex_state = 21, .external_lex_state = 11},
  [612] = {.lex_state = 21, .external_lex_state = 11},
  [613] = {.lex_state = 20, .external_lex_state = 15},
  [614] = {.lex_state = 21, .external_lex_state = 13},
  [615] = {.lex_state = 21, .external_lex_state = 11},
  [616] = {.lex_state = 21, .external_lex_state = 11},
  [617] = {.lex_state = 21, .external_lex_state = 12},
  [618] = {.lex_state = 21, .external_lex_state = 13},
  [619] = {.lex_state = 21, .external_lex_state = 13},
  [620] = {.lex_state = 21, .external_lex_state = 13},
  [621] = {.lex_state = 21, .external_lex_state = 12},
  [622] = {.lex_state = 21, .external_lex_state = 11},
  [623] = {.lex_state = 20, .external_lex_state = 15},
  [624] = {.lex_state = 20, .external_lex_state = 15},
  [625] = {.lex_state = 21, .external_lex_state = 12},
  [626] = {.lex_state = 21, .external_lex_state = 13},
  [627] = {.lex_state = 21, .external_lex_state = 12},
  [628] = {.lex_state = 21, .external_lex_state = 13},
  [629] = {.lex_state = 21, .external_lex_state = 13},
  [630] = {.lex_state = 21, .external_lex_state = 13},
  [631] = {.lex_state = 21, .external_lex_state = 13},
  [632] = {.lex_state = 21, .external_lex_state = 13},
  [633] = {.lex_state = 21, .external_lex_state = 13},
  [634] = {.lex_state = 21, .external_lex_state = 13},
  [635] = {.lex_state = 21, .external_lex_state = 13},
  [636] = {.lex_state = 21, .external_lex_state = 13},
  [637] = {.lex_state = 21, .external_lex_state = 12},
  [638] = {.lex_state = 20, .external_lex_state = 15},
  [639] = {.lex_state = 21, .external_lex_state = 12},
  [640] = {.lex_state = 21, .external_lex_state = 12},
  [641] = {.lex_state = 21, .external_lex_state = 12},
  [642] = {.lex_state = 21, .external_lex_state = 11},
  [643] = {.lex_state = 21, .external_lex_state = 13},
  [644] = {.lex_state = 21, .external_lex_state = 13},
  [645] = {.lex_state = 21, .external_lex_state = 13},
  [646] = {.lex_state = 21, .external_lex_state = 13},
  [647] = {.lex_state = 21, .external_lex_state = 13},
  [648] = {.lex_state = 21, .external_lex_state = 13},
  [649] = {.lex_state = 21, .external_lex_state = 13},
  [650] = {.lex_state = 21, .external_lex_state = 13},
  [651] = {.lex_state = 21, .external_lex_state = 12},
  [652] = {.lex_state = 21, .external_lex_state = 12},
  [653] = {.lex_state = 21, .external_lex_state = 12},
  [654] = {.lex_state = 20, .external_lex_state = 15},
  [655] = {.lex_state = 21, .external_lex_state = 13},
  [656] = {.lex_state = 21, .external_lex_state = 12},
  [657] = {.lex_state = 21, .external_lex_state = 12},
  [658] = {.lex_state = 21, .external_lex_state = 13},
  [659] = {.lex_state = 21, .external_lex_state = 12},
  [660] = {.lex_state = 21, .external_lex_state = 11},
  [661] = {.lex_state = 21, .external_lex_state = 12},
  [662] = {.lex_state = 21, .external_lex_state = 12},
  [663] = {.lex_state = 21, .external_lex_state = 12},
  [664] = {.lex_state = 21, .external_lex_state = 11},
  [665] = {.lex_state = 21, .external_lex_state = 11},
  [666] = {.lex_state = 21, .external_lex_state = 11},
  [667] = {.lex_state = 20, .external_lex_state = 15},
  [668] = {.lex_state = 21, .external_lex_state = 12},
  [669] = {.lex_state = 21, .external_lex_state = 13},
  [670] = {.lex_state = 20, .external_lex_state = 15},
  [671] = {.lex_state = 21, .external_lex_state = 12},
  [672] = {.lex_state = 21, .external_lex_state = 13},
  [673] = {.lex_state = 21, .external_lex_state = 12},
  [674] = {.lex_state = 21, .external_lex_state = 13},
  [675] = {.lex_state = 21, .external_lex_state = 12},
  [676] = {.lex_state = 21, .external_lex_state = 13},
  [677] = {.lex_state = 20, .external_lex_state = 15},
  [678] = {.lex_state = 21, .external_lex_state = 12},
  [679] = {.lex_state = 21, .external_lex_state = 12},
  [680] = {.lex_state = 21, .external_lex_state = 11},
  [681] = {.lex_state = 21, .external_lex_state = 13},
  [682] = {.lex_state = 21, .external_lex_state = 12},
  [683] = {.lex_state = 21, .external_lex_state = 13},
  [684] = {.lex_state = 21, .external_lex_state = 11},
  [685] = {.lex_state = 21, .external_lex_state = 12},
  [686] = {.lex_state = 20, .external_lex_state = 15},
  [687] = {.lex_state = 21, .external_lex_state = 11},
  [688] = {.lex_state = 21, .external_lex_state = 11},
  [689] = {.lex_state = 21, .external_lex_state = 12},
  [690] = {.lex_state = 20, .external_lex_state = 15},
  [691] = {.lex_state = 21, .external_lex_state = 13},
  [692] = {.lex_state = 21, .external_lex_state = 12},
  [693] = {.lex_state = 21, .external_lex_state = 12},
  [694] = {.lex_state = 21, .external_lex_state = 12},
  [695] = {.lex_state = 21, .external_lex_state = 11},
  [696] = {.lex_state = 20, .external_lex_state = 15},
  [697] = {.lex_state = 21, .external_lex_state = 12},
  [698] = {.lex_state = 21, .external_lex_state = 12},
  [699] = {.lex_state = 21, .external_lex_state = 12},
  [700] = {.lex_state = 21, .external_lex_state = 13},
  [701] = {.lex_state = 21, .external_lex_state = 12},
  [702] = {.lex_state = 21, .external_lex_state = 12},
  [703] = {.lex_state = 21, .external_lex_state = 11},
  [704] = {.lex_state = 21, .external_lex_state = 11},
  [705] = {.lex_state = 21, .external_lex_state = 11},
  [706] = {.lex_state = 21, .external_lex_state = 11},
  [707] = {.lex_state = 21, .external_lex_state = 13},
  [708] = {.lex_state = 23, .external_lex_state = 16},
  [709] = {.lex_state = 21, .external_lex_state = 13},
  [710] = {.lex_state = 21, .external_lex_state = 13},
  [711] = {.lex_state = 21, .external_lex_state = 13},
  [712] = {.lex_state = 20, .external_lex_state = 15},
  [713] = {.lex_state = 20, .external_lex_state = 15},
  [714] = {.lex_state = 20, .external_lex_state = 15},
  [715] = {.lex_state = 20, .external_lex_state = 15},
  [716] = {.lex_state = 20, .external_lex_state = 15},
  [717] = {.lex_state = 21, .external_lex_state = 11},
  [718] = {.lex_state = 21, .external_lex_state = 11},
  [719] = {.lex_state = 21, .external_lex_state = 11},
  [720] = {.lex_state = 21, .external_lex_state = 12},
  [721] = {.lex_state = 21, .external_lex_state = 12},
  [722] = {.lex_state = 20, .external_lex_state = 15},
  [723] = {.lex_state = 20, .external_lex_state = 15},
  [724] = {.lex_state = 23, .external_lex_state = 16},
  [725] = {.lex_state = 21, .external_lex_state = 12},
  [726] = {.lex_state = 23, .external_lex_state = 16},
  [727] = {.lex_state = 23, .external_lex_state = 16},
  [728] = {.lex_state = 20, .external_lex_state = 15},
  [729] = {.lex_state = 23, .external_lex_state = 16},
  [730] = {.lex_state = 20, .external_lex_state = 15},
  [731] = {.lex_state = 23, .external_lex_state = 16},
  [732] = {.lex_state = 23, .external_lex_state = 16},
  [733] = {.lex_state = 23, .external_lex_state = 16},
  [734] = {.lex_state = 23, .external_lex_state = 16},
  [735] = {.lex_state = 23, .external_lex_state = 16},
  [736] = {.lex_state = 23, .external_lex_state = 16},
  [737] = {.lex_state = 23, .external_lex_state = 16},
  [738] = {.lex_state = 23, .external_lex_state = 16},
  [739] = {.lex_state = 23, .external_lex_state = 16},
  [740] = {.lex_state = 23, .external_lex_state = 16},
  [741] = {.lex_state = 23, .external_lex_state = 16},
  [742] = {.lex_state = 23, .external_lex_state = 16},
  [743] = {.lex_state = 23, .external_lex_state = 16},
  [744] = {.lex_state = 23, .external_lex_state = 16},
  [745] = {.lex_state = 23, .external_lex_state = 16},
  [746] = {.lex_state = 23, .external_lex_state = 16},
  [747] = {.lex_state = 23, .external_lex_state = 16},
  [748] = {.lex_state = 20, .external_lex_state = 15},
  [749] = {.lex_state = 23, .external_lex_state = 16},
  [750] = {.lex_state = 23, .external_lex_state = 16},
  [751] = {.lex_state = 23, .external_lex_state = 16},
  [752] = {.lex_state = 23, .external_lex_state = 16},
  [753] = {.lex_state = 23, .external_lex_state = 16},
  [754] = {.lex_state = 23, .external_lex_state = 16},
  [755] = {.lex_state = 23, .external_lex_state = 16},
  [756] = {.lex_state = 23, .external_lex_state = 16},
  [757] = {.lex_state = 23, .external_lex_state = 16},
  [758] = {.lex_state = 23, .external_lex_state = 16},
  [759] = {.lex_state = 23, .external_lex_state = 16},
  [760] = {.lex_state = 23, .external_lex_state = 16},
  [761] = {.lex_state = 23, .external_lex_state = 16},
  [762] = {.lex_state = 23, .external_lex_state = 16},
  [763] = {.lex_state = 23, .external_lex_state = 16},
  [764] = {.lex_state = 23, .external_lex_state = 16},
  [765] = {.lex_state = 23, .external_lex_state = 16},
  [766] = {.lex_state = 23, .external_lex_state = 16},
  [767] = {.lex_state = 23, .external_lex_state = 16},
  [768] = {.lex_state = 23, .external_lex_state = 16},
  [769] = {.lex_state = 23, .external_lex_state = 16},
  [770] = {.lex_state = 23, .external_lex_state = 16},
  [771] = {.lex_state = 23, .external_lex_state = 16},
  [772] = {.lex_state = 23, .external_lex_state = 16},
  [773] = {.lex_state = 23, .external_lex_state = 16},
  [774] = {.lex_state = 23, .external_lex_state = 16},
  [775] = {.lex_state = 23, .external_lex_state = 16},
  [776] = {.lex_state = 23, .external_lex_state = 16},
  [777] = {.lex_state = 23, .external_lex_state = 16},
  [778] = {.lex_state = 23, .external_lex_state = 16},
  [779] = {.lex_state = 23, .external_lex_state = 16},
  [780] = {.lex_state = 23, .external_lex_state = 16},
  [781] = {.lex_state = 20, .external_lex_state = 15},
  [782] = {.lex_state = 20, .external_lex_state = 15},
  [783] = {.lex_state = 23, .external_lex_state = 16},
  [784] = {.lex_state = 20, .external_lex_state = 15},
  [785] = {.lex_state = 20, .external_lex_state = 15},
  [786] = {.lex_state = 20, .external_lex_state = 15},
  [787] = {.lex_state = 20, .external_lex_state = 15},
  [788] = {.lex_state = 20, .external_lex_state = 15},
  [789] = {.lex_state = 20, .external_lex_state = 15},
  [790] = {.lex_state = 20, .external_lex_state = 15},
  [791] = {.lex_state = 20, .external_lex_state = 15},
  [792] = {.lex_state = 20, .external_lex_state = 15},
  [793] = {.lex_state = 20, .external_lex_state = 15},
  [794] = {.lex_state = 20, .external_lex_state = 15},
  [795] = {.lex_state = 20, .external_lex_state = 15},
  [796] = {.lex_state = 20, .external_lex_state = 15},
  [797] = {.lex_state = 20, .external_lex_state = 15},
  [798] = {.lex_state = 20, .external_lex_state = 15},
  [799] = {.lex_state = 20, .external_lex_state = 15},
  [800] = {.lex_state = 20, .external_lex_state = 15},
  [801] = {.lex_state = 20, .external_lex_state = 15},
  [802] = {.lex_state = 20, .external_lex_state = 15},
  [803] = {.lex_state = 20, .external_lex_state = 15},
  [804] = {.lex_state = 20, .external_lex_state = 15},
  [805] = {.lex_state = 20, .external_lex_state = 15},
  [806] = {.lex_state = 20, .external_lex_state = 15},
  [807] = {.lex_state = 20, .external_lex_state = 15},
  [808] = {.lex_state = 20, .external_lex_state = 15},
  [809] = {.lex_state = 20, .external_lex_state = 15},
  [810] = {.lex_state = 20, .external_lex_state = 15},
  [811] = {.lex_state = 20, .external_lex_state = 15},
  [812] = {.lex_state = 20, .external_lex_state = 15},
  [813] = {.lex_state = 20, .external_lex_state = 15},
  [814] = {.lex_state = 20, .external_lex_state = 15},
  [815] = {.lex_state = 20, .external_lex_state = 15},
  [816] = {.lex_state = 20, .external_lex_state = 15},
  [817] = {.lex_state = 20, .external_lex_state = 15},
  [818] = {.lex_state = 20, .external_lex_state = 15},
  [819] = {.lex_state = 20, .external_lex_state = 15},
  [820] = {.lex_state = 20, .external_lex_state = 15},
  [821] = {.lex_state = 20, .external_lex_state = 15},
  [822] = {.lex_state = 20, .external_lex_state = 15},
  [823] = {.lex_state = 20, .external_lex_state = 15},
  [824] = {.lex_state = 20, .external_lex_state = 15},
  [825] = {.lex_state = 20, .external_lex_state = 15},
  [826] = {.lex_state = 20, .external_lex_state = 15},
  [827] = {.lex_state = 20, .external_lex_state = 15},
  [828] = {.lex_state = 20, .external_lex_state = 15},
  [829] = {.lex_state = 20, .external_lex_state = 15},
  [830] = {.lex_state = 20, .external_lex_state = 15},
  [831] = {.lex_state = 20, .external_lex_state = 15},
  [832] = {.lex_state = 20, .external_lex_state = 15},
  [833] = {.lex_state = 20, .external_lex_state = 15},
  [834] = {.lex_state = 20, .external_lex_state = 15},
  [835] = {.lex_state = 20, .external_lex_state = 15},
  [836] = {.lex_state = 20, .external_lex_state = 15},
  [837] = {.lex_state = 20, .external_lex_state = 15},
  [838] = {.lex_state = 20, .external_lex_state = 15},
  [839] = {.lex_state = 20, .external_lex_state = 15},
  [840] = {.lex_state = 20, .external_lex_state = 15},
  [841] = {.lex_state = 20, .external_lex_state = 15},
  [842] = {.lex_state = 20, .external_lex_state = 15},
  [843] = {.lex_state = 20, .external_lex_state = 15},
  [844] = {.lex_state = 20, .external_lex_state = 15},
  [845] = {.lex_state = 20, .external_lex_state = 15},
  [846] = {.lex_state = 20, .external_lex_state = 15},
  [847] = {.lex_state = 20, .external_lex_state = 15},
  [848] = {.lex_state = 20, .external_lex_state = 15},
  [849] = {.lex_state = 20, .external_lex_state = 15},
  [850] = {.lex_state = 20, .external_lex_state = 15},
  [851] = {.lex_state = 20, .external_lex_state = 15},
  [852] = {.lex_state = 20, .external_lex_state = 15},
  [853] = {.lex_state = 20, .external_lex_state = 15},
  [854] = {.lex_state = 20, .external_lex_state = 15},
  [855] = {.lex_state = 20, .external_lex_state = 15},
  [856] = {.lex_state = 20, .external_lex_state = 15},
  [857] = {.lex_state = 20, .external_lex_state = 15},
  [858] = {.lex_state = 20, .external_lex_state = 15},
  [859] = {.lex_state = 20, .external_lex_state = 15},
  [860] = {.lex_state = 20, .external_lex_state = 15},
  [861] = {.lex_state = 20, .external_lex_state = 15},
  [862] = {.lex_state = 20, .external_lex_state = 15},
  [863] = {.lex_state = 20, .external_lex_state = 15},
  [864] = {.lex_state = 20, .external_lex_state = 15},
  [865] = {.lex_state = 20, .external_lex_state = 15},
  [866] = {.lex_state = 20, .external_lex_state = 15},
  [867] = {.lex_state = 20, .external_lex_state = 15},
  [868] = {.lex_state = 20, .external_lex_state = 15},
  [869] = {.lex_state = 20, .external_lex_state = 15},
  [870] = {.lex_state = 20, .external_lex_state = 15},
  [871] = {.lex_state = 20, .external_lex_state = 15},
  [872] = {.lex_state = 20, .external_lex_state = 15},
  [873] = {.lex_state = 20, .external_lex_state = 15},
  [874] = {.lex_state = 20, .external_lex_state = 15},
  [875] = {.lex_state = 20, .external_lex_state = 15},
  [876] = {.lex_state = 20, .external_lex_state = 15},
  [877] = {.lex_state = 20, .external_lex_state = 15},
  [878] = {.lex_state = 20, .external_lex_state = 15},
  [879] = {.lex_state = 20, .external_lex_state = 15},
  [880] = {.lex_state = 20, .external_lex_state = 15},
  [881] = {.lex_state = 20, .external_lex_state = 15},
  [882] = {.lex_state = 20, .external_lex_state = 15},
  [883] = {.lex_state = 20, .external_lex_state = 15},
  [884] = {.lex_state = 20, .external_lex_state = 15},
  [885] = {.lex_state = 20, .external_lex_state = 15},
  [886] = {.lex_state = 23, .external_lex_state = 16},
  [887] = {.lex_state = 20, .external_lex_state = 15},
  [888] = {.lex_state = 20, .external_lex_state = 15},
  [889] = {.lex_state = 20, .external_lex_state = 15},
  [890] = {.lex_state = 20, .external_lex_state = 15},
  [891] = {.lex_state = 20, .external_lex_state = 15},
  [892] = {.lex_state = 20, .external_lex_state = 15},
  [893] = {.lex_state = 20, .external_lex_state = 15},
  [894] = {.lex_state = 20, .external_lex_state = 15},
  [895] = {.lex_state = 20, .external_lex_state = 15},
  [896] = {.lex_state = 20, .external_lex_state = 15},
  [897] = {.lex_state = 20, .external_lex_state = 15},
  [898] = {.lex_state = 20, .external_lex_state = 15},
  [899] = {.lex_state = 20, .external_lex_state = 15},
  [900] = {.lex_state = 20, .external_lex_state = 15},
  [901] = {.lex_state = 20, .external_lex_state = 15},
  [902] = {.lex_state = 20, .external_lex_state = 15},
  [903] = {.lex_state = 20, .external_lex_state = 15},
  [904] = {.lex_state = 20, .external_lex_state = 15},
  [905] = {.lex_state = 20, .external_lex_state = 15},
  [906] = {.lex_state = 20, .external_lex_state = 15},
  [907] = {.lex_state = 20, .external_lex_state = 15},
  [908] = {.lex_state = 20, .external_lex_state = 15},
  [909] = {.lex_state = 20, .external_lex_state = 15},
  [910] = {.lex_state = 20, .external_lex_state = 15},
  [911] = {.lex_state = 20, .external_lex_state = 15},
  [912] = {.lex_state = 20, .external_lex_state = 15},
  [913] = {.lex_state = 20, .external_lex_state = 15},
  [914] = {.lex_state = 20, .external_lex_state = 15},
  [915] = {.lex_state = 20, .external_lex_state = 15},
  [916] = {.lex_state = 20, .external_lex_state = 15},
  [917] = {.lex_state = 20, .external_lex_state = 15},
  [918] = {.lex_state = 20, .external_lex_state = 15},
  [919] = {.lex_state = 20, .external_lex_state = 15},
  [920] = {.lex_state = 20, .external_lex_state = 15},
  [921] = {.lex_state = 20, .external_lex_state = 15},
  [922] = {.lex_state = 20, .external_lex_state = 15},
  [923] = {.lex_state = 20, .external_lex_state = 15},
  [924] = {.lex_state = 20, .external_lex_state = 15},
  [925] = {.lex_state = 20, .external_lex_state = 15},
  [926] = {.lex_state = 20, .external_lex_state = 15},
  [927] = {.lex_state = 20, .external_lex_state = 15},
  [928] = {.lex_state = 20, .external_lex_state = 15},
  [929] = {.lex_state = 20, .external_lex_state = 15},
  [930] = {.lex_state = 20, .external_lex_state = 15},
  [931] = {.lex_state = 20, .external_lex_state = 15},
  [932] = {.lex_state = 20, .external_lex_state = 15},
  [933] = {.lex_state = 20, .external_lex_state = 15},
  [934] = {.lex_state = 20, .external_lex_state = 15},
  [935] = {.lex_state = 20, .external_lex_state = 15},
  [936] = {.lex_state = 20, .external_lex_state = 15},
  [937] = {.lex_state = 20, .external_lex_state = 15},
  [938] = {.lex_state = 20, .external_lex_state = 15},
  [939] = {.lex_state = 20, .external_lex_state = 15},
  [940] = {.lex_state = 20, .external_lex_state = 15},
  [941] = {.lex_state = 20, .external_lex_state = 15},
  [942] = {.lex_state = 20, .external_lex_state = 15},
  [943] = {.lex_state = 20, .external_lex_state = 15},
  [944] = {.lex_state = 20, .external_lex_state = 15},
  [945] = {.lex_state = 20, .external_lex_state = 15},
  [946] = {.lex_state = 20, .external_lex_state = 15},
  [947] = {.lex_state = 20, .external_lex_state = 15},
  [948] = {.lex_state = 20, .external_lex_state = 15},
  [949] = {.lex_state = 20, .external_lex_state = 15},
  [950] = {.lex_state = 20, .external_lex_state = 15},
  [951] = {.lex_state = 20, .external_lex_state = 15},
  [952] = {.lex_state = 20, .external_lex_state = 15},
  [953] = {.lex_state = 20, .external_lex_state = 15},
  [954] = {.lex_state = 20, .external_lex_state = 15},
  [955] = {.lex_state = 20, .external_lex_state = 15},
  [956] = {.lex_state = 20, .external_lex_state = 15},
  [957] = {.lex_state = 20, .external_lex_state = 15},
  [958] = {.lex_state = 20, .external_lex_state = 15},
  [959] = {.lex_state = 20, .external_lex_state = 15},
  [960] = {.lex_state = 20, .external_lex_state = 15},
  [961] = {.lex_state = 20, .external_lex_state = 15},
  [962] = {.lex_state = 20, .external_lex_state = 15},
  [963] = {.lex_state = 20, .external_lex_state = 15},
  [964] = {.lex_state = 20, .external_lex_state = 15},
  [965] = {.lex_state = 20, .external_lex_state = 15},
  [966] = {.lex_state = 20, .external_lex_state = 15},
  [967] = {.lex_state = 20, .external_lex_state = 15},
  [968] = {.lex_state = 20, .external_lex_state = 15},
  [969] = {.lex_state = 20, .external_lex_state = 15},
  [970] = {.lex_state = 20, .external_lex_state = 15},
  [971] = {.lex_state = 20, .external_lex_state = 15},
  [972] = {.lex_state = 20, .external_lex_state = 15},
  [973] = {.lex_state = 20, .external_lex_state = 15},
  [974] = {.lex_state = 20, .external_lex_state = 15},
  [975] = {.lex_state = 20, .external_lex_state = 15},
  [976] = {.lex_state = 20, .external_lex_state = 15},
  [977] = {.lex_state = 20, .external_lex_state = 15},
  [978] = {.lex_state = 20, .external_lex_state = 15},
  [979] = {.lex_state = 20, .external_lex_state = 15},
  [980] = {.lex_state = 20, .external_lex_state = 15},
  [981] = {.lex_state = 20, .external_lex_state = 15},
  [982] = {.lex_state = 20, .external_lex_state = 15},
  [983] = {.lex_state = 20, .external_lex_state = 15},
  [984] = {.lex_state = 20, .external_lex_state = 15},
  [985] = {.lex_state = 20, .external_lex_state = 15},
  [986] = {.lex_state = 20, .external_lex_state = 15},
  [987] = {.lex_state = 20, .external_lex_state = 15},
  [988] = {.lex_state = 20, .external_lex_state = 15},
  [989] = {.lex_state = 20, .external_lex_state = 15},
  [990] = {.lex_state = 20, .external_lex_state = 15},
  [991] = {.lex_state = 20, .external_lex_state = 15},
  [992] = {.lex_state = 20, .external_lex_state = 15},
  [993] = {.lex_state = 20, .external_lex_state = 15},
  [994] = {.lex_state = 20, .external_lex_state = 15},
  [995] = {.lex_state = 20, .external_lex_state = 15},
  [996] = {.lex_state = 20, .external_lex_state = 15},
  [997] = {.lex_state = 20, .external_lex_state = 15},
  [998] = {.lex_state = 20, .external_lex_state = 15},
  [999] = {.lex_state = 20, .external_lex_state = 15},
  [1000] = {.lex_state = 20, .external_lex_state = 15},
  [1001] = {.lex_state = 20, .external_lex_state = 15},
  [1002] = {.lex_state = 20, .external_lex_state = 15},
  [1003] = {.lex_state = 20, .external_lex_state = 15},
  [1004] = {.lex_state = 20, .external_lex_state = 15},
  [1005] = {.lex_state = 20, .external_lex_state = 15},
  [1006] = {.lex_state = 20, .external_lex_state = 15},
  [1007] = {.lex_state = 20, .external_lex_state = 15},
  [1008] = {.lex_state = 20, .external_lex_state = 15},
  [1009] = {.lex_state = 20, .external_lex_state = 15},
  [1010] = {.lex_state = 20, .external_lex_state = 15},
  [1011] = {.lex_state = 20, .external_lex_state = 15},
  [1012] = {.lex_state = 20, .external_lex_state = 15},
  [1013] = {.lex_state = 20, .external_lex_state = 15},
  [1014] = {.lex_state = 20, .external_lex_state = 15},
  [1015] = {.lex_state = 20, .external_lex_state = 15},
  [1016] = {.lex_state = 20, .external_lex_state = 15},
  [1017] = {.lex_state = 20, .external_lex_state = 15},
  [1018] = {.lex_state = 20, .external_lex_state = 15},
  [1019] = {.lex_state = 20, .external_lex_state = 15},
  [1020] = {.lex_state = 20, .external_lex_state = 15},
  [1021] = {.lex_state = 23, .external_lex_state = 16},
  [1022] = {.lex_state = 23, .external_lex_state = 16},
  [1023] = {.lex_state = 23, .external_lex_state = 16},
  [1024] = {.lex_state = 23, .external_lex_state = 16},
  [1025] = {.lex_state = 23, .external_lex_state = 16},
  [1026] = {.lex_state = 23, .external_lex_state = 16},
  [1027] = {.lex_state = 23, .external_lex_state = 16},
  [1028] = {.lex_state = 23, .external_lex_state = 16},
  [1029] = {.lex_state = 23, .external_lex_state = 16},
  [1030] = {.lex_state = 23, .external_lex_state = 16},
  [1031] = {.lex_state = 23, .external_lex_state = 16},
  [1032] = {.lex_state = 23, .external_lex_state = 16},
  [1033] = {.lex_state = 23, .external_lex_state = 16},
  [1034] = {.lex_state = 23, .external_lex_state = 16},
  [1035] = {.lex_state = 23, .external_lex_state = 16},
  [1036] = {.lex_state = 23, .external_lex_state = 16},
  [1037] = {.lex_state = 23, .external_lex_state = 16},
  [1038] = {.lex_state = 23, .external_lex_state = 16},
  [1039] = {.lex_state = 23, .external_lex_state = 16},
  [1040] = {.lex_state = 23, .external_lex_state = 16},
  [1041] = {.lex_state = 23, .external_lex_state = 16},
  [1042] = {.lex_state = 23, .external_lex_state = 16},
  [1043] = {.lex_state = 23, .external_lex_state = 16},
  [1044] = {.lex_state = 23, .external_lex_state = 16},
  [1045] = {.lex_state = 23, .external_lex_state = 16},
  [1046] = {.lex_state = 23, .external_lex_state = 16},
  [1047] = {.lex_state = 23, .external_lex_state = 16},
  [1048] = {.lex_state = 23, .external_lex_state = 16},
  [1049] = {.lex_state = 23, .external_lex_state = 16},
  [1050] = {.lex_state = 23, .external_lex_state = 16},
  [1051] = {.lex_state = 23, .external_lex_state = 16},
  [1052] = {.lex_state = 23, .external_lex_state = 16},
  [1053] = {.lex_state = 23, .external_lex_state = 16},
  [1054] = {.lex_state = 23, .external_lex_state = 16},
  [1055] = {.lex_state = 23, .external_lex_state = 16},
  [1056] = {.lex_state = 23, .external_lex_state = 16},
  [1057] = {.lex_state = 23, .external_lex_state = 16},
  [1058] = {.lex_state = 23, .external_lex_state = 16},
  [1059] = {.lex_state = 23, .external_lex_state = 16},
  [1060] = {.lex_state = 23, .external_lex_state = 16},
  [1061] = {.lex_state = 23, .external_lex_state = 16},
  [1062] = {.lex_state = 23, .external_lex_state = 16},
  [1063] = {.lex_state = 23, .external_lex_state = 16},
  [1064] = {.lex_state = 23, .external_lex_state = 16},
  [1065] = {.lex_state = 23, .external_lex_state = 16},
  [1066] = {.lex_state = 23, .external_lex_state = 16},
  [1067] = {.lex_state = 23, .external_lex_state = 16},
  [1068] = {.lex_state = 23, .external_lex_state = 16},
  [1069] = {.lex_state = 23, .external_lex_state = 16},
  [1070] = {.lex_state = 23, .external_lex_state = 16},
  [1071] = {.lex_state = 23, .external_lex_state = 16},
  [1072] = {.lex_state = 23, .external_lex_state = 16},
  [1073] = {.lex_state = 23, .external_lex_state = 16},
  [1074] = {.lex_state = 23, .external_lex_state = 16},
  [1075] = {.lex_state = 23, .external_lex_state = 16},
  [1076] = {.lex_state = 23, .external_lex_state = 16},
  [1077] = {.lex_state = 23, .external_lex_state = 16},
  [1078] = {.lex_state = 23, .external_lex_state = 16},
  [1079] = {.lex_state = 23, .external_lex_state = 16},
  [1080] = {.lex_state = 23, .external_lex_state = 16},
  [1081] = {.lex_state = 23, .external_lex_state = 16},
  [1082] = {.lex_state = 23, .external_lex_state = 16},
  [1083] = {.lex_state = 23, .external_lex_state = 16},
  [1084] = {.lex_state = 23, .external_lex_state = 16},
  [1085] = {.lex_state = 23, .external_lex_state = 16},
  [1086] = {.lex_state = 23, .external_lex_state = 16},
  [1087] = {.lex_state = 23, .external_lex_state = 16},
  [1088] = {.lex_state = 21, .external_lex_state = 19},
  [1089] = {.lex_state = 21, .external_lex_state = 19},
  [1090] = {.lex_state = 21, .external_lex_state = 19},
  [1091] = {.lex_state = 23, .external_lex_state = 16},
  [1092] = {.lex_state = 23, .external_lex_state = 16},
  [1093] = {.lex_state = 23, .external_lex_state = 16},
  [1094] = {.lex_state = 23, .external_lex_state = 16},
  [1095] = {.lex_state = 23, .external_lex_state = 16},
  [1096] = {.lex_state = 23, .external_lex_state = 16},
  [1097] = {.lex_state = 23, .external_lex_state = 16},
  [1098] = {.lex_state = 21, .external_lex_state = 20},
  [1099] = {.lex_state = 23, .external_lex_state = 16},
  [1100] = {.lex_state = 21, .external_lex_state = 20},
  [1101] = {.lex_state = 21, .external_lex_state = 20},
  [1102] = {.lex_state = 23, .external_lex_state = 16},
  [1103] = {.lex_state = 23, .external_lex_state = 16},
  [1104] = {.lex_state = 23, .external_lex_state = 16},
  [1105] = {.lex_state = 23, .external_lex_state = 16},
  [1106] = {.lex_state = 23, .external_lex_state = 16},
  [1107] = {.lex_state = 23, .external_lex_state = 16},
  [1108] = {.lex_state = 23, .external_lex_state = 16},
  [1109] = {.lex_state = 23, .external_lex_state = 16},
  [1110] = {.lex_state = 23, .external_lex_state = 16},
  [1111] = {.lex_state = 23, .external_lex_state = 16},
  [1112] = {.lex_state = 23, .external_lex_state = 16},
  [1113] = {.lex_state = 23, .external_lex_state = 16},
  [1114] = {.lex_state = 23, .external_lex_state = 16},
  [1115] = {.lex_state = 23, .external_lex_state = 16},
  [1116] = {.lex_state = 23, .external_lex_state = 16},
  [1117] = {.lex_state = 23, .external_lex_state = 16},
  [1118] = {.lex_state = 23, .external_lex_state = 16},
  [1119] = {.lex_state = 23, .external_lex_state = 16},
  [1120] = {.lex_state = 23, .external_lex_state = 16},
  [1121] = {.lex_state = 23, .external_lex_state = 16},
  [1122] = {.lex_state = 23, .external_lex_state = 16},
  [1123] = {.lex_state = 23, .external_lex_state = 16},
  [1124] = {.lex_state = 23, .external_lex_state = 16},
  [1125] = {.lex_state = 23, .external_lex_state = 16},
  [1126] = {.lex_state = 23, .external_lex_state = 16},
  [1127] = {.lex_state = 23, .external_lex_state = 16},
  [1128] = {.lex_state = 23, .external_lex_state = 16},
  [1129] = {.lex_state = 23, .external_lex_state = 16},
  [1130] = {.lex_state = 21, .external_lex_state = 16},
  [1131] = {.lex_state = 21, .external_lex_state = 19},
  [1132] = {.lex_state = 21, .external_lex_state = 19},
  [1133] = {.lex_state = 21, .external_lex_state = 19},
  [1134] = {.lex_state = 21, .external_lex_state = 19},
  [1135] = {.lex_state = 21, .external_lex_state = 19},
  [1136] = {.lex_state = 21, .external_lex_state = 19},
  [1137] = {.lex_state = 21, .external_lex_state = 19},
  [1138] = {.lex_state = 23, .external_lex_state = 16},
  [1139] = {.lex_state = 21, .external_lex_state = 19},
  [1140] = {.lex_state = 21, .external_lex_state = 19},
  [1141] = {.lex_state = 21, .external_lex_state = 19},
  [1142] = {.lex_state = 23, .external_lex_state = 16},
  [1143] = {.lex_state = 21, .external_lex_state = 19},
  [1144] = {.lex_state = 21, .external_lex_state = 19},
  [1145] = {.lex_state = 21, .external_lex_state = 19},
  [1146] = {.lex_state = 21, .external_lex_state = 19},
  [1147] = {.lex_state = 21, .external_lex_state = 19},
  [1148] = {.lex_state = 21, .external_lex_state = 19},
  [1149] = {.lex_state = 21, .external_lex_state = 19},
  [1150] = {.lex_state = 21, .external_lex_state = 20},
  [1151] = {.lex_state = 21, .external_lex_state = 20},
  [1152] = {.lex_state = 21, .external_lex_state = 21},
  [1153] = {.lex_state = 21, .external_lex_state = 20},
  [1154] = {.lex_state = 21, .external_lex_state = 20},
  [1155] = {.lex_state = 23, .external_lex_state = 22},
  [1156] = {.lex_state = 21, .external_lex_state = 20},
  [1157] = {.lex_state = 21, .external_lex_state = 20},
  [1158] = {.lex_state = 23, .external_lex_state = 3},
  [1159] = {.lex_state = 21, .external_lex_state = 20},
  [1160] = {.lex_state = 21, .external_lex_state = 20},
  [1161] = {.lex_state = 21, .external_lex_state = 23},
  [1162] = {.lex_state = 21, .external_lex_state = 23},
  [1163] = {.lex_state = 21, .external_lex_state = 23},
  [1164] = {.lex_state = 21, .external_lex_state = 20},
  [1165] = {.lex_state = 21, .external_lex_state = 20},
  [1166] = {.lex_state = 21, .external_lex_state = 20},
  [1167] = {.lex_state = 21, .external_lex_state = 20},
  [1168] = {.lex_state = 21, .external_lex_state = 20},
  [1169] = {.lex_state = 21, .external_lex_state = 21},
  [1170] = {.lex_state = 21, .external_lex_state = 21},
  [1171] = {.lex_state = 21, .external_lex_state = 20},
  [1172] = {.lex_state = 21, .external_lex_state = 20},
  [1173] = {.lex_state = 21, .external_lex_state = 20},
  [1174] = {.lex_state = 23, .external_lex_state = 24},
  [1175] = {.lex_state = 21, .external_lex_state = 22},
  [1176] = {.lex_state = 21, .external_lex_state = 3},
  [1177] = {.lex_state = 21, .external_lex_state = 25},
  [1178] = {.lex_state = 21, .external_lex_state = 25},
  [1179] = {.lex_state = 21, .external_lex_state = 26},
  [1180] = {.lex_state = 21, .external_lex_state = 27},
  [1181] = {.lex_state = 21, .external_lex_state = 27},
  [1182] = {.lex_state = 21, .external_lex_state = 27},
  [1183] = {.lex_state = 21, .external_lex_state = 22},
  [1184] = {.lex_state = 21, .external_lex_state = 19},
  [1185] = {.lex_state = 21, .external_lex_state = 16},
  [1186] = {.lex_state = 21, .external_lex_state = 25},
  [1187] = {.lex_state = 21, .external_lex_state = 28},
  [1188] = {.lex_state = 21, .external_lex_state = 23},
  [1189] = {.lex_state = 21, .external_lex_state = 22},
  [1190] = {.lex_state = 21, .external_lex_state = 23},
  [1191] = {.lex_state = 21, .external_lex_state = 22},
  [1192] = {.lex_state = 21, .external_lex_state = 21},
  [1193] = {.lex_state = 21, .external_lex_state = 21},
  [1194] = {.lex_state = 21, .external_lex_state = 16},
  [1195] = {.lex_state = 21, .external_lex_state = 22},
  [1196] = {.lex_state = 21, .external_lex_state = 16},
  [1197] = {.lex_state = 21, .external_lex_state = 3},
  [1198] = {.lex_state = 21, .external_lex_state = 16},
  [1199] = {.lex_state = 21, .external_lex_state = 3},
  [1200] = {.lex_state = 21, .external_lex_state = 16},
  [1201] = {.lex_state = 21, .external_lex_state = 16},
  [1202] = {.lex_state = 21, .external_lex_state = 16},
  [1203] = {.lex_state = 21, .external_lex_state = 23},
  [1204] = {.lex_state = 21, .external_lex_state = 22},
  [1205] = {.lex_state = 21, .external_lex_state = 16},
  [1206] = {.lex_state = 21, .external_lex_state = 16},
  [1207] = {.lex_state = 21, .external_lex_state = 24},
  [1208] = {.lex_state = 21, .external_lex_state = 16},
  [1209] = {.lex_state = 21, .external_lex_state = 16},
  [1210] = {.lex_state = 21, .external_lex_state = 22},
  [1211] = {.lex_state = 21, .external_lex_state = 22},
  [1212] = {.lex_state = 21, .external_lex_state = 21},
  [1213] = {.lex_state = 21, .external_lex_state = 16},
  [1214] = {.lex_state = 21, .external_lex_state = 21},
  [1215] = {.lex_state = 21, .external_lex_state = 16},
  [1216] = {.lex_state = 21, .external_lex_state = 22},
  [1217] = {.lex_state = 21, .external_lex_state = 23},
  [1218] = {.lex_state = 21, .external_lex_state = 22},
  [1219] = {.lex_state = 21, .external_lex_state = 23},
  [1220] = {.lex_state = 21, .external_lex_state = 16},
  [1221] = {.lex_state = 21, .external_lex_state = 23},
  [1222] = {.lex_state = 21, .external_lex_state = 16},
  [1223] = {.lex_state = 21, .external_lex_state = 22},
  [1224] = {.lex_state = 21, .external_lex_state = 20},
  [1225] = {.lex_state = 21, .external_lex_state = 22},
  [1226] = {.lex_state = 21, .external_lex_state = 23},
  [1227] = {.lex_state = 21, .external_lex_state = 22},
  [1228] = {.lex_state = 21, .external_lex_state = 21},
  [1229] = {.lex_state = 21, .external_lex_state = 16},
  [1230] = {.lex_state = 21, .external_lex_state = 24},
  [1231] = {.lex_state = 21, .external_lex_state = 21},
  [1232] = {.lex_state = 21, .external_lex_state = 28},
  [1233] = {.lex_state = 21, .external_lex_state = 29},
  [1234] = {.lex_state = 21, .external_lex_state = 16},
  [1235] = {.lex_state = 21, .external_lex_state = 28},
  [1236] = {.lex_state = 21, .external_lex_state = 22},
  [1237] = {.lex_state = 21, .external_lex_state = 16},
  [1238] = {.lex_state = 23, .external_lex_state = 4},
  [1239] = {.lex_state = 21, .external_lex_state = 29},
  [1240] = {.lex_state = 21, .external_lex_state = 23},
  [1241] = {.lex_state = 21, .external_lex_state = 21},
  [1242] = {.lex_state = 21, .external_lex_state = 21},
  [1243] = {.lex_state = 21, .external_lex_state = 23},
  [1244] = {.lex_state = 21, .external_lex_state = 16},
  [1245] = {.lex_state = 21, .external_lex_state = 21},
  [1246] = {.lex_state = 21, .external_lex_state = 16},
  [1247] = {.lex_state = 21, .external_lex_state = 22},
  [1248] = {.lex_state = 21, .external_lex_state = 21},
  [1249] = {.lex_state = 21, .external_lex_state = 22},
  [1250] = {.lex_state = 21, .external_lex_state = 21},
  [1251] = {.lex_state = 21, .external_lex_state = 23},
  [1252] = {.lex_state = 21, .external_lex_state = 16},
  [1253] = {.lex_state = 21, .external_lex_state = 21},
  [1254] = {.lex_state = 21, .external_lex_state = 21},
  [1255] = {.lex_state = 23, .external_lex_state = 2},
  [1256] = {.lex_state = 21, .external_lex_state = 22},
  [1257] = {.lex_state = 21, .external_lex_state = 23},
  [1258] = {.lex_state = 21, .external_lex_state = 22},
  [1259] = {.lex_state = 21, .external_lex_state = 22},
  [1260] = {.lex_state = 21, .external_lex_state = 16},
  [1261] = {.lex_state = 21, .external_lex_state = 16},
  [1262] = {.lex_state = 21, .external_lex_state = 16},
  [1263] = {.lex_state = 21, .external_lex_state = 23},
  [1264] = {.lex_state = 23, .external_lex_state = 5},
  [1265] = {.lex_state = 21, .external_lex_state = 16},
  [1266] = {.lex_state = 21, .external_lex_state = 16},
  [1267] = {.lex_state = 21, .external_lex_state = 23},
  [1268] = {.lex_state = 21, .external_lex_state = 22},
  [1269] = {.lex_state = 21, .external_lex_state = 22},
  [1270] = {.lex_state = 21, .external_lex_state = 16},
  [1271] = {.lex_state = 21, .external_lex_state = 16},
  [1272] = {.lex_state = 21, .external_lex_state = 16},
  [1273] = {.lex_state = 21, .external_lex_state = 22},
  [1274] = {.lex_state = 21, .external_lex_state = 21},
  [1275] = {.lex_state = 21, .external_lex_state = 16},
  [1276] = {.lex_state = 21, .external_lex_state = 16},
  [1277] = {.lex_state = 21, .external_lex_state = 22},
  [1278] = {.lex_state = 21, .external_lex_state = 23},
  [1279] = {.lex_state = 21, .external_lex_state = 23},
  [1280] = {.lex_state = 21, .external_lex_state = 16},
  [1281] = {.lex_state = 21, .external_lex_state = 22},
  [1282] = {.lex_state = 21, .external_lex_state = 23},
  [1283] = {.lex_state = 21, .external_lex_state = 22},
  [1284] = {.lex_state = 21, .external_lex_state = 22},
  [1285] = {.lex_state = 21, .external_lex_state = 22},
  [1286] = {.lex_state = 21, .external_lex_state = 22},
  [1287] = {.lex_state = 21, .external_lex_state = 21},
  [1288] = {.lex_state = 21, .external_lex_state = 22},
  [1289] = {.lex_state = 21, .external_lex_state = 22},
  [1290] = {.lex_state = 21, .external_lex_state = 16},
  [1291] = {.lex_state = 21, .external_lex_state = 16},
  [1292] = {.lex_state = 21, .external_lex_state = 21},
  [1293] = {.lex_state = 21, .external_lex_state = 29},
  [1294] = {.lex_state = 21, .external_lex_state = 22},
  [1295] = {.lex_state = 21, .external_lex_state = 4},
  [1296] = {.lex_state = 23, .external_lex_state = 30},
  [1297] = {.lex_state = 21, .external_lex_state = 5},
  [1298] = {.lex_state = 23, .external_lex_state = 31},
  [1299] = {.lex_state = 21, .external_lex_state = 27},
  [1300] = {.lex_state = 21, .external_lex_state = 27},
  [1301] = {.lex_state = 21, .external_lex_state = 27},
  [1302] = {.lex_state = 21, .external_lex_state = 27},
  [1303] = {.lex_state = 21, .external_lex_state = 27},
  [1304] = {.lex_state = 21, .external_lex_state = 27},
  [1305] = {.lex_state = 21, .external_lex_state = 32},
  [1306] = {.lex_state = 21, .external_lex_state = 25},
  [1307] = {.lex_state = 21, .external_lex_state = 25},
  [1308] = {.lex_state = 21, .external_lex_state = 27},
  [1309] = {.lex_state = 21, .external_lex_state = 25},
  [1310] = {.lex_state = 21, .external_lex_state = 25},
  [1311] = {.lex_state = 21, .external_lex_state = 33},
  [1312] = {.lex_state = 21, .external_lex_state = 26},
  [1313] = {.lex_state = 21, .external_lex_state = 26},
  [1314] = {.lex_state = 21, .external_lex_state = 26},
  [1315] = {.lex_state = 21, .external_lex_state = 26},
  [1316] = {.lex_state = 21, .external_lex_state = 26},
  [1317] = {.lex_state = 21, .external_lex_state = 2},
  [1318] = {.lex_state = 21, .external_lex_state = 24},
  [1319] = {.lex_state = 21, .external_lex_state = 24},
  [1320] = {.lex_state = 21, .external_lex_state = 27},
  [1321] = {.lex_state = 21, .external_lex_state = 27},
  [1322] = {.lex_state = 21, .external_lex_state = 27},
  [1323] = {.lex_state = 21, .external_lex_state = 27},
  [1324] = {.lex_state = 21, .external_lex_state = 27},
  [1325] = {.lex_state = 21, .external_lex_state = 24},
  [1326] = {.lex_state = 21, .external_lex_state = 24},
  [1327] = {.lex_state = 21, .external_lex_state = 24},
  [1328] = {.lex_state = 21, .external_lex_state = 24},
  [1329] = {.lex_state = 21, .external_lex_state = 24},
  [1330] = {.lex_state = 21, .external_lex_state = 24},
  [1331] = {.lex_state = 21, .external_lex_state = 24},
  [1332] = {.lex_state = 21, .external_lex_state = 24},
  [1333] = {.lex_state = 21, .external_lex_state = 24},
  [1334] = {.lex_state = 21, .external_lex_state = 24},
  [1335] = {.lex_state = 21, .external_lex_state = 24},
  [1336] = {.lex_state = 21, .external_lex_state = 24},
  [1337] = {.lex_state = 21, .external_lex_state = 24},
  [1338] = {.lex_state = 21, .external_lex_state = 24},
  [1339] = {.lex_state = 21, .external_lex_state = 24},
  [1340] = {.lex_state = 21, .external_lex_state = 24},
  [1341] = {.lex_state = 21, .external_lex_state = 24},
  [1342] = {.lex_state = 21, .external_lex_state = 24},
  [1343] = {.lex_state = 21, .external_lex_state = 24},
  [1344] = {.lex_state = 21, .external_lex_state = 24},
  [1345] = {.lex_state = 21, .external_lex_state = 24},
  [1346] = {.lex_state = 21, .external_lex_state = 24},
  [1347] = {.lex_state = 21, .external_lex_state = 24},
  [1348] = {.lex_state = 21, .external_lex_state = 3},
  [1349] = {.lex_state = 21, .external_lex_state = 3},
  [1350] = {.lex_state = 21, .external_lex_state = 3},
  [1351] = {.lex_state = 21, .external_lex_state = 3},
  [1352] = {.lex_state = 21, .external_lex_state = 3},
  [1353] = {.lex_state = 21, .external_lex_state = 3},
  [1354] = {.lex_state = 21, .external_lex_state = 3},
  [1355] = {.lex_state = 21, .external_lex_state = 3},
  [1356] = {.lex_state = 21, .external_lex_state = 3},
  [1357] = {.lex_state = 21, .external_lex_state = 3},
  [1358] = {.lex_state = 21, .external_lex_state = 3},
  [1359] = {.lex_state = 21, .external_lex_state = 3},
  [1360] = {.lex_state = 21, .external_lex_state = 3},
  [1361] = {.lex_state = 21, .external_lex_state = 3},
  [1362] = {.lex_state = 21, .external_lex_state = 3},
  [1363] = {.lex_state = 21, .external_lex_state = 3},
  [1364] = {.lex_state = 21, .external_lex_state = 3},
  [1365] = {.lex_state = 21, .external_lex_state = 3},
  [1366] = {.lex_state = 21, .external_lex_state = 3},
  [1367] = {.lex_state = 21, .external_lex_state = 3},
  [1368] = {.lex_state = 21, .external_lex_state = 3},
  [1369] = {.lex_state = 21, .external_lex_state = 3},
  [1370] = {.lex_state = 21, .external_lex_state = 3},
  [1371] = {.lex_state = 21, .external_lex_state = 3},
  [1372] = {.lex_state = 21, .external_lex_state = 3},
  [1373] = {.lex_state = 21, .external_lex_state = 26},
  [1374] = {.lex_state = 21, .external_lex_state = 26},
  [1375] = {.lex_state = 21, .external_lex_state = 34},
  [1376] = {.lex_state = 21, .external_lex_state = 27},
  [1377] = {.lex_state = 21, .external_lex_state = 27},
  [1378] = {.lex_state = 21, .external_lex_state = 24},
  [1379] = {.lex_state = 21, .external_lex_state = 24},
  [1380] = {.lex_state = 21, .external_lex_state = 26},
  [1381] = {.lex_state = 21, .external_lex_state = 26},
  [1382] = {.lex_state = 21, .external_lex_state = 27},
  [1383] = {.lex_state = 21, .external_lex_state = 27},
  [1384] = {.lex_state = 21, .external_lex_state = 3},
  [1385] = {.lex_state = 21, .external_lex_state = 3},
  [1386] = {.lex_state = 21, .external_lex_state = 25},
  [1387] = {.lex_state = 21, .external_lex_state = 25},
  [1388] = {.lex_state = 21, .external_lex_state = 25},
  [1389] = {.lex_state = 21, .external_lex_state = 25},
  [1390] = {.lex_state = 21, .external_lex_state = 25},
  [1391] = {.lex_state = 21, .external_lex_state = 25},
  [1392] = {.lex_state = 21, .external_lex_state = 25},
  [1393] = {.lex_state = 21, .external_lex_state = 25},
  [1394] = {.lex_state = 21, .external_lex_state = 25},
  [1395] = {.lex_state = 21, .external_lex_state = 25},
  [1396] = {.lex_state = 21, .external_lex_state = 25},
  [1397] = {.lex_state = 21, .external_lex_state = 25},
  [1398] = {.lex_state = 21, .external_lex_state = 24},
  [1399] = {.lex_state = 21, .external_lex_state = 29},
  [1400] = {.lex_state = 21, .external_lex_state = 28},
  [1401] = {.lex_state = 21, .external_lex_state = 28},
  [1402] = {.lex_state = 21, .external_lex_state = 28},
  [1403] = {.lex_state = 21, .external_lex_state = 28},
  [1404] = {.lex_state = 21, .external_lex_state = 2},
  [1405] = {.lex_state = 21, .external_lex_state = 2},
  [1406] = {.lex_state = 23, .external_lex_state = 35},
  [1407] = {.lex_state = 21, .external_lex_state = 28},
  [1408] = {.lex_state = 21, .external_lex_state = 29},
  [1409] = {.lex_state = 21, .external_lex_state = 28},
  [1410] = {.lex_state = 21, .external_lex_state = 31},
  [1411] = {.lex_state = 21, .external_lex_state = 28},
  [1412] = {.lex_state = 21, .external_lex_state = 28},
  [1413] = {.lex_state = 21, .external_lex_state = 4},
  [1414] = {.lex_state = 21, .external_lex_state = 30},
  [1415] = {.lex_state = 21, .external_lex_state = 28},
  [1416] = {.lex_state = 21, .external_lex_state = 28},
  [1417] = {.lex_state = 21, .external_lex_state = 29},
  [1418] = {.lex_state = 21, .external_lex_state = 28},
  [1419] = {.lex_state = 21, .external_lex_state = 29},
  [1420] = {.lex_state = 21, .external_lex_state = 29},
  [1421] = {.lex_state = 21, .external_lex_state = 29},
  [1422] = {.lex_state = 21, .external_lex_state = 29},
  [1423] = {.lex_state = 21, .external_lex_state = 23},
  [1424] = {.lex_state = 21, .external_lex_state = 28},
  [1425] = {.lex_state = 21, .external_lex_state = 31},
  [1426] = {.lex_state = 21, .external_lex_state = 29},
  [1427] = {.lex_state = 21, .external_lex_state = 29},
  [1428] = {.lex_state = 21, .external_lex_state = 5},
  [1429] = {.lex_state = 21, .external_lex_state = 29},
  [1430] = {.lex_state = 21, .external_lex_state = 5},
  [1431] = {.lex_state = 21, .external_lex_state = 24},
  [1432] = {.lex_state = 21, .external_lex_state = 29},
  [1433] = {.lex_state = 21, .external_lex_state = 29},
  [1434] = {.lex_state = 21, .external_lex_state = 28},
  [1435] = {.lex_state = 21, .external_lex_state = 29},
  [1436] = {.lex_state = 21, .external_lex_state = 21},
  [1437] = {.lex_state = 21, .external_lex_state = 29},
  [1438] = {.lex_state = 23, .external_lex_state = 36},
  [1439] = {.lex_state = 21, .external_lex_state = 4},
  [1440] = {.lex_state = 21, .external_lex_state = 28},
  [1441] = {.lex_state = 21, .external_lex_state = 28},
  [1442] = {.lex_state = 21, .external_lex_state = 29},
  [1443] = {.lex_state = 21, .external_lex_state = 30},
  [1444] = {.lex_state = 21, .external_lex_state = 28},
  [1445] = {.lex_state = 21, .external_lex_state = 29},
  [1446] = {.lex_state = 21, .external_lex_state = 30},
  [1447] = {.lex_state = 21, .external_lex_state = 22},
  [1448] = {.lex_state = 21, .external_lex_state = 5},
  [1449] = {.lex_state = 21, .external_lex_state = 5},
  [1450] = {.lex_state = 21, .external_lex_state = 5},
  [1451] = {.lex_state = 21, .external_lex_state = 5},
  [1452] = {.lex_state = 21, .external_lex_state = 5},
  [1453] = {.lex_state = 21, .external_lex_state = 5},
  [1454] = {.lex_state = 21, .external_lex_state = 5},
  [1455] = {.lex_state = 21, .external_lex_state = 5},
  [1456] = {.lex_state = 21, .external_lex_state = 5},
  [1457] = {.lex_state = 21, .external_lex_state = 5},
  [1458] = {.lex_state = 21, .external_lex_state = 5},
  [1459] = {.lex_state = 21, .external_lex_state = 5},
  [1460] = {.lex_state = 21, .external_lex_state = 5},
  [1461] = {.lex_state = 21, .external_lex_state = 5},
  [1462] = {.lex_state = 21, .external_lex_state = 5},
  [1463] = {.lex_state = 21, .external_lex_state = 5},
  [1464] = {.lex_state = 21, .external_lex_state = 5},
  [1465] = {.lex_state = 21, .external_lex_state = 5},
  [1466] = {.lex_state = 21, .external_lex_state = 5},
  [1467] = {.lex_state = 21, .external_lex_state = 22},
  [1468] = {.lex_state = 21, .external_lex_state = 5},
  [1469] = {.lex_state = 21, .external_lex_state = 5},
  [1470] = {.lex_state = 21, .external_lex_state = 5},
  [1471] = {.lex_state = 21, .external_lex_state = 5},
  [1472] = {.lex_state = 21, .external_lex_state = 22},
  [1473] = {.lex_state = 21, .external_lex_state = 16},
  [1474] = {.lex_state = 21, .external_lex_state = 30},
  [1475] = {.lex_state = 21, .external_lex_state = 4},
  [1476] = {.lex_state = 21, .external_lex_state = 30},
  [1477] = {.lex_state = 21, .external_lex_state = 30},
  [1478] = {.lex_state = 21, .external_lex_state = 30},
  [1479] = {.lex_state = 21, .external_lex_state = 30},
  [1480] = {.lex_state = 21, .external_lex_state = 30},
  [1481] = {.lex_state = 21, .external_lex_state = 34},
  [1482] = {.lex_state = 21, .external_lex_state = 34},
  [1483] = {.lex_state = 21, .external_lex_state = 30},
  [1484] = {.lex_state = 21, .external_lex_state = 34},
  [1485] = {.lex_state = 21, .external_lex_state = 34},
  [1486] = {.lex_state = 21, .external_lex_state = 22},
  [1487] = {.lex_state = 21, .external_lex_state = 22},
  [1488] = {.lex_state = 21, .external_lex_state = 22},
  [1489] = {.lex_state = 21, .external_lex_state = 22},
  [1490] = {.lex_state = 21, .external_lex_state = 22},
  [1491] = {.lex_state = 21, .external_lex_state = 22},
  [1492] = {.lex_state = 21, .external_lex_state = 22},
  [1493] = {.lex_state = 21, .external_lex_state = 22},
  [1494] = {.lex_state = 21, .external_lex_state = 22},
  [1495] = {.lex_state = 21, .external_lex_state = 22},
  [1496] = {.lex_state = 21, .external_lex_state = 16},
  [1497] = {.lex_state = 21, .external_lex_state = 30},
  [1498] = {.lex_state = 21, .external_lex_state = 22},
  [1499] = {.lex_state = 21, .external_lex_state = 30},
  [1500] = {.lex_state = 21, .external_lex_state = 22},
  [1501] = {.lex_state = 21, .external_lex_state = 22},
  [1502] = {.lex_state = 21, .external_lex_state = 22},
  [1503] = {.lex_state = 21, .external_lex_state = 22},
  [1504] = {.lex_state = 21, .external_lex_state = 22},
  [1505] = {.lex_state = 21, .external_lex_state = 22},
  [1506] = {.lex_state = 23, .external_lex_state = 37},
  [1507] = {.lex_state = 21, .external_lex_state = 22},
  [1508] = {.lex_state = 21, .external_lex_state = 22},
  [1509] = {.lex_state = 21, .external_lex_state = 22},
  [1510] = {.lex_state = 21, .external_lex_state = 22},
  [1511] = {.lex_state = 21, .external_lex_state = 22},
  [1512] = {.lex_state = 21, .external_lex_state = 22},
  [1513] = {.lex_state = 21, .external_lex_state = 4},
  [1514] = {.lex_state = 21, .external_lex_state = 4},
  [1515] = {.lex_state = 21, .external_lex_state = 16},
  [1516] = {.lex_state = 21, .external_lex_state = 30},
  [1517] = {.lex_state = 21, .external_lex_state = 2},
  [1518] = {.lex_state = 21, .external_lex_state = 2},
  [1519] = {.lex_state = 21, .external_lex_state = 2},
  [1520] = {.lex_state = 21, .external_lex_state = 2},
  [1521] = {.lex_state = 21, .external_lex_state = 2},
  [1522] = {.lex_state = 21, .external_lex_state = 35},
  [1523] = {.lex_state = 21, .external_lex_state = 35},
  [1524] = {.lex_state = 21, .external_lex_state = 5},
  [1525] = {.lex_state = 21, .external_lex_state = 5},
  [1526] = {.lex_state = 21, .external_lex_state = 2},
  [1527] = {.lex_state = 21, .external_lex_state = 16},
  [1528] = {.lex_state = 21, .external_lex_state = 2},
  [1529] = {.lex_state = 21, .external_lex_state = 2},
  [1530] = {.lex_state = 21, .external_lex_state = 24},
  [1531] = {.lex_state = 21, .external_lex_state = 32},
  [1532] = {.lex_state = 21, .external_lex_state = 33},
  [1533] = {.lex_state = 21, .external_lex_state = 16},
  [1534] = {.lex_state = 21, .external_lex_state = 33},
  [1535] = {.lex_state = 21, .external_lex_state = 30},
  [1536] = {.lex_state = 21, .external_lex_state = 30},
  [1537] = {.lex_state = 21, .external_lex_state = 2},
  [1538] = {.lex_state = 21, .external_lex_state = 30},
  [1539] = {.lex_state = 21, .external_lex_state = 4},
  [1540] = {.lex_state = 21, .external_lex_state = 16},
  [1541] = {.lex_state = 21, .external_lex_state = 16},
  [1542] = {.lex_state = 21, .external_lex_state = 30},
  [1543] = {.lex_state = 21, .external_lex_state = 4},
  [1544] = {.lex_state = 21, .external_lex_state = 4},
  [1545] = {.lex_state = 21, .external_lex_state = 4},
  [1546] = {.lex_state = 21, .external_lex_state = 4},
  [1547] = {.lex_state = 21, .external_lex_state = 30},
  [1548] = {.lex_state = 21, .external_lex_state = 2},
  [1549] = {.lex_state = 21, .external_lex_state = 2},
  [1550] = {.lex_state = 21, .external_lex_state = 4},
  [1551] = {.lex_state = 21, .external_lex_state = 30},
  [1552] = {.lex_state = 21, .external_lex_state = 30},
  [1553] = {.lex_state = 21, .external_lex_state = 2},
  [1554] = {.lex_state = 21, .external_lex_state = 2},
  [1555] = {.lex_state = 21, .external_lex_state = 4},
  [1556] = {.lex_state = 21, .external_lex_state = 22},
  [1557] = {.lex_state = 21, .external_lex_state = 2},
  [1558] = {.lex_state = 21, .external_lex_state = 2},
  [1559] = {.lex_state = 21, .external_lex_state = 16},
  [1560] = {.lex_state = 21, .external_lex_state = 2},
  [1561] = {.lex_state = 21, .external_lex_state = 2},
  [1562] = {.lex_state = 21, .external_lex_state = 2},
  [1563] = {.lex_state = 21, .external_lex_state = 2},
  [1564] = {.lex_state = 21, .external_lex_state = 16},
  [1565] = {.lex_state = 21, .external_lex_state = 4},
  [1566] = {.lex_state = 21, .external_lex_state = 4},
  [1567] = {.lex_state = 21, .external_lex_state = 4},
  [1568] = {.lex_state = 21, .external_lex_state = 4},
  [1569] = {.lex_state = 21, .external_lex_state = 30},
  [1570] = {.lex_state = 21, .external_lex_state = 4},
  [1571] = {.lex_state = 21, .external_lex_state = 30},
  [1572] = {.lex_state = 21, .external_lex_state = 4},
  [1573] = {.lex_state = 21, .external_lex_state = 30},
  [1574] = {.lex_state = 21, .external_lex_state = 4},
  [1575] = {.lex_state = 21, .external_lex_state = 4},
  [1576] = {.lex_state = 21, .external_lex_state = 4},
  [1577] = {.lex_state = 21, .external_lex_state = 4},
  [1578] = {.lex_state = 21, .external_lex_state = 16},
  [1579] = {.lex_state = 21, .external_lex_state = 4},
  [1580] = {.lex_state = 21, .external_lex_state = 4},
  [1581] = {.lex_state = 21, .external_lex_state = 33},
  [1582] = {.lex_state = 21, .external_lex_state = 4},
  [1583] = {.lex_state = 21, .external_lex_state = 22},
  [1584] = {.lex_state = 21, .external_lex_state = 31},
  [1585] = {.lex_state = 21, .external_lex_state = 22},
  [1586] = {.lex_state = 21, .external_lex_state = 32},
  [1587] = {.lex_state = 21, .external_lex_state = 32},
  [1588] = {.lex_state = 21, .external_lex_state = 2},
  [1589] = {.lex_state = 21, .external_lex_state = 2},
  [1590] = {.lex_state = 21, .external_lex_state = 2},
  [1591] = {.lex_state = 21, .external_lex_state = 2},
  [1592] = {.lex_state = 21, .external_lex_state = 16},
  [1593] = {.lex_state = 21, .external_lex_state = 31},
  [1594] = {.lex_state = 21, .external_lex_state = 22},
  [1595] = {.lex_state = 21, .external_lex_state = 32},
  [1596] = {.lex_state = 21, .external_lex_state = 30},
  [1597] = {.lex_state = 21, .external_lex_state = 31},
  [1598] = {.lex_state = 21, .external_lex_state = 4},
  [1599] = {.lex_state = 21, .external_lex_state = 31},
  [1600] = {.lex_state = 21, .external_lex_state = 4},
  [1601] = {.lex_state = 21, .external_lex_state = 31},
  [1602] = {.lex_state = 21, .external_lex_state = 31},
  [1603] = {.lex_state = 21, .external_lex_state = 31},
  [1604] = {.lex_state = 21, .external_lex_state = 31},
  [1605] = {.lex_state = 21, .external_lex_state = 31},
  [1606] = {.lex_state = 21, .external_lex_state = 33},
  [1607] = {.lex_state = 21, .external_lex_state = 5},
  [1608] = {.lex_state = 21, .external_lex_state = 25},
  [1609] = {.lex_state = 21, .external_lex_state = 31},
  [1610] = {.lex_state = 21, .external_lex_state = 16},
  [1611] = {.lex_state = 21, .external_lex_state = 16},
  [1612] = {.lex_state = 21, .external_lex_state = 31},
  [1613] = {.lex_state = 21, .external_lex_state = 30},
  [1614] = {.lex_state = 21, .external_lex_state = 31},
  [1615] = {.lex_state = 21, .external_lex_state = 33},
  [1616] = {.lex_state = 21, .external_lex_state = 33},
  [1617] = {.lex_state = 21, .external_lex_state = 31},
  [1618] = {.lex_state = 21, .external_lex_state = 33},
  [1619] = {.lex_state = 21, .external_lex_state = 31},
  [1620] = {.lex_state = 21, .external_lex_state = 22},
  [1621] = {.lex_state = 21, .external_lex_state = 16},
  [1622] = {.lex_state = 21, .external_lex_state = 31},
  [1623] = {.lex_state = 21, .external_lex_state = 16},
  [1624] = {.lex_state = 21, .external_lex_state = 33},
  [1625] = {.lex_state = 21, .external_lex_state = 16},
  [1626] = {.lex_state = 21, .external_lex_state = 16},
  [1627] = {.lex_state = 21, .external_lex_state = 16},
  [1628] = {.lex_state = 21, .external_lex_state = 16},
  [1629] = {.lex_state = 21, .external_lex_state = 31},
  [1630] = {.lex_state = 21, .external_lex_state = 33},
  [1631] = {.lex_state = 21, .external_lex_state = 2},
  [1632] = {.lex_state = 21, .external_lex_state = 16},
  [1633] = {.lex_state = 21, .external_lex_state = 16},
  [1634] = {.lex_state = 21, .external_lex_state = 16},
  [1635] = {.lex_state = 21, .external_lex_state = 2},
  [1636] = {.lex_state = 21, .external_lex_state = 2},
  [1637] = {.lex_state = 21, .external_lex_state = 16},
  [1638] = {.lex_state = 21, .external_lex_state = 16},
  [1639] = {.lex_state = 21, .external_lex_state = 16},
  [1640] = {.lex_state = 21, .external_lex_state = 2},
  [1641] = {.lex_state = 21, .external_lex_state = 16},
  [1642] = {.lex_state = 21, .external_lex_state = 16},
  [1643] = {.lex_state = 21, .external_lex_state = 16},
  [1644] = {.lex_state = 21, .external_lex_state = 16},
  [1645] = {.lex_state = 21, .external_lex_state = 16},
  [1646] = {.lex_state = 21, .external_lex_state = 16},
  [1647] = {.lex_state = 21, .external_lex_state = 16},
  [1648] = {.lex_state = 21, .external_lex_state = 16},
  [1649] = {.lex_state = 21, .external_lex_state = 22},
  [1650] = {.lex_state = 21, .external_lex_state = 16},
  [1651] = {.lex_state = 21, .external_lex_state = 16},
  [1652] = {.lex_state = 21, .external_lex_state = 16},
  [1653] = {.lex_state = 21, .external_lex_state = 22},
  [1654] = {.lex_state = 21, .external_lex_state = 22},
  [1655] = {.lex_state = 21, .external_lex_state = 16},
  [1656] = {.lex_state = 21, .external_lex_state = 30},
  [1657] = {.lex_state = 21, .external_lex_state = 30},
  [1658] = {.lex_state = 21, .external_lex_state = 22},
  [1659] = {.lex_state = 21, .external_lex_state = 31},
  [1660] = {.lex_state = 21, .external_lex_state = 3},
  [1661] = {.lex_state = 21, .external_lex_state = 16},
  [1662] = {.lex_state = 21, .external_lex_state = 31},
  [1663] = {.lex_state = 21, .external_lex_state = 31},
  [1664] = {.lex_state = 21, .external_lex_state = 16},
  [1665] = {.lex_state = 21, .external_lex_state = 16},
  [1666] = {.lex_state = 21, .external_lex_state = 31},
  [1667] = {.lex_state = 21, .external_lex_state = 31},
  [1668] = {.lex_state = 21, .external_lex_state = 31},
  [1669] = {.lex_state = 21, .external_lex_state = 30},
  [1670] = {.lex_state = 21, .external_lex_state = 31},
  [1671] = {.lex_state = 21, .external_lex_state = 16},
  [1672] = {.lex_state = 21, .external_lex_state = 22},
  [1673] = {.lex_state = 21, .external_lex_state = 32},
  [1674] = {.lex_state = 21, .external_lex_state = 32},
  [1675] = {.lex_state = 21, .external_lex_state = 22},
  [1676] = {.lex_state = 21, .external_lex_state = 22},
  [1677] = {.lex_state = 21, .external_lex_state = 22},
  [1678] = {.lex_state = 21, .external_lex_state = 16},
  [1679] = {.lex_state = 21, .external_lex_state = 16},
  [1680] = {.lex_state = 21, .external_lex_state = 16},
  [1681] = {.lex_state = 21, .external_lex_state = 16},
  [1682] = {.lex_state = 21, .external_lex_state = 16},
  [1683] = {.lex_state = 21, .external_lex_state = 31},
  [1684] = {.lex_state = 21, .external_lex_state = 31},
  [1685] = {.lex_state = 21, .external_lex_state = 31},
  [1686] = {.lex_state = 21, .external_lex_state = 32},
  [1687] = {.lex_state = 21, .external_lex_state = 32},
  [1688] = {.lex_state = 21, .external_lex_state = 16},
  [1689] = {.lex_state = 21, .external_lex_state = 22},
  [1690] = {.lex_state = 21, .external_lex_state = 16},
  [1691] = {.lex_state = 21, .external_lex_state = 16},
  [1692] = {.lex_state = 21, .external_lex_state = 16},
  [1693] = {.lex_state = 21, .external_lex_state = 16},
  [1694] = {.lex_state = 21, .external_lex_state = 16},
  [1695] = {.lex_state = 21, .external_lex_state = 16},
  [1696] = {.lex_state = 21, .external_lex_state = 16},
  [1697] = {.lex_state = 21, .external_lex_state = 16},
  [1698] = {.lex_state = 21, .external_lex_state = 16},
  [1699] = {.lex_state = 23, .external_lex_state = 38},
  [1700] = {.lex_state = 21, .external_lex_state = 16},
  [1701] = {.lex_state = 21, .external_lex_state = 16},
  [1702] = {.lex_state = 21, .external_lex_state = 16},
  [1703] = {.lex_state = 21, .external_lex_state = 16},
  [1704] = {.lex_state = 21, .external_lex_state = 16},
  [1705] = {.lex_state = 21, .external_lex_state = 16},
  [1706] = {.lex_state = 21, .external_lex_state = 16},
  [1707] = {.lex_state = 21, .external_lex_state = 16},
  [1708] = {.lex_state = 21, .external_lex_state = 31},
  [1709] = {.lex_state = 21, .external_lex_state = 31},
  [1710] = {.lex_state = 21, .external_lex_state = 16},
  [1711] = {.lex_state = 21, .external_lex_state = 3},
  [1712] = {.lex_state = 21, .external_lex_state = 34},
  [1713] = {.lex_state = 21, .external_lex_state = 34},
  [1714] = {.lex_state = 21, .external_lex_state = 34},
  [1715] = {.lex_state = 21, .external_lex_state = 16},
  [1716] = {.lex_state = 21, .external_lex_state = 16},
  [1717] = {.lex_state = 21, .external_lex_state = 16},
  [1718] = {.lex_state = 21, .external_lex_state = 3},
  [1719] = {.lex_state = 21, .external_lex_state = 27},
  [1720] = {.lex_state = 21, .external_lex_state = 34},
  [1721] = {.lex_state = 21, .external_lex_state = 36},
  [1722] = {.lex_state = 21, .external_lex_state = 3},
  [1723] = {.lex_state = 21, .external_lex_state = 34},
  [1724] = {.lex_state = 21, .external_lex_state = 16},
  [1725] = {.lex_state = 21, .external_lex_state = 16},
  [1726] = {.lex_state = 21, .external_lex_state = 36},
  [1727] = {.lex_state = 21, .external_lex_state = 22},
  [1728] = {.lex_state = 21, .external_lex_state = 30},
  [1729] = {.lex_state = 21, .external_lex_state = 32},
  [1730] = {.lex_state = 21, .external_lex_state = 30},
  [1731] = {.lex_state = 21, .external_lex_state = 22},
  [1732] = {.lex_state = 21, .external_lex_state = 16},
  [1733] = {.lex_state = 21, .external_lex_state = 16},
  [1734] = {.lex_state = 21, .external_lex_state = 4},
  [1735] = {.lex_state = 21, .external_lex_state = 4},
  [1736] = {.lex_state = 21, .external_lex_state = 5},
  [1737] = {.lex_state = 21, .external_lex_state = 36},
  [1738] = {.lex_state = 21, .external_lex_state = 24},
  [1739] = {.lex_state = 21, .external_lex_state = 24},
  [1740] = {.lex_state = 21, .external_lex_state = 24},
  [1741] = {.lex_state = 21, .external_lex_state = 37},
  [1742] = {.lex_state = 21, .external_lex_state = 37},
  [1743] = {.lex_state = 21, .external_lex_state = 24},
  [1744] = {.lex_state = 21, .external_lex_state = 29},
  [1745] = {.lex_state = 21, .external_lex_state = 35},
  [1746] = {.lex_state = 21, .external_lex_state = 35},
  [1747] = {.lex_state = 21, .external_lex_state = 3},
  [1748] = {.lex_state = 21, .external_lex_state = 24},
  [1749] = {.lex_state = 21, .external_lex_state = 24},
  [1750] = {.lex_state = 21, .external_lex_state = 35},
  [1751] = {.lex_state = 21, .external_lex_state = 35},
  [1752] = {.lex_state = 21, .external_lex_state = 3},
  [1753] = {.lex_state = 21, .external_lex_state = 36},
  [1754] = {.lex_state = 21, .external_lex_state = 36},
  [1755] = {.lex_state = 21, .external_lex_state = 24},
  [1756] = {.lex_state = 21, .external_lex_state = 36},
  [1757] = {.lex_state = 21, .external_lex_state = 24},
  [1758] = {.lex_state = 21, .external_lex_state = 24},
  [1759] = {.lex_state = 21, .external_lex_state = 24},
  [1760] = {.lex_state = 21, .external_lex_state = 36},
  [1761] = {.lex_state = 21, .external_lex_state = 24},
  [1762] = {.lex_state = 21, .external_lex_state = 24},
  [1763] = {.lex_state = 21, .external_lex_state = 24},
  [1764] = {.lex_state = 21, .external_lex_state = 24},
  [1765] = {.lex_state = 21, .external_lex_state = 24},
  [1766] = {.lex_state = 21, .external_lex_state = 24},
  [1767] = {.lex_state = 21, .external_lex_state = 24},
  [1768] = {.lex_state = 21, .external_lex_state = 24},
  [1769] = {.lex_state = 21, .external_lex_state = 24},
  [1770] = {.lex_state = 21, .external_lex_state = 24},
  [1771] = {.lex_state = 21, .external_lex_state = 24},
  [1772] = {.lex_state = 21, .external_lex_state = 24},
  [1773] = {.lex_state = 21, .external_lex_state = 24},
  [1774] = {.lex_state = 21, .external_lex_state = 24},
  [1775] = {.lex_state = 21, .external_lex_state = 24},
  [1776] = {.lex_state = 21, .external_lex_state = 24},
  [1777] = {.lex_state = 21, .external_lex_state = 22},
  [1778] = {.lex_state = 21, .external_lex_state = 24},
  [1779] = {.lex_state = 21, .external_lex_state = 24},
  [1780] = {.lex_state = 21, .external_lex_state = 24},
  [1781] = {.lex_state = 21, .external_lex_state = 24},
  [1782] = {.lex_state = 21, .external_lex_state = 24},
  [1783] = {.lex_state = 21, .external_lex_state = 24},
  [1784] = {.lex_state = 21, .external_lex_state = 24},
  [1785] = {.lex_state = 21, .external_lex_state = 24},
  [1786] = {.lex_state = 21, .external_lex_state = 35},
  [1787] = {.lex_state = 21, .external_lex_state = 30},
  [1788] = {.lex_state = 21, .external_lex_state = 35},
  [1789] = {.lex_state = 21, .external_lex_state = 35},
  [1790] = {.lex_state = 21, .external_lex_state = 35},
  [1791] = {.lex_state = 21, .external_lex_state = 35},
  [1792] = {.lex_state = 21, .external_lex_state = 35},
  [1793] = {.lex_state = 21, .external_lex_state = 28},
  [1794] = {.lex_state = 21, .external_lex_state = 35},
  [1795] = {.lex_state = 21, .external_lex_state = 35},
  [1796] = {.lex_state = 21, .external_lex_state = 35},
  [1797] = {.lex_state = 21, .external_lex_state = 35},
  [1798] = {.lex_state = 21, .external_lex_state = 35},
  [1799] = {.lex_state = 21, .external_lex_state = 35},
  [1800] = {.lex_state = 21, .external_lex_state = 35},
  [1801] = {.lex_state = 21, .external_lex_state = 35},
  [1802] = {.lex_state = 21, .external_lex_state = 35},
  [1803] = {.lex_state = 21, .external_lex_state = 35},
  [1804] = {.lex_state = 21, .external_lex_state = 35},
  [1805] = {.lex_state = 21, .external_lex_state = 35},
  [1806] = {.lex_state = 21, .external_lex_state = 35},
  [1807] = {.lex_state = 21, .external_lex_state = 24},
  [1808] = {.lex_state = 21, .external_lex_state = 35},
  [1809] = {.lex_state = 21, .external_lex_state = 35},
  [1810] = {.lex_state = 21, .external_lex_state = 35},
  [1811] = {.lex_state = 21, .external_lex_state = 38},
  [1812] = {.lex_state = 21, .external_lex_state = 35},
  [1813] = {.lex_state = 21, .external_lex_state = 38},
  [1814] = {.lex_state = 21, .external_lex_state = 24},
  [1815] = {.lex_state = 21, .external_lex_state = 31},
  [1816] = {.lex_state = 21, .external_lex_state = 24},
  [1817] = {.lex_state = 21, .external_lex_state = 24},
  [1818] = {.lex_state = 21, .external_lex_state = 24},
  [1819] = {.lex_state = 21, .external_lex_state = 36},
  [1820] = {.lex_state = 21, .external_lex_state = 36},
  [1821] = {.lex_state = 21, .external_lex_state = 3},
  [1822] = {.lex_state = 21, .external_lex_state = 3},
  [1823] = {.lex_state = 21, .external_lex_state = 36},
  [1824] = {.lex_state = 21, .external_lex_state = 36},
  [1825] = {.lex_state = 21, .external_lex_state = 24},
  [1826] = {.lex_state = 21, .external_lex_state = 36},
  [1827] = {.lex_state = 21, .external_lex_state = 36},
  [1828] = {.lex_state = 21, .external_lex_state = 36},
  [1829] = {.lex_state = 21, .external_lex_state = 36},
  [1830] = {.lex_state = 21, .external_lex_state = 36},
  [1831] = {.lex_state = 21, .external_lex_state = 36},
  [1832] = {.lex_state = 21, .external_lex_state = 36},
  [1833] = {.lex_state = 21, .external_lex_state = 36},
  [1834] = {.lex_state = 21, .external_lex_state = 36},
  [1835] = {.lex_state = 21, .external_lex_state = 36},
  [1836] = {.lex_state = 21, .external_lex_state = 36},
  [1837] = {.lex_state = 21, .external_lex_state = 24},
  [1838] = {.lex_state = 21, .external_lex_state = 36},
  [1839] = {.lex_state = 21, .external_lex_state = 36},
  [1840] = {.lex_state = 21, .external_lex_state = 36},
  [1841] = {.lex_state = 21, .external_lex_state = 36},
  [1842] = {.lex_state = 21, .external_lex_state = 24},
  [1843] = {.lex_state = 21, .external_lex_state = 36},
  [1844] = {.lex_state = 21, .external_lex_state = 36},
  [1845] = {.lex_state = 21, .external_lex_state = 36},
  [1846] = {.lex_state = 21, .external_lex_state = 24},
  [1847] = {.lex_state = 21, .external_lex_state = 36},
  [1848] = {.lex_state = 21, .external_lex_state = 35},
  [1849] = {.lex_state = 21, .external_lex_state = 37},
  [1850] = {.lex_state = 21, .external_lex_state = 37},
  [1851] = {.lex_state = 21, .external_lex_state = 2},
  [1852] = {.lex_state = 21, .external_lex_state = 37},
  [1853] = {.lex_state = 21, .external_lex_state = 31},
  [1854] = {.lex_state = 21, .external_lex_state = 36},
  [1855] = {.lex_state = 21, .external_lex_state = 35},
  [1856] = {.lex_state = 21, .external_lex_state = 35},
  [1857] = {.lex_state = 21, .external_lex_state = 38},
  [1858] = {.lex_state = 21, .external_lex_state = 38},
  [1859] = {.lex_state = 21, .external_lex_state = 38},
  [1860] = {.lex_state = 21, .external_lex_state = 5},
  [1861] = {.lex_state = 21, .external_lex_state = 2},
  [1862] = {.lex_state = 21, .external_lex_state = 35},
  [1863] = {.lex_state = 21, .external_lex_state = 38},
  [1864] = {.lex_state = 21, .external_lex_state = 38},
  [1865] = {.lex_state = 21, .external_lex_state = 38},
  [1866] = {.lex_state = 21, .external_lex_state = 4},
  [1867] = {.lex_state = 21, .external_lex_state = 38},
  [1868] = {.lex_state = 21, .external_lex_state = 38},
  [1869] = {.lex_state = 21, .external_lex_state = 38},
  [1870] = {.lex_state = 21, .external_lex_state = 35},
  [1871] = {.lex_state = 21, .external_lex_state = 38},
  [1872] = {.lex_state = 21, .external_lex_state = 38},
  [1873] = {.lex_state = 21, .external_lex_state = 38},
  [1874] = {.lex_state = 21, .external_lex_state = 38},
  [1875] = {.lex_state = 21, .external_lex_state = 38},
  [1876] = {.lex_state = 21, .external_lex_state = 38},
  [1877] = {.lex_state = 21, .external_lex_state = 38},
  [1878] = {.lex_state = 21, .external_lex_state = 5},
  [1879] = {.lex_state = 21, .external_lex_state = 38},
  [1880] = {.lex_state = 21, .external_lex_state = 38},
  [1881] = {.lex_state = 21, .external_lex_state = 38},
  [1882] = {.lex_state = 21, .external_lex_state = 38},
  [1883] = {.lex_state = 21, .external_lex_state = 37},
  [1884] = {.lex_state = 21, .external_lex_state = 37},
  [1885] = {.lex_state = 21, .external_lex_state = 35},
  [1886] = {.lex_state = 21, .external_lex_state = 35},
  [1887] = {.lex_state = 21, .external_lex_state = 2},
  [1888] = {.lex_state = 21, .external_lex_state = 38},
  [1889] = {.lex_state = 21, .external_lex_state = 22},
  [1890] = {.lex_state = 21, .external_lex_state = 37},
  [1891] = {.lex_state = 21, .external_lex_state = 35},
  [1892] = {.lex_state = 21, .external_lex_state = 37},
  [1893] = {.lex_state = 21, .external_lex_state = 37},
  [1894] = {.lex_state = 21, .external_lex_state = 38},
  [1895] = {.lex_state = 21, .external_lex_state = 4},
  [1896] = {.lex_state = 21, .external_lex_state = 38},
  [1897] = {.lex_state = 21, .external_lex_state = 38},
  [1898] = {.lex_state = 21, .external_lex_state = 37},
  [1899] = {.lex_state = 21, .external_lex_state = 2},
  [1900] = {.lex_state = 21, .external_lex_state = 5},
  [1901] = {.lex_state = 21, .external_lex_state = 37},
  [1902] = {.lex_state = 21, .external_lex_state = 3},
  [1903] = {.lex_state = 21, .external_lex_state = 38},
  [1904] = {.lex_state = 21, .external_lex_state = 35},
  [1905] = {.lex_state = 21, .external_lex_state = 38},
  [1906] = {.lex_state = 21, .external_lex_state = 38},
  [1907] = {.lex_state = 21, .external_lex_state = 4},
  [1908] = {.lex_state = 21, .external_lex_state = 30},
  [1909] = {.lex_state = 21, .external_lex_state = 37},
  [1910] = {.lex_state = 21, .external_lex_state = 4},
  [1911] = {.lex_state = 21, .external_lex_state = 35},
  [1912] = {.lex_state = 21, .external_lex_state = 37},
  [1913] = {.lex_state = 21, .external_lex_state = 37},
  [1914] = {.lex_state = 21, .external_lex_state = 37},
  [1915] = {.lex_state = 21, .external_lex_state = 38},
  [1916] = {.lex_state = 21, .external_lex_state = 37},
  [1917] = {.lex_state = 21, .external_lex_state = 37},
  [1918] = {.lex_state = 21, .external_lex_state = 37},
  [1919] = {.lex_state = 21, .external_lex_state = 37},
  [1920] = {.lex_state = 21, .external_lex_state = 37},
  [1921] = {.lex_state = 21, .external_lex_state = 35},
  [1922] = {.lex_state = 21, .external_lex_state = 37},
  [1923] = {.lex_state = 21, .external_lex_state = 35},
  [1924] = {.lex_state = 21, .external_lex_state = 37},
  [1925] = {.lex_state = 21, .external_lex_state = 5},
  [1926] = {.lex_state = 21, .external_lex_state = 37},
  [1927] = {.lex_state = 21, .external_lex_state = 37},
  [1928] = {.lex_state = 21, .external_lex_state = 35},
  [1929] = {.lex_state = 21, .external_lex_state = 37},
  [1930] = {.lex_state = 21, .external_lex_state = 37},
  [1931] = {.lex_state = 21, .external_lex_state = 37},
  [1932] = {.lex_state = 21, .external_lex_state = 37},
  [1933] = {.lex_state = 21, .external_lex_state = 37},
  [1934] = {.lex_state = 21, .external_lex_state = 35},
  [1935] = {.lex_state = 21, .external_lex_state = 30},
  [1936] = {.lex_state = 21, .external_lex_state = 2},
  [1937] = {.lex_state = 21, .external_lex_state = 3},
  [1938] = {.lex_state = 21, .external_lex_state = 3},
  [1939] = {.lex_state = 21, .external_lex_state = 3},
  [1940] = {.lex_state = 21, .external_lex_state = 3},
  [1941] = {.lex_state = 21, .external_lex_state = 3},
  [1942] = {.lex_state = 21, .external_lex_state = 3},
  [1943] = {.lex_state = 21, .external_lex_state = 3},
  [1944] = {.lex_state = 21, .external_lex_state = 30},
  [1945] = {.lex_state = 21, .external_lex_state = 30},
  [1946] = {.lex_state = 21, .external_lex_state = 3},
  [1947] = {.lex_state = 21, .external_lex_state = 3},
  [1948] = {.lex_state = 21, .external_lex_state = 30},
  [1949] = {.lex_state = 21, .external_lex_state = 30},
  [1950] = {.lex_state = 21, .external_lex_state = 30},
  [1951] = {.lex_state = 21, .external_lex_state = 30},
  [1952] = {.lex_state = 21, .external_lex_state = 30},
  [1953] = {.lex_state = 21, .external_lex_state = 38},
  [1954] = {.lex_state = 21, .external_lex_state = 3},
  [1955] = {.lex_state = 21, .external_lex_state = 4},
  [1956] = {.lex_state = 21, .external_lex_state = 30},
  [1957] = {.lex_state = 21, .external_lex_state = 4},
  [1958] = {.lex_state = 21, .external_lex_state = 31},
  [1959] = {.lex_state = 21, .external_lex_state = 2},
  [1960] = {.lex_state = 21, .external_lex_state = 3},
  [1961] = {.lex_state = 21, .external_lex_state = 5},
  [1962] = {.lex_state = 21, .external_lex_state = 5},
  [1963] = {.lex_state = 21, .external_lex_state = 3},
  [1964] = {.lex_state = 21, .external_lex_state = 3},
  [1965] = {.lex_state = 21, .external_lex_state = 3},
  [1966] = {.lex_state = 21, .external_lex_state = 3},
  [1967] = {.lex_state = 21, .external_lex_state = 3},
  [1968] = {.lex_state = 21, .external_lex_state = 3},
  [1969] = {.lex_state = 21, .external_lex_state = 3},
  [1970] = {.lex_state = 21, .external_lex_state = 3},
  [1971] = {.lex_state = 21, .external_lex_state = 3},
  [1972] = {.lex_state = 21, .external_lex_state = 3},
  [1973] = {.lex_state = 21, .external_lex_state = 3},
  [1974] = {.lex_state = 21, .external_lex_state = 31},
  [1975] = {.lex_state = 21, .external_lex_state = 3},
  [1976] = {.lex_state = 21, .external_lex_state = 3},
  [1977] = {.lex_state = 21, .external_lex_state = 3},
  [1978] = {.lex_state = 21, .external_lex_state = 3},
  [1979] = {.lex_state = 21, .external_lex_state = 3},
  [1980] = {.lex_state = 21, .external_lex_state = 3},
  [1981] = {.lex_state = 21, .external_lex_state = 3},
  [1982] = {.lex_state = 21, .external_lex_state = 3},
  [1983] = {.lex_state = 21, .external_lex_state = 3},
  [1984] = {.lex_state = 21, .external_lex_state = 3},
  [1985] = {.lex_state = 21, .external_lex_state = 3},
  [1986] = {.lex_state = 21, .external_lex_state = 31},
  [1987] = {.lex_state = 21, .external_lex_state = 31},
  [1988] = {.lex_state = 21, .external_lex_state = 31},
  [1989] = {.lex_state = 21, .external_lex_state = 3},
  [1990] = {.lex_state = 21, .external_lex_state = 31},
  [1991] = {.lex_state = 21, .external_lex_state = 3},
  [1992] = {.lex_state = 21, .external_lex_state = 3},
  [1993] = {.lex_state = 21, .external_lex_state = 3},
  [1994] = {.lex_state = 21, .external_lex_state = 3},
  [1995] = {.lex_state = 21, .external_lex_state = 3},
  [1996] = {.lex_state = 21, .external_lex_state = 30},
  [1997] = {.lex_state = 21, .external_lex_state = 3},
  [1998] = {.lex_state = 21, .external_lex_state = 3},
  [1999] = {.lex_state = 21, .external_lex_state = 3},
  [2000] = {.lex_state = 21, .external_lex_state = 3},
  [2001] = {.lex_state = 21, .external_lex_state = 30},
  [2002] = {.lex_state = 21, .external_lex_state = 3},
  [2003] = {.lex_state = 21, .external_lex_state = 3},
  [2004] = {.lex_state = 21, .external_lex_state = 3},
  [2005] = {.lex_state = 21, .external_lex_state = 3},
  [2006] = {.lex_state = 21, .external_lex_state = 3},
  [2007] = {.lex_state = 21, .external_lex_state = 3},
  [2008] = {.lex_state = 21, .external_lex_state = 3},
  [2009] = {.lex_state = 21, .external_lex_state = 31},
  [2010] = {.lex_state = 21, .external_lex_state = 31},
  [2011] = {.lex_state = 21, .external_lex_state = 3},
  [2012] = {.lex_state = 21, .external_lex_state = 31},
  [2013] = {.lex_state = 21, .external_lex_state = 36},
  [2014] = {.lex_state = 21, .external_lex_state = 31},
  [2015] = {.lex_state = 21, .external_lex_state = 22},
  [2016] = {.lex_state = 21, .external_lex_state = 2},
  [2017] = {.lex_state = 21, .external_lex_state = 2},
  [2018] = {.lex_state = 21, .external_lex_state = 31},
  [2019] = {.lex_state = 21, .external_lex_state = 31},
  [2020] = {.lex_state = 21, .external_lex_state = 3},
  [2021] = {.lex_state = 21, .external_lex_state = 31},
  [2022] = {.lex_state = 21, .external_lex_state = 31},
  [2023] = {.lex_state = 21, .external_lex_state = 31},
  [2024] = {.lex_state = 21, .external_lex_state = 31},
  [2025] = {.lex_state = 21, .external_lex_state = 31},
  [2026] = {.lex_state = 21, .external_lex_state = 3},
  [2027] = {.lex_state = 21, .external_lex_state = 31},
  [2028] = {.lex_state = 21, .external_lex_state = 31},
  [2029] = {.lex_state = 21, .external_lex_state = 31},
  [2030] = {.lex_state = 21, .external_lex_state = 31},
  [2031] = {.lex_state = 21, .external_lex_state = 31},
  [2032] = {.lex_state = 21, .external_lex_state = 31},
  [2033] = {.lex_state = 21, .external_lex_state = 31},
  [2034] = {.lex_state = 21, .external_lex_state = 31},
  [2035] = {.lex_state = 21, .external_lex_state = 31},
  [2036] = {.lex_state = 21, .external_lex_state = 31},
  [2037] = {.lex_state = 21, .external_lex_state = 31},
  [2038] = {.lex_state = 21, .external_lex_state = 31},
  [2039] = {.lex_state = 21, .external_lex_state = 5},
  [2040] = {.lex_state = 21, .external_lex_state = 31},
  [2041] = {.lex_state = 21, .external_lex_state = 3},
  [2042] = {.lex_state = 21, .external_lex_state = 31},
  [2043] = {.lex_state = 21, .external_lex_state = 31},
  [2044] = {.lex_state = 21, .external_lex_state = 31},
  [2045] = {.lex_state = 21, .external_lex_state = 30},
  [2046] = {.lex_state = 21, .external_lex_state = 31},
  [2047] = {.lex_state = 21, .external_lex_state = 30},
  [2048] = {.lex_state = 21, .external_lex_state = 30},
  [2049] = {.lex_state = 21, .external_lex_state = 5},
  [2050] = {.lex_state = 21, .external_lex_state = 31},
  [2051] = {.lex_state = 21, .external_lex_state = 30},
  [2052] = {.lex_state = 21, .external_lex_state = 30},
  [2053] = {.lex_state = 21, .external_lex_state = 30},
  [2054] = {.lex_state = 21, .external_lex_state = 3},
  [2055] = {.lex_state = 21, .external_lex_state = 31},
  [2056] = {.lex_state = 21, .external_lex_state = 3},
  [2057] = {.lex_state = 21, .external_lex_state = 30},
  [2058] = {.lex_state = 21, .external_lex_state = 30},
  [2059] = {.lex_state = 21, .external_lex_state = 30},
  [2060] = {.lex_state = 21, .external_lex_state = 31},
  [2061] = {.lex_state = 21, .external_lex_state = 30},
  [2062] = {.lex_state = 21, .external_lex_state = 30},
  [2063] = {.lex_state = 21, .external_lex_state = 30},
  [2064] = {.lex_state = 21, .external_lex_state = 30},
  [2065] = {.lex_state = 21, .external_lex_state = 30},
  [2066] = {.lex_state = 21, .external_lex_state = 31},
  [2067] = {.lex_state = 21, .external_lex_state = 30},
  [2068] = {.lex_state = 21, .external_lex_state = 30},
  [2069] = {.lex_state = 21, .external_lex_state = 30},
  [2070] = {.lex_state = 21, .external_lex_state = 30},
  [2071] = {.lex_state = 21, .external_lex_state = 30},
  [2072] = {.lex_state = 21, .external_lex_state = 30},
  [2073] = {.lex_state = 21, .external_lex_state = 30},
  [2074] = {.lex_state = 21, .external_lex_state = 30},
  [2075] = {.lex_state = 21, .external_lex_state = 30},
  [2076] = {.lex_state = 21, .external_lex_state = 30},
  [2077] = {.lex_state = 21, .external_lex_state = 30},
  [2078] = {.lex_state = 21, .external_lex_state = 30},
  [2079] = {.lex_state = 21, .external_lex_state = 30},
  [2080] = {.lex_state = 21, .external_lex_state = 31},
  [2081] = {.lex_state = 21, .external_lex_state = 30},
  [2082] = {.lex_state = 21, .external_lex_state = 31},
  [2083] = {.lex_state = 21, .external_lex_state = 4},
  [2084] = {.lex_state = 21, .external_lex_state = 30},
  [2085] = {.lex_state = 21, .external_lex_state = 22},
  [2086] = {.lex_state = 21, .external_lex_state = 4},
  [2087] = {.lex_state = 21, .external_lex_state = 22},
  [2088] = {.lex_state = 21, .external_lex_state = 31},
  [2089] = {.lex_state = 21, .external_lex_state = 3},
  [2090] = {.lex_state = 21, .external_lex_state = 30},
  [2091] = {.lex_state = 21, .external_lex_state = 30},
  [2092] = {.lex_state = 21, .external_lex_state = 30},
  [2093] = {.lex_state = 21, .external_lex_state = 3},
  [2094] = {.lex_state = 21, .external_lex_state = 31},
  [2095] = {.lex_state = 21, .external_lex_state = 37},
  [2096] = {.lex_state = 21, .external_lex_state = 31},
  [2097] = {.lex_state = 21, .external_lex_state = 3},
  [2098] = {.lex_state = 21, .external_lex_state = 36},
  [2099] = {.lex_state = 21, .external_lex_state = 36},
  [2100] = {.lex_state = 21, .external_lex_state = 36},
  [2101] = {.lex_state = 21, .external_lex_state = 36},
  [2102] = {.lex_state = 21, .external_lex_state = 36},
  [2103] = {.lex_state = 21, .external_lex_state = 36},
  [2104] = {.lex_state = 21, .external_lex_state = 35},
  [2105] = {.lex_state = 21, .external_lex_state = 36},
  [2106] = {.lex_state = 21, .external_lex_state = 36},
  [2107] = {.lex_state = 21, .external_lex_state = 35},
  [2108] = {.lex_state = 21, .external_lex_state = 35},
  [2109] = {.lex_state = 21, .external_lex_state = 36},
  [2110] = {.lex_state = 21, .external_lex_state = 35},
  [2111] = {.lex_state = 21, .external_lex_state = 35},
  [2112] = {.lex_state = 21, .external_lex_state = 36},
  [2113] = {.lex_state = 21, .external_lex_state = 36},
  [2114] = {.lex_state = 21, .external_lex_state = 36},
  [2115] = {.lex_state = 21, .external_lex_state = 36},
  [2116] = {.lex_state = 21, .external_lex_state = 35},
  [2117] = {.lex_state = 21, .external_lex_state = 35},
  [2118] = {.lex_state = 21, .external_lex_state = 36},
  [2119] = {.lex_state = 21, .external_lex_state = 35},
  [2120] = {.lex_state = 21, .external_lex_state = 35},
  [2121] = {.lex_state = 21, .external_lex_state = 35},
  [2122] = {.lex_state = 21, .external_lex_state = 35},
  [2123] = {.lex_state = 21, .external_lex_state = 36},
  [2124] = {.lex_state = 21, .external_lex_state = 35},
  [2125] = {.lex_state = 21, .external_lex_state = 36},
  [2126] = {.lex_state = 21, .external_lex_state = 35},
  [2127] = {.lex_state = 21, .external_lex_state = 35},
  [2128] = {.lex_state = 21, .external_lex_state = 36},
  [2129] = {.lex_state = 21, .external_lex_state = 36},
  [2130] = {.lex_state = 21, .external_lex_state = 36},
  [2131] = {.lex_state = 21, .external_lex_state = 36},
  [2132] = {.lex_state = 21, .external_lex_state = 35},
  [2133] = {.lex_state = 21, .external_lex_state = 36},
  [2134] = {.lex_state = 21, .external_lex_state = 36},
  [2135] = {.lex_state = 21, .external_lex_state = 36},
  [2136] = {.lex_state = 21, .external_lex_state = 36},
  [2137] = {.lex_state = 21, .external_lex_state = 36},
  [2138] = {.lex_state = 21, .external_lex_state = 36},
  [2139] = {.lex_state = 21, .external_lex_state = 3},
  [2140] = {.lex_state = 21, .external_lex_state = 36},
  [2141] = {.lex_state = 21, .external_lex_state = 35},
  [2142] = {.lex_state = 21, .external_lex_state = 36},
  [2143] = {.lex_state = 21, .external_lex_state = 36},
  [2144] = {.lex_state = 21, .external_lex_state = 36},
  [2145] = {.lex_state = 21, .external_lex_state = 36},
  [2146] = {.lex_state = 21, .external_lex_state = 36},
  [2147] = {.lex_state = 21, .external_lex_state = 35},
  [2148] = {.lex_state = 21, .external_lex_state = 35},
  [2149] = {.lex_state = 21, .external_lex_state = 36},
  [2150] = {.lex_state = 21, .external_lex_state = 35},
  [2151] = {.lex_state = 21, .external_lex_state = 35},
  [2152] = {.lex_state = 21, .external_lex_state = 5},
  [2153] = {.lex_state = 21, .external_lex_state = 35},
  [2154] = {.lex_state = 21, .external_lex_state = 35},
  [2155] = {.lex_state = 21, .external_lex_state = 35},
  [2156] = {.lex_state = 21, .external_lex_state = 36},
  [2157] = {.lex_state = 21, .external_lex_state = 35},
  [2158] = {.lex_state = 21, .external_lex_state = 36},
  [2159] = {.lex_state = 21, .external_lex_state = 35},
  [2160] = {.lex_state = 21, .external_lex_state = 35},
  [2161] = {.lex_state = 21, .external_lex_state = 35},
  [2162] = {.lex_state = 21, .external_lex_state = 35},
  [2163] = {.lex_state = 21, .external_lex_state = 35},
  [2164] = {.lex_state = 21, .external_lex_state = 36},
  [2165] = {.lex_state = 21, .external_lex_state = 35},
  [2166] = {.lex_state = 21, .external_lex_state = 36},
  [2167] = {.lex_state = 21, .external_lex_state = 35},
  [2168] = {.lex_state = 21, .external_lex_state = 35},
  [2169] = {.lex_state = 21, .external_lex_state = 35},
  [2170] = {.lex_state = 21, .external_lex_state = 36},
  [2171] = {.lex_state = 21, .external_lex_state = 35},
  [2172] = {.lex_state = 21, .external_lex_state = 36},
  [2173] = {.lex_state = 21, .external_lex_state = 35},
  [2174] = {.lex_state = 21, .external_lex_state = 35},
  [2175] = {.lex_state = 21, .external_lex_state = 36},
  [2176] = {.lex_state = 21, .external_lex_state = 35},
  [2177] = {.lex_state = 21, .external_lex_state = 35},
  [2178] = {.lex_state = 21, .external_lex_state = 35},
  [2179] = {.lex_state = 21, .external_lex_state = 36},
  [2180] = {.lex_state = 21, .external_lex_state = 2},
  [2181] = {.lex_state = 21, .external_lex_state = 35},
  [2182] = {.lex_state = 21, .external_lex_state = 36},
  [2183] = {.lex_state = 21, .external_lex_state = 4},
  [2184] = {.lex_state = 21, .external_lex_state = 35},
  [2185] = {.lex_state = 21, .external_lex_state = 35},
  [2186] = {.lex_state = 21, .external_lex_state = 35},
  [2187] = {.lex_state = 21, .external_lex_state = 36},
  [2188] = {.lex_state = 21, .external_lex_state = 36},
  [2189] = {.lex_state = 21, .external_lex_state = 36},
  [2190] = {.lex_state = 21, .external_lex_state = 36},
  [2191] = {.lex_state = 21, .external_lex_state = 36},
  [2192] = {.lex_state = 21, .external_lex_state = 37},
  [2193] = {.lex_state = 21, .external_lex_state = 2},
  [2194] = {.lex_state = 21, .external_lex_state = 2},
  [2195] = {.lex_state = 21, .external_lex_state = 2},
  [2196] = {.lex_state = 21, .external_lex_state = 38},
  [2197] = {.lex_state = 21, .external_lex_state = 4},
  [2198] = {.lex_state = 21, .external_lex_state = 4},
  [2199] = {.lex_state = 21, .external_lex_state = 2},
  [2200] = {.lex_state = 21, .external_lex_state = 2},
  [2201] = {.lex_state = 21, .external_lex_state = 2},
  [2202] = {.lex_state = 21, .external_lex_state = 2},
  [2203] = {.lex_state = 21, .external_lex_state = 4},
  [2204] = {.lex_state = 21, .external_lex_state = 2},
  [2205] = {.lex_state = 21, .external_lex_state = 2},
  [2206] = {.lex_state = 21, .external_lex_state = 2},
  [2207] = {.lex_state = 21, .external_lex_state = 4},
  [2208] = {.lex_state = 21, .external_lex_state = 2},
  [2209] = {.lex_state = 21, .external_lex_state = 2},
  [2210] = {.lex_state = 21, .external_lex_state = 2},
  [2211] = {.lex_state = 21, .external_lex_state = 2},
  [2212] = {.lex_state = 21, .external_lex_state = 4},
  [2213] = {.lex_state = 21, .external_lex_state = 2},
  [2214] = {.lex_state = 21, .external_lex_state = 2},
  [2215] = {.lex_state = 21, .external_lex_state = 5},
  [2216] = {.lex_state = 21, .external_lex_state = 5},
  [2217] = {.lex_state = 21, .external_lex_state = 5},
  [2218] = {.lex_state = 21, .external_lex_state = 2},
  [2219] = {.lex_state = 21, .external_lex_state = 2},
  [2220] = {.lex_state = 21, .external_lex_state = 36},
  [2221] = {.lex_state = 21, .external_lex_state = 2},
  [2222] = {.lex_state = 21, .external_lex_state = 37},
  [2223] = {.lex_state = 2, .external_lex_state = 39},
  [2224] = {.lex_state = 21, .external_lex_state = 2},
  [2225] = {.lex_state = 21, .external_lex_state = 2},
  [2226] = {.lex_state = 21, .external_lex_state = 5},
  [2227] = {.lex_state = 21, .external_lex_state = 2},
  [2228] = {.lex_state = 21, .external_lex_state = 37},
  [2229] = {.lex_state = 21, .external_lex_state = 22},
  [2230] = {.lex_state = 21, .external_lex_state = 2},
  [2231] = {.lex_state = 21, .external_lex_state = 22},
  [2232] = {.lex_state = 21, .external_lex_state = 2},
  [2233] = {.lex_state = 21, .external_lex_state = 22},
  [2234] = {.lex_state = 21, .external_lex_state = 2},
  [2235] = {.lex_state = 21, .external_lex_state = 5},
  [2236] = {.lex_state = 21, .external_lex_state = 5},
  [2237] = {.lex_state = 21, .external_lex_state = 5},
  [2238] = {.lex_state = 21, .external_lex_state = 5},
  [2239] = {.lex_state = 21, .external_lex_state = 37},
  [2240] = {.lex_state = 21, .external_lex_state = 22},
  [2241] = {.lex_state = 21, .external_lex_state = 22},
  [2242] = {.lex_state = 21, .external_lex_state = 22},
  [2243] = {.lex_state = 21, .external_lex_state = 5},
  [2244] = {.lex_state = 21, .external_lex_state = 5},
  [2245] = {.lex_state = 21, .external_lex_state = 22},
  [2246] = {.lex_state = 21, .external_lex_state = 37},
  [2247] = {.lex_state = 21, .external_lex_state = 2},
  [2248] = {.lex_state = 21, .external_lex_state = 5},
  [2249] = {.lex_state = 21, .external_lex_state = 5},
  [2250] = {.lex_state = 21, .external_lex_state = 5},
  [2251] = {.lex_state = 21, .external_lex_state = 5},
  [2252] = {.lex_state = 21, .external_lex_state = 5},
  [2253] = {.lex_state = 21, .external_lex_state = 38},
  [2254] = {.lex_state = 21, .external_lex_state = 4},
  [2255] = {.lex_state = 21, .external_lex_state = 4},
  [2256] = {.lex_state = 21, .external_lex_state = 22},
  [2257] = {.lex_state = 21, .external_lex_state = 5},
  [2258] = {.lex_state = 21, .external_lex_state = 5},
  [2259] = {.lex_state = 21, .external_lex_state = 22},
  [2260] = {.lex_state = 21, .external_lex_state = 5},
  [2261] = {.lex_state = 21, .external_lex_state = 5},
  [2262] = {.lex_state = 21, .external_lex_state = 5},
  [2263] = {.lex_state = 21, .external_lex_state = 5},
  [2264] = {.lex_state = 21, .external_lex_state = 4},
  [2265] = {.lex_state = 21, .external_lex_state = 5},
  [2266] = {.lex_state = 21, .external_lex_state = 5},
  [2267] = {.lex_state = 21, .external_lex_state = 5},
  [2268] = {.lex_state = 21, .external_lex_state = 38},
  [2269] = {.lex_state = 21, .external_lex_state = 22},
  [2270] = {.lex_state = 21, .external_lex_state = 38},
  [2271] = {.lex_state = 21, .external_lex_state = 22},
  [2272] = {.lex_state = 21, .external_lex_state = 5},
  [2273] = {.lex_state = 21, .external_lex_state = 5},
  [2274] = {.lex_state = 21, .external_lex_state = 5},
  [2275] = {.lex_state = 21, .external_lex_state = 5},
  [2276] = {.lex_state = 21, .external_lex_state = 38},
  [2277] = {.lex_state = 21, .external_lex_state = 22},
  [2278] = {.lex_state = 21, .external_lex_state = 38},
  [2279] = {.lex_state = 21, .external_lex_state = 38},
  [2280] = {.lex_state = 21, .external_lex_state = 22},
  [2281] = {.lex_state = 21, .external_lex_state = 38},
  [2282] = {.lex_state = 21, .external_lex_state = 38},
  [2283] = {.lex_state = 21, .external_lex_state = 2},
  [2284] = {.lex_state = 21, .external_lex_state = 5},
  [2285] = {.lex_state = 21, .external_lex_state = 22},
  [2286] = {.lex_state = 21, .external_lex_state = 5},
  [2287] = {.lex_state = 21, .external_lex_state = 5},
  [2288] = {.lex_state = 21, .external_lex_state = 38},
  [2289] = {.lex_state = 21, .external_lex_state = 38},
  [2290] = {.lex_state = 21, .external_lex_state = 38},
  [2291] = {.lex_state = 21, .external_lex_state = 38},
  [2292] = {.lex_state = 21, .external_lex_state = 38},
  [2293] = {.lex_state = 21, .external_lex_state = 5},
  [2294] = {.lex_state = 21, .external_lex_state = 5},
  [2295] = {.lex_state = 21, .external_lex_state = 38},
  [2296] = {.lex_state = 21, .external_lex_state = 38},
  [2297] = {.lex_state = 21, .external_lex_state = 38},
  [2298] = {.lex_state = 21, .external_lex_state = 38},
  [2299] = {.lex_state = 21, .external_lex_state = 22},
  [2300] = {.lex_state = 21, .external_lex_state = 22},
  [2301] = {.lex_state = 21, .external_lex_state = 5},
  [2302] = {.lex_state = 21, .external_lex_state = 38},
  [2303] = {.lex_state = 21, .external_lex_state = 38},
  [2304] = {.lex_state = 21, .external_lex_state = 38},
  [2305] = {.lex_state = 21, .external_lex_state = 5},
  [2306] = {.lex_state = 21, .external_lex_state = 38},
  [2307] = {.lex_state = 21, .external_lex_state = 22},
  [2308] = {.lex_state = 21, .external_lex_state = 38},
  [2309] = {.lex_state = 21, .external_lex_state = 38},
  [2310] = {.lex_state = 21, .external_lex_state = 38},
  [2311] = {.lex_state = 21, .external_lex_state = 5},
  [2312] = {.lex_state = 21, .external_lex_state = 38},
  [2313] = {.lex_state = 21, .external_lex_state = 38},
  [2314] = {.lex_state = 21, .external_lex_state = 2},
  [2315] = {.lex_state = 21, .external_lex_state = 4},
  [2316] = {.lex_state = 21, .external_lex_state = 22},
  [2317] = {.lex_state = 21, .external_lex_state = 22},
  [2318] = {.lex_state = 21, .external_lex_state = 2},
  [2319] = {.lex_state = 21, .external_lex_state = 37},
  [2320] = {.lex_state = 21, .external_lex_state = 2},
  [2321] = {.lex_state = 21, .external_lex_state = 22},
  [2322] = {.lex_state = 21, .external_lex_state = 2},
  [2323] = {.lex_state = 21, .external_lex_state = 37},
  [2324] = {.lex_state = 21, .external_lex_state = 2},
  [2325] = {.lex_state = 21, .external_lex_state = 2},
  [2326] = {.lex_state = 21, .external_lex_state = 38},
  [2327] = {.lex_state = 21, .external_lex_state = 38},
  [2328] = {.lex_state = 21, .external_lex_state = 22},
  [2329] = {.lex_state = 21, .external_lex_state = 38},
  [2330] = {.lex_state = 21, .external_lex_state = 22},
  [2331] = {.lex_state = 21, .external_lex_state = 38},
  [2332] = {.lex_state = 21, .external_lex_state = 2},
  [2333] = {.lex_state = 21, .external_lex_state = 22},
  [2334] = {.lex_state = 21, .external_lex_state = 2},
  [2335] = {.lex_state = 21, .external_lex_state = 22},
  [2336] = {.lex_state = 21, .external_lex_state = 37},
  [2337] = {.lex_state = 21, .external_lex_state = 22},
  [2338] = {.lex_state = 21, .external_lex_state = 22},
  [2339] = {.lex_state = 21, .external_lex_state = 4},
  [2340] = {.lex_state = 21, .external_lex_state = 4},
  [2341] = {.lex_state = 21, .external_lex_state = 22},
  [2342] = {.lex_state = 21, .external_lex_state = 22},
  [2343] = {.lex_state = 21, .external_lex_state = 22},
  [2344] = {.lex_state = 21, .external_lex_state = 4},
  [2345] = {.lex_state = 21, .external_lex_state = 4},
  [2346] = {.lex_state = 21, .external_lex_state = 22},
  [2347] = {.lex_state = 21, .external_lex_state = 38},
  [2348] = {.lex_state = 21, .external_lex_state = 38},
  [2349] = {.lex_state = 21, .external_lex_state = 5},
  [2350] = {.lex_state = 21, .external_lex_state = 38},
  [2351] = {.lex_state = 21, .external_lex_state = 38},
  [2352] = {.lex_state = 21, .external_lex_state = 38},
  [2353] = {.lex_state = 21, .external_lex_state = 38},
  [2354] = {.lex_state = 21, .external_lex_state = 38},
  [2355] = {.lex_state = 21, .external_lex_state = 38},
  [2356] = {.lex_state = 21, .external_lex_state = 38},
  [2357] = {.lex_state = 21, .external_lex_state = 22},
  [2358] = {.lex_state = 21, .external_lex_state = 5},
  [2359] = {.lex_state = 21, .external_lex_state = 22},
  [2360] = {.lex_state = 21, .external_lex_state = 37},
  [2361] = {.lex_state = 21, .external_lex_state = 38},
  [2362] = {.lex_state = 21, .external_lex_state = 37},
  [2363] = {.lex_state = 21, .external_lex_state = 22},
  [2364] = {.lex_state = 21, .external_lex_state = 4},
  [2365] = {.lex_state = 21, .external_lex_state = 37},
  [2366] = {.lex_state = 21, .external_lex_state = 37},
  [2367] = {.lex_state = 21, .external_lex_state = 4},
  [2368] = {.lex_state = 21, .external_lex_state = 4},
  [2369] = {.lex_state = 21, .external_lex_state = 22},
  [2370] = {.lex_state = 21, .external_lex_state = 4},
  [2371] = {.lex_state = 21, .external_lex_state = 22},
  [2372] = {.lex_state = 21, .external_lex_state = 2},
  [2373] = {.lex_state = 21, .external_lex_state = 5},
  [2374] = {.lex_state = 21, .external_lex_state = 37},
  [2375] = {.lex_state = 21, .external_lex_state = 5},
  [2376] = {.lex_state = 21, .external_lex_state = 22},
  [2377] = {.lex_state = 21, .external_lex_state = 5},
  [2378] = {.lex_state = 21, .external_lex_state = 5},
  [2379] = {.lex_state = 21, .external_lex_state = 37},
  [2380] = {.lex_state = 21, .external_lex_state = 37},
  [2381] = {.lex_state = 21, .external_lex_state = 22},
  [2382] = {.lex_state = 21, .external_lex_state = 22},
  [2383] = {.lex_state = 21, .external_lex_state = 5},
  [2384] = {.lex_state = 21, .external_lex_state = 5},
  [2385] = {.lex_state = 21, .external_lex_state = 5},
  [2386] = {.lex_state = 21, .external_lex_state = 5},
  [2387] = {.lex_state = 21, .external_lex_state = 5},
  [2388] = {.lex_state = 21, .external_lex_state = 22},
  [2389] = {.lex_state = 21, .external_lex_state = 4},
  [2390] = {.lex_state = 21, .external_lex_state = 5},
  [2391] = {.lex_state = 21, .external_lex_state = 5},
  [2392] = {.lex_state = 21, .external_lex_state = 37},
  [2393] = {.lex_state = 21, .external_lex_state = 37},
  [2394] = {.lex_state = 21, .external_lex_state = 37},
  [2395] = {.lex_state = 21, .external_lex_state = 5},
  [2396] = {.lex_state = 21, .external_lex_state = 5},
  [2397] = {.lex_state = 21, .external_lex_state = 5},
  [2398] = {.lex_state = 21, .external_lex_state = 5},
  [2399] = {.lex_state = 21, .external_lex_state = 5},
  [2400] = {.lex_state = 21, .external_lex_state = 37},
  [2401] = {.lex_state = 21, .external_lex_state = 37},
  [2402] = {.lex_state = 21, .external_lex_state = 37},
  [2403] = {.lex_state = 21, .external_lex_state = 37},
  [2404] = {.lex_state = 21, .external_lex_state = 37},
  [2405] = {.lex_state = 21, .external_lex_state = 5},
  [2406] = {.lex_state = 21, .external_lex_state = 37},
  [2407] = {.lex_state = 21, .external_lex_state = 22},
  [2408] = {.lex_state = 21, .external_lex_state = 37},
  [2409] = {.lex_state = 21, .external_lex_state = 37},
  [2410] = {.lex_state = 21, .external_lex_state = 37},
  [2411] = {.lex_state = 21, .external_lex_state = 5},
  [2412] = {.lex_state = 21, .external_lex_state = 37},
  [2413] = {.lex_state = 21, .external_lex_state = 37},
  [2414] = {.lex_state = 21, .external_lex_state = 37},
  [2415] = {.lex_state = 21, .external_lex_state = 37},
  [2416] = {.lex_state = 21, .external_lex_state = 37},
  [2417] = {.lex_state = 21, .external_lex_state = 37},
  [2418] = {.lex_state = 21, .external_lex_state = 37},
  [2419] = {.lex_state = 21, .external_lex_state = 37},
  [2420] = {.lex_state = 21, .external_lex_state = 37},
  [2421] = {.lex_state = 21, .external_lex_state = 2},
  [2422] = {.lex_state = 21, .external_lex_state = 38},
  [2423] = {.lex_state = 21, .external_lex_state = 5},
  [2424] = {.lex_state = 21, .external_lex_state = 5},
  [2425] = {.lex_state = 21, .external_lex_state = 22},
  [2426] = {.lex_state = 21, .external_lex_state = 2},
  [2427] = {.lex_state = 21, .external_lex_state = 2},
  [2428] = {.lex_state = 21, .external_lex_state = 2},
  [2429] = {.lex_state = 21, .external_lex_state = 2},
  [2430] = {.lex_state = 21, .external_lex_state = 22},
  [2431] = {.lex_state = 21, .external_lex_state = 2},
  [2432] = {.lex_state = 21, .external_lex_state = 22},
  [2433] = {.lex_state = 21, .external_lex_state = 2},
  [2434] = {.lex_state = 21, .external_lex_state = 4},
  [2435] = {.lex_state = 21, .external_lex_state = 22},
  [2436] = {.lex_state = 21, .external_lex_state = 2},
  [2437] = {.lex_state = 21, .external_lex_state = 22},
  [2438] = {.lex_state = 21, .external_lex_state = 2},
  [2439] = {.lex_state = 21, .external_lex_state = 2},
  [2440] = {.lex_state = 21, .external_lex_state = 37},
  [2441] = {.lex_state = 21, .external_lex_state = 38},
  [2442] = {.lex_state = 21, .external_lex_state = 36},
  [2443] = {.lex_state = 21, .external_lex_state = 38},
  [2444] = {.lex_state = 21, .external_lex_state = 2},
  [2445] = {.lex_state = 21, .external_lex_state = 36},
  [2446] = {.lex_state = 21, .external_lex_state = 38},
  [2447] = {.lex_state = 21, .external_lex_state = 36},
  [2448] = {.lex_state = 21, .external_lex_state = 37},
  [2449] = {.lex_state = 21, .external_lex_state = 2},
  [2450] = {.lex_state = 21, .external_lex_state = 36},
  [2451] = {.lex_state = 21, .external_lex_state = 38},
  [2452] = {.lex_state = 21, .external_lex_state = 36},
  [2453] = {.lex_state = 21, .external_lex_state = 38},
  [2454] = {.lex_state = 21, .external_lex_state = 4},
  [2455] = {.lex_state = 21, .external_lex_state = 4},
  [2456] = {.lex_state = 21, .external_lex_state = 4},
  [2457] = {.lex_state = 21, .external_lex_state = 4},
  [2458] = {.lex_state = 21, .external_lex_state = 4},
  [2459] = {.lex_state = 21, .external_lex_state = 36},
  [2460] = {.lex_state = 21, .external_lex_state = 4},
  [2461] = {.lex_state = 21, .external_lex_state = 4},
  [2462] = {.lex_state = 21, .external_lex_state = 2},
  [2463] = {.lex_state = 21, .external_lex_state = 4},
  [2464] = {.lex_state = 21, .external_lex_state = 4},
  [2465] = {.lex_state = 21, .external_lex_state = 2},
  [2466] = {.lex_state = 21, .external_lex_state = 2},
  [2467] = {.lex_state = 21, .external_lex_state = 2},
  [2468] = {.lex_state = 21, .external_lex_state = 2},
  [2469] = {.lex_state = 21, .external_lex_state = 2},
  [2470] = {.lex_state = 21, .external_lex_state = 4},
  [2471] = {.lex_state = 21, .external_lex_state = 4},
  [2472] = {.lex_state = 21, .external_lex_state = 4},
  [2473] = {.lex_state = 21, .external_lex_state = 4},
  [2474] = {.lex_state = 21, .external_lex_state = 2},
  [2475] = {.lex_state = 21, .external_lex_state = 2},
  [2476] = {.lex_state = 21, .external_lex_state = 2},
  [2477] = {.lex_state = 21, .external_lex_state = 2},
  [2478] = {.lex_state = 21, .external_lex_state = 38},
  [2479] = {.lex_state = 2, .external_lex_state = 39},
  [2480] = {.lex_state = 21, .external_lex_state = 2},
  [2481] = {.lex_state = 21, .external_lex_state = 4},
  [2482] = {.lex_state = 21, .external_lex_state = 38},
  [2483] = {.lex_state = 21, .external_lex_state = 4},
  [2484] = {.lex_state = 21, .external_lex_state = 4},
  [2485] = {.lex_state = 21, .external_lex_state = 4},
  [2486] = {.lex_state = 21, .external_lex_state = 4},
  [2487] = {.lex_state = 21, .external_lex_state = 4},
  [2488] = {.lex_state = 21, .external_lex_state = 36},
  [2489] = {.lex_state = 21, .external_lex_state = 4},
  [2490] = {.lex_state = 21, .external_lex_state = 4},
  [2491] = {.lex_state = 21, .external_lex_state = 4},
  [2492] = {.lex_state = 21, .external_lex_state = 4},
  [2493] = {.lex_state = 21, .external_lex_state = 4},
  [2494] = {.lex_state = 21, .external_lex_state = 4},
  [2495] = {.lex_state = 21, .external_lex_state = 4},
  [2496] = {.lex_state = 21, .external_lex_state = 4},
  [2497] = {.lex_state = 21, .external_lex_state = 4},
  [2498] = {.lex_state = 21, .external_lex_state = 4},
  [2499] = {.lex_state = 21, .external_lex_state = 4},
  [2500] = {.lex_state = 21, .external_lex_state = 4},
  [2501] = {.lex_state = 21, .external_lex_state = 4},
  [2502] = {.lex_state = 21, .external_lex_state = 4},
  [2503] = {.lex_state = 21, .external_lex_state = 38},
  [2504] = {.lex_state = 21, .external_lex_state = 4},
  [2505] = {.lex_state = 21, .external_lex_state = 4},
  [2506] = {.lex_state = 21, .external_lex_state = 4},
  [2507] = {.lex_state = 21, .external_lex_state = 4},
  [2508] = {.lex_state = 21, .external_lex_state = 38},
  [2509] = {.lex_state = 21, .external_lex_state = 37},
  [2510] = {.lex_state = 21, .external_lex_state = 37},
  [2511] = {.lex_state = 21, .external_lex_state = 38},
  [2512] = {.lex_state = 21, .external_lex_state = 38},
  [2513] = {.lex_state = 21, .external_lex_state = 38},
  [2514] = {.lex_state = 21, .external_lex_state = 38},
  [2515] = {.lex_state = 21, .external_lex_state = 38},
  [2516] = {.lex_state = 21, .external_lex_state = 38},
  [2517] = {.lex_state = 21, .external_lex_state = 38},
  [2518] = {.lex_state = 21, .external_lex_state = 38},
  [2519] = {.lex_state = 21, .external_lex_state = 38},
  [2520] = {.lex_state = 21, .external_lex_state = 4},
  [2521] = {.lex_state = 21, .external_lex_state = 22},
  [2522] = {.lex_state = 21, .external_lex_state = 22},
  [2523] = {.lex_state = 21, .external_lex_state = 22},
  [2524] = {.lex_state = 21, .external_lex_state = 22},
  [2525] = {.lex_state = 21, .external_lex_state = 4},
  [2526] = {.lex_state = 21, .external_lex_state = 37},
  [2527] = {.lex_state = 21, .external_lex_state = 37},
  [2528] = {.lex_state = 21, .external_lex_state = 37},
  [2529] = {.lex_state = 21, .external_lex_state = 4},
  [2530] = {.lex_state = 21, .external_lex_state = 5},
  [2531] = {.lex_state = 21, .external_lex_state = 4},
  [2532] = {.lex_state = 21, .external_lex_state = 5},
  [2533] = {.lex_state = 21, .external_lex_state = 2},
  [2534] = {.lex_state = 2, .external_lex_state = 39},
  [2535] = {.lex_state = 2, .external_lex_state = 39},
  [2536] = {.lex_state = 2, .external_lex_state = 39},
  [2537] = {.lex_state = 2, .external_lex_state = 39},
  [2538] = {.lex_state = 2, .external_lex_state = 39},
  [2539] = {.lex_state = 2, .external_lex_state = 39},
  [2540] = {.lex_state = 2, .external_lex_state = 39},
  [2541] = {.lex_state = 2, .external_lex_state = 39},
  [2542] = {.lex_state = 2, .external_lex_state = 39},
  [2543] = {.lex_state = 2, .external_lex_state = 39},
  [2544] = {.lex_state = 20, .external_lex_state = 16},
  [2545] = {.lex_state = 20, .external_lex_state = 15},
  [2546] = {.lex_state = 20, .external_lex_state = 16},
  [2547] = {.lex_state = 20, .external_lex_state = 16},
  [2548] = {.lex_state = 0, .external_lex_state = 40},
  [2549] = {.lex_state = 20, .external_lex_state = 16},
  [2550] = {.lex_state = 0, .external_lex_state = 40},
  [2551] = {.lex_state = 0, .external_lex_state = 40},
  [2552] = {.lex_state = 0, .external_lex_state = 40},
  [2553] = {.lex_state = 0, .external_lex_state = 40},
  [2554] = {.lex_state = 0, .external_lex_state = 40},
  [2555] = {.lex_state = 0, .external_lex_state = 40},
  [2556] = {.lex_state = 0, .external_lex_state = 40},
  [2557] = {.lex_state = 0, .external_lex_state = 40},
  [2558] = {.lex_state = 0, .external_lex_state = 40},
  [2559] = {.lex_state = 0, .external_lex_state = 40},
  [2560] = {.lex_state = 0, .external_lex_state = 40},
  [2561] = {.lex_state = 0, .external_lex_state = 40},
  [2562] = {.lex_state = 0, .external_lex_state = 40},
  [2563] = {.lex_state = 0, .external_lex_state = 40},
  [2564] = {.lex_state = 20, .external_lex_state = 16},
  [2565] = {.lex_state = 0, .external_lex_state = 40},
  [2566] = {.lex_state = 0, .external_lex_state = 40},
  [2567] = {.lex_state = 0, .external_lex_state = 40},
  [2568] = {.lex_state = 0, .external_lex_state = 40},
  [2569] = {.lex_state = 0, .external_lex_state = 40},
  [2570] = {.lex_state = 0, .external_lex_state = 40},
  [2571] = {.lex_state = 0, .external_lex_state = 40},
  [2572] = {.lex_state = 0, .external_lex_state = 40},
  [2573] = {.lex_state = 0, .external_lex_state = 40},
  [2574] = {.lex_state = 0, .external_lex_state = 40},
  [2575] = {.lex_state = 2, .external_lex_state = 41},
  [2576] = {.lex_state = 21, .external_lex_state = 16},
  [2577] = {.lex_state = 0, .external_lex_state = 42},
  [2578] = {.lex_state = 0, .external_lex_state = 42},
  [2579] = {.lex_state = 0, .external_lex_state = 42},
  [2580] = {.lex_state = 0, .external_lex_state = 42},
  [2581] = {.lex_state = 0, .external_lex_state = 42},
  [2582] = {.lex_state = 0, .external_lex_state = 42},
  [2583] = {.lex_state = 0, .external_lex_state = 42},
  [2584] = {.lex_state = 0, .external_lex_state = 42},
  [2585] = {.lex_state = 0, .external_lex_state = 42},
  [2586] = {.lex_state = 0, .external_lex_state = 42},
  [2587] = {.lex_state = 0, .external_lex_state = 42},
  [2588] = {.lex_state = 0, .external_lex_state = 42},
  [2589] = {.lex_state = 0, .external_lex_state = 42},
  [2590] = {.lex_state = 20, .external_lex_state = 16},
  [2591] = {.lex_state = 0, .external_lex_state = 42},
  [2592] = {.lex_state = 0, .external_lex_state = 42},
  [2593] = {.lex_state = 0, .external_lex_state = 42},
  [2594] = {.lex_state = 0, .external_lex_state = 42},
  [2595] = {.lex_state = 0, .external_lex_state = 42},
  [2596] = {.lex_state = 0, .external_lex_state = 42},
  [2597] = {.lex_state = 0, .external_lex_state = 42},
  [2598] = {.lex_state = 0, .external_lex_state = 42},
  [2599] = {.lex_state = 0, .external_lex_state = 42},
  [2600] = {.lex_state = 0, .external_lex_state = 42},
  [2601] = {.lex_state = 0, .external_lex_state = 42},
  [2602] = {.lex_state = 0, .external_lex_state = 42},
  [2603] = {.lex_state = 0, .external_lex_state = 42},
  [2604] = {.lex_state = 0, .external_lex_state = 42},
  [2605] = {.lex_state = 0, .external_lex_state = 42},
  [2606] = {.lex_state = 0, .external_lex_state = 42},
  [2607] = {.lex_state = 0, .external_lex_state = 42},
  [2608] = {.lex_state = 0, .external_lex_state = 42},
  [2609] = {.lex_state = 0, .external_lex_state = 42},
  [2610] = {.lex_state = 0, .external_lex_state = 42},
  [2611] = {.lex_state = 0, .external_lex_state = 42},
  [2612] = {.lex_state = 0, .external_lex_state = 42},
  [2613] = {.lex_state = 0, .external_lex_state = 42},
  [2614] = {.lex_state = 0, .external_lex_state = 42},
  [2615] = {.lex_state = 0, .external_lex_state = 42},
  [2616] = {.lex_state = 0, .external_lex_state = 42},
  [2617] = {.lex_state = 0, .external_lex_state = 42},
  [2618] = {.lex_state = 0, .external_lex_state = 42},
  [2619] = {.lex_state = 0, .external_lex_state = 42},
  [2620] = {.lex_state = 0, .external_lex_state = 42},
  [2621] = {.lex_state = 0, .external_lex_state = 42},
  [2622] = {.lex_state = 0, .external_lex_state = 42},
  [2623] = {.lex_state = 0, .external_lex_state = 42},
  [2624] = {.lex_state = 0, .external_lex_state = 42},
  [2625] = {.lex_state = 0, .external_lex_state = 42},
  [2626] = {.lex_state = 0, .external_lex_state = 42},
  [2627] = {.lex_state = 0, .external_lex_state = 42},
  [2628] = {.lex_state = 0, .external_lex_state = 42},
  [2629] = {.lex_state = 0, .external_lex_state = 42},
  [2630] = {.lex_state = 0, .external_lex_state = 42},
  [2631] = {.lex_state = 0, .external_lex_state = 42},
  [2632] = {.lex_state = 0, .external_lex_state = 42},
  [2633] = {.lex_state = 0, .external_lex_state = 42},
  [2634] = {.lex_state = 0, .external_lex_state = 42},
  [2635] = {.lex_state = 0, .external_lex_state = 42},
  [2636] = {.lex_state = 0, .external_lex_state = 42},
  [2637] = {.lex_state = 0, .external_lex_state = 42},
  [2638] = {.lex_state = 0, .external_lex_state = 42},
  [2639] = {.lex_state = 0, .external_lex_state = 42},
  [2640] = {.lex_state = 0, .external_lex_state = 42},
  [2641] = {.lex_state = 0, .external_lex_state = 42},
  [2642] = {.lex_state = 0, .external_lex_state = 42},
  [2643] = {.lex_state = 0, .external_lex_state = 42},
  [2644] = {.lex_state = 0, .external_lex_state = 42},
  [2645] = {.lex_state = 2, .external_lex_state = 41},
  [2646] = {.lex_state = 0, .external_lex_state = 42},
  [2647] = {.lex_state = 0, .external_lex_state = 42},
  [2648] = {.lex_state = 0, .external_lex_state = 42},
  [2649] = {.lex_state = 20, .external_lex_state = 16},
  [2650] = {.lex_state = 0, .external_lex_state = 42},
  [2651] = {.lex_state = 23, .external_lex_state = 16},
  [2652] = {.lex_state = 20, .external_lex_state = 41},
  [2653] = {.lex_state = 23, .external_lex_state = 16},
  [2654] = {.lex_state = 20, .external_lex_state = 41},
  [2655] = {.lex_state = 20, .external_lex_state = 41},
  [2656] = {.lex_state = 20, .external_lex_state = 41},
  [2657] = {.lex_state = 20, .external_lex_state = 41},
  [2658] = {.lex_state = 20, .external_lex_state = 41},
  [2659] = {.lex_state = 23, .external_lex_state = 41},
  [2660] = {.lex_state = 20, .external_lex_state = 41},
  [2661] = {.lex_state = 20, .external_lex_state = 41},
  [2662] = {.lex_state = 20, .external_lex_state = 41},
  [2663] = {.lex_state = 23, .external_lex_state = 43},
  [2664] = {.lex_state = 20, .external_lex_state = 41},
  [2665] = {.lex_state = 20, .external_lex_state = 41},
  [2666] = {.lex_state = 20, .external_lex_state = 41},
  [2667] = {.lex_state = 21, .external_lex_state = 41},
  [2668] = {.lex_state = 20, .external_lex_state = 41},
  [2669] = {.lex_state = 20, .external_lex_state = 41},
  [2670] = {.lex_state = 20, .external_lex_state = 41},
  [2671] = {.lex_state = 20, .external_lex_state = 41},
  [2672] = {.lex_state = 20, .external_lex_state = 41},
  [2673] = {.lex_state = 21, .external_lex_state = 41},
  [2674] = {.lex_state = 20, .external_lex_state = 41},
  [2675] = {.lex_state = 20, .external_lex_state = 41},
  [2676] = {.lex_state = 20, .external_lex_state = 41},
  [2677] = {.lex_state = 20, .external_lex_state = 41},
  [2678] = {.lex_state = 20, .external_lex_state = 41},
  [2679] = {.lex_state = 21, .external_lex_state = 41},
  [2680] = {.lex_state = 20, .external_lex_state = 41},
  [2681] = {.lex_state = 20, .external_lex_state = 41},
  [2682] = {.lex_state = 20, .external_lex_state = 41},
  [2683] = {.lex_state = 20, .external_lex_state = 41},
  [2684] = {.lex_state = 23, .external_lex_state = 41},
  [2685] = {.lex_state = 20, .external_lex_state = 41},
  [2686] = {.lex_state = 20, .external_lex_state = 41},
  [2687] = {.lex_state = 20, .external_lex_state = 41},
  [2688] = {.lex_state = 21, .external_lex_state = 41},
  [2689] = {.lex_state = 21, .external_lex_state = 41},
  [2690] = {.lex_state = 21, .external_lex_state = 43},
  [2691] = {.lex_state = 21, .external_lex_state = 39},
  [2692] = {.lex_state = 21, .external_lex_state = 41},
  [2693] = {.lex_state = 23, .external_lex_state = 41},
  [2694] = {.lex_state = 21, .external_lex_state = 41},
  [2695] = {.lex_state = 23, .external_lex_state = 41},
  [2696] = {.lex_state = 23, .external_lex_state = 41},
  [2697] = {.lex_state = 23, .external_lex_state = 41},
  [2698] = {.lex_state = 0, .external_lex_state = 40},
  [2699] = {.lex_state = 0, .external_lex_state = 40},
  [2700] = {.lex_state = 23, .external_lex_state = 41},
  [2701] = {.lex_state = 23, .external_lex_state = 41},
  [2702] = {.lex_state = 21, .external_lex_state = 41},
  [2703] = {.lex_state = 23, .external_lex_state = 41},
  [2704] = {.lex_state = 23, .external_lex_state = 41},
  [2705] = {.lex_state = 23, .external_lex_state = 41},
  [2706] = {.lex_state = 21, .external_lex_state = 41},
  [2707] = {.lex_state = 21, .external_lex_state = 41},
  [2708] = {.lex_state = 23, .external_lex_state = 41},
  [2709] = {.lex_state = 23, .external_lex_state = 41},
  [2710] = {.lex_state = 23, .external_lex_state = 41},
  [2711] = {.lex_state = 0, .external_lex_state = 40},
  [2712] = {.lex_state = 21, .external_lex_state = 41},
  [2713] = {.lex_state = 23, .external_lex_state = 41},
  [2714] = {.lex_state = 23, .external_lex_state = 41},
  [2715] = {.lex_state = 23, .external_lex_state = 41},
  [2716] = {.lex_state = 23, .external_lex_state = 41},
  [2717] = {.lex_state = 23, .external_lex_state = 41},
  [2718] = {.lex_state = 23, .external_lex_state = 41},
  [2719] = {.lex_state = 23, .external_lex_state = 41},
  [2720] = {.lex_state = 23, .external_lex_state = 41},
  [2721] = {.lex_state = 0, .external_lex_state = 40},
  [2722] = {.lex_state = 23, .external_lex_state = 41},
  [2723] = {.lex_state = 23, .external_lex_state = 41},
  [2724] = {.lex_state = 23, .external_lex_state = 41},
  [2725] = {.lex_state = 23, .external_lex_state = 41},
  [2726] = {.lex_state = 23, .external_lex_state = 41},
  [2727] = {.lex_state = 23, .external_lex_state = 41},
  [2728] = {.lex_state = 0, .external_lex_state = 40},
  [2729] = {.lex_state = 23, .external_lex_state = 41},
  [2730] = {.lex_state = 21, .external_lex_state = 41},
  [2731] = {.lex_state = 23, .external_lex_state = 41},
  [2732] = {.lex_state = 21, .external_lex_state = 41},
  [2733] = {.lex_state = 23, .external_lex_state = 41},
  [2734] = {.lex_state = 23, .external_lex_state = 41},
  [2735] = {.lex_state = 21, .external_lex_state = 43},
  [2736] = {.lex_state = 21, .external_lex_state = 43},
  [2737] = {.lex_state = 21, .external_lex_state = 41},
  [2738] = {.lex_state = 21, .external_lex_state = 41},
  [2739] = {.lex_state = 21, .external_lex_state = 41},
  [2740] = {.lex_state = 21, .external_lex_state = 41},
  [2741] = {.lex_state = 23, .external_lex_state = 41},
  [2742] = {.lex_state = 21, .external_lex_state = 41},
  [2743] = {.lex_state = 23, .external_lex_state = 41},
  [2744] = {.lex_state = 0, .external_lex_state = 40},
  [2745] = {.lex_state = 21, .external_lex_state = 41},
  [2746] = {.lex_state = 21, .external_lex_state = 39},
  [2747] = {.lex_state = 21, .external_lex_state = 39},
  [2748] = {.lex_state = 21, .external_lex_state = 39},
  [2749] = {.lex_state = 21, .external_lex_state = 39},
  [2750] = {.lex_state = 21, .external_lex_state = 43},
  [2751] = {.lex_state = 21, .external_lex_state = 39},
  [2752] = {.lex_state = 21, .external_lex_state = 44},
  [2753] = {.lex_state = 21, .external_lex_state = 43},
  [2754] = {.lex_state = 21, .external_lex_state = 39},
  [2755] = {.lex_state = 21, .external_lex_state = 43},
  [2756] = {.lex_state = 21, .external_lex_state = 43},
  [2757] = {.lex_state = 21, .external_lex_state = 44},
  [2758] = {.lex_state = 21, .external_lex_state = 39},
  [2759] = {.lex_state = 0, .external_lex_state = 42},
  [2760] = {.lex_state = 21, .external_lex_state = 44},
  [2761] = {.lex_state = 21, .external_lex_state = 41},
  [2762] = {.lex_state = 21, .external_lex_state = 39},
  [2763] = {.lex_state = 21, .external_lex_state = 39},
  [2764] = {.lex_state = 21, .external_lex_state = 43},
  [2765] = {.lex_state = 21, .external_lex_state = 44},
  [2766] = {.lex_state = 21, .external_lex_state = 44},
  [2767] = {.lex_state = 21, .external_lex_state = 44},
  [2768] = {.lex_state = 21, .external_lex_state = 39},
  [2769] = {.lex_state = 21, .external_lex_state = 43},
  [2770] = {.lex_state = 21, .external_lex_state = 39},
  [2771] = {.lex_state = 21, .external_lex_state = 43},
  [2772] = {.lex_state = 21, .external_lex_state = 39},
  [2773] = {.lex_state = 21, .external_lex_state = 39},
  [2774] = {.lex_state = 21, .external_lex_state = 39},
  [2775] = {.lex_state = 21, .external_lex_state = 39},
  [2776] = {.lex_state = 21, .external_lex_state = 39},
  [2777] = {.lex_state = 21, .external_lex_state = 43},
  [2778] = {.lex_state = 21, .external_lex_state = 39},
  [2779] = {.lex_state = 21, .external_lex_state = 39},
  [2780] = {.lex_state = 21, .external_lex_state = 39},
  [2781] = {.lex_state = 21, .external_lex_state = 44},
  [2782] = {.lex_state = 21, .external_lex_state = 39},
  [2783] = {.lex_state = 21, .external_lex_state = 39},
  [2784] = {.lex_state = 21, .external_lex_state = 44},
  [2785] = {.lex_state = 21, .external_lex_state = 39},
  [2786] = {.lex_state = 21, .external_lex_state = 39},
  [2787] = {.lex_state = 21, .external_lex_state = 45},
  [2788] = {.lex_state = 21, .external_lex_state = 39},
  [2789] = {.lex_state = 0, .external_lex_state = 42},
  [2790] = {.lex_state = 21, .external_lex_state = 43},
  [2791] = {.lex_state = 21, .external_lex_state = 43},
  [2792] = {.lex_state = 21, .external_lex_state = 43},
  [2793] = {.lex_state = 21, .external_lex_state = 39},
  [2794] = {.lex_state = 21, .external_lex_state = 39},
  [2795] = {.lex_state = 21, .external_lex_state = 43},
  [2796] = {.lex_state = 21, .external_lex_state = 39},
  [2797] = {.lex_state = 21, .external_lex_state = 39},
  [2798] = {.lex_state = 21, .external_lex_state = 43},
  [2799] = {.lex_state = 21, .external_lex_state = 43},
  [2800] = {.lex_state = 21, .external_lex_state = 43},
  [2801] = {.lex_state = 21, .external_lex_state = 44},
  [2802] = {.lex_state = 21, .external_lex_state = 43},
  [2803] = {.lex_state = 21, .external_lex_state = 43},
  [2804] = {.lex_state = 21, .external_lex_state = 44},
  [2805] = {.lex_state = 21, .external_lex_state = 39},
  [2806] = {.lex_state = 21, .external_lex_state = 39},
  [2807] = {.lex_state = 21, .external_lex_state = 43},
  [2808] = {.lex_state = 21, .external_lex_state = 43},
  [2809] = {.lex_state = 21, .external_lex_state = 43},
  [2810] = {.lex_state = 21, .external_lex_state = 44},
  [2811] = {.lex_state = 21, .external_lex_state = 43},
  [2812] = {.lex_state = 21, .external_lex_state = 41},
  [2813] = {.lex_state = 0, .external_lex_state = 42},
  [2814] = {.lex_state = 21, .external_lex_state = 43},
  [2815] = {.lex_state = 21, .external_lex_state = 44},
  [2816] = {.lex_state = 21, .external_lex_state = 45},
  [2817] = {.lex_state = 21, .external_lex_state = 44},
  [2818] = {.lex_state = 21, .external_lex_state = 39},
  [2819] = {.lex_state = 21, .external_lex_state = 39},
  [2820] = {.lex_state = 21, .external_lex_state = 45},
  [2821] = {.lex_state = 21, .external_lex_state = 39},
  [2822] = {.lex_state = 21, .external_lex_state = 39},
  [2823] = {.lex_state = 21, .external_lex_state = 39},
  [2824] = {.lex_state = 21, .external_lex_state = 39},
  [2825] = {.lex_state = 21, .external_lex_state = 45},
  [2826] = {.lex_state = 21, .external_lex_state = 39},
  [2827] = {.lex_state = 21, .external_lex_state = 39},
  [2828] = {.lex_state = 21, .external_lex_state = 39},
  [2829] = {.lex_state = 0, .external_lex_state = 42},
  [2830] = {.lex_state = 21, .external_lex_state = 39},
  [2831] = {.lex_state = 21, .external_lex_state = 43},
  [2832] = {.lex_state = 21, .external_lex_state = 39},
  [2833] = {.lex_state = 21, .external_lex_state = 39},
  [2834] = {.lex_state = 21, .external_lex_state = 39},
  [2835] = {.lex_state = 21, .external_lex_state = 39},
  [2836] = {.lex_state = 21, .external_lex_state = 43},
  [2837] = {.lex_state = 0, .external_lex_state = 42},
  [2838] = {.lex_state = 21, .external_lex_state = 43},
  [2839] = {.lex_state = 21, .external_lex_state = 43},
  [2840] = {.lex_state = 21, .external_lex_state = 39},
  [2841] = {.lex_state = 21, .external_lex_state = 45},
  [2842] = {.lex_state = 21, .external_lex_state = 44},
  [2843] = {.lex_state = 21, .external_lex_state = 43},
  [2844] = {.lex_state = 21, .external_lex_state = 39},
  [2845] = {.lex_state = 21, .external_lex_state = 41},
  [2846] = {.lex_state = 0, .external_lex_state = 41},
  [2847] = {.lex_state = 23, .external_lex_state = 41},
  [2848] = {.lex_state = 21, .external_lex_state = 41},
  [2849] = {.lex_state = 21, .external_lex_state = 44},
  [2850] = {.lex_state = 21, .external_lex_state = 41},
  [2851] = {.lex_state = 23, .external_lex_state = 41},
  [2852] = {.lex_state = 0, .external_lex_state = 41},
  [2853] = {.lex_state = 21, .external_lex_state = 41},
  [2854] = {.lex_state = 21, .external_lex_state = 41},
  [2855] = {.lex_state = 21, .external_lex_state = 41},
  [2856] = {.lex_state = 21, .external_lex_state = 41},
  [2857] = {.lex_state = 21, .external_lex_state = 41},
  [2858] = {.lex_state = 21, .external_lex_state = 41},
  [2859] = {.lex_state = 21, .external_lex_state = 41},
  [2860] = {.lex_state = 21, .external_lex_state = 41},
  [2861] = {.lex_state = 21, .external_lex_state = 41},
  [2862] = {.lex_state = 21, .external_lex_state = 41},
  [2863] = {.lex_state = 21, .external_lex_state = 41},
  [2864] = {.lex_state = 21, .external_lex_state = 41},
  [2865] = {.lex_state = 21, .external_lex_state = 41},
  [2866] = {.lex_state = 21, .external_lex_state = 41},
  [2867] = {.lex_state = 21, .external_lex_state = 46},
  [2868] = {.lex_state = 21, .external_lex_state = 47},
  [2869] = {.lex_state = 21, .external_lex_state = 48},
  [2870] = {.lex_state = 21, .external_lex_state = 46},
  [2871] = {.lex_state = 21, .external_lex_state = 46},
  [2872] = {.lex_state = 21, .external_lex_state = 46},
  [2873] = {.lex_state = 21, .external_lex_state = 41},
  [2874] = {.lex_state = 21, .external_lex_state = 41},
  [2875] = {.lex_state = 21, .external_lex_state = 49},
  [2876] = {.lex_state = 21, .external_lex_state = 41},
  [2877] = {.lex_state = 21, .external_lex_state = 46},
  [2878] = {.lex_state = 21, .external_lex_state = 46},
  [2879] = {.lex_state = 21, .external_lex_state = 41},
  [2880] = {.lex_state = 21, .external_lex_state = 41},
  [2881] = {.lex_state = 21, .external_lex_state = 46},
  [2882] = {.lex_state = 21, .external_lex_state = 45},
  [2883] = {.lex_state = 21, .external_lex_state = 41},
  [2884] = {.lex_state = 21, .external_lex_state = 41},
  [2885] = {.lex_state = 20, .external_lex_state = 41},
  [2886] = {.lex_state = 21, .external_lex_state = 46},
  [2887] = {.lex_state = 21, .external_lex_state = 48},
  [2888] = {.lex_state = 21, .external_lex_state = 46},
  [2889] = {.lex_state = 21, .external_lex_state = 41},
  [2890] = {.lex_state = 21, .external_lex_state = 47},
  [2891] = {.lex_state = 21, .external_lex_state = 41},
  [2892] = {.lex_state = 21, .external_lex_state = 43},
  [2893] = {.lex_state = 21, .external_lex_state = 43},
  [2894] = {.lex_state = 21, .external_lex_state = 46},
  [2895] = {.lex_state = 21, .external_lex_state = 49},
  [2896] = {.lex_state = 21, .external_lex_state = 41},
  [2897] = {.lex_state = 21, .external_lex_state = 46},
  [2898] = {.lex_state = 21, .external_lex_state = 41},
  [2899] = {.lex_state = 21, .external_lex_state = 46},
  [2900] = {.lex_state = 21, .external_lex_state = 46},
  [2901] = {.lex_state = 21, .external_lex_state = 44},
  [2902] = {.lex_state = 21, .external_lex_state = 45},
  [2903] = {.lex_state = 21, .external_lex_state = 41},
  [2904] = {.lex_state = 21, .external_lex_state = 47},
  [2905] = {.lex_state = 21, .external_lex_state = 47},
  [2906] = {.lex_state = 21, .external_lex_state = 43},
  [2907] = {.lex_state = 21, .external_lex_state = 43},
  [2908] = {.lex_state = 21, .external_lex_state = 43},
  [2909] = {.lex_state = 21, .external_lex_state = 45},
  [2910] = {.lex_state = 21, .external_lex_state = 43},
  [2911] = {.lex_state = 0, .external_lex_state = 41},
  [2912] = {.lex_state = 0, .external_lex_state = 41},
  [2913] = {.lex_state = 0, .external_lex_state = 41},
  [2914] = {.lex_state = 0, .external_lex_state = 41},
  [2915] = {.lex_state = 0, .external_lex_state = 41},
  [2916] = {.lex_state = 21, .external_lex_state = 43},
  [2917] = {.lex_state = 20, .external_lex_state = 41},
  [2918] = {.lex_state = 0, .external_lex_state = 41},
  [2919] = {.lex_state = 0, .external_lex_state = 41},
  [2920] = {.lex_state = 0, .external_lex_state = 41},
  [2921] = {.lex_state = 0, .external_lex_state = 41},
  [2922] = {.lex_state = 0, .external_lex_state = 41},
  [2923] = {.lex_state = 0, .external_lex_state = 41},
  [2924] = {.lex_state = 21, .external_lex_state = 41},
  [2925] = {.lex_state = 0, .external_lex_state = 41},
  [2926] = {.lex_state = 0, .external_lex_state = 41},
  [2927] = {.lex_state = 0, .external_lex_state = 41},
  [2928] = {.lex_state = 21, .external_lex_state = 47},
  [2929] = {.lex_state = 21, .external_lex_state = 41},
  [2930] = {.lex_state = 0, .external_lex_state = 41},
  [2931] = {.lex_state = 0, .external_lex_state = 41},
  [2932] = {.lex_state = 0, .external_lex_state = 41},
  [2933] = {.lex_state = 21, .external_lex_state = 41},
  [2934] = {.lex_state = 0, .external_lex_state = 41},
  [2935] = {.lex_state = 21, .external_lex_state = 47},
  [2936] = {.lex_state = 21, .external_lex_state = 41},
  [2937] = {.lex_state = 0, .external_lex_state = 41},
  [2938] = {.lex_state = 0, .external_lex_state = 41},
  [2939] = {.lex_state = 0, .external_lex_state = 41},
  [2940] = {.lex_state = 0, .external_lex_state = 41},
  [2941] = {.lex_state = 0, .external_lex_state = 41},
  [2942] = {.lex_state = 0, .external_lex_state = 41},
  [2943] = {.lex_state = 0, .external_lex_state = 41},
  [2944] = {.lex_state = 0, .external_lex_state = 41},
  [2945] = {.lex_state = 20, .external_lex_state = 41},
  [2946] = {.lex_state = 0, .external_lex_state = 41},
  [2947] = {.lex_state = 20, .external_lex_state = 41},
  [2948] = {.lex_state = 21, .external_lex_state = 47},
  [2949] = {.lex_state = 0, .external_lex_state = 41},
  [2950] = {.lex_state = 0, .external_lex_state = 41},
  [2951] = {.lex_state = 0, .external_lex_state = 41},
  [2952] = {.lex_state = 20, .external_lex_state = 41},
  [2953] = {.lex_state = 20, .external_lex_state = 41},
  [2954] = {.lex_state = 21, .external_lex_state = 41},
  [2955] = {.lex_state = 21, .external_lex_state = 44},
  [2956] = {.lex_state = 21, .external_lex_state = 50},
  [2957] = {.lex_state = 21, .external_lex_state = 41},
  [2958] = {.lex_state = 21, .external_lex_state = 44},
  [2959] = {.lex_state = 0, .external_lex_state = 41},
  [2960] = {.lex_state = 0, .external_lex_state = 41},
  [2961] = {.lex_state = 0, .external_lex_state = 41},
  [2962] = {.lex_state = 21, .external_lex_state = 39},
  [2963] = {.lex_state = 21, .external_lex_state = 39},
  [2964] = {.lex_state = 0, .external_lex_state = 41},
  [2965] = {.lex_state = 21, .external_lex_state = 44},
  [2966] = {.lex_state = 21, .external_lex_state = 47},
  [2967] = {.lex_state = 0, .external_lex_state = 41},
  [2968] = {.lex_state = 0, .external_lex_state = 41},
  [2969] = {.lex_state = 21, .external_lex_state = 41},
  [2970] = {.lex_state = 21, .external_lex_state = 50},
  [2971] = {.lex_state = 0, .external_lex_state = 41},
  [2972] = {.lex_state = 0, .external_lex_state = 41},
  [2973] = {.lex_state = 20, .external_lex_state = 41},
  [2974] = {.lex_state = 0, .external_lex_state = 41},
  [2975] = {.lex_state = 0, .external_lex_state = 41},
  [2976] = {.lex_state = 20, .external_lex_state = 41},
  [2977] = {.lex_state = 0, .external_lex_state = 41},
  [2978] = {.lex_state = 0, .external_lex_state = 41},
  [2979] = {.lex_state = 0, .external_lex_state = 41},
  [2980] = {.lex_state = 0, .external_lex_state = 41},
  [2981] = {.lex_state = 0, .external_lex_state = 41},
  [2982] = {.lex_state = 0, .external_lex_state = 41},
  [2983] = {.lex_state = 21, .external_lex_state = 47},
  [2984] = {.lex_state = 0, .external_lex_state = 41},
  [2985] = {.lex_state = 0, .external_lex_state = 41},
  [2986] = {.lex_state = 0, .external_lex_state = 41},
  [2987] = {.lex_state = 21, .external_lex_state = 41},
  [2988] = {.lex_state = 21, .external_lex_state = 44},
  [2989] = {.lex_state = 0, .external_lex_state = 41},
  [2990] = {.lex_state = 0, .external_lex_state = 41},
  [2991] = {.lex_state = 21, .external_lex_state = 44},
  [2992] = {.lex_state = 20, .external_lex_state = 41},
  [2993] = {.lex_state = 20, .external_lex_state = 41},
  [2994] = {.lex_state = 0, .external_lex_state = 41},
  [2995] = {.lex_state = 20, .external_lex_state = 41},
  [2996] = {.lex_state = 21, .external_lex_state = 41},
  [2997] = {.lex_state = 21, .external_lex_state = 41},
  [2998] = {.lex_state = 0, .external_lex_state = 41},
  [2999] = {.lex_state = 0, .external_lex_state = 41},
  [3000] = {.lex_state = 0, .external_lex_state = 41},
  [3001] = {.lex_state = 0, .external_lex_state = 41},
  [3002] = {.lex_state = 20, .external_lex_state = 41},
  [3003] = {.lex_state = 0, .external_lex_state = 41},
  [3004] = {.lex_state = 20, .external_lex_state = 41},
  [3005] = {.lex_state = 20, .external_lex_state = 41},
  [3006] = {.lex_state = 20, .external_lex_state = 41},
  [3007] = {.lex_state = 0, .external_lex_state = 41},
  [3008] = {.lex_state = 20, .external_lex_state = 41},
  [3009] = {.lex_state = 0, .external_lex_state = 41},
  [3010] = {.lex_state = 21, .external_lex_state = 47},
  [3011] = {.lex_state = 0, .external_lex_state = 41},
  [3012] = {.lex_state = 21, .external_lex_state = 43},
  [3013] = {.lex_state = 21, .external_lex_state = 44},
  [3014] = {.lex_state = 20, .external_lex_state = 41},
  [3015] = {.lex_state = 21, .external_lex_state = 41},
  [3016] = {.lex_state = 21, .external_lex_state = 41},
  [3017] = {.lex_state = 0, .external_lex_state = 41},
  [3018] = {.lex_state = 0, .external_lex_state = 41},
  [3019] = {.lex_state = 21, .external_lex_state = 44},
  [3020] = {.lex_state = 0, .external_lex_state = 41},
  [3021] = {.lex_state = 20, .external_lex_state = 41},
  [3022] = {.lex_state = 0, .external_lex_state = 41},
  [3023] = {.lex_state = 20, .external_lex_state = 41},
  [3024] = {.lex_state = 21, .external_lex_state = 41},
  [3025] = {.lex_state = 0, .external_lex_state = 41},
  [3026] = {.lex_state = 21, .external_lex_state = 47},
  [3027] = {.lex_state = 0, .external_lex_state = 41},
  [3028] = {.lex_state = 0, .external_lex_state = 41},
  [3029] = {.lex_state = 0, .external_lex_state = 41},
  [3030] = {.lex_state = 21, .external_lex_state = 47},
  [3031] = {.lex_state = 0, .external_lex_state = 41},
  [3032] = {.lex_state = 0, .external_lex_state = 41},
  [3033] = {.lex_state = 21, .external_lex_state = 41},
  [3034] = {.lex_state = 0, .external_lex_state = 41},
  [3035] = {.lex_state = 21, .external_lex_state = 41},
  [3036] = {.lex_state = 21, .external_lex_state = 41},
  [3037] = {.lex_state = 21, .external_lex_state = 41},
  [3038] = {.lex_state = 0, .external_lex_state = 41},
  [3039] = {.lex_state = 0, .external_lex_state = 41},
  [3040] = {.lex_state = 0, .external_lex_state = 41},
  [3041] = {.lex_state = 21, .external_lex_state = 41},
  [3042] = {.lex_state = 0, .external_lex_state = 41},
  [3043] = {.lex_state = 20, .external_lex_state = 41},
  [3044] = {.lex_state = 0, .external_lex_state = 41},
  [3045] = {.lex_state = 21, .external_lex_state = 41},
  [3046] = {.lex_state = 0, .external_lex_state = 41},
  [3047] = {.lex_state = 0, .external_lex_state = 41},
  [3048] = {.lex_state = 0, .external_lex_state = 41},
  [3049] = {.lex_state = 0, .external_lex_state = 41},
  [3050] = {.lex_state = 20, .external_lex_state = 41},
  [3051] = {.lex_state = 0, .external_lex_state = 41},
  [3052] = {.lex_state = 0, .external_lex_state = 41},
  [3053] = {.lex_state = 0, .external_lex_state = 41},
  [3054] = {.lex_state = 0, .external_lex_state = 41},
  [3055] = {.lex_state = 0, .external_lex_state = 41},
  [3056] = {.lex_state = 21, .external_lex_state = 41},
  [3057] = {.lex_state = 20, .external_lex_state = 41},
  [3058] = {.lex_state = 0, .external_lex_state = 41},
  [3059] = {.lex_state = 0, .external_lex_state = 41},
  [3060] = {.lex_state = 20, .external_lex_state = 41},
  [3061] = {.lex_state = 0, .external_lex_state = 41},
  [3062] = {.lex_state = 0, .external_lex_state = 41},
  [3063] = {.lex_state = 20, .external_lex_state = 41},
  [3064] = {.lex_state = 21, .external_lex_state = 49},
  [3065] = {.lex_state = 21, .external_lex_state = 41},
  [3066] = {.lex_state = 0, .external_lex_state = 41},
  [3067] = {.lex_state = 0, .external_lex_state = 41},
  [3068] = {.lex_state = 0, .external_lex_state = 41},
  [3069] = {.lex_state = 0, .external_lex_state = 41},
  [3070] = {.lex_state = 0, .external_lex_state = 41},
  [3071] = {.lex_state = 21, .external_lex_state = 41},
  [3072] = {.lex_state = 0, .external_lex_state = 41},
  [3073] = {.lex_state = 21, .external_lex_state = 41},
  [3074] = {.lex_state = 21, .external_lex_state = 43},
  [3075] = {.lex_state = 21, .external_lex_state = 41},
  [3076] = {.lex_state = 0, .external_lex_state = 51},
  [3077] = {.lex_state = 21, .external_lex_state = 41},
  [3078] = {.lex_state = 0, .external_lex_state = 41},
  [3079] = {.lex_state = 0, .external_lex_state = 41},
  [3080] = {.lex_state = 0, .external_lex_state = 41},
  [3081] = {.lex_state = 0, .external_lex_state = 41},
  [3082] = {.lex_state = 0, .external_lex_state = 41},
  [3083] = {.lex_state = 0, .external_lex_state = 41},
  [3084] = {.lex_state = 0, .external_lex_state = 41},
  [3085] = {.lex_state = 21, .external_lex_state = 41},
  [3086] = {.lex_state = 0, .external_lex_state = 41},
  [3087] = {.lex_state = 0, .external_lex_state = 41},
  [3088] = {.lex_state = 0, .external_lex_state = 41},
  [3089] = {.lex_state = 0, .external_lex_state = 41},
  [3090] = {.lex_state = 0, .external_lex_state = 41},
  [3091] = {.lex_state = 0, .external_lex_state = 41},
  [3092] = {.lex_state = 20, .external_lex_state = 41},
  [3093] = {.lex_state = 0, .external_lex_state = 41},
  [3094] = {.lex_state = 0, .external_lex_state = 41},
  [3095] = {.lex_state = 21, .external_lex_state = 41},
  [3096] = {.lex_state = 21, .external_lex_state = 41},
  [3097] = {.lex_state = 0, .external_lex_state = 41},
  [3098] = {.lex_state = 21, .external_lex_state = 48},
  [3099] = {.lex_state = 0, .external_lex_state = 41},
  [3100] = {.lex_state = 0, .external_lex_state = 41},
  [3101] = {.lex_state = 0, .external_lex_state = 41},
  [3102] = {.lex_state = 0, .external_lex_state = 41},
  [3103] = {.lex_state = 0, .external_lex_state = 41},
  [3104] = {.lex_state = 21, .external_lex_state = 46},
  [3105] = {.lex_state = 20, .external_lex_state = 41},
  [3106] = {.lex_state = 20, .external_lex_state = 41},
  [3107] = {.lex_state = 21, .external_lex_state = 41},
  [3108] = {.lex_state = 0, .external_lex_state = 41},
  [3109] = {.lex_state = 0, .external_lex_state = 41},
  [3110] = {.lex_state = 0, .external_lex_state = 41},
  [3111] = {.lex_state = 0, .external_lex_state = 41},
  [3112] = {.lex_state = 0, .external_lex_state = 41},
  [3113] = {.lex_state = 0, .external_lex_state = 41},
  [3114] = {.lex_state = 20, .external_lex_state = 41},
  [3115] = {.lex_state = 0, .external_lex_state = 41},
  [3116] = {.lex_state = 0, .external_lex_state = 41},
  [3117] = {.lex_state = 0, .external_lex_state = 41},
  [3118] = {.lex_state = 20, .external_lex_state = 41},
  [3119] = {.lex_state = 0, .external_lex_state = 41},
  [3120] = {.lex_state = 21, .external_lex_state = 41},
  [3121] = {.lex_state = 0, .external_lex_state = 41},
  [3122] = {.lex_state = 0, .external_lex_state = 41},
  [3123] = {.lex_state = 0, .external_lex_state = 41},
  [3124] = {.lex_state = 0, .external_lex_state = 41},
  [3125] = {.lex_state = 20, .external_lex_state = 41},
  [3126] = {.lex_state = 21, .external_lex_state = 49},
  [3127] = {.lex_state = 21, .external_lex_state = 49},
  [3128] = {.lex_state = 0, .external_lex_state = 41},
  [3129] = {.lex_state = 20, .external_lex_state = 41},
  [3130] = {.lex_state = 20, .external_lex_state = 41},
  [3131] = {.lex_state = 21, .external_lex_state = 49},
  [3132] = {.lex_state = 20, .external_lex_state = 41},
  [3133] = {.lex_state = 21, .external_lex_state = 49},
  [3134] = {.lex_state = 21, .external_lex_state = 49},
  [3135] = {.lex_state = 21, .external_lex_state = 41},
  [3136] = {.lex_state = 0, .external_lex_state = 41},
  [3137] = {.lex_state = 0, .external_lex_state = 41},
  [3138] = {.lex_state = 21, .external_lex_state = 49},
  [3139] = {.lex_state = 21, .external_lex_state = 49},
  [3140] = {.lex_state = 21, .external_lex_state = 49},
  [3141] = {.lex_state = 21, .external_lex_state = 49},
  [3142] = {.lex_state = 21, .external_lex_state = 41},
  [3143] = {.lex_state = 21, .external_lex_state = 49},
  [3144] = {.lex_state = 20, .external_lex_state = 41},
  [3145] = {.lex_state = 21, .external_lex_state = 41},
  [3146] = {.lex_state = 21, .external_lex_state = 41},
  [3147] = {.lex_state = 21, .external_lex_state = 49},
  [3148] = {.lex_state = 21, .external_lex_state = 49},
  [3149] = {.lex_state = 21, .external_lex_state = 49},
  [3150] = {.lex_state = 21, .external_lex_state = 49},
  [3151] = {.lex_state = 20, .external_lex_state = 41},
  [3152] = {.lex_state = 0, .external_lex_state = 41},
  [3153] = {.lex_state = 21, .external_lex_state = 41},
  [3154] = {.lex_state = 21, .external_lex_state = 49},
  [3155] = {.lex_state = 21, .external_lex_state = 49},
  [3156] = {.lex_state = 21, .external_lex_state = 49},
  [3157] = {.lex_state = 21, .external_lex_state = 49},
  [3158] = {.lex_state = 21, .external_lex_state = 49},
  [3159] = {.lex_state = 0, .external_lex_state = 41},
  [3160] = {.lex_state = 21, .external_lex_state = 49},
  [3161] = {.lex_state = 21, .external_lex_state = 49},
  [3162] = {.lex_state = 20, .external_lex_state = 41},
  [3163] = {.lex_state = 21, .external_lex_state = 49},
  [3164] = {.lex_state = 21, .external_lex_state = 49},
  [3165] = {.lex_state = 21, .external_lex_state = 49},
  [3166] = {.lex_state = 21, .external_lex_state = 49},
  [3167] = {.lex_state = 21, .external_lex_state = 49},
  [3168] = {.lex_state = 21, .external_lex_state = 49},
  [3169] = {.lex_state = 21, .external_lex_state = 49},
  [3170] = {.lex_state = 21, .external_lex_state = 49},
  [3171] = {.lex_state = 21, .external_lex_state = 49},
  [3172] = {.lex_state = 21, .external_lex_state = 49},
  [3173] = {.lex_state = 21, .external_lex_state = 48},
  [3174] = {.lex_state = 20, .external_lex_state = 41},
  [3175] = {.lex_state = 0, .external_lex_state = 41},
  [3176] = {.lex_state = 21, .external_lex_state = 41},
  [3177] = {.lex_state = 0, .external_lex_state = 41},
  [3178] = {.lex_state = 21, .external_lex_state = 49},
  [3179] = {.lex_state = 21, .external_lex_state = 49},
  [3180] = {.lex_state = 21, .external_lex_state = 41},
  [3181] = {.lex_state = 21, .external_lex_state = 41},
  [3182] = {.lex_state = 0, .external_lex_state = 41},
  [3183] = {.lex_state = 21, .external_lex_state = 41},
  [3184] = {.lex_state = 0, .external_lex_state = 41},
  [3185] = {.lex_state = 20, .external_lex_state = 41},
  [3186] = {.lex_state = 21, .external_lex_state = 49},
  [3187] = {.lex_state = 21, .external_lex_state = 49},
  [3188] = {.lex_state = 21, .external_lex_state = 41},
  [3189] = {.lex_state = 21, .external_lex_state = 49},
  [3190] = {.lex_state = 21, .external_lex_state = 49},
  [3191] = {.lex_state = 21, .external_lex_state = 41},
  [3192] = {.lex_state = 21, .external_lex_state = 49},
  [3193] = {.lex_state = 21, .external_lex_state = 41},
  [3194] = {.lex_state = 21, .external_lex_state = 41},
  [3195] = {.lex_state = 21, .external_lex_state = 49},
  [3196] = {.lex_state = 21, .external_lex_state = 41},
  [3197] = {.lex_state = 20, .external_lex_state = 41},
  [3198] = {.lex_state = 0, .external_lex_state = 41},
  [3199] = {.lex_state = 0, .external_lex_state = 41},
  [3200] = {.lex_state = 21, .external_lex_state = 49},
  [3201] = {.lex_state = 21, .external_lex_state = 49},
  [3202] = {.lex_state = 0, .external_lex_state = 41},
  [3203] = {.lex_state = 21, .external_lex_state = 49},
  [3204] = {.lex_state = 21, .external_lex_state = 49},
  [3205] = {.lex_state = 0, .external_lex_state = 41},
  [3206] = {.lex_state = 21, .external_lex_state = 49},
  [3207] = {.lex_state = 21, .external_lex_state = 49},
  [3208] = {.lex_state = 20, .external_lex_state = 41},
  [3209] = {.lex_state = 21, .external_lex_state = 41},
  [3210] = {.lex_state = 21, .external_lex_state = 50},
  [3211] = {.lex_state = 21, .external_lex_state = 49},
  [3212] = {.lex_state = 21, .external_lex_state = 49},
  [3213] = {.lex_state = 21, .external_lex_state = 49},
  [3214] = {.lex_state = 0, .external_lex_state = 41},
  [3215] = {.lex_state = 20, .external_lex_state = 41},
  [3216] = {.lex_state = 21, .external_lex_state = 49},
  [3217] = {.lex_state = 21, .external_lex_state = 49},
  [3218] = {.lex_state = 0, .external_lex_state = 41},
  [3219] = {.lex_state = 21, .external_lex_state = 43},
  [3220] = {.lex_state = 0, .external_lex_state = 41},
  [3221] = {.lex_state = 0, .external_lex_state = 41},
  [3222] = {.lex_state = 21, .external_lex_state = 49},
  [3223] = {.lex_state = 21, .external_lex_state = 49},
  [3224] = {.lex_state = 21, .external_lex_state = 41},
  [3225] = {.lex_state = 21, .external_lex_state = 49},
  [3226] = {.lex_state = 21, .external_lex_state = 49},
  [3227] = {.lex_state = 21, .external_lex_state = 41},
  [3228] = {.lex_state = 0, .external_lex_state = 41},
  [3229] = {.lex_state = 0, .external_lex_state = 41},
  [3230] = {.lex_state = 21, .external_lex_state = 47},
  [3231] = {.lex_state = 21, .external_lex_state = 41},
  [3232] = {.lex_state = 0, .external_lex_state = 41},
  [3233] = {.lex_state = 21, .external_lex_state = 41},
  [3234] = {.lex_state = 21, .external_lex_state = 41},
  [3235] = {.lex_state = 21, .external_lex_state = 49},
  [3236] = {.lex_state = 21, .external_lex_state = 49},
  [3237] = {.lex_state = 20, .external_lex_state = 41},
  [3238] = {.lex_state = 0, .external_lex_state = 41},
  [3239] = {.lex_state = 20, .external_lex_state = 41},
  [3240] = {.lex_state = 21, .external_lex_state = 49},
  [3241] = {.lex_state = 21, .external_lex_state = 49},
  [3242] = {.lex_state = 21, .external_lex_state = 49},
  [3243] = {.lex_state = 21, .external_lex_state = 41},
  [3244] = {.lex_state = 20, .external_lex_state = 41},
  [3245] = {.lex_state = 21, .external_lex_state = 49},
  [3246] = {.lex_state = 21, .external_lex_state = 41},
  [3247] = {.lex_state = 21, .external_lex_state = 49},
  [3248] = {.lex_state = 21, .external_lex_state = 41},
  [3249] = {.lex_state = 20, .external_lex_state = 41},
  [3250] = {.lex_state = 21, .external_lex_state = 49},
  [3251] = {.lex_state = 20, .external_lex_state = 41},
  [3252] = {.lex_state = 0, .external_lex_state = 41},
  [3253] = {.lex_state = 20, .external_lex_state = 41},
  [3254] = {.lex_state = 21, .external_lex_state = 49},
  [3255] = {.lex_state = 21, .external_lex_state = 49},
  [3256] = {.lex_state = 21, .external_lex_state = 49},
  [3257] = {.lex_state = 21, .external_lex_state = 41},
  [3258] = {.lex_state = 0, .external_lex_state = 41},
  [3259] = {.lex_state = 0, .external_lex_state = 41},
  [3260] = {.lex_state = 21, .external_lex_state = 49},
  [3261] = {.lex_state = 21, .external_lex_state = 41},
  [3262] = {.lex_state = 21, .external_lex_state = 49},
  [3263] = {.lex_state = 21, .external_lex_state = 49},
  [3264] = {.lex_state = 0, .external_lex_state = 41},
  [3265] = {.lex_state = 21, .external_lex_state = 41},
  [3266] = {.lex_state = 21, .external_lex_state = 41},
  [3267] = {.lex_state = 21, .external_lex_state = 41},
  [3268] = {.lex_state = 21, .external_lex_state = 49},
  [3269] = {.lex_state = 21, .external_lex_state = 41},
  [3270] = {.lex_state = 21, .external_lex_state = 49},
  [3271] = {.lex_state = 21, .external_lex_state = 48},
  [3272] = {.lex_state = 21, .external_lex_state = 49},
  [3273] = {.lex_state = 21, .external_lex_state = 41},
  [3274] = {.lex_state = 20, .external_lex_state = 41},
  [3275] = {.lex_state = 21, .external_lex_state = 41},
  [3276] = {.lex_state = 0, .external_lex_state = 41},
  [3277] = {.lex_state = 21, .external_lex_state = 41},
  [3278] = {.lex_state = 21, .external_lex_state = 49},
  [3279] = {.lex_state = 21, .external_lex_state = 49},
  [3280] = {.lex_state = 0, .external_lex_state = 41},
  [3281] = {.lex_state = 21, .external_lex_state = 41},
  [3282] = {.lex_state = 21, .external_lex_state = 49},
  [3283] = {.lex_state = 21, .external_lex_state = 49},
  [3284] = {.lex_state = 0, .external_lex_state = 52},
  [3285] = {.lex_state = 21, .external_lex_state = 41},
  [3286] = {.lex_state = 21, .external_lex_state = 41},
  [3287] = {.lex_state = 21, .external_lex_state = 49},
  [3288] = {.lex_state = 16, .external_lex_state = 41},
  [3289] = {.lex_state = 21, .external_lex_state = 41},
  [3290] = {.lex_state = 21, .external_lex_state = 49},
  [3291] = {.lex_state = 21, .external_lex_state = 49},
  [3292] = {.lex_state = 21, .external_lex_state = 41},
  [3293] = {.lex_state = 21, .external_lex_state = 41},
  [3294] = {.lex_state = 21, .external_lex_state = 49},
  [3295] = {.lex_state = 21, .external_lex_state = 49},
  [3296] = {.lex_state = 0, .external_lex_state = 41},
  [3297] = {.lex_state = 21, .external_lex_state = 41},
  [3298] = {.lex_state = 21, .external_lex_state = 41},
  [3299] = {.lex_state = 21, .external_lex_state = 49},
  [3300] = {.lex_state = 21, .external_lex_state = 49},
  [3301] = {.lex_state = 21, .external_lex_state = 49},
  [3302] = {.lex_state = 20, .external_lex_state = 41},
  [3303] = {.lex_state = 0, .external_lex_state = 41},
  [3304] = {.lex_state = 21, .external_lex_state = 41},
  [3305] = {.lex_state = 0, .external_lex_state = 41},
  [3306] = {.lex_state = 21, .external_lex_state = 49},
  [3307] = {.lex_state = 21, .external_lex_state = 41},
  [3308] = {.lex_state = 21, .external_lex_state = 49},
  [3309] = {.lex_state = 21, .external_lex_state = 49},
  [3310] = {.lex_state = 21, .external_lex_state = 41},
  [3311] = {.lex_state = 21, .external_lex_state = 49},
  [3312] = {.lex_state = 16, .external_lex_state = 41},
  [3313] = {.lex_state = 21, .external_lex_state = 49},
  [3314] = {.lex_state = 0, .external_lex_state = 41},
  [3315] = {.lex_state = 21, .external_lex_state = 49},
  [3316] = {.lex_state = 21, .external_lex_state = 41},
  [3317] = {.lex_state = 21, .external_lex_state = 49},
  [3318] = {.lex_state = 21, .external_lex_state = 48},
  [3319] = {.lex_state = 20, .external_lex_state = 41},
  [3320] = {.lex_state = 0, .external_lex_state = 41},
  [3321] = {.lex_state = 21, .external_lex_state = 41},
  [3322] = {.lex_state = 20, .external_lex_state = 41},
  [3323] = {.lex_state = 16, .external_lex_state = 41},
  [3324] = {.lex_state = 21, .external_lex_state = 41},
  [3325] = {.lex_state = 21, .external_lex_state = 49},
  [3326] = {.lex_state = 21, .external_lex_state = 41},
  [3327] = {.lex_state = 2, .external_lex_state = 41},
  [3328] = {.lex_state = 0, .external_lex_state = 41},
  [3329] = {.lex_state = 0, .external_lex_state = 41},
  [3330] = {.lex_state = 0, .external_lex_state = 41},
  [3331] = {.lex_state = 21, .external_lex_state = 50},
  [3332] = {.lex_state = 21, .external_lex_state = 41},
  [3333] = {.lex_state = 21, .external_lex_state = 49},
  [3334] = {.lex_state = 21, .external_lex_state = 49},
  [3335] = {.lex_state = 21, .external_lex_state = 41},
  [3336] = {.lex_state = 21, .external_lex_state = 49},
  [3337] = {.lex_state = 21, .external_lex_state = 49},
  [3338] = {.lex_state = 0, .external_lex_state = 41},
  [3339] = {.lex_state = 0, .external_lex_state = 41},
  [3340] = {.lex_state = 0, .external_lex_state = 41},
  [3341] = {.lex_state = 21, .external_lex_state = 49},
  [3342] = {.lex_state = 21, .external_lex_state = 49},
  [3343] = {.lex_state = 21, .external_lex_state = 49},
  [3344] = {.lex_state = 20, .external_lex_state = 41},
  [3345] = {.lex_state = 21, .external_lex_state = 41},
  [3346] = {.lex_state = 0, .external_lex_state = 41},
  [3347] = {.lex_state = 16, .external_lex_state = 41},
  [3348] = {.lex_state = 21, .external_lex_state = 41},
  [3349] = {.lex_state = 0, .external_lex_state = 41},
  [3350] = {.lex_state = 21, .external_lex_state = 49},
  [3351] = {.lex_state = 21, .external_lex_state = 41},
  [3352] = {.lex_state = 21, .external_lex_state = 49},
  [3353] = {.lex_state = 21, .external_lex_state = 48},
  [3354] = {.lex_state = 21, .external_lex_state = 49},
  [3355] = {.lex_state = 21, .external_lex_state = 49},
  [3356] = {.lex_state = 21, .external_lex_state = 41},
  [3357] = {.lex_state = 21, .external_lex_state = 49},
  [3358] = {.lex_state = 16, .external_lex_state = 41},
  [3359] = {.lex_state = 21, .external_lex_state = 41},
  [3360] = {.lex_state = 21, .external_lex_state = 49},
  [3361] = {.lex_state = 21, .external_lex_state = 41},
  [3362] = {.lex_state = 0, .external_lex_state = 41},
  [3363] = {.lex_state = 21, .external_lex_state = 49},
  [3364] = {.lex_state = 0, .external_lex_state = 41},
  [3365] = {.lex_state = 21, .external_lex_state = 50},
  [3366] = {.lex_state = 21, .external_lex_state = 49},
  [3367] = {.lex_state = 21, .external_lex_state = 49},
  [3368] = {.lex_state = 21, .external_lex_state = 49},
  [3369] = {.lex_state = 21, .external_lex_state = 41},
  [3370] = {.lex_state = 0, .external_lex_state = 41},
  [3371] = {.lex_state = 21, .external_lex_state = 49},
  [3372] = {.lex_state = 21, .external_lex_state = 49},
  [3373] = {.lex_state = 0, .external_lex_state = 41},
  [3374] = {.lex_state = 0, .external_lex_state = 41},
  [3375] = {.lex_state = 21, .external_lex_state = 49},
  [3376] = {.lex_state = 0, .external_lex_state = 41},
  [3377] = {.lex_state = 21, .external_lex_state = 49},
  [3378] = {.lex_state = 21, .external_lex_state = 49},
  [3379] = {.lex_state = 21, .external_lex_state = 41},
  [3380] = {.lex_state = 21, .external_lex_state = 41},
  [3381] = {.lex_state = 16, .external_lex_state = 41},
  [3382] = {.lex_state = 21, .external_lex_state = 49},
  [3383] = {.lex_state = 0, .external_lex_state = 41},
  [3384] = {.lex_state = 21, .external_lex_state = 49},
  [3385] = {.lex_state = 21, .external_lex_state = 41},
  [3386] = {.lex_state = 21, .external_lex_state = 49},
  [3387] = {.lex_state = 21, .external_lex_state = 48},
  [3388] = {.lex_state = 21, .external_lex_state = 49},
  [3389] = {.lex_state = 21, .external_lex_state = 49},
  [3390] = {.lex_state = 21, .external_lex_state = 41},
  [3391] = {.lex_state = 21, .external_lex_state = 49},
  [3392] = {.lex_state = 16, .external_lex_state = 41},
  [3393] = {.lex_state = 21, .external_lex_state = 41},
  [3394] = {.lex_state = 21, .external_lex_state = 49},
  [3395] = {.lex_state = 21, .external_lex_state = 41},
  [3396] = {.lex_state = 0, .external_lex_state = 41},
  [3397] = {.lex_state = 21, .external_lex_state = 41},
  [3398] = {.lex_state = 21, .external_lex_state = 49},
  [3399] = {.lex_state = 21, .external_lex_state = 50},
  [3400] = {.lex_state = 21, .external_lex_state = 49},
  [3401] = {.lex_state = 21, .external_lex_state = 49},
  [3402] = {.lex_state = 0, .external_lex_state = 41},
  [3403] = {.lex_state = 21, .external_lex_state = 41},
  [3404] = {.lex_state = 21, .external_lex_state = 49},
  [3405] = {.lex_state = 21, .external_lex_state = 41},
  [3406] = {.lex_state = 20, .external_lex_state = 41},
  [3407] = {.lex_state = 0, .external_lex_state = 41},
  [3408] = {.lex_state = 0, .external_lex_state = 41},
  [3409] = {.lex_state = 21, .external_lex_state = 49},
  [3410] = {.lex_state = 21, .external_lex_state = 49},
  [3411] = {.lex_state = 21, .external_lex_state = 49},
  [3412] = {.lex_state = 21, .external_lex_state = 41},
  [3413] = {.lex_state = 16, .external_lex_state = 41},
  [3414] = {.lex_state = 0, .external_lex_state = 41},
  [3415] = {.lex_state = 0, .external_lex_state = 41},
  [3416] = {.lex_state = 0, .external_lex_state = 41},
  [3417] = {.lex_state = 16, .external_lex_state = 41},
  [3418] = {.lex_state = 21, .external_lex_state = 41},
  [3419] = {.lex_state = 21, .external_lex_state = 49},
  [3420] = {.lex_state = 21, .external_lex_state = 49},
  [3421] = {.lex_state = 0, .external_lex_state = 41},
  [3422] = {.lex_state = 21, .external_lex_state = 41},
  [3423] = {.lex_state = 0, .external_lex_state = 41},
  [3424] = {.lex_state = 21, .external_lex_state = 41},
  [3425] = {.lex_state = 0, .external_lex_state = 41},
  [3426] = {.lex_state = 0, .external_lex_state = 41},
  [3427] = {.lex_state = 21, .external_lex_state = 41},
  [3428] = {.lex_state = 0, .external_lex_state = 41},
  [3429] = {.lex_state = 21, .external_lex_state = 41},
  [3430] = {.lex_state = 0, .external_lex_state = 41},
  [3431] = {.lex_state = 21, .external_lex_state = 49},
  [3432] = {.lex_state = 0, .external_lex_state = 41},
  [3433] = {.lex_state = 21, .external_lex_state = 49},
  [3434] = {.lex_state = 21, .external_lex_state = 49},
  [3435] = {.lex_state = 20, .external_lex_state = 41},
  [3436] = {.lex_state = 21, .external_lex_state = 49},
  [3437] = {.lex_state = 16, .external_lex_state = 41},
  [3438] = {.lex_state = 0, .external_lex_state = 41},
  [3439] = {.lex_state = 21, .external_lex_state = 49},
  [3440] = {.lex_state = 21, .external_lex_state = 41},
  [3441] = {.lex_state = 21, .external_lex_state = 49},
  [3442] = {.lex_state = 21, .external_lex_state = 49},
  [3443] = {.lex_state = 21, .external_lex_state = 41},
  [3444] = {.lex_state = 21, .external_lex_state = 41},
  [3445] = {.lex_state = 0, .external_lex_state = 41},
  [3446] = {.lex_state = 21, .external_lex_state = 41},
  [3447] = {.lex_state = 21, .external_lex_state = 41},
  [3448] = {.lex_state = 21, .external_lex_state = 49},
  [3449] = {.lex_state = 21, .external_lex_state = 41},
  [3450] = {.lex_state = 21, .external_lex_state = 41},
  [3451] = {.lex_state = 21, .external_lex_state = 41},
  [3452] = {.lex_state = 21, .external_lex_state = 49},
  [3453] = {.lex_state = 0, .external_lex_state = 41},
  [3454] = {.lex_state = 21, .external_lex_state = 49},
  [3455] = {.lex_state = 21, .external_lex_state = 49},
  [3456] = {.lex_state = 21, .external_lex_state = 49},
  [3457] = {.lex_state = 21, .external_lex_state = 49},
  [3458] = {.lex_state = 21, .external_lex_state = 49},
  [3459] = {.lex_state = 20, .external_lex_state = 41},
  [3460] = {.lex_state = 21, .external_lex_state = 49},
  [3461] = {.lex_state = 0, .external_lex_state = 41},
  [3462] = {.lex_state = 21, .external_lex_state = 41},
  [3463] = {.lex_state = 21, .external_lex_state = 41},
  [3464] = {.lex_state = 20, .external_lex_state = 41},
  [3465] = {.lex_state = 0, .external_lex_state = 41},
  [3466] = {.lex_state = 0, .external_lex_state = 41},
  [3467] = {.lex_state = 21, .external_lex_state = 49},
  [3468] = {.lex_state = 0, .external_lex_state = 41},
  [3469] = {.lex_state = 21, .external_lex_state = 49},
  [3470] = {.lex_state = 21, .external_lex_state = 49},
  [3471] = {.lex_state = 0, .external_lex_state = 41},
  [3472] = {.lex_state = 21, .external_lex_state = 49},
  [3473] = {.lex_state = 21, .external_lex_state = 41},
  [3474] = {.lex_state = 21, .external_lex_state = 49},
  [3475] = {.lex_state = 0, .external_lex_state = 41},
  [3476] = {.lex_state = 21, .external_lex_state = 41},
  [3477] = {.lex_state = 21, .external_lex_state = 49},
  [3478] = {.lex_state = 21, .external_lex_state = 41},
  [3479] = {.lex_state = 21, .external_lex_state = 49},
  [3480] = {.lex_state = 21, .external_lex_state = 41},
  [3481] = {.lex_state = 21, .external_lex_state = 49},
  [3482] = {.lex_state = 21, .external_lex_state = 49},
  [3483] = {.lex_state = 0, .external_lex_state = 41},
  [3484] = {.lex_state = 20, .external_lex_state = 41},
  [3485] = {.lex_state = 16, .external_lex_state = 41},
  [3486] = {.lex_state = 21, .external_lex_state = 49},
  [3487] = {.lex_state = 21, .external_lex_state = 49},
  [3488] = {.lex_state = 20, .external_lex_state = 41},
  [3489] = {.lex_state = 20, .external_lex_state = 41},
  [3490] = {.lex_state = 0, .external_lex_state = 41},
  [3491] = {.lex_state = 21, .external_lex_state = 49},
  [3492] = {.lex_state = 0, .external_lex_state = 41},
  [3493] = {.lex_state = 18, .external_lex_state = 41},
  [3494] = {.lex_state = 21, .external_lex_state = 49},
  [3495] = {.lex_state = 21, .external_lex_state = 49},
  [3496] = {.lex_state = 21, .external_lex_state = 49},
  [3497] = {.lex_state = 21, .external_lex_state = 41},
  [3498] = {.lex_state = 0, .external_lex_state = 41},
  [3499] = {.lex_state = 21, .external_lex_state = 41},
  [3500] = {.lex_state = 21, .external_lex_state = 49},
  [3501] = {.lex_state = 21, .external_lex_state = 49},
  [3502] = {.lex_state = 21, .external_lex_state = 49},
  [3503] = {.lex_state = 21, .external_lex_state = 49},
  [3504] = {.lex_state = 21, .external_lex_state = 49},
  [3505] = {.lex_state = 0, .external_lex_state = 41},
  [3506] = {.lex_state = 21, .external_lex_state = 49},
  [3507] = {.lex_state = 21, .external_lex_state = 49},
  [3508] = {.lex_state = 21, .external_lex_state = 49},
  [3509] = {.lex_state = 21, .external_lex_state = 41},
  [3510] = {.lex_state = 21, .external_lex_state = 48},
  [3511] = {.lex_state = 21, .external_lex_state = 49},
  [3512] = {.lex_state = 21, .external_lex_state = 49},
  [3513] = {.lex_state = 0, .external_lex_state = 41},
  [3514] = {.lex_state = 21, .external_lex_state = 49},
  [3515] = {.lex_state = 16, .external_lex_state = 41},
  [3516] = {.lex_state = 0, .external_lex_state = 41},
  [3517] = {.lex_state = 20, .external_lex_state = 41},
  [3518] = {.lex_state = 21, .external_lex_state = 49},
  [3519] = {.lex_state = 21, .external_lex_state = 49},
  [3520] = {.lex_state = 0, .external_lex_state = 41},
  [3521] = {.lex_state = 0, .external_lex_state = 41},
  [3522] = {.lex_state = 0, .external_lex_state = 41},
  [3523] = {.lex_state = 21, .external_lex_state = 41},
  [3524] = {.lex_state = 21, .external_lex_state = 49},
  [3525] = {.lex_state = 21, .external_lex_state = 49},
  [3526] = {.lex_state = 0, .external_lex_state = 41},
  [3527] = {.lex_state = 21, .external_lex_state = 49},
  [3528] = {.lex_state = 0, .external_lex_state = 41},
  [3529] = {.lex_state = 21, .external_lex_state = 49},
  [3530] = {.lex_state = 21, .external_lex_state = 48},
  [3531] = {.lex_state = 21, .external_lex_state = 41},
  [3532] = {.lex_state = 21, .external_lex_state = 49},
  [3533] = {.lex_state = 21, .external_lex_state = 49},
  [3534] = {.lex_state = 0, .external_lex_state = 41},
  [3535] = {.lex_state = 0, .external_lex_state = 41},
  [3536] = {.lex_state = 21, .external_lex_state = 49},
  [3537] = {.lex_state = 21, .external_lex_state = 41},
  [3538] = {.lex_state = 21, .external_lex_state = 49},
  [3539] = {.lex_state = 21, .external_lex_state = 41},
  [3540] = {.lex_state = 0, .external_lex_state = 41},
  [3541] = {.lex_state = 16, .external_lex_state = 41},
  [3542] = {.lex_state = 0, .external_lex_state = 41},
  [3543] = {.lex_state = 21, .external_lex_state = 41},
  [3544] = {.lex_state = 21, .external_lex_state = 41},
  [3545] = {.lex_state = 21, .external_lex_state = 49},
  [3546] = {.lex_state = 20, .external_lex_state = 41},
  [3547] = {.lex_state = 0, .external_lex_state = 41},
  [3548] = {.lex_state = 0, .external_lex_state = 41},
  [3549] = {.lex_state = 21, .external_lex_state = 41},
  [3550] = {.lex_state = 21, .external_lex_state = 49},
  [3551] = {.lex_state = 20, .external_lex_state = 41},
  [3552] = {.lex_state = 21, .external_lex_state = 49},
  [3553] = {.lex_state = 21, .external_lex_state = 41},
  [3554] = {.lex_state = 0, .external_lex_state = 41},
  [3555] = {.lex_state = 0, .external_lex_state = 41},
  [3556] = {.lex_state = 21, .external_lex_state = 41},
  [3557] = {.lex_state = 21, .external_lex_state = 49},
  [3558] = {.lex_state = 21, .external_lex_state = 41},
  [3559] = {.lex_state = 0, .external_lex_state = 41},
  [3560] = {.lex_state = 21, .external_lex_state = 41},
  [3561] = {.lex_state = 0, .external_lex_state = 41},
  [3562] = {.lex_state = 21, .external_lex_state = 49},
  [3563] = {.lex_state = 21, .external_lex_state = 41},
  [3564] = {.lex_state = 0, .external_lex_state = 41},
  [3565] = {.lex_state = 21, .external_lex_state = 49},
  [3566] = {.lex_state = 0, .external_lex_state = 41},
  [3567] = {.lex_state = 20, .external_lex_state = 41},
  [3568] = {.lex_state = 0, .external_lex_state = 41},
  [3569] = {.lex_state = 20, .external_lex_state = 41},
  [3570] = {.lex_state = 0, .external_lex_state = 41},
  [3571] = {.lex_state = 0, .external_lex_state = 41},
  [3572] = {.lex_state = 21, .external_lex_state = 49},
  [3573] = {.lex_state = 2, .external_lex_state = 41},
  [3574] = {.lex_state = 21, .external_lex_state = 49},
  [3575] = {.lex_state = 21, .external_lex_state = 49},
  [3576] = {.lex_state = 20, .external_lex_state = 41},
  [3577] = {.lex_state = 21, .external_lex_state = 41},
  [3578] = {.lex_state = 0, .external_lex_state = 41},
  [3579] = {.lex_state = 21, .external_lex_state = 49},
  [3580] = {.lex_state = 0, .external_lex_state = 41},
  [3581] = {.lex_state = 20, .external_lex_state = 41},
  [3582] = {.lex_state = 21, .external_lex_state = 49},
  [3583] = {.lex_state = 21, .external_lex_state = 49},
  [3584] = {.lex_state = 20, .external_lex_state = 41},
  [3585] = {.lex_state = 21, .external_lex_state = 49},
  [3586] = {.lex_state = 21, .external_lex_state = 49},
  [3587] = {.lex_state = 21, .external_lex_state = 49},
  [3588] = {.lex_state = 21, .external_lex_state = 49},
  [3589] = {.lex_state = 21, .external_lex_state = 49},
  [3590] = {.lex_state = 21, .external_lex_state = 41},
  [3591] = {.lex_state = 0, .external_lex_state = 41},
  [3592] = {.lex_state = 21, .external_lex_state = 49},
  [3593] = {.lex_state = 21, .external_lex_state = 41},
  [3594] = {.lex_state = 21, .external_lex_state = 47},
  [3595] = {.lex_state = 16, .external_lex_state = 41},
  [3596] = {.lex_state = 21, .external_lex_state = 49},
  [3597] = {.lex_state = 21, .external_lex_state = 41},
  [3598] = {.lex_state = 0, .external_lex_state = 41},
  [3599] = {.lex_state = 0, .external_lex_state = 41},
  [3600] = {.lex_state = 20, .external_lex_state = 41},
  [3601] = {.lex_state = 20, .external_lex_state = 41},
  [3602] = {.lex_state = 21, .external_lex_state = 49},
  [3603] = {.lex_state = 21, .external_lex_state = 41},
  [3604] = {.lex_state = 21, .external_lex_state = 41},
  [3605] = {.lex_state = 21, .external_lex_state = 49},
  [3606] = {.lex_state = 21, .external_lex_state = 41},
  [3607] = {.lex_state = 21, .external_lex_state = 47},
  [3608] = {.lex_state = 21, .external_lex_state = 49},
  [3609] = {.lex_state = 21, .external_lex_state = 49},
  [3610] = {.lex_state = 0, .external_lex_state = 41},
  [3611] = {.lex_state = 0, .external_lex_state = 41},
  [3612] = {.lex_state = 21, .external_lex_state = 49},
  [3613] = {.lex_state = 20, .external_lex_state = 41},
  [3614] = {.lex_state = 21, .external_lex_state = 49},
  [3615] = {.lex_state = 21, .external_lex_state = 49},
  [3616] = {.lex_state = 0, .external_lex_state = 41},
  [3617] = {.lex_state = 21, .external_lex_state = 49},
  [3618] = {.lex_state = 21, .external_lex_state = 41},
  [3619] = {.lex_state = 21, .external_lex_state = 47},
  [3620] = {.lex_state = 21, .external_lex_state = 49},
  [3621] = {.lex_state = 20, .external_lex_state = 41},
  [3622] = {.lex_state = 0, .external_lex_state = 41},
  [3623] = {.lex_state = 0, .external_lex_state = 41},
  [3624] = {.lex_state = 20, .external_lex_state = 41},
  [3625] = {.lex_state = 20, .external_lex_state = 41},
  [3626] = {.lex_state = 0, .external_lex_state = 41},
  [3627] = {.lex_state = 0, .external_lex_state = 41},
  [3628] = {.lex_state = 0, .external_lex_state = 41},
  [3629] = {.lex_state = 0, .external_lex_state = 41},
  [3630] = {.lex_state = 21, .external_lex_state = 41},
  [3631] = {.lex_state = 0, .external_lex_state = 41},
  [3632] = {.lex_state = 0, .external_lex_state = 41},
  [3633] = {.lex_state = 21, .external_lex_state = 49},
  [3634] = {.lex_state = 0, .external_lex_state = 41},
  [3635] = {.lex_state = 0, .external_lex_state = 41},
  [3636] = {.lex_state = 21, .external_lex_state = 49},
  [3637] = {.lex_state = 0, .external_lex_state = 41},
  [3638] = {.lex_state = 0, .external_lex_state = 41},
  [3639] = {.lex_state = 21, .external_lex_state = 49},
  [3640] = {.lex_state = 0, .external_lex_state = 41},
  [3641] = {.lex_state = 0, .external_lex_state = 41},
  [3642] = {.lex_state = 21, .external_lex_state = 41},
  [3643] = {.lex_state = 0, .external_lex_state = 41},
  [3644] = {.lex_state = 0, .external_lex_state = 41},
  [3645] = {.lex_state = 21, .external_lex_state = 49},
  [3646] = {.lex_state = 0, .external_lex_state = 41},
  [3647] = {.lex_state = 0, .external_lex_state = 41},
  [3648] = {.lex_state = 0, .external_lex_state = 41},
  [3649] = {.lex_state = 0, .external_lex_state = 41},
  [3650] = {.lex_state = 0, .external_lex_state = 41},
  [3651] = {.lex_state = 0, .external_lex_state = 41},
  [3652] = {.lex_state = 0, .external_lex_state = 41},
  [3653] = {.lex_state = 0, .external_lex_state = 41},
  [3654] = {.lex_state = 0, .external_lex_state = 41},
  [3655] = {.lex_state = 0, .external_lex_state = 41},
  [3656] = {.lex_state = 0, .external_lex_state = 41},
  [3657] = {.lex_state = 0, .external_lex_state = 41},
  [3658] = {.lex_state = 0, .external_lex_state = 41},
  [3659] = {.lex_state = 0, .external_lex_state = 41},
  [3660] = {.lex_state = 0, .external_lex_state = 41},
  [3661] = {.lex_state = 16, .external_lex_state = 41},
  [3662] = {.lex_state = 18, .external_lex_state = 41},
  [3663] = {.lex_state = 21, .external_lex_state = 43},
  [3664] = {.lex_state = 20, .external_lex_state = 41},
  [3665] = {.lex_state = 21, .external_lex_state = 49},
  [3666] = {.lex_state = 21, .external_lex_state = 49},
  [3667] = {.lex_state = 16, .external_lex_state = 41},
  [3668] = {.lex_state = 21, .external_lex_state = 41},
  [3669] = {.lex_state = 21, .external_lex_state = 43},
  [3670] = {.lex_state = 20, .external_lex_state = 41},
  [3671] = {.lex_state = 21, .external_lex_state = 49},
  [3672] = {.lex_state = 20, .external_lex_state = 41},
  [3673] = {.lex_state = 16, .external_lex_state = 41},
  [3674] = {.lex_state = 21, .external_lex_state = 41},
  [3675] = {.lex_state = 21, .external_lex_state = 43},
  [3676] = {.lex_state = 20, .external_lex_state = 41},
  [3677] = {.lex_state = 21, .external_lex_state = 49},
  [3678] = {.lex_state = 21, .external_lex_state = 41},
  [3679] = {.lex_state = 21, .external_lex_state = 41},
  [3680] = {.lex_state = 20, .external_lex_state = 41},
  [3681] = {.lex_state = 0, .external_lex_state = 41},
  [3682] = {.lex_state = 20, .external_lex_state = 41},
  [3683] = {.lex_state = 21, .external_lex_state = 41},
  [3684] = {.lex_state = 20, .external_lex_state = 41},
  [3685] = {.lex_state = 21, .external_lex_state = 49},
  [3686] = {.lex_state = 20, .external_lex_state = 41},
  [3687] = {.lex_state = 20, .external_lex_state = 41},
  [3688] = {.lex_state = 20, .external_lex_state = 41},
  [3689] = {.lex_state = 21, .external_lex_state = 41},
  [3690] = {.lex_state = 20, .external_lex_state = 41},
  [3691] = {.lex_state = 21, .external_lex_state = 49},
  [3692] = {.lex_state = 20, .external_lex_state = 41},
  [3693] = {.lex_state = 21, .external_lex_state = 48},
  [3694] = {.lex_state = 20, .external_lex_state = 41},
  [3695] = {.lex_state = 20, .external_lex_state = 41},
  [3696] = {.lex_state = 20, .external_lex_state = 41},
  [3697] = {.lex_state = 20, .external_lex_state = 41},
  [3698] = {.lex_state = 20, .external_lex_state = 41},
  [3699] = {.lex_state = 21, .external_lex_state = 49},
  [3700] = {.lex_state = 21, .external_lex_state = 49},
  [3701] = {.lex_state = 21, .external_lex_state = 49},
  [3702] = {.lex_state = 21, .external_lex_state = 49},
  [3703] = {.lex_state = 21, .external_lex_state = 48},
  [3704] = {.lex_state = 21, .external_lex_state = 49},
  [3705] = {.lex_state = 21, .external_lex_state = 49},
  [3706] = {.lex_state = 20, .external_lex_state = 41},
  [3707] = {.lex_state = 0, .external_lex_state = 41},
  [3708] = {.lex_state = 0, .external_lex_state = 41},
  [3709] = {.lex_state = 21, .external_lex_state = 41},
  [3710] = {.lex_state = 21, .external_lex_state = 49},
  [3711] = {.lex_state = 21, .external_lex_state = 49},
  [3712] = {.lex_state = 21, .external_lex_state = 49},
  [3713] = {.lex_state = 21, .external_lex_state = 49},
  [3714] = {.lex_state = 21, .external_lex_state = 49},
  [3715] = {.lex_state = 21, .external_lex_state = 49},
  [3716] = {.lex_state = 21, .external_lex_state = 49},
  [3717] = {.lex_state = 20, .external_lex_state = 41},
  [3718] = {.lex_state = 21, .external_lex_state = 41},
  [3719] = {.lex_state = 21, .external_lex_state = 49},
  [3720] = {.lex_state = 21, .external_lex_state = 49},
  [3721] = {.lex_state = 21, .external_lex_state = 49},
  [3722] = {.lex_state = 0, .external_lex_state = 41},
  [3723] = {(TSStateId)(-1)},
  [3724] = {(TSStateId)(-1)},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym_comment] = STATE(0),
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_name] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_local] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_end] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_then] = ACTIONS(1),
    [anon_sym_elseif] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_repeat] = ACTIONS(1),
    [anon_sym_until] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [sym_continue_stmt] = ACTIONS(1),
    [anon_sym_export] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_DOT_DOT_EQ] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_TILDE_EQ] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH_SLASH] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_DOT_DOT] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_not] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_typeof] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [anon_sym_LBRACE2] = ACTIONS(1),
    [aux_sym_unicode_escape_token1] = ACTIONS(1),
    [anon_sym_RBRACE2] = ACTIONS(1),
    [aux_sym_dec_byte_escape_token1] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [anon_sym_nil] = ACTIONS(1),
    [anon_sym_read] = ACTIONS(1),
    [anon_sym_write] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_AT_LBRACK] = ACTIONS(1),
    [sym__comment_start] = ACTIONS(3),
    [sym__comment_content] = ACTIONS(1),
    [sym__comment_end] = ACTIONS(1),
    [sym__string_start] = ACTIONS(1),
    [sym__string_content] = ACTIONS(1),
    [sym__string_end] = ACTIONS(1),
    [sym_interp_start] = ACTIONS(1),
    [sym_interp_content] = ACTIONS(1),
    [sym_interp_brace_open] = ACTIONS(1),
    [sym_interp_brace_close] = ACTIONS(1),
    [sym_interp_end] = ACTIONS(1),
    [sym_simple_escape] = ACTIONS(1),
    [sym__unicode_escape_sequence] = ACTIONS(1),
    [sym__dec_byte_escape_sequence] = ACTIONS(1),
    [sym__hex_byte_escape_sequence] = ACTIONS(1),
  },
  [1] = {
    [sym_chunk] = STATE(3329),
    [sym__block] = STATE(3202),
    [sym_ret_stmt] = STATE(3421),
    [sym_statement] = STATE(2283),
    [sym_local_fn_stmt] = STATE(2234),
    [sym_fn_stmt] = STATE(2234),
    [aux_sym__attrlist] = STATE(2787),
    [sym_for_in_stmt] = STATE(2234),
    [sym_for_range_stmt] = STATE(2234),
    [sym_if_stmt] = STATE(2234),
    [sym_repeat_stmt] = STATE(2234),
    [sym_while_stmt] = STATE(2234),
    [sym_do_stmt] = STATE(2234),
    [sym_break_stmt] = STATE(2234),
    [sym_local_var_stmt] = STATE(2234),
    [sym_var_stmt] = STATE(2234),
    [sym_assign_stmt] = STATE(2234),
    [sym__varlist] = STATE(3426),
    [sym_type_stmt] = STATE(2234),
    [sym_type_fn_stmt] = STATE(2234),
    [sym_prefixexp] = STATE(3049),
    [sym__prefixexp] = STATE(2785),
    [sym_exp_wrap] = STATE(2691),
    [sym_call_stmt] = STATE(1305),
    [sym__tbl_method] = STATE(2833),
    [sym_var] = STATE(2539),
    [sym__tbl_seq] = STATE(2223),
    [sym_attribute] = STATE(2882),
    [sym_comment] = STATE(1),
    [aux_sym__block_repeat1] = STATE(230),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_name] = ACTIONS(7),
    [anon_sym_return] = ACTIONS(9),
    [anon_sym_local] = ACTIONS(11),
    [anon_sym_function] = ACTIONS(13),
    [anon_sym_for] = ACTIONS(15),
    [anon_sym_do] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_repeat] = ACTIONS(21),
    [anon_sym_while] = ACTIONS(23),
    [anon_sym_break] = ACTIONS(25),
    [sym_continue_stmt] = ACTIONS(27),
    [anon_sym_export] = ACTIONS(29),
    [anon_sym_type] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_AT] = ACTIONS(35),
    [anon_sym_AT_LBRACK] = ACTIONS(37),
    [sym__comment_start] = ACTIONS(3),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 40,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(39), 1,
      anon_sym_return,
    ACTIONS(41), 1,
      anon_sym_local,
    ACTIONS(43), 1,
      anon_sym_function,
    ACTIONS(45), 1,
      anon_sym_for,
    ACTIONS(47), 1,
      anon_sym_do,
    ACTIONS(49), 1,
      anon_sym_end,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_elseif,
    ACTIONS(55), 1,
      anon_sym_else,
    ACTIONS(57), 1,
      anon_sym_repeat,
    ACTIONS(59), 1,
      anon_sym_while,
    ACTIONS(61), 1,
      anon_sym_break,
    ACTIONS(63), 1,
      sym_continue_stmt,
    ACTIONS(65), 1,
      anon_sym_export,
    ACTIONS(67), 1,
      anon_sym_type,
    STATE(2), 1,
      sym_comment,
    STATE(137), 1,
      aux_sym__block_repeat1,
    STATE(1179), 1,
      sym_call_stmt,
    STATE(2041), 1,
      sym_statement,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2537), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2758), 1,
      sym__tbl_method,
    STATE(2760), 1,
      aux_sym_if_stmt_repeat1,
    STATE(2817), 1,
      sym_block,
    STATE(2825), 1,
      aux_sym__attrlist,
    STATE(2844), 1,
      sym__prefixexp,
    STATE(2882), 1,
      sym_attribute,
    STATE(2955), 1,
      sym_elseif_clause,
    STATE(2958), 1,
      sym_ret_stmt,
    STATE(3019), 1,
      sym__block,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3241), 1,
      sym_else_clause,
    STATE(3383), 1,
      sym__varlist,
    STATE(2026), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [134] = 40,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(39), 1,
      anon_sym_return,
    ACTIONS(41), 1,
      anon_sym_local,
    ACTIONS(43), 1,
      anon_sym_function,
    ACTIONS(45), 1,
      anon_sym_for,
    ACTIONS(47), 1,
      anon_sym_do,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_elseif,
    ACTIONS(55), 1,
      anon_sym_else,
    ACTIONS(57), 1,
      anon_sym_repeat,
    ACTIONS(59), 1,
      anon_sym_while,
    ACTIONS(61), 1,
      anon_sym_break,
    ACTIONS(63), 1,
      sym_continue_stmt,
    ACTIONS(65), 1,
      anon_sym_export,
    ACTIONS(67), 1,
      anon_sym_type,
    ACTIONS(69), 1,
      anon_sym_end,
    STATE(3), 1,
      sym_comment,
    STATE(137), 1,
      aux_sym__block_repeat1,
    STATE(1179), 1,
      sym_call_stmt,
    STATE(2041), 1,
      sym_statement,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2537), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2752), 1,
      sym_block,
    STATE(2758), 1,
      sym__tbl_method,
    STATE(2765), 1,
      aux_sym_if_stmt_repeat1,
    STATE(2825), 1,
      aux_sym__attrlist,
    STATE(2844), 1,
      sym__prefixexp,
    STATE(2882), 1,
      sym_attribute,
    STATE(2955), 1,
      sym_elseif_clause,
    STATE(2958), 1,
      sym_ret_stmt,
    STATE(3019), 1,
      sym__block,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3270), 1,
      sym_else_clause,
    STATE(3383), 1,
      sym__varlist,
    STATE(2026), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [268] = 40,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(39), 1,
      anon_sym_return,
    ACTIONS(41), 1,
      anon_sym_local,
    ACTIONS(43), 1,
      anon_sym_function,
    ACTIONS(45), 1,
      anon_sym_for,
    ACTIONS(47), 1,
      anon_sym_do,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_elseif,
    ACTIONS(55), 1,
      anon_sym_else,
    ACTIONS(57), 1,
      anon_sym_repeat,
    ACTIONS(59), 1,
      anon_sym_while,
    ACTIONS(61), 1,
      anon_sym_break,
    ACTIONS(63), 1,
      sym_continue_stmt,
    ACTIONS(65), 1,
      anon_sym_export,
    ACTIONS(67), 1,
      anon_sym_type,
    ACTIONS(71), 1,
      anon_sym_end,
    STATE(4), 1,
      sym_comment,
    STATE(137), 1,
      aux_sym__block_repeat1,
    STATE(1179), 1,
      sym_call_stmt,
    STATE(2041), 1,
      sym_statement,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2537), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2758), 1,
      sym__tbl_method,
    STATE(2801), 1,
      sym_block,
    STATE(2804), 1,
      aux_sym_if_stmt_repeat1,
    STATE(2825), 1,
      aux_sym__attrlist,
    STATE(2844), 1,
      sym__prefixexp,
    STATE(2882), 1,
      sym_attribute,
    STATE(2955), 1,
      sym_elseif_clause,
    STATE(2958), 1,
      sym_ret_stmt,
    STATE(3019), 1,
      sym__block,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3134), 1,
      sym_else_clause,
    STATE(3383), 1,
      sym__varlist,
    STATE(2026), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [402] = 40,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(39), 1,
      anon_sym_return,
    ACTIONS(41), 1,
      anon_sym_local,
    ACTIONS(43), 1,
      anon_sym_function,
    ACTIONS(45), 1,
      anon_sym_for,
    ACTIONS(47), 1,
      anon_sym_do,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_elseif,
    ACTIONS(55), 1,
      anon_sym_else,
    ACTIONS(57), 1,
      anon_sym_repeat,
    ACTIONS(59), 1,
      anon_sym_while,
    ACTIONS(61), 1,
      anon_sym_break,
    ACTIONS(63), 1,
      sym_continue_stmt,
    ACTIONS(65), 1,
      anon_sym_export,
    ACTIONS(67), 1,
      anon_sym_type,
    ACTIONS(73), 1,
      anon_sym_end,
    STATE(5), 1,
      sym_comment,
    STATE(137), 1,
      aux_sym__block_repeat1,
    STATE(1179), 1,
      sym_call_stmt,
    STATE(2041), 1,
      sym_statement,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2537), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2758), 1,
      sym__tbl_method,
    STATE(2766), 1,
      sym_block,
    STATE(2767), 1,
      aux_sym_if_stmt_repeat1,
    STATE(2825), 1,
      aux_sym__attrlist,
    STATE(2844), 1,
      sym__prefixexp,
    STATE(2882), 1,
      sym_attribute,
    STATE(2955), 1,
      sym_elseif_clause,
    STATE(2958), 1,
      sym_ret_stmt,
    STATE(3019), 1,
      sym__block,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3383), 1,
      sym__varlist,
    STATE(3617), 1,
      sym_else_clause,
    STATE(2026), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [536] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(39), 1,
      anon_sym_return,
    ACTIONS(41), 1,
      anon_sym_local,
    ACTIONS(43), 1,
      anon_sym_function,
    ACTIONS(45), 1,
      anon_sym_for,
    ACTIONS(47), 1,
      anon_sym_do,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(57), 1,
      anon_sym_repeat,
    ACTIONS(59), 1,
      anon_sym_while,
    ACTIONS(61), 1,
      anon_sym_break,
    ACTIONS(63), 1,
      sym_continue_stmt,
    ACTIONS(65), 1,
      anon_sym_export,
    ACTIONS(67), 1,
      anon_sym_type,
    STATE(6), 1,
      sym_comment,
    STATE(137), 1,
      aux_sym__block_repeat1,
    STATE(1179), 1,
      sym_call_stmt,
    STATE(2041), 1,
      sym_statement,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2537), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2758), 1,
      sym__tbl_method,
    STATE(2825), 1,
      aux_sym__attrlist,
    STATE(2844), 1,
      sym__prefixexp,
    STATE(2882), 1,
      sym_attribute,
    STATE(2958), 1,
      sym_ret_stmt,
    STATE(2988), 1,
      sym_block,
    STATE(3019), 1,
      sym__block,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3383), 1,
      sym__varlist,
    ACTIONS(75), 3,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
    STATE(2026), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [657] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(83), 1,
      anon_sym_COLON,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(89), 1,
      anon_sym_end,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    STATE(7), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3455), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [779] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(105), 1,
      anon_sym_COLON,
    ACTIONS(107), 1,
      anon_sym_end,
    STATE(8), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3419), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [901] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(109), 1,
      anon_sym_COLON,
    ACTIONS(111), 1,
      anon_sym_end,
    STATE(9), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3550), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [1023] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(113), 1,
      anon_sym_COLON,
    ACTIONS(115), 1,
      anon_sym_end,
    STATE(10), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3719), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [1145] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(117), 1,
      anon_sym_COLON,
    ACTIONS(119), 1,
      anon_sym_end,
    STATE(11), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3313), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [1267] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(121), 1,
      anon_sym_COLON,
    ACTIONS(123), 1,
      anon_sym_end,
    STATE(12), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3503), 1,
      sym_block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [1389] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(125), 1,
      anon_sym_COLON,
    ACTIONS(127), 1,
      anon_sym_end,
    STATE(13), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3164), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [1511] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(129), 1,
      anon_sym_COLON,
    ACTIONS(131), 1,
      anon_sym_end,
    STATE(14), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3263), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [1633] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(133), 1,
      anon_sym_COLON,
    ACTIONS(135), 1,
      anon_sym_end,
    STATE(15), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3308), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [1755] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(137), 1,
      anon_sym_COLON,
    ACTIONS(139), 1,
      anon_sym_end,
    STATE(16), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3354), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [1877] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(141), 1,
      anon_sym_COLON,
    ACTIONS(143), 1,
      anon_sym_end,
    STATE(17), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3501), 1,
      sym_block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [1999] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(145), 1,
      anon_sym_COLON,
    ACTIONS(147), 1,
      anon_sym_end,
    STATE(18), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3700), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [2121] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(149), 1,
      anon_sym_COLON,
    ACTIONS(151), 1,
      anon_sym_end,
    STATE(19), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3131), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [2243] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(153), 1,
      anon_sym_COLON,
    ACTIONS(155), 1,
      anon_sym_end,
    STATE(20), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3452), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [2365] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(157), 1,
      anon_sym_COLON,
    ACTIONS(159), 1,
      anon_sym_end,
    STATE(21), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3150), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [2487] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(161), 1,
      anon_sym_COLON,
    ACTIONS(163), 1,
      anon_sym_end,
    STATE(22), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3434), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [2609] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(165), 1,
      anon_sym_COLON,
    ACTIONS(167), 1,
      anon_sym_end,
    STATE(23), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3491), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [2731] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(169), 1,
      anon_sym_COLON,
    ACTIONS(171), 1,
      anon_sym_end,
    STATE(24), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3545), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [2853] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(173), 1,
      anon_sym_COLON,
    ACTIONS(175), 1,
      anon_sym_end,
    STATE(25), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3605), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [2975] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(177), 1,
      anon_sym_COLON,
    ACTIONS(179), 1,
      anon_sym_end,
    STATE(26), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3172), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [3097] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(181), 1,
      anon_sym_COLON,
    ACTIONS(183), 1,
      anon_sym_end,
    STATE(27), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3203), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [3219] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(185), 1,
      anon_sym_COLON,
    ACTIONS(187), 1,
      anon_sym_end,
    STATE(28), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3235), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [3341] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(189), 1,
      anon_sym_COLON,
    ACTIONS(191), 1,
      anon_sym_end,
    STATE(29), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3254), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [3463] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(193), 1,
      anon_sym_COLON,
    ACTIONS(195), 1,
      anon_sym_end,
    STATE(30), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3301), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [3585] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(197), 1,
      anon_sym_COLON,
    ACTIONS(199), 1,
      anon_sym_end,
    STATE(31), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3315), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [3707] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(201), 1,
      anon_sym_COLON,
    ACTIONS(203), 1,
      anon_sym_end,
    STATE(32), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3352), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [3829] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(205), 1,
      anon_sym_COLON,
    ACTIONS(207), 1,
      anon_sym_end,
    STATE(33), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3372), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [3951] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(209), 1,
      anon_sym_COLON,
    ACTIONS(211), 1,
      anon_sym_end,
    STATE(34), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3433), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [4073] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(213), 1,
      anon_sym_COLON,
    ACTIONS(215), 1,
      anon_sym_end,
    STATE(35), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3334), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [4195] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(217), 1,
      anon_sym_COLON,
    ACTIONS(219), 1,
      anon_sym_end,
    STATE(36), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3482), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [4317] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(221), 1,
      anon_sym_COLON,
    ACTIONS(223), 1,
      anon_sym_end,
    STATE(37), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3502), 1,
      sym_block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [4439] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(225), 1,
      anon_sym_COLON,
    ACTIONS(227), 1,
      anon_sym_end,
    STATE(38), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3552), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [4561] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(229), 1,
      anon_sym_COLON,
    ACTIONS(231), 1,
      anon_sym_end,
    STATE(39), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3565), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [4683] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(233), 1,
      anon_sym_COLON,
    ACTIONS(235), 1,
      anon_sym_end,
    STATE(40), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3579), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [4805] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(237), 1,
      anon_sym_COLON,
    ACTIONS(239), 1,
      anon_sym_end,
    STATE(41), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3587), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [4927] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(241), 1,
      anon_sym_COLON,
    ACTIONS(243), 1,
      anon_sym_end,
    STATE(42), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3671), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [5049] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(245), 1,
      anon_sym_COLON,
    ACTIONS(247), 1,
      anon_sym_end,
    STATE(43), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3701), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [5171] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(249), 1,
      anon_sym_COLON,
    ACTIONS(251), 1,
      anon_sym_end,
    STATE(44), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3713), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [5293] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(253), 1,
      anon_sym_COLON,
    ACTIONS(255), 1,
      anon_sym_end,
    STATE(45), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3720), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [5415] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(257), 1,
      anon_sym_COLON,
    ACTIONS(259), 1,
      anon_sym_end,
    STATE(46), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3401), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [5537] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(261), 1,
      anon_sym_COLON,
    ACTIONS(263), 1,
      anon_sym_end,
    STATE(47), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3457), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [5659] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(265), 1,
      anon_sym_COLON,
    ACTIONS(267), 1,
      anon_sym_end,
    STATE(48), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3705), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [5781] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(269), 1,
      anon_sym_COLON,
    ACTIONS(271), 1,
      anon_sym_end,
    STATE(49), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3133), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [5903] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(273), 1,
      anon_sym_COLON,
    ACTIONS(275), 1,
      anon_sym_end,
    STATE(50), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3247), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [6025] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(277), 1,
      anon_sym_COLON,
    ACTIONS(279), 1,
      anon_sym_end,
    STATE(51), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3295), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [6147] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(281), 1,
      anon_sym_COLON,
    ACTIONS(283), 1,
      anon_sym_end,
    STATE(52), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3325), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [6269] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(285), 1,
      anon_sym_COLON,
    ACTIONS(287), 1,
      anon_sym_end,
    STATE(53), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3360), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [6391] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(289), 1,
      anon_sym_COLON,
    ACTIONS(291), 1,
      anon_sym_end,
    STATE(54), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3442), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [6513] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(293), 1,
      anon_sym_COLON,
    ACTIONS(295), 1,
      anon_sym_end,
    STATE(55), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3458), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [6635] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(297), 1,
      anon_sym_COLON,
    ACTIONS(299), 1,
      anon_sym_end,
    STATE(56), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3477), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [6757] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(301), 1,
      anon_sym_COLON,
    ACTIONS(303), 1,
      anon_sym_end,
    STATE(57), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3494), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [6879] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(305), 1,
      anon_sym_COLON,
    ACTIONS(307), 1,
      anon_sym_end,
    STATE(58), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3572), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [7001] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(309), 1,
      anon_sym_COLON,
    ACTIONS(311), 1,
      anon_sym_end,
    STATE(59), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3614), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [7123] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(313), 1,
      anon_sym_COLON,
    ACTIONS(315), 1,
      anon_sym_end,
    STATE(60), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3666), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [7245] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(317), 1,
      anon_sym_COLON,
    ACTIONS(319), 1,
      anon_sym_end,
    STATE(61), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3699), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [7367] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(321), 1,
      anon_sym_COLON,
    ACTIONS(323), 1,
      anon_sym_end,
    STATE(62), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3140), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [7489] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(325), 1,
      anon_sym_COLON,
    ACTIONS(327), 1,
      anon_sym_end,
    STATE(63), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3149), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [7611] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(329), 1,
      anon_sym_COLON,
    ACTIONS(331), 1,
      anon_sym_end,
    STATE(64), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3158), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [7733] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(333), 1,
      anon_sym_COLON,
    ACTIONS(335), 1,
      anon_sym_end,
    STATE(65), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3165), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [7855] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(337), 1,
      anon_sym_COLON,
    ACTIONS(339), 1,
      anon_sym_end,
    STATE(66), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3186), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [7977] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(341), 1,
      anon_sym_COLON,
    ACTIONS(343), 1,
      anon_sym_end,
    STATE(67), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3195), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [8099] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(345), 1,
      anon_sym_COLON,
    ACTIONS(347), 1,
      anon_sym_end,
    STATE(68), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3204), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [8221] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(349), 1,
      anon_sym_COLON,
    ACTIONS(351), 1,
      anon_sym_end,
    STATE(69), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3211), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [8343] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(353), 1,
      anon_sym_COLON,
    ACTIONS(355), 1,
      anon_sym_end,
    STATE(70), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3268), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [8465] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(357), 1,
      anon_sym_end,
    STATE(71), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3585), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [8584] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(359), 1,
      anon_sym_return,
    ACTIONS(361), 1,
      anon_sym_local,
    ACTIONS(363), 1,
      anon_sym_function,
    ACTIONS(365), 1,
      anon_sym_for,
    ACTIONS(367), 1,
      anon_sym_do,
    ACTIONS(369), 1,
      anon_sym_if,
    ACTIONS(371), 1,
      anon_sym_repeat,
    ACTIONS(373), 1,
      anon_sym_until,
    ACTIONS(375), 1,
      anon_sym_while,
    ACTIONS(377), 1,
      anon_sym_break,
    ACTIONS(379), 1,
      sym_continue_stmt,
    ACTIONS(381), 1,
      anon_sym_export,
    ACTIONS(383), 1,
      anon_sym_type,
    STATE(72), 1,
      sym_comment,
    STATE(229), 1,
      aux_sym__block_repeat1,
    STATE(1375), 1,
      sym_call_stmt,
    STATE(2217), 1,
      sym_statement,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2534), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2747), 1,
      sym__prefixexp,
    STATE(2751), 1,
      sym__tbl_method,
    STATE(2820), 1,
      aux_sym__attrlist,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3173), 1,
      sym_ret_stmt,
    STATE(3271), 1,
      sym__block,
    STATE(3349), 1,
      sym__varlist,
    STATE(3353), 1,
      sym_block,
    STATE(2216), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [8703] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(385), 1,
      anon_sym_end,
    STATE(73), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3350), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [8822] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(387), 1,
      anon_sym_end,
    STATE(74), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3333), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [8941] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(389), 1,
      anon_sym_end,
    STATE(75), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3299), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [9060] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(391), 1,
      anon_sym_end,
    STATE(76), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3454), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [9179] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(393), 1,
      anon_sym_end,
    STATE(77), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3612), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [9298] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(395), 1,
      anon_sym_end,
    STATE(78), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3615), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [9417] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(397), 1,
      anon_sym_end,
    STATE(79), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3282), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [9536] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(399), 1,
      anon_sym_end,
    STATE(80), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3404), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [9655] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(401), 1,
      anon_sym_end,
    STATE(81), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3441), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [9774] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(403), 1,
      anon_sym_end,
    STATE(82), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3141), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [9893] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(405), 1,
      anon_sym_end,
    STATE(83), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3398), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [10012] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(407), 1,
      anon_sym_end,
    STATE(84), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3448), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [10131] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(409), 1,
      anon_sym_end,
    STATE(85), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3456), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [10250] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(411), 1,
      anon_sym_end,
    STATE(86), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3156), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [10369] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(413), 1,
      anon_sym_end,
    STATE(87), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3169), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [10488] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(415), 1,
      anon_sym_end,
    STATE(88), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3178), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [10607] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(417), 1,
      anon_sym_end,
    STATE(89), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3439), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [10726] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(419), 1,
      anon_sym_end,
    STATE(90), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3250), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [10845] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(421), 1,
      anon_sym_end,
    STATE(91), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3143), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [10964] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(423), 1,
      anon_sym_end,
    STATE(92), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3389), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [11083] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(425), 1,
      anon_sym_end,
    STATE(93), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3278), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [11202] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(427), 1,
      anon_sym_end,
    STATE(94), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3290), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [11321] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(429), 1,
      anon_sym_end,
    STATE(95), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3291), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [11440] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(431), 1,
      anon_sym_end,
    STATE(96), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3524), 1,
      sym_block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [11559] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(433), 1,
      anon_sym_end,
    STATE(97), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3311), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [11678] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(435), 1,
      anon_sym_end,
    STATE(98), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3317), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [11797] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(437), 1,
      anon_sym_end,
    STATE(99), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3336), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [11916] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(439), 1,
      anon_sym_end,
    STATE(100), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3532), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [12035] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(441), 1,
      anon_sym_end,
    STATE(101), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3378), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [12154] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(443), 1,
      anon_sym_end,
    STATE(102), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3400), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [12273] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(445), 1,
      anon_sym_end,
    STATE(103), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3409), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [12392] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(447), 1,
      anon_sym_end,
    STATE(104), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3410), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [12511] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(449), 1,
      anon_sym_end,
    STATE(105), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3411), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [12630] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(451), 1,
      anon_sym_end,
    STATE(106), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3525), 1,
      sym_block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [12749] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(453), 1,
      anon_sym_end,
    STATE(107), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3283), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [12868] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(455), 1,
      anon_sym_end,
    STATE(108), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3636), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [12987] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(457), 1,
      anon_sym_end,
    STATE(109), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3163), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [13106] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(459), 1,
      anon_sym_end,
    STATE(110), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3225), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [13225] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(461), 1,
      anon_sym_end,
    STATE(111), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3287), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [13344] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(463), 1,
      anon_sym_end,
    STATE(112), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3300), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [13463] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(465), 1,
      anon_sym_end,
    STATE(113), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3371), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [13582] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(467), 1,
      anon_sym_end,
    STATE(114), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3467), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [13701] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(469), 1,
      anon_sym_end,
    STATE(115), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3529), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [13820] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(471), 1,
      anon_sym_end,
    STATE(116), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3712), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [13939] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(473), 1,
      anon_sym_end,
    STATE(117), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3436), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [14058] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(475), 1,
      anon_sym_end,
    STATE(118), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3157), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [14177] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(477), 1,
      anon_sym_end,
    STATE(119), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3168), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [14296] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(479), 1,
      anon_sym_end,
    STATE(120), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3179), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [14415] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(481), 1,
      anon_sym_end,
    STATE(121), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3187), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [14534] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(483), 1,
      anon_sym_end,
    STATE(122), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3189), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [14653] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(485), 1,
      anon_sym_end,
    STATE(123), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3192), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [14772] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(487), 1,
      anon_sym_end,
    STATE(124), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3294), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [14891] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(489), 1,
      anon_sym_end,
    STATE(125), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3533), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [15010] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(491), 1,
      anon_sym_end,
    STATE(126), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3536), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [15129] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(493), 1,
      anon_sym_end,
    STATE(127), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3557), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [15248] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(495), 1,
      anon_sym_end,
    STATE(128), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3562), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [15367] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(497), 1,
      anon_sym_end,
    STATE(129), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3608), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [15486] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(499), 1,
      anon_sym_end,
    STATE(130), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3609), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [15605] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(501), 1,
      anon_sym_end,
    STATE(131), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3645), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [15724] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(503), 1,
      anon_sym_end,
    STATE(132), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3665), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [15843] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(505), 1,
      anon_sym_end,
    STATE(133), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3222), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [15962] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(507), 1,
      anon_sym_end,
    STATE(134), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3223), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [16081] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(509), 1,
      anon_sym_end,
    STATE(135), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3240), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [16200] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(511), 1,
      anon_sym_end,
    STATE(136), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3242), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [16319] = 33,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(39), 1,
      anon_sym_return,
    ACTIONS(41), 1,
      anon_sym_local,
    ACTIONS(43), 1,
      anon_sym_function,
    ACTIONS(45), 1,
      anon_sym_for,
    ACTIONS(47), 1,
      anon_sym_do,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(57), 1,
      anon_sym_repeat,
    ACTIONS(59), 1,
      anon_sym_while,
    ACTIONS(61), 1,
      anon_sym_break,
    ACTIONS(63), 1,
      sym_continue_stmt,
    ACTIONS(65), 1,
      anon_sym_export,
    ACTIONS(67), 1,
      anon_sym_type,
    STATE(137), 1,
      sym_comment,
    STATE(226), 1,
      aux_sym__block_repeat1,
    STATE(1179), 1,
      sym_call_stmt,
    STATE(2041), 1,
      sym_statement,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2537), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2758), 1,
      sym__tbl_method,
    STATE(2825), 1,
      aux_sym__attrlist,
    STATE(2844), 1,
      sym__prefixexp,
    STATE(2882), 1,
      sym_attribute,
    STATE(2991), 1,
      sym_ret_stmt,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3383), 1,
      sym__varlist,
    ACTIONS(513), 3,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
    STATE(2026), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [16434] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(515), 1,
      anon_sym_end,
    STATE(138), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3255), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [16553] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(517), 1,
      anon_sym_end,
    STATE(139), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3256), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [16672] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(519), 1,
      anon_sym_end,
    STATE(140), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3260), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [16791] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(521), 1,
      anon_sym_end,
    STATE(141), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3262), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [16910] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(523), 1,
      anon_sym_end,
    STATE(142), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3341), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [17029] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(525), 1,
      anon_sym_end,
    STATE(143), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3342), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [17148] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(527), 1,
      anon_sym_end,
    STATE(144), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3355), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [17267] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(529), 1,
      anon_sym_end,
    STATE(145), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3357), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [17386] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(531), 1,
      anon_sym_end,
    STATE(146), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3375), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [17505] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(533), 1,
      anon_sym_end,
    STATE(147), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3377), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [17624] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(535), 1,
      anon_sym_end,
    STATE(148), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3384), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [17743] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(537), 1,
      anon_sym_end,
    STATE(149), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3386), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [17862] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(539), 1,
      anon_sym_end,
    STATE(150), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3472), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [17981] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(541), 1,
      anon_sym_end,
    STATE(151), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3474), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [18100] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(543), 1,
      anon_sym_end,
    STATE(152), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3486), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [18219] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(359), 1,
      anon_sym_return,
    ACTIONS(361), 1,
      anon_sym_local,
    ACTIONS(363), 1,
      anon_sym_function,
    ACTIONS(365), 1,
      anon_sym_for,
    ACTIONS(367), 1,
      anon_sym_do,
    ACTIONS(369), 1,
      anon_sym_if,
    ACTIONS(371), 1,
      anon_sym_repeat,
    ACTIONS(375), 1,
      anon_sym_while,
    ACTIONS(377), 1,
      anon_sym_break,
    ACTIONS(379), 1,
      sym_continue_stmt,
    ACTIONS(381), 1,
      anon_sym_export,
    ACTIONS(383), 1,
      anon_sym_type,
    ACTIONS(545), 1,
      anon_sym_until,
    STATE(153), 1,
      sym_comment,
    STATE(229), 1,
      aux_sym__block_repeat1,
    STATE(1375), 1,
      sym_call_stmt,
    STATE(2217), 1,
      sym_statement,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2534), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2747), 1,
      sym__prefixexp,
    STATE(2751), 1,
      sym__tbl_method,
    STATE(2820), 1,
      aux_sym__attrlist,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3173), 1,
      sym_ret_stmt,
    STATE(3271), 1,
      sym__block,
    STATE(3349), 1,
      sym__varlist,
    STATE(3387), 1,
      sym_block,
    STATE(2216), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [18338] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(547), 1,
      anon_sym_end,
    STATE(154), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3504), 1,
      sym_block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [18457] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(549), 1,
      anon_sym_end,
    STATE(155), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3506), 1,
      sym_block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [18576] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(551), 1,
      anon_sym_end,
    STATE(156), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3511), 1,
      sym_block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [18695] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(553), 1,
      anon_sym_end,
    STATE(157), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3514), 1,
      sym_block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [18814] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(555), 1,
      anon_sym_end,
    STATE(158), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3574), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [18933] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(557), 1,
      anon_sym_end,
    STATE(159), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3575), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [19052] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(559), 1,
      anon_sym_end,
    STATE(160), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3582), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [19171] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(561), 1,
      anon_sym_end,
    STATE(161), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3583), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [19290] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(563), 1,
      anon_sym_end,
    STATE(162), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3588), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [19409] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(565), 1,
      anon_sym_end,
    STATE(163), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3589), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [19528] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(567), 1,
      anon_sym_end,
    STATE(164), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3592), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [19647] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(569), 1,
      anon_sym_end,
    STATE(165), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3596), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [19766] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(571), 1,
      anon_sym_end,
    STATE(166), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3710), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [19885] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(573), 1,
      anon_sym_end,
    STATE(167), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3711), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [20004] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(575), 1,
      anon_sym_end,
    STATE(168), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3715), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [20123] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(577), 1,
      anon_sym_end,
    STATE(169), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3716), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [20242] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(579), 1,
      anon_sym_end,
    STATE(170), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3721), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [20361] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(581), 1,
      anon_sym_end,
    STATE(171), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3366), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [20480] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(583), 1,
      anon_sym_end,
    STATE(172), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3190), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [20599] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(585), 1,
      anon_sym_end,
    STATE(173), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3272), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [20718] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(587), 1,
      anon_sym_end,
    STATE(174), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3602), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [20837] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(589), 1,
      anon_sym_end,
    STATE(175), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3620), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [20956] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(591), 1,
      anon_sym_end,
    STATE(176), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3126), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [21075] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(593), 1,
      anon_sym_end,
    STATE(177), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3127), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [21194] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(595), 1,
      anon_sym_end,
    STATE(178), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3138), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [21313] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(597), 1,
      anon_sym_end,
    STATE(179), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3139), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [21432] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(599), 1,
      anon_sym_end,
    STATE(180), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3147), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [21551] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(601), 1,
      anon_sym_end,
    STATE(181), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3148), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [21670] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(603), 1,
      anon_sym_end,
    STATE(182), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3306), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [21789] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(605), 1,
      anon_sym_end,
    STATE(183), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3309), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [21908] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(607), 1,
      anon_sym_end,
    STATE(184), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3337), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [22027] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(609), 1,
      anon_sym_end,
    STATE(185), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3343), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [22146] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(611), 1,
      anon_sym_end,
    STATE(186), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3363), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [22265] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(613), 1,
      anon_sym_end,
    STATE(187), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3368), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [22384] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(615), 1,
      anon_sym_end,
    STATE(188), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3382), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [22503] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(617), 1,
      anon_sym_end,
    STATE(189), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3394), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [22622] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(619), 1,
      anon_sym_end,
    STATE(190), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3469), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [22741] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(621), 1,
      anon_sym_end,
    STATE(191), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3470), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [22860] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(623), 1,
      anon_sym_end,
    STATE(192), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3479), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [22979] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(625), 1,
      anon_sym_end,
    STATE(193), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3481), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [23098] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(627), 1,
      anon_sym_end,
    STATE(194), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3495), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [23217] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(629), 1,
      anon_sym_end,
    STATE(195), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3496), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [23336] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(631), 1,
      anon_sym_end,
    STATE(196), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3518), 1,
      sym_block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [23455] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(633), 1,
      anon_sym_end,
    STATE(197), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3519), 1,
      sym_block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [23574] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(635), 1,
      anon_sym_end,
    STATE(198), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3633), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [23693] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(637), 1,
      anon_sym_end,
    STATE(199), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3639), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [23812] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(639), 1,
      anon_sym_end,
    STATE(200), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3677), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [23931] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(641), 1,
      anon_sym_end,
    STATE(201), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3685), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [24050] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(643), 1,
      anon_sym_end,
    STATE(202), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3702), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [24169] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(645), 1,
      anon_sym_end,
    STATE(203), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3704), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [24288] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(647), 1,
      anon_sym_end,
    STATE(204), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(3714), 1,
      sym_block,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [24407] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(649), 1,
      anon_sym_end,
    STATE(205), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3460), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [24526] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(359), 1,
      anon_sym_return,
    ACTIONS(361), 1,
      anon_sym_local,
    ACTIONS(363), 1,
      anon_sym_function,
    ACTIONS(365), 1,
      anon_sym_for,
    ACTIONS(367), 1,
      anon_sym_do,
    ACTIONS(369), 1,
      anon_sym_if,
    ACTIONS(371), 1,
      anon_sym_repeat,
    ACTIONS(375), 1,
      anon_sym_while,
    ACTIONS(377), 1,
      anon_sym_break,
    ACTIONS(379), 1,
      sym_continue_stmt,
    ACTIONS(381), 1,
      anon_sym_export,
    ACTIONS(383), 1,
      anon_sym_type,
    ACTIONS(651), 1,
      anon_sym_until,
    STATE(206), 1,
      sym_comment,
    STATE(229), 1,
      aux_sym__block_repeat1,
    STATE(1375), 1,
      sym_call_stmt,
    STATE(2217), 1,
      sym_statement,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2534), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2747), 1,
      sym__prefixexp,
    STATE(2751), 1,
      sym__tbl_method,
    STATE(2820), 1,
      aux_sym__attrlist,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3173), 1,
      sym_ret_stmt,
    STATE(3271), 1,
      sym__block,
    STATE(3349), 1,
      sym__varlist,
    STATE(3510), 1,
      sym_block,
    STATE(2216), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [24645] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(653), 1,
      anon_sym_end,
    STATE(207), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3154), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [24764] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(655), 1,
      anon_sym_end,
    STATE(208), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3155), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [24883] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(657), 1,
      anon_sym_end,
    STATE(209), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3160), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [25002] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(659), 1,
      anon_sym_end,
    STATE(210), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3161), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [25121] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(661), 1,
      anon_sym_end,
    STATE(211), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3166), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [25240] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(663), 1,
      anon_sym_end,
    STATE(212), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3167), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [25359] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(665), 1,
      anon_sym_end,
    STATE(213), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3170), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [25478] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(667), 1,
      anon_sym_end,
    STATE(214), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3171), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [25597] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(669), 1,
      anon_sym_end,
    STATE(215), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3200), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [25716] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(671), 1,
      anon_sym_end,
    STATE(216), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3201), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [25835] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(673), 1,
      anon_sym_end,
    STATE(217), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3206), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [25954] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(675), 1,
      anon_sym_end,
    STATE(218), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3207), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [26073] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(677), 1,
      anon_sym_end,
    STATE(219), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3212), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [26192] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(679), 1,
      anon_sym_end,
    STATE(220), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3213), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [26311] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(681), 1,
      anon_sym_end,
    STATE(221), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3216), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [26430] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(683), 1,
      anon_sym_end,
    STATE(222), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3217), 1,
      sym_block,
    STATE(3314), 1,
      sym__varlist,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [26549] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(359), 1,
      anon_sym_return,
    ACTIONS(361), 1,
      anon_sym_local,
    ACTIONS(363), 1,
      anon_sym_function,
    ACTIONS(365), 1,
      anon_sym_for,
    ACTIONS(367), 1,
      anon_sym_do,
    ACTIONS(369), 1,
      anon_sym_if,
    ACTIONS(371), 1,
      anon_sym_repeat,
    ACTIONS(375), 1,
      anon_sym_while,
    ACTIONS(377), 1,
      anon_sym_break,
    ACTIONS(379), 1,
      sym_continue_stmt,
    ACTIONS(381), 1,
      anon_sym_export,
    ACTIONS(383), 1,
      anon_sym_type,
    ACTIONS(685), 1,
      anon_sym_until,
    STATE(223), 1,
      sym_comment,
    STATE(229), 1,
      aux_sym__block_repeat1,
    STATE(1375), 1,
      sym_call_stmt,
    STATE(2217), 1,
      sym_statement,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2534), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2747), 1,
      sym__prefixexp,
    STATE(2751), 1,
      sym__tbl_method,
    STATE(2820), 1,
      aux_sym__attrlist,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3173), 1,
      sym_ret_stmt,
    STATE(3271), 1,
      sym__block,
    STATE(3318), 1,
      sym_block,
    STATE(3349), 1,
      sym__varlist,
    STATE(2216), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [26668] = 35,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(687), 1,
      anon_sym_end,
    STATE(224), 1,
      sym_comment,
    STATE(231), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3487), 1,
      sym_block,
    STATE(3500), 1,
      sym__block,
    STATE(3527), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [26787] = 8,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(693), 1,
      anon_sym_LBRACK,
    ACTIONS(695), 1,
      anon_sym_DOT,
    STATE(225), 1,
      sym_comment,
    STATE(237), 1,
      sym_key,
    STATE(238), 1,
      sym__key_named,
    ACTIONS(691), 18,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(689), 23,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [26851] = 30,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(697), 1,
      sym_name,
    ACTIONS(702), 1,
      anon_sym_local,
    ACTIONS(705), 1,
      anon_sym_function,
    ACTIONS(708), 1,
      anon_sym_for,
    ACTIONS(711), 1,
      anon_sym_do,
    ACTIONS(714), 1,
      anon_sym_if,
    ACTIONS(717), 1,
      anon_sym_repeat,
    ACTIONS(720), 1,
      anon_sym_while,
    ACTIONS(723), 1,
      anon_sym_break,
    ACTIONS(726), 1,
      sym_continue_stmt,
    ACTIONS(729), 1,
      anon_sym_export,
    ACTIONS(732), 1,
      anon_sym_type,
    ACTIONS(735), 1,
      anon_sym_LPAREN,
    ACTIONS(738), 1,
      anon_sym_AT,
    ACTIONS(741), 1,
      anon_sym_AT_LBRACK,
    STATE(1179), 1,
      sym_call_stmt,
    STATE(2041), 1,
      sym_statement,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2537), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2758), 1,
      sym__tbl_method,
    STATE(2825), 1,
      aux_sym__attrlist,
    STATE(2844), 1,
      sym__prefixexp,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3383), 1,
      sym__varlist,
    STATE(226), 2,
      sym_comment,
      aux_sym__block_repeat1,
    ACTIONS(700), 4,
      anon_sym_return,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
    STATE(2026), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [26959] = 8,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(693), 1,
      anon_sym_LBRACK,
    ACTIONS(695), 1,
      anon_sym_DOT,
    STATE(227), 1,
      sym_comment,
    STATE(238), 1,
      sym__key_named,
    STATE(240), 1,
      sym_key,
    ACTIONS(746), 18,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(744), 23,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [27023] = 9,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(693), 1,
      anon_sym_LBRACK,
    ACTIONS(695), 1,
      anon_sym_DOT,
    STATE(228), 1,
      sym_comment,
    STATE(238), 1,
      sym__key_named,
    STATE(239), 1,
      sym_key,
    ACTIONS(752), 3,
      sym__string_start,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
    ACTIONS(750), 15,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_AT_LBRACK,
    ACTIONS(748), 23,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [27089] = 33,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(359), 1,
      anon_sym_return,
    ACTIONS(361), 1,
      anon_sym_local,
    ACTIONS(363), 1,
      anon_sym_function,
    ACTIONS(365), 1,
      anon_sym_for,
    ACTIONS(367), 1,
      anon_sym_do,
    ACTIONS(369), 1,
      anon_sym_if,
    ACTIONS(371), 1,
      anon_sym_repeat,
    ACTIONS(375), 1,
      anon_sym_while,
    ACTIONS(377), 1,
      anon_sym_break,
    ACTIONS(379), 1,
      sym_continue_stmt,
    ACTIONS(381), 1,
      anon_sym_export,
    ACTIONS(383), 1,
      anon_sym_type,
    ACTIONS(513), 1,
      anon_sym_until,
    STATE(229), 1,
      sym_comment,
    STATE(244), 1,
      aux_sym__block_repeat1,
    STATE(1375), 1,
      sym_call_stmt,
    STATE(2217), 1,
      sym_statement,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2534), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2747), 1,
      sym__prefixexp,
    STATE(2751), 1,
      sym__tbl_method,
    STATE(2820), 1,
      aux_sym__attrlist,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3349), 1,
      sym__varlist,
    STATE(3693), 1,
      sym_ret_stmt,
    STATE(2216), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [27202] = 33,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(9), 1,
      anon_sym_return,
    ACTIONS(11), 1,
      anon_sym_local,
    ACTIONS(13), 1,
      anon_sym_function,
    ACTIONS(15), 1,
      anon_sym_for,
    ACTIONS(17), 1,
      anon_sym_do,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_repeat,
    ACTIONS(23), 1,
      anon_sym_while,
    ACTIONS(25), 1,
      anon_sym_break,
    ACTIONS(27), 1,
      sym_continue_stmt,
    ACTIONS(29), 1,
      anon_sym_export,
    ACTIONS(31), 1,
      anon_sym_type,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(754), 1,
      ts_builtin_sym_end,
    STATE(230), 1,
      sym_comment,
    STATE(236), 1,
      aux_sym__block_repeat1,
    STATE(1305), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2283), 1,
      sym_statement,
    STATE(2539), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2785), 1,
      sym__prefixexp,
    STATE(2787), 1,
      aux_sym__attrlist,
    STATE(2833), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3415), 1,
      sym_ret_stmt,
    STATE(3426), 1,
      sym__varlist,
    STATE(2234), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [27315] = 33,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_name,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(77), 1,
      anon_sym_return,
    ACTIONS(79), 1,
      anon_sym_local,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_for,
    ACTIONS(87), 1,
      anon_sym_do,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_while,
    ACTIONS(97), 1,
      anon_sym_break,
    ACTIONS(99), 1,
      sym_continue_stmt,
    ACTIONS(101), 1,
      anon_sym_export,
    ACTIONS(103), 1,
      anon_sym_type,
    ACTIONS(513), 1,
      anon_sym_end,
    STATE(231), 1,
      sym_comment,
    STATE(243), 1,
      aux_sym__block_repeat1,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    STATE(3388), 1,
      sym_ret_stmt,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [27428] = 8,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(756), 1,
      anon_sym_LBRACK,
    ACTIONS(758), 1,
      anon_sym_DOT,
    STATE(232), 1,
      sym_comment,
    STATE(328), 1,
      sym__key_named,
    STATE(334), 1,
      sym_key,
    ACTIONS(746), 18,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(744), 21,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [27490] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(233), 1,
      sym_comment,
    ACTIONS(762), 19,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(760), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [27544] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(234), 1,
      sym_comment,
    ACTIONS(766), 19,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(764), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [27598] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(235), 1,
      sym_comment,
    ACTIONS(770), 19,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(768), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [27652] = 31,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(697), 1,
      sym_name,
    ACTIONS(700), 1,
      anon_sym_return,
    ACTIONS(735), 1,
      anon_sym_LPAREN,
    ACTIONS(738), 1,
      anon_sym_AT,
    ACTIONS(741), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(772), 1,
      ts_builtin_sym_end,
    ACTIONS(774), 1,
      anon_sym_local,
    ACTIONS(777), 1,
      anon_sym_function,
    ACTIONS(780), 1,
      anon_sym_for,
    ACTIONS(783), 1,
      anon_sym_do,
    ACTIONS(786), 1,
      anon_sym_if,
    ACTIONS(789), 1,
      anon_sym_repeat,
    ACTIONS(792), 1,
      anon_sym_while,
    ACTIONS(795), 1,
      anon_sym_break,
    ACTIONS(798), 1,
      sym_continue_stmt,
    ACTIONS(801), 1,
      anon_sym_export,
    ACTIONS(804), 1,
      anon_sym_type,
    STATE(1305), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2283), 1,
      sym_statement,
    STATE(2539), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2785), 1,
      sym__prefixexp,
    STATE(2787), 1,
      aux_sym__attrlist,
    STATE(2833), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3426), 1,
      sym__varlist,
    STATE(236), 2,
      sym_comment,
      aux_sym__block_repeat1,
    STATE(2234), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [27760] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(237), 1,
      sym_comment,
    ACTIONS(809), 19,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(807), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [27814] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(238), 1,
      sym_comment,
    ACTIONS(813), 19,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(811), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [27868] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(239), 1,
      sym_comment,
    ACTIONS(817), 19,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(815), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [27922] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(240), 1,
      sym_comment,
    ACTIONS(821), 19,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(819), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [27976] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(241), 1,
      sym_comment,
    ACTIONS(825), 19,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(823), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [28030] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(242), 1,
      sym_comment,
    ACTIONS(829), 19,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(827), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [28084] = 30,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(697), 1,
      sym_name,
    ACTIONS(735), 1,
      anon_sym_LPAREN,
    ACTIONS(738), 1,
      anon_sym_AT,
    ACTIONS(741), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(831), 1,
      anon_sym_local,
    ACTIONS(834), 1,
      anon_sym_function,
    ACTIONS(837), 1,
      anon_sym_for,
    ACTIONS(840), 1,
      anon_sym_do,
    ACTIONS(843), 1,
      anon_sym_if,
    ACTIONS(846), 1,
      anon_sym_repeat,
    ACTIONS(849), 1,
      anon_sym_while,
    ACTIONS(852), 1,
      anon_sym_break,
    ACTIONS(855), 1,
      sym_continue_stmt,
    ACTIONS(858), 1,
      anon_sym_export,
    ACTIONS(861), 1,
      anon_sym_type,
    STATE(1311), 1,
      sym_call_stmt,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2264), 1,
      sym_statement,
    STATE(2543), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2806), 1,
      sym__prefixexp,
    STATE(2816), 1,
      aux_sym__attrlist,
    STATE(2840), 1,
      sym__tbl_method,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3314), 1,
      sym__varlist,
    ACTIONS(700), 2,
      anon_sym_return,
      anon_sym_end,
    STATE(243), 2,
      sym_comment,
      aux_sym__block_repeat1,
    STATE(2255), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [28190] = 30,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(697), 1,
      sym_name,
    ACTIONS(735), 1,
      anon_sym_LPAREN,
    ACTIONS(738), 1,
      anon_sym_AT,
    ACTIONS(741), 1,
      anon_sym_AT_LBRACK,
    ACTIONS(864), 1,
      anon_sym_local,
    ACTIONS(867), 1,
      anon_sym_function,
    ACTIONS(870), 1,
      anon_sym_for,
    ACTIONS(873), 1,
      anon_sym_do,
    ACTIONS(876), 1,
      anon_sym_if,
    ACTIONS(879), 1,
      anon_sym_repeat,
    ACTIONS(882), 1,
      anon_sym_while,
    ACTIONS(885), 1,
      anon_sym_break,
    ACTIONS(888), 1,
      sym_continue_stmt,
    ACTIONS(891), 1,
      anon_sym_export,
    ACTIONS(894), 1,
      anon_sym_type,
    STATE(1375), 1,
      sym_call_stmt,
    STATE(2217), 1,
      sym_statement,
    STATE(2223), 1,
      sym__tbl_seq,
    STATE(2534), 1,
      sym_var,
    STATE(2691), 1,
      sym_exp_wrap,
    STATE(2747), 1,
      sym__prefixexp,
    STATE(2751), 1,
      sym__tbl_method,
    STATE(2820), 1,
      aux_sym__attrlist,
    STATE(2882), 1,
      sym_attribute,
    STATE(3049), 1,
      sym_prefixexp,
    STATE(3349), 1,
      sym__varlist,
    ACTIONS(700), 2,
      anon_sym_return,
      anon_sym_until,
    STATE(244), 2,
      sym_comment,
      aux_sym__block_repeat1,
    STATE(2216), 14,
      sym_local_fn_stmt,
      sym_fn_stmt,
      sym_for_in_stmt,
      sym_for_range_stmt,
      sym_if_stmt,
      sym_repeat_stmt,
      sym_while_stmt,
      sym_do_stmt,
      sym_break_stmt,
      sym_local_var_stmt,
      sym_var_stmt,
      sym_assign_stmt,
      sym_type_stmt,
      sym_type_fn_stmt,
  [28296] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(245), 1,
      sym_comment,
    ACTIONS(899), 19,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(897), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [28350] = 8,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(901), 1,
      anon_sym_LBRACK,
    ACTIONS(903), 1,
      anon_sym_DOT,
    STATE(246), 1,
      sym_comment,
    STATE(271), 1,
      sym_key,
    STATE(272), 1,
      sym__key_named,
    ACTIONS(691), 19,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(689), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [28412] = 9,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(901), 1,
      anon_sym_LBRACK,
    ACTIONS(903), 1,
      anon_sym_DOT,
    STATE(247), 1,
      sym_comment,
    STATE(272), 1,
      sym__key_named,
    STATE(273), 1,
      sym_key,
    ACTIONS(752), 3,
      sym__string_start,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
    ACTIONS(750), 16,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_AT_LBRACK,
    ACTIONS(748), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [28476] = 8,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(901), 1,
      anon_sym_LBRACK,
    ACTIONS(903), 1,
      anon_sym_DOT,
    STATE(248), 1,
      sym_comment,
    STATE(272), 1,
      sym__key_named,
    STATE(275), 1,
      sym_key,
    ACTIONS(746), 19,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(744), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [28538] = 8,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(905), 1,
      anon_sym_LBRACK,
    ACTIONS(907), 1,
      anon_sym_DOT,
    STATE(249), 1,
      sym_comment,
    STATE(287), 1,
      sym_key,
    STATE(288), 1,
      sym__key_named,
    ACTIONS(691), 18,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(689), 21,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [28600] = 9,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(905), 1,
      anon_sym_LBRACK,
    ACTIONS(907), 1,
      anon_sym_DOT,
    STATE(250), 1,
      sym_comment,
    STATE(288), 1,
      sym__key_named,
    STATE(296), 1,
      sym_key,
    ACTIONS(752), 3,
      sym__string_start,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
    ACTIONS(750), 15,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_AT_LBRACK,
    ACTIONS(748), 21,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [28664] = 8,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(905), 1,
      anon_sym_LBRACK,
    ACTIONS(907), 1,
      anon_sym_DOT,
    STATE(251), 1,
      sym_comment,
    STATE(288), 1,
      sym__key_named,
    STATE(300), 1,
      sym_key,
    ACTIONS(746), 18,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(744), 21,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [28726] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(252), 1,
      sym_comment,
    ACTIONS(911), 19,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(909), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [28780] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(253), 1,
      sym_comment,
    ACTIONS(915), 19,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(913), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [28834] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(254), 1,
      sym_comment,
    ACTIONS(919), 19,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(917), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [28888] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(255), 1,
      sym_comment,
    ACTIONS(923), 19,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(921), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [28942] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(256), 1,
      sym_comment,
    ACTIONS(927), 19,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(925), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [28996] = 7,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(933), 1,
      anon_sym_LT,
    ACTIONS(935), 1,
      anon_sym_DOT,
    ACTIONS(937), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(257), 1,
      sym_comment,
    ACTIONS(931), 18,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(929), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      sym_name,
      anon_sym_AT,
  [29056] = 9,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(756), 1,
      anon_sym_LBRACK,
    ACTIONS(758), 1,
      anon_sym_DOT,
    STATE(258), 1,
      sym_comment,
    STATE(328), 1,
      sym__key_named,
    STATE(331), 1,
      sym_key,
    ACTIONS(752), 3,
      sym__string_start,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
    ACTIONS(750), 15,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_AT_LBRACK,
    ACTIONS(748), 21,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [29120] = 8,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(756), 1,
      anon_sym_LBRACK,
    ACTIONS(758), 1,
      anon_sym_DOT,
    STATE(259), 1,
      sym_comment,
    STATE(327), 1,
      sym_key,
    STATE(328), 1,
      sym__key_named,
    ACTIONS(691), 18,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(689), 21,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [29182] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(260), 1,
      sym_comment,
    ACTIONS(941), 19,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(939), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [29236] = 6,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(933), 1,
      anon_sym_LT,
    ACTIONS(935), 1,
      anon_sym_DOT,
    STATE(261), 1,
      sym_comment,
    ACTIONS(931), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(929), 21,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [29293] = 5,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(947), 1,
      anon_sym_DASH_GT,
    STATE(262), 1,
      sym_comment,
    ACTIONS(945), 18,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(943), 23,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [29348] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(263), 1,
      sym_comment,
    ACTIONS(911), 20,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(909), 21,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [29400] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(264), 1,
      sym_comment,
    ACTIONS(919), 19,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(917), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [29452] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(265), 1,
      sym_comment,
    ACTIONS(915), 19,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(913), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [29504] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(266), 1,
      sym_comment,
    ACTIONS(923), 19,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(921), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [29556] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(267), 1,
      sym_comment,
    ACTIONS(919), 19,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(917), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [29608] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(268), 1,
      sym_comment,
    ACTIONS(923), 19,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(921), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [29660] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(269), 1,
      sym_comment,
    ACTIONS(927), 19,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(925), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [29712] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(270), 1,
      sym_comment,
    ACTIONS(927), 19,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(925), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [29764] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(271), 1,
      sym_comment,
    ACTIONS(809), 20,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(807), 21,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [29816] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(272), 1,
      sym_comment,
    ACTIONS(813), 20,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(811), 21,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [29868] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(273), 1,
      sym_comment,
    ACTIONS(817), 20,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(815), 21,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [29920] = 7,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(949), 1,
      anon_sym_LT,
    ACTIONS(951), 1,
      anon_sym_DOT,
    ACTIONS(953), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(274), 1,
      sym_comment,
    ACTIONS(931), 18,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(929), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      sym_name,
      anon_sym_AT,
  [29978] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(275), 1,
      sym_comment,
    ACTIONS(821), 20,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(819), 21,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [30030] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(276), 1,
      sym_comment,
    ACTIONS(825), 20,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(823), 21,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [30082] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(277), 1,
      sym_comment,
    ACTIONS(825), 19,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(823), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [30134] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(278), 1,
      sym_comment,
    ACTIONS(829), 20,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(827), 21,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [30186] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(279), 1,
      sym_comment,
    ACTIONS(899), 20,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(897), 21,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [30238] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(280), 1,
      sym_comment,
    ACTIONS(899), 19,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(897), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [30290] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(281), 1,
      sym_comment,
    ACTIONS(829), 19,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(827), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [30342] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(282), 1,
      sym_comment,
    ACTIONS(957), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(955), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [30394] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(283), 1,
      sym_comment,
    ACTIONS(961), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(959), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [30446] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(284), 1,
      sym_comment,
    ACTIONS(899), 19,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(897), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [30498] = 7,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(963), 1,
      anon_sym_LT,
    ACTIONS(965), 1,
      anon_sym_DOT,
    ACTIONS(967), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(285), 1,
      sym_comment,
    ACTIONS(929), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      sym_name,
      anon_sym_AT,
    ACTIONS(931), 19,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
  [30556] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(286), 1,
      sym_comment,
    ACTIONS(770), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(768), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [30608] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(287), 1,
      sym_comment,
    ACTIONS(809), 19,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(807), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [30660] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(288), 1,
      sym_comment,
    ACTIONS(813), 19,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(811), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [30712] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(289), 1,
      sym_comment,
    ACTIONS(941), 20,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(939), 21,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [30764] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(290), 1,
      sym_comment,
    ACTIONS(770), 19,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(768), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [30816] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(291), 1,
      sym_comment,
    ACTIONS(762), 20,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(760), 21,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [30868] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(292), 1,
      sym_comment,
    ACTIONS(915), 20,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(913), 21,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [30920] = 7,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(973), 1,
      anon_sym_AMP,
    ACTIONS(975), 1,
      anon_sym_PIPE,
    ACTIONS(977), 1,
      anon_sym_QMARK,
    STATE(293), 1,
      sym_comment,
    ACTIONS(971), 16,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(969), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [30978] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(294), 1,
      sym_comment,
    ACTIONS(981), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(979), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [31030] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(295), 1,
      sym_comment,
    ACTIONS(985), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(983), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [31082] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(296), 1,
      sym_comment,
    ACTIONS(817), 19,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(815), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [31134] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(297), 1,
      sym_comment,
    ACTIONS(919), 20,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(917), 21,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [31186] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(298), 1,
      sym_comment,
    ACTIONS(989), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(987), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [31238] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(299), 1,
      sym_comment,
    ACTIONS(993), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(991), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [31290] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(300), 1,
      sym_comment,
    ACTIONS(821), 19,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(819), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [31342] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(301), 1,
      sym_comment,
    ACTIONS(766), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(764), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [31394] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(302), 1,
      sym_comment,
    ACTIONS(997), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(995), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [31446] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(303), 1,
      sym_comment,
    ACTIONS(825), 19,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(823), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [31498] = 7,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(973), 1,
      anon_sym_AMP,
    ACTIONS(975), 1,
      anon_sym_PIPE,
    ACTIONS(977), 1,
      anon_sym_QMARK,
    STATE(304), 1,
      sym_comment,
    ACTIONS(1001), 16,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(999), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [31556] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(305), 1,
      sym_comment,
    ACTIONS(1005), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(1003), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [31608] = 7,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(1007), 1,
      anon_sym_LT,
    ACTIONS(1009), 1,
      anon_sym_DOT,
    ACTIONS(1011), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(306), 1,
      sym_comment,
    ACTIONS(931), 18,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(929), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      sym_name,
      anon_sym_AT,
  [31666] = 7,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(973), 1,
      anon_sym_AMP,
    ACTIONS(975), 1,
      anon_sym_PIPE,
    ACTIONS(977), 1,
      anon_sym_QMARK,
    STATE(307), 1,
      sym_comment,
    ACTIONS(1015), 16,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(1013), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [31724] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(308), 1,
      sym_comment,
    ACTIONS(923), 20,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(921), 21,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [31776] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(309), 1,
      sym_comment,
    ACTIONS(829), 19,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(827), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [31828] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(310), 1,
      sym_comment,
    ACTIONS(1015), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(1013), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [31880] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(311), 1,
      sym_comment,
    ACTIONS(1019), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(1017), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [31932] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(312), 1,
      sym_comment,
    ACTIONS(927), 20,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(925), 21,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [31984] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(313), 1,
      sym_comment,
    ACTIONS(1023), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(1021), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [32036] = 7,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(973), 1,
      anon_sym_AMP,
    ACTIONS(975), 1,
      anon_sym_PIPE,
    ACTIONS(977), 1,
      anon_sym_QMARK,
    STATE(314), 1,
      sym_comment,
    ACTIONS(1027), 16,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(1025), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [32094] = 5,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(315), 1,
      sym_comment,
    ACTIONS(752), 3,
      sym__string_start,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
    ACTIONS(750), 15,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_AT_LBRACK,
    ACTIONS(748), 23,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [32148] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(316), 1,
      sym_comment,
    ACTIONS(1031), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(1029), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [32200] = 5,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(1037), 1,
      anon_sym_LT,
    STATE(317), 1,
      sym_comment,
    ACTIONS(1035), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(1033), 21,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [32254] = 5,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(977), 1,
      anon_sym_QMARK,
    STATE(318), 1,
      sym_comment,
    ACTIONS(1041), 18,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_AT_LBRACK,
    ACTIONS(1039), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [32308] = 6,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(973), 1,
      anon_sym_AMP,
    ACTIONS(977), 1,
      anon_sym_QMARK,
    STATE(319), 1,
      sym_comment,
    ACTIONS(1041), 17,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_PIPE,
      anon_sym_AT_LBRACK,
    ACTIONS(1039), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [32364] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(320), 1,
      sym_comment,
    ACTIONS(911), 19,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(909), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [32416] = 7,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(973), 1,
      anon_sym_AMP,
    ACTIONS(975), 1,
      anon_sym_PIPE,
    ACTIONS(977), 1,
      anon_sym_QMARK,
    STATE(321), 1,
      sym_comment,
    ACTIONS(1045), 16,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(1043), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [32474] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(322), 1,
      sym_comment,
    ACTIONS(1045), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(1043), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [32526] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(323), 1,
      sym_comment,
    ACTIONS(1049), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(1047), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [32578] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(324), 1,
      sym_comment,
    ACTIONS(1053), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(1051), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [32630] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(325), 1,
      sym_comment,
    ACTIONS(1057), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(1055), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [32682] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(326), 1,
      sym_comment,
    ACTIONS(1061), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(1059), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [32734] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(327), 1,
      sym_comment,
    ACTIONS(809), 19,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(807), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [32786] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(328), 1,
      sym_comment,
    ACTIONS(813), 19,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(811), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [32838] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(329), 1,
      sym_comment,
    ACTIONS(766), 20,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(764), 21,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [32890] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(330), 1,
      sym_comment,
    ACTIONS(770), 20,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(768), 21,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [32942] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(331), 1,
      sym_comment,
    ACTIONS(817), 19,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(815), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [32994] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(332), 1,
      sym_comment,
    ACTIONS(941), 19,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(939), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [33046] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(333), 1,
      sym_comment,
    ACTIONS(762), 19,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(760), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [33098] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(334), 1,
      sym_comment,
    ACTIONS(821), 19,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(819), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [33150] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(335), 1,
      sym_comment,
    ACTIONS(941), 19,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(939), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [33202] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(336), 1,
      sym_comment,
    ACTIONS(762), 19,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(760), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [33254] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(337), 1,
      sym_comment,
    ACTIONS(766), 19,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(764), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [33306] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(338), 1,
      sym_comment,
    ACTIONS(770), 19,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(768), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [33358] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(339), 1,
      sym_comment,
    ACTIONS(911), 19,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(909), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [33410] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(340), 1,
      sym_comment,
    ACTIONS(915), 19,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(913), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [33462] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(341), 1,
      sym_comment,
    ACTIONS(766), 19,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(764), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_name,
      anon_sym_AT,
  [33514] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(342), 1,
      sym_comment,
    ACTIONS(1065), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(1063), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [33566] = 6,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(1071), 1,
      anon_sym_COLON,
    STATE(343), 1,
      sym_comment,
    STATE(2962), 1,
      sym__method_name,
    ACTIONS(1069), 16,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(1067), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [33621] = 5,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(947), 1,
      anon_sym_DASH_GT,
    STATE(344), 1,
      sym_comment,
    ACTIONS(945), 18,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(943), 21,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [33674] = 5,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(947), 1,
      anon_sym_DASH_GT,
    STATE(345), 1,
      sym_comment,
    ACTIONS(945), 18,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(943), 21,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [33727] = 6,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(963), 1,
      anon_sym_LT,
    ACTIONS(965), 1,
      anon_sym_DOT,
    STATE(346), 1,
      sym_comment,
    ACTIONS(929), 18,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
    ACTIONS(931), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
  [33782] = 5,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(947), 1,
      anon_sym_DASH_GT,
    STATE(347), 1,
      sym_comment,
    ACTIONS(945), 19,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(943), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [33835] = 6,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(1007), 1,
      anon_sym_LT,
    ACTIONS(1009), 1,
      anon_sym_DOT,
    STATE(348), 1,
      sym_comment,
    ACTIONS(929), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
    ACTIONS(931), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
  [33890] = 6,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(949), 1,
      anon_sym_LT,
    ACTIONS(951), 1,
      anon_sym_DOT,
    STATE(349), 1,
      sym_comment,
    ACTIONS(929), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
    ACTIONS(931), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
  [33945] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(350), 1,
      sym_comment,
    ACTIONS(1023), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(1021), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [33995] = 5,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(1073), 1,
      anon_sym_LT,
    STATE(351), 1,
      sym_comment,
    ACTIONS(1033), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
    ACTIONS(1035), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
  [34047] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(352), 1,
      sym_comment,
    ACTIONS(1003), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
    ACTIONS(1005), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
  [34097] = 5,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(353), 1,
      sym_comment,
    ACTIONS(752), 3,
      sym__string_start,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
    ACTIONS(750), 15,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_AT_LBRACK,
    ACTIONS(748), 21,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [34149] = 5,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(1075), 1,
      anon_sym_QMARK,
    STATE(354), 1,
      sym_comment,
    ACTIONS(1041), 18,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_AT_LBRACK,
    ACTIONS(1039), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [34201] = 6,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(1075), 1,
      anon_sym_QMARK,
    ACTIONS(1077), 1,
      anon_sym_AMP,
    STATE(355), 1,
      sym_comment,
    ACTIONS(1041), 17,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_PIPE,
      anon_sym_AT_LBRACK,
    ACTIONS(1039), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [34255] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(356), 1,
      sym_comment,
    ACTIONS(961), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(959), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [34305] = 7,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(1075), 1,
      anon_sym_QMARK,
    ACTIONS(1077), 1,
      anon_sym_AMP,
    ACTIONS(1079), 1,
      anon_sym_PIPE,
    STATE(357), 1,
      sym_comment,
    ACTIONS(1045), 16,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(1043), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [34361] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(358), 1,
      sym_comment,
    ACTIONS(1045), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(1043), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [34411] = 7,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(1081), 1,
      anon_sym_AMP,
    ACTIONS(1083), 1,
      anon_sym_PIPE,
    ACTIONS(1085), 1,
      anon_sym_QMARK,
    STATE(359), 1,
      sym_comment,
    ACTIONS(1015), 17,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(1013), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [34467] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(360), 1,
      sym_comment,
    ACTIONS(1013), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
    ACTIONS(1015), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
  [34517] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(361), 1,
      sym_comment,
    ACTIONS(1049), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(1047), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [34567] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(362), 1,
      sym_comment,
    ACTIONS(1053), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(1051), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [34617] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(363), 1,
      sym_comment,
    ACTIONS(1057), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(1055), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [34667] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(364), 1,
      sym_comment,
    ACTIONS(1017), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
    ACTIONS(1019), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
  [34717] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(365), 1,
      sym_comment,
    ACTIONS(1021), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
    ACTIONS(1023), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
  [34767] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(366), 1,
      sym_comment,
    ACTIONS(1061), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(1059), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [34817] = 7,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(1081), 1,
      anon_sym_AMP,
    ACTIONS(1083), 1,
      anon_sym_PIPE,
    ACTIONS(1085), 1,
      anon_sym_QMARK,
    STATE(367), 1,
      sym_comment,
    ACTIONS(1027), 17,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(1025), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [34873] = 16,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(1091), 1,
      anon_sym_COMMA,
    ACTIONS(1095), 1,
      anon_sym_or,
    ACTIONS(1097), 1,
      anon_sym_and,
    ACTIONS(1105), 1,
      anon_sym_SLASH,
    ACTIONS(1107), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1109), 1,
      anon_sym_CARET,
    ACTIONS(1111), 1,
      anon_sym_COLON_COLON,
    STATE(368), 1,
      sym_comment,
    STATE(1747), 1,
      aux_sym__explist_repeat1,
    ACTIONS(1093), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1101), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1089), 3,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(1103), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1099), 4,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1087), 17,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      sym_name,
      anon_sym_AT,
  [34947] = 7,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(1113), 1,
      anon_sym_AMP,
    ACTIONS(1115), 1,
      anon_sym_PIPE,
    ACTIONS(1117), 1,
      anon_sym_QMARK,
    STATE(369), 1,
      sym_comment,
    ACTIONS(971), 16,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(969), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [35003] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(370), 1,
      sym_comment,
    ACTIONS(981), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(979), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [35053] = 5,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(371), 1,
      sym_comment,
    ACTIONS(752), 3,
      sym__string_start,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
    ACTIONS(750), 15,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_AT_LBRACK,
    ACTIONS(748), 21,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [35105] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(372), 1,
      sym_comment,
    ACTIONS(985), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(983), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [35155] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(373), 1,
      sym_comment,
    ACTIONS(1029), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
    ACTIONS(1031), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
  [35205] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(374), 1,
      sym_comment,
    ACTIONS(989), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(987), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [35255] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(375), 1,
      sym_comment,
    ACTIONS(993), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(991), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [35305] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(376), 1,
      sym_comment,
    ACTIONS(1065), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(1063), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [35355] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(377), 1,
      sym_comment,
    ACTIONS(997), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(995), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [35405] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(378), 1,
      sym_comment,
    ACTIONS(766), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(764), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [35455] = 7,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(1113), 1,
      anon_sym_AMP,
    ACTIONS(1115), 1,
      anon_sym_PIPE,
    ACTIONS(1117), 1,
      anon_sym_QMARK,
    STATE(379), 1,
      sym_comment,
    ACTIONS(1001), 16,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(999), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [35511] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(380), 1,
      sym_comment,
    ACTIONS(1005), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(1003), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [35561] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(381), 1,
      sym_comment,
    ACTIONS(770), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(768), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [35611] = 5,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(1119), 1,
      anon_sym_LT,
    STATE(382), 1,
      sym_comment,
    ACTIONS(1033), 18,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
    ACTIONS(1035), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
  [35663] = 7,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(1113), 1,
      anon_sym_AMP,
    ACTIONS(1115), 1,
      anon_sym_PIPE,
    ACTIONS(1117), 1,
      anon_sym_QMARK,
    STATE(383), 1,
      sym_comment,
    ACTIONS(1015), 16,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(1013), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [35719] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(384), 1,
      sym_comment,
    ACTIONS(957), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(955), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [35769] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(385), 1,
      sym_comment,
    ACTIONS(1015), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(1013), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [35819] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(386), 1,
      sym_comment,
    ACTIONS(1019), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(1017), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [35869] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(387), 1,
      sym_comment,
    ACTIONS(1023), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(1021), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [35919] = 7,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(1113), 1,
      anon_sym_AMP,
    ACTIONS(1115), 1,
      anon_sym_PIPE,
    ACTIONS(1117), 1,
      anon_sym_QMARK,
    STATE(388), 1,
      sym_comment,
    ACTIONS(1027), 16,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(1025), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [35975] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(389), 1,
      sym_comment,
    ACTIONS(1031), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(1029), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [36025] = 5,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(1085), 1,
      anon_sym_QMARK,
    STATE(390), 1,
      sym_comment,
    ACTIONS(1039), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
    ACTIONS(1041), 19,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_AT_LBRACK,
  [36077] = 5,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(1121), 1,
      anon_sym_LT,
    STATE(391), 1,
      sym_comment,
    ACTIONS(1033), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
    ACTIONS(1035), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
  [36129] = 5,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(1117), 1,
      anon_sym_QMARK,
    STATE(392), 1,
      sym_comment,
    ACTIONS(1041), 18,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_AT_LBRACK,
    ACTIONS(1039), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [36181] = 26,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(1123), 1,
      sym_name,
    ACTIONS(1125), 1,
      anon_sym_SEMI,
    ACTIONS(1127), 1,
      anon_sym_function,
    ACTIONS(1131), 1,
      anon_sym_if,
    ACTIONS(1135), 1,
      anon_sym_not,
    ACTIONS(1137), 1,
      anon_sym_LBRACE,
    ACTIONS(1139), 1,
      anon_sym_LPAREN,
    ACTIONS(1141), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1143), 1,
      sym_number,
    ACTIONS(1147), 1,
      anon_sym_nil,
    ACTIONS(1149), 1,
      sym__string_start,
    ACTIONS(1151), 1,
      sym_interp_start,
    STATE(393), 1,
      sym_comment,
    STATE(1101), 1,
      sym__tbl_seq,
    STATE(1224), 1,
      sym_var,
    STATE(1431), 1,
      sym_prefixexp,
    STATE(1530), 1,
      sym_exp,
    STATE(2793), 1,
      sym__prefixexp,
    STATE(2794), 1,
      sym__tbl_method,
    STATE(2901), 1,
      sym__explist,
    ACTIONS(1133), 2,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(1100), 2,
      sym_exp_wrap,
      sym_call_stmt,
    ACTIONS(1129), 3,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
    STATE(1783), 11,
      sym_binexp,
      sym_cast,
      sym_unexp,
      sym_ifexp,
      sym_table,
      sym_anon_fn,
      sym_vararg,
      sym_string,
      sym_string_interp,
      sym_boolean,
      sym_nil,
  [36275] = 6,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(1113), 1,
      anon_sym_AMP,
    ACTIONS(1117), 1,
      anon_sym_QMARK,
    STATE(394), 1,
      sym_comment,
    ACTIONS(1041), 17,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_PIPE,
      anon_sym_AT_LBRACK,
    ACTIONS(1039), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [36329] = 7,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(1113), 1,
      anon_sym_AMP,
    ACTIONS(1115), 1,
      anon_sym_PIPE,
    ACTIONS(1117), 1,
      anon_sym_QMARK,
    STATE(395), 1,
      sym_comment,
    ACTIONS(1045), 16,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(1043), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [36385] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(396), 1,
      sym_comment,
    ACTIONS(1045), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(1043), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [36435] = 6,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(1081), 1,
      anon_sym_AMP,
    ACTIONS(1085), 1,
      anon_sym_QMARK,
    STATE(397), 1,
      sym_comment,
    ACTIONS(1041), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_PIPE,
      anon_sym_AT_LBRACK,
    ACTIONS(1039), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [36489] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(398), 1,
      sym_comment,
    ACTIONS(1031), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(1029), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [36539] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(399), 1,
      sym_comment,
    ACTIONS(1053), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(1051), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [36589] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(400), 1,
      sym_comment,
    ACTIONS(1057), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(1055), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [36639] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(401), 1,
      sym_comment,
    ACTIONS(1061), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(1059), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [36689] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(402), 1,
      sym_comment,
    ACTIONS(955), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
    ACTIONS(957), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
  [36739] = 7,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(1081), 1,
      anon_sym_AMP,
    ACTIONS(1083), 1,
      anon_sym_PIPE,
    ACTIONS(1085), 1,
      anon_sym_QMARK,
    STATE(403), 1,
      sym_comment,
    ACTIONS(1045), 17,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(1043), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [36795] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(404), 1,
      sym_comment,
    ACTIONS(1043), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
    ACTIONS(1045), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
  [36845] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(405), 1,
      sym_comment,
    ACTIONS(959), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
    ACTIONS(961), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
  [36895] = 27,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(1153), 1,
      sym_name,
    ACTIONS(1157), 1,
      anon_sym_function,
    ACTIONS(1159), 1,
      anon_sym_if,
    ACTIONS(1163), 1,
      anon_sym_not,
    ACTIONS(1165), 1,
      anon_sym_LBRACE,
    ACTIONS(1167), 1,
      anon_sym_RBRACE,
    ACTIONS(1169), 1,
      anon_sym_LBRACK,
    ACTIONS(1171), 1,
      anon_sym_LPAREN,
    ACTIONS(1173), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1175), 1,
      sym_number,
    ACTIONS(1179), 1,
      anon_sym_nil,
    ACTIONS(1181), 1,
      sym__string_start,
    ACTIONS(1183), 1,
      sym_interp_start,
    STATE(406), 1,
      sym_comment,
    STATE(1088), 1,
      sym__tbl_seq,
    STATE(1184), 1,
      sym_var,
    STATE(1294), 1,
      sym_prefixexp,
    STATE(2085), 1,
      sym_exp,
    STATE(2768), 1,
      sym__prefixexp,
    STATE(2770), 1,
      sym__tbl_method,
    STATE(3015), 1,
      sym_field,
    ACTIONS(1155), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(1161), 2,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1177), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(1090), 2,
      sym_exp_wrap,
      sym_call_stmt,
    STATE(1594), 11,
      sym_binexp,
      sym_cast,
      sym_unexp,
      sym_ifexp,
      sym_table,
      sym_anon_fn,
      sym_vararg,
      sym_string,
      sym_string_interp,
      sym_boolean,
      sym_nil,
  [36991] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(407), 1,
      sym_comment,
    ACTIONS(1047), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
    ACTIONS(1049), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
  [37041] = 5,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(408), 1,
      sym_comment,
    ACTIONS(752), 3,
      sym__string_start,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
    ACTIONS(750), 16,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_AT_LBRACK,
    ACTIONS(748), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_COLON,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [37093] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(409), 1,
      sym_comment,
    ACTIONS(1051), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
    ACTIONS(1053), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
  [37143] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(410), 1,
      sym_comment,
    ACTIONS(1055), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
    ACTIONS(1057), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
  [37193] = 7,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(1075), 1,
      anon_sym_QMARK,
    ACTIONS(1077), 1,
      anon_sym_AMP,
    ACTIONS(1079), 1,
      anon_sym_PIPE,
    STATE(411), 1,
      sym_comment,
    ACTIONS(971), 16,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(969), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [37249] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(412), 1,
      sym_comment,
    ACTIONS(981), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(979), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [37299] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(413), 1,
      sym_comment,
    ACTIONS(1059), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
    ACTIONS(1061), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
  [37349] = 7,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(1081), 1,
      anon_sym_AMP,
    ACTIONS(1083), 1,
      anon_sym_PIPE,
    ACTIONS(1085), 1,
      anon_sym_QMARK,
    STATE(414), 1,
      sym_comment,
    ACTIONS(971), 17,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(969), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [37405] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(415), 1,
      sym_comment,
    ACTIONS(985), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(983), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [37455] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(416), 1,
      sym_comment,
    ACTIONS(957), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(955), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [37505] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(417), 1,
      sym_comment,
    ACTIONS(979), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
    ACTIONS(981), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
  [37555] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(418), 1,
      sym_comment,
    ACTIONS(983), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
    ACTIONS(985), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
  [37605] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(419), 1,
      sym_comment,
    ACTIONS(961), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(959), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [37655] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(420), 1,
      sym_comment,
    ACTIONS(989), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(987), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [37705] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(421), 1,
      sym_comment,
    ACTIONS(993), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(991), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [37755] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(422), 1,
      sym_comment,
    ACTIONS(766), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(764), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [37805] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(423), 1,
      sym_comment,
    ACTIONS(770), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(768), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [37855] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(424), 1,
      sym_comment,
    ACTIONS(987), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
    ACTIONS(989), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
  [37905] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(425), 1,
      sym_comment,
    ACTIONS(1065), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(1063), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [37955] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(426), 1,
      sym_comment,
    ACTIONS(997), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(995), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [38005] = 7,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(1075), 1,
      anon_sym_QMARK,
    ACTIONS(1077), 1,
      anon_sym_AMP,
    ACTIONS(1079), 1,
      anon_sym_PIPE,
    STATE(427), 1,
      sym_comment,
    ACTIONS(1001), 16,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
    ACTIONS(999), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [38061] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(428), 1,
      sym_comment,
    ACTIONS(1005), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
    ACTIONS(1003), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
  [38111] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(429), 1,
      sym_comment,
    ACTIONS(991), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
    ACTIONS(993), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
  [38161] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(430), 1,
      sym_comment,
    ACTIONS(1063), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
    ACTIONS(1065), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
  [38211] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(431), 1,
      sym_comment,
    ACTIONS(995), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_if,
      anon_sym_repeat,
      anon_sym_while,
      anon_sym_break,
      sym_continue_stmt,
      anon_sym_export,
      anon_sym_type,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_SLASH,
      sym_name,
      anon_sym_AT,
    ACTIONS(997), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_AT_LBRACK,
  [38261] = 7,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(1075), 1,
      anon_sym_QMARK,
    ACTIONS(1077), 1,
      anon_sym_AMP,
    ACTIONS(1079), 1,
      anon_sym_PIPE,
    STATE(432), 1,
      sym_comment,
    ACTIONS(1015), 16,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_AT_LBRACK,
 