/*++

Copyright (C) 2019 Calculation developers

All rights reserved.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.6.0.

Abstract: This is an autogenerated C++-Header file in order to allow an easy
 use of Calculation library

Interface version: 1.0.0

*/

#ifndef __CALCULATION_DYNAMICHEADER_CPPTYPES
#define __CALCULATION_DYNAMICHEADER_CPPTYPES

#include "calculation_types.hpp"

#include "numbers_types.hpp"


/*************************************************************************************************************************
 Class definition for Base
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class definition for Calculator
**************************************************************************************************************************/

/**
* Adds a Variable to the list of Variables this calculator works on
*
* @param[in] pCalculator - Calculator instance.
* @param[in] pVariable - The new variable in this calculator
* @return error code or 0 (success)
*/
typedef CalculationResult (*PCalculationCalculator_EnlistVariablePtr) (Calculation_Calculator pCalculator, Numbers_Variable pVariable);

/**
* Returns an instance of a enlisted variable
*
* @param[in] pCalculator - Calculator instance.
* @param[in] nIndex - The index of the variable to query
* @param[out] pVariable - The Index-th variable in this calculator
* @return error code or 0 (success)
*/
typedef CalculationResult (*PCalculationCalculator_GetEnlistedVariablePtr) (Calculation_Calculator pCalculator, Calculation_uint32 nIndex, Numbers_Variable * pVariable);

/**
* Clears all variables in enlisted in this calculator
*
* @param[in] pCalculator - Calculator instance.
* @return error code or 0 (success)
*/
typedef CalculationResult (*PCalculationCalculator_ClearVariablesPtr) (Calculation_Calculator pCalculator);

/**
* Multiplies all enlisted variables
*
* @param[in] pCalculator - Calculator instance.
* @param[out] pInstance - Variable that holds the product of all enlisted Variables
* @return error code or 0 (success)
*/
typedef CalculationResult (*PCalculationCalculator_MultiplyPtr) (Calculation_Calculator pCalculator, Numbers_Variable * pInstance);

/**
* Sums all enlisted variables
*
* @param[in] pCalculator - Calculator instance.
* @param[out] pInstance - Variable that holds the sum of all enlisted Variables
* @return error code or 0 (success)
*/
typedef CalculationResult (*PCalculationCalculator_AddPtr) (Calculation_Calculator pCalculator, Numbers_Variable * pInstance);

/*************************************************************************************************************************
 Global functions
**************************************************************************************************************************/

/**
* Creates a new Calculator instance
*
* @param[out] pInstance - New Calculator instance
* @return error code or 0 (success)
*/
typedef CalculationResult (*PCalculationCreateCalculatorPtr) (Calculation_Calculator * pInstance);

/**
* retrieves the binary version of this library.
*
* @param[out] pMajor - returns the major version of this library
* @param[out] pMinor - returns the minor version of this library
* @param[out] pMicro - returns the micro version of this library
* @return error code or 0 (success)
*/
typedef CalculationResult (*PCalculationGetVersionPtr) (Calculation_uint32 * pMajor, Calculation_uint32 * pMinor, Calculation_uint32 * pMicro);

/**
* Returns the last error recorded on this object
*
* @param[in] pInstance - Instance Handle
* @param[in] nErrorMessageBufferSize - size of the buffer (including trailing 0)
* @param[out] pErrorMessageNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pErrorMessageBuffer -  buffer of Message of the last error, may be NULL
* @param[out] pHasError - Is there a last error to query
* @return error code or 0 (success)
*/
typedef CalculationResult (*PCalculationGetLastErrorPtr) (Calculation_Base pInstance, const Calculation_uint32 nErrorMessageBufferSize, Calculation_uint32* pErrorMessageNeededChars, char * pErrorMessageBuffer, bool * pHasError);

/**
* Releases shared ownership of an Instance
*
* @param[in] pInstance - Instance Handle
* @return error code or 0 (success)
*/
typedef CalculationResult (*PCalculationReleaseInstancePtr) (Calculation_Base pInstance);

/**
* Acquires shared ownership of an Instance
*
* @param[in] pInstance - Instance Handle
* @return error code or 0 (success)
*/
typedef CalculationResult (*PCalculationAcquireInstancePtr) (Calculation_Base pInstance);

/**
* Injects an imported component for usage within this component
*
* @param[in] pNameSpace - NameSpace of the injected component
* @param[in] pSymbolAddressMethod - Address of the SymbolAddressMethod of the injected component
* @return error code or 0 (success)
*/
typedef CalculationResult (*PCalculationInjectComponentPtr) (const char * pNameSpace, Calculation_pvoid pSymbolAddressMethod);

/**
* Returns the address of the SymbolLookupMethod
*
* @param[out] pSymbolLookupMethod - Address of the SymbolAddressMethod
* @return error code or 0 (success)
*/
typedef CalculationResult (*PCalculationGetSymbolLookupMethodPtr) (Calculation_pvoid * pSymbolLookupMethod);

/*************************************************************************************************************************
 Function Table Structure
**************************************************************************************************************************/

typedef struct {
	void * m_LibraryHandle;
	PCalculationCalculator_EnlistVariablePtr m_Calculator_EnlistVariable;
	PCalculationCalculator_GetEnlistedVariablePtr m_Calculator_GetEnlistedVariable;
	PCalculationCalculator_ClearVariablesPtr m_Calculator_ClearVariables;
	PCalculationCalculator_MultiplyPtr m_Calculator_Multiply;
	PCalculationCalculator_AddPtr m_Calculator_Add;
	PCalculationCreateCalculatorPtr m_CreateCalculator;
	PCalculationGetVersionPtr m_GetVersion;
	PCalculationGetLastErrorPtr m_GetLastError;
	PCalculationReleaseInstancePtr m_ReleaseInstance;
	PCalculationAcquireInstancePtr m_AcquireInstance;
	PCalculationInjectComponentPtr m_InjectComponent;
	PCalculationGetSymbolLookupMethodPtr m_GetSymbolLookupMethod;
} sCalculationDynamicWrapperTable;

#endif // __CALCULATION_DYNAMICHEADER_CPPTYPES

