{$IFDEF FPC}{$MODE DELPHI}{$ENDIF}
(*++

Copyright (C) 2019 ACT Developers


This file has been generated by the Automatic Component Toolkit (ACT) version 1.6.0.

Abstract: This is an autogenerated Pascal Header file in order to allow an easy
 use of Optional Class Library

Interface version: 1.0.0

*)

unit Unit_OptClass;

interface

uses
  {$IFDEF WINDOWS}
    Windows,
  {$ELSE}
    dynlibs,
  {$ENDIF}
  Types,
  Classes,
  SysUtils;

(*************************************************************************************************************************
 Version definition for OptClass
**************************************************************************************************************************)

const
  OPTCLASS_VERSION_MAJOR = 1;
  OPTCLASS_VERSION_MINOR = 0;
  OPTCLASS_VERSION_MICRO = 0;
  OPTCLASS_VERSION_PRERELEASEINFO = '';
  OPTCLASS_VERSION_BUILDINFO = '';


(*************************************************************************************************************************
 General type definitions
**************************************************************************************************************************)

type
  TOptClassResult = Cardinal;
  TOptClassHandle = Pointer;

  POptClassResult = ^TOptClassResult;
  POptClassHandle = ^TOptClassHandle;

(*************************************************************************************************************************
 Error Constants for OptClass
**************************************************************************************************************************)

const
  OPTCLASS_SUCCESS = 0;
  OPTCLASS_ERROR_NOTIMPLEMENTED = 1;
  OPTCLASS_ERROR_INVALIDPARAM = 2;
  OPTCLASS_ERROR_INVALIDCAST = 3;
  OPTCLASS_ERROR_BUFFERTOOSMALL = 4;
  OPTCLASS_ERROR_GENERICEXCEPTION = 5;
  OPTCLASS_ERROR_COULDNOTLOADLIBRARY = 6;
  OPTCLASS_ERROR_COULDNOTFINDLIBRARYEXPORT = 7;
  OPTCLASS_ERROR_INCOMPATIBLEBINARYVERSION = 8;


(*************************************************************************************************************************
 Declaration of handle classes 
**************************************************************************************************************************)

type
  TOptClassWrapper = class;
  TOptClassBase = class;


(*************************************************************************************************************************
 Function type definitions for Base
**************************************************************************************************************************)

(*************************************************************************************************************************
 Global function definitions 
**************************************************************************************************************************)

  (**
  * Acquire shared ownership of an Instance
  *
  * @param[in] pInstance - Instance Handle
  * @return error code or 0 (success)
  *)
  TOptClassAcquireInstanceFunc = function(const pInstance: TOptClassHandle): TOptClassResult; cdecl;
  
  (**
  * Releases shared ownership of an Instance
  *
  * @param[in] pInstance - Instance Handle
  * @return error code or 0 (success)
  *)
  TOptClassReleaseInstanceFunc = function(const pInstance: TOptClassHandle): TOptClassResult; cdecl;
  
  (**
  * retrieves the binary version of this library.
  *
  * @param[out] pMajor - returns the major version of this library
  * @param[out] pMinor - returns the minor version of this library
  * @param[out] pMicro - returns the micro version of this library
  * @return error code or 0 (success)
  *)
  TOptClassGetVersionFunc = function(out pMajor: Cardinal; out pMinor: Cardinal; out pMicro: Cardinal): TOptClassResult; cdecl;
  
  (**
  * Returns the last error recorded on this object
  *
  * @param[in] pInstance - Instance Handle
  * @param[in] nErrorMessageBufferSize - size of the buffer (including trailing 0)
  * @param[out] pErrorMessageNeededChars - will be filled with the count of the written bytes, or needed buffer size.
  * @param[out] pErrorMessageBuffer -  buffer of Message of the last error, may be NULL
  * @param[out] pHasError - Is there a last error to query
  * @return error code or 0 (success)
  *)
  TOptClassGetLastErrorFunc = function(const pInstance: TOptClassHandle; const nErrorMessageBufferSize: Cardinal; out pErrorMessageNeededChars: Cardinal; pErrorMessageBuffer: PAnsiChar; out pHasError: Byte): TOptClassResult; cdecl;
  
  (**
  * Handles Library Journaling
  *
  * @param[in] pFileName - Journal FileName
  * @return error code or 0 (success)
  *)
  TOptClassSetJournalFunc = function(const pFileName: PAnsiChar): TOptClassResult; cdecl;
  
  (**
  * Creates an instance of Base class with a given identifier (but does not return it)
  *
  * @param[in] pIdentifier - Identifier of the new instance
  * @return error code or 0 (success)
  *)
  TOptClassCreateInstanceWithNameFunc = function(const pIdentifier: PAnsiChar): TOptClassResult; cdecl;
  
  (**
  * Finds a Base class instance by Identifier
  *
  * @param[in] pIdentifier - Identifier of the tnstance to query
  * @param[out] pInstance - Base class instance
  * @return error code or 0 (success)
  *)
  TOptClassFindInstanceAFunc = function(const pIdentifier: PAnsiChar; out pInstance: TOptClassHandle): TOptClassResult; cdecl;
  
  (**
  * Finds a Base class instance by Identifier
  *
  * @param[in] pIdentifier - Identifier of the tnstance to query
  * @param[out] pInstance - Base class instance
  * @return error code or 0 (success)
  *)
  TOptClassFindInstanceBFunc = function(const pIdentifier: PAnsiChar; out pInstance: TOptClassHandle): TOptClassResult; cdecl;
  
  (**
  * Uses a Base class instance
  *
  * @param[in] pInstance - Base class instance
  * @param[out] pIsUsed - Was the Instance used?
  * @return error code or 0 (success)
  *)
  TOptClassUseInstanceMaybeFunc = function(const pInstance: TOptClassHandle; out pIsUsed: Byte): TOptClassResult; cdecl;
  

(*************************************************************************************************************************
 Helper function pointer definitions 
**************************************************************************************************************************)
TOptClassSymbolLookupMethod = function(const pSymbolName: PAnsiChar; out pValue: Pointer): TOptClassResult; cdecl;

(*************************************************************************************************************************
 Exception definition
**************************************************************************************************************************)

  EOptClassException = class(Exception)
  private
    FErrorCode: TOptClassResult;
    FCustomMessage: String;
  public
    property ErrorCode: TOptClassResult read FErrorCode;
    property CustomMessage: String read FCustomMessage;
    constructor Create(AErrorCode: TOptClassResult; AMessage: String);
    constructor CreateCustomMessage(AErrorCode: TOptClassResult; AMessage: String);
  end;


(*************************************************************************************************************************
 Class definition for Base
**************************************************************************************************************************)

 TOptClassBase = class(TObject)
  private
    FWrapper: TOptClassWrapper;
    FHandle: TOptClassHandle;
  public
    constructor Create(AWrapper: TOptClassWrapper; AHandle: TOptClassHandle);
    destructor Destroy; override;
    property TheHandle: TOptClassHandle read FHandle;
  end;

(*************************************************************************************************************************
 Wrapper definition
**************************************************************************************************************************)

  TOptClassWrapper = class(TObject)
  private
    FModule: HMODULE;
    FOptClassAcquireInstanceFunc: TOptClassAcquireInstanceFunc;
    FOptClassReleaseInstanceFunc: TOptClassReleaseInstanceFunc;
    FOptClassGetVersionFunc: TOptClassGetVersionFunc;
    FOptClassGetLastErrorFunc: TOptClassGetLastErrorFunc;
    FOptClassSetJournalFunc: TOptClassSetJournalFunc;
    FOptClassCreateInstanceWithNameFunc: TOptClassCreateInstanceWithNameFunc;
    FOptClassFindInstanceAFunc: TOptClassFindInstanceAFunc;
    FOptClassFindInstanceBFunc: TOptClassFindInstanceBFunc;
    FOptClassUseInstanceMaybeFunc: TOptClassUseInstanceMaybeFunc;

    {$IFDEF MSWINDOWS}
    function LoadFunction(AFunctionName: AnsiString; FailIfNotExistent: Boolean = True): FARPROC;
    {$ELSE}
    function LoadFunction(AFunctionName: AnsiString; FailIfNotExistent: Boolean = True): Pointer;
    {$ENDIF MSWINDOWS}

    procedure checkBinaryVersion();

  protected
    property OptClassAcquireInstanceFunc: TOptClassAcquireInstanceFunc read FOptClassAcquireInstanceFunc;
    property OptClassReleaseInstanceFunc: TOptClassReleaseInstanceFunc read FOptClassReleaseInstanceFunc;
    property OptClassGetVersionFunc: TOptClassGetVersionFunc read FOptClassGetVersionFunc;
    property OptClassGetLastErrorFunc: TOptClassGetLastErrorFunc read FOptClassGetLastErrorFunc;
    property OptClassSetJournalFunc: TOptClassSetJournalFunc read FOptClassSetJournalFunc;
    property OptClassCreateInstanceWithNameFunc: TOptClassCreateInstanceWithNameFunc read FOptClassCreateInstanceWithNameFunc;
    property OptClassFindInstanceAFunc: TOptClassFindInstanceAFunc read FOptClassFindInstanceAFunc;
    property OptClassFindInstanceBFunc: TOptClassFindInstanceBFunc read FOptClassFindInstanceBFunc;
    property OptClassUseInstanceMaybeFunc: TOptClassUseInstanceMaybeFunc read FOptClassUseInstanceMaybeFunc;
    procedure CheckError(AInstance: TOptClassBase; AErrorCode: TOptClassResult);
  public
    constructor Create(ADLLName: String);
    constructor CreateFromSymbolLookupMethod(ALookupMethod: TOptClassSymbolLookupMethod);
    destructor Destroy; override;
    procedure AcquireInstance(const AInstance: TOptClassBase);
    procedure ReleaseInstance(const AInstance: TOptClassBase);
    procedure GetVersion(out AMajor: Cardinal; out AMinor: Cardinal; out AMicro: Cardinal);
    function GetLastError(const AInstance: TOptClassBase; out AErrorMessage: String): Boolean;
    procedure SetJournal(const AFileName: String);
    procedure CreateInstanceWithName(const AIdentifier: String);
    function FindInstanceA(const AIdentifier: String): TOptClassBase;
    procedure FindInstanceB(const AIdentifier: String; out AInstance: TOptClassBase);
    function UseInstanceMaybe(const AInstance: TOptClassBase): Boolean;
  end;


implementation


(*************************************************************************************************************************
 Exception implementation
**************************************************************************************************************************)

  constructor EOptClassException.Create(AErrorCode: TOptClassResult; AMessage: String);
  var
    ADescription: String;
  begin
    FErrorCode := AErrorCode;
    case FErrorCode of
      OPTCLASS_ERROR_NOTIMPLEMENTED: ADescription := 'functionality not implemented';
      OPTCLASS_ERROR_INVALIDPARAM: ADescription := 'an invalid parameter was passed';
      OPTCLASS_ERROR_INVALIDCAST: ADescription := 'a type cast failed';
      OPTCLASS_ERROR_BUFFERTOOSMALL: ADescription := 'a provided buffer is too small';
      OPTCLASS_ERROR_GENERICEXCEPTION: ADescription := 'a generic exception occurred';
      OPTCLASS_ERROR_COULDNOTLOADLIBRARY: ADescription := 'the library could not be loaded';
      OPTCLASS_ERROR_COULDNOTFINDLIBRARYEXPORT: ADescription := 'a required exported symbol could not be found in the library';
      OPTCLASS_ERROR_INCOMPATIBLEBINARYVERSION: ADescription := 'the version of the binary interface does not match the bindings interface';
      else
        ADescription := 'unknown';
    end;

    inherited Create(Format('Optional Class Library Error - %s (#%d, %s)', [ ADescription, AErrorCode, AMessage ]));
  end;

  constructor EOptClassException.CreateCustomMessage(AErrorCode: TOptClassResult; AMessage: String);
  begin
    FCustomMessage := AMessage;
    FErrorCode := AErrorCode;
    inherited Create(Format('%s (%d)', [FCustomMessage, AErrorCode]));
  end;

(*************************************************************************************************************************
 Class implementation for Base
**************************************************************************************************************************)

  constructor TOptClassBase.Create(AWrapper: TOptClassWrapper; AHandle: TOptClassHandle);
  begin
    if not Assigned(AWrapper) then
      raise EOptClassException.Create(OPTCLASS_ERROR_INVALIDPARAM, '');
    if not Assigned(AHandle) then
      raise EOptClassException.Create(OPTCLASS_ERROR_INVALIDPARAM, '');

    inherited Create();
    FWrapper := AWrapper;
    FHandle := AHandle;
  end;

  destructor TOptClassBase.Destroy;
  begin
    FWrapper.ReleaseInstance(self);
    inherited;
  end;

(*************************************************************************************************************************
 Wrapper class implementation
**************************************************************************************************************************)

  constructor TOptClassWrapper.Create(ADLLName: String);
  {$IFDEF MSWINDOWS}
  var
    AWideString: WideString;
  {$ENDIF MSWINDOWS}
  begin
    inherited Create;
    
    
    {$IFDEF MSWINDOWS}
      AWideString := UTF8Decode(ADLLName + #0);
      FModule := LoadLibraryW(PWideChar(AWideString));
    {$ELSE}
      FModule := dynlibs.LoadLibrary(ADLLName);
    {$ENDIF MSWINDOWS}
    if FModule = 0 then
      raise EOptClassException.Create(OPTCLASS_ERROR_COULDNOTLOADLIBRARY, '');

    FOptClassAcquireInstanceFunc := LoadFunction('optclass_acquireinstance');
    FOptClassReleaseInstanceFunc := LoadFunction('optclass_releaseinstance');
    FOptClassGetVersionFunc := LoadFunction('optclass_getversion');
    FOptClassGetLastErrorFunc := LoadFunction('optclass_getlasterror');
    FOptClassSetJournalFunc := LoadFunction('optclass_setjournal');
    FOptClassCreateInstanceWithNameFunc := LoadFunction('optclass_createinstancewithname');
    FOptClassFindInstanceAFunc := LoadFunction('optclass_findinstancea');
    FOptClassFindInstanceBFunc := LoadFunction('optclass_findinstanceb');
    FOptClassUseInstanceMaybeFunc := LoadFunction('optclass_useinstancemaybe');
    
    checkBinaryVersion();
  end;

  constructor TOptClassWrapper.CreateFromSymbolLookupMethod(ALookupMethod: TOptClassSymbolLookupMethod);
  var
    AResult : TOptClassResult;
  begin
    inherited Create;
    
    
    AResult := ALookupMethod(PAnsiChar('optclass_acquireinstance'), @FOptClassAcquireInstanceFunc);
    if AResult <> OPTCLASS_SUCCESS then
      raise EOptClassException.CreateCustomMessage(OPTCLASS_ERROR_COULDNOTLOADLIBRARY, '');
    AResult := ALookupMethod(PAnsiChar('optclass_releaseinstance'), @FOptClassReleaseInstanceFunc);
    if AResult <> OPTCLASS_SUCCESS then
      raise EOptClassException.CreateCustomMessage(OPTCLASS_ERROR_COULDNOTLOADLIBRARY, '');
    AResult := ALookupMethod(PAnsiChar('optclass_getversion'), @FOptClassGetVersionFunc);
    if AResult <> OPTCLASS_SUCCESS then
      raise EOptClassException.CreateCustomMessage(OPTCLASS_ERROR_COULDNOTLOADLIBRARY, '');
    AResult := ALookupMethod(PAnsiChar('optclass_getlasterror'), @FOptClassGetLastErrorFunc);
    if AResult <> OPTCLASS_SUCCESS then
      raise EOptClassException.CreateCustomMessage(OPTCLASS_ERROR_COULDNOTLOADLIBRARY, '');
    AResult := ALookupMethod(PAnsiChar('optclass_setjournal'), @FOptClassSetJournalFunc);
    if AResult <> OPTCLASS_SUCCESS then
      raise EOptClassException.CreateCustomMessage(OPTCLASS_ERROR_COULDNOTLOADLIBRARY, '');
    AResult := ALookupMethod(PAnsiChar('optclass_createinstancewithname'), @FOptClassCreateInstanceWithNameFunc);
    if AResult <> OPTCLASS_SUCCESS then
      raise EOptClassException.CreateCustomMessage(OPTCLASS_ERROR_COULDNOTLOADLIBRARY, '');
    AResult := ALookupMethod(PAnsiChar('optclass_findinstancea'), @FOptClassFindInstanceAFunc);
    if AResult <> OPTCLASS_SUCCESS then
      raise EOptClassException.CreateCustomMessage(OPTCLASS_ERROR_COULDNOTLOADLIBRARY, '');
    AResult := ALookupMethod(PAnsiChar('optclass_findinstanceb'), @FOptClassFindInstanceBFunc);
    if AResult <> OPTCLASS_SUCCESS then
      raise EOptClassException.CreateCustomMessage(OPTCLASS_ERROR_COULDNOTLOADLIBRARY, '');
    AResult := ALookupMethod(PAnsiChar('optclass_useinstancemaybe'), @FOptClassUseInstanceMaybeFunc);
    if AResult <> OPTCLASS_SUCCESS then
      raise EOptClassException.CreateCustomMessage(OPTCLASS_ERROR_COULDNOTLOADLIBRARY, '');
    
    checkBinaryVersion();
  end;

  destructor TOptClassWrapper.Destroy;
  begin
    {$IFDEF MSWINDOWS}
      if FModule <> 0 then
        FreeLibrary(FModule);
    {$ELSE}
      if FModule <> 0 then
        UnloadLibrary(FModule);
    {$ENDIF MSWINDOWS}
    inherited;
  end;

  procedure TOptClassWrapper.CheckError(AInstance: TOptClassBase; AErrorCode: TOptClassResult);
  var
    AErrorMessage: String;
  begin
    if AInstance <> nil then begin
      if AInstance.FWrapper <> Self then
        raise EOptClassException.CreateCustomMessage(OPTCLASS_ERROR_INVALIDCAST, 'invalid wrapper call');
    end;
    if AErrorCode <> OPTCLASS_SUCCESS then begin
      AErrorMessage := '';
      if Assigned(AInstance) then
        GetLastError(AInstance, AErrorMessage);
      raise EOptClassException.Create(AErrorCode, AErrorMessage);
    end;
  end;

  {$IFDEF MSWINDOWS}
  function TOptClassWrapper.LoadFunction(AFunctionName: AnsiString; FailIfNotExistent: Boolean): FARPROC;
  begin
    Result := GetProcAddress(FModule, PAnsiChar(AFunctionName));
    if FailIfNotExistent and not Assigned(Result) then
      raise EOptClassException.CreateCustomMessage(OPTCLASS_ERROR_COULDNOTFINDLIBRARYEXPORT, 'could not find function ' + AFunctionName);
  end;
  {$ELSE}
  function TOptClassWrapper.LoadFunction(AFunctionName: AnsiString; FailIfNotExistent: Boolean): Pointer;
  begin
    Result := dynlibs.GetProcAddress(FModule, AFunctionName);
    if FailIfNotExistent and not Assigned(Result) then
      raise EOptClassException.CreateCustomMessage(OPTCLASS_ERROR_COULDNOTFINDLIBRARYEXPORT, 'could not find function ' + AFunctionName);
  end;
  {$ENDIF MSWINDOWS}

  procedure TOptClassWrapper.checkBinaryVersion();
  var
    AMajor, AMinor, AMicro: Cardinal;
  begin
    GetVersion(AMajor, AMinor, AMicro);
    if (AMajor <> OPTCLASS_VERSION_MAJOR) then
      raise EOptClassException.Create(OPTCLASS_ERROR_INCOMPATIBLEBINARYVERSION, '');
  end;
  
  procedure TOptClassWrapper.AcquireInstance(const AInstance: TOptClassBase);
  var
    AInstanceHandle: TOptClassHandle;
  begin
    if Assigned(AInstance) then
    AInstanceHandle := AInstance.TheHandle
    else
      raise EOptClassException.CreateCustomMessage(OPTCLASS_ERROR_INVALIDPARAM, 'AInstance is a nil value.');
    CheckError(nil, OptClassAcquireInstanceFunc(AInstanceHandle));
  end;

  procedure TOptClassWrapper.ReleaseInstance(const AInstance: TOptClassBase);
  var
    AInstanceHandle: TOptClassHandle;
  begin
    if Assigned(AInstance) then
    AInstanceHandle := AInstance.TheHandle
    else
      raise EOptClassException.CreateCustomMessage(OPTCLASS_ERROR_INVALIDPARAM, 'AInstance is a nil value.');
    CheckError(nil, OptClassReleaseInstanceFunc(AInstanceHandle));
  end;

  procedure TOptClassWrapper.GetVersion(out AMajor: Cardinal; out AMinor: Cardinal; out AMicro: Cardinal);
  begin
    CheckError(nil, OptClassGetVersionFunc(AMajor, AMinor, AMicro));
  end;

  function TOptClassWrapper.GetLastError(const AInstance: TOptClassBase; out AErrorMessage: String): Boolean;
  var
    AInstanceHandle: TOptClassHandle;
    bytesNeededErrorMessage: Cardinal;
    bytesWrittenErrorMessage: Cardinal;
    bufferErrorMessage: array of Char;
    ResultHasError: Byte;
  begin
    if Assigned(AInstance) then
    AInstanceHandle := AInstance.TheHandle
    else
      raise EOptClassException.CreateCustomMessage(OPTCLASS_ERROR_INVALIDPARAM, 'AInstance is a nil value.');
    bytesNeededErrorMessage:= 0;
    bytesWrittenErrorMessage:= 0;
    ResultHasError := 0;
    CheckError(nil, OptClassGetLastErrorFunc(AInstanceHandle, 0, bytesNeededErrorMessage, nil, ResultHasError));
    SetLength(bufferErrorMessage, bytesNeededErrorMessage);
    CheckError(nil, OptClassGetLastErrorFunc(AInstanceHandle, bytesNeededErrorMessage, bytesWrittenErrorMessage, @bufferErrorMessage[0], ResultHasError));
    AErrorMessage := StrPas(@bufferErrorMessage[0]);
    Result := (ResultHasError <> 0);
  end;

  procedure TOptClassWrapper.SetJournal(const AFileName: String);
  begin
    CheckError(nil, OptClassSetJournalFunc(PAnsiChar(AFileName)));
  end;

  procedure TOptClassWrapper.CreateInstanceWithName(const AIdentifier: String);
  begin
    CheckError(nil, OptClassCreateInstanceWithNameFunc(PAnsiChar(AIdentifier)));
  end;

  function TOptClassWrapper.FindInstanceA(const AIdentifier: String): TOptClassBase;
  var
    HInstance: TOptClassHandle;
  begin
    Result := nil;
    HInstance := nil;
    CheckError(nil, OptClassFindInstanceAFunc(PAnsiChar(AIdentifier), HInstance));
    if Assigned(HInstance) then
      Result := TOptClassBase.Create(Self, HInstance);
  end;

  procedure TOptClassWrapper.FindInstanceB(const AIdentifier: String; out AInstance: TOptClassBase);
  var
    HInstance: TOptClassHandle;
  begin
    AInstance := nil;
    HInstance := nil;
    CheckError(nil, OptClassFindInstanceBFunc(PAnsiChar(AIdentifier), HInstance));
    if Assigned(HInstance) then
      AInstance := TOptClassBase.Create(Self, HInstance);
  end;

  function TOptClassWrapper.UseInstanceMaybe(const AInstance: TOptClassBase): Boolean;
  var
    AInstanceHandle: TOptClassHandle;
    ResultIsUsed: Byte;
  begin
    if Assigned(AInstance) then
    AInstanceHandle := AInstance.TheHandle
    else
    AInstanceHandle := nil;
    ResultIsUsed := 0;
    CheckError(nil, OptClassUseInstanceMaybeFunc(AInstanceHandle, ResultIsUsed));
    Result := (ResultIsUsed <> 0);
  end;


end.
