/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.database;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;

public enum MappingReplaceMechanism {
    ABSENT(0, DTMessages.pref_data_transfer_replacing_combo_do_not),
    UNDERSCORES(1, DTMessages.pref_data_transfer_replacing_combo_underscores),
    CAMELCASE(2, DTMessages.pref_data_transfer_replacing_combo_camel_case);

    private final int selectionId;
    private final String name;

    private MappingReplaceMechanism(int selectionId, String name) {
        this.selectionId = selectionId;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @NotNull
    public static MappingReplaceMechanism getCaseBySelectionId(int id) {
        MappingReplaceMechanism[] mappingReplaceMechanismArray = MappingReplaceMechanism.values();
        int n = mappingReplaceMechanismArray.length;
        int n2 = 0;
        while (n2 < n) {
            MappingReplaceMechanism value = mappingReplaceMechanismArray[n2];
            if (id == value.selectionId) {
                return value;
            }
            ++n2;
        }
        return ABSENT;
    }

    @NotNull
    public static MappingReplaceMechanism getCaseFromPreferences(@NotNull DBPPreferenceStore dbpPreferenceStore, @NotNull DBPPreferenceStore store) {
        int selectionIndex = dbpPreferenceStore.contains("replaceMapping") ? dbpPreferenceStore.getInt("replaceMapping") : store.getInt("replaceMapping");
        return MappingReplaceMechanism.getCaseBySelectionId(selectionIndex);
    }
}

