/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.contexts;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.e4.core.internal.contexts.Computation;

public class WeakGroupedListenerList {
    private final Map<String, Set<Computation>> listeners = new HashMap<String, Set<Computation>>();

    public synchronized void add(String groupName, Computation computation) {
        Objects.requireNonNull(computation);
        this.listeners.computeIfAbsent(groupName, k -> Collections.newSetFromMap(new WeakHashMap())).add(computation);
    }

    public synchronized void remove(Computation computation) {
        Collection<Set<Computation>> allListeners = this.listeners.values();
        for (Set<Computation> group : allListeners) {
            group.remove(computation);
        }
    }

    public synchronized Set<String> getNames() {
        Set<String> groupNames = this.listeners.keySet();
        HashSet<String> usedNames = new HashSet<String>(groupNames.size());
        usedNames.addAll(groupNames);
        return usedNames;
    }

    public synchronized void clear() {
        this.listeners.clear();
    }

    public synchronized Set<Computation> getListeners() {
        Collection<Set<Computation>> groups = this.listeners.values();
        HashSet<Computation> result = new HashSet<Computation>();
        for (Set<Computation> computations : groups) {
            for (Computation computation : computations) {
                if (!computation.isValid()) continue;
                result.add(computation);
            }
        }
        return result;
    }

    public synchronized Set<Computation> getListeners(String groupName) {
        Set<Computation> computations = this.listeners.get(groupName);
        if (computations == null) {
            return null;
        }
        HashSet<Computation> result = new HashSet<Computation>(computations.size());
        for (Computation computation : computations) {
            if (!computation.isValid()) continue;
            result.add(computation);
        }
        return result;
    }

    public synchronized void cleanup() {
        Set<Map.Entry<String, Set<Computation>>> entries = this.listeners.entrySet();
        entries.removeIf(entry -> {
            Set computations = (Set)entry.getValue();
            computations.removeIf(computation -> !computation.isValid());
            return computations.isEmpty();
        });
    }
}

