#ifndef __EPS_H_
 #define __EPS_H_

typedef struct __eps_ {
  int interface,           /* Interface used to initialize EPS   */
      content_type,        /* Content-type of message            */
	  result;			   /* Result							 */

  char *h_content_type,    /* String version of the content type */
       *source;            /* Source string from email           */

  struct __unfold_ *u;     /* Unfolding structure                */
  struct __header_ *h;     /* Temporary header parser structure  */
  struct __boundary_ *b;   /* Message boundary linked list       */
  struct __mime_ *m;       /* Temporary MIME handler structure   */
} eps_t;

#include "line.h"
#include "buffer.h"
#include "unfold.h"
#include "rfc2822.h"
#include "content.h"
#include "interface.h"
#include "int_stream.h"
#include "misc.h"
#include "header.h"
#include "email.h"
#include "boundary.h"
#include "mime.h"
#include "address.h"
#include "base64.h"
#include "fold.h"
#include "int_buffer.h"
#include "qp.h"
#include "date.h"

eps_t *eps_begin(const int, const void *);
void eps_restart(eps_t *, const void *);
void eps_end(eps_t *);
header_t *eps_next_header(eps_t *);
unsigned char *eps_next_line(eps_t *);
void eps_header_free(eps_t *);
void eps_end(eps_t *);
int eps_is_eof(const eps_t *);
int eps_source(eps_t *, const unsigned char *);
int eps_sink(eps_t *, const unsigned char *);

#endif
