-- Copyright 2023 Stanford University
--
-- Licensed under the Apache License, Version 2.0 (the "License");
-- you may not use this file except in compliance with the License.
-- You may obtain a copy of the License at
--
--     http://www.apache.org/licenses/LICENSE-2.0
--
-- Unless required by applicable law or agreed to in writing, software
-- distributed under the License is distributed on an "AS IS" BASIS,
-- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
-- See the License for the specific language governing permissions and
-- limitations under the License.

-- fails-with:
-- privilege_undefined2.rg:25: requested reads($x) but $x is not a parameter
-- task f(y : region(int))
--    ^

import "regent"

local x = regentlib.newsymbol(region(int), "x")
local reads_x = regentlib.privilege(regentlib.reads, x)

task f(y : region(int))
where [reads_x] do
end
f:compile()
