#!/bin/ksh
# tarZ.sh
# $Id: tarZ.sh,v 1.1 1999/10/16 21:27:58 gwiley Exp $
# Glen Wiley, gwiley@ieee.org
#
#  tests use of uncompress and tar for pdv utilities
#
# TODO: negative tests - bogus arguments etc.

#-------------------- TEST: simple file package using uncompress

print "BEGIN TEST:"
print "TARGET: pdv stub, pdvmkpkg"
print "GOAL:   test compress filter"
print "EXPECT: exit status 0, matching diag. message, matching checksums"

cat > pkgdata.tmp <<-EOF
This is sample package data for use in the tarZ tests for the
pdv utilities.
This file should get uncompressed automatically.
EOF

set -- `cksum pkgdata.tmp`
goodcksum="$1"

compress pkgdata.tmp
../pdvmkpkg -C -o pkgdata.tmp -c pkg.tmp pkgdata.tmp.Z
print "exit status = $?"
rm -f pkgdata.tmp.Z pkgdata.tmp

./pkg.tmp
print "exit status = $?"

set -- `cksum pkgdata.tmp`
if [ "$goodcksum" != "$1" ]
then
	print "CHECKSUM DIFFERS BETWEEN PACKAGE DATA BEFORE AND AFTER DELIVERY"
else
	print "checksums match"
fi

rm -f pkgdata.tmp pkg.tmp pkgdata.tmp.Z

print "END TEST"

#-------------------- TEST: simple file package using tar

print "BEGIN TEST:"
print "TARGET: pdv stub, pdvmkpkg"
print "GOAL:   test tar filter"
print "EXPECT: exit status 0, matching diag. message, matching dir trees"

mkdir -p tarZdir.tmp/subdir0 tarZdir.tmp/subdir1

cat > tarZdir.tmp/datafile <<-EOF
This is sample package data for use in the tarZ tests for the
pdv utilities.
EOF
cp tarZdir.tmp/datafile tarZdir.tmp/subdir0/datafile 
cp tarZdir.tmp/datafile tarZdir.tmp/subdir1/datafile 
tar -cf tarZ.tar.tmp tarZdir.tmp
find tarZdir.tmp -depth
../pdvmkpkg -T -c pkg.tmp tarZ.tar.tmp
print "exit status = $?"
rm -Rf tarZdir.tmp
./pkg.tmp
print "exit status = $?"
find tarZdir.tmp -depth

rm -Rf tarZdir.tmp pkg.tmp tarZ.tar.tmp

print "END TEST"

#-------------------- TEST: package using tar and compress

print "BEGIN TEST:"
print "TARGET: pdv stub, pdvmkpkg"
print "GOAL:   test tar and compress filter together"
print "EXPECT: exit status 0, matching diag. message, matching dir trees"

mkdir -p tarZdir.tmp/subdir0 tarZdir.tmp/subdir1

cat > tarZdir.tmp/datafile <<-EOF
This is sample package data for use in the tarZ tests for the
pdv utilities.
EOF
cp tarZdir.tmp/datafile tarZdir.tmp/subdir0/datafile 
cp tarZdir.tmp/datafile tarZdir.tmp/subdir1/datafile 
tar -cf tarZ.tar.tmp tarZdir.tmp
compress tarZ.tar.tmp
find tarZdir.tmp -depth
../pdvmkpkg -C -T -c pkg.tmp tarZ.tar.tmp.Z
print "exit status = $?"
rm -Rf tarZdir.tmp tarZ.tar.tmp.Z
./pkg.tmp
print "exit status = $?"
find tarZdir.tmp -depth

rm -Rf tarZdir.tmp pkg.tmp tarZ.tar.tmp

print "END TEST"

return 0
# tarZ.sh
