/*
 * libxml2_globals.c: definition and handling of the set of global variables
 *                    of the library
 *
 * The bottom of this file is automatically generated by build_glob.py
 * based on the description file global.data
 *
 * See Copyright for the status of this software.
 *
 * Gary Pennington <Gary.Pennington@uk.sun.com>
 * daniel@veillard.com
 * Portion Copyright  2009 Nokia Corporation and/or its subsidiary(-ies). All rights reserved. 
 */
#define IN_LIBXML
#define UNDEF_IMPORT_C_IN_DATA

#include <assert.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <stdarg.h>

#include "xmlenglibxml.h"

#include <libxml2_globals.h>
#include "libxml2_xmlschemastypes.h"




const xeGlobalConstData xeGlobalConsts =
    {
    LIBXML_VERSION_STRING // xmlParserVersion field
    };

const xeGlobalConstData* xeGetGlobalConsts()
{
    return &xeGlobalConsts;
}

/**
 * xmlParserVersion:
 *
 * Constant string describing the internal version of the library
 */
XMLPUBFUNEXPORT const char* const xmlParserVersion = LIBXML_VERSION_STRING;


/*
This function creates and initializes new xmlGlobalState structure
and stores pointer to it into Thread-Local Storage of this DLL.

If TLS is not NULL, then nothing happens and pointer to existing global data is returned

This function is used once prior any use of libxml2 code!
It called from XmlEngine::XmlEngineAttachL() function
and must be called by any other client of libxml2's API if XmlEngineAttachL()
is not used.
*/
XMLPUBFUNEXPORT xmlGlobalStatePtr xmlCreateAndInitializeGlobalState()
{
    xmlGlobalStatePtr gs = xeGetTLS();
    if(gs)
        return gs; // already initialized;

    gs = (xmlGlobalStatePtr) malloc(sizeof(xmlGlobalState));
    if(gs)
    {
        memset(gs, 0, sizeof(xmlGlobalState));
        xeSetTLS(gs);
        xmlInitializeGlobalState(gs);
    }
    return gs;
}

/*
Performs complete cleanup of the resource allocated for Libxml2.
Global state data is destroyed.

On Symbian:
  Thread-Local Storage is set to NULL after the cleanup finished.

 @note XmlEngine::XmlEngineCleanup(TAny*) calls this function
       as part of XML Engine shutdown sequence; but it also adds
       counter for multi-user (within one thread) processing support.

 @note This function should not be directly used by Symbian applications;
       the only exception for this rule is usage of libxml2 by other
       open-source libraries [XmlEngine::XmlEngineCleanup(TAny*) is preferred]
*/
XMLPUBFUNEXPORT void xmlCleanupGlobalData()
{
    DEFINE_GS_PROXY /* NOTE: Initialize GS proxy initialize before using any GS member */
    xmlGlobalStatePtr gs = xeGetTLS();

    if(!gs)
        return;
    SET_GS_PROXY(gs);

    xmlSchemaCleanupTypes();
    xmlResetLastError();
    xmlCleanupCharEncodingHandlers();
    xmlCleanupParser();
    xeXPathCleanup();
    xeCleanupDOMStringConverter();
#ifdef XMLENGINE_XSLT
    if(xsltGlobalsCleanupFunc)
        ((void(*)())xsltGlobalsCleanupFunc)();
#endif
    free(gs); //using xmlFree(gs) is not right:  GS was not initialized with xmlMalloc() !
    xeSetTLS(NULL);
}





XMLPUBFUNEXPORT int xmlOOMFlag()
    {
    LOAD_GS_DIRECT
#ifdef _DEBUG
    int f = OOM_FLAG;
    if(f)
        {
        f |= 0; // SET BREAKPOINT HERE
        }
    return f;
#else
    return OOM_FLAG;
#endif
    }

void XMLCALL xeCheckErrno()
    {
    int err = errno;
    if (err == ENOMEM)
        {
        SET_OOM_FLAG;
        }
#ifdef _DEBUG
    else if (err)
        {
        // some other error!!!
        err ^=err;
        }
#endif
    }

XMLPUBFUNEXPORT void xmlSetOOM()
    {
    DEFINE_GS_PROXY //note: ensure GS proxy initialize before any GS member access
    xmlGlobalStatePtr gs = xeGetTLS();
    SET_GS_PROXY(gs)
    // Should be sure that globals state (contains the OOM flag) is initialized
    if(gs)
        {
        OOM_FLAG = 1;
        }
    }

XMLPUBFUNEXPORT void xmlResetOOM()
    {
    DEFINE_GS_PROXY //note: ensure GS proxy initialize before any GS member access
    xmlGlobalStatePtr gs = xeGetTLS();
    SET_GS_PROXY(gs)
    // We need this in case OOM happened during initialization of the 'global state'
    if (!gs)
        return;
    OOM_FLAG = 0;
    }


#define __lookup_ALLOC_ADDRES_  0

#ifdef XMLENGINE_MEM_DEBUG
void __catchAllocatedAddress()
    {
    // Set breakpoint here
    }
void __catchFreedAddress()
    {
    // Set breakpoint here
    }
#endif

#ifdef XMLENGINE_MEM_DEBUG
//#define XMLENGINE_MEM_DEBUG_SIZE
#endif

/*
 NOTE: XMLENGINE_MEM_DEBUG option is defined only in debug builds
*/
XMLPUBFUNEXPORT void* XMLCALL malloc_impl(size_t size)
{
#ifdef XMLENGINE_MEM_DEBUG
    LOAD_GS_DIRECT
#endif
#ifndef XMLENGINE_MEM_DEBUG_SIZE
    void* mem = malloc(size);

#ifdef XMLENGINE_MEM_DEBUG
    if((int)mem == __lookup_ALLOC_ADDRES_) {
        __catchAllocatedAddress();
    }
#endif
#else
    // when defined XMLENGINE_MEM_DEBUG_SIZE
    //
    // the previous 4 bytes before returned pointer is the size of a block
    void *hdr;
    void *mem;

    hdr = malloc(size + sizeof(size_t));
    if(hdr)
    {
        mem = ((char*)hdr) + sizeof(size_t);
        *((size_t*)hdr) = size;
    }
    else
        mem = NULL;

    if((int)hdr == __lookup_ALLOC_ADDRES_) {
        __catchAllocatedAddress();
    }
#endif

    if(mem)
        {
#ifdef XMLENGINE_MEM_DEBUG
        xmlGlobalStatePtr gs = xeGetTLS();
        if(gs && !xmlOOM) // do not count "after allocations" during error-handling
            {
            gs->allocCount++;
            gs->allocTotal += size;
#ifdef XMLENGINE_MEM_DEBUG_SIZE
            gs->allocMemSize += size;
            if(gs->allocMemSize > gs->allocMemSizeMax)
                gs->allocMemSizeMax = gs->allocMemSize;
#endif
            }
#endif
        return mem;
        }
    else
        {
        SET_OOM_FLAG;
        return NULL; // NULL
        }
}

XMLPUBFUNEXPORT void* XMLCALL realloc_impl(void *ptr, size_t size)
{
#ifdef XMLENGINE_MEM_DEBUG
    LOAD_GS_DIRECT
#endif
#ifndef XMLENGINE_MEM_DEBUG_SIZE
    void* mem = realloc(ptr, size);

#   ifdef XMLENGINE_MEM_DEBUG
    if((int)mem == __lookup_ALLOC_ADDRES_) {
        __catchAllocatedAddress();
    }
#   endif
#else
    // XMLENGINE_MEM_DEBUG_SIZE is defined
    void* hdr;
    void* mem;
    size_t prevSize;

    hdr = (((size_t*)ptr) - 1);
    prevSize = *((size_t*)hdr);

    hdr = realloc(hdr, size + sizeof(size_t));
    if(hdr)
    {
        mem = ((size_t*)hdr) + 1;
        *((size_t*)hdr) = size;
    }
    else
        mem = NULL;

    if((int)hdr == __lookup_ALLOC_ADDRES_) {
        __catchAllocatedAddress();
    }
#endif /* XMLENGINE_MEM_DEBUG_SIZE */

    if(mem)
        {
#ifdef XMLENGINE_MEM_DEBUG
        xmlGlobalStatePtr gs = xeGetTLS();
        if(gs && !xmlOOM) // do not count "after allocations" during error-handling
            {
            gs->reallocCount++;
#ifdef XMLENGINE_MEM_DEBUG_SIZE
            gs->allocMemSize += size - prevSize;
            if(gs->allocMemSize > gs->allocMemSizeMax)
                gs->allocMemSizeMax = gs->allocMemSize;
#endif
            }
#endif
        return mem;
        }
    else
        {
        SET_OOM_FLAG;
        return NULL;
        }
}

//
// NOTE: in release builds  free() is used directly
void free_debug(void* mem)
{
#ifdef XMLENGINE_MEM_DEBUG
    xmlGlobalStatePtr gs;

#ifndef XMLENGINE_MEM_DEBUG_SIZE
    if((int)mem == __lookup_ALLOC_ADDRES_) {
        __catchFreedAddress();
    }

    free(mem);
#else
    void*  hdr;
    size_t size;

    hdr = (((size_t*)mem) - 1);

    if((int)hdr == __lookup_ALLOC_ADDRES_) {
        __catchFreedAddress();
    }
    size = *((size_t*)hdr);
    free(hdr);
#endif /* XMLENGINE_MEM_DEBUG_SIZE */

    gs = xeGetTLS();
    if(gs)
        {
        gs->deallocCount++;
#ifdef XMLENGINE_MEM_DEBUG_SIZE
        gs->allocMemSize -=size;
#endif
        }
#endif /* XMLENGINE_MEM_DEBUG */
}
//

#ifdef XMLENGINE_EXCLUDE_EMBED_MSG
const char* const __embedded_errtxt_replacement = "DISABLED ERROR STRING\n";
#endif

void xeCleanupDOMStringConverter()
{
    DOMStringConverterData* data = &xmlGetGlobalState()->xeStringArgs;
    char** buf;
    int i;
    for(i=0; i<4; i++){
        buf = &data->cleanupItem[i];
        if(*buf){
            xmlFree(*buf);
            *buf = 0;
        }
    }
}

int symbian_vsnprintf(char *str, size_t size, const char *format, va_list ap)
{
    int ret = 0;

    ret = vsprintf(str, format, ap);

    assert((size_t)ret < size);
    return ret;
}

int symbian_snprintf(char *str, size_t size, const char *format, ...)
{
    int ret = 0;
    va_list args;
    va_start(args, format);
    symbian_vsnprintf(str, size, format, args);
    va_end(args);

    assert((size_t)ret < size);

    return ret;
}

#include <libxml2_sax.h>

/**
 * xmlTreeIndentString:
 *
 * The string used to do one-level indent. By default is equal to "  " (two spaces)
 */
XMLPUBFUNEXPORT const char* const xmlTreeIndentString = "  ";
const char* const xmlTreeIndentStringThrDef = "  ";


XMLPUBFUNEXPORT xmlRegisterNodeFunc
xmlRegisterNodeDefault(xmlRegisterNodeFunc func)
{
	LOAD_GS_DIRECT
    xmlRegisterNodeFunc old = xmlRegisterNodeDefaultValue;

    __xmlRegisterCallbacks = 1;
    xmlRegisterNodeDefaultValue = func;
    return(old);
}

XMLPUBFUNEXPORT xmlDeregisterNodeFunc
xmlDeregisterNodeDefault(xmlDeregisterNodeFunc func)
{
	LOAD_GS_DIRECT
    xmlDeregisterNodeFunc old = xmlDeregisterNodeDefaultValue;

    __xmlRegisterCallbacks = 1;
    xmlDeregisterNodeDefaultValue = func;
    return(old);
}


#define xmlBufferAllocSchemeThrDef XML_BUFFER_ALLOC_EXACT
#define xmlDefaultBufferSizeThrDef BASE_BUFFER_SIZE
#define xmlParserDebugEntitiesThrDef 0
#define xmlDoValidityCheckingDefaultValueThrDef 0
#define xmlGetWarningsDefaultValueThrDef 1
#define xmlLoadExtDtdDefaultValueThrDef 0
#define xmlPedanticParserDefaultValueThrDef 0
#define xmlLineNumbersDefaultValueThrDef 0
#define xmlKeepBlanksDefaultValueThrDef 1
#define xmlSubstituteEntitiesDefaultValueThrDef 0
#define xmlRegisterNodeDefaultValueThrDef NULL
#define xmlDeregisterNodeDefaultValueThrDef NULL

void xmlGenericErrorDefaultFunc (void *ctx ATTRIBUTE_UNUSED, const char *msg, ...);

#define xmlGenericErrorThrDef  xmlGenericErrorDefaultFunc
#define xmlStructuredErrorThrDef  NULL
#define xmlGenericErrorContextThrDef NULL
#define xmlIndentTreeOutputThrDef 1
#define xmlTreeIndentStringThrDef "  "
#define xmlSaveNoEmptyTagsThrDef 0

#undef  docbDefaultSAXHandler
#undef  htmlDefaultSAXHandler
#undef  xmlBufferAllocScheme
#undef  xmlDefaultBufferSize
#undef  xmlDefaultSAXHandler
#undef  xmlDefaultSAXLocator
#undef  xmlDoValidityCheckingDefaultValue
#undef  xmlGenericError
#undef  xmlStructuredError
#undef  xmlGenericErrorContext
#undef  xmlGetWarningsDefaultValue
#undef  xmlIndentTreeOutput
//#undef  xmlTreeIndentString
#undef  xmlKeepBlanksDefaultValue
#undef  xmlLineNumbersDefaultValue
#undef  xmlLoadExtDtdDefaultValue
#undef  xmlParserDebugEntities
#undef  xmlPedanticParserDefaultValue
#undef  xmlSaveNoEmptyTags
#undef  xmlSubstituteEntitiesDefaultValue
#undef  xmlRegisterNodeDefaultValue
#undef  xmlDeregisterNodeDefaultValue
#undef  xmlLastError

#undef  xmlFree
#undef  xmlMalloc
#undef  xmlMallocAtomic
#undef  xmlMemStrdup
#undef  xmlRealloc

/* html */
#undef  htmlStartCloseIndex
#undef  htmlStartCloseIndexinitialized

/* tree */
#undef __xmlRegisterCallbacks
#undef xmlCompressMode
#undef xmlCheckDTD

/* xmlmemory */
#undef xmlMemInitialized
#undef debugMemSize
#undef debugMaxMemSize
#undef xmlMemMutex
#undef g_block
#undef xmlMemStopAtBlock
#undef xmlMemTraceBlockAt

/* catalog */
#undef  xmlDebugCatalogs
#undef  xmlCatalogDefaultAllow
#undef  xmlCatalogDefaultPrefer
#undef  xmlCatalogXMLFiles
#undef  xmlDefaultCatalog
#undef  xmlCatalogMutex
#undef  xmlCatalogInitialized

#undef  xmlInputCallbackTable
#undef  xmlInputCallbackNr
#undef  xmlInputCallbackInitialized
#undef  xmlOutputCallbackTable
#undef  xmlOutputCallbackNr
#undef  xmlOutputCallbackInitialized
#undef xmlCurrentExternalEntityLoader

#undef xmlSAX2DefaultVersionValue

#undef xmlParserMaxDepth
#undef xmlW3CPIs
#undef xmlParserInitialized
#undef xeStackLimit
// Now these are global constants
//#undef xmlEntityLt
//#undef xmlEntityGt
//#undef xmlEntityAmp
//#undef xmlEntityQuot
//#undef xmlEntityApos

#undef xmlUTF16LEHandler
#undef xmlUTF16BEHandler
#undef xmlCharEncodingAliases
#undef xmlCharEncodingAliasesNb
#undef xmlCharEncodingAliasesMax
#undef xmlLittleEndian
#undef handlers
#undef nbCharEncodingHandler
#undef xmlDefaultCharEncodingHandler

#undef xmlXPathNAN
#undef xmlXPathPINF
#undef xmlXPathNINF
#undef xmlXPathNZERO
#undef xmlXPathInitialized

#ifndef LIBXML_THREAD_ENABLED
#   undef xmlXPathDisableOptimizer
#endif

#undef xmlXPathDefineExtensionFunctionsGlobally
#undef xmlXPathDefaultFunctionsHash
#undef xmlXPathIntermediaryExtensionFunctionsHash

#undef xlinkDefaultHandler
#undef xlinkDefaultDetect

#undef had_info
#undef xmlInputStreamId

#undef xeUserCount

/* XMLENGINE_XSLT */
#undef g_calibration
//#undef default_token
#undef xsltExtensionsHash
#undef xsltFunctionsHash
#undef xsltElementsHash
#undef xsltGlobalsCleanupFunc
#undef xsltTopLevelsHash
#undef xsltDebuggerCurrentCallbacks

#ifdef LIBXML_SAX1_ENABLED
/**
 * xmlDefaultSAXHandler:
 *
 * Default SAX version1 handler for XML, builds the DOM tree
 */
const xmlSAXHandlerV1 xmlDefaultSAXHandler = {
    xmlSAX2InternalSubset,
    xmlSAX2IsStandalone,
    xmlSAX2HasInternalSubset,
    xmlSAX2HasExternalSubset,
    xmlSAX2ResolveEntity,
    xmlSAX2GetEntity,
    xmlSAX2EntityDecl,
    xmlSAX2NotationDecl,
    xmlSAX2AttributeDecl,
    xmlSAX2ElementDecl,
    xmlSAX2UnparsedEntityDecl,
    xmlSAX2SetDocumentLocator,
    xmlSAX2StartDocument,
    xmlSAX2EndDocument,
    xmlSAX2StartElement,
    xmlSAX2EndElement,
    xmlSAX2Reference,
    xmlSAX2Characters,
    xmlSAX2Characters,
    xmlSAX2ProcessingInstruction,
    xmlSAX2Comment,
    xmlParserWarning,
    xmlParserError,
    xmlParserError,
    xmlSAX2GetParameterEntity,
    xmlSAX2CDataBlock,
    xmlSAX2ExternalSubset,
    0,
};
#endif /* LIBXML_SAX1_ENABLED */

/**
 * xmlDefaultSAXLocator:
 *
 * The default SAX Locator
 * { getPublicId, getSystemId, getLineNumber, getColumnNumber}
 */
const xmlSAXLocator xmlDefaultSAXLocator = {
    xmlSAX2GetPublicId,
    xmlSAX2GetSystemId,
    xmlSAX2GetLineNumber,
    xmlSAX2GetColumnNumber
};

#ifdef LIBXML_HTML_ENABLED
/**
 * htmlDefaultSAXHandler:
 *
 * Default old SAX v1 handler for HTML, builds the DOM tree
 */
const xmlSAXHandlerV1 htmlDefaultSAXHandler = {
    xmlSAX2InternalSubset,
    NULL,
    NULL,
    NULL,
    NULL,
    xmlSAX2GetEntity,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    xmlSAX2SetDocumentLocator,
    xmlSAX2StartDocument,
    xmlSAX2EndDocument,
    xmlSAX2StartElement,
    xmlSAX2EndElement,
    NULL,
    xmlSAX2Characters,
    xmlSAX2IgnorableWhitespace,
    NULL,
    xmlSAX2Comment,
    xmlParserWarning,
    xmlParserError,
    xmlParserError,
    xmlSAX2GetParameterEntity,
    xmlSAX2CDataBlock,
    NULL,
    0,
};
#endif /* LIBXML_HTML_ENABLED */

#ifdef LIBXML_DOCB_ENABLED
/**
 * docbDefaultSAXHandler:
 *
 * Default old SAX v1 handler for SGML DocBook, builds the DOM tree
 */
const xmlSAXHandlerV1 docbDefaultSAXHandler = {
    xmlSAX2InternalSubset,
    xmlSAX2IsStandalone,
    xmlSAX2HasInternalSubset,
    xmlSAX2HasExternalSubset,
    xmlSAX2ResolveEntity,
    xmlSAX2GetEntity,
    xmlSAX2EntityDecl,
    NULL,
    NULL,
    NULL,
    NULL,
    xmlSAX2SetDocumentLocator,
    xmlSAX2StartDocument,
    xmlSAX2EndDocument,
    xmlSAX2StartElement,
    xmlSAX2EndElement,
    xmlSAX2Reference,
    xmlSAX2Characters,
    xmlSAX2IgnorableWhitespace,
    NULL,
    xmlSAX2Comment,
    xmlParserWarning,
    xmlParserError,
    xmlParserError,
    xmlSAX2GetParameterEntity,
    NULL,
    NULL,
    0,
};
#endif /* LIBXML_DOCB_ENABLED */



/**
 * xmlInitializeGlobalState:
 * @param gs a pointer to a newly allocated global state
 *
 * xmlInitializeGlobalState() initialize a global state with all the
 * default values of the library.
 */
XMLPUBFUNEXPORT void
xmlInitializeGlobalState(xmlGlobalStatePtr gs)
{

#ifdef DEBUG_GLOBALS
    fprintf(stderr, "Initializing globals at %lu for thread %d\n",
        (unsigned long) gs, xmlGetThreadId());
#endif

    /*
     * Perform initialization as required by libxml
     */
    if (xmlThrDefMutex == NULL)
        xmlInitGlobals();

    xmlMutexLock(xmlThrDefMutex);

#ifdef LIBXML_DOCB_ENABLED
    xmlSAX2InitDocbDefaultSAXHandler(&gs->docbDefaultSAXHandler);
#endif
#ifdef LIBXML_HTML_ENABLED
    
    //xmlSAX2InitHtmlDefaultSAXHandler(&gs->htmlDefaultSAXHandler);
#endif
// merge: agathe: I had removed this code for libxslt...
//#ifdef LIBXML_DOCB_ENABLED
//    initdocbDefaultSAXHandler(&gs->docbDefaultSAXHandler);
//#endif

//#ifdef LIBXML_HTML_ENABLED
    //inithtmlDefaultSAXHandler(&gs->htmlDefaultSAXHandler);
//#endif

    gs->xmlBufferAllocScheme = xmlBufferAllocSchemeThrDef;
    gs->xmlDefaultBufferSize = xmlDefaultBufferSizeThrDef;
#ifdef LIBXML_SAX1_ENABLED
    initxmlDefaultSAXHandler(&gs->xmlDefaultSAXHandler, 1);
#endif /* LIBXML_SAX1_ENABLED */
    gs->xmlDefaultSAXLocator.getPublicId = xmlSAX2GetPublicId;
    gs->xmlDefaultSAXLocator.getSystemId = xmlSAX2GetSystemId;
    gs->xmlDefaultSAXLocator.getLineNumber = xmlSAX2GetLineNumber;
    gs->xmlDefaultSAXLocator.getColumnNumber = xmlSAX2GetColumnNumber;
    gs->xmlDoValidityCheckingDefaultValue = xmlDoValidityCheckingDefaultValueThrDef;

    gs->xeStackLimit = xeStackLimitAddress();

    gs->xmlGetWarningsDefaultValue = xmlGetWarningsDefaultValueThrDef;
    gs->xmlIndentTreeOutput = xmlIndentTreeOutputThrDef;

    gs->xmlKeepBlanksDefaultValue = xmlKeepBlanksDefaultValueThrDef;
#ifdef LIBXML_ENABLE_NODE_LINEINFO
    gs->xmlLineNumbersDefaultValue = xmlLineNumbersDefaultValueThrDef;
#endif
    gs->xmlLoadExtDtdDefaultValue = xmlLoadExtDtdDefaultValueThrDef;
    gs->xmlParserDebugEntities = xmlParserDebugEntitiesThrDef;
    gs->xmlPedanticParserDefaultValue = xmlPedanticParserDefaultValueThrDef;
    gs->xmlSaveNoEmptyTags = xmlSaveNoEmptyTagsThrDef;
    gs->xmlSubstituteEntitiesDefaultValue = xmlSubstituteEntitiesDefaultValueThrDef;

    gs->xmlGenericError = xmlGenericErrorThrDef;
    gs->xmlStructuredError = xmlStructuredErrorThrDef;
    gs->xmlGenericErrorContext = xmlGenericErrorContextThrDef;
    gs->xmlRegisterNodeDefaultValue = xmlRegisterNodeDefaultValueThrDef;
    gs->xmlDeregisterNodeDefaultValue = xmlDeregisterNodeDefaultValueThrDef;
    memset(&gs->xmlLastError, 0, sizeof(xmlError));

// ==================================================
// XMLENEGINE: NOTE: All zero values are commented,
//  since the whole structure is set to zeros prior
//  initialization
// ==================================================

//  gs->had_info = 0;

//  gs->xmlInputStreamId = 0;

//  gs->xmlUTF16LEHandler = NULL;
//  gs->xmlUTF16BEHandler = NULL;
//  gs->xmlCharEncodingAliases = NULL;
//  gs->xmlCharEncodingAliasesNb = 0;
//  gs->xmlCharEncodingAliasesMax = 0;
    gs->xmlLittleEndian = 1;
//  gs->handlers = NULL;
//  gs->nbCharEncodingHandler = 0;
//  gs->xmlDefaultCharEncodingHandler = NULL;

    gs->xmlParserMaxDepth = 1024;
    gs->xmlW3CPIs[0] = "xml-stylesheet";
    gs->xmlW3CPIs[1] = NULL;
//  gs->xmlParserInitialized = 0;

    gs->xmlSAX2DefaultVersionValue = 2;

//  gs->xmlInputCallbackNr = 0;
//  gs->xmlInputCallbackInitialized = 0;

#ifdef LIBXML_OUTPUT_ENABLED
//  gs->xmlOutputCallbackNr = 0;
//  gs->xmlOutputCallbackInitialized = 0;
#endif /* LIBXML_OUTPUT_ENABLED*/

    gs->xmlCurrentExternalEntityLoader = xmlDefaultExternalEntityLoader;

//  gs->xmlMemInitialized = 0;
//  gs->debugMemSize = 0;
//  gs->debugMaxMemSize = 0;
//  gs->xmlMemMutex = NULL;
//  gs->block = 0;
//  gs->xmlMemStopAtBlock = 0;
//  gs->xmlMemTraceBlockAt = NULL;

//#ifdef LIBXML_TREE_ENABLED
//  gs->__xmlRegisterCallbacks = 0;
//#endif
#ifdef LIBXML_TREE_ENABLED
    
//  gs->xmlCompressMode = 0;
    gs->xmlCheckDTD = 1;
#endif

#ifdef LIBXML_CATALOG_ENABLED
//  gs->xmlDebugCatalogs = 0;
    gs->xmlCatalogDefaultAllow = XML_CATA_ALLOW_ALL;
    gs->xmlCatalogDefaultPrefer = XML_CATA_PREFER_PUBLIC;
//  gs->xmlCatalogXMLFiles = NULL;
//  gs->xmlDefaultCatalog = NULL;
//  xmlCatalogMutex = NULL;
//  gs->xmlCatalogInitialized = 0;
#endif

#ifdef LIBXML_XPATH_ENABLED
//  gs->xmlXPathNAN = 0;
    gs->xmlXPathPINF = 1;
    gs->xmlXPathNINF = -1;
//  gs->xmlXPathNZERO = 0;
//  gs->xmlXPathInitialized = 0;
#ifndef LIBXML_THREAD_ENABLED
//  gs->xmlXPathDisableOptimizer = 0;
#endif
    gs->xmlXPathDefineExtensionFunctionsGlobally = 1;
//  gs->xmlXPathDefaultFunctionsHash = NULL;
//  gs->xmlXPathIntermediaryExtensionFunctionsHash = NULL;
#endif /* LIBXML_XPATH_ENABLED */

#ifdef LIBXML_XPTR_ENABLED
//  gs->xlinkDefaultHandler = NULL;
//  gs->xlinkDefaultDetect = NULL;
#endif

    xmlMutexUnlock(xmlThrDefMutex);

    // gs->xmlOOM = gs->xeUserCount = 0; //
}
