/** VSys:$iptonf.cc:0.0.3-021$ **/
/*
 *  Transfered by VSys script on   11 17:05:08 MSK 2003
 *  Project: ndsad; Project version: 0.0.3-025;
 *  Branch: ;
 *  File: iptonf.cc; File version: 0.0.3-021
 */
/*
 * IP to NFlow conversion. Simple parsing of IP and UDP/TCP headers.
 * Some fields in nf5 are not used.
 */

/*
 * Thanks to TCPDUMP Group for their code - it was very usefull in
 * learning BPF/PCAP usage
 */

#ifdef WIN32
#include "win32/types.h"
#include <winsock2.h>
#else
#include <sys/types.h>
#include <sys/time.h>
#endif
#include <string.h>
#include "nf.h"
#include "nfc.h"
#include "iptonf.h"
#include "nethdr.h"
#include "handlers.h"

#define __OPTIMIZE__
#ifndef WIN32
#include <netinet/in.h>
#include "debug.h"
#endif

nf5* iptonf( u_char * _if, const timeval * ts, const u_char *p ) {
	nf5 _nf, *nf = &_nf;
	u_int16_t proto;
	struct iphdr *ih = (struct iphdr *) (p);
	struct udphdr *uh;
	struct tcphdr *th;
	if_list *_iface = (if_list *) _if;
	nfc * iface = _iface->ifl_nfc;
	if( ih->ih_ver != 4 ) return 0;

//  nf = (nf5 *) calloc( 1, sizeof(nf5) );
	memset( nf, 0, sizeof(nf5) );
	nf->saddr = ih->ih_saddr;
	nf->daddr = ih->ih_daddr;
	proto = ( ih->ih_proto );
	if( proto == IPP_UDP ) {
		uh = (udphdr *) (ih + 1);
//uh = (udphdr *) ((u_char *) ih + ih->ihl);
		nf->sport = uh->uh_sport;
		nf->dport = uh->uh_dport;
	} else if( proto == IPP_TCP ) {
		th = (tcphdr *) (ih + 1);
		//th = (tcphdr *) ((u_char *) ih + sizeof(iphdr) + ih->ihl);
		nf->sport = th->th_sport;
		nf->dport = th->th_dport;
		nf->tcp_flags = th->th_flags;
	}
	nf->proto = proto;
	nf->ts_last = ts->tv_sec;
	nf->tos = ih->ih_tos;
	//                                                                        //      tmp = nf;
	nf->d_oct = ntohs(ih->ih_len);
	nf->d_pkt = 1;
	nf->iface = _iface->ifl_ind;
	nf = iface->apply( nf );
	return nf;
#if 0
	if( nf->tcp_flags & TH_FIN ) {
	print_nf( nf );
	iface->remove( nf );
	}
#endif
}

