/** VSys:$mempool.h:0.0.3$ **/
/*
 *  Transfered by VSys script on   11 17:05:08 MSK 2003
 *  Project: ndsad; Project version: 0.0.3-025;
 *  Branch: ;
 *  File: mempool.h; File version: 0.0.3
 */
#ifndef __NF_ALLOC_H__
#define __NF_ALLOC_H__

#include "nfc.h"
#include "ldefs.h"

#define __DEFAULT_POOL_SIZE 0x4000
#define __TAIL_MARK_LIMIT   0x10000
#define   MPH_DEFAULT       0x0
#define   MPH( x )          (( mempool_hdr * ) (x))

struct mempool_hdr {
	int           mph_type;
	int           mph_size;
	mempool_hdr * mph_next;
};

class mempool {
 public:
	__LOCK_DEF( head );
	__LOCK_DEF( tail );

	mempool_hdr *head;
	mempool_hdr *tail;
	mempool_hdr  hdr;   // Etalon header. ALl headers will be created 
	                    // with this template
	int tail_mark, head_mark, heap_limit;

	              mempool( int hl = __DEFAULT_POOL_SIZE );
	              ~mempool();
	void          init( mempool_hdr * ); // Init template header.
	mempool_hdr * get();
	void          put( mempool_hdr * );
	void          dump();
};

extern mempool * nfpool;

#endif//__NF_ALLOC_H__
