/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.12.0
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/stream.h>



PyDoc_STRVAR(doc_wxStreamBase_GetLastError, "GetLastError() -> StreamError\n"
"\n"
"This function returns the last error.");

extern "C" {static PyObject *meth_wxStreamBase_GetLastError(PyObject *, PyObject *);}
static PyObject *meth_wxStreamBase_GetLastError(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxStreamBase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxStreamBase, &sipCpp))
        {
            ::wxStreamError sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetLastError();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxStreamError);
        }
    }

    sipNoMethod(sipParseErr, sipName_StreamBase, sipName_GetLastError, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxStreamBase_GetLength, "GetLength() -> FileOffset\n"
"\n"
"Returns the length of the stream in bytes.");

extern "C" {static PyObject *meth_wxStreamBase_GetLength(PyObject *, PyObject *);}
static PyObject *meth_wxStreamBase_GetLength(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxStreamBase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxStreamBase, &sipCpp))
        {
            ::wxFileOffset sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetLength();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLongLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_StreamBase, sipName_GetLength, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxStreamBase_GetSize, "GetSize() -> int\n"
"\n"
"This function returns the size of the stream.");

extern "C" {static PyObject *meth_wxStreamBase_GetSize(PyObject *, PyObject *);}
static PyObject *meth_wxStreamBase_GetSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxStreamBase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxStreamBase, &sipCpp))
        {
            size_t sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetSize();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_StreamBase, sipName_GetSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxStreamBase_IsOk, "IsOk() -> bool\n"
"\n"
"Returns true if no error occurred on the stream.");

extern "C" {static PyObject *meth_wxStreamBase_IsOk(PyObject *, PyObject *);}
static PyObject *meth_wxStreamBase_IsOk(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxStreamBase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxStreamBase, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsOk();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_StreamBase, sipName_IsOk, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxStreamBase_IsSeekable, "IsSeekable() -> bool\n"
"\n"
"Returns true if the stream supports seeking to arbitrary offsets.");

extern "C" {static PyObject *meth_wxStreamBase_IsSeekable(PyObject *, PyObject *);}
static PyObject *meth_wxStreamBase_IsSeekable(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxStreamBase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxStreamBase, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsSeekable();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_StreamBase, sipName_IsSeekable, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxStreamBase_Reset, "Reset(error=STREAM_NO_ERROR) -> None\n"
"\n"
"Resets the stream state.");

extern "C" {static PyObject *meth_wxStreamBase_Reset(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxStreamBase_Reset(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxStreamError error = wxSTREAM_NO_ERROR;
        ::wxStreamBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_error,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|E", &sipSelf, sipType_wxStreamBase, &sipCpp, sipType_wxStreamError, &error))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Reset(error);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_StreamBase, sipName_Reset, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxStreamBase(void *, int);}
static void release_wxStreamBase(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxStreamBase *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxStreamBase(sipSimpleWrapper *);}
static void dealloc_wxStreamBase(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxStreamBase(sipGetAddress(sipSelf), 0);
    }
}


static PyMethodDef methods_wxStreamBase[] = {
    {sipName_GetLastError, meth_wxStreamBase_GetLastError, METH_VARARGS, doc_wxStreamBase_GetLastError},
    {sipName_GetLength, meth_wxStreamBase_GetLength, METH_VARARGS, doc_wxStreamBase_GetLength},
    {sipName_GetSize, meth_wxStreamBase_GetSize, METH_VARARGS, doc_wxStreamBase_GetSize},
    {sipName_IsOk, meth_wxStreamBase_IsOk, METH_VARARGS, doc_wxStreamBase_IsOk},
    {sipName_IsSeekable, meth_wxStreamBase_IsSeekable, METH_VARARGS, doc_wxStreamBase_IsSeekable},
    {sipName_Reset, SIP_MLMETH_CAST(meth_wxStreamBase_Reset), METH_VARARGS|METH_KEYWORDS, doc_wxStreamBase_Reset}
};

sipVariableDef variables_wxStreamBase[] = {
    {PropertyVariable, sipName_Size, &methods_wxStreamBase[2], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Length, &methods_wxStreamBase[1], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_LastError, &methods_wxStreamBase[0], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxStreamBase, "StreamBase() -> None\n"
"\n"
"This class is the base class of most stream related classes in\n"
"wxWidgets.");


sipClassTypeDef sipTypeDef__core_wxStreamBase = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_ABSTRACT|SIP_TYPE_CLASS,
        sipNameNr_wxStreamBase,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_StreamBase,
        {0, 0, 1},
        6, methods_wxStreamBase,
        0, SIP_NULLPTR,
        3, variables_wxStreamBase,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxStreamBase,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxStreamBase,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_wxStreamBase,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    0,
};
