/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.LargeObject;
import com.impossibl.postgres.jdbc.PGClob;
import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;

public class ClobWriter
extends Writer {
    PGClob owner;
    LargeObject lo;
    byte[] buf;
    int pos;

    public ClobWriter(PGClob owner, LargeObject lo) {
        this.owner = owner;
        this.lo = lo;
        this.pos = 0;
        this.buf = new byte[4096];
    }

    @Override
    public void write(int ch) throws IOException {
        if (this.pos >= this.buf.length) {
            this.writeNextRegion();
        }
        this.buf[this.pos++] = (byte)(ch >>> 24);
        this.buf[this.pos++] = (byte)(ch >>> 16);
        this.buf[this.pos++] = (byte)(ch >>> 8);
        this.buf[this.pos++] = (byte)(ch >>> 0);
    }

    @Override
    public void write(char[] chars) throws IOException {
        this.write(chars, 0, chars.length);
    }

    @Override
    public void write(char[] chars, int off, int len) throws IOException {
        for (int c = off; c < len; ++c) {
            this.write(chars[c]);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.pos > 0) {
            this.writeNextRegion();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.lo == null) {
            return;
        }
        this.flush();
        try {
            this.lo.close();
        }
        catch (SQLException e) {
            throw new IOException("Error closing stream", e);
        }
        if (this.owner != null) {
            this.owner.removeStream(this.lo);
        }
        this.owner = null;
        this.lo = null;
    }

    private void writeNextRegion() throws IOException {
        try {
            this.lo.write(this.buf, 0, this.pos);
            this.pos = 0;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }
}

