/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.datetime.instants.AmbiguousInstant;
import com.impossibl.postgres.datetime.instants.Instant;
import com.impossibl.postgres.datetime.instants.Instants;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.procs.BinaryDecoder;
import com.impossibl.postgres.system.procs.BinaryEncoder;
import com.impossibl.postgres.system.procs.SettingSelectProcProvider;
import com.impossibl.postgres.system.procs.TextDecoder;
import com.impossibl.postgres.system.procs.TextEncoder;
import com.impossibl.postgres.types.PrimitiveType;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;

public class TimesWithoutTZ
extends SettingSelectProcProvider {
    public TimesWithoutTZ() {
        super("field.datetime.format", Integer.class, new TxtEncoder(), new TxtDecoder(), new BinIntegerEncoder(), new BinIntegerDecoder(), null, null, new TxtEncoder(), new TxtDecoder(), "time_");
    }

    static class TxtEncoder
    extends TextEncoder {
        TxtEncoder() {
        }

        @Override
        public PrimitiveType getOutputPrimitiveType() {
            return PrimitiveType.Time;
        }

        @Override
        public Class<?> getInputType() {
            return Instant.class;
        }

        @Override
        protected void encode(Type type, StringBuilder buffer, Object val, Context context) throws IOException {
            String strVal = context.getTimeFormatter().getPrinter().format((Instant)val);
            buffer.append(strVal);
        }
    }

    static class TxtDecoder
    extends TextDecoder {
        TxtDecoder() {
        }

        @Override
        public PrimitiveType getInputPrimitiveType() {
            return PrimitiveType.Time;
        }

        @Override
        public Class<?> getOutputType() {
            return Instant.class;
        }

        @Override
        protected Object decode(Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Context context) throws IOException {
            HashMap<String, Object> pieces = new HashMap<String, Object>();
            context.getTimeFormatter().getParser().parse(buffer.toString(), 0, pieces);
            return Instants.timeFromPieces(pieces, context.getTimeZone()).ambiguate();
        }
    }

    static class BinIntegerEncoder
    extends BinaryEncoder {
        BinIntegerEncoder() {
        }

        @Override
        public Class<?> getInputType() {
            return Instant.class;
        }

        @Override
        public PrimitiveType getOutputPrimitiveType() {
            return PrimitiveType.Time;
        }

        @Override
        public void encode(Type type, ByteBuf buffer, Object val, Context context) throws IOException {
            if (val == null) {
                buffer.writeInt(-1);
            } else {
                Instant inst = (Instant)val;
                long micros = inst.getMicrosLocal() % TimeUnit.DAYS.toMicros(1L);
                buffer.writeInt(8);
                buffer.writeLong(micros);
            }
        }
    }

    static class BinIntegerDecoder
    extends BinaryDecoder {
        BinIntegerDecoder() {
        }

        @Override
        public PrimitiveType getInputPrimitiveType() {
            return PrimitiveType.Time;
        }

        @Override
        public Class<?> getOutputType() {
            return Instant.class;
        }

        @Override
        public Instant decode(Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Context context) throws IOException {
            int length = buffer.readInt();
            if (length == -1) {
                return null;
            }
            if (length != 8) {
                throw new IOException("invalid length");
            }
            long micros = buffer.readLong();
            return new AmbiguousInstant(Instant.Type.Time, micros);
        }
    }
}

