/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights;

import com.microsoft.applicationinsights.channel.TelemetryChannel;
import com.microsoft.applicationinsights.core.dependencies.googlecommon.base.Strings;
import com.microsoft.applicationinsights.extensibility.ContextInitializer;
import com.microsoft.applicationinsights.extensibility.TelemetryInitializer;
import com.microsoft.applicationinsights.extensibility.TelemetryModule;
import com.microsoft.applicationinsights.extensibility.TelemetryProcessor;
import com.microsoft.applicationinsights.internal.config.TelemetryConfigurationFactory;
import java.util.ArrayList;
import java.util.List;

public final class TelemetryConfiguration {
    private static final Object s_lock = new Object();
    private static volatile TelemetryConfiguration active;
    private String instrumentationKey;
    private final ArrayList<ContextInitializer> contextInitializers = new ArrayList();
    private final ArrayList<TelemetryInitializer> telemetryInitializers = new ArrayList();
    private final ArrayList<TelemetryModule> telemetryModules = new ArrayList();
    private final ArrayList<TelemetryProcessor> telemetryProcessors = new ArrayList();
    private TelemetryChannel channel;
    private boolean trackingIsDisabled = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TelemetryConfiguration getActive() {
        if (active == null) {
            Object object = s_lock;
            synchronized (object) {
                if (active == null) {
                    active = new TelemetryConfiguration();
                    TelemetryConfigurationFactory.INSTANCE.initialize(active);
                }
            }
        }
        return active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TelemetryConfiguration getActiveWithoutInitializingConfig() {
        if (active == null) {
            Object object = s_lock;
            synchronized (object) {
                if (active == null) {
                    active = new TelemetryConfiguration();
                }
            }
        }
        return active;
    }

    public static TelemetryConfiguration createDefault() {
        TelemetryConfiguration telemetryConfiguration = new TelemetryConfiguration();
        TelemetryConfigurationFactory.INSTANCE.initialize(telemetryConfiguration);
        return telemetryConfiguration;
    }

    public TelemetryChannel getChannel() {
        return this.channel;
    }

    public void setChannel(TelemetryChannel channel) {
        this.channel = channel;
    }

    public boolean isTrackingDisabled() {
        return this.trackingIsDisabled;
    }

    public void setTrackingIsDisabled(boolean disable) {
        this.trackingIsDisabled = disable;
    }

    public List<ContextInitializer> getContextInitializers() {
        return this.contextInitializers;
    }

    public List<TelemetryInitializer> getTelemetryInitializers() {
        return this.telemetryInitializers;
    }

    public List<TelemetryModule> getTelemetryModules() {
        return this.telemetryModules;
    }

    public List<TelemetryProcessor> getTelemetryProcessors() {
        return this.telemetryProcessors;
    }

    public String getInstrumentationKey() {
        return this.instrumentationKey;
    }

    public void setInstrumentationKey(String key) {
        if (Strings.isNullOrEmpty(key)) {
            throw new IllegalArgumentException("key");
        }
        this.instrumentationKey = key;
    }

    private static void setActiveAsNull() {
        active = null;
    }
}

