/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.quickpulse;

import com.microsoft.applicationinsights.core.dependencies.http.client.methods.HttpPost;
import com.microsoft.applicationinsights.core.dependencies.http.entity.ByteArrayEntity;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.quickpulse.QuickPulseDataCollector;
import com.microsoft.applicationinsights.internal.quickpulse.QuickPulseDataFetcher;
import com.microsoft.applicationinsights.internal.quickpulse.QuickPulseNetworkHelper;
import java.util.Date;
import java.util.concurrent.ArrayBlockingQueue;

final class DefaultQuickPulseDataFetcher
implements QuickPulseDataFetcher {
    private static final String QP_BASE_URI = "https://rt.services.visualstudio.com/QuickPulseService.svc/";
    private final String quickPulsePostUri;
    private final ArrayBlockingQueue<HttpPost> sendQueue;
    private final QuickPulseNetworkHelper networkHelper = new QuickPulseNetworkHelper();
    private String postPrefix;

    public DefaultQuickPulseDataFetcher(ArrayBlockingQueue<HttpPost> sendQueue, String ikey, String instanceName, String quickPulseId) {
        this.quickPulsePostUri = "https://rt.services.visualstudio.com/QuickPulseService.svc/post?ikey=" + ikey;
        this.sendQueue = sendQueue;
        StringBuilder sb = new StringBuilder();
        sb.append("[{");
        this.formatDocuments(sb);
        sb.append("\"Instance\": \"" + instanceName + "\",");
        sb.append("\"InstrumentationKey\": \"" + ikey + "\",");
        sb.append("\"InvariantVersion\": 2,");
        sb.append("\"MachineName\": \"" + instanceName + "\",");
        sb.append("\"StreamId\": \"" + quickPulseId + "\",");
        this.postPrefix = sb.toString();
    }

    @Override
    public void prepareQuickPulseDataForSend() {
        try {
            QuickPulseDataCollector.FinalCounters counters = QuickPulseDataCollector.INSTANCE.getAndRestart();
            Date currentDate = new Date();
            HttpPost request = this.networkHelper.buildRequest(currentDate, this.quickPulsePostUri);
            ByteArrayEntity postEntity = this.buildPostEntity(counters);
            request.setEntity(postEntity);
            if (!this.sendQueue.offer(request)) {
                InternalLogger.INSTANCE.trace("Quick Pulse send queue is full", new Object[0]);
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable e) {
            try {
                InternalLogger.INSTANCE.trace("Quick Pulse failed to prepare data for send", new Object[0]);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private ByteArrayEntity buildPostEntity(QuickPulseDataCollector.FinalCounters counters) {
        StringBuilder sb = new StringBuilder(this.postPrefix);
        this.formatMetrics(counters, sb);
        sb.append("\"Timestamp\": \"\\/Date(");
        long ms = System.currentTimeMillis();
        sb.append(ms);
        sb.append(")\\/\",");
        sb.append("\"Version\": \"2.2.0-738\"");
        sb.append("}]");
        ByteArrayEntity bae = new ByteArrayEntity(sb.toString().getBytes());
        return bae;
    }

    private void formatDocuments(StringBuilder sb) {
        sb.append("\"Documents\": [] ,");
    }

    private void formatSingleMetric(StringBuilder sb, String metricName, double metricValue, int metricWeight, Boolean includeComma) {
        String comma = includeComma != false ? "," : "";
        sb.append(String.format("{\"Name\": \"%s\",\"Value\": %s,\"Weight\": %s}%s", metricName, metricValue, metricWeight, comma));
    }

    private void formatSingleMetric(StringBuilder sb, String metricName, long metricValue, int metricWeight, Boolean includeComma) {
        String comma = includeComma != false ? "," : "";
        sb.append(String.format("{\"Name\": \"%s\",\"Value\": %s,\"Weight\": %s}%s", metricName, metricValue, metricWeight, comma));
    }

    private void formatSingleMetric(StringBuilder sb, String metricName, int metricValue, int metricWeight, Boolean includeComma) {
        String comma = includeComma != false ? "," : "";
        sb.append(String.format("{\"Name\": \"%s\",\"Value\": %s,\"Weight\": %s}%s", metricName, metricValue, metricWeight, comma));
    }

    private void formatMetrics(QuickPulseDataCollector.FinalCounters counters, StringBuilder sb) {
        sb.append("\"Metrics\":[");
        this.formatSingleMetric(sb, "\\\\ApplicationInsights\\\\Requests\\/Sec", counters.requests, 1, (Boolean)true);
        this.formatSingleMetric(sb, "\\\\ApplicationInsights\\\\Request Duration", counters.requestsDuration, 1, (Boolean)true);
        this.formatSingleMetric(sb, "\\\\ApplicationInsights\\\\Requests Failed\\/Sec", counters.unsuccessfulRequests, 1, (Boolean)true);
        this.formatSingleMetric(sb, "\\\\ApplicationInsights\\\\Requests Succeeded\\/Sec", counters.requests - counters.unsuccessfulRequests, 1, (Boolean)true);
        this.formatSingleMetric(sb, "\\\\ApplicationInsights\\\\Dependency Calls\\/Sec", counters.rdds, 1, (Boolean)true);
        this.formatSingleMetric(sb, "\\\\ApplicationInsights\\\\Dependency Call Duration", counters.rddsDuration, 1, (Boolean)true);
        this.formatSingleMetric(sb, "\\\\ApplicationInsights\\\\Dependency Calls Failed\\/Sec", counters.unsuccessfulRdds, 1, (Boolean)true);
        this.formatSingleMetric(sb, "\\\\ApplicationInsights\\\\Dependency Calls Succeeded\\/Sec", counters.rdds - counters.unsuccessfulRdds, 1, (Boolean)true);
        this.formatSingleMetric(sb, "\\\\ApplicationInsights\\\\Exceptions\\/Sec", counters.exceptions, 1, (Boolean)true);
        this.formatSingleMetric(sb, "\\\\Memory\\\\Committed Bytes", counters.memoryCommitted, 1, (Boolean)true);
        this.formatSingleMetric(sb, "\\\\Processor(_Total)\\\\% Processor Time", counters.cpuUsage, 1, (Boolean)false);
        sb.append("],");
    }
}

