/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.util;

import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class ThreadPoolUtils {
    public static ThreadPoolExecutor newLimitedThreadPool(int minNumberOfThreads, int maxNumberOfThreads, long defaultRemoveIdleThread, int bufferSize) {
        return new ThreadPoolExecutor(minNumberOfThreads, maxNumberOfThreads, defaultRemoveIdleThread, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(bufferSize));
    }

    public static void stop(ExecutorService executorService, long timeout, TimeUnit timeUnit) {
        if (executorService == null) {
            return;
        }
        executorService.shutdown();
        try {
            if (!executorService.awaitTermination(timeout, timeUnit)) {
                executorService.shutdownNow();
                if (!executorService.awaitTermination(timeout, timeUnit)) {
                    InternalLogger.INSTANCE.trace("Pool did not terminate", new Object[0]);
                }
            }
        }
        catch (InterruptedException ie) {
            executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public static ThreadFactory createDaemonThreadFactory(Class<?> clazz, int instanceId) {
        return ThreadPoolUtils.createNamedDaemonThreadFactory(String.format("%s_%d", clazz.getSimpleName(), instanceId));
    }

    public static ThreadFactory createDaemonThreadFactory(Class<?> clazz, String uniqueId) {
        return ThreadPoolUtils.createNamedDaemonThreadFactory(String.format("%s_%s", clazz.getSimpleName(), uniqueId));
    }

    public static ThreadFactory createDaemonThreadFactory(Class<?> clazz) {
        return ThreadPoolUtils.createNamedDaemonThreadFactory(clazz.getSimpleName());
    }

    public static ThreadFactory createNamedDaemonThreadFactory(final String poolName) {
        return new ThreadFactory(){
            private AtomicInteger threadId = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setName(String.format("%s-%d", poolName, this.threadId.getAndIncrement()));
                thread.setDaemon(true);
                return thread;
            }
        };
    }
}

