/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.telemetry;

import com.microsoft.applicationinsights.internal.schemav2.PageViewData;
import com.microsoft.applicationinsights.internal.util.Sanitizer;
import com.microsoft.applicationinsights.telemetry.BaseSampleSourceTelemetry;
import com.microsoft.applicationinsights.telemetry.Duration;
import java.net.URI;
import java.util.concurrent.ConcurrentMap;

public final class PageViewTelemetry
extends BaseSampleSourceTelemetry<PageViewData> {
    private Double samplingPercentage;
    private PageViewData data = new PageViewData();
    private static final String ENVELOPE_NAME = "PageView";
    private static final String BASE_TYPE = "PageViewData";

    public PageViewTelemetry() {
        this.initialize(this.data.getProperties());
    }

    public PageViewTelemetry(String pageName) {
        this();
        this.setName(pageName);
    }

    public void setName(String name) {
        this.data.setName(name);
    }

    public String getName() {
        return this.data.getName();
    }

    public URI getUri() {
        URI result = Sanitizer.safeStringToUri(this.data.getUrl());
        if (result == null) {
            this.data.setUrl(null);
        }
        return result;
    }

    public void setUrl(URI url) {
        this.data.setUrl(url == null ? null : url.toString());
    }

    public long getDuration() {
        return this.data.getDuration().getTotalMilliseconds();
    }

    public void setDuration(long duration) {
        this.data.setDuration(new Duration(duration));
    }

    public ConcurrentMap<String, Double> getMetrics() {
        return this.data.getMeasurements();
    }

    @Override
    public Double getSamplingPercentage() {
        return this.samplingPercentage;
    }

    @Override
    public void setSamplingPercentage(Double samplingPercentage) {
        this.samplingPercentage = samplingPercentage;
    }

    @Override
    @Deprecated
    protected void additionalSanitize() {
        this.data.setName(Sanitizer.sanitizeName(this.data.getName()));
        Sanitizer.sanitizeMeasurements(this.getMetrics());
        Sanitizer.sanitizeUri(this.data.getUrl());
    }

    @Override
    protected PageViewData getData() {
        return this.data;
    }

    @Override
    public String getEnvelopName() {
        return ENVELOPE_NAME;
    }

    @Override
    public String getBaseTypeName() {
        return BASE_TYPE;
    }
}

