/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.wellbehaved.event;

import java.util.Objects;
import java.util.function.Function;
import javafx.event.Event;
import org.fxmisc.wellbehaved.event.EventPattern;
import org.fxmisc.wellbehaved.event.InputHandler;
import org.fxmisc.wellbehaved.event.InputMap;

class PatternActionMap<T extends Event, U extends T>
implements InputMap<U> {
    static final Function<Object, InputHandler.Result> CONST_IGNORE = x -> InputHandler.Result.IGNORE;
    private final EventPattern<T, ? extends U> pattern;
    private final Function<? super U, InputHandler.Result> action;

    PatternActionMap(EventPattern<T, ? extends U> pattern, Function<? super U, InputHandler.Result> action) {
        this.pattern = pattern;
        this.action = action;
    }

    @Override
    public void forEachEventType(InputMap.HandlerConsumer<? super U> f) {
        InputHandler<Event> h2 = t -> this.pattern.match(t).map(this.action::apply).orElse(InputHandler.Result.PROCEED);
        this.pattern.getEventTypes().forEach(et -> f.accept(et, h2));
    }

    public boolean equals(Object other) {
        if (other instanceof PatternActionMap) {
            PatternActionMap that = (PatternActionMap)other;
            return Objects.equals(this.pattern, that.pattern) && Objects.equals(this.action, that.action);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.pattern, this.action);
    }
}

