/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.autocompleter;

import javafx.util.StringConverter;
import org.jabref.gui.autocompleter.AutoCompleteFirstNameMode;
import org.jabref.gui.autocompleter.AutoCompletePreferences;
import org.jabref.model.entry.Author;
import org.jabref.model.entry.AuthorList;

public class PersonNameStringConverter
extends StringConverter<Author> {
    private final boolean autoCompFF;
    private final boolean autoCompLF;
    private final AutoCompleteFirstNameMode autoCompleteFirstNameMode;

    public PersonNameStringConverter(boolean autoCompFF, boolean autoCompLF, AutoCompleteFirstNameMode autoCompleteFirstNameMode) {
        this.autoCompFF = autoCompFF;
        this.autoCompLF = autoCompLF;
        this.autoCompleteFirstNameMode = autoCompleteFirstNameMode;
    }

    public PersonNameStringConverter(AutoCompletePreferences preferences) {
        if (preferences.getOnlyCompleteFirstLast()) {
            this.autoCompFF = true;
            this.autoCompLF = false;
        } else if (preferences.getOnlyCompleteLastFirst()) {
            this.autoCompFF = false;
            this.autoCompLF = true;
        } else {
            this.autoCompFF = true;
            this.autoCompLF = true;
        }
        this.autoCompleteFirstNameMode = preferences.getFirstNameMode();
    }

    public String toString(Author author) {
        if (this.autoCompLF) {
            switch (this.autoCompleteFirstNameMode) {
                case ONLY_ABBREVIATED: {
                    return author.getLastFirst(true);
                }
                case ONLY_FULL: {
                    return author.getLastFirst(false);
                }
                case BOTH: {
                    return author.getLastFirst(true);
                }
            }
        }
        if (this.autoCompFF) {
            switch (this.autoCompleteFirstNameMode) {
                case ONLY_ABBREVIATED: {
                    return author.getFirstLast(true);
                }
                case ONLY_FULL: {
                    return author.getFirstLast(false);
                }
                case BOTH: {
                    return author.getFirstLast(true);
                }
            }
        }
        return author.getLastOnly();
    }

    public Author fromString(String string) {
        return AuthorList.parse(string).getAuthor(0);
    }
}

