/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import java.io.IOException;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.fxmisc.easybind.EasyBind;
import org.jabref.gui.DialogService;
import org.jabref.gui.autocompleter.AutoCompleteSuggestionProvider;
import org.jabref.gui.desktop.JabRefDesktop;
import org.jabref.gui.fieldeditors.AbstractEditorViewModel;
import org.jabref.gui.mergeentries.FetchAndMergeEntry;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.importer.WebFetchers;
import org.jabref.logic.importer.util.IdentifierParser;
import org.jabref.logic.integrity.FieldCheckers;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.FieldName;
import org.jabref.model.entry.identifier.Identifier;

public class IdentifierEditorViewModel
extends AbstractEditorViewModel {
    private BooleanProperty validIdentifierIsNotPresent = new SimpleBooleanProperty(true);
    private BooleanProperty identifierLookupInProgress = new SimpleBooleanProperty(false);
    private BooleanProperty idFetcherAvailable = new SimpleBooleanProperty(true);
    private ObjectProperty<Optional<? extends Identifier>> identifier = new SimpleObjectProperty();
    private TaskExecutor taskExecutor;
    private DialogService dialogService;

    public IdentifierEditorViewModel(String fieldName, AutoCompleteSuggestionProvider<?> suggestionProvider, TaskExecutor taskExecutor, DialogService dialogService, FieldCheckers fieldCheckers) {
        super(fieldName, suggestionProvider, fieldCheckers);
        this.taskExecutor = taskExecutor;
        this.dialogService = dialogService;
        this.identifier.bind(EasyBind.map(this.text, input -> IdentifierParser.parse(fieldName, input)));
        this.validIdentifierIsNotPresent.bind(EasyBind.map(this.identifier, parsedIdentifier -> !parsedIdentifier.isPresent()));
        this.idFetcherAvailable.setValue(Boolean.valueOf(WebFetchers.getIdFetcherForField(fieldName).isPresent()));
    }

    public boolean isIdFetcherAvailable() {
        return this.idFetcherAvailable.get();
    }

    public BooleanProperty idFetcherAvailableProperty() {
        return this.idFetcherAvailable;
    }

    public boolean getValidIdentifierIsNotPresent() {
        return this.validIdentifierIsNotPresent.get();
    }

    public BooleanProperty validIdentifierIsNotPresentProperty() {
        return this.validIdentifierIsNotPresent;
    }

    public void openExternalLink() {
        ((Optional)this.identifier.get()).flatMap(Identifier::getExternalURI).ifPresent(url -> {
            try {
                JabRefDesktop.openBrowser(url);
            }
            catch (IOException ex) {
                this.dialogService.showErrorDialogAndWait(Localization.lang("Unable to open link.", new String[0]), ex);
            }
        });
    }

    public boolean getIdentifierLookupInProgress() {
        return this.identifierLookupInProgress.get();
    }

    public BooleanProperty identifierLookupInProgressProperty() {
        return this.identifierLookupInProgress;
    }

    public FetchAndMergeEntry fetchInformationByIdentifier(BibEntry entry) {
        return new FetchAndMergeEntry(entry, this.fieldName);
    }

    public void lookupIdentifier(BibEntry entry) {
        WebFetchers.getIdFetcherForField(this.fieldName).ifPresent(idFetcher -> BackgroundTask.wrap(() -> idFetcher.findIdentifier(entry)).onRunning(() -> this.identifierLookupInProgress.setValue(Boolean.valueOf(true))).onFinished(() -> this.identifierLookupInProgress.setValue(Boolean.valueOf(false))).onSuccess(identifier -> {
            if (identifier.isPresent()) {
                entry.setField(this.fieldName, ((Identifier)identifier.get()).getNormalized());
            } else {
                this.dialogService.notify(Localization.lang("No %0 found", FieldName.getDisplayName(this.fieldName)));
            }
        }).onFailure(this.dialogService::showErrorDialogAndWait).executeWith(this.taskExecutor));
    }
}

