/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import javafx.beans.property.Property;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.TextInputControl;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import org.jabref.gui.autocompleter.AutoCompleteSuggestionProvider;
import org.jabref.gui.autocompleter.AutoCompletionTextInputBinding;
import org.jabref.gui.fieldeditors.EditorTextArea;
import org.jabref.gui.fieldeditors.EditorValidator;
import org.jabref.gui.fieldeditors.FieldEditorFX;
import org.jabref.gui.fieldeditors.PersonsEditorViewModel;
import org.jabref.gui.fieldeditors.contextmenu.EditorMenus;
import org.jabref.logic.integrity.FieldCheckers;
import org.jabref.model.entry.BibEntry;
import org.jabref.preferences.JabRefPreferences;

public class PersonsEditor
extends HBox
implements FieldEditorFX {
    @FXML
    private final PersonsEditorViewModel viewModel;

    public PersonsEditor(String fieldName, AutoCompleteSuggestionProvider<?> suggestionProvider, JabRefPreferences preferences, FieldCheckers fieldCheckers) {
        this.viewModel = new PersonsEditorViewModel(fieldName, suggestionProvider, preferences.getAutoCompletePreferences(), fieldCheckers);
        EditorTextArea textArea = new EditorTextArea();
        HBox.setHgrow((Node)textArea, (Priority)Priority.ALWAYS);
        textArea.textProperty().bindBidirectional((Property)this.viewModel.textProperty());
        textArea.addToContextMenu(EditorMenus.getNameMenu(textArea));
        this.getChildren().add((Object)textArea);
        AutoCompletionTextInputBinding.autoComplete((TextInputControl)textArea, this.viewModel::complete, this.viewModel.getAutoCompletionConverter(), this.viewModel.getAutoCompletionStrategy());
        new EditorValidator(preferences).configureValidation(this.viewModel.getFieldValidator().getValidationStatus(), textArea);
    }

    @Override
    public void bindToEntry(BibEntry entry) {
        this.viewModel.bindToEntry(entry);
    }

    @Override
    public Parent getNode() {
        return this;
    }
}

